/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.smartApproval;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.smartApproval.enums.AlgriModelNameEnum;
import kd.ssc.smartApproval.enums.BillFieldSourceDescEnum;
import kd.ssc.smartApproval.enums.BillFieldSourceEnum;
import kd.ssc.task.formplugin.util.DateUtil;

public class AlgorithmModelDetailPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(AlgorithmModelDetailPlugin.class);
    private static final String[] pieItemColors = new String[]{"#40A9FF", "#45DAD1", "#73D13D", "#FFC53D", "#FFA940", "#6682F5"};
    private static final String defaultShowFieldCacheKey = "default";
    private static final String relativityValueCacheKey = "value";
    private static final int curIndex = 0;
    private static final int lastIndex = 1;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"piechart"});
        this.fillResultInfo4BillList();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener(event -> {
            if ("subject".equals(event.getFieldName())) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("task_predict_parse");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setCustomParam("id", ((BillListHyperLinkClickEvent)event).getCurrentRow().getPrimaryKeyValue());
                this.getView().showForm(showParameter);
            }
        });
    }

    private void fillResultInfo4BillList() {
        String number = (String)this.getView().getFormShowParameter().getCustomParam("number");
        if (AlgriModelNameEnum.UNPASS.getNumber().equals(number)) {
            this.processBillInfo4UNPASS();
        } else if (AlgriModelNameEnum.BREAKRULE.getNumber().equals(number)) {
            this.processBillInfo4BREAKRULE();
        } else if (AlgriModelNameEnum.WITHDRAWAL.getNumber().equals(number)) {
            this.processBillInfo4WITHDRAWAL();
        } else if (AlgriModelNameEnum.OPERATION.getNumber().equals(number)) {
            this.processBillInfo4OPERATION();
        }
    }

    private void processBillInfo4UNPASS() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.getView().setVisible(Boolean.FALSE, new String[]{"breakrulepredictresult", "operationpredictresult", "withdrawalpredictresult"});
        billList.setFilterParameter(new FilterParameter(new QFilter("realpass", "in", (Object)new String[]{"0", "1"}), "predicttime desc"));
        billList.addBeforePackageDataListener(event -> {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"task_approval_result");
            ComboProp comboProp = (ComboProp)EntityTypeUtil.getFieldProp((String)"predictpass", (EntityType)entityType);
            Map<String, String> id2Name = comboProp.getComboItems().stream().collect(Collectors.toMap(ValueMapItem::getValue, e -> e.getName().toString()));
            for (DynamicObject row : event.getPageData()) {
                row.set("predictresultinfo", (Object)id2Name.get(row.getString("predictpass")));
            }
        });
    }

    private void processBillInfo4BREAKRULE() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.getView().setVisible(Boolean.FALSE, new String[]{"realpredictresult", "operationpredictresult", "withdrawalpredictresult"});
        billList.setFilterParameter(new FilterParameter(new QFilter("realpass", "=", (Object)"1"), "predicttime desc"));
        billList.addBeforePackageDataListener(event -> {
            DynamicObject[] breakRules = BusinessDataServiceHelper.load((String)"fircm_subscorerule", (String)"id,name", (QFilter[])new QFilter("name", "is not null", (Object)"").toArray());
            Map<String, String> id2Name = Arrays.stream(breakRules).collect(Collectors.toMap(e -> e.getString("id"), e -> e.getString("name")));
            String field = "breakrule";
            this.convertId2Name(field, id2Name, event.getPageData());
        });
    }

    private void processBillInfo4WITHDRAWAL() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.getView().setVisible(Boolean.FALSE, new String[]{"realpredictresult", "breakrulepredictresult", "operationpredictresult"});
        billList.setFilterParameter(new FilterParameter(new QFilter("realpass", "=", (Object)"0"), "predicttime desc"));
        billList.addBeforePackageDataListener(event -> {
            DynamicObject[] withdrawals = BusinessDataServiceHelper.load((String)"task_withdrawal", (String)"id,name", (QFilter[])new QFilter("name", "is not null", (Object)"").toArray());
            Map<String, String> id2Name = Arrays.stream(withdrawals).collect(Collectors.toMap(e -> e.getString("id"), e -> e.getString("name")));
            String field = "withdrawal";
            this.convertId2Name(field, id2Name, event.getPageData());
        });
    }

    private void processBillInfo4OPERATION() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.getView().setVisible(Boolean.FALSE, new String[]{"realpredictresult", "breakrulepredictresult", "withdrawalpredictresult"});
        billList.setFilterParameter(new FilterParameter(new QFilter("realpass", "=", (Object)"0"), "predicttime desc"));
        billList.addBeforePackageDataListener(event -> {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"task_approve");
            ComboProp comboProp = (ComboProp)EntityTypeUtil.getFieldProp((String)"decisionitem", (EntityType)entityType);
            Map<String, String> id2Name = comboProp.getComboItems().stream().collect(Collectors.toMap(ValueMapItem::getValue, e -> e.getName().toString()));
            String field = "operation";
            this.convertId2Name(field, id2Name, event.getPageData());
        });
    }

    private void convertId2Name(String field, Map<String, String> id2Name, DynamicObjectCollection pageData) {
        for (DynamicObject row : pageData) {
            String idStr = row.getString(field);
            if (!StringUtils.isNotEmpty((String)idStr) || idStr.length() <= 3) continue;
            try {
                String[] ids = idStr.substring(2, idStr.length() - 2).split("\",\"");
                StringBuilder nameStr = new StringBuilder();
                for (String id : ids) {
                    String name = id2Name.get(id);
                    if (name == null) continue;
                    nameStr.append(id2Name.get(id)).append('\uff0c');
                }
                if (nameStr.length() <= 0) continue;
                nameStr.deleteCharAt(nameStr.length() - 1);
                row.set("predictresultinfo", (Object)nameStr.toString());
            }
            catch (Exception e) {
                log.error(String.format("Error to parse %s field of task %s", field, row.getString("taskid")), (Throwable)e);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject[] top2ModelInfo;
        super.afterCreateNewData(e);
        String number = (String)this.getView().getFormShowParameter().getCustomParam("number");
        if (StringUtils.isEmpty((String)number)) {
            number = AlgriModelNameEnum.UNPASS.getNumber();
            this.getView().getFormShowParameter().setCustomParam("number", (Object)number);
        }
        if ((top2ModelInfo = this.loadModelIterationInfo(number)).length == 0) {
            return;
        }
        this.setIterationInfo(top2ModelInfo);
        this.fillResultInfo4BillList();
        DynamicObject curModelInfo = top2ModelInfo[0];
        AlgriModelNameEnum algriModelNameEnum = AlgriModelNameEnum.getByNumber((String)curModelInfo.getString("number"));
        if (algriModelNameEnum != null) {
            ((Label)this.getControl("titlelabel")).setText(algriModelNameEnum.getBridge().loadKDString());
        }
        this.drawPieChart4InfluenceFactor(curModelInfo);
        String field = this.getPageCache().get(defaultShowFieldCacheKey);
        if (StringUtils.isEmpty((String)field)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fielddetailfp"});
            return;
        }
        this.setFieldDescription(BillFieldSourceEnum.getBillFieldSourceName((String)field), BillFieldSourceDescEnum.getDescriptionByName((String)field));
        String value = curModelInfo.getString("newrecommend_tag");
        this.getPageCache().put(relativityValueCacheKey, value);
        this.drawBarChart4Relativity(field, value);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("piechart".equals(control.getKey())) {
            String factorName = ((ChartClickEvent)evt).getName();
            if (factorName == null) {
                return;
            }
            BillFieldSourceEnum field = BillFieldSourceEnum.getBillFieldSourceByName((String)factorName);
            if (field == null) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"fielddetailfp"});
                return;
            }
            this.setFieldDescription(factorName, BillFieldSourceDescEnum.getDescriptionByName((String)field.getFieldName()));
            this.drawBarChart4Relativity(field.getFieldName(), this.getPageCache().get(relativityValueCacheKey));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing && "config".equals(opKey = ((Donothing)source).getOperateKey())) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("task_mapping_setting");
            showParameter.getOpenStyle().setTargetKey("tabap");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    private void setFieldDescription(String fieldName, String description) {
        Label fieldLabel = (Label)this.getControl("fieldlabel");
        fieldLabel.setText(fieldName + "\uff1a");
        Label descLabel = (Label)this.getControl("desclabel");
        descLabel.setText(description);
        this.getView().setVisible(Boolean.TRUE, new String[]{"fielddetailfp"});
    }

    private void setIterationInfo(DynamicObject[] top2ModelInfo) {
        DynamicObject current = top2ModelInfo[0];
        ((Label)this.getControl("trainsizelabel")).setText(current.getBigDecimal("trainsize").setScale(0, 4).toString());
        ((Label)this.getControl("createtimelabel")).setText(DateUtil.format(current.getDate("createtime"), "yyyy.MM.dd HH:mm:ss"));
        if (top2ModelInfo.length == 2) {
            DynamicObject last = top2ModelInfo[1];
            BigDecimal compareValue = current.getBigDecimal("accuracy").subtract(last.getBigDecimal("accuracy")).multiply(new BigDecimal(100)).setScale(1, 4);
            String valueStr = compareValue.compareTo(BigDecimal.ZERO) >= 0 ? "+" + compareValue + "%" : compareValue + "%";
            ((Label)this.getControl("comparelabel")).setText(valueStr);
        }
        int accuracy = current.getBigDecimal("accuracy").multiply(new BigDecimal(100)).setScale(0, 4).intValue();
        this.drawPieChart4Accuracy(accuracy);
        String prompt = accuracy < 85 ? ResManager.loadKDString((String)"\u5f53\u524d\u7b97\u6cd5\u6a21\u578b\u6210\u719f\u5ea6\u8f83\u4f4e\uff0c\u5efa\u8bae\u589e\u52a0\u4efb\u52a1\u8bad\u7ec3\u91cf\uff0c\u63d0\u9ad8\u7b97\u6cd5\u51c6\u786e\u5ea6\u3002", (String)"AlgorithmModelDetailPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]) : (accuracy < 95 ? ResManager.loadKDString((String)"\u76ee\u524d\u7b97\u6cd5\u7684\u6210\u719f\u5ea6\u5df2\u7ecf\u8fbe\u5230\u4e00\u5b9a\u6c34\u5e73\uff0c\u8bf7\u8c28\u614e\u53c2\u8003\u7b97\u6cd5\u9884\u6d4b\u7684\u7ed3\u679c\u3002", (String)"AlgorithmModelDetailPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f53\u524d\u7b97\u6cd5\u9884\u6d4b\u7684\u51c6\u786e\u7387\u8f83\u9ad8\uff0c\u53ef\u4e3a\u5ba1\u6838\u7ed3\u679c\u63d0\u4f9b\u53c2\u8003\u3002", (String)"AlgorithmModelDetailPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        ((Label)this.getControl("promptlabel")).setText(prompt);
    }

    private void drawPieChart4Accuracy(int accuracy) {
        PieChart pieChart = (PieChart)this.getControl("piechart4acc");
        pieChart.clearData();
        pieChart.setShowTooltip(false);
        pieChart.setShowLegend(false);
        PieSeries series = pieChart.createPieSeries("");
        series.setPropValue("silent", (Object)Boolean.TRUE);
        ArrayList data = new ArrayList();
        HashMap<String, Object> item1 = new HashMap<String, Object>();
        item1.put(relativityValueCacheKey, accuracy);
        String valueColor = accuracy < 85 ? "#E65E67" : (accuracy < 95 ? "#1890FF" : "#73D13D");
        item1.put("itemStyle", Collections.singletonMap("normal", Collections.singletonMap("color", valueColor)));
        data.add(item1);
        HashMap<String, Object> item2 = new HashMap<String, Object>();
        item2.put(relativityValueCacheKey, 100 - accuracy);
        item2.put("itemStyle", Collections.singletonMap("normal", Collections.singletonMap("color", "#EDEDEE")));
        data.add(item2);
        series.setPropValue("data", data);
        HashMap<String, Object> labelMap = new HashMap<String, Object>();
        labelMap.put("show", Boolean.TRUE);
        labelMap.put("position", "center");
        labelMap.put("color", "#212121");
        labelMap.put("fontWeight", "#bold");
        labelMap.put("formatter", "{a|" + accuracy + "}{b|%}");
        HashMap richMap = new HashMap();
        HashMap<String, Object> aMap = new HashMap<String, Object>();
        aMap.put("color", "#212121");
        aMap.put("fontWeight", "bold");
        aMap.put("fontSize", 40);
        richMap.put("a", aMap);
        HashMap<String, Object> bMap = new HashMap<String, Object>();
        bMap.put("color", "#212121");
        bMap.put("fontWeight", "bold");
        bMap.put("fontSize", 20);
        richMap.put("b", bMap);
        labelMap.put("rich", richMap);
        series.setPropValue("label", labelMap);
        series.setRadius("56%", "76%");
    }

    private DynamicObject[] loadModelIterationInfo(String number) {
        return BusinessDataServiceHelper.load((String)"task_algri_mode", (String)"name,accuracy,trainsize,createtime,newrecommend_tag,influentity.influencefactor,influentity.factorinflurate", (QFilter[])new QFilter("number", "=", (Object)number).toArray(), (String)"createtime desc", (int)2);
    }

    private void drawBarChart4Relativity(String field, String value) {
        DynamicObject[] levels;
        Map<String, String> id2Name;
        Set idSet;
        Map valueMap;
        BarChart barchart = (BarChart)this.getControl("barchart");
        barchart.clearData();
        if (StringUtils.isEmpty((String)value)) {
            barchart.refresh();
            return;
        }
        try {
            valueMap = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
        }
        catch (Exception e3) {
            log.error("Error to parse recommend field", (Throwable)e3);
            return;
        }
        HashMap valueMapOfFiled = (HashMap)valueMap.get(field);
        if (valueMapOfFiled == null) {
            barchart.refresh();
            return;
        }
        List sortedValue = valueMapOfFiled.entrySet().stream().sorted((e1, e2) -> ((BigDecimal)e2.getValue()).compareTo((BigDecimal)e1.getValue())).collect(Collectors.toList());
        if (field.equals(BillFieldSourceEnum.fsscid.getFieldName()) || field.equals(BillFieldSourceEnum.forgid.getFieldName())) {
            idSet = sortedValue.stream().map(e -> Long.parseLong((String)e.getKey())).collect(Collectors.toSet());
            DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name", (QFilter[])new QFilter("id", "in", idSet).toArray());
            id2Name = Arrays.stream(orgs).collect(Collectors.toMap(e -> e.getString("id"), e -> e.getString("name")));
        } else if (field.equals(BillFieldSourceEnum.fbilltypeid.getFieldName())) {
            idSet = sortedValue.stream().map(e -> Long.parseLong((String)e.getKey())).collect(Collectors.toSet());
            DynamicObject[] billTypes = BusinessDataServiceHelper.load((String)"task_taskbill", (String)"id,name", (QFilter[])new QFilter("id", "in", idSet).toArray());
            id2Name = Arrays.stream(billTypes).collect(Collectors.toMap(e -> e.getString("id"), e -> e.getString("name")));
        } else if (field.equals(BillFieldSourceEnum.frecordtype.getFieldName())) {
            DynamicObject[] billEntities = BusinessDataServiceHelper.load((String)"bos_entityinfo", (String)"dentityid,name", (QFilter[])new QFilter("dentityid", "in", valueMapOfFiled.keySet()).toArray());
            id2Name = Arrays.stream(billEntities).collect(Collectors.toMap(e -> e.getString("dentityid"), e -> e.getString("name")));
        } else if (field.equals(BillFieldSourceEnum.fcreatorid.getFieldName()) || field.equals(BillFieldSourceEnum.fuser.getFieldName())) {
            idSet = sortedValue.stream().map(e -> Long.parseLong((String)e.getKey())).collect(Collectors.toSet());
            DynamicObject[] users = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,name", (QFilter[])new QFilter("id", "in", idSet).toArray());
            id2Name = Arrays.stream(users).collect(Collectors.toMap(e -> e.getString("id"), e -> e.getString("name")));
        } else if (field.equals(BillFieldSourceEnum.ffeetype.getFieldName())) {
            id2Name = new HashMap<String, String>();
        } else if (field.equals(BillFieldSourceEnum.fcreditlevel.getFieldName())) {
            idSet = sortedValue.stream().map(e -> Long.parseLong((String)e.getKey())).collect(Collectors.toSet());
            levels = BusinessDataServiceHelper.load((String)"task_creditlevel", (String)"id,name", (QFilter[])new QFilter("id", "in", idSet).toArray());
            id2Name = Arrays.stream(levels).collect(Collectors.toMap(e -> e.getString("id"), e -> e.getString("name")));
        } else if (field.equals(BillFieldSourceEnum.forgpatternid.getFieldName())) {
            idSet = sortedValue.stream().map(e -> Long.parseLong((String)e.getKey())).collect(Collectors.toSet());
            levels = BusinessDataServiceHelper.load((String)"bos_org_pattern", (String)"id,name", (QFilter[])new QFilter("id", "in", idSet).toArray());
            id2Name = Arrays.stream(levels).collect(Collectors.toMap(e -> e.getString("id"), e -> e.getString("name")));
        } else if (field.equals(BillFieldSourceEnum.fusertype.getFieldName())) {
            idSet = sortedValue.stream().map(e -> Long.parseLong((String)e.getKey())).collect(Collectors.toSet());
            DynamicObject[] types = BusinessDataServiceHelper.load((String)"bos_usertype", (String)"id,name", (QFilter[])new QFilter("id", "in", idSet).toArray());
            id2Name = Arrays.stream(types).collect(Collectors.toMap(e -> e.getString("id"), e -> e.getString("name")));
        } else if (field.equals(BillFieldSourceEnum.withdrawal.getFieldName())) {
            idSet = sortedValue.stream().map(e -> Long.parseLong((String)e.getKey())).collect(Collectors.toSet());
            DynamicObject[] withdrawals = BusinessDataServiceHelper.load((String)"task_withdrawal", (String)"id,name", (QFilter[])new QFilter("id", "in", idSet).toArray());
            id2Name = Arrays.stream(withdrawals).collect(Collectors.toMap(e -> e.getString("id"), e -> e.getString("name")));
        } else if (field.equals(BillFieldSourceEnum.breakrule.getFieldName())) {
            idSet = sortedValue.stream().map(e -> Long.parseLong((String)e.getKey())).collect(Collectors.toSet());
            DynamicObject[] rules = BusinessDataServiceHelper.load((String)"fircm_subscorerule", (String)"id,name", (QFilter[])new QFilter("id", "in", idSet).toArray());
            id2Name = Arrays.stream(rules).collect(Collectors.toMap(e -> e.getString("id"), e -> e.getString("name")));
        } else if (field.equals(BillFieldSourceEnum.operation.getFieldName())) {
            id2Name = this.getComboPropMap("task_approve", "decisionitem");
        } else if (field.equals(BillFieldSourceEnum.fstate.getFieldName())) {
            id2Name = this.getComboPropMap("task_taskhistory", "state");
        } else {
            barchart.refresh();
            return;
        }
        int size = 5;
        int count = 0;
        ArrayList<String> xAxisNames = new ArrayList<String>(size);
        ArrayList<BigDecimal> data = new ArrayList<BigDecimal>(size);
        for (Map.Entry entry : sortedValue) {
            String name = id2Name.getOrDefault(entry.getKey(), (String)entry.getKey());
            xAxisNames.add(name);
            data.add(((BigDecimal)entry.getValue()).multiply(new BigDecimal(100)));
            if (++count != size) continue;
            break;
        }
        barchart.setMargin(Position.top, "18%");
        barchart.setShowTooltip(true);
        barchart.addTooltip("formatter", (Object)"{b}\uff1a{c}");
        BarSeries barSeries = barchart.createSeries(null);
        barSeries.setColor("#40A9FF");
        barSeries.setBarWidth("24");
        barSeries.setPropValue("label", Collections.singletonMap("show", Boolean.FALSE));
        barSeries.setPropValue("data", data);
        Axis xAxis = barchart.createXAxis(null, AxisType.category);
        xAxis.setPropValue("axisTick", Collections.singletonMap("show", Boolean.FALSE));
        xAxis.setPropValue("data", xAxisNames);
        Axis yAxis1 = barchart.createYAxis(ResManager.loadKDString((String)"\u76f8\u5173\u6027", (String)"AlgorithmModelDetailPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), AxisType.value);
        yAxis1.setPropValue("splitNumber", (Object)4);
        yAxis1.setPropValue("axisTick", Collections.singletonMap("show", Boolean.FALSE));
        barchart.refresh();
    }

    private Map<String, String> getComboPropMap(String entity, String prop) {
        HashMap<String, String> value2Name = new HashMap<String, String>(8);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        ComboProp comboProp = (ComboProp)EntityTypeUtil.getFieldProp((String)prop, (EntityType)entityType);
        for (ValueMapItem comboItem : comboProp.getComboItems()) {
            value2Name.put(comboItem.getValue(), comboItem.getName().getLocaleValue());
        }
        return value2Name;
    }

    private List<PieItem> packPieItem(DynamicObject modelInfo) {
        DynamicObjectCollection factors = modelInfo.getDynamicObjectCollection("influentity");
        if (factors.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, BigDecimal> factorMap = new HashMap<String, BigDecimal>();
        for (DynamicObject factor : factors) {
            BigDecimal old;
            String key = factor.getString("influencefactor");
            BigDecimal value = factor.getBigDecimal("factorinflurate");
            if (key.endsWith("_month")) {
                old = (BigDecimal)factorMap.get(key = key.substring(0, key.length() - 6));
                factorMap.put(key, old != null && old.compareTo(value) > 0 ? old : value);
                continue;
            }
            if (key.endsWith("_day")) {
                old = (BigDecimal)factorMap.get(key = key.substring(0, key.length() - 4));
                factorMap.put(key, old != null && old.compareTo(value) > 0 ? old : value);
                continue;
            }
            factorMap.put(key, value);
        }
        Stream sortedFactor = factorMap.entrySet().stream().sorted((e1, e2) -> ((BigDecimal)e2.getValue()).compareTo((BigDecimal)e1.getValue())).limit(6L);
        ArrayList<PieItem> itemList = new ArrayList<PieItem>(6);
        sortedFactor.forEach(e -> {
            BigDecimal v = ((BigDecimal)e.getValue()).multiply(new BigDecimal(100)).setScale(0, 4);
            itemList.add(new PieItem((String)e.getKey(), BillFieldSourceEnum.getBillFieldSourceName((String)((String)e.getKey())), v));
        });
        this.getPageCache().put(defaultShowFieldCacheKey, ((PieItem)itemList.get(0)).field);
        return itemList;
    }

    private void drawPieChart4InfluenceFactor(DynamicObject modelInfo) {
        List<PieItem> pieItems = this.packPieItem(modelInfo);
        if (pieItems.isEmpty()) {
            return;
        }
        PieChart pieChart = (PieChart)this.getControl("piechart");
        pieChart.clearData();
        pieChart.setShowTooltip(true);
        pieChart.setShowLegend(true);
        pieChart.setLegendPropValue("x", (Object)"left");
        pieChart.setLegendPropValue("y", (Object)"bottom");
        pieChart.setLegendPropValue("itemHeight", (Object)10);
        pieChart.setLegendPropValue("icon", (Object)"circle");
        pieChart.setLegendPropValue("itemWidth", (Object)16);
        pieChart.setLegendPropValue("itemGap", (Object)16);
        pieChart.setLegendPropValue("selectedMode", (Object)Boolean.FALSE);
        HashMap<String, Object> legendTextStyle = new HashMap<String, Object>();
        legendTextStyle.put("fontSize", 12);
        legendTextStyle.put("color", "#666");
        pieChart.setLegendPropValue("textStyle", legendTextStyle);
        this.buildSeries(pieChart, pieItems);
    }

    private void buildSeries(PieChart pieChart, List<PieItem> pieItems) {
        PieSeries series = pieChart.createPieSeries("factorPie");
        ArrayList data = new ArrayList();
        for (int i = 0; i < pieItems.size(); ++i) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            PieItem pieItem = pieItems.get(i);
            item.put("name", pieItem.getName());
            item.put(relativityValueCacheKey, pieItem.getValue());
            item.put("field", pieItem.getField());
            Map<String, Map<String, String>> style = Collections.singletonMap("normal", Collections.singletonMap("color", pieItemColors[i]));
            item.put("itemStyle", style);
            data.add(item);
        }
        series.setPropValue("data", data);
        series.setPropValue("label", Collections.singletonMap("show", Boolean.FALSE));
        series.setPropValue("minAngle", (Object)3);
        series.setPropValue("tooltip", Collections.singletonMap("formatter", "function(d) {return d.name + '\uff1a' + d.value + '\uff08' + d.percent + '%\uff09<br />click for detail';}"));
        ArrayList<String> tooltipFuncPath = new ArrayList<String>();
        tooltipFuncPath.add("tooltip");
        tooltipFuncPath.add("formatter");
        series.addFuncPath(tooltipFuncPath);
        series.setRadius("64%");
        Object[] position = new Object[]{"44%", "38%"};
        series.setPropValue("center", (Object)position);
    }

    private static class PieItem {
        private String field;
        private String name;
        private BigDecimal value;

        public PieItem(String field, String name, BigDecimal value) {
            this.field = field;
            this.name = name;
            this.value = value;
        }

        public String getField() {
            return this.field;
        }

        public String getName() {
            return this.name;
        }

        public BigDecimal getValue() {
            return this.value;
        }
    }
}

