/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.smartApproval;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.ssc.enums.TaskApprovePageInvokerEnum;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.smartApproval.enums.AIRiskLevel;
import kd.ssc.smartApproval.enums.IsPassEnum;
import kd.ssc.smartApproval.pojo.AIGeneralResult;
import kd.ssc.smartApproval.pojo.IDISchemaResult;
import kd.ssc.smartApproval.pojo.SmartApprovalPredictedResult;
import kd.ssc.smartApproval.predict.TaskApprovalForecast;
import kd.ssc.smartApproval.util.TaskDataUploadHelper;
import kd.ssc.task.dto.approve.DecisionResult;
import kd.ssc.task.formplugin.TaskApprevalHelper;
import kd.ssc.task.formplugin.smartApproval.AIGeneralResultParser;
import kd.ssc.task.formplugin.smartApproval.PredictedDataHelper;
import kd.ssc.task.formplugin.smartApproval.fgptas.AttachmentReviewPlugin;
import kd.ssc.task.formplugin.util.WithdrawalSelectorUtil;
import kd.ssc.task.helper.TaskBillChildQueryServiceHelper;
import kd.ssc.task.service.approve.impl.IntelligentDecisionServiceImpl;
import kd.ssc.task.util.SSCBosUtil;
import org.apache.commons.lang3.math.NumberUtils;

public class TaskSmartApprovalShowResultPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(TaskSmartApprovalShowResultPlugin.class);
    private static final String FLEX_TITLE = "flex_smartaudit_1";
    private static final String KEY_XIAOK = "littlekap";
    private static final String KEY_LABEL = "labelap";
    private static final String KEY_EMPLOYEE = "employeeimage";
    private static final String KEY_EMPLOYEE_NAME = "employeename";
    private static final String BTN_NODATA = "/icons/pc/state/notdelay_notstart.png";
    private static final String FLEX_BUTTON_GROUP = "ai_buttongroup";
    private static final String LABEL_EQU = "labelequal";
    private static final String LABEL_ADD = "labeladd";
    private static final String BTN_GENERAL = "general";
    public static final String BTN_IDI = "idi";
    private static final String BTN_PREDICT = "predict";
    private static final String BTN_FILE_ANALYSIS = "fileanalysis";
    private static final Set<String> BTN_GROUP = new HashSet<String>(Arrays.asList("general", "idi", "predict", "fileanalysis"));
    public static final String FLEX_PREFIX = "flex_";
    public static final String FLEX_GENERAL = "flex_general";
    public static final String FLEX_IDI = "flex_idi";
    public static final String FLEX_PREDICT = "flex_predict";
    public static final String FLEX_FILE = "flex_fileanalysis";
    private static final String KEY_RISK_ICON = "risk_icon";
    private static final String KEY_RISK_LABEL = "risk_label";
    private static final String KEY_PREDICT_TEXT = "predict_text";
    private static final String KEY_FACTOR_TEXT = "factor_text";
    private static final String KEY_FACTOR_ENTRY = "factoryentry";
    private static final String KEY_FACTOR_ENTRY_ICON = "factorentryicon";
    private static final String KEY_FACTOR_ENTRY_ICON_GREEN = "/icons/pc/state/green_6_6.png";
    private static final String KEY_FACTOR_ENTRY_ICON_RED = "/icons/pc/state/red_6_6.png";
    private static final String KEY_FACTOR_ENTRY_TEXT = "factorentrytext";
    private static final String KEY_MORE = "more";
    private static final String KEY_SIMILAR_TASK = "smtaudit_title";
    private static final String FLEX_SIMILAR_TASK = "flexpanelap6";
    private static final String CONTAINER_AUDIT = "auditsplitcontainer";
    private static final String CACHE_OPEN = "opened";
    public static final String CACHE_CHECKED = "checked";
    public static final String CACHE_LAST_CHECKED = "last_checked";
    private static final String SB_PREFIX = "similarbill_";
    private static final String SB_SUFFIX = "_taskid";
    private static final String LABEL_SMTAUDIT_OK = "label_smtaudit_ok";
    private static final String LABEL_SMTAUDIT_NO = "label_smtaudit_no";
    private static final String LABEL_SMTAUDIT_NULL = "label_smtaudit_null";
    private Long taskId = 0L;
    private Long sourceTaskId = 0L;
    private TaskPoolTypeEnum poolType;
    private long taskTypeId;
    private long billTypeId;
    private boolean isEnableSmart = false;
    private boolean isEnableSchema = false;
    private boolean isAttachmentReview = false;
    private SmartApprovalPredictedResult predictResult;
    private IDISchemaResult schemaResult;
    private AIGeneralResult aiGeneralResult;
    private final Map<Long, String> taskSubjectMap = new HashMap<Long, String>(5);
    private static final String REFRESH_KEY = "image_smartaudit_f5";

    public void initialize() {
        FormShowParameter showParam = this.getView().getFormShowParameter();
        this.taskId = (Long)showParam.getCustomParam("taskid");
        this.poolType = TaskPoolTypeEnum.getTaskPoolType((String)((String)showParam.getCustomParam("pooltype")));
        this.taskTypeId = NumberUtils.toLong((String)(showParam.getCustomParam("tasktypeid") + ""));
        this.billTypeId = NumberUtils.toLong((String)(showParam.getCustomParam("billtypeid") + ""));
        if (this.isCompletedTask()) {
            this.sourceTaskId = (Long)showParam.getCustomParam("sourcetaskid");
        }
        this.isEnableSmart = StringUtils.equals((CharSequence)"true", (CharSequence)SSCBosUtil.getCtrlParam((String)"isEnableSmartApproval"));
        List idiSchemaList = TaskBillChildQueryServiceHelper.listTaskBillChildIdiSchema((Long)this.billTypeId, (Long)this.taskTypeId);
        this.isEnableSchema = idiSchemaList != null && !idiSchemaList.isEmpty();
        log.info(String.format("\u8be5\u4efb\u52a1%s\u5df2\u914d\u7f6e\u4e86\u6570\u636e\u6d1e\u5bdf:%s\uff0c\u5df2\u5f00\u542f\u667a\u80fd\u5ba1\u6838\u52a9\u624b:%s\u3002", this.taskId, this.isEnableSchema, this.isEnableSmart));
        if (this.isEnableSchema) {
            this.schemaResult = IDISchemaResult.getSchemaResult((Long)this.getTaskIdDB());
        }
        if (this.schemaResult == null) {
            this.schemaResult = new IDISchemaResult(this.getTaskIdDB().longValue());
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_GENERAL, BTN_IDI, BTN_PREDICT, BTN_FILE_ANALYSIS, KEY_MORE, REFRESH_KEY, "similarbill_1", "similarbill_2", "similarbill_3"});
    }

    public void afterCreateNewData(EventObject e) {
        boolean enableRefresh;
        log.info(String.format("show smart approval predict result. taskId = %s, sourceTaskId = %s, poolType = %s, isEnableSmart = %s", this.taskId, this.sourceTaskId, this.poolType.getValue(), this.isEnableSmart));
        List idiSchemaList = TaskBillChildQueryServiceHelper.listTaskBillChildIdiSchema((Long)this.billTypeId, (Long)this.taskTypeId);
        this.changeIsEnableSchema(idiSchemaList);
        log.info(String.format("\u8be5\u4efb\u52a1%s\u5df2\u914d\u7f6e\u4e86\u6570\u636e\u6d1e\u5bdf:%s\uff0c\u5df2\u5f00\u542f\u667a\u80fd\u5ba1\u6838\u52a9\u624b:%s\u3002", this.taskId, this.isEnableSchema, this.isEnableSmart));
        boolean bl = enableRefresh = !"true".equals(TaskDataUploadHelper.getSettingInfo((String)"disableOpenRefresh")) && !this.isCompletedTask();
        if (this.callDecision(idiSchemaList, enableRefresh)) {
            this.predictTask();
        }
        this.comeBineResult();
        this.isAttachmentReview = StringUtils.equals((CharSequence)"true", (CharSequence)this.getPageCache().get("CACHE_ENABLE_REVIEW"));
        if (!(this.isEnableSmart || this.isEnableSchema || this.isAttachmentReview)) {
            log.info("\u6ca1\u5f00\u542f\u667a\u80fd\u76f8\u5173\u7279\u6027\uff0c\u5173\u95ed\u667a\u80fd\u5ba1\u6279");
            SplitContainer auditContainer = (SplitContainer)this.getControl(CONTAINER_AUDIT);
            auditContainer.hidePanel(SplitDirection.up, true);
            return;
        }
        if (Objects.isNull(this.aiGeneralResult)) {
            this.comeBineResult();
        }
        this.updateTitleFlex();
        String checked = this.updateButtonFlex();
        if (StringUtils.isNotBlank((CharSequence)checked)) {
            this.getPageCache().put(CACHE_CHECKED, checked);
        }
        this.updateContentFlex();
        this.updateSimilarTask();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        String checked = this.getPageCache().get(CACHE_CHECKED);
        if (checked != null) {
            FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            String key = checked;
            List plugIns = pluginProxy.getPlugIns();
            List<Class> list = Arrays.asList(TaskSmartApprovalShowResultPlugin.class, AttachmentReviewPlugin.class);
            plugIns.stream().filter(p -> list.contains(p.getClass())).forEach(p -> ((AbstractFormPlugin)p).addClickListeners(new String[]{key}));
            ((Button)this.getView().getControl(key)).click();
        }
    }

    private boolean callDecision(List<String> idiSchemaList, boolean enableRefresh) {
        this.changeIsEnableSchema(idiSchemaList);
        if (!this.isEnableSchema) {
            return false;
        }
        boolean isDiff = false;
        if (enableRefresh) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String billId = formShowParameter.getCustomParam("billid") + "";
            String billNumber = (String)formShowParameter.getCustomParam("billnumber");
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billNumber);
            IntelligentDecisionServiceImpl decisionService = new IntelligentDecisionServiceImpl();
            DecisionResult result = decisionService.decisionAnalysis(this.taskId, "", bill, idiSchemaList);
            IDISchemaResult newSchemaResult = new IDISchemaResult(this.getTaskIdDB().longValue());
            newSchemaResult.setBy(result);
            if (!this.schemaResult.equals((Object)newSchemaResult)) {
                log.info(String.format("\u6d1e\u5bdf\u7ed3\u679c\u53d1\u751f\u4e86\u53d8\u5316[ %s ]->[ %s ]\uff0c\u9700\u8981\u91cd\u65b0\u4fdd\u5b58\u6d1e\u5bdf\u7ed3\u679c\u3001\u9884\u6d4b\u3002", this.schemaResult, newSchemaResult));
                this.schemaResult = newSchemaResult;
                this.schemaResult.save();
                isDiff = true;
            }
        }
        return isDiff;
    }

    private void queryPredictResultByDB() {
        if (this.isEnableSmart) {
            try {
                this.predictResult = PredictedDataHelper.getPredictedDataByTask(this.getTaskIdDB());
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u5ba1\u6838\u9884\u6d4b\u7ed3\u679c\u89e3\u6790\u62a5\u9519\uff1a%s", (String)"TaskSmartApprovalShowResultPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), ex.getMessage()));
                log.error("\u4efb\u52a1\u5ba1\u6838\u9884\u6d4b\u7ed3\u679c\u89e3\u6790\u62a5\u9519 ", (Throwable)ex);
                this.predictResult = new SmartApprovalPredictedResult();
            }
        }
    }

    private void comeBineResult() {
        this.queryPredictResultByDB();
        this.aiGeneralResult = new AIGeneralResult(this.getTaskIdDB().longValue(), this.schemaResult, this.predictResult);
        this.parsePredictResult();
    }

    private void waitAnimation(long start) {
        long wait = 500L - (System.currentTimeMillis() - start);
        if (wait > 0L) {
            try {
                Thread.sleep(wait);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void updateTitleFlex() {
        String titleLabel = "";
        if (this.isEnableSmart) {
            titleLabel = !this.aiGeneralResult.predictSuccess() ? LABEL_SMTAUDIT_NULL : (this.aiGeneralResult.isPass() != false ? LABEL_SMTAUDIT_OK : LABEL_SMTAUDIT_NO);
            this.setResultLabelVisble(titleLabel);
            this.getView().setEnable(Boolean.valueOf(!this.isCompletedTask()), new String[]{REFRESH_KEY});
        } else if (this.isEnableSchema) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_XIAOK, KEY_EMPLOYEE, KEY_EMPLOYEE_NAME});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_LABEL});
            Label label = (Label)this.getControl(KEY_LABEL);
            label.setText(ResManager.loadKDString((String)"\u667a\u80fd\u6d1e\u5bdf\uff1a", (String)"TaskSmartApprovalShowResultPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            if (this.schemaResult.isPass() != null) {
                titleLabel = this.schemaResult.isPass() != false ? LABEL_SMTAUDIT_OK : LABEL_SMTAUDIT_NO;
            }
            this.setResultLabelVisble(titleLabel);
            this.getView().setEnable(Boolean.valueOf(!this.isCompletedTask()), new String[]{REFRESH_KEY});
        } else if (this.isAttachmentReview) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_XIAOK, KEY_EMPLOYEE, KEY_EMPLOYEE_NAME, REFRESH_KEY});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_LABEL});
            Label label = (Label)this.getControl(KEY_LABEL);
            label.setText(ResManager.loadKDString((String)"\u9644\u4ef6\u5ba1\u6838\uff1a", (String)"TaskSmartApprovalShowResultPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.setResultLabelVisble("");
        }
        if (this.isEnableSchema) {
            this.updateEmployeeInfo("znsjdc");
        } else if (this.isEnableSmart) {
            this.updateEmployeeInfo("znshzs");
        }
    }

    private String updateButtonFlex() {
        String checked = null;
        if (this.isAttachmentReview) {
            checked = BTN_FILE_ANALYSIS;
        }
        boolean showButtonGroup = this.isEnableSchema == this.isEnableSmart ? this.isEnableSmart : this.isAttachmentReview;
        this.getView().setVisible(Boolean.valueOf(showButtonGroup), new String[]{FLEX_BUTTON_GROUP});
        if (!showButtonGroup) {
            return checked;
        }
        ArrayList<String> invisible = new ArrayList<String>();
        invisible.add(LABEL_EQU);
        invisible.add(LABEL_ADD);
        invisible.add(BTN_PREDICT);
        invisible.add(BTN_GENERAL);
        invisible.add(BTN_IDI);
        if (this.isEnableSchema) {
            invisible.remove(BTN_IDI);
            checked = BTN_IDI;
            Button idi = (Button)this.getControl(BTN_IDI);
            idi.setUrl(this.schemaResult.isPass() != null ? this.schemaResult.getSchemaPass().getImageKey() : BTN_NODATA);
        }
        if (this.isEnableSmart) {
            invisible.remove(BTN_GENERAL);
            Button predict = (Button)this.getControl(BTN_PREDICT);
            if (this.aiGeneralResult.predictSuccess()) {
                checked = BTN_GENERAL;
                predict.setUrl(this.predictResult.getIsPass().getImageKey());
                this.getView().setEnable(Boolean.TRUE, new String[]{BTN_GENERAL, BTN_PREDICT});
                this.updateSimilarTask();
            } else {
                predict.setUrl(BTN_NODATA);
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_GENERAL, BTN_PREDICT});
            }
        }
        if (this.isEnableSchema && this.isEnableSmart) {
            invisible.remove(BTN_PREDICT);
            invisible.remove(LABEL_EQU);
            invisible.remove(LABEL_ADD);
        }
        this.getView().setVisible(Boolean.FALSE, invisible.toArray(new String[0]));
        return checked;
    }

    private void updateContentFlex() {
        if (this.isEnableSmart && this.aiGeneralResult.predictSuccess()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_GENERAL});
            AIRiskLevel aiRiskLevel = this.aiGeneralResult.getAiRiskLevel();
            if (aiRiskLevel != null) {
                Image riskIcon = (Image)this.getControl(KEY_RISK_ICON);
                riskIcon.setUrl(aiRiskLevel.getBackgroundImgKey());
                Label riskLabel = (Label)this.getControl(KEY_RISK_LABEL);
                riskLabel.setText(aiRiskLevel.getText());
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("fc", aiRiskLevel.getColor());
                this.getView().updateControlMetadata(KEY_RISK_LABEL, properties);
            }
            String predictText = AIGeneralResultParser.createPredictText(this.aiGeneralResult);
            Label factorText = (Label)this.getControl(KEY_FACTOR_TEXT);
            int factorSize = this.loadFactors(this.predictResult.isPass(), !this.isEnableSchema);
            if (!this.isEnableSchema) {
                predictText = String.format(ResManager.loadKDString((String)"\u57fa\u4e8eAI\u673a\u5668\u5b66\u4e60+\u89c4\u5219\u5f15\u64ce+\u5927\u6570\u636e\u6316\u6398\u6280\u672f\uff0c%s", (String)"AIGeneralResultParser_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u7ed3\u5408\u5386\u53f2\u76f8\u4f3c\u5355\u636e\u5206\u6790\u5f97\u51fa\u672c\u5355\u636e\u4e3a%1$s\u5355\u636e\uff0c\u5efa\u8bae\u5ba1\u6279\u7ed3\u679c\u4e3a\uff1a%2$s\u3002\u5177\u4f53\u5f71\u54cd\u56e0\u7d20\u5982\u4e0b\uff1a", (String)"AIGeneralResultParser_6", (String)"ssc-task-formplugin", (Object[])new Object[0]) + "\n\n", this.aiGeneralResult.getAiRiskLevel().getText(), this.aiGeneralResult.getIsPassEnum().getText()));
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_IDI, FLEX_PREDICT});
            } else if (factorSize != 0) {
                String showText = String.format(ResManager.loadKDString((String)"\u5f71\u54cd\u672c\u6b21\u9884\u5ba1\u7ed3\u679c\u7684%s\u56e0\u7d20\u4e3a\uff1a", (String)"TaskSmartApprovalShowResultPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]), "Top" + factorSize) + "\n\n";
                factorText.setText(showText);
            }
            Label predictTextLabel = (Label)this.getControl(KEY_PREDICT_TEXT);
            predictTextLabel.setText(predictText);
        } else if (this.isEnableSchema) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_GENERAL, FLEX_PREDICT});
            this.getPageCache().put(CACHE_CHECKED, BTN_IDI);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_GENERAL, FLEX_PREDICT, FLEX_IDI, FLEX_FILE});
        }
    }

    private int loadFactors(boolean predictPass, boolean isGeneralFlex) {
        Map<String, Object> top5AffectFactors = AIGeneralResultParser.getTop5AffectFactors(this.aiGeneralResult.getTaskId());
        List textList = (List)top5AffectFactors.get("text");
        if (textList.isEmpty()) {
            log.info("\u65e0\u9884\u6d4b\u56e0\u7d20\u53ef\u52a0\u8f7d\u3002");
            return 0;
        }
        String suffix = isGeneralFlex ? "" : "1";
        String keyEntry = KEY_FACTOR_ENTRY + suffix;
        String keyIcon = KEY_FACTOR_ENTRY_ICON + suffix;
        String keyText = KEY_FACTOR_ENTRY_TEXT + suffix;
        Image icon = (Image)this.getControl(keyIcon);
        icon.setUrl(predictPass ? KEY_FACTOR_ENTRY_ICON_GREEN : KEY_FACTOR_ENTRY_ICON_RED);
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        tvs.addField(keyText, textList.toArray());
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.deleteEntryData(keyEntry);
        model.batchCreateNewEntryRow(keyEntry, tvs);
        model.endInit();
        this.getView().updateView(keyEntry);
        return textList.size();
    }

    private void updateSimilarTask() {
        if (!this.isEnableSmart) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SIMILAR_TASK, FLEX_SIMILAR_TASK});
            return;
        }
        if (CollectionUtils.isEmpty(this.taskSubjectMap)) {
            log.info(String.format("taskSubjectMap is empty. taskId = %s, poolType = %s", this.taskId, this.poolType));
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SIMILAR_TASK, FLEX_SIMILAR_TASK});
        }
        for (int i = 1; i <= 3; ++i) {
            Long similarBillId = Long.parseLong(this.getModel().getValue(SB_PREFIX + i + SB_SUFFIX) + "");
            if (similarBillId != 0L) {
                ((Label)this.getControl(SB_PREFIX + i)).setText(this.taskSubjectMap.get(similarBillId));
                continue;
            }
            ((Label)this.getControl(SB_PREFIX + i)).setText("");
        }
    }

    private boolean updateEmployeeInfo(String number) {
        QFilter numFilter = new QFilter("number", "=", (Object)number);
        DynamicObject fatvsSkill = QueryServiceHelper.queryOne((String)"fatvs_skill", (String)"employee,unlockstatus", (QFilter[])numFilter.toArray());
        if (fatvsSkill == null || !fatvsSkill.getBoolean("unlockstatus")) {
            return false;
        }
        long employee = fatvsSkill.getLong("employee");
        QFilter eidFilter = new QFilter("id", "=", (Object)employee);
        DynamicObject fatvsEmployee = QueryServiceHelper.queryOne((String)"fatvs_employee", (String)"image,name,usertype", (QFilter[])eidFilter.toArray());
        if (fatvsEmployee == null) {
            return false;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        String name = fatvsEmployee.getString("name");
        String image = fatvsEmployee.getString("image");
        String usertype = fatvsEmployee.getString("usertype");
        if (org.apache.commons.lang3.StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{name, image})) {
            return false;
        }
        result.put("name", name);
        String webUrl = UrlService.getDomainContextUrlByTenantCode((String)RequestContext.get().getTenantCode());
        if ("0".equals(usertype)) {
            image = webUrl + image.substring(Math.max(image.indexOf("/images"), 0));
        } else if (!image.startsWith("http")) {
            image = UrlService.getImageFullUrl((String)image);
        }
        result.put("image", image);
        log.info("\u667a\u80fd\u5ba1\u6838\u52a9\u624b\u6570\u5b57\u5458\u5de5\u4e2a\u4eba\u4fe1\u606f:" + result);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_XIAOK, KEY_LABEL});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_EMPLOYEE, KEY_EMPLOYEE_NAME});
        Image imageCtrl = (Image)this.getControl(KEY_EMPLOYEE);
        Label nameCtrl = (Label)this.getControl(KEY_EMPLOYEE_NAME);
        imageCtrl.setUrl(image);
        nameCtrl.setText(String.format(ResManager.loadKDString((String)"%s\u5ba1\u6279\u5efa\u8bae\uff1a", (String)"TaskSmartApprovalShowResultPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), name));
        return true;
    }

    public void click(EventObject evt) {
        block8: {
            String key;
            block7: {
                super.click(evt);
                Control ctrl = (Control)evt.getSource();
                key = ctrl.getKey();
                List<String> labels = Arrays.asList("similarbill_1", "similarbill_2", "similarbill_3");
                if (labels.contains(key)) {
                    this.showSimilarBill(key);
                    return;
                }
                if (BTN_GROUP.contains(key)) {
                    this.checkControl(key);
                    long similarTaskId = NumberUtils.toLong((String)(this.getModel().getValue("similarbill_1_taskid") + ""), (long)0L);
                    this.getView().setVisible(Boolean.valueOf(similarTaskId != 0L && BTN_GENERAL.equals(key)), new String[]{KEY_SIMILAR_TASK, FLEX_SIMILAR_TASK});
                    this.getView().setVisible(Boolean.valueOf(!BTN_FILE_ANALYSIS.equals(key)), new String[]{REFRESH_KEY});
                    return;
                }
                if (!REFRESH_KEY.equals(key)) break block7;
                try {
                    this.getView().setEnable(Boolean.FALSE, new String[]{FLEX_BUTTON_GROUP});
                    long start = System.currentTimeMillis();
                    List idiSchemaList = TaskBillChildQueryServiceHelper.listTaskBillChildIdiSchema((Long)this.billTypeId, (Long)this.taskTypeId);
                    this.callDecision(idiSchemaList, true);
                    this.predictTask();
                    this.comeBineResult();
                    this.waitAnimation(start);
                    this.getPageCache().batchRemove(Arrays.asList(CACHE_OPEN, CACHE_CHECKED));
                    this.afterCreateNewData(new EventObject(this.getModel()));
                    this.getView().updateView();
                }
                catch (Exception e) {
                    try {
                        log.error("\u667a\u80fd\u5ba1\u6838\u5237\u65b0\u5f02\u5e38\u3002");
                        throw e;
                    }
                    catch (Throwable throwable) {
                        this.getView().setEnable(Boolean.TRUE, new String[]{FLEX_BUTTON_GROUP});
                        throw throwable;
                    }
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{FLEX_BUTTON_GROUP});
                break block8;
            }
            if (KEY_MORE.equals(key)) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("task_predict_parse");
                showParameter.getOpenStyle().setTargetKey("tabap");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setCustomParam("taskId", (Object)this.getTaskIdDB());
                this.getView().showForm(showParameter);
            }
        }
    }

    private void predictTask() {
        if (this.isCompletedTask() || !this.isEnableSmart) {
            log.warn("\u5df2\u5b8c\u6210\u7684\u4efb\u52a1\u65e0\u987b\u9884\u6d4b\u3002");
            return;
        }
        DynamicObject task = QueryServiceHelper.queryOne((String)"task_task", (String)"billid", (QFilter[])new QFilter("id", "=", (Object)this.taskId).toArray());
        String billId = "";
        if (task != null) {
            billId = task.getString("billid");
        }
        try {
            log.info("\u4efb\u52a1\u5ba1\u6838\u9884\u6d4b\u5237\u65b0\uff1a" + this.taskId);
            TaskApprovalForecast.predict((long)this.taskId, (String)billId);
        }
        catch (KDException e) {
            this.getView().showErrorNotification(e.getErrorCode().getMessage());
            log.error("\u4efb\u52a1\u5ba1\u6838\u9884\u6d4b\u5237\u65b0\u62a5\u9519 ", (Throwable)e);
        }
        catch (Throwable e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c\u4efb\u52a1\u5ba1\u6838\u201d\u9884\u6d4b\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"TaskSmartApprovalShowResultPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), e.getMessage()));
            log.error("\u4efb\u52a1\u5ba1\u6838\u9884\u6d4b\u5237\u65b0\u62a5\u9519 ", e);
        }
    }

    private void parsePredictResult() {
        if (!this.aiGeneralResult.predictSuccess()) {
            return;
        }
        IDataModel model = this.getModel();
        List<Long> taskIds = this.convertToLong(this.predictResult.getSimilartask());
        this.setSimilarBillId(taskIds);
        this.setTaskSubject(taskIds);
        model.setValue("smartaudit_text", (Object)this.predictResult.getSuggestDetail());
        if (this.isCompletedTask() || this.isSaved()) {
            log.info(String.format("\u5df2\u5b8c\u6210\u6216\u5df2\u4fdd\u5b58\u7684\u4efb\u52a1\u4e0d\u518d\u66f4\u6539\u9875\u9762\uff1a taskId = %s, poolType = %s", this.taskId, this.poolType));
            return;
        }
        IsPassEnum isPass = this.predictResult.getIsPass();
        if (this.aiGeneralResult.isPass().booleanValue()) {
            model.setValue("operationgroupfield", (Object)"1");
            if (IsPassEnum.pass == isPass) {
                List<Long> breakRules = this.convertToLong(this.predictResult.getBreakrule());
                model.setValue("selectsubscorerule", (Object)breakRules.toArray());
            }
        } else {
            model.setValue("operationgroupfield", (Object)"2");
            if (IsPassEnum.unPass == isPass) {
                List<Long> withdrawals;
                List opList = this.predictResult.getOperation();
                if (!CollectionUtils.isEmpty((Collection)opList)) {
                    model.setValue("decisionitem", opList.get(0));
                }
                if (!CollectionUtils.isEmpty(withdrawals = this.convertToLong(this.predictResult.getWithdrawal()))) {
                    WithdrawalSelectorUtil wdSelectorUtil = new WithdrawalSelectorUtil();
                    model.setValue("withdrawal", (Object)wdSelectorUtil.transformWithdrawal(withdrawals));
                    this.getPageCache().put("withdrawal", SerializationUtils.toJsonString(withdrawals));
                }
            }
        }
    }

    private List<Long> convertToLong(List<String> sourceList) {
        return sourceList.stream().map(p -> NumberUtils.toLong((String)p, (long)0L)).collect(Collectors.toList());
    }

    private void setSimilarBillId(List<Long> taskIds) {
        IDataModel model = this.getModel();
        int index = 0;
        for (int i = 1; i < 3; ++i) {
            if (index < taskIds.size()) {
                model.setValue(SB_PREFIX + i + SB_SUFFIX, (Object)taskIds.get(index));
                ++index;
                continue;
            }
            model.setValue(SB_PREFIX + i + SB_SUFFIX, null);
        }
    }

    private void setTaskSubject(List<Long> taskIds) {
        String algoKey = ((Object)((Object)this)).getClass().getSimpleName() + ".setTaskSubject()";
        QFilter idFilter = new QFilter("id", "in", taskIds);
        try (DataSet taskDS = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_taskhistory", (String)"id, subject", (QFilter[])new QFilter[]{idFilter}, null);){
            for (Row row : taskDS) {
                this.taskSubjectMap.put(row.getLong("id"), row.getString("subject"));
            }
        }
    }

    private void setResultLabelVisble(String laelKey) {
        Boolean isShowOk = Boolean.FALSE;
        Boolean isShowNo = Boolean.FALSE;
        Boolean isShowNull = Boolean.FALSE;
        Boolean isShowTitle = Boolean.TRUE;
        switch (laelKey) {
            case "label_smtaudit_ok": {
                isShowOk = Boolean.TRUE;
                break;
            }
            case "label_smtaudit_no": {
                isShowNo = Boolean.TRUE;
                break;
            }
            case "label_smtaudit_null": {
                isShowNull = Boolean.TRUE;
                isShowTitle = Boolean.FALSE;
                break;
            }
            default: {
                isShowTitle = Boolean.FALSE;
            }
        }
        IFormView view = this.getView();
        view.setVisible(isShowOk, new String[]{LABEL_SMTAUDIT_OK});
        view.setVisible(isShowNo, new String[]{LABEL_SMTAUDIT_NO});
        view.setVisible(isShowNull, new String[]{LABEL_SMTAUDIT_NULL});
        view.setVisible(isShowTitle, new String[]{KEY_SIMILAR_TASK, FLEX_SIMILAR_TASK});
    }

    private void showSimilarBill(String clickKey) {
        Long taskId = (Long)this.getModel().getValue(clickKey + SB_SUFFIX);
        TaskApprevalHelper.showFormToApprove(this.getView(), taskId, true, null, TaskApprovePageInvokerEnum.SMART_APPROVAL_SIMILAR_BILL.getValue());
    }

    private void checkControl(String key) {
        this.getPageCache().put(CACHE_CHECKED, key);
        Map<String, Object> checkProperties = this.changeBorder("#2A71F5", "#E0EFFF");
        Map<String, Object> unCheckProperties = this.changeBorder("#FFFFFF", "#FFFFFF");
        this.getView().updateControlMetadata(key, checkProperties);
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_PREFIX + key});
        HashSet<String> unChecks = new HashSet<String>(BTN_GROUP);
        unChecks.remove(key);
        for (String unCheck : unChecks) {
            this.getView().updateControlMetadata(unCheck, unCheckProperties);
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_PREFIX + unCheck});
        }
    }

    private Map<String, Object> changeBorder(String borderColor, String BackColor) {
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        HashMap style = new HashMap();
        if (!kd.bos.util.StringUtils.isEmpty((String)borderColor)) {
            HashMap<String, String> border = new HashMap<String, String>();
            border.put("b", "1px_solid_" + borderColor);
            border.put("l", "1px_solid_" + borderColor);
            border.put("r", "1px_solid_" + borderColor);
            border.put("t", "1px_solid_" + borderColor);
            style.put("b", border);
        }
        propertiesMap.put("s", style);
        propertiesMap.put("bc", BackColor);
        return propertiesMap;
    }

    private boolean isCompletedTask() {
        return this.poolType == TaskPoolTypeEnum.COMPLETE;
    }

    private boolean isSaved() {
        DynamicObject task = QueryServiceHelper.queryOne((String)"task_task", (String)"approveop", (QFilter[])new QFilter("id", "=", (Object)this.taskId).toArray());
        return task != null && StringUtils.isNotEmpty((CharSequence)task.getString("approveop"));
    }

    private Long getTaskIdDB() {
        return this.isCompletedTask() ? this.sourceTaskId : this.taskId;
    }

    private void changeIsEnableSchema(List<String> idiSchemaList) {
        this.isEnableSchema = idiSchemaList != null && !idiSchemaList.isEmpty();
    }
}

