/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.smartcs;

import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.plugin.IListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class DetailFormPlugin
extends AbstractFormPlugin
implements IListPlugin {
    private static final Log log = LogFactory.getLog(DetailFormPlugin.class);
    private static final String ABSENCE = "nothing";
    private static final String CACHED_SUBJECT_ID = "subjectId";
    private static final String ASSIGN_NEW_PERM_ITEMID = "47156aff000000ac";
    private static final String ASSIGN_SAVE_PERM_ITEMID = "0=KX5+QVF5+R";

    public void afterCreateNewData(EventObject e) {
        if (this.mcleSubject()) {
            this.setSubjectVisiable();
        } else {
            this.setInfoVisiable();
            Object subject = this.getView().getFormShowParameter().getCustomParam(CACHED_SUBJECT_ID);
            if (subject != null) {
                this.getModel().setValue("group", subject);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.checkPermission();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.mcleSubject()) {
            this.setSubjectVisiable();
        } else {
            IDataModel model;
            this.setInfoVisiable();
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (OperationStatus.EDIT.equals((Object)status) && (model = this.getModel()).getEntryRowCount("quesentry") == 0) {
                this.getModel().createNewEntryRow("quesentry");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        int entryCount;
        Long subjectId;
        super.beforeDoOperation(args);
        Object operation = args.getSource();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (operation instanceof Save && OperationStatus.ADDNEW.equals((Object)status)) {
            if (this.mcleSubject()) {
                this.autoFillFieldWithSubject();
            } else {
                this.autoFillFieldWithInfo();
            }
        }
        if (operation instanceof SaveAndNew && (subjectId = (Long)this.getView().getFormShowParameter().getCustomParam(CACHED_SUBJECT_ID)) == null) {
            Object subject = this.getModel().getValue("group");
            subjectId = subject instanceof DynamicObject ? (Long)((DynamicObject)subject).getPkValue() : (Long)subject;
            this.getView().getFormShowParameter().getCustomParams().put(CACHED_SUBJECT_ID, subjectId);
        }
        if (operation instanceof NewEntry && (entryCount = this.getModel().getEntryRowCount("quesentry")) >= 5) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u76f8\u4f3c\u95ee\u6cd5\u6570\u91cf\u5df2\u8fbe\u4e0a\u9650\uff085\u4e2a\uff09\u3002", (String)"DetailFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        Object operation = args.getSource();
        OperationResult result = args.getOperationResult();
        if (result == null) {
            return;
        }
        boolean success = result.isSuccess();
        if (operation instanceof Save && success && this.mcleSubject()) {
            this.getView().close();
        }
    }

    private void autoFillFieldWithInfo() {
        IDataModel model = this.getModel();
        model.setValue("subject", (Object)Boolean.FALSE);
        model.setValue("subjectnum", model.getValue("number"));
        model.setValue("name", (Object)ABSENCE);
        Object areaId = this.getAreaId();
        if (areaId != null) {
            model.setValue("area", areaId);
        }
    }

    private void autoFillFieldWithSubject() {
        IDataModel model = this.getModel();
        model.setValue("subject", (Object)Boolean.TRUE);
        Object subjectNum = model.getValue("subjectnum");
        model.setValue("number", StringUtils.isBlank((Object)subjectNum) ? ABSENCE : subjectNum);
        model.setValue("question", (Object)ABSENCE);
        model.setValue("answer", (Object)ABSENCE);
        Object areaId = this.getAreaId();
        if (areaId != null) {
            model.setValue("area", areaId);
        }
    }

    private boolean mcleSubject() {
        boolean kind = false;
        kind = "addnew".equals(this.getView().getFormShowParameter().getCustomParams().get("operate"));
        kind = kind || "edit".equals(this.getView().getFormShowParameter().getCustomParams().get("operate"));
        return kind;
    }

    private void setSubjectVisiable() {
        String[] hidenField = new String[]{"titleapanel", "flexpanelap5"};
        String[] visitField = new String[]{"flexpanelap6"};
        this.getView().setVisible(Boolean.FALSE, hidenField);
        this.getView().setVisible(Boolean.TRUE, visitField);
    }

    private void setInfoVisiable() {
        String[] hidenField = new String[]{"flexpanelap6"};
        String[] visitField = new String[]{"titleapanel", "flexpanelap5"};
        this.getView().setVisible(Boolean.FALSE, hidenField);
        this.getView().setVisible(Boolean.TRUE, visitField);
    }

    private Object getAreaId() {
        return this.getView().getFormShowParameter().getCustomParam("areaId");
    }

    private void checkPermission() {
        Object createOrgIdObj = this.getView().getFormShowParameter().getCustomParam("createOrgId");
        if (createOrgIdObj == null) {
            log.info("checkPermission() occur exception, createOrg is null");
            return;
        }
        Long createOrgId = Long.parseLong(createOrgIdObj.toString());
        boolean hasNewPermission = this.hasAssignedPermission(createOrgId, ASSIGN_NEW_PERM_ITEMID);
        boolean hasSavePermission = this.hasAssignedPermission(createOrgId, ASSIGN_SAVE_PERM_ITEMID);
        if (hasSavePermission && hasNewPermission) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_saveandnew"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_saveandnew"});
        }
        if (hasSavePermission) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_save"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"flexpanelap5"});
        }
    }

    private boolean hasAssignedPermission(Long orgId, String permItemId) {
        String appId = AppMetadataCache.getAppInfo((String)"ssc").getId();
        Long userId = RequestContext.get().getCurrUserId();
        int hasPermResult = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)appId, (String)"som_knowledge_info", (String)permItemId);
        return hasPermResult == 1;
    }

    private Long queryAreaCreateOrgById(Long areaId) {
        if (areaId == null || areaId == 0L) {
            return 0L;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)areaId);
        DynamicObject area = QueryServiceHelper.queryOne((String)"som_knowledge_area", (String)"createorg", (QFilter[])new QFilter[]{qFilter});
        if (area == null) {
            return 0L;
        }
        return area.getLong("createorg.id");
    }
}

