/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.smartcs;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.enums.MultiLangEnumBridge;
import kd.ssc.task.dto.smartcs.GroupPermission;
import kd.ssc.task.util.SscLicenseUtil;

public class SmartcsStaffTreeListPlugin
extends StandardTreeListPlugin {
    private static final Log logger = LogFactory.getLog(StandardTreeListPlugin.class);
    private static final String CONFIRM_BTNDEL = "CONFIRM_BTNDEL";
    private static final String GROUP_PRESET_ID = "som_smartcs_group.presetid";
    private static final String GROUP_CREATE_ORG = "som_smartcs_group.createorg";
    private static final String GROUP_SSC_ID = "group.createorg.id";
    private static final String ENTRY_IS_ENABLE = "entryentity.isenable";
    private static final String ENTRY_GROUP_ID = "entryentity.groupid";
    public static final String PRO_CREATEORG = "createOrg";
    public static final String VERIFYORG = "verifyOrg";
    private static final Map<String, GroupPermission> PERMISSION_MAP = new HashMap<String, GroupPermission>(16);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        SscLicenseUtil.checkFeatureLicense((String)"PRO_SSC_SCS", (PreOpenFormEventArgs)e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
    }

    public void filterContainerSetFlat(SetFilterContainerFlatEvent args) {
        args.setNewFilter(false);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.checkPreset();
        if (this.getControlFilters() == null) {
            List commonFilterColumns = args.getCommonFilterColumns();
            for (FilterColumn column : commonFilterColumns) {
                if (!"group.createorg.name".equals(column.getFieldName())) continue;
                column.setDefaultValue(this.getPageCache().get(PRO_CREATEORG));
                break;
            }
            this.getTreeListView().refreshTreeView();
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        boolean switchSSC;
        super.filterContainerSearchClick(args);
        List fieldName = (List)args.getCurrentCommonFilter().get("FieldName");
        boolean bl = switchSSC = fieldName != null && GROUP_SSC_ID.equals(fieldName.get(0));
        if (switchSSC) {
            Object orgId = ((List)args.getCurrentCommonFilter().get("Value")).get(0);
            this.cacheOrg(orgId.toString());
            this.getTreeModel().setCurrentNodeId((Object)this.getTreeModel().getRoot().getId());
            this.getTreeListView().refreshTreeView();
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        Iterator qFilterIterator = qFilters.iterator();
        ITreeModel treeModel = this.getTreeModel();
        boolean checkingAll = treeModel.getRoot().getId().equals(treeModel.getCurrentNodeId());
        QFilter allGroup = new QFilter(ENTRY_GROUP_ID, "=", (Object)-99999999L);
        block10: while (qFilterIterator.hasNext()) {
            QFilter qFilter = (QFilter)qFilterIterator.next();
            switch (qFilter.getProperty()) {
                case "group.createorg.id": {
                    qFilterIterator.remove();
                    if (!checkingAll) break;
                    List groups = treeModel.getRoot().getChildren();
                    if (groups == null) continue block10;
                    List groupIds = groups.stream().map(TreeNode::getId).mapToLong(Long::parseLong).boxed().collect(Collectors.toList());
                    allGroup = new QFilter(ENTRY_GROUP_ID, "in", groupIds);
                    break;
                }
                case "entryenable": {
                    qFilter.__setProperty(ENTRY_IS_ENABLE);
                    break;
                }
                case "group": {
                    qFilter.__setProperty(ENTRY_GROUP_ID);
                }
            }
        }
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        if (checkingAll) {
            qFilters.add(allGroup);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        TreeListModel model = (TreeListModel)this.getTreeModel();
        this.setTreeListFilter();
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Long orgId = this.getOrgIdFilterElseContext();
        String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
        boolean isNotRoot = !this.getTreeModel().getRoot().getId().equals(currentNodeId);
        BillShowParameter billShowParameter = e.getParameter();
        billShowParameter.setCustomParam("createorg", (Object)orgId);
        billShowParameter.setCustomParam("useorgId", (Object)orgId.toString());
        if (isNotRoot) {
            billShowParameter.setCustomParam("s_groupid", (Object)currentNodeId);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object argsSource = args.getSource();
        if (argsSource instanceof Delete || argsSource instanceof Donothing) {
            DefaultEntityOperate source = (DefaultEntityOperate)argsSource;
            source.setCancelRefresh(true);
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            StringJoiner entryIdJoiner = new StringJoiner(",");
            StringJoiner fIdJoiner = new StringJoiner(",");
            StringJoiner indexJoiner = new StringJoiner(",");
            for (int i = 0; i < listSelectedData.size(); ++i) {
                ListSelectedRow listSelectedRow = listSelectedData.get(i);
                entryIdJoiner.add(listSelectedRow.getEntryPrimaryKeyValue().toString());
                fIdJoiner.add(listSelectedRow.getPrimaryKeyValue().toString());
                indexJoiner.add(listSelectedRow.getRowKey() + 1 + "");
            }
            source.getOption().setVariableValue("entryids", entryIdJoiner.toString());
            source.getOption().setVariableValue("fids", fIdJoiner.toString());
            source.getOption().setVariableValue("rowKeys", indexJoiner.toString());
            source.getOption().setVariableValue("opKey", source.getOperateKey());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getSource() instanceof Delete) {
            OperationResult operationResult = args.getOperationResult();
            if (operationResult.isSuccess()) {
                this.getView().invokeOperation("refresh");
            }
        } else if (args.getSource() instanceof Donothing) {
            String opName = ((Donothing)args.getSource()).getOperateName().toString();
            OperationResult operationResult = args.getOperationResult();
            String errorFormId = "bos_operationresult";
            String boxTitle = "title";
            String errorMsg = "errorMsg";
            String titleMsg = ResManager.loadKDString((String)"\u5171%1$s\u6761\u6570\u636e\uff0c%2$s\u6210\u529f%3$s\u6761\uff0c\u5931\u8d25%4$s\u6761", (String)"StaffTreeListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            if (operationResult != null) {
                if (operationResult.isSuccess()) {
                    this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"SmartcsKDString_12", (String)"ssc-task-formplugin", (Object[])new Object[0]), opName));
                    this.getView().invokeOperation("refresh");
                    return;
                }
                List allErrorInfoList = operationResult.getAllErrorOrValidateInfo();
                if (!allErrorInfoList.isEmpty()) {
                    ArrayList<String> list = new ArrayList<String>(10);
                    int len = allErrorInfoList.size();
                    for (int i = 0; i < len; ++i) {
                        String msg = ((IOperateInfo)allErrorInfoList.get(i)).getMessage();
                        list.add(msg);
                    }
                    if (operationResult.getBillCount() > 1) {
                        FormShowParameter parameters = new FormShowParameter();
                        parameters.getOpenStyle().setShowType(ShowType.Modal);
                        parameters.setFormId(errorFormId);
                        parameters.setShowTitle(false);
                        int successCount = operationResult.getBillCount() - allErrorInfoList.size();
                        String title = String.format(titleMsg, operationResult.getBillCount(), StringUtils.isBlank((CharSequence)opName) ? "" : opName, successCount, allErrorInfoList.size());
                        parameters.setCustomParam(boxTitle, (Object)title);
                        parameters.setCustomParam(errorMsg, list);
                        this.getView().showForm(parameters);
                    } else {
                        this.getView().showTipNotification((String)list.get(0));
                    }
                }
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public void treeToolbarClick(EventObject e) {
        Control ctl = (Control)e.getSource();
        String sscId = this.getPageCache().get("createorg");
        String appId = this.getView().getFormShowParameter().getAppId();
        Optional<String> invalid = Optional.ofNullable(PERMISSION_MAP.get(ctl.getKey())).map(gp -> gp.checkPermission(appId, Long.parseLong(sscId)));
        if (invalid.isPresent()) {
            this.getView().showErrorNotification(invalid.get());
            return;
        }
        switch (ctl.getKey()) {
            case "btnnew": {
                this.addNode(e);
                break;
            }
            case "btnedit": {
                this.editNode(e);
                break;
            }
            case "btndel": {
                this.deleteNode(e);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (StringUtils.equals((CharSequence)event.getCallBackId(), (CharSequence)CONFIRM_BTNDEL) && event.getResult() == MessageBoxResult.Yes) {
            MessageBoxClosedEvent group_bar_del = new MessageBoxClosedEvent(event.getSource(), "group_bar_del", event.getResult().getValue(), event.getCustomVaule());
            super.confirmCallBack(group_bar_del);
        }
    }

    private void addNode(EventObject e) {
        ITreeModel treeModel = this.getTreeModel();
        String currentNodeId = (String)treeModel.getCurrentNodeId();
        if (!treeModel.getRoot().getId().equals(currentNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u6839\u8282\u70b9\u4e0b\u65b0\u589e\u5206\u7ec4\u3002", (String)"SmartcsKDString_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        } else {
            super.treeToolbarClick(e);
        }
    }

    private void editNode(EventObject e) {
        super.treeToolbarClick(e);
    }

    private void deleteNode(EventObject e) {
        ITreeModel treeModel = this.getTreeModel();
        String currentNodeId = (String)treeModel.getCurrentNodeId();
        TreeNode currentNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId, 10);
        if (this.deletionError()) {
            return;
        }
        String text = currentNode.getText();
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5220\u9664\u201c%s\u201d\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u5220\u9664\u5417\uff1f", (String)"SmartcsKDString_4", (String)"ssc-task-formplugin", (Object[])new Object[0]), text), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRM_BTNDEL));
    }

    private boolean deletionError() {
        ITreeModel treeModel = this.getTreeModel();
        String currentNodeId = (String)treeModel.getCurrentNodeId();
        GroupProp prop = this.getTreeModel().getGroupProp();
        boolean rootIsCurrent = this.getTreeModel().getRoot().getId().equals(currentNodeId);
        if (rootIsCurrent) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u6839\u8282\u70b9\u3002", (String)"SmartcsKDString_6", (String)"ssc-task-common", (Object[])new Object[0]));
            return true;
        }
        if (StringUtils.isBlank((CharSequence)currentNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u5206\u7ec4\u8282\u70b9\u3002", (String)"SmartcsKDString_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (!prop.isNeedRefreshTree()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7981\u7528\u5237\u65b0\u60c5\u51b5\u4e0d\u5141\u8bb8\u5220\u9664\u8282\u70b9\u3002", (String)"SmartcsKDString_7", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return true;
        }
        QFilter entryEntity = new QFilter(ENTRY_GROUP_ID, "=", (Object)Long.valueOf(currentNodeId));
        boolean groupHasStaff = QueryServiceHelper.exists((String)"som_smartcs_staff", (QFilter[])new QFilter[]{entryEntity});
        if (groupHasStaff) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4eba\u5458\u7ba1\u7406\u201d\u4e2d\u7684\u201c\u7ec4\u540d\u201d\u5b57\u6bb5\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"SmartcsKDString_9", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private QFilter groupFilter() {
        return new QFilter("createorg", "=", (Object)this.getOrgIdFilterElseContext());
    }

    private Long getOrgIdFilterElseContext() {
        return this.getFilterOrg().orElseGet(() -> this.getUserFirstSSCId(RequestContext.get().getCurrUserId()));
    }

    private Optional<Long> getFilterOrg() {
        return Optional.ofNullable(this.getControlFilters()).map(filters -> Long.parseLong(filters.getFilter(GROUP_SSC_ID).get(0).toString()));
    }

    private void setTreeListFilter() {
        List treeFilter = this.getTreeModel().getTreeFilter();
        treeFilter.clear();
        treeFilter.add(this.groupFilter());
    }

    private void checkPreset() {
        boolean isPreset;
        Long createOrg = this.getOrgIdFilterElseContext();
        logger.info(String.format("\u68c0\u67e5\u5171\u4eab\u4e2d\u5fc3%s\u662f\u5426\u9700\u8981\u9884\u7f6e", createOrg));
        QFilter presetLeftJoinGroup = QFilter.join((String)"id", (String)GROUP_PRESET_ID, (QFilter)QFilter.of((String)"som_smartcs_group.createorg= ?", (Object[])new Object[]{createOrg}), (ORMHint.JoinHint)ORMHint.JoinHint.LEFT, (boolean)true);
        QFilter presetIdIsNull = new QFilter(GROUP_PRESET_ID, "is null", null);
        String selectFields = "id,name,subgroup,number,som_smartcs_group.presetid";
        Supplier<DynamicObject[]> notPresetGroups = () -> BusinessDataServiceHelper.load((String)"som_smartcs_preset_group", (String)"id,name,subgroup,number,som_smartcs_group.presetid", (QFilter[])new QFilter[]{presetLeftJoinGroup, presetIdIsNull}, (String)"id desc");
        boolean bl = isPreset = notPresetGroups.get().length == 0;
        if (isPreset) {
            return;
        }
        String lockInfo = "fi/som/som_smartcs_group/initialize-preset-group/" + createOrg;
        try (DLock lock = DLock.create((String)lockInfo, (String)("preset-group-initialize-ssc" + createOrg));){
            logger.info(String.format("\u5171\u4eab\u4e2d\u5fc3%s\u9700\u8981\u9884\u7f6e\u5206\u7ec4\uff0c\u7b49\u5f85\u52a0\u9501\uff0clockInfo:%s", createOrg, lockInfo));
            lock.tryLock(4000L);
            logger.info(String.format("\u52a0\u9501\u6210\u529flockInfo:%s", lockInfo));
            DynamicObject[] dynamicObjects = notPresetGroups.get();
            boolean bl2 = isPreset = dynamicObjects.length == 0;
            if (isPreset) {
                return;
            }
            ArrayList<DynamicObject> newGroups = new ArrayList<DynamicObject>(dynamicObjects.length);
            DynamicObject org = BusinessDataReader.loadSingle((Object)createOrg, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
            for (DynamicObject dyo : dynamicObjects) {
                DynamicObject group = BusinessDataServiceHelper.newDynamicObject((String)"som_smartcs_group");
                group.set("createorg", (Object)org);
                group.set("number", (Object)dyo.getString("number"));
                group.set("name", (Object)dyo.getLocaleString("name"));
                group.set("presetid", (Object)dyo.getLong("id"));
                group.set("subgroup", dyo.get("subgroup"));
                group.set("enable", (Object)"1");
                group.set("status", (Object)"C");
                newGroups.add(group);
            }
            OperationServiceHelper.executeOperate((String)"save", (String)"som_smartcs_group", (DynamicObject[])newGroups.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            logger.info(String.format("\u5171\u4eab\u4e2d\u5fc3%s\u9884\u7f6e\u4ee5\u4e0b\u5206\u7ec4\u6210\u529f\uff1a%s", createOrg, newGroups.stream().map(ng -> ng.getString("name")).collect(Collectors.joining(","))));
        }
    }

    private void cacheOrg(String orgId) {
        this.getPageCache().put(PRO_CREATEORG, orgId);
        this.getPageCache().put(VERIFYORG, orgId);
        this.getPageCache().put("createorg", orgId);
    }

    private void cacheOrg() {
        Optional<Long> filterOrg = this.getFilterOrg();
        if (filterOrg.isPresent()) {
            Long orgId = filterOrg.get();
            this.cacheOrg(orgId.toString());
        }
    }

    private Long getUserFirstSSCId(Long userId) {
        boolean isScc;
        String ssc = "createorg";
        String cacheSSCId = this.getPageCache().get(ssc);
        if (kd.bos.util.StringUtils.isNotEmpty((String)cacheSSCId)) {
            return Long.valueOf(cacheSSCId);
        }
        Long sscid = 0L;
        String appId = "som";
        String entityName = "som_smartcs_staff";
        sscid = RequestContext.get().getOrgId();
        int checkPermission = PermissionServiceHelper.checkPermission((Long)userId, (Long)sscid, (String)"12", (String)appId, (String)entityName, (String)"47150e89000000ac");
        if (checkPermission == 1 && (isScc = OrgUnitServiceHelper.checkOrgFunction((Long)sscid, (String)"12"))) {
            this.cacheOrg(String.valueOf(sscid));
            return sscid;
        }
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"12", (String)appId, (String)entityName, (String)"47150e89000000ac");
        boolean isHasAllOrgPerm = allPermOrgs.hasAllOrgPerm();
        if (isHasAllOrgPerm) {
            QFilter f1 = new QFilter("view.number", "=", (Object)"12");
            QFilter f3 = new QFilter("view.isdefault", "=", (Object)Boolean.TRUE);
            DynamicObject bosorgItem = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{f1, f3});
            if (bosorgItem != null) {
                sscid = bosorgItem.getLong("org");
            }
        } else {
            List hasPermOrgs = allPermOrgs.getHasPermOrgs();
            List sscOrgList = OrgUnitServiceHelper.filterOrgDuty((List)hasPermOrgs, (String)"12");
            long min = Long.MAX_VALUE;
            long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
            if (sscOrgList != null && sscOrgList.size() > 0) {
                for (Long sscOrg : sscOrgList) {
                    if (sscOrg == rootOrgId) {
                        min = rootOrgId;
                        break;
                    }
                    min = Math.min(sscOrg, min);
                }
                sscOrgList.sort(Long::compareTo);
                sscid = min;
            }
        }
        if (sscid != null) {
            this.cacheOrg(String.valueOf(sscid));
        }
        return sscid;
    }

    static {
        PERMISSION_MAP.put("btndel", new GroupPermission("4715e1f1000000ac", new MultiLangEnumBridge("\u5220\u9664", "SmartcsStaffTreeListPlugin_0", "ssc-task-formplugin")));
        PERMISSION_MAP.put("btnnew", new GroupPermission("47156aff000000ac", new MultiLangEnumBridge("\u65b0\u589e", "SmartcsStaffTreeListPlugin_1", "ssc-task-formplugin")));
        PERMISSION_MAP.put("btnedit", new GroupPermission("4715a0df000000ac", new MultiLangEnumBridge("\u4fee\u6539", "SmartcsStaffTreeListPlugin_2", "ssc-task-formplugin")));
    }
}

