/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.smartcs.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.ssc.smartcs.enums.ExcpStateEnum;
import kd.ssc.smartcs.result.QuestionResult;
import kd.ssc.smartcs.util.AIMetaDataSynchrnizedUtil;

public class AttachmentSynSchedule
extends AbstractTask {
    private static final Log log = LogFactory.getLog(AttachmentSynSchedule.class);
    private static final String AREA = "area";
    private static final String SUBJECT = "group";
    private static final String AI_SUBJECT_ID = "aisubjectid";
    private static final String AI_QUESTION_ID = "aiquestionid";
    private static final String QUESTION = "question";
    private static final String ANSWER = "answer";
    private static final String KEYWORDS = "keyword";
    private static final String ENTRY = "quesentry";
    private static final String LINK_NAME = "linktitle";
    private static final String LINK_ADDRESS = "link";
    private static final String ATTACHMENT = "attachment";
    private static final String SIM_QUESTION = "similarques";
    private static final String SYNATTACHMENT = "synattachment";
    private static final String URLSUFFIX = "/index.html?formId=som_smartcs_attach&accountId=%s&attachId=%s";
    private static final String URLSUFFIX_MOBILE = "/mobile.html?form=som_smartcs_attach_mb&userId=guest&accountId=%s&attachId=%s";
    private String domainContextURL;
    private String accountId;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String domainUrlMap;
        QFilter accountFil;
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(2);
        qfilters.add(new QFilter("rebortuse", "=", (Object)Boolean.TRUE));
        qfilters.add(new QFilter(SYNATTACHMENT, "=", (Object)Boolean.FALSE));
        List<Object> ids = QueryServiceHelper.query((String)"som_knowledge_info", (String)"id", (QFilter[])qfilters.toArray(new QFilter[0])).stream().map(d -> d.get("id")).collect(Collectors.toList());
        if (ids.isEmpty()) {
            return;
        }
        this.accountId = requestContext.getAccountId();
        this.domainContextURL = UrlService.getDomainContextUrl();
        QFilter tenantIdFil = new QFilter("qxtenantid", "=", (Object)requestContext.getTenantId());
        DynamicObject globalInfoDyo = BusinessDataServiceHelper.loadSingle((String)"som_knowledge_global", (QFilter[])new QFilter[]{tenantIdFil, accountFil = new QFilter("accountid", "=", (Object)requestContext.getAccountId())});
        if (globalInfoDyo != null && StringUtils.isNotEmpty((CharSequence)(domainUrlMap = globalInfoDyo.getString("domainurlmap"))) && domainUrlMap.startsWith("http")) {
            this.domainContextURL = domainUrlMap;
        }
        DynamicObjectType questionType = BusinessDataServiceHelper.newDynamicObject((String)"som_knowledge_info").getDynamicObjectType();
        DynamicObject[] questions = BusinessDataServiceHelper.load((Object[])ids.toArray(new Object[0]), (DynamicObjectType)questionType);
        ArrayList<DynamicObject> updateQuestionList = new ArrayList<DynamicObject>(Arrays.asList(questions));
        for (DynamicObject dyo : questions) {
            try {
                this.updateQuestion(dyo);
            }
            catch (Exception e) {
                updateQuestionList.remove(dyo);
                log.error("\u540c\u6b65\u95ee\u7b54\u9644\u4ef6\u62a5\u9519\uff0cid\uff1a" + dyo.getPkValue() + "\uff0cmsg\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
        SaveServiceHelper.save((DynamicObject[])updateQuestionList.toArray(new DynamicObject[0]));
    }

    private void updateQuestion(DynamicObject dyo) {
        Long areaId = this.getAIAreaId(this.getAreaId(dyo));
        Long qaId = this.getQAId(this.getAreaId(dyo));
        Long subjectId = this.getAISubjectId(dyo);
        Long questionId = this.getAIQuestionId(dyo);
        String keyword = dyo.getString(KEYWORDS) + "";
        String answer = dyo.getString(ANSWER) + "";
        List<String> questions = this.getQuestions(dyo);
        String linkTitle = dyo.getString(LINK_NAME) + "";
        String linkAddress = dyo.getString(LINK_ADDRESS) + "";
        boolean enableLinkCard = false;
        if (StringUtils.isNotBlank((CharSequence)linkAddress)) {
            enableLinkCard = true;
        }
        Map<Long, List<String>> attachments = this.getAttachmentList(dyo);
        if (questionId <= 0L) {
            ErrorCode code = new ErrorCode(ExcpStateEnum.DataOutOfSync.getValue(), ResManager.loadKDString((String)"\u66f4\u65b0\u95ee\u7b54\u65f6\uff0c\u65e0\u6cd5\u83b7\u5f97AI\u95ee\u7b54id\u3002", (String)"InfoSavePlugin_0", (String)"ssc-task-opplugin", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        QuestionResult result = AIMetaDataSynchrnizedUtil.updateQuestion((Long)questionId, (Long)areaId, (Long)subjectId, (Long)qaId, (String)keyword, (String)answer, questions, (boolean)enableLinkCard, (String)linkTitle, (String)linkAddress, attachments);
        dyo.set(AI_QUESTION_ID, (Object)result.getId());
        dyo.set(SYNATTACHMENT, (Object)Boolean.TRUE);
    }

    private Long getAIQuestionId(DynamicObject dyo) {
        return this.getBaseId(dyo, AI_QUESTION_ID);
    }

    private Map<Long, List<String>> getAttachmentList(DynamicObject dyo) {
        DynamicObjectCollection attachments = dyo.getDynamicObjectCollection(ATTACHMENT);
        if (attachments == null || attachments.isEmpty()) {
            return new HashMap<Long, List<String>>(0);
        }
        HashMap<Long, List<String>> attachmentMap = new HashMap<Long, List<String>>(attachments.size());
        for (DynamicObject each : attachments) {
            DynamicObject attachment = each.getDynamicObject("fbasedataid");
            Long id = (Long)attachment.getPkValue();
            String name = attachment.get("name") + "";
            String attachPageUrl = String.format(this.domainContextURL + URLSUFFIX, this.accountId, id);
            String attachMobilePageUrl = String.format(this.domainContextURL + URLSUFFIX_MOBILE, this.accountId, id);
            log.info("\u9644\u4ef6\u5730\u5740\uff1aattachPageUrl = {}, attachMobilePageUrl = {}", (Object)attachPageUrl, (Object)attachMobilePageUrl);
            attachmentMap.put(id, Arrays.asList(name, attachPageUrl, attachMobilePageUrl));
        }
        return attachmentMap;
    }

    private List<String> getQuestions(DynamicObject dyo) {
        List<String> similarQuestions = this.getSimQuestion(dyo);
        ArrayList<String> questions = new ArrayList<String>(similarQuestions.size() + 1);
        questions.add(dyo.getString(QUESTION) + "");
        questions.addAll(similarQuestions);
        return questions;
    }

    private List<String> getSimQuestion(DynamicObject dyo) {
        DynamicObjectCollection simQuestions = dyo.getDynamicObjectCollection(ENTRY);
        if (simQuestions == null || simQuestions.isEmpty()) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> simQuestionList = new ArrayList<String>(simQuestions.size());
        for (DynamicObject each : simQuestions) {
            simQuestionList.add(each.getString(SIM_QUESTION) + "");
        }
        return simQuestionList;
    }

    private Long getAIAreaId(Long areaId) {
        QFilter qFilter = new QFilter("id", "=", (Object)areaId);
        DynamicObject area = QueryServiceHelper.queryOne((String)"som_knowledge_area", (String)"aiareaid", (QFilter[])new QFilter[]{qFilter});
        if (area == null || area.getLong("aiareaid") == 0L) {
            ErrorCode code = new ErrorCode(ExcpStateEnum.DataOutOfSync.getValue(), String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u95ee\u7b54\u672a\u83b7\u5f97\u6240\u5c5e\u9886\u57dfid\uff08AI\uff09\uff0c\u6240\u5c5e\u82cd\u7a79\u9886\u57dfid\u4e3a\uff1a%s", (String)"AttachmentSynSchedule_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), areaId));
            throw new KDException(code, new Object[0]);
        }
        return area.getLong("aiareaid");
    }

    private Long getQAId(Long areaId) {
        QFilter qFilter = new QFilter("id", "=", (Object)areaId);
        DynamicObject qa = QueryServiceHelper.queryOne((String)"som_knowledge_area", (String)"aiqaid", (QFilter[])new QFilter[]{qFilter});
        if (qa == null || qa.getLong("aiqaid") == 0L) {
            ErrorCode code = new ErrorCode(ExcpStateEnum.DataOutOfSync.getValue(), String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u95ee\u7b54\u672a\u83b7\u5f97\u6240\u5c5eQAId\uff08AI\uff09\uff0c\u6240\u5c5e\u82cd\u7a79\u9886\u57dfid\u4e3a\uff1a%s", (String)"AttachmentSynSchedule_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), areaId));
            throw new KDException(code, new Object[0]);
        }
        return qa.getLong("aiqaid");
    }

    private Long getAISubjectId(DynamicObject dyo) {
        long subjectId = this.getSubjectId(dyo);
        DynamicObject subject = QueryServiceHelper.queryOne((String)"som_knowledge_info", (String)AI_SUBJECT_ID, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)subjectId)});
        if (subject == null || subject.getLong(AI_SUBJECT_ID) == 0L) {
            ErrorCode code = new ErrorCode(ExcpStateEnum.DataOutOfSync.getValue(), String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u95ee\u7b54\u672a\u83b7\u5f97\u6240\u5c5e\u7c7b\u76eeid\uff08AI\uff09\uff0c\u6240\u5c5e\u82cd\u7a79\u7c7b\u76eeid\u4e3a\uff1a%s", (String)"AttachmentSynSchedule_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), dyo.getPkValue()));
            throw new KDException(code, new Object[0]);
        }
        return subject.getLong(AI_SUBJECT_ID);
    }

    private Long getSubjectId(DynamicObject dyo) {
        return this.getBaseId(dyo, SUBJECT);
    }

    private Long getAreaId(DynamicObject dyo) {
        return this.getBaseId(dyo, AREA);
    }

    private Long getBaseId(DynamicObject dyo, String field) {
        Object value = dyo.get(field);
        if (value instanceof DynamicObject) {
            return (Long)((DynamicObject)value).getPkValue();
        }
        return (Long)value;
    }
}

