/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.smartcs.schedule;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.smartcs.enums.OperationEnum;
import kd.ssc.smartcs.enums.TerminalAppEnum;
import kd.ssc.task.util.DateUtil;

public class SmartCSPullRobotQALogSchedule
extends AbstractTask {
    private static final Log log = LogFactory.getLog(SmartCSPullRobotQALogSchedule.class);
    private DynamicObject golbalParam;
    private long robotId;
    private long skillId;
    private Date pullTime;
    private final Date now = new Date();
    private Integer totalPage;
    private static final int pageSize = 1000;
    private static final String qaLogEntity = "som_knowledge_qa_log";

    public void execute(RequestContext request, Map<String, Object> paramsMap) throws KDException {
        boolean loadSucess = this.loadGlobalParams(request);
        if (loadSucess) {
            this.pullAIRobotQALog(1);
            this.writeBackPullTime();
        }
    }

    private boolean loadGlobalParams(RequestContext request) {
        QFilter qFilter = new QFilter("qxtenantid", "=", (Object)request.getTenantId());
        QFilter a = new QFilter("accountid", "=", (Object)request.getAccountId());
        String selectFields = String.join((CharSequence)",", "robotid", "skillid", "pulltime");
        this.golbalParam = BusinessDataServiceHelper.loadSingle((String)"som_knowledge_global", (String)selectFields, (QFilter[])new QFilter[]{qFilter, a});
        if (this.golbalParam == null) {
            log.error("loadGlobalParams() error. Global parameters not exists");
            return false;
        }
        this.robotId = this.golbalParam.getLong("robotid");
        this.skillId = this.golbalParam.getLong("skillid");
        this.pullTime = this.golbalParam.getDate("pulltime");
        if (this.pullTime == null) {
            this.pullTime = DateUtil.addMonth((Date)this.now, (int)-6);
        }
        return true;
    }

    private void pullAIRobotQALog(int curPage) {
        String inputParams = this.buildInputParams(curPage);
        String result = this.invokeCbpService(inputParams);
        JSONObject resultJson = JSONObject.parseObject((String)result);
        int code = resultJson.getIntValue("code");
        log.info(String.format(" inputParams = %s, code = %s, message = %s, traceId = %s", inputParams, code, resultJson.getString("msg"), resultJson.getString("traceId")));
        if (0 != code) {
            log.info(String.format("api invoke failed! curPage = %s, totalPage = %s", curPage, this.totalPage));
            return;
        }
        List<DynamicObject> qaLogs = this.parseResult(resultJson);
        if (qaLogs.isEmpty()) {
            log.info(String.format("exit! qaLogs is empty. curPage = %s, totalPage = %s", curPage, this.totalPage));
            return;
        }
        SaveServiceHelper.save((DynamicObject[])qaLogs.toArray(new DynamicObject[qaLogs.size()]));
        if (++curPage <= this.totalPage) {
            this.pullAIRobotQALog(curPage);
        }
    }

    protected String invokeCbpService(String inputParams) {
        return (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cbp", (String)"CbpService", (String)"adminOperate", (Object[])new Object[]{OperationEnum.GET_SKILLLOG.getOperate(), inputParams});
    }

    private void writeBackPullTime() {
        this.golbalParam.set("pulltime", (Object)this.now);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.golbalParam});
    }

    private String buildInputParams(int curPage) {
        HashMap<String, Object> inputParams = new HashMap<String, Object>(8);
        inputParams.put("robotId", this.robotId);
        inputParams.put("skillId", this.skillId);
        inputParams.put("startTime", this.pullTime);
        inputParams.put("endTime", this.now);
        HashMap<String, Integer> pageInfo = new HashMap<String, Integer>(2);
        pageInfo.put("current", curPage);
        pageInfo.put("pageSize", 1000);
        inputParams.put("pagination", pageInfo);
        return SerializationUtils.toJsonString(inputParams);
    }

    private List<DynamicObject> parseResult(JSONObject resultJson) {
        JSONArray jsonArr;
        Map<Long, Object[]> qaInfo;
        ArrayList<DynamicObject> qaLogs = new ArrayList<DynamicObject>(1000);
        JSONObject data = resultJson.getJSONObject("data");
        if (this.totalPage == null) {
            JSONObject pageInfo = data.getJSONObject("pagination");
            int total = pageInfo.getIntValue("total");
            if (total == 0) {
                this.totalPage = 0;
                return qaLogs;
            }
            this.totalPage = total / 1000 + 1;
        }
        if ((qaInfo = this.getKnowledgeInfoByAiQaIds(jsonArr = data.getJSONArray("list"))).isEmpty()) {
            log.warn(String.format(" qaInfo is empty! inputParams = %s, totalPage = %s", this.buildInputParams(data.getIntValue("current")), this.totalPage));
            return qaLogs;
        }
        Map<String, Long> kdccUserIds = this.convert2KDCCUserIds(jsonArr);
        for (Object obj : jsonArr) {
            JSONObject jsonObj = (JSONObject)obj;
            String terminalApp = jsonObj.getString("entranceType");
            Object[] knowlInfo = qaInfo.get(jsonObj.getLong("intentionId"));
            if (knowlInfo == null) continue;
            DynamicObject qaLog = BusinessDataServiceHelper.newDynamicObject((String)qaLogEntity);
            qaLog.set("knowledge", knowlInfo[0]);
            qaLog.set("sscid", knowlInfo[1]);
            Long userId = 0L;
            if (TerminalAppEnum.PC_CHATBOT.name().equals(terminalApp) || TerminalAppEnum.CQ_CHATBOT.name().equals(terminalApp)) {
                userId = jsonObj.getLongValue("userId");
            } else if (TerminalAppEnum.YZJ_CHATBOT.name().equals(terminalApp) || TerminalAppEnum.NATIVE_CHATBOT.name().equals(terminalApp) || TerminalAppEnum.APP_CHATBOT.name().equals(terminalApp)) {
                userId = kdccUserIds.get(jsonObj.getString("openId"));
                if (userId == null) {
                    userId = 0L;
                    log.warn("\u672a\u627e\u5230\u4e91\u4e4b\u5bb6openId\u4e3a" + jsonObj.getString("openId") + "\u7684\u82cd\u7a79\u7528\u6237");
                }
            } else {
                log.info("\u672a\u77e5\u7ec8\u7aef\uff1a" + terminalApp);
            }
            qaLog.set("entrancetype", (Object)terminalApp);
            qaLog.set("askuser", (Object)userId);
            qaLog.set("askusername", (Object)jsonObj.getString("userName"));
            qaLog.set("input", (Object)jsonObj.getString("input"));
            String replay = jsonObj.getString("replay");
            if (StringUtils.isNotEmpty((String)replay)) {
                qaLog.set("replay_tag", (Object)replay);
                if (replay.length() > 255) {
                    replay = replay.substring(0, 255);
                }
                qaLog.set("replay", (Object)replay);
            }
            qaLog.set("asktime", (Object)jsonObj.getDate("time"));
            qaLog.set("triggerkeyword", (Object)jsonObj.getString("keywordString"));
            qaLog.set("feedback", (Object)jsonObj.getString("feedback"));
            qaLogs.add(qaLog);
        }
        return qaLogs;
    }

    private Map<Long, Object[]> getKnowledgeInfoByAiQaIds(JSONArray jsonArr) {
        HashSet aiQAIds = new HashSet(64);
        jsonArr.forEach(p -> {
            JSONObject jsonObj = (JSONObject)p;
            aiQAIds.add(jsonObj.getLong("intentionId"));
        });
        HashMap<Long, Object[]> qaInfo = new HashMap<Long, Object[]>(64);
        QFilter aiQAIdFil = new QFilter("aiquestionid", "in", aiQAIds);
        String algoKey = ((Object)((Object)this)).getClass().getName() + ".getKnowledgeInfoByAiQaIds()";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"som_knowledge_info", (String)"id,area.createorg.id sscid,aiquestionid", (QFilter[])new QFilter[]{aiQAIdFil}, null);){
            for (Row row : dataSet) {
                Long[] tempArr = new Long[]{row.getLong("id"), row.getLong("sscid")};
                qaInfo.put(row.getLong("aiquestionid"), tempArr);
            }
        }
        return qaInfo;
    }

    private Map<String, Long> convert2KDCCUserIds(JSONArray jsonArr) {
        HashSet openIds = new HashSet(64);
        jsonArr.forEach(p -> {
            JSONObject jsonObj = (JSONObject)p;
            String terminalApp = jsonObj.getString("entranceType");
            if (TerminalAppEnum.YZJ_CHATBOT.toString().equals(terminalApp) || TerminalAppEnum.NATIVE_CHATBOT.toString().equals(terminalApp) || TerminalAppEnum.APP_CHATBOT.name().equals(terminalApp)) {
                openIds.add(jsonObj.getString("openId"));
            }
        });
        HashMap<String, Long> kdccUserIds = new HashMap<String, Long>(64);
        if (openIds.isEmpty()) {
            return kdccUserIds;
        }
        QFilter openIdFil = new QFilter("useropenid", "in", openIds);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "convert2KDCCUserId()"), (String)"bos_user", (String)"id, useropenid", (QFilter[])new QFilter[]{openIdFil}, null);){
            for (Row row : ds) {
                kdccUserIds.put(row.getString("useropenid"), row.getLong("id"));
            }
        }
        return kdccUserIds;
    }
}

