/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.smartqualitycheck;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.task.common.QualityCheckSchemeUtil;
import kd.ssc.task.common.smartscheme.ExecuteModeEnum;
import kd.ssc.task.common.smartscheme.SamplingMethodEnum;
import kd.ssc.task.formplugin.util.SscUtil;
import kd.ssc.task.util.SscLicenseUtil;

public class SmartSchemeManagementListPlugin
extends AbstractListPlugin
implements ItemClickListener,
FilterContainerInitListener,
HyperLinkClickListener,
SearchClickListener,
SetFilterListener,
CreateListDataProviderListener {
    private static final String systemType = "ssc-task-formplugin";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addSetFilterListener((SetFilterListener)this);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.setBillFormId("task_smartsamplelibrary");
        fc.addFilterContainerInitListener((FilterContainerInitListener)this);
        fc.addSearchClickListener((SearchClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"algorithmdetail"});
        Button edit_btn = (Button)this.getView().getControl("edit_btn");
        edit_btn.addClickListener((ClickListener)this);
        Button implement_btn = (Button)this.getView().getControl("implement_btn");
        implement_btn.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void filterContainerInit(FilterContainerInitEvent event) {
        List comFilters = event.getCommonFilterColumns();
        for (FilterColumn column : comFilters) {
            BillList billListAp;
            CommonFilterColumn comFilter = (CommonFilterColumn)column;
            if (!comFilter.getFieldName().equals("smartcheckscheme.ssccenter.name")) continue;
            List defaultValues = comFilter.getDefaultValues();
            List comboItems = comFilter.getComboItems();
            if ((defaultValues == null || defaultValues.isEmpty()) && comboItems != null && !comboItems.isEmpty()) {
                comFilter.setDefaultValue(((ComboItem)comboItems.get(0)).getValue());
            }
            String ssc = this.getPageCache().get("ssc");
            if (this.getPageCache().get("ssc") == null) {
                this.getPageCache().put("ssc", comFilter.getDefaultValues().get(0) + "");
            } else {
                comFilter.setDefaultValue(ssc);
            }
            if ((billListAp = (BillList)this.getControl("billlistap")) == null) continue;
            billListAp.clearSelection();
        }
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dynObjs = super.getData(start, limit);
                String selectFields = super.getQueryBuilder().getSelectFields();
                if (!selectFields.contains("state")) {
                    return dynObjs;
                }
                dynObjs.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("cmplrate", String.class, null));
                dynObjs.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("reformrate", String.class, null));
                DecimalFormat format = new DecimalFormat("#%");
                for (DynamicObject library : dynObjs) {
                    BigDecimal cmplNum = BigDecimal.valueOf(library.getLong("completednum"));
                    BigDecimal totalNum = BigDecimal.valueOf(library.getInt("totalnum"));
                    BigDecimal reformNum = BigDecimal.valueOf(library.getInt("reformnum"));
                    if (totalNum.compareTo(BigDecimal.ZERO) != 0) {
                        BigDecimal reformrate = reformNum.divide(totalNum, 2, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
                        library.set("cmplrate", (Object)format.format(cmplNum.divide(totalNum, 2, RoundingMode.HALF_UP)));
                        library.set("reformrate", (Object)format.format(reformNum.divide(totalNum, 2, RoundingMode.HALF_UP)));
                        String schemeReformRate = library.getString("smartcheckscheme.reformrate");
                        if (reformrate.compareTo(new BigDecimal(schemeReformRate)) > 0) {
                            library.set("description", (Object)ResManager.loadKDString((String)"\u6574\u6539\u7387\u8fc7\u9ad8\uff0c\u5efa\u8bae\u8fdb\u884c\u4e8c\u6b21\u62bd\u68c0", (String)"SmartSchemeManagementListPlugin_9", (String)SmartSchemeManagementListPlugin.systemType, (Object[])new Object[0]));
                            continue;
                        }
                        library.set("description", (Object)"");
                        continue;
                    }
                    library.set("cmplrate", (Object)"--");
                    library.set("reformrate", (Object)"--");
                    library.set("description", (Object)"");
                }
                return dynObjs;
            }
        });
    }

    public void click(SearchClickEvent event) {
        Map currentCommonFilter = event.getCurrentCommonFilter();
        if (((List)currentCommonFilter.get("FieldName")).contains("smartcheckscheme.ssccenter.id")) {
            this.getPageCache().put("ssc", ((List)currentCommonFilter.get("Value")).get(0) + "");
            this.initScheme();
        } else if (((List)currentCommonFilter.get("FieldName")).contains("createtime")) {
            QFilter createTimeFilter = event.getQFilter("createtime");
            if (createTimeFilter != null) {
                this.getPageCache().put("createtimefilter", createTimeFilter.toSerializedString());
            } else {
                this.getPageCache().remove("createtimefilter");
            }
        } else if (((List)currentCommonFilter.get("FieldName")).contains("state")) {
            QFilter stateFilter = event.getQFilter("state");
            if (stateFilter != null) {
                this.getPageCache().put("stateFilter", stateFilter.toSerializedString());
            } else {
                this.getPageCache().remove("stateFilter");
            }
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        List filters = event.getQFilters();
        String ssc = this.getPageCache().get("ssc");
        String createTimeFilter = this.getPageCache().get("createtimefilter");
        String stateFilter = this.getPageCache().get("stateFilter");
        QFilter qFilter = new QFilter("smartcheckscheme.ssccenter.id", "=", (Object)Long.parseLong(ssc));
        if (StringUtils.isNotBlank((CharSequence)createTimeFilter)) {
            qFilter.and(QFilter.fromSerializedString((String)createTimeFilter));
        }
        if (StringUtils.isNotBlank((CharSequence)stateFilter)) {
            qFilter.and(QFilter.fromSerializedString((String)stateFilter));
        }
        filters.add(qFilter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initScheme();
    }

    public void click(EventObject e) {
        super.click(e);
        String clickKey = ((Control)e.getSource()).getKey();
        if (clickKey.equals("algorithmdetail")) {
            ReportShowParameter reportShowParameter = new ReportShowParameter();
            reportShowParameter.setFormId("task_smartschemealgorithm");
            reportShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm((FormShowParameter)reportShowParameter);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String clickKey = event.getFieldName();
        if (clickKey.equals("number")) {
            this.openQualityManagement(event);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        if (event.getOperationResult() != null && event.getOperationResult().isSuccess()) {
            BillList billList = (BillList)this.getControl("billlistap");
            switch (event.getOperateKey()) {
                case "reimplement": {
                    ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                    if (selectedRows == null || selectedRows.size() == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60a8\u8981\u6267\u884c\u7684\u4e00\u6761\u6570\u636e\u3002", (String)"SmartSchemeManagementListPlugin_12", (String)systemType, (Object[])new Object[0]));
                        return;
                    }
                    if (selectedRows.size() > 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u53ea\u80fd\u6267\u884c\u4e00\u4e2a\u8d28\u68c0\u65b9\u6848\u3002", (String)"SmartSchemeManagementListPlugin_13", (String)systemType, (Object[])new Object[0]));
                        return;
                    }
                    ConfirmCallBackListener reimplement = new ConfirmCallBackListener("reimplement", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u7acb\u5373\u6267\u884c\u5c06\u4ea7\u751f\u8d28\u68c0\u4efb\u52a1\uff0c\u786e\u8ba4\u6267\u884c\u5417\uff1f", (String)"SmartSchemeManagementListPlugin_1", (String)systemType, (Object[])new Object[0]), MessageBoxOptions.OKCancel, reimplement);
                    break;
                }
                case "implement": {
                    if (StringUtils.isBlank((CharSequence)(this.getModel().getValue("smartcheckscheme") + ""))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7f16\u8f91\u667a\u80fd\u8d28\u68c0\u65b9\u6848\u3002", (String)"SmartSchemeManagementListPlugin_3", (String)systemType, (Object[])new Object[0]));
                        return;
                    }
                    ConfirmCallBackListener implementConfirm = new ConfirmCallBackListener("implement", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u7acb\u5373\u6267\u884c\u5c06\u4ea7\u751f\u8d28\u68c0\u4efb\u52a1\uff0c\u786e\u8ba4\u6267\u884c\u5417\uff1f", (String)"SmartSchemeManagementListPlugin_1", (String)systemType, (Object[])new Object[0]), MessageBoxOptions.OKCancel, implementConfirm);
                    break;
                }
                case "refresh": {
                    this.initScheme();
                    billList.clearSelection();
                    billList.refresh();
                    break;
                }
                case "edit": {
                    this.editScheme();
                    break;
                }
                case "schemedetail": {
                    ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                    if (selectedRows == null || selectedRows.size() == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60a8\u8981\u67e5\u770b\u7684\u4e00\u6761\u6570\u636e\u3002", (String)"SmartSchemeManagementListPlugin_11", (String)systemType, (Object[])new Object[0]));
                        return;
                    }
                    if (selectedRows.size() > 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u53ea\u80fd\u67e5\u770b\u4e00\u4e2a\u8d28\u68c0\u65b9\u6848\u3002", (String)"SmartSchemeManagementListPlugin_7", (String)systemType, (Object[])new Object[0]));
                        return;
                    }
                    Object selectedLib = selectedRows.get(0).getPrimaryKeyValue();
                    DynamicObject lib = BusinessDataServiceHelper.loadSingle((Object)selectedLib, (String)"task_qualitysamplelibrary");
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setFormId("task_smartscheme_setting");
                    showParameter.setCustomParam("smartcheckscheme", (Object)(lib.get("smartcheckscheme.id") + ""));
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    this.getView().showForm(showParameter);
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (event.getActionId().equals("refreshscheme")) {
            this.initScheme();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent arg0) {
        super.confirmCallBack(arg0);
        if ("reimplement".equalsIgnoreCase(arg0.getCallBackId()) && MessageBoxResult.Yes.equals((Object)arg0.getResult())) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            Object selectedLib = selectedRows.get(0).getPrimaryKeyValue();
            DynamicObject library = BusinessDataServiceHelper.loadSingle((Object)selectedLib, (String)"task_qualitysamplelibrary");
            this.executeCheck(library.get("smartcheckscheme.id") + "");
        }
        if ("implement".equalsIgnoreCase(arg0.getCallBackId()) && MessageBoxResult.Yes.equals((Object)arg0.getResult())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"implement_btn"});
            String smartSchemeId = this.getModel().getValue("smartcheckscheme") + "";
            this.executeCheck(smartSchemeId);
        }
    }

    private void executeCheck(String smartSchemeId) {
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(smartSchemeId), (String)"task_smartcheckscheme");
        Map<String, Object> result = QualityCheckSchemeUtil.qualityCheckByImplement(scheme, true);
        if (result == null || result.isEmpty()) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"implement_btn"});
            return;
        }
        int num = Integer.parseInt(result.get("num") + "");
        if (num > -1) {
            String message = String.format(ResManager.loadKDString((String)"\u667a\u80fd\u65b9\u6848\u5df2\u7ecf\u6267\u884c\u7ed3\u675f\uff0c\u5171\u751f\u6210%d\u6761\u8d28\u68c0\u4efb\u52a1\u3002", (String)"SmartSchemeManagementListPlugin_5", (String)systemType, (Object[])new Object[0]), num);
            this.getView().showMessage(message);
            this.initScheme();
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
            this.getView().setEnable(Boolean.TRUE, new String[]{"implement_btn"});
        } else {
            this.getView().showErrorNotification(result.get("error") + "");
            this.getView().setEnable(Boolean.TRUE, new String[]{"implement_btn"});
        }
    }

    private void initScheme() {
        String sscId = this.getPageCache().get("ssc");
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and(new QFilter("ssccenter", "=", (Object)Long.parseLong(sscId)));
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((String)"task_smartcheckscheme", (String)"id,samplingmethod,executemode,status,taskbill", (QFilter[])new QFilter[]{filter});
        if (scheme != null) {
            Label samplingMethodLabel = (Label)this.getControl("samplingmethod");
            samplingMethodLabel.setText(SamplingMethodEnum.getName(scheme.getString("samplingmethod")));
            Label executeModeLabel = (Label)this.getControl("executemode");
            executeModeLabel.setText(ExecuteModeEnum.getName(scheme.getString("executemode")));
            Label statusLabel = (Label)this.getControl("status");
            statusLabel.setText(ResManager.loadKDString((String)"\u53ef\u7528", (String)"SmartSchemeManagementListPlugin_14", (String)systemType, (Object[])new Object[0]));
            this.getModel().setValue("smartcheckscheme", scheme.get("id"));
            StringBuilder taskBillsName = new StringBuilder();
            scheme.getDynamicObjectCollection("taskbill").forEach(bill -> {
                if (bill.get("fbasedataid") != null) {
                    taskBillsName.append(((DynamicObject)bill.get("fbasedataid")).getLocaleString("name").getLocaleValue()).append(';');
                }
            });
            if (taskBillsName.length() > 0) {
                Label taskBillLabel = (Label)this.getControl("taskbill");
                taskBillLabel.setText(taskBillsName.substring(0, taskBillsName.length() - 1));
            }
        } else {
            Label samplingMethodLabel = (Label)this.getControl("samplingmethod");
            samplingMethodLabel.setText("");
            Label executeModeLabel = (Label)this.getControl("executemode");
            executeModeLabel.setText("");
            Label statusLabel = (Label)this.getControl("status");
            statusLabel.setText("");
            this.getModel().setValue("smartcheckscheme", (Object)"");
            Label taskBillLabel = (Label)this.getControl("taskbill");
            taskBillLabel.setText("");
        }
    }

    private void editScheme() {
        OperationStatus status;
        String smartCheckScheme = this.getModel().getValue("smartcheckscheme") + "";
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setCustomParam("ssc", (Object)this.getPageCache().get("ssc"));
        if (StringUtils.isNotBlank((CharSequence)smartCheckScheme)) {
            QFilter filter = new QFilter("smartcheckscheme", "=", (Object)Long.parseLong(smartCheckScheme));
            boolean exist = QueryServiceHelper.exists((String)"task_qualitysamplelibrary", (QFilter[])new QFilter[]{filter});
            if (exist) {
                status = OperationStatus.ADDNEW;
            } else {
                status = OperationStatus.EDIT;
                baseShowParameter.setPkId((Object)Long.parseLong(smartCheckScheme));
            }
        } else {
            status = OperationStatus.ADDNEW;
        }
        baseShowParameter.setFormId("task_smartcheckscheme");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(status);
        CloseCallBack close = new CloseCallBack((IFormPlugin)this, "refreshscheme");
        baseShowParameter.setCloseCallBack(close);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void openQualityManagement(HyperLinkClickEvent event) {
        ListSelectedRow row = this.getSelectedRow(event.getRowIndex());
        if (row == null) {
            return;
        }
        Object libId = row.getPrimaryKeyValue();
        DynamicObject library = BusinessDataServiceHelper.loadSingle((Object)libId, (String)"task_qualitysamplelibrary");
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        String sampleLibNumber = library.getString("number");
        String sampleLibState = library.getString("state");
        DynamicObject checkScheme = (DynamicObject)library.get("smartcheckscheme");
        String qualitychecktasktype = checkScheme.getString("qualitychecktasktype.id");
        String checkschemename = checkScheme.getString("name");
        Long sscId = checkScheme.getLong("ssccenter.id");
        List<Long> sscIds = Collections.singletonList(sscId);
        String poolType = QualityCheckSchemeUtil.stateTransfer(sampleLibState);
        String billFormId = "task_task";
        if (TaskPoolTypeEnum.COMPLETE.getValue().equals(poolType)) {
            billFormId = "task_taskhistory";
        }
        params.put("sampleLibid", libId + "");
        params.put("samplelibnumber", sampleLibNumber);
        params.put("sampleLibState", sampleLibState);
        params.put("pooltype", Collections.singletonList(poolType));
        params.put("qualitysscid", sscIds);
        params.put("checkschemeid", "0");
        params.put("checkschemename", checkschemename);
        params.put("qualitychecktasktype", qualitychecktasktype);
        params.put("sources", "qualitysamplelibrary");
        params.put("billformid", billFormId);
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setCustomParams(params);
        listShowParameter.setCustomParam("issmart", (Object)"1");
        listShowParameter.setBillFormId(billFormId);
        listShowParameter.setFormId("task_doqualitymanagement");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u8d28\u68c0\u4efb\u52a1\u7ba1\u7406", (String)"QualitySampleLibraryListPlugin_18", (String)systemType, (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private ListSelectedRow getSelectedRow(int selectedIndex) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60a8\u8981\u6253\u5f00\u7684\u4e00\u6761\u6570\u636e\u3002", (String)"SmartSchemeManagementListPlugin_10", (String)systemType, (Object[])new Object[0]));
            return null;
        }
        for (int i = 0; i < selectedRows.size(); ++i) {
            ListSelectedRow listSelectedRow = selectedRows.get(i);
            int rowKey = listSelectedRow.getRowKey();
            if (selectedIndex != rowKey) continue;
            return selectedRows.get(i);
        }
        return null;
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        List<Long> allPermSSC;
        super.preOpenForm(e);
        String version = LicenseServiceHelper.getProductVersion();
        if ("5.0".equals(version)) {
            SscLicenseUtil.checkGroupLicense5_0((PreOpenFormEventArgs)e, (String)"task_smartcheckschemelist");
        }
        if ((allPermSSC = SscUtil.getAllPermSSC(RequestContext.get().getCurrUserId(), "task_smartcheckschemelist", e.getFormShowParameter().getAppId())).size() == 0) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u6743\u9650\u3002", (String)"SmartSchemeManagementListPlugin_16", (String)systemType, (Object[])new Object[0]));
        }
    }
}

