/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.taskpool;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.business.helper.OrgRelationQueryHelper;
import kd.ssc.task.business.task.OrgF7ViewShowHelper;
import kd.ssc.task.formplugin.taskpool.DoneAction;
import kd.ssc.task.formplugin.taskpool.Factory;
import kd.ssc.task.formplugin.taskpool.ProcessAction;
import kd.ssc.task.formplugin.taskpool.baseclass.Action;
import kd.ssc.task.formplugin.taskpool.baseclass.CommonTaskPool;
import org.apache.commons.lang3.StringUtils;

public class AllTask
extends CommonTaskPool {
    private static final Log log = LogFactory.getLog(AllTask.class);
    List<?> billTypeClass;
    Long billType;
    Long taskType;
    boolean isUseImage = false;

    public AllTask(long sscId, Action action) {
        super(sscId, action);
    }

    @Override
    public void initialize() {
        super.initialize();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        this.billTypeClass = (List)customParams.get("showbillclassid");
        this.billType = (Long)customParams.get("showbilltype");
        this.taskType = (Long)customParams.get("showtasktypeid");
        if (customParams.get("PAMAM_ISUSEIMAGE") != null) {
            this.isUseImage = (Boolean)customParams.get("PAMAM_ISUSEIMAGE");
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addListRowSortListeners(xx -> {
            String sortInfo = billList.getEntryState().getSortInfo();
            if (StringUtils.isNotEmpty((CharSequence)sortInfo)) {
                if (sortInfo.contains("tasklevelid.name desc")) {
                    String newSortInfo = sortInfo.replaceAll("tasklevelid.name desc", "tasklevelid.priority asc");
                    billList.getEntryState().setSortInfo(newSortInfo);
                } else if (sortInfo.contains("tasklevelid.name asc")) {
                    String newSortInfo = sortInfo.replaceAll("tasklevelid.name asc", "tasklevelid.priority desc");
                    billList.getEntryState().setSortInfo(newSortInfo);
                }
            }
        });
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        this.action.setFilter(e);
        List qFilters = e.getQFilters();
        qFilters.add(new QFilter("state", "!=", (Object)String.valueOf(TaskStateEnum.CANCEL.getValue())));
        qFilters.add(new QFilter("personid.id", "=", (Object)RequestContext.get().getCurrUserId()));
        qFilters.add(new QFilter("sscid", "=", (Object)this.sscId));
        if (this.billTypeClass != null && !this.billTypeClass.isEmpty()) {
            qFilters.add(new QFilter("billtype.group", "in", this.billTypeClass));
        }
        if (this.billType != null) {
            qFilters.add(new QFilter("billtype.id", "=", (Object)this.billType));
        }
        if (this.taskType != null) {
            qFilters.add(new QFilter("tasktypeid.id", "=", (Object)this.taskType));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String name = args.getFieldName();
        List qfilters = args.getQfilters();
        if (this.sscId > 0L) {
            this.extractedFilter(name, qfilters);
        }
        if ("orgid.id".equals(name)) {
            OrgF7ViewShowHelper.beforeFilterContainerF7((BeforeFilterF7SelectEvent)args, (Long)this.sscId);
        }
    }

    private void extractedFilter(String name, List<QFilter> qfilters) {
        if ("orgid.name".equals(name)) {
            List deputeOrgIDList = OrgRelationQueryHelper.getFromOrgList((long)this.sscId);
            qfilters.add(new QFilter("id", "in", (Object)deputeOrgIDList));
        } else if ("tasktypeid.name".equals(name)) {
            qfilters.add(new QFilter("orgfield", "=", (Object)this.sscId));
            if (this.taskType != null) {
                qfilters.add(new QFilter("id", "=", (Object)this.taskType));
            }
        } else if ("billtype.name".equals(name)) {
            if (this.billTypeClass != null && !this.billTypeClass.isEmpty()) {
                qfilters.add(new QFilter("group", "in", this.billTypeClass));
            }
            if (this.billType != null) {
                qfilters.add(new QFilter("id", "=", (Object)this.billType));
            }
            qfilters.add(new QFilter("ssccenter.id", "=", (Object)this.sscId));
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        List qFilters = args.getQFilters();
        this.extractedFilter(fieldName, qFilters);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        this.setStateFilter(null);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        QFilter tasktypeidId = args.getQFilter("tasktypeid.id");
        QFilter stateQFilter = args.getQFilter("state");
        QFilter billtypeQFilter = args.getQFilter("billtype.id");
        AllTask taskByTasktype = Factory.getTaskByTasktype((AllTask)this.primitivePlugin, tasktypeidId, stateQFilter);
        if (taskByTasktype != (AllTask)this.primitivePlugin) {
            this.changePlugin(taskByTasktype);
        }
        taskByTasktype.setUseImage(billtypeQFilter);
        taskByTasktype.setStateFilter(args);
        taskByTasktype.initStateValue(args);
        this.changeBillListAction(taskByTasktype);
        taskByTasktype.changeListAndButton();
    }

    protected void setStateFilter(FilterContainerSearchClickArgs args) {
        Map<String, FilterColumn> filterContainer = this.getFilterContainer(CommonTaskPool.FilterType.Common);
        CommonFilterColumn stateFilter = (CommonFilterColumn)filterContainer.get("state");
        if (stateFilter != null) {
            List comboItems = stateFilter.getComboItems();
            stateFilter.setMustInput(false);
            comboItems.clear();
            comboItems.addAll(this.getInitStateFilterValue());
        }
    }

    protected void initStateValue(FilterContainerSearchClickArgs args) {
        if (args != null) {
            List objectList;
            Object o;
            Set collect = this.getInitStateFilterValue().stream().map(ComboItem::getValue).collect(Collectors.toSet());
            Map filterValues = args.getFilterValues();
            List customfilter = (List)filterValues.get("customfilter");
            if (customfilter == null) {
                return;
            }
            Optional<Map> first = customfilter.stream().filter(x -> ((List)x.get("FieldName")).get(0).equals("state")).findFirst();
            if (first.isPresent() && !collect.contains(o = (objectList = (List)first.get().get("Value")).get(0))) {
                objectList.clear();
                objectList.add("");
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.changeListAndButton();
    }

    protected void changeListAndButton() {
        if (this.action instanceof ProcessAction) {
            this.billListChangeBillFormId("task_dypool_approve");
        } else {
            this.billListChangeBillFormId("task_dypool_approvedone");
        }
    }

    public boolean isUseImage() {
        return this.isUseImage;
    }

    protected List<ComboItem> getInitStateFilterValue() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        if (this.primitiveAction instanceof DoneAction) {
            comboItems.add(new ComboItem(new LocaleString(TaskStateEnum.AUDIT_PASSED.getName()), TaskStateEnum.AUDIT_PASSED.getValue()));
            comboItems.add(new ComboItem(new LocaleString(TaskStateEnum.AUDIT_NOTPASSED.getName()), TaskStateEnum.AUDIT_NOTPASSED.getValue()));
            if (this.getSscType().equals("3")) {
                comboItems.add(new ComboItem(new LocaleString(TaskStateEnum.PROCESSED.getName()), TaskStateEnum.PROCESSED.getValue()));
                comboItems.add(new ComboItem(new LocaleString(TaskStateEnum.TERMINATED.getName()), TaskStateEnum.TERMINATED.getValue()));
            }
        } else {
            comboItems.add(new ComboItem(new LocaleString(TaskStateEnum.TO_BE_AUDIT.getName()), TaskStateEnum.TO_BE_AUDIT.getValue()));
            comboItems.add(new ComboItem(new LocaleString(TaskStateEnum.PAUSE.getName()), TaskStateEnum.PAUSE.getValue()));
            if (this.isUseImage) {
                comboItems.add(new ComboItem(new LocaleString(TaskStateEnum.REUPLOAD_IMAGE.getName()), TaskStateEnum.REUPLOAD_IMAGE.getValue()));
                comboItems.add(new ComboItem(new LocaleString(TaskStateEnum.RESCAN.getName()), TaskStateEnum.RESCAN.getValue()));
            }
        }
        return comboItems;
    }

    public void destory() {
        super.destory();
        this.getPageCache().put("sscid.id", String.valueOf(this.sscId));
        if (this.action instanceof DoneAction) {
            this.getPageCache().put("pooltype", TaskPoolTypeEnum.COMPLETE.getValue());
        } else {
            this.getPageCache().put("pooltype", TaskPoolTypeEnum.PROCESSING.getValue());
        }
    }

    public void setUseImage(QFilter billtypeQFilter) {
        if (billtypeQFilter != null) {
            Object value = billtypeQFilter.getValue();
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", value), new QFilter("isuseimage", "=", (Object)true)};
            this.isUseImage = QueryServiceHelper.exists((String)"task_taskbill", (QFilter[])qFilters);
        }
    }

    protected void changeBillListAction(AllTask task) {
        BillList billlistap = (BillList)task.getControl("billlistap");
        if (billlistap instanceof CommonTaskPool.AllTaskBilllist) {
            ((CommonTaskPool.AllTaskBilllist)billlistap).setAction(task.action);
        }
    }
}

