/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.taskpool;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.formplugin.taskpool.AllTask;
import kd.ssc.task.formplugin.taskpool.DoneAction;
import kd.ssc.task.formplugin.taskpool.ProcessAction;
import kd.ssc.task.formplugin.taskpool.baseclass.Action;
import kd.ssc.task.formplugin.taskpool.baseclass.CommonTaskPool;
import org.apache.commons.lang3.ArrayUtils;

public class QualityTask
extends AllTask {
    private static final Log log = LogFactory.getLog(QualityTask.class);
    private static final String[] approvalFast = new String[]{"subject", "orignalperson.name", "reformperson.name"};

    public QualityTask(long sscId, Action action) {
        super(sscId, action);
    }

    @Override
    protected void changeListAndButton() {
        if (this.action instanceof DoneAction) {
            this.billListChangeBillFormId("task_dypool_zj_done");
        } else {
            this.billListChangeBillFormId("task_dypool_zj");
        }
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        boolean isRemove = e.getQFilters().removeIf(p -> p.getProperty().equals("state") && TaskStateEnum.TO_BE_TRACKED.getValue().equals(p.getValue()));
        ArrayList<QFilter> list = new ArrayList<QFilter>(1);
        list.add(new QFilter("qualitysamplelibrary.id", ">", (Object)0L));
        QFilter[] qFilters = new QFilter[]{new QFilter("ssccenter", "=", (Object)this.sscId)};
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"task_qualitycheckscheme", (String)"selectedorg", (QFilter[])qFilters);
        HashSet<Long> set = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : load) {
            DynamicObjectCollection selectedorg = dynamicObject.getDynamicObjectCollection("selectedorg");
            for (DynamicObject object : selectedorg) {
                set.add(object.getLong("fbasedataid_id"));
            }
        }
        list.add(new QFilter("orgid.id", "in", set));
        if (isRemove) {
            e.getQFilters().removeIf(p -> p.getProperty().equals("personid.id"));
            RequestContext requestContext = RequestContext.get();
            Long currentUserId = Long.valueOf(requestContext.getUserId());
            QFilter personFil = new QFilter("personid.id", "!=", (Object)currentUserId);
            QFilter quaResultFil = new QFilter("qualityresult", "=", (Object)Character.valueOf('0'));
            QFilter checkPersonFil = new QFilter("orignalperson", "=", (Object)currentUserId);
            QFilter reformPersonFil = new QFilter("reformperson", "=", (Object)currentUserId);
            personFil.and(quaResultFil).and(checkPersonFil.or(reformPersonFil));
            list.add(personFil);
        }
        e.getQFilters().addAll(list);
    }

    @Override
    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        if (!this.pluginHasChange) {
            if ("tasktypeid.name".equals(args.getFieldName())) {
                args.addCustomQFilter(new QFilter("qualityjudge", "=", (Object)"1"));
            }
            if ("orgid.name".equals(args.getFieldName())) {
                QFilter[] qFilters = new QFilter[]{new QFilter("ssccenter", "=", (Object)this.sscId)};
                DynamicObject[] load = BusinessDataServiceHelper.load((String)"task_qualitycheckscheme", (String)"selectedorg", (QFilter[])qFilters);
                HashSet<Long> set = new HashSet<Long>(16);
                for (DynamicObject dynamicObject : load) {
                    DynamicObjectCollection selectedorg = dynamicObject.getDynamicObjectCollection("selectedorg");
                    for (DynamicObject object : selectedorg) {
                        set.add(object.getLong("fbasedataid_id"));
                    }
                }
                args.addCustomQFilter(new QFilter("id", "in", set));
            }
        }
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if (!this.pluginHasChange) {
            List qfilters = args.getQfilters();
            if ("tasktypeid.name".equals(args.getFieldName())) {
                qfilters.add(new QFilter("qualityjudge", "!=", (Object)"1"));
            }
        }
    }

    @Override
    protected void setStateFilter(FilterContainerSearchClickArgs args) {
        QFilter stateQFilter;
        if (args != null && (stateQFilter = args.getQFilter("state")) != null && stateQFilter.getValue().equals(TaskStateEnum.TO_BE_TRACKED.getValue())) {
            this.setAction(new ProcessAction());
        }
        super.setStateFilter(args);
        Map<String, FilterColumn> filterContainer = this.getFilterContainer(CommonTaskPool.FilterType.Common);
        CommonFilterColumn stateFilter = (CommonFilterColumn)filterContainer.get("state");
        if (stateFilter != null && this.primitiveAction instanceof DoneAction) {
            stateFilter.setMustInput(true);
            stateFilter.setDefaultValue(TaskStateEnum.QUA_CHECK_COMPLETED.getValue());
        }
    }

    @Override
    protected void initStateValue(FilterContainerSearchClickArgs args) {
        if (args != null) {
            Set collect = this.getInitStateFilterValue().stream().map(ComboItem::getValue).collect(Collectors.toSet());
            Map filterValues = args.getFilterValues();
            List customfilter = (List)filterValues.get("customfilter");
            if (customfilter == null) {
                return;
            }
            Optional<Map> first = customfilter.stream().filter(x -> ((List)x.get("FieldName")).get(0).equals("state")).findFirst();
            if (first.isPresent()) {
                List objectList = (List)first.get().get("Value");
                Object o = objectList.get(0);
                if (!collect.contains(o) && this.action instanceof ProcessAction) {
                    objectList.clear();
                    objectList.add("");
                } else if (!collect.contains(o) && this.action instanceof DoneAction) {
                    objectList.clear();
                    objectList.add(TaskStateEnum.QUA_CHECK_COMPLETED.getValue());
                }
            }
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List fastFilterColumns = args.getFastFilterColumns();
        fastFilterColumns.removeIf(p -> !ArrayUtils.contains((Object[])approvalFast, (Object)p.getFieldName()));
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        if (this.pluginHasChange) {
            super.filterContainerSearchClick(args);
        } else {
            QFilter state = args.getQFilter("state");
            QFilter billtypeQFilter = args.getQFilter("billtype.id");
            this.setUseImage(billtypeQFilter);
            ListView view = (ListView)this.getView();
            this.registerPlugin(view.getBillFormId());
            if (state != null && TaskStateEnum.TO_BE_TRACKED.getValue().equals(state.getValue())) {
                this.setAction(new ProcessAction());
                this.changeBillListAction(this);
                this.changePlugin(this);
            }
        }
    }

    @Override
    protected List<ComboItem> getInitStateFilterValue() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        if (this.primitiveAction instanceof DoneAction) {
            comboItems.add(new ComboItem(new LocaleString(TaskStateEnum.TO_BE_TRACKED.getName()), TaskStateEnum.TO_BE_TRACKED.getValue()));
            comboItems.add(new ComboItem(new LocaleString(TaskStateEnum.QUA_CHECK_COMPLETED.getName()), TaskStateEnum.QUA_CHECK_COMPLETED.getValue()));
        } else {
            comboItems.add(new ComboItem(new LocaleString(TaskStateEnum.CHECKING.getName()), TaskStateEnum.CHECKING.getValue()));
            comboItems.add(new ComboItem(new LocaleString(TaskStateEnum.RECTIFYING.getName()), TaskStateEnum.RECTIFYING.getValue()));
            comboItems.add(new ComboItem(new LocaleString(TaskStateEnum.REVIEW.getName()), TaskStateEnum.REVIEW.getValue()));
            comboItems.add(new ComboItem(new LocaleString(TaskStateEnum.PAUSE_CHECKING.getName()), TaskStateEnum.PAUSE_CHECKING.getValue()));
            comboItems.add(new ComboItem(new LocaleString(TaskStateEnum.PAUSE_RECTIFYING.getName()), TaskStateEnum.PAUSE_RECTIFYING.getValue()));
            comboItems.add(new ComboItem(new LocaleString(TaskStateEnum.PAUSE_REVIEW.getName()), TaskStateEnum.PAUSE_REVIEW.getValue()));
        }
        return comboItems;
    }
}

