/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.taskpool.helper;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class ShareAuthService {
    private static final Log LOGGER = LogFactory.getLog(ShareAuthService.class);
    private static final long SHARE_ORG = 12L;

    public static ShareAuthService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private Set<Long> getUserHasPerShareOrg(String entityName, String appId) {
        List allShareOrgList = OrgUnitServiceHelper.getAllOrgByViewId((long)12L, (boolean)false);
        LOGGER.info("ShareAuthService_getUserHasPerOrgId_{}_{}", (Object)entityName, (Object)allShareOrgList.size());
        HashSet<Long> allShareOrgSet = new HashSet<Long>(allShareOrgList);
        if (allShareOrgList.isEmpty()) {
            return new HashSet<Long>();
        }
        HasPermOrgResult hasOrg = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)String.valueOf(12L), (String)AppMetadataCache.getAppInfo((String)appId).getId(), (String)entityName, (String)"47150e89000000ac");
        if (hasOrg != null) {
            if (hasOrg.hasAllOrgPerm()) {
                LOGGER.info("ShareAuthService_hasAllOrgPerm");
                return allShareOrgSet;
            }
            List hasPermOrgList = hasOrg.getHasPermOrgs();
            if (hasPermOrgList != null && !hasPermOrgList.isEmpty()) {
                HashSet hasPermOrgSet = new HashSet(hasPermOrgList);
                HashSet<Long> resultSet = new HashSet<Long>(allShareOrgSet);
                resultSet.retainAll(hasPermOrgSet);
                return resultSet;
            }
        }
        return new HashSet<Long>();
    }

    public Set<Long> getShareOrgIdSet(String entityName, String appId) {
        String businessType = "2";
        if (StringUtils.isEmpty((String)appId)) {
            appId = "ssc";
        }
        if ("hstc".equals(appId)) {
            businessType = "3";
        }
        Set<Long> orgSet = this.getOrgSet(businessType);
        Set<Long> userHasPerShareOrg = this.getUserHasPerShareOrg(entityName, appId);
        orgSet.retainAll(userHasPerShareOrg);
        return orgSet;
    }

    private Set<Long> getOrgSet(String businessType) {
        QFilter type;
        if (StringUtils.isEmpty((String)businessType)) {
            return new HashSet<Long>();
        }
        if ("3".equals(businessType)) {
            type = new QFilter("sscbusinesstype", "=", (Object)businessType);
        } else {
            HashSet<String> set = new HashSet<String>();
            set.add("1");
            set.add("2");
            type = new QFilter("sscbusinesstype", "in", set);
        }
        DynamicObject[] dutyManageArr = BusinessDataServiceHelper.load((String)"ssc_dutymanage", (String)"id,sscorg.id", (QFilter[])new QFilter[]{type});
        if (dutyManageArr == null || dutyManageArr.length == 0) {
            return new HashSet<Long>();
        }
        return Arrays.stream(dutyManageArr).map(dd -> dd.getLong("sscorg.id")).collect(Collectors.toSet());
    }

    public long getUserHasPerOrgId(String entityName, String appId) {
        Set<Long> userHasPerShareOrg = this.getShareOrgIdSet(entityName, appId);
        if (userHasPerShareOrg.isEmpty()) {
            return 0L;
        }
        long userOrgID = RequestContext.get().getOrgId();
        if (userHasPerShareOrg.contains(userOrgID)) {
            return userOrgID;
        }
        return userHasPerShareOrg.stream().min(Long::compareTo).orElse(0L);
    }

    private static class InstanceHolder {
        private static final ShareAuthService INSTANCE = new ShareAuthService();

        private InstanceHolder() {
        }
    }
}

