/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ArtiCheckPointUtil {
    private static final Log logger = LogFactory.getLog(ArtiCheckPointUtil.class);

    @Deprecated
    public static void saveArtiCheckPointInfo(String key, String taskid, IDataModel model, Long historyId, boolean isFromTaskList, Long billTypeId, String tasktypeid) {
        Date nowDate = new Date();
        if (isFromTaskList) {
            DynamicObjectCollection artiCheckPoints;
            QFilter filter = new QFilter("taskid", "=", (Object)taskid);
            DynamicObject[] articheckpointrecords = BusinessDataServiceHelper.load((String)"task_articheckpointrecord", (String)"id,taskid,createtime", (QFilter[])new QFilter[]{filter});
            if (articheckpointrecords != null && articheckpointrecords.length > 0) {
                for (DynamicObject articheckpointrecord : articheckpointrecords) {
                    articheckpointrecord.set("taskid", (Object)historyId);
                    articheckpointrecord.set("createtime", (Object)nowDate);
                }
                SaveServiceHelper.save((DynamicObject[])articheckpointrecords);
                return;
            }
            DynamicObject taskDo = QueryServiceHelper.queryOne((String)"task_task", (String)"billid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskid)});
            if (taskDo == null) {
                taskDo = QueryServiceHelper.queryOne((String)"task_taskhistory", (String)"billid", (QFilter[])new QFilter[]{new QFilter("sourcetaskid", "=", (Object)taskid)});
            }
            if ((artiCheckPoints = ArtiCheckPointUtil.getArtiCheckPointByBillTypeId(billTypeId, tasktypeid, taskDo.get("billid"))) == null) {
                return;
            }
            ArrayList<DynamicObject> articheckpointlist = new ArrayList<DynamicObject>();
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"task_articheckpointrecord");
            for (DynamicObject artiCheckPoint : artiCheckPoints) {
                DynamicObject articheckpointitem = new DynamicObject((DynamicObjectType)dt);
                articheckpointitem.set("taskid", (Object)historyId.toString());
                articheckpointitem.set("articheckpoint", (Object)artiCheckPoint.getString("articheckpointid"));
                articheckpointitem.set("createtime", (Object)nowDate);
                if ("bar_pass".equals(key)) {
                    articheckpointitem.set("iscontented", (Object)Boolean.TRUE);
                } else {
                    articheckpointitem.set("iscontented", (Object)artiCheckPoint.getBoolean("articheckpointselected"));
                }
                articheckpointlist.add(articheckpointitem);
            }
            SaveServiceHelper.save((DynamicObject[])articheckpointlist.toArray(new DynamicObject[0]));
            return;
        }
        if (model == null) {
            return;
        }
        QFilter filter = new QFilter("taskid", "=", (Object)taskid);
        DynamicObjectCollection articheckpointrecords = QueryServiceHelper.query((String)"task_articheckpointrecord", (String)"id as articheckpointid,articheckpoint as articheckpointname,iscontented as articheckpointselected", (QFilter[])new QFilter[]{filter});
        if (articheckpointrecords != null && articheckpointrecords.size() > 0) {
            DeleteServiceHelper.delete((String)"task_articheckpointrecord", (QFilter[])new QFilter[]{filter});
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"task_articheckpointrecord");
        ArrayList<DynamicObject> articheckpointlist = new ArrayList<DynamicObject>();
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        if (entryentity == null || entryentity.size() == 0) {
            return;
        }
        for (DynamicObject entry : entryentity) {
            DynamicObject articheckpointitem = new DynamicObject((DynamicObjectType)dt);
            articheckpointitem.set("taskid", (Object)(historyId == null ? taskid : historyId.toString()));
            articheckpointitem.set("articheckpoint", (Object)entry.getString("articheckpointid"));
            articheckpointitem.set("createtime", (Object)nowDate);
            articheckpointitem.set("iscontented", entry.get("checkboxfield"));
            articheckpointlist.add(articheckpointitem);
        }
        SaveServiceHelper.save((DynamicObject[])articheckpointlist.toArray(new DynamicObject[0]));
    }

    public static boolean isArtiCheckPointSelected(IFormView view, IDataModel model) {
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        if (entryentity == null || entryentity.size() == 0) {
            return true;
        }
        for (DynamicObject entry : entryentity) {
            if (entry.getBoolean("checkboxfield")) continue;
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4eba\u5de5\u68c0\u67e5\u9879\u6ca1\u6709\u68c0\u67e5\u901a\u8fc7\uff0c\u8bf7\u5148\u68c0\u67e5\u901a\u8fc7\u540e\u5e76\u52fe\u9009\u3002", (String)"ArtiCheckPointUtil_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), entry.get("articheckpointname")));
            return false;
        }
        return true;
    }

    public static DynamicObjectCollection getArtiCheckPointByBillTypeId(Long billTypeId, String tasktypeid, Object billId) {
        if (StringUtils.isBlank((Object)billId)) {
            return null;
        }
        String entityName = "task_taskbill";
        String selectFields = "id,entryentity.childpkid as childpkid,bindbill.number as bindbillnumber";
        QFilter billTypeFilter = new QFilter("id", "=", (Object)billTypeId);
        QFilter taskTypeFilter = new QFilter("entryentity.tasktype", "=", (Object)Long.valueOf(tasktypeid));
        DynamicObject dynObjCol = QueryServiceHelper.queryOne((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{billTypeFilter, taskTypeFilter});
        if (dynObjCol == null) {
            return null;
        }
        Long childpkid = dynObjCol.getLong("childpkid");
        QFilter filter = new QFilter("id", "=", (Object)childpkid);
        QFilter filter1 = QFilter.isNotNull((String)"entryentityarticheck.articheck.id").and("entryentityarticheck.articheck.id", "!=", (Object)0L);
        DynamicObjectCollection articheckpointCollection = QueryServiceHelper.query((String)"task_taskbill_child", (String)"entryentityarticheck.articheck.id as articheckpointid,entryentityarticheck.articheck.name as articheckpointname,entryentityarticheck.articheck.isselected as articheckpointselected,entryentityarticheck.checkconditionjson_tag as checkconditionjson,entryentityarticheck.checkcondition as checkcondition", (QFilter[])new QFilter[]{filter, filter1});
        DynamicObjectCollection result = new DynamicObjectCollection();
        if (articheckpointCollection != null && !articheckpointCollection.isEmpty()) {
            for (DynamicObject dyo : articheckpointCollection) {
                if (!StringUtils.isBlank((CharSequence)dyo.getString("checkcondition")) && !ArtiCheckPointUtil.meetCondition(dynObjCol.getString("bindbillnumber"), dyo.getString("checkconditionjson"), billId)) continue;
                result.add((Object)dyo);
            }
        }
        return result.isEmpty() ? null : result;
    }

    public static QFilter analysisFilter(String entityNumber, String conditionJson) {
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)conditionJson, FilterCondition.class);
        FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumber), filterCondition, true);
        filterBuilder.buildFilter(false);
        return filterBuilder.getQFilter();
    }

    public static boolean isArtiCheckPointSelectedOfList(IFormView view, List<Long> taskIdList) {
        List taskIds = taskIdList.stream().map(id -> id + "").collect(Collectors.toList());
        QFilter taskFilter = new QFilter("taskid", "in", taskIds);
        QFilter taskbillchildFilter = QFilter.isNotNull((String)"entryentityarticheck.articheck.id").and("entryentityarticheck.articheck.id", "!=", (Object)0L);
        DynamicObjectCollection articheckpointrecords = QueryServiceHelper.query((String)"task_articheckpointrecord", (String)"iscontented,taskid", (QFilter[])new QFilter[]{taskFilter});
        if (articheckpointrecords != null && articheckpointrecords.size() > 0) {
            for (DynamicObject articheckpointrecord : articheckpointrecords) {
                taskIdList.remove(articheckpointrecord.getLong("taskid"));
                if (articheckpointrecord.getBoolean("iscontented")) continue;
                String subject = ArtiCheckPointUtil.getSubjectFromTask(articheckpointrecord.getString("taskid"));
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4eba\u5de5\u68c0\u67e5\u9879\u6ca1\u6709\u68c0\u67e5\u901a\u8fc7\uff0c\u8bf7\u5148\u68c0\u67e5\u901a\u8fc7\u540e\u5e76\u52fe\u9009\u3002", (String)"ArtiCheckPointUtil_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), subject));
                return false;
            }
            if (taskIdList.size() == 0) {
                return true;
            }
        }
        long count = 0L;
        ORM orm = ORM.create();
        try (DataSet taskRows = orm.queryDataSet("task_task", "task_task", "id as taskid,billtype,tasktypeid,subject,billid", new QFilter[]{new QFilter("id", "in", taskIdList)});
             DataSet billtypeRows = orm.queryDataSet("task_taskbill", "task_taskbill", "id as taskbillid,entryentity.tasktype as tasktype,entryentity.childpkid as childid,bindbill.number as bindbillnumber", null);
             DataSet childBilltypeRows = orm.queryDataSet("task_taskbill_child", "task_taskbill_child", "id as taskbillchildid,entryentityarticheck.articheck.isselected as articheckpointselected,entryentityarticheck.checkconditionjson_tag as checkconditionjson,entryentityarticheck.checkcondition as checkcondition", taskbillchildFilter.toArray());
             DataSet resultRows = taskRows.join(billtypeRows, JoinType.INNER).on("billtype", "taskbillid").on("tasktypeid", "tasktype").select(new String[]{"taskid", "subject", "childid", "billid", "bindbillnumber"}).finish().join(childBilltypeRows, JoinType.INNER).on("childid", "taskbillchildid").select(new String[]{"taskid", "subject", "billid", "bindbillnumber", "articheckpointselected", "checkconditionjson", "checkcondition"}).finish();){
            Iterator iterator = resultRows.iterator();
            while (true) {
                if (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    if (StringUtils.isNotBlank((CharSequence)row.getString("checkcondition")) && !ArtiCheckPointUtil.meetCondition(row.getString("bindbillnumber"), row.getString("checkconditionjson"), row.get("billid"))) continue;
                    ++count;
                    if (row.getBoolean("articheckpointselected").booleanValue()) continue;
                    view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4eba\u5de5\u68c0\u67e5\u9879\u6ca1\u6709\u68c0\u67e5\u901a\u8fc7\uff0c\u8bf7\u5148\u68c0\u67e5\u901a\u8fc7\u540e\u5e76\u52fe\u9009\u3002", (String)"ArtiCheckPointUtil_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), row.getString("subject")));
                    logger.info("count:" + count);
                    boolean bl = false;
                    return bl;
                    continue;
                }
                break;
            }
        }
        logger.info("count:" + count);
        return true;
    }

    private static String getSubjectFromTask(String taskid) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(taskid), (String)"task_task", (String)"subject");
        return dynamicObject.getString("subject");
    }

    private static boolean meetCondition(String bindEntityNumber, String conditionJson, Object billId) {
        QFilter qFilter = ArtiCheckPointUtil.analysisFilter(bindEntityNumber, conditionJson);
        try {
            billId = Long.parseLong(String.valueOf(billId));
        }
        catch (Exception exception) {
            // empty catch block
        }
        qFilter.and("id", "=", billId);
        return QueryServiceHelper.exists((String)bindEntityNumber, (QFilter[])qFilter.toArray());
    }
}

