/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.ssc.enums.TaskStateEnum;

public class IntelligentDataUtil {
    private static final Log log = LogFactory.getLog(IntelligentDataUtil.class);
    private static final String TASK_TASKHISTORY = "task_taskhistory";
    private static final String BOS_USER = "bos_user";
    private static final String BOS_ORG = "bos_org";
    private static final String TASK_TASKBILL = "task_taskbill";
    private static final String TASK_CREDITFILES = "task_creditfiles";
    private static final String TASK_TASKTYPE = "task_tasktype";
    private static final String TASK_STATECHANGEHIS = "task_statechangehis";
    private static final String SSC_INTELLIGENT_TMP = "ssc_intelligent_tmp";
    private static final String tripreqbill = "er_tripreqbill";
    private static final String dailyloanbill = "er_dailyloanbill";
    private static final String dailyreimbursebill = "er_dailyreimbursebill";
    private static final String tripreimbursebill = "er_tripreimbursebill";
    private static String algoKeyStr = IntelligentDataUtil.class.getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSet getData(List<Long> taskIds, String[] billTypeNumbers) {
        DataSet resultDs = null;
        try (DataSet ds = null;){
            DynamicObjectCollection coll = QueryServiceHelper.query((String)TASK_TASKBILL, (String)"id", (QFilter[])new QFilter[]{new QFilter("bindbill.number", "in", (Object)billTypeNumbers)});
            ArrayList<Object> billTypes = new ArrayList<Object>(50);
            if (coll != null && coll.size() > 0) {
                for (DynamicObject billtypeObj : coll) {
                    billTypes.add(billtypeObj.get("id"));
                }
            }
            String selectFields = "id as taskid,billnumber,autoprocess as isverifybill,month(taskcreatetime) as createmonth,tasktypeid.name as tasktype,billtype,billtype.name as billtypename,usergroup as auditorgroup,usergroup.name as usergroupname,billid,creator,personid as auditor,sscid";
            QFilter filter = new QFilter("id", "in", taskIds);
            filter.and("billtype.id", "in", billTypes);
            String orderBys = null;
            ds = QueryServiceHelper.queryDataSet((String)(algoKeyStr + TASK_TASKHISTORY), (String)TASK_TASKHISTORY, (String)selectFields, (QFilter[])new QFilter[]{filter}, orderBys);
            ArrayList<Long> creatorList = new ArrayList<Long>(50);
            ArrayList<Long> auditorList = new ArrayList<Long>(50);
            ArrayList<Long> billList = new ArrayList<Long>(50);
            ArrayList<Long> billtypeList = new ArrayList<Long>(50);
            ArrayList<Object> taskIdList = new ArrayList<Object>(50);
            HashMap<Long, Object> map = new HashMap<Long, Object>(50);
            if (!ds.isEmpty()) {
                DataSet dsTmp = ds.copy();
                for (Row row : dsTmp) {
                    creatorList.add(row.getLong("creator"));
                    auditorList.add(row.getLong("auditor"));
                    billList.add(row.getLong("billid"));
                    billtypeList.add(row.getLong("billtype"));
                    taskIdList.add(row.get("taskid"));
                    map.put(row.getLong("billid"), row.get("billtype"));
                }
                List creatorOrgIds = UserServiceHelper.getUserMainOrgIds(creatorList);
                String creatorFields = "id ,entryentity.dpt as dptid";
                QFilter creatorFilter = new QFilter("id", "in", creatorList);
                creatorFilter.and(new QFilter("entryentity.ispartjob", "=", (Object)Boolean.FALSE));
                DataSet creatorDs = QueryServiceHelper.queryDataSet((String)(algoKeyStr + BOS_USER), (String)BOS_USER, (String)creatorFields, (QFilter[])new QFilter[]{creatorFilter}, orderBys);
                String orgtypeFields = "id , orgpattern,orgpattern.name as orgpatternname";
                QFilter orgtypeFilter = new QFilter("id", "in", (Object)creatorOrgIds);
                DataSet orgtypeDs = QueryServiceHelper.queryDataSet((String)(algoKeyStr + BOS_ORG), (String)BOS_ORG, (String)orgtypeFields, (QFilter[])new QFilter[]{orgtypeFilter}, orderBys);
                DataSet tmpDs = creatorDs.join(orgtypeDs).on("dptid", "id").select(new String[]{"id", "dptid"}, new String[]{"orgpattern", "orgpatternname"}).finish();
                List auditorOrgIds = UserServiceHelper.getUserMainOrgIds(auditorList);
                String auditorFields = "id ,entryentity.dpt as dptid,entryentity.position as position,entryentity.dpt.name as dptname";
                QFilter auditorFilter = new QFilter("id", "in", auditorList);
                auditorFilter.and(new QFilter("entryentity.dpt", "in", (Object)auditorOrgIds));
                auditorFilter.and(new QFilter("entryentity.ispartjob", "=", (Object)Boolean.FALSE));
                DataSet auditorDs = QueryServiceHelper.queryDataSet((String)(algoKeyStr + BOS_USER), (String)BOS_USER, (String)auditorFields, (QFilter[])new QFilter[]{auditorFilter}, orderBys);
                ds = ds.leftJoin(auditorDs).on("auditor", "id").select(new String[]{"taskid", "billnumber", "isverifybill", "createmonth", "tasktype", "billtype", "billtypename", "auditorgroup", "usergroupname", "creator", "auditor", "sscid", "billid"}, new String[]{"position", "dptname"}).finish();
                resultDs = ds.select(new String[]{"taskid", "billnumber", "isverifybill", "createmonth", "tasktype", "billtype", "billtypename", "auditorgroup", "usergroupname", "position", "dptname", "creator", "auditor", "sscid", "billid"});
                resultDs = resultDs.leftJoin(tmpDs).on("creator", "id").select(new String[]{"taskid", "billnumber", "isverifybill", "createmonth", "tasktype", "billtype", "billtypename", "auditorgroup", "usergroupname", "position", "dptname", "creator", "auditor", "sscid", "billid"}, new String[]{"dptid as org", "orgpattern as orgtype", "orgpatternname"}).finish();
                String creditFields = "id ,user ,creditvalue";
                QFilter creditFilter = new QFilter("user", "in", creatorList);
                DataSet creditDs = QueryServiceHelper.queryDataSet((String)(algoKeyStr + TASK_CREDITFILES), (String)TASK_CREDITFILES, (String)creditFields, (QFilter[])new QFilter[]{creditFilter}, orderBys);
                resultDs = resultDs.leftJoin(creditDs).on("creator", "user").select(new String[]{"taskid", "billnumber", "isverifybill", "createmonth", "tasktype", "billtype", "billtypename", "auditorgroup", "usergroupname", "position", "dptname", "org", "orgtype", "orgpatternname", "creator", "auditor", "billid"}, new String[]{"creditvalue"}).finish();
                String ctaskFields = " id ,creator";
                QFilter ctaskFilter = new QFilter("creator", "in", creatorList);
                DataSet ctaskDs = QueryServiceHelper.queryDataSet((String)(algoKeyStr + TASK_TASKHISTORY), (String)TASK_TASKHISTORY, (String)ctaskFields, (QFilter[])new QFilter[]{ctaskFilter}, orderBys);
                GroupbyDataSet ctaskGroupByDs = ctaskDs.groupBy(new String[]{"creator"});
                ctaskGroupByDs.count("creatortaskhiscount");
                DataSet ctaskgbDs = ctaskGroupByDs.finish();
                resultDs = resultDs.leftJoin(ctaskgbDs).on("creator", "creator").select(new String[]{"taskid", "billnumber", "isverifybill", "createmonth", "tasktype", "billtype", "billtypename", "auditorgroup", "usergroupname", "position", "dptname", "org", "orgtype", "orgpatternname", "creditvalue", "creator", "auditor", "billid"}, new String[]{"creatortaskhiscount"}).finish();
                String ataskFields = " id ,personid as auditor";
                QFilter ataskFilter = new QFilter("personid", "in", auditorList);
                DataSet ataskDs = QueryServiceHelper.queryDataSet((String)(algoKeyStr + TASK_TASKHISTORY), (String)TASK_TASKHISTORY, (String)ataskFields, (QFilter[])new QFilter[]{ataskFilter}, orderBys);
                GroupbyDataSet ataskGroupByDs = ataskDs.groupBy(new String[]{"auditor"});
                ataskGroupByDs.count("auditortaskhiscount");
                DataSet ataskgbDs = ataskGroupByDs.finish();
                resultDs = resultDs.leftJoin(ataskgbDs).on("auditor", "auditor").select(new String[]{"taskid", "billnumber", "isverifybill", "createmonth", "tasktype", "billtype", "billtypename", "auditorgroup", "usergroupname", "position", "dptname", "org", "orgtype", "orgpatternname", "creditvalue", "creatortaskhiscount", "creator", "auditor", "billid"}, new String[]{"auditortaskhiscount"}).finish();
                DynamicObject obj = QueryServiceHelper.queryOne((String)TASK_TASKTYPE, (String)"id", (QFilter[])new QFilter[]{new QFilter("qualityjudge", "=", (Object)"1")});
                long taskTypeId = 0L;
                if (obj != null) {
                    taskTypeId = obj.getLong("id");
                }
                String ataskQualityFields = " id ,qualitystate,personid as auditor";
                HashSet auditorSet = new HashSet(auditorList);
                QFilter ataskQualityFilter = new QFilter("tasktypeid", "=", (Object)taskTypeId);
                DataSet qualityResultDs = null;
                for (Long userId : auditorSet) {
                    ataskQualityFilter.and("personid", "in", (Object)userId);
                    DataSet ataskQualityDs = QueryServiceHelper.queryDataSet((String)(algoKeyStr + TASK_TASKHISTORY), (String)TASK_TASKHISTORY, (String)ataskQualityFields, (QFilter[])new QFilter[]{ataskQualityFilter}, orderBys).top(50);
                    DataSet ataskQualityCopyDs = ataskQualityDs.copy();
                    GroupbyDataSet ataskQualityGroupByDs = ataskQualityCopyDs.groupBy(new String[]{"auditor"});
                    ataskQualityGroupByDs.count("total");
                    DataSet ataskQualitygbDs = ataskQualityGroupByDs.finish();
                    DataSet qualityDs = ataskQualityCopyDs.filter("qualitystate in ('4','5')");
                    GroupbyDataSet qualityGroupByDs = qualityDs.groupBy(new String[]{"auditor"});
                    qualityGroupByDs.count("completetotal");
                    DataSet qualitygbDs = qualityGroupByDs.finish();
                    DataSet qualityTmpDs = ataskQualitygbDs.join(qualitygbDs).on("auditor", "auditor").select(new String[]{"auditor", "total"}, new String[]{"completetotal"}).finish();
                    if (qualityResultDs != null) {
                        qualityResultDs = qualityResultDs.union(qualityTmpDs);
                        continue;
                    }
                    qualityResultDs = qualityTmpDs;
                }
                resultDs = resultDs.leftJoin(qualityResultDs).on("auditor", "auditor").select(new String[]{"taskid", "billnumber", "isverifybill", "createmonth", "tasktype", "billtype", "billtypename", "auditorgroup", "usergroupname", "position", "dptname", "org", "orgtype", "orgpatternname", "creditvalue", "creatortaskhiscount", "auditortaskhiscount", "creator", "auditor", "billid"}, new String[]{"completetotal", "total"}).finish();
                String isPendingRepulseFields = "id ,newjobstate,jobid as taskid";
                QFilter isPendingRepulseFilter = new QFilter("jobid", "in", taskIdList);
                isPendingRepulseFilter.and("newjobstate", "=", (Object)TaskStateEnum.PAUSE.getValue());
                DataSet isPendingRepulseDs = QueryServiceHelper.queryDataSet((String)(algoKeyStr + TASK_STATECHANGEHIS), (String)TASK_STATECHANGEHIS, (String)isPendingRepulseFields, (QFilter[])new QFilter[]{isPendingRepulseFilter}, orderBys);
                GroupbyDataSet isPendingRepulseGbDs = isPendingRepulseDs.groupBy(new String[]{"taskid"});
                isPendingRepulseGbDs.count("ispendingrepulserecord");
                DataSet isPendingRepulseResultDs = isPendingRepulseGbDs.finish();
                resultDs = resultDs.leftJoin(isPendingRepulseResultDs).on("taskid", "taskid").select(new String[]{"taskid", "billnumber", "isverifybill", "createmonth", "tasktype", "billtype", "billtypename", "auditorgroup", "usergroupname", "position", "dptname", "org", "orgtype", "orgpatternname", "creditvalue", "creatortaskhiscount", "auditortaskhiscount", "completetotal", "total", "creator", "auditor", "billid"}, new String[]{"ispendingrepulserecord"}).finish();
                String isRectificationFields = "id , reformperson";
                QFilter isRectificationFilter = new QFilter("id", "in", taskIdList);
                DataSet isRectificationDs = QueryServiceHelper.queryDataSet((String)(algoKeyStr + TASK_TASKHISTORY), (String)TASK_TASKHISTORY, (String)isRectificationFields, (QFilter[])new QFilter[]{isRectificationFilter}, orderBys);
                resultDs = resultDs.leftJoin(isRectificationDs).on("taskid", "id").select(new String[]{"taskid", "billnumber", "isverifybill", "createmonth", "tasktype", "billtype", "billtypename", "auditorgroup", "usergroupname", "position", "dptname", "org", "orgtype", "orgpatternname", "creditvalue", "creatortaskhiscount", "auditortaskhiscount", "ispendingrepulserecord", "completetotal", "total", "creator", "auditor"}, new String[]{"reformperson"}).finish();
                String billtypeFields = "id ,bindbill.id as bid,bindbill.number as bnumber";
                QFilter billtypeFilter = new QFilter("id", "in", billtypeList);
                DynamicObjectCollection billtypeColl = QueryServiceHelper.query((String)TASK_TASKBILL, (String)billtypeFields, (QFilter[])new QFilter[]{billtypeFilter}, orderBys);
                if (billtypeColl != null && billtypeColl.size() > 0) {
                    ArrayList<Long> tripreqbills = new ArrayList<Long>(50);
                    ArrayList<Long> dailyloanbills = new ArrayList<Long>(50);
                    ArrayList<Long> dailyreimbursebills = new ArrayList<Long>(50);
                    ArrayList<Long> tripreimbursebills = new ArrayList<Long>(50);
                    ArrayList<Long> market_account_bills = new ArrayList<Long>(50);
                    ArrayList<Long> channel_account_bills = new ArrayList<Long>(50);
                    ArrayList<Long> paymentbills = new ArrayList<Long>(50);
                    for (Long id : billList) {
                        for (DynamicObject billMateObj : billtypeColl) {
                            String billtypeNumber = billMateObj.getString("bnumber");
                            if (!map.get(id).equals(billMateObj.get("id"))) continue;
                            switch (billtypeNumber) {
                                case "er_tripreqbill": {
                                    tripreqbills.add(id);
                                    break;
                                }
                                case "er_dailyloanbill": {
                                    dailyloanbills.add(id);
                                    break;
                                }
                                case "er_dailyreimbursebill": {
                                    dailyreimbursebills.add(id);
                                    break;
                                }
                                case "er_tripreimbursebill": {
                                    tripreimbursebills.add(id);
                                    break;
                                }
                            }
                        }
                    }
                    DataSet MoneyDs = null;
                    String tripreqbillFields = " id ,billno,caspayentry.dpamt as money";
                    QFilter tripreqbillFilter = new QFilter("id", "in", tripreqbills);
                    DataSet tripreqbillDs = QueryServiceHelper.queryDataSet((String)(algoKeyStr + tripreqbill), (String)tripreqbill, (String)tripreqbillFields, (QFilter[])new QFilter[]{tripreqbillFilter}, orderBys);
                    GroupbyDataSet tripreqbillGbDs = tripreqbillDs.groupBy(new String[]{"id", "billno"});
                    tripreqbillGbDs = tripreqbillGbDs.sum("money", "total");
                    DataSet tripreqbillResultDs = tripreqbillGbDs.finish();
                    if (MoneyDs == null) {
                        MoneyDs = tripreqbillResultDs;
                    } else if (tripreqbillResultDs != null) {
                        MoneyDs = MoneyDs.union(tripreqbillResultDs);
                    }
                    String dailyloanbillFields = " id ,billno,expenseentryentity.expenseamount as money ";
                    QFilter dailyloanbillFilter = new QFilter("id", "in", dailyloanbills);
                    DataSet dailyloanbillDs = QueryServiceHelper.queryDataSet((String)(algoKeyStr + dailyloanbill), (String)dailyloanbill, (String)dailyloanbillFields, (QFilter[])new QFilter[]{dailyloanbillFilter}, orderBys);
                    GroupbyDataSet dailyloanbillGbDs = dailyloanbillDs.groupBy(new String[]{"id", "billno"});
                    dailyloanbillGbDs = dailyloanbillGbDs.sum("money", "total");
                    DataSet dailyloanbillResultDs = dailyloanbillGbDs.finish();
                    if (MoneyDs == null) {
                        MoneyDs = dailyloanbillResultDs;
                    } else if (dailyloanbillResultDs != null) {
                        MoneyDs = MoneyDs.union(dailyloanbillResultDs);
                    }
                    String dailyreimbursebillFields = " id ,billno,expenseentryentity.expenseamount as money";
                    QFilter dailyreimbursebillFilter = new QFilter("id", "in", dailyreimbursebills);
                    DataSet dailyreimbursebillDs = QueryServiceHelper.queryDataSet((String)(algoKeyStr + dailyreimbursebill), (String)dailyreimbursebill, (String)dailyreimbursebillFields, (QFilter[])new QFilter[]{dailyreimbursebillFilter}, orderBys);
                    GroupbyDataSet dailyreimbursebillGbDs = dailyreimbursebillDs.groupBy(new String[]{"id", "billno"});
                    dailyreimbursebillGbDs = dailyreimbursebillGbDs.sum("money", "total");
                    DataSet dailyreimbursebillResultDs = dailyreimbursebillGbDs.finish();
                    if (MoneyDs == null) {
                        MoneyDs = dailyreimbursebillResultDs;
                    } else if (dailyreimbursebillResultDs != null) {
                        MoneyDs = MoneyDs.union(dailyreimbursebillResultDs);
                    }
                    String tripreimbursebillFields = " id ,billno,invoiceitementry.excludeamount as money";
                    QFilter tripreimbursebillFilter = new QFilter("id", "in", tripreimbursebills);
                    DataSet tripreimbursebillDs = QueryServiceHelper.queryDataSet((String)(algoKeyStr + tripreimbursebill), (String)tripreimbursebill, (String)tripreimbursebillFields, (QFilter[])new QFilter[]{tripreimbursebillFilter}, orderBys);
                    GroupbyDataSet tripreimbursebillGbDs = tripreimbursebillDs.groupBy(new String[]{"id", "billno"});
                    tripreimbursebillGbDs = tripreimbursebillGbDs.sum("money", "total");
                    DataSet tripreimbursebillResultDs = tripreimbursebillGbDs.finish();
                    if (MoneyDs == null) {
                        MoneyDs = tripreimbursebillResultDs;
                    } else if (tripreimbursebillResultDs != null) {
                        MoneyDs = MoneyDs.union(tripreimbursebillResultDs);
                    }
                    if (MoneyDs != null) {
                        resultDs = resultDs.leftJoin(MoneyDs).on("billnumber", "billno").select(new String[]{"taskid", "billnumber", "isverifybill", "createmonth", "tasktype", "billtype", "billtypename", "auditorgroup", "usergroupname", "position", "dptname", "org", "orgtype", "orgpatternname", "creditvalue", "creatortaskhiscount", "auditortaskhiscount", "ispendingrepulserecord", "completetotal", "total", "reformperson", "creator", "auditor"}, new String[]{"total as totalmoney"}).finish();
                    } else {
                        resultDs.addField("totalmoney", null);
                    }
                    DataSet countDs = IntelligentDataUtil.getEntityCount(tripreqbills, dailyloanbills, dailyreimbursebills, tripreimbursebills, market_account_bills, channel_account_bills, paymentbills);
                    if (countDs != null) {
                        resultDs = resultDs.leftJoin(countDs).on("billnumber", "billno").select(new String[]{"taskid", "billnumber", "isverifybill", "createmonth", "tasktype", "billtype", "billtypename", "auditorgroup", "usergroupname", "position", "dptname", "org", "orgtype", "orgpatternname", "creditvalue", "creatortaskhiscount", "auditortaskhiscount", "ispendingrepulserecord", "totalmoney", "completetotal", "total", "reformperson", "creator", "auditor"}, new String[]{"entrycounts as detailscount"}).finish();
                    } else {
                        resultDs.addField("detailscount", null);
                    }
                    DataSet itemDs = IntelligentDataUtil.getEntityItems(tripreqbills, dailyloanbills, dailyreimbursebills, tripreimbursebills, market_account_bills, channel_account_bills, paymentbills);
                    if (itemDs != null) {
                        resultDs = resultDs.leftJoin(itemDs).on("billnumber", "billno").select(new String[]{"taskid", "billnumber", "isverifybill", "createmonth", "tasktype", "billtype", "billtypename", "auditorgroup", "usergroupname", "position", "dptname", "org", "orgtype", "orgpatternname", "creditvalue", "creatortaskhiscount", "auditortaskhiscount", "ispendingrepulserecord", "totalmoney", "detailscount", "completetotal", "total", "reformperson", "creator", "auditor"}, new String[]{"itemtext as items"}).finish();
                    } else {
                        resultDs.addField("items", null);
                    }
                }
            }
        }
        return resultDs;
    }

    public static DataSet getEntityCount(List<Long> tripreqbills, List<Long> dailyloanbills, List<Long> dailyreimbursebills, List<Long> tripreimbursebills, List<Long> market_account_bills, List<Long> channel_account_bills, List<Long> paymentbills) {
        String orderBys = null;
        DataSet bill_1 = null;
        String tripreqbillFields_1 = " id ,billno,tripentry.travelers";
        QFilter tripreqbillFilter_1 = new QFilter("id", "in", tripreqbills);
        DataSet tripreqbillDs_1 = QueryServiceHelper.queryDataSet((String)(algoKeyStr + tripreqbill), (String)tripreqbill, (String)tripreqbillFields_1, (QFilter[])new QFilter[]{tripreqbillFilter_1}, orderBys);
        DataSet tripreqbillResultDs_1 = tripreqbillDs_1.groupBy(new String[]{"id", "billno"}).count("entrycount").finish();
        String tripreqbillFields_2 = " id ,billno,accountentry.payertype";
        QFilter tripreqbillFilter_2 = new QFilter("id", "in", tripreqbills);
        DataSet tripreqbillDs_2 = QueryServiceHelper.queryDataSet((String)(algoKeyStr + tripreqbill), (String)tripreqbill, (String)tripreqbillFields_2, (QFilter[])new QFilter[]{tripreqbillFilter_2}, orderBys);
        DataSet tripreqbillResultDs_2 = tripreqbillDs_2.groupBy(new String[]{"id", "billno"}).count("entrycount").finish();
        String tripreqbillFields_3 = " id ,billno,caspayentry.dpamt";
        QFilter tripreqbillFilter_3 = new QFilter("id", "in", tripreqbills);
        DataSet tripreqbillDs_3 = QueryServiceHelper.queryDataSet((String)(algoKeyStr + tripreqbill), (String)tripreqbill, (String)tripreqbillFields_3, (QFilter[])new QFilter[]{tripreqbillFilter_3}, orderBys);
        DataSet tripreqbillResultDs_3 = tripreqbillDs_3.groupBy(new String[]{"id", "billno"}).count("entrycount").finish();
        bill_1 = tripreqbillResultDs_1.union(new DataSet[]{tripreqbillResultDs_2, tripreqbillResultDs_3});
        DataSet ds = bill_1 = bill_1.groupBy(new String[]{"billno"}).count("entrycounts").finish();
        DataSet bill_2 = null;
        String dailyloanbillFields_1 = " id ,billno,expenseentryentity.expenseamount";
        QFilter dailyloanbillFilter_1 = new QFilter("id", "in", dailyloanbills);
        DataSet dailyloanbillDs_1 = QueryServiceHelper.queryDataSet((String)(algoKeyStr + dailyloanbill), (String)dailyloanbill, (String)dailyloanbillFields_1, (QFilter[])new QFilter[]{dailyloanbillFilter_1}, orderBys);
        DataSet dailyloanbillResultDs_1 = dailyloanbillDs_1.groupBy(new String[]{"id", "billno"}).count("entrycount").finish();
        String dailyloanbillFields_2 = " id ,billno,accountentry.payertype";
        QFilter dailyloanbillFilter_2 = new QFilter("id", "in", dailyloanbills);
        DataSet dailyloanbillDs_2 = QueryServiceHelper.queryDataSet((String)(algoKeyStr + dailyloanbill), (String)dailyloanbill, (String)dailyloanbillFields_2, (QFilter[])new QFilter[]{dailyloanbillFilter_2}, orderBys);
        DataSet dailyloanbillResultDs_2 = dailyloanbillDs_2.groupBy(new String[]{"id", "billno"}).count("entrycount").finish();
        String dailyloanbillFields_3 = " id ,billno,caspayentry.targetsettletype";
        QFilter dailyloanbillFilter_3 = new QFilter("id", "in", dailyloanbills);
        DataSet dailyloanbillDs_3 = QueryServiceHelper.queryDataSet((String)(algoKeyStr + dailyloanbill), (String)dailyloanbill, (String)dailyloanbillFields_3, (QFilter[])new QFilter[]{dailyloanbillFilter_3}, orderBys);
        DataSet dailyloanbillResultDs_3 = dailyloanbillDs_3.groupBy(new String[]{"id", "billno"}).count("entrycount").finish();
        bill_2 = dailyloanbillResultDs_1.union(new DataSet[]{dailyloanbillResultDs_2, dailyloanbillResultDs_3});
        if ((bill_2 = bill_2.groupBy(new String[]{"billno"}).count("entrycounts").finish()) != null) {
            ds = ds.union(bill_2);
        }
        DataSet bill_3 = null;
        String dailyreimbursebillFields_1 = " id ,billno,expenseentryentity.expenseamount";
        QFilter dailyreimbursebillFilter_1 = new QFilter("id", "in", dailyreimbursebills);
        DataSet dailyreimbursebillDs_1 = QueryServiceHelper.queryDataSet((String)(algoKeyStr + dailyreimbursebill), (String)dailyreimbursebill, (String)dailyreimbursebillFields_1, (QFilter[])new QFilter[]{dailyreimbursebillFilter_1}, orderBys);
        DataSet dailyreimbursebillResultDs_1 = dailyreimbursebillDs_1.groupBy(new String[]{"id", "billno"}).count("entrycount").finish();
        String dailyreimbursebillFields_2 = " id ,billno,invoiceentry.invoicetype";
        QFilter dailyreimbursebillFilter_2 = new QFilter("id", "in", dailyreimbursebills);
        DataSet dailyreimbursebillDs_2 = QueryServiceHelper.queryDataSet((String)(algoKeyStr + dailyreimbursebill), (String)dailyreimbursebill, (String)dailyreimbursebillFields_2, (QFilter[])new QFilter[]{dailyreimbursebillFilter_2}, orderBys);
        DataSet dailyreimbursebillResultDs_2 = dailyreimbursebillDs_2.groupBy(new String[]{"id", "billno"}).count("entrycount").finish();
        String dailyreimbursebillFields_3 = " id ,billno,writeoffmoney.loanbillnov1";
        QFilter dailyreimbursebillFilter_3 = new QFilter("id", "in", dailyreimbursebills);
        DataSet dailyreimbursebillDs_3 = QueryServiceHelper.queryDataSet((String)(algoKeyStr + dailyreimbursebill), (String)dailyreimbursebill, (String)dailyreimbursebillFields_3, (QFilter[])new QFilter[]{dailyreimbursebillFilter_3}, orderBys);
        DataSet dailyreimbursebillResultDs_3 = dailyreimbursebillDs_3.groupBy(new String[]{"id", "billno"}).count("entrycount").finish();
        String dailyreimbursebillFields_4 = " id ,billno,writeoffapply.applybillno";
        QFilter dailyreimbursebillFilter_4 = new QFilter("id", "in", dailyreimbursebills);
        DataSet dailyreimbursebillDs_4 = QueryServiceHelper.queryDataSet((String)(algoKeyStr + dailyreimbursebill), (String)dailyreimbursebill, (String)dailyreimbursebillFields_4, (QFilter[])new QFilter[]{dailyreimbursebillFilter_4}, orderBys);
        DataSet dailyreimbursebillResultDs_4 = dailyreimbursebillDs_4.groupBy(new String[]{"id", "billno"}).count("entrycount").finish();
        String dailyreimbursebillFields_5 = " id ,billno,accountentry.paymode";
        QFilter dailyreimbursebillFilter_5 = new QFilter("id", "in", dailyreimbursebills);
        DataSet dailyreimbursebillDs_5 = QueryServiceHelper.queryDataSet((String)(algoKeyStr + dailyreimbursebill), (String)dailyreimbursebill, (String)dailyreimbursebillFields_5, (QFilter[])new QFilter[]{dailyreimbursebillFilter_5}, orderBys);
        DataSet dailyreimbursebillResultDs_5 = dailyreimbursebillDs_5.groupBy(new String[]{"id", "billno"}).count("entrycount").finish();
        String dailyreimbursebillFields_6 = " id ,billno,caspayentry.targetsettletype";
        QFilter dailyreimbursebillFilter_6 = new QFilter("id", "in", dailyreimbursebills);
        DataSet dailyreimbursebillDs_6 = QueryServiceHelper.queryDataSet((String)(algoKeyStr + dailyreimbursebill), (String)dailyreimbursebill, (String)dailyreimbursebillFields_6, (QFilter[])new QFilter[]{dailyreimbursebillFilter_6}, orderBys);
        DataSet dailyreimbursebillResultDs_6 = dailyreimbursebillDs_6.groupBy(new String[]{"id", "billno"}).count("entrycount").finish();
        String dailyreimbursebillFields_7 = " id ,billno,invoiceitementry.itementryid";
        QFilter dailyreimbursebillFilter_7 = new QFilter("id", "in", dailyreimbursebills);
        DataSet dailyreimbursebillDs_7 = QueryServiceHelper.queryDataSet((String)(algoKeyStr + dailyreimbursebill), (String)dailyreimbursebill, (String)dailyreimbursebillFields_7, (QFilter[])new QFilter[]{dailyreimbursebillFilter_7}, orderBys);
        DataSet dailyreimbursebillResultDs_7 = dailyreimbursebillDs_7.groupBy(new String[]{"id", "billno"}).count("entrycount").finish();
        bill_3 = dailyreimbursebillResultDs_1.union(new DataSet[]{dailyreimbursebillResultDs_2, dailyreimbursebillResultDs_3, dailyreimbursebillResultDs_4, dailyreimbursebillResultDs_5, dailyreimbursebillResultDs_6, dailyreimbursebillResultDs_7});
        if ((bill_3 = bill_3.groupBy(new String[]{"billno"}).count("entrycounts").finish()) != null) {
            ds = ds.union(bill_3);
        }
        DataSet bill_4 = null;
        String tripreimbursebillFields_1 = " id ,billno,tripentry.travelers";
        QFilter tripreimbursebillFilter_1 = new QFilter("id", "in", tripreimbursebills);
        DataSet tripreimbursebillDs_1 = QueryServiceHelper.queryDataSet((String)(algoKeyStr + tripreimbursebill), (String)tripreimbursebill, (String)tripreimbursebillFields_1, (QFilter[])new QFilter[]{tripreimbursebillFilter_1}, orderBys);
        DataSet tripreimbursebillResultDs_1 = tripreimbursebillDs_1.groupBy(new String[]{"id", "billno"}).count("entrycounts").finish();
        String tripreimbursebillFields_2 = " id ,billno,invoiceentry.invoicetype";
        QFilter tripreimbursebillFilter_2 = new QFilter("id", "in", tripreimbursebills);
        DataSet tripreimbursebillDs_2 = QueryServiceHelper.queryDataSet((String)(algoKeyStr + tripreimbursebill), (String)tripreimbursebill, (String)tripreimbursebillFields_2, (QFilter[])new QFilter[]{tripreimbursebillFilter_2}, orderBys);
        DataSet tripreimbursebillResultDs_2 = tripreimbursebillDs_2.groupBy(new String[]{"id", "billno"}).count("entrycounts").finish();
        String tripreimbursebillFields_3 = " id ,billno,clearloanentry.loanbizdate";
        QFilter tripreimbursebillFilter_3 = new QFilter("id", "in", tripreimbursebills);
        DataSet tripreimbursebillDs_3 = QueryServiceHelper.queryDataSet((String)(algoKeyStr + tripreimbursebill), (String)tripreimbursebill, (String)tripreimbursebillFields_3, (QFilter[])new QFilter[]{tripreimbursebillFilter_3}, orderBys);
        DataSet tripreimbursebillResultDs_3 = tripreimbursebillDs_3.groupBy(new String[]{"id", "billno"}).count("entrycounts").finish();
        String tripreimbursebillFields_4 = " id ,billno,accountentry.payertype ";
        QFilter tripreimbursebillFilter_4 = new QFilter("id", "in", tripreimbursebills);
        DataSet tripreimbursebillDs_4 = QueryServiceHelper.queryDataSet((String)(algoKeyStr + tripreimbursebill), (String)tripreimbursebill, (String)tripreimbursebillFields_4, (QFilter[])new QFilter[]{tripreimbursebillFilter_4}, orderBys);
        DataSet tripreimbursebillResultDs_4 = tripreimbursebillDs_4.groupBy(new String[]{"id", "billno"}).count("entrycounts").finish();
        String tripreimbursebillFields_5 = " id ,billno,caspayentry.targetbillno ";
        QFilter tripreimbursebillFilter_5 = new QFilter("id", "in", tripreimbursebills);
        DataSet tripreimbursebillDs_5 = QueryServiceHelper.queryDataSet((String)(algoKeyStr + tripreimbursebill), (String)tripreimbursebill, (String)tripreimbursebillFields_5, (QFilter[])new QFilter[]{tripreimbursebillFilter_5}, orderBys);
        DataSet tripreimbursebillResultDs_5 = tripreimbursebillDs_5.groupBy(new String[]{"id", "billno"}).count("entrycounts").finish();
        String tripreimbursebillFields_6 = " id ,billno,invoiceitementry.itementryid";
        QFilter tripreimbursebillFilter_6 = new QFilter("id", "in", tripreimbursebills);
        DataSet tripreimbursebillDs_6 = QueryServiceHelper.queryDataSet((String)(algoKeyStr + tripreimbursebill), (String)tripreimbursebill, (String)tripreimbursebillFields_6, (QFilter[])new QFilter[]{tripreimbursebillFilter_6}, orderBys);
        DataSet tripreimbursebillResultDs_6 = tripreimbursebillDs_6.groupBy(new String[]{"id", "billno"}).count("entrycounts").finish();
        bill_4 = tripreimbursebillResultDs_1.union(new DataSet[]{tripreimbursebillResultDs_2, tripreimbursebillResultDs_3, tripreimbursebillResultDs_4, tripreimbursebillResultDs_5, tripreimbursebillResultDs_6});
        if ((bill_4 = bill_4.groupBy(new String[]{"billno"}).count("entrycounts").finish()) != null) {
            ds = ds.union(bill_4);
        }
        return ds;
    }

    public static DataSet getEntityItems(List<Long> tripreqbills, List<Long> dailyloanbills, List<Long> dailyreimbursebills, List<Long> tripreimbursebills, List<Long> market_account_bills, List<Long> channel_account_bills, List<Long> paymentbills) {
        DataSet ds = null;
        Object orderBys = null;
        String selectFields_2 = "id,billno,expenseentryentity.expenseitem.name as item";
        DataSet bill_2 = IntelligentDataUtil.getHandleItemDataSet(selectFields_2, dailyloanbills, dailyloanbill);
        if (bill_2 != null) {
            ds = bill_2;
        }
        String selectFields_3 = "id,billno,expenseentryentity.expenseitem.name as item";
        DataSet bill_3 = IntelligentDataUtil.getHandleItemDataSet(selectFields_3, dailyreimbursebills, dailyreimbursebill);
        if (ds == null) {
            ds = bill_3;
        } else if (bill_3 != null) {
            ds = ds.union(bill_3);
        }
        String selectFields_4 = "id,billno,clearloanentry.sourceexpenseitem.name as item";
        DataSet bill_4 = IntelligentDataUtil.getHandleItemDataSet(selectFields_4, tripreimbursebills, tripreimbursebill);
        if (ds == null) {
            ds = bill_4;
        } else if (bill_4 != null) {
            ds = ds.union(bill_4);
        }
        return ds;
    }

    public static DataSet getHandleItemDataSet(String field, List<Long> billIds, String entityName) {
        DataSet ds = null;
        QFilter filter = new QFilter("id", "in", billIds);
        String tmpField = "id,billid,billno,itemtext";
        DynamicObjectCollection coll = QueryServiceHelper.query((String)entityName, (String)field, (QFilter[])new QFilter[]{filter});
        if (coll != null && coll.size() > 0) {
            HashMap<String, String> billnoItemMap = new HashMap<String, String>();
            HashMap<String, Long> billnoBillIdMap = new HashMap<String, Long>();
            for (DynamicObject item : coll) {
                String billno = item.getString("billno");
                Long billId = item.getLong("id");
                String itemName = item.getString("item");
                String oldItem = (String)billnoItemMap.get(billno);
                String newItem = null;
                newItem = oldItem != null ? oldItem + ";" + itemName : itemName;
                billnoItemMap.put(billno, newItem);
                if (billnoBillIdMap.containsKey(billno)) continue;
                billnoBillIdMap.put(billno, billId);
            }
            QFilter dfilter = new QFilter("billid", "in", billIds);
            List pks = QueryServiceHelper.queryPrimaryKeys((String)SSC_INTELLIGENT_TMP, (QFilter[])new QFilter[]{dfilter}, null, (int)billIds.size());
            BusinessDataServiceHelper.delete((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)SSC_INTELLIGENT_TMP).getDataEntityType(), (Object[])pks.toArray());
            ArrayList<DynamicObject> items = new ArrayList<DynamicObject>(50);
            for (Map.Entry entry : billnoItemMap.entrySet()) {
                DynamicObject itemObj = BusinessDataServiceHelper.newDynamicObject((String)SSC_INTELLIGENT_TMP);
                itemObj.set("billno", entry.getKey());
                itemObj.set("itemtext", entry.getValue());
                itemObj.set("billid", billnoBillIdMap.get(entry.getKey()));
                items.add(itemObj);
            }
            SaveServiceHelper.save((DynamicObject[])items.toArray(new DynamicObject[0]));
        }
        QFilter entryFilter = new QFilter("billid", "in", billIds);
        ds = QueryServiceHelper.queryDataSet((String)(algoKeyStr + SSC_INTELLIGENT_TMP), (String)SSC_INTELLIGENT_TMP, (String)tmpField, (QFilter[])new QFilter[]{entryFilter}, null);
        return ds;
    }
}

