/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.util;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.task.formplugin.pojo.achieve.WorkLoadOnline;
import kd.ssc.task.util.DateUtil;

public class WorkLoadOnlineRecountUtil {
    private static final Log log = LogFactory.getLog(WorkLoadOnlineRecountUtil.class);

    public static void saveWorkLoadBybeforeDay(Date oneDay, List<Long> sscIds) {
        QFilter oneDayCompleteFilter = WorkLoadOnlineRecountUtil.getDayFilter("completetime", oneDay);
        if (sscIds != null && !sscIds.isEmpty()) {
            oneDayCompleteFilter.and("sscid", "in", sscIds);
        }
        DynamicObjectCollection oneDayCompleteTasks = QueryServiceHelper.query((String)"task_taskhistory", (String)"id,sscid,billnumber,billtype,completetime,orgid,usergroup,personid,tasktypeid,coefficient", (QFilter[])new QFilter[]{oneDayCompleteFilter});
        ArrayList<DynamicObject> workLoadOnlineObjs = new ArrayList<DynamicObject>(16);
        for (DynamicObject task : oneDayCompleteTasks) {
            DynamicObject workLoadOnlineObj = WorkLoadOnlineRecountUtil.buildWorkLoadDynByTaskDyn(task);
            workLoadOnlineObjs.add(workLoadOnlineObj);
        }
        try {
            SaveServiceHelper.save((DynamicObject[])workLoadOnlineObjs.toArray(new DynamicObject[workLoadOnlineObjs.size()]));
        }
        catch (Exception e) {
            log.error("kd.ssc.task.formplugin.util.WorkLoadOnlineRecountUtil:\u65b0\u589e" + oneDay.toString() + "\u7684\u7ebf\u4e0a\u5de5\u4f5c\u91cf\u7edf\u8ba1\u51fa\u9519\uff1a", (Throwable)e);
        }
    }

    public static DynamicObject buildWorkLoadDynByTaskDyn(DynamicObject taskDyn) {
        WorkLoadOnline workLoadOnline = new WorkLoadOnline();
        workLoadOnline.setTaskid(taskDyn.getLong("id"));
        workLoadOnline.setSscid(taskDyn.getLong("sscid"));
        workLoadOnline.setBillno(taskDyn.getString("billnumber"));
        workLoadOnline.setBilltypeid(taskDyn.getLong("billtype"));
        workLoadOnline.setCompletetime(taskDyn.getDate("completetime"));
        workLoadOnline.setOrgid(taskDyn.getLong("orgid"));
        workLoadOnline.setGroupid(taskDyn.getLong("usergroup"));
        workLoadOnline.setHandlerid(taskDyn.getLong("personid"));
        workLoadOnline.setTasktype(taskDyn.getLong("tasktypeid"));
        workLoadOnline.setTaskcoefficent(taskDyn.getBigDecimal("coefficient"));
        workLoadOnline.setTasknum(1);
        BigDecimal standardNum = workLoadOnline.getTaskcoefficent().multiply(new BigDecimal(workLoadOnline.getTasknum()));
        workLoadOnline.setStandardnum(standardNum);
        QFilter taskTypeFilter = new QFilter("id", "=", (Object)workLoadOnline.getTasktype());
        DynamicObject taskTypeObj = BusinessDataServiceHelper.loadSingle((String)"task_tasktype", (String)"qualityjudge", (QFilter[])new QFilter[]{taskTypeFilter});
        if (taskTypeObj != null) {
            workLoadOnline.setAttribute(taskTypeObj.getString("qualityjudge"));
        }
        return workLoadOnline.getDynamicObject();
    }

    public static void deleteWorkLoadByDay(Date oneDay, List<Long> sscIds) {
        QFilter oneDayCompleteFilter = WorkLoadOnlineRecountUtil.getDayFilter("completetime", oneDay);
        if (sscIds != null && !sscIds.isEmpty()) {
            oneDayCompleteFilter.and("sscid", "in", sscIds);
        }
        DeleteServiceHelper.delete((String)"ssc_workloadonline", (QFilter[])new QFilter[]{oneDayCompleteFilter});
    }

    private static QFilter getDayFilter(String dateName, Date dateValue) {
        Date oneDayStart = null;
        Date oneDayEnd = null;
        try {
            oneDayStart = DateUtil.getCurDateForm((Date)dateValue, (boolean)true);
            oneDayEnd = DateUtil.getCurDateForm((Date)dateValue, (boolean)false);
        }
        catch (ParseException e) {
            log.error("WorkLoadOnlineRecountUtil.getDayFilter error:" + e.getMessage(), (Throwable)e);
        }
        QFilter oneDayFilter = new QFilter(dateName, ">=", (Object)oneDayStart);
        oneDayFilter.and(new QFilter(dateName, "<=", (Object)oneDayEnd));
        return oneDayFilter;
    }
}

