/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.workcalendar;

import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.WorkCalendar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.enums.workcalendar.SscDateType;
import kd.ssc.enums.workcalendar.SscLevelType;
import kd.ssc.enums.workcalendar.SscTimeType;
import kd.ssc.task.common.workcalendar.SscWorkCalendarApi;
import kd.ssc.task.common.workcalendar.WorkCalendarUtils;
import kd.ssc.task.formplugin.pojo.PersonInfo;
import kd.ssc.task.formplugin.pojo.workcalendar.WorkCalendarTaskMessage;
import kd.ssc.task.formplugin.util.SscWorkCalendarLoadService;
import kd.ssc.task.formplugin.util.SscWorkCalendarUtil;
import kd.ssc.task.util.DateUtil;

public class SscWorkCalendarBasePlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(SscWorkCalendarBasePlugin.class);
    private static final String IMICDIMENSION_BOS_ORG = "imicdimension_bos_org";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"preyear", "nextyear"});
        WorkCalendar workCalendar = (WorkCalendar)this.getView().getControl("workcalendarap");
        workCalendar.addClickListener((ClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btn = (Button)this.getView().getControl("btn_save");
        btn.addClickListener((ClickListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (!QueryServiceHelper.exists((String)"bos_org", null)) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u5148\u5728\u201c\u57fa\u7840\u670d\u52a1\u4e91\u201d\u521b\u5efa\u884c\u653f\u7ec4\u7ec7\u3002", (String)"SscWorkCalendarBasePlugin_15", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void afterBindData(EventObject e) {
        String orgId;
        super.afterBindData(e);
        this.setShareCenter();
        if (StringUtils.isEmpty((CharSequence)(this.getModel().getDataEntity().get("year") + ""))) {
            this.setCurrentYear(Calendar.getInstance().get(1));
        }
        if (StringUtils.isEmpty((CharSequence)(orgId = this.getCurrentOrgId()))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5171\u4eab\u4e2d\u5fc3\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6743\u9650\u3002", (String)"SscWorkCalendarBasePlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save", "workcalendpanel", "syncothergroup"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"btn_save", "workcalendpanel", "syncothergroup"});
        switch (this.getCurrentEntityName()) {
            case "ssc_workcalendar_center": {
                this.loadBaseWorkCalendar(this.getCurrentYear());
                this.initSingleSet(true);
                break;
            }
            case "ssc_workcalendar_group": {
                boolean enable = this.enableUserGroup(this.setGroup(orgId));
                this.loadBaseWorkCalendar(this.getCurrentYear());
                this.initSingleSet(enable);
                break;
            }
            case "ssc_workcalendar_employee": {
                boolean enable = this.enableUserGroup(this.setGroup(orgId));
                this.setUserList();
                this.loadBaseWorkCalendar(this.getCurrentYear());
                this.initSingleSet(enable);
                break;
            }
        }
        this.getView().updateView("country");
        this.getView().updateView("timezone");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (evt.getItemKey().equals("bar_refresh")) {
            String userGroup = "";
            switch (this.getCurrentEntityName()) {
                case "ssc_workcalendar_group": {
                    userGroup = this.setGroup(this.getCurrentOrgId());
                    break;
                }
                case "ssc_workcalendar_employee": {
                    userGroup = this.setGroup(this.getCurrentOrgId());
                    this.resetUser();
                    break;
                }
            }
            boolean enable = this.enableUserGroup(userGroup);
            this.loadBaseWorkCalendar(this.getCurrentYear());
            this.initSingleSet(enable);
            this.getView().updateView("country");
            this.getView().updateView("timezone");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        int year = this.getCurrentYear();
        int thisYear = Calendar.getInstance().get(1);
        int maxYear = thisYear + 10;
        switch (control.getKey()) {
            case "preyear": {
                this.setCurrentYear(year - 1);
                this.loadBaseWorkCalendar(year - 1);
                break;
            }
            case "nextyear": {
                int nextYear = year + 1;
                if (maxYear < nextYear) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u5386\u4ec5\u652f\u6301\u8bbe\u7f6e10\u5e74\u5185\u6570\u636e\u3002", (String)"SscWorkCalendarBasePlugin_18", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.setCurrentYear(year + 1);
                this.loadBaseWorkCalendar(year + 1);
                break;
            }
            case "workcalendarap": {
                if (this.getCurrentEntityName().equals("ssc_workcalendar_employee") && this.getModel().getEntryEntity("cardentry").isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7528\u6237\u5217\u8868\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5207\u6362\u65e5\u671f\u3002", (String)"SscWorkCalendarBasePlugin_20", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                ArrayList dateList = ((WorkCalendar)this.getControl("workcalendarap")).getDateList();
                if (dateList.size() <= 0) break;
                String selectDate = (String)dateList.get(0);
                this.resetMarkType();
                this.markWorkCalendar(selectDate);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        String dateTypeChange = this.getPageCache().get("dateTypeChange");
        String orgId = this.getCurrentOrgId();
        switch (propName) {
            case "ssccenter": {
                this.getModel().setValue("orgfield", (Object)orgId);
                if (this.enableUserGroup(this.setGroup(orgId))) {
                    this.resetUser();
                    this.loadBaseWorkCalendar(this.getCurrentYear());
                    this.initSingleSet(true);
                }
                this.getView().updateView("country");
                this.getView().updateView("timezone");
                break;
            }
            case "usergroup": {
                boolean exists;
                String userGroup = this.getCurrentGroup();
                if (StringUtils.isNotEmpty((CharSequence)userGroup) && !(exists = QueryServiceHelper.exists((String)"task_usergroup", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(userGroup))}))) {
                    this.setGroup(orgId);
                    userGroup = this.setGroup(orgId);
                }
                boolean enable = this.enableUserGroup(userGroup);
                this.loadBaseWorkCalendar(this.getCurrentYear());
                this.initSingleSet(enable);
                this.resetUser();
                break;
            }
            case "restdate": 
            case "holiday": 
            case "workdate": 
            case "halfworkdate": {
                if (dateTypeChange != null && dateTypeChange.equals("1")) break;
                this.putDateTypeChangeCache();
                this.dateTypeChange(propName);
                this.removeDateTypeChangeCache();
                break;
            }
            case "am_time": 
            case "pm_time": {
                if (dateTypeChange != null && dateTypeChange.equals("1")) break;
                this.putDateTypeChangeCache();
                this.timeTypeChange(propName);
                this.removeDateTypeChangeCache();
                break;
            }
            case "isduty": {
                this.loadBaseWorkCalendar(this.getCurrentYear());
                this.initSingleSet(this.enableUserGroup(this.getCurrentGroup()));
                this.setUserList();
                break;
            }
        }
    }

    boolean loadBaseWorkCalendar(int year) {
        String orgId = this.getCurrentOrgId();
        if (StringUtils.isEmpty((CharSequence)orgId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5171\u4eab\u4e2d\u5fc3\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6743\u9650\u3002", (String)"SscWorkCalendarBasePlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"workcalendpanel"});
            return false;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"workcalendpanel"});
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("ssc", orgId);
        params.put("year", year + "");
        DynamicObjectCollection workCalendars = SscWorkCalendarLoadService.loadWorkCalendar(params);
        switch (this.getCurrentEntityName()) {
            case "ssc_workcalendar_group": 
            case "ssc_workcalendar_employee": {
                String userGroup = this.getCurrentGroup();
                if (!StringUtils.isNotEmpty((CharSequence)userGroup)) break;
                params.put("usergroup", userGroup);
                workCalendars.addAll((Collection)SscWorkCalendarLoadService.loadWorkCalendar(params));
                break;
            }
        }
        List<Map<String, String>> datas = WorkCalendarUtils.parseWorkCalendarData(workCalendars);
        WorkCalendar workCalendar = (WorkCalendar)this.getView().getControl("workcalendarap");
        workCalendar.setYear(year);
        workCalendar.setWorkDataList(datas);
        String today = this.getSscToday();
        workCalendar.setToday(today);
        workCalendar.setData();
        return true;
    }

    void initSingleSet(boolean enableGroup) {
        String today = this.getSscToday();
        this.markWorkCalendar(today);
        if (!this.getCurrentEntityName().equals("ssc_workcalendar_employee")) {
            this.getView().updateView("singledayset");
        }
        if (this.getCurrentEntityName().equals("ssc_workcalendar_group")) {
            if (enableGroup) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"restdate", "am_time", "pm_time", "workdate", "halfworkdate", "morning", "afternoon"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"restdate", "am_time", "pm_time", "workdate", "halfworkdate", "morning", "afternoon"});
            }
        }
    }

    void dateTypeChange(String propName) {
        if (!((Boolean)this.getModel().getValue(propName)).booleanValue()) {
            return;
        }
        switch (propName) {
            case "restdate": {
                this.toRestDate();
                break;
            }
            case "holiday": {
                this.toHoliday();
                break;
            }
            case "workdate": {
                this.toWorkDate();
                break;
            }
            case "halfworkdate": {
                this.toHalfWorkDate();
                break;
            }
        }
    }

    void timeTypeChange(String propName) {
        switch (propName) {
            case "am_time": {
                this.resetMarkType();
                this.getModel().setValue("am_time", (Object)Boolean.TRUE);
                this.getView().setVisible(Boolean.FALSE, new String[]{"afternoon"});
                this.getModel().setValue("halfworkdate", (Object)Boolean.TRUE);
                break;
            }
            case "pm_time": {
                this.resetMarkType();
                this.getModel().setValue("pm_time", (Object)Boolean.TRUE);
                this.getView().setVisible(Boolean.FALSE, new String[]{"morning"});
                this.getModel().setValue("halfworkdate", (Object)Boolean.TRUE);
                break;
            }
        }
    }

    void setShareCenter() {
        String entityName = this.getCurrentEntityName();
        String appId = this.getView().getFormShowParameter().getAppId();
        String cusAppId = (String)this.getView().getFormShowParameter().getCustomParam("cusAppId");
        if (StringUtils.isNotEmpty((CharSequence)cusAppId)) {
            appId = cusAppId;
        }
        List<ComboItem> comboItems = WorkCalendarUtils.setShareCenter(entityName, appId);
        ComboEdit combo = (ComboEdit)this.getControl("ssccenter");
        if (comboItems.size() > 0) {
            combo.setComboItems(comboItems);
            this.getModel().setValue("ssccenter", (Object)this.selectSscID(comboItems));
            this.getView().updateView("ssccenter");
        } else {
            this.getModel().setValue("ssccenter", (Object)"");
            combo.setComboItems(null);
        }
        this.getModel().setValue("orgfield", (Object)this.getCurrentOrgId());
        this.getView().updateView("orgfield");
    }

    private String selectSscID(List<ComboItem> comboItems) {
        String sscId;
        String imicOrgId = (String)this.getView().getFormShowParameter().getCustomParam(IMICDIMENSION_BOS_ORG);
        if (StringUtils.isNotEmpty((CharSequence)imicOrgId)) {
            this.getView().getFormShowParameter().setCustomParam("sscId", (Object)imicOrgId);
        }
        if ((sscId = (String)this.getView().getFormShowParameter().getCustomParam("sscId")) == null) {
            return comboItems.get(0).getValue();
        }
        for (ComboItem comboItem : comboItems) {
            if (!sscId.equals(comboItem.getValue())) continue;
            return sscId;
        }
        return comboItems.get(0).getValue();
    }

    String setGroup(Object orgId) {
        String userGroup = "";
        if (this.getCurrentEntityName().equals("ssc_workcalendar_group") || this.getCurrentEntityName().equals("ssc_workcalendar_employee")) {
            Long userId = Long.parseLong(this.getCurrentUserId());
            List<ComboItem> comboItems = WorkCalendarUtils.setGroup(orgId, userId);
            ComboEdit combo = (ComboEdit)this.getControl("usergroup");
            if (comboItems.size() > 0) {
                userGroup = comboItems.get(0).getValue();
                combo.setComboItems(comboItems);
                this.getModel().setValue("usergroup", (Object)userGroup);
                this.getView().updateView("usergroup");
            } else {
                this.getModel().setValue("usergroup", (Object)userGroup);
                combo.setComboItems(null);
            }
        }
        return userGroup;
    }

    void setUserList() {
        String orgId = this.getCurrentOrgId();
        String groupId = this.getCurrentGroup();
        IDataModel model = this.getModel();
        this.getView().setVisible(Boolean.TRUE, new String[]{"btn_save", "syncothergroup"});
        this.getPageCache().put("uid", null);
        if (groupId == null || "".equals(groupId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7528\u6237\u7ec4\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6743\u9650\u3002", (String)"SscWorkCalendarBasePlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            model.deleteEntryData("cardentry");
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save", "syncothergroup"});
            return;
        }
        String duty = (String)this.getModel().getValue("isduty");
        List<PersonInfo> personlist = SscWorkCalendarApi.getPersonWorkList(orgId, groupId);
        if (personlist == null || personlist.size() == 0) {
            model.deleteEntryData("cardentry");
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save", "syncothergroup"});
            this.userOffAndOverTimeBtn(Boolean.FALSE);
            this.resetMarkType();
            WorkCalendarUtils.cleanEntryEntity(model);
            return;
        }
        if (personlist != null && personlist.size() > 0) {
            ArrayList<PersonInfo> work = new ArrayList<PersonInfo>();
            ArrayList<PersonInfo> unWork = new ArrayList<PersonInfo>();
            for (PersonInfo person : personlist) {
                boolean value = person.getWorkStatus();
                if (value) {
                    work.add(person);
                    continue;
                }
                unWork.add(person);
            }
            switch (duty) {
                case "1": {
                    if (this.getUidFromCache() == null && work.size() > 0) {
                        this.putUidToCache(((PersonInfo)work.get(0)).getUid());
                    }
                    this.buildUserList(work);
                    break;
                }
                case "2": {
                    if (this.getUidFromCache() == null && unWork.size() > 0) {
                        this.putUidToCache(((PersonInfo)unWork.get(0)).getUid());
                    }
                    this.buildUserList(unWork);
                    break;
                }
                default: {
                    if (this.getUidFromCache() == null && personlist.size() > 0) {
                        this.putUidToCache(personlist.get(0).getUid());
                    }
                    this.buildUserList(personlist);
                }
            }
        }
    }

    void buildUserList(List<PersonInfo> personlist) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("cardentry");
        if (personlist.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save", "syncothergroup"});
            this.userOffAndOverTimeBtn(Boolean.FALSE);
            this.resetMarkType();
            WorkCalendarUtils.cleanEntryEntity((IDataModel)model);
            return;
        }
        model.beginInit();
        TableValueSetter vs1 = new TableValueSetter(new String[0]);
        vs1.addField("userfield", new Object[0]);
        vs1.addField("phone", new Object[0]);
        vs1.addField("workflag", new Object[0]);
        for (PersonInfo info : personlist) {
            vs1.addRow(new Object[]{info.getUid(), info.getPhone(), info.getWorkStatus()});
        }
        model.batchCreateNewEntryRow("cardentry", vs1);
        model.endInit();
        this.getView().updateView("cardentry");
        AbstractGrid cardentry = (AbstractGrid)this.getControl("cardentry");
        cardentry.selectRows(0);
    }

    void setCurrentYear(int year) {
        this.getModel().setValue("year", (Object)year);
        Label label = (Label)this.getControl("yearshow");
        label.setText(year + "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markWorkCalendar(String date) {
        String orgId = this.getCurrentOrgId();
        if (StringUtils.isEmpty((CharSequence)orgId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5171\u4eab\u4e2d\u5fc3\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6743\u9650\u3002", (String)"SscWorkCalendarBasePlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"workcalendpanel"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"workcalendpanel"});
        SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date today = SDF.parse(this.getSscToday());
            Date selectDate = SDF.parse(date);
            IDataModel model = this.getModel();
            HashMap<String, String> params = new HashMap<String, String>(16);
            params.put("ssc", orgId);
            params.put("date", date);
            this.putSelectDateCache(date);
            this.removeWorkCalendarId();
            this.removeWorkDateEntryId();
            Label label = (Label)this.getView().getControl("datelabel");
            label.setText(date);
            this.getModel().setValue("selecteddate", (Object)date);
            this.getView().setVisible(Boolean.TRUE, new String[]{"btn_save", "syncothergroup"});
            switch (this.getCurrentEntityName()) {
                case "ssc_workcalendar_group": {
                    String userGroup = this.getCurrentGroup();
                    if (StringUtils.isEmpty((CharSequence)userGroup)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7528\u6237\u7ec4\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6743\u9650\u3002", (String)"SscWorkCalendarBasePlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        this.resetMarkType();
                        this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save", "syncothergroup"});
                        return;
                    }
                    DynamicObjectCollection timeDatas = SscWorkCalendarLoadService.getCalendarTimeOfWorkTime(params);
                    if (timeDatas != null && timeDatas.size() > 0) {
                        this.setSingleDaySetOfGroup(timeDatas, userGroup);
                        break;
                    }
                    this.resetMarkType();
                    if (selectDate.getTime() < today.getTime()) break;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u65e5\u671f\u5728\u5171\u4eab\u4e2d\u5fc3\u5de5\u4f5c\u65e5\u5386\u4e2d\u672a\u8bbe\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"SscWorkCalendarBasePlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save", "syncothergroup"});
                    return;
                }
                case "ssc_workcalendar_center": {
                    DynamicObjectCollection timeDatas = SscWorkCalendarLoadService.getCalendarTimeOfWorkTime(params);
                    this.setSingleDaySetOfSSC(timeDatas);
                    break;
                }
                case "ssc_workcalendar_employee": {
                    WorkCalendarUtils.cleanEntryEntity(model);
                    String userGroup = this.getCurrentGroup();
                    if (StringUtils.isEmpty((CharSequence)userGroup)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7528\u6237\u7ec4\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6743\u9650\u3002", (String)"SscWorkCalendarBasePlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        this.resetMarkType();
                        this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save", "syncothergroup"});
                        this.userOffAndOverTimeBtn(Boolean.FALSE);
                        return;
                    }
                    params.put("usergroup", userGroup);
                    List<Long> userIdList = SscWorkCalendarLoadService.getUserIdList(userGroup);
                    if (userIdList.size() <= 0) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u7528\u6237\uff0c\u8bf7\u68c0\u67e5\u7528\u6237\u7ec4\u8bbe\u7f6e\u3002", (String)"SscWorkCalendarBasePlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save", "syncothergroup"});
                        this.userOffAndOverTimeBtn(Boolean.FALSE);
                        this.resetMarkType();
                        return;
                    }
                    DynamicObjectCollection groupCols = SscWorkCalendarApi.getData(orgId, userGroup, selectDate, null);
                    if (groupCols.size() <= 0) {
                        DynamicObjectCollection sscCols = SscWorkCalendarApi.getData(orgId, null, selectDate, null);
                        if (sscCols.size() <= 0) {
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u65e5\u671f\u5728\u5171\u4eab\u4e2d\u5fc3\u5de5\u4f5c\u65e5\u5386\u4e2d\u672a\u8bbe\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"SscWorkCalendarBasePlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save", "syncothergroup"});
                            this.userOffAndOverTimeBtn(Boolean.FALSE);
                            this.resetMarkType();
                            return;
                        }
                        this.setSingleDaySetOfSSC(sscCols);
                    } else {
                        this.setSingleDaySetOfGroup(groupCols, userGroup);
                    }
                    String uid = this.getUidFromCache();
                    if (!StringUtils.isNotBlank((CharSequence)uid)) break;
                    ArrayList<Long> list = new ArrayList<Long>(1);
                    list.add(Long.valueOf(uid));
                    DynamicObjectCollection userCols = SscWorkCalendarApi.getData(orgId, userGroup, selectDate, list);
                    if (userCols == null || userCols.size() <= 0) break;
                    WorkCalendarUtils.setSingleDaySetOfUser(userCols, date, userGroup, uid, model);
                    break;
                }
            }
            if (selectDate.getTime() < today.getTime()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"savepanel"});
                this.userOffAndOverTimeBtn(Boolean.FALSE);
                this.getView().setEnable(Boolean.FALSE, new String[]{"restdate", "holiday", "workdate", "halfworkdate", "am_time", "pm_time", "morning", "afternoon"});
                return;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"savepanel"});
            this.userOffAndOverTimeBtn(Boolean.TRUE);
            this.getView().setEnable(Boolean.TRUE, new String[]{"restdate", "holiday", "workdate", "halfworkdate", "am_time", "pm_time", "morning", "afternoon"});
            return;
        }
        catch (ParseException e) {
            log.info(e.getMessage());
            return;
        }
        finally {
            this.removeDateTypeChangeCache();
        }
    }

    void setSingleDaySetOfSSC(DynamicObjectCollection timeDatas) {
        if (timeDatas != null && timeDatas.size() > 0) {
            DynamicObject validData = (DynamicObject)timeDatas.get(0);
            for (DynamicObject timeData : timeDatas) {
                if (!timeData.getString("dateentry.usergroup").equals("0")) continue;
                validData = timeData;
                break;
            }
            this.putWorkCalendarId(validData.getString("id"));
            this.putDateEntryId(validData.getString("dateentry.id"));
            this.markDataTime(validData);
        } else {
            this.resetMarkType();
        }
    }

    void setSingleDaySetOfGroup(DynamicObjectCollection timeDatas, String userGroup) {
        DynamicObject validData = (DynamicObject)timeDatas.get(0);
        for (DynamicObject timeData : timeDatas) {
            if (!timeData.getString("dateentry.usergroup").equals(userGroup)) continue;
            validData = timeData;
            this.putDateEntryId(validData.getString("dateentry.id"));
            break;
        }
        this.putWorkCalendarId(validData.getString("id"));
        this.markDataTime(validData);
    }

    private void markDataTime(DynamicObject validData) {
        this.resetMarkType();
        String dateType = validData.getString("dateentry.datetype");
        switch (SscDateType.getSscDateType((String)dateType)) {
            case WORKDATE: {
                this.getModel().setValue("workdate", (Object)Boolean.TRUE);
                this.getView().setVisible(Boolean.FALSE, new String[]{"halfworkdaypanel"});
                if ("ssc_workcalendar_employee".equals(this.getCurrentEntityName())) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"flexofftimeset"});
                }
                this.markWorkTime(validData, "");
                break;
            }
            case RESTDATE: {
                this.getModel().setValue("restdate", (Object)Boolean.TRUE);
                this.getView().setVisible(Boolean.FALSE, new String[]{"worktimepanel"});
                if (!"ssc_workcalendar_employee".equals(this.getCurrentEntityName())) break;
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexofftimeset"});
                break;
            }
            case HOLIDAY: {
                this.getModel().setValue("holiday", (Object)Boolean.TRUE);
                this.getView().setVisible(Boolean.FALSE, new String[]{"worktimepanel"});
                if (!"ssc_workcalendar_employee".equals(this.getCurrentEntityName())) break;
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexofftimeset"});
                break;
            }
            case HALFWORKDATEAM: {
                this.getModel().setValue("halfworkdate", (Object)Boolean.TRUE);
                this.getModel().setValue("am_time", (Object)Boolean.TRUE);
                this.getView().setVisible(Boolean.FALSE, new String[]{"afternoon"});
                if ("ssc_workcalendar_employee".equals(this.getCurrentEntityName())) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"flexofftimeset"});
                }
                this.markWorkTime(validData, "am");
                break;
            }
            case HALFWORKDATEPM: {
                this.getModel().setValue("halfworkdate", (Object)Boolean.TRUE);
                this.getModel().setValue("pm_time", (Object)Boolean.TRUE);
                this.getView().setVisible(Boolean.FALSE, new String[]{"morning"});
                if ("ssc_workcalendar_employee".equals(this.getCurrentEntityName())) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"flexofftimeset"});
                }
                this.markWorkTime(validData, "pm");
            }
        }
    }

    private void markWorkTime(DynamicObject validData, String timeType) {
        if (validData == null) {
            return;
        }
        switch (timeType) {
            case "am": {
                String begintimeam = validData.getString("dateentry.timeentry.begintimeam");
                String endtimeam = validData.getString("dateentry.timeentry.endtimeam");
                if (StringUtils.isNotEmpty((CharSequence)begintimeam)) {
                    this.getModel().setValue("morning_starttime", (Object)SscWorkCalendarUtil.getTimeShow(begintimeam));
                }
                if (!StringUtils.isNotEmpty((CharSequence)endtimeam)) break;
                this.getModel().setValue("morning_endtime", (Object)SscWorkCalendarUtil.getTimeShow(endtimeam));
                break;
            }
            case "pm": {
                String begintimepm = validData.getString("dateentry.timeentry.begintimepm");
                String endtimepm = validData.getString("dateentry.timeentry.endtimepm");
                if (StringUtils.isNotEmpty((CharSequence)begintimepm)) {
                    this.getModel().setValue("afternoon_starttime", (Object)SscWorkCalendarUtil.getTimeShow(begintimepm));
                }
                if (!StringUtils.isNotEmpty((CharSequence)endtimepm)) break;
                this.getModel().setValue("afternoon_endtime", (Object)SscWorkCalendarUtil.getTimeShow(endtimepm));
                break;
            }
            default: {
                String begintimeam = validData.getString("dateentry.timeentry.begintimeam");
                String endtimeam = validData.getString("dateentry.timeentry.endtimeam");
                if (StringUtils.isNotEmpty((CharSequence)begintimeam)) {
                    this.getModel().setValue("morning_starttime", (Object)SscWorkCalendarUtil.getTimeShow(begintimeam));
                }
                if (StringUtils.isNotEmpty((CharSequence)endtimeam)) {
                    this.getModel().setValue("morning_endtime", (Object)SscWorkCalendarUtil.getTimeShow(endtimeam));
                }
                String begintimepm = validData.getString("dateentry.timeentry.begintimepm");
                String endtimepm = validData.getString("dateentry.timeentry.endtimepm");
                if (StringUtils.isNotEmpty((CharSequence)begintimepm)) {
                    this.getModel().setValue("afternoon_starttime", (Object)SscWorkCalendarUtil.getTimeShow(begintimepm));
                }
                if (!StringUtils.isNotEmpty((CharSequence)endtimepm)) break;
                this.getModel().setValue("afternoon_endtime", (Object)SscWorkCalendarUtil.getTimeShow(endtimepm));
            }
        }
    }

    void resetMarkType() {
        this.putDateTypeChangeCache();
        IDataModel model = this.getModel();
        model.setValue("restdate", null);
        model.setValue("workdate", null);
        model.setValue("halfworkdate", null);
        model.setValue("holiday", null);
        model.setValue("am_time", null);
        model.setValue("pm_time", null);
        model.setValue("morning_starttime", null);
        model.setValue("morning_endtime", null);
        model.setValue("afternoon_starttime", null);
        model.setValue("afternoon_endtime", null);
        this.getView().setVisible(Boolean.TRUE, new String[]{"morning", "afternoon", "worktimepanel", "halfworkdaypanel"});
    }

    String getCurrentUserId() {
        return RequestContext.get().getUserId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void savePersonalizedData() {
        Date date;
        Map<String, String> panelData = this.getPanelData();
        if (panelData == null) {
            return;
        }
        panelData.put("date", this.getPageCache().get("selectDate"));
        try {
            date = DateUtil.parse((String)this.getPageCache().get("selectDate"), (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            log.info(e.getMessage());
            return;
        }
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("ssc", "kd.ssc.task.ssc_workcalendar_queue");){
            String panelDataJson = CollectionUtils.isEmpty(panelData) ? "" : JSONObject.toJSONString(panelData);
            log.info("\u4fdd\u5b58\u5de5\u4f5c\u65e5\u5386\u5c55\u793a\u6570\u636e-\u4fdd\u5b58start: CurrentEntityName = {}, panelData = {}", (Object)this.getCurrentEntityName(), (Object)panelDataJson);
            switch (this.getCurrentEntityName()) {
                case "ssc_workcalendar_center": {
                    if (!this.saveWorkCalenderSsc(panelData)) return;
                    List<String> groups = SscWorkCalendarLoadService.getGroup(this.getCurrentOrgId());
                    groups.forEach(group -> pub.publish((Object)new WorkCalendarTaskMessage(this.getCurrentOrgId(), (String)group, SscWorkCalendarLoadService.getUserIdList(group), date, date, "ssc")));
                    return;
                }
                case "ssc_workcalendar_group": {
                    if (!this.saveWorkCalenderGroup(panelData)) return;
                    pub.publish((Object)new WorkCalendarTaskMessage(this.getCurrentOrgId(), this.getCurrentGroup(), SscWorkCalendarLoadService.getUserIdList(this.getCurrentGroup()), date, date, "usergroup"));
                    return;
                }
                case "ssc_workcalendar_employee": {
                    String uidStr = this.getUidFromCache();
                    if (!this.saveWorkCalenderUser(panelData)) return;
                    pub.publish((Object)new WorkCalendarTaskMessage(this.getCurrentOrgId(), this.getCurrentGroup(), Collections.singletonList(Long.parseLong(uidStr)), date, date, "user"));
                    return;
                }
            }
            return;
        }
    }

    boolean saveWorkCalenderSsc(Map<String, String> panelData) {
        String workCalendarId = this.getWorkCalendarId();
        if (StringUtils.isNotEmpty((CharSequence)workCalendarId)) {
            return this.updateWorkCalendar(workCalendarId, this.getDateEntryId(), panelData);
        }
        return this.newWorkCalendar(null, panelData);
    }

    boolean saveWorkCalenderGroup(Map<String, String> panelData) {
        String workCalendarId = this.getWorkCalendarId();
        String dateEntryId = this.getDateEntryId();
        if (StringUtils.isNotEmpty((CharSequence)workCalendarId)) {
            if (StringUtils.isNotEmpty((CharSequence)dateEntryId)) {
                return this.updateWorkCalendar(workCalendarId, dateEntryId, panelData);
            }
            return this.newWorkCalendar(workCalendarId, panelData);
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u6743\u9650\u4e0d\u8db3\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u6dfb\u52a0\u6743\u9650\u3002", (String)"SscWorkCalendarBasePlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        return false;
    }

    boolean saveWorkCalenderUser(Map<String, String> panelData) {
        if (this.getUidFromCache() == null) {
            return false;
        }
        String workCalendarId = this.getWorkCalendarId();
        String dateEntryId = this.getDateEntryId();
        if (StringUtils.isNotEmpty((CharSequence)workCalendarId) && StringUtils.isNotEmpty((CharSequence)dateEntryId)) {
            boolean off = this.isvalidOffTime();
            boolean over = this.isvalidOverTime();
            if (off && over) {
                return this.updateWorkCalendarUser(workCalendarId, dateEntryId, panelData);
            }
        }
        return false;
    }

    boolean isvalidOffTime() {
        IDataModel model = this.getModel();
        boolean flag = true;
        boolean workdate = (Boolean)model.getValue("workdate");
        boolean halfworkdate = (Boolean)model.getValue("halfworkdate");
        String amStart = null;
        String amEnd = null;
        String pmStart = null;
        String pmEnd = null;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("offtimeentryentity");
        if (entryEntity != null && entryEntity.size() > 0) {
            for (int rowIndex = 0; rowIndex < entryEntity.size(); ++rowIndex) {
                int currentOffBeginTime = (Integer)model.getValue("offtimestart", rowIndex);
                int currentOffEndTime = (Integer)model.getValue("offtimeend", rowIndex);
                if (workdate) {
                    amStart = SscWorkCalendarUtil.getTimeShow((Integer)model.getValue("morning_starttime"));
                    amEnd = SscWorkCalendarUtil.getTimeShow((Integer)model.getValue("morning_endtime"));
                    pmStart = SscWorkCalendarUtil.getTimeShow((Integer)model.getValue("afternoon_starttime"));
                    pmEnd = SscWorkCalendarUtil.getTimeShow((Integer)model.getValue("afternoon_endtime"));
                    if (currentOffBeginTime >= SscWorkCalendarUtil.getTimeShow(amStart) && currentOffEndTime <= SscWorkCalendarUtil.getTimeShow(amEnd)) {
                        flag = true;
                        continue;
                    }
                    if (currentOffBeginTime >= SscWorkCalendarUtil.getTimeShow(pmStart) && currentOffEndTime <= SscWorkCalendarUtil.getTimeShow(pmEnd)) {
                        flag = true;
                        continue;
                    }
                    flag = false;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5047\u65f6\u95f4\u5fc5\u987b\u5728\u5de5\u4f5c\u65f6\u95f4\u8303\u56f4\u5185\u3002", (String)"SscWorkCalendarUserEditPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (!halfworkdate) continue;
                boolean am = (Boolean)model.getValue("am_time");
                boolean pm = (Boolean)model.getValue("pm_time");
                if (am) {
                    amStart = SscWorkCalendarUtil.getTimeShow((Integer)model.getValue("morning_starttime"));
                    amEnd = SscWorkCalendarUtil.getTimeShow((Integer)model.getValue("morning_endtime"));
                    if (currentOffBeginTime >= SscWorkCalendarUtil.getTimeShow(amStart) && currentOffEndTime <= SscWorkCalendarUtil.getTimeShow(amEnd)) {
                        flag = true;
                        continue;
                    }
                    flag = false;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5047\u65f6\u95f4\u5fc5\u987b\u5728\u5de5\u4f5c\u65f6\u95f4\u8303\u56f4\u5185\u3002", (String)"SscWorkCalendarUserEditPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (!pm) continue;
                pmStart = SscWorkCalendarUtil.getTimeShow((Integer)model.getValue("afternoon_starttime"));
                pmEnd = SscWorkCalendarUtil.getTimeShow((Integer)model.getValue("afternoon_endtime"));
                if (currentOffBeginTime >= SscWorkCalendarUtil.getTimeShow(pmStart) && currentOffEndTime <= SscWorkCalendarUtil.getTimeShow(pmEnd)) {
                    flag = true;
                    continue;
                }
                flag = false;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5047\u65f6\u95f4\u5fc5\u987b\u5728\u5de5\u4f5c\u65f6\u95f4\u8303\u56f4\u5185\u3002", (String)"SscWorkCalendarUserEditPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                break;
            }
        }
        return flag;
    }

    boolean isvalidOverTime() {
        IDataModel model = this.getModel();
        boolean flag = true;
        boolean workdate = (Boolean)model.getValue("workdate");
        boolean halfworkdate = (Boolean)model.getValue("halfworkdate");
        String amStart = null;
        String amEnd = null;
        String pmStart = null;
        String pmEnd = null;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("overtimeentryentity");
        if (entryEntity != null && entryEntity.size() > 0) {
            for (int rowIndex = 0; rowIndex < entryEntity.size(); ++rowIndex) {
                int currentOffBeginTime = (Integer)model.getValue("overtimestart", rowIndex);
                int currentOffEndTime = (Integer)model.getValue("overtimeend", rowIndex);
                if (workdate) {
                    amStart = SscWorkCalendarUtil.getTimeShow((Integer)model.getValue("morning_starttime"));
                    amEnd = SscWorkCalendarUtil.getTimeShow((Integer)model.getValue("morning_endtime"));
                    pmStart = SscWorkCalendarUtil.getTimeShow((Integer)model.getValue("afternoon_starttime"));
                    pmEnd = SscWorkCalendarUtil.getTimeShow((Integer)model.getValue("afternoon_endtime"));
                    if (currentOffEndTime <= SscWorkCalendarUtil.getTimeShow(amStart) || currentOffBeginTime >= SscWorkCalendarUtil.getTimeShow(pmEnd)) {
                        flag = true;
                        continue;
                    }
                    if (currentOffBeginTime >= SscWorkCalendarUtil.getTimeShow(amEnd) && currentOffEndTime <= SscWorkCalendarUtil.getTimeShow(pmStart)) {
                        flag = true;
                        continue;
                    }
                    flag = false;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u52a0\u73ed\u65f6\u95f4\u5fc5\u987b\u5728\u975e\u5de5\u4f5c\u65f6\u95f4\u8303\u56f4\u5185\u3002", (String)"SscWorkCalendarUserEditPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (!halfworkdate) continue;
                boolean am = (Boolean)model.getValue("am_time");
                boolean pm = (Boolean)model.getValue("pm_time");
                if (am) {
                    amStart = SscWorkCalendarUtil.getTimeShow((Integer)model.getValue("morning_starttime"));
                    amEnd = SscWorkCalendarUtil.getTimeShow((Integer)model.getValue("morning_endtime"));
                    if (currentOffEndTime <= SscWorkCalendarUtil.getTimeShow(amStart) || currentOffBeginTime >= SscWorkCalendarUtil.getTimeShow(amEnd)) {
                        flag = true;
                        continue;
                    }
                    flag = false;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u52a0\u73ed\u65f6\u95f4\u5fc5\u987b\u5728\u975e\u5de5\u4f5c\u65f6\u95f4\u8303\u56f4\u5185\u3002", (String)"SscWorkCalendarUserEditPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (!pm) continue;
                pmStart = SscWorkCalendarUtil.getTimeShow((Integer)model.getValue("afternoon_starttime"));
                pmEnd = SscWorkCalendarUtil.getTimeShow((Integer)model.getValue("afternoon_endtime"));
                if (currentOffEndTime <= SscWorkCalendarUtil.getTimeShow(pmStart) || currentOffBeginTime >= SscWorkCalendarUtil.getTimeShow(pmEnd)) {
                    flag = true;
                    continue;
                }
                flag = false;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u52a0\u73ed\u65f6\u95f4\u5fc5\u987b\u5728\u975e\u5de5\u4f5c\u65f6\u95f4\u8303\u56f4\u5185\u3002", (String)"SscWorkCalendarUserEditPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                break;
            }
        }
        return flag;
    }

    boolean newWorkCalendar(String workCalendarId, Map<String, String> panelData) {
        SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
        try {
            DynamicObject workCalendar;
            Date date = SDF.parse(panelData.get("date"));
            if (StringUtils.isEmpty((CharSequence)workCalendarId)) {
                workCalendar = this.newWorkCalendar(panelData, date);
            } else {
                workCalendar = BusinessDataServiceHelper.loadSingle((Object)workCalendarId, (String)"ssc_workcalendarsetting");
                if (workCalendar == null) {
                    return false;
                }
            }
            DynamicObjectCollection dateEntrys = workCalendar.getDynamicObjectCollection("dateentry");
            DynamicObject dateEntry = this.setDateEntry(panelData, date, new DynamicObject(dateEntrys.getDynamicObjectType()));
            DynamicObjectCollection timeEntrys = dateEntry.getDynamicObjectCollection("timeentry");
            DynamicObject timeEntry = this.setTimeEntry(panelData, new DynamicObject(timeEntrys.getDynamicObjectType()));
            timeEntrys.add((Object)timeEntry);
            dateEntrys.add((Object)dateEntry);
            Object[] result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{workCalendar});
            if (result != null && result.length > 0) {
                DynamicObject dyn = (DynamicObject)result[0];
                this.putWorkCalendarId(dyn.getString("id"));
                for (DynamicObject entry : (DynamicObjectCollection)dyn.get("dateentry")) {
                    switch (this.getCurrentEntityName()) {
                        case "ssc_workcalendar_group": {
                            if (!date.equals(entry.getDate("date")) || !this.getCurrentGroup().equals(entry.getString("usergroup"))) break;
                            this.putDateEntryId(entry.getString("id"));
                            break;
                        }
                        case "ssc_workcalendar_center": {
                            if (!date.equals(entry.getDate("date")) || !this.getCurrentOrgId().equals(entry.getString("ssc"))) break;
                            this.putDateEntryId(entry.getString("id"));
                            break;
                        }
                    }
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SscWorkCalendarBasePlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        catch (ParseException e) {
            log.info(e.getMessage());
        }
        return false;
    }

    boolean updateWorkCalendar(String workCalendarId, String dateEntryId, Map<String, String> panelData) {
        SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
        try {
            DynamicObject timeEntry;
            Date date = SDF.parse(panelData.get("date"));
            DynamicObject workCalendar = BusinessDataServiceHelper.loadSingle((Object)workCalendarId, (String)"ssc_workcalendarsetting");
            if (workCalendar == null) {
                return false;
            }
            DynamicObjectCollection dateEntrys = workCalendar.getDynamicObjectCollection("dateentry");
            DynamicObject dateEntry = BusinessDataServiceHelper.loadSingle((Object)dateEntryId, (DynamicObjectType)dateEntrys.getDynamicObjectType());
            if (dateEntry == null) {
                return false;
            }
            this.setDateEntry(panelData, date, dateEntry);
            DynamicObjectCollection timeEntrys = dateEntry.getDynamicObjectCollection("timeentry");
            if (timeEntrys.size() == 0) {
                timeEntry = new DynamicObject(timeEntrys.getDynamicObjectType());
                timeEntrys.add((Object)timeEntry);
            } else {
                timeEntry = (DynamicObject)timeEntrys.get(0);
            }
            this.setTimeEntry(panelData, timeEntry);
            Object[] result = SaveServiceHelper.save((IDataEntityType)dateEntrys.getDynamicObjectType(), (Object[])new DynamicObject[]{dateEntry});
            if (result != null && result.length > 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SscWorkCalendarBasePlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        catch (ParseException e) {
            log.info(e.getMessage());
        }
        return false;
    }

    boolean updateWorkCalendarUser(String workCalendarId, String dateEntryId, Map<String, String> panelData) {
        SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Object[] result;
            DynamicObjectCollection overtimeSetCols;
            Date date = SDF.parse(panelData.get("date"));
            DynamicObject workCalendar = BusinessDataServiceHelper.loadSingle((Object)workCalendarId, (String)"ssc_workcalendarsetting");
            if (workCalendar == null) {
                return false;
            }
            DynamicObjectCollection dateEntrys = workCalendar.getDynamicObjectCollection("dateentry");
            DynamicObject dateEntry = new DynamicObject(dateEntrys.getDynamicObjectType());
            this.setDateEntry(panelData, date, dateEntry);
            DynamicObjectCollection timeEntrys = dateEntry.getDynamicObjectCollection("timeentry");
            Map<String, Object> dynamicObjectTypes = SscWorkCalendarLoadService.getDynamicObjectType(date, date, this.getCurrentOrgId());
            this.deleteEmpOffOrOverWorkData(date, date, (DynamicObjectType)dynamicObjectTypes.get("dateEntryType"));
            DynamicObjectCollection offtiemSetCols = this.getModel().getEntryEntity("offtimeentryentity");
            if (offtiemSetCols != null && offtiemSetCols.size() > 0) {
                for (Object obj : offtiemSetCols) {
                    DynamicObject timeEntry = new DynamicObject(timeEntrys.getDynamicObjectType());
                    int offStart = obj.getInt("offtimestart");
                    int offEnd = obj.getInt("offtimeend");
                    String offtimestart = SscWorkCalendarUtil.getTimeShow(offStart);
                    String offtimeend = SscWorkCalendarUtil.getTimeShow(offEnd);
                    log.info("\u4fdd\u5b58\u5de5\u4f5c\u65e5\u5386\u5c55\u793a\u6570\u636e-\u4fdd\u5b58: offtimestart = {}, offtimeend = {}", (Object)offtimestart, (Object)offtimeend);
                    if (offStart != -1 && offEnd != -1) {
                        this.setTimeEntry(offtimestart, offtimeend, timeEntry, SscTimeType.OFFTIME.getValue());
                        timeEntrys.add((Object)timeEntry);
                        continue;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8bf7\u5047\u5f00\u59cb\u548c\u7ed3\u675f\u65f6\u95f4\u3002", (String)"SscWorkCalendarBasePlugin_16", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return false;
                }
            }
            if ((overtimeSetCols = this.getModel().getEntryEntity("overtimeentryentity")) != null && overtimeSetCols.size() > 0) {
                for (DynamicObject obj : overtimeSetCols) {
                    DynamicObject timeEntry = new DynamicObject(timeEntrys.getDynamicObjectType());
                    int overStart = obj.getInt("overtimestart");
                    int overEnd = obj.getInt("overtimeend");
                    String overtimestart = SscWorkCalendarUtil.getTimeShow(overStart);
                    String overtimeend = SscWorkCalendarUtil.getTimeShow(overEnd);
                    log.info("\u4fdd\u5b58\u5de5\u4f5c\u65e5\u5386\u5c55\u793a\u6570\u636e-\u4fdd\u5b58: overtimestart = {}, overtimeend = {}", (Object)overtimestart, (Object)overtimeend);
                    if (overStart != -1 && overEnd != -1) {
                        this.setTimeEntry(overtimestart, overtimeend, timeEntry, SscTimeType.OVERTIME.getValue());
                        timeEntrys.add((Object)timeEntry);
                        continue;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u52a0\u73ed\u7684\u5f00\u59cb\u548c\u7ed3\u675f\u65f6\u95f4\u3002", (String)"SscWorkCalendarBasePlugin_17", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return false;
                }
            }
            if (offtiemSetCols != null && offtiemSetCols.size() > 0 || overtimeSetCols != null && overtimeSetCols.size() > 0) {
                dateEntrys.add((Object)dateEntry);
            }
            if ((result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{workCalendar})) != null) {
                this.setUserList();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SscWorkCalendarBasePlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        catch (ParseException e) {
            log.info(e.getMessage());
        }
        return false;
    }

    private void deleteEmpOffOrOverWorkData(Object startDate, Object endDate, DynamicObjectType dynamicObjectType) {
        QFilter filters = new QFilter("dateentry.ssc", "=", (Object)Long.parseLong(this.getCurrentOrgId()));
        filters.and(new QFilter("dateentry.usergroup", "=", (Object)Long.parseLong(this.getCurrentGroup())));
        filters.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.EMPLOYEE.getValue()));
        filters.and(new QFilter("dateentry.date", ">=", startDate));
        filters.and(new QFilter("dateentry.date", "<=", endDate));
        filters.and(new QFilter("dateentry.user", "=", (Object)Long.parseLong(this.getUidFromCache())));
        List dateentryids = QueryServiceHelper.query((String)"ssc_workcalendarsetting", (String)"dateentry.id", (QFilter[])new QFilter[]{filters}).stream().map(id -> id.get("dateentry.id")).collect(Collectors.toList());
        if (dateentryids.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)dynamicObjectType, (Object[])dateentryids.toArray());
        }
    }

    private DynamicObject newWorkCalendar(Map<String, String> panelData, Date selectDate) {
        Calendar calendarDate = Calendar.getInstance();
        calendarDate.setTime(selectDate);
        DynamicObject workCalendar = BusinessDataServiceHelper.newDynamicObject((String)"ssc_workcalendarsetting");
        workCalendar.set("status", (Object)"A");
        workCalendar.set("modifier", (Object)this.getCurrentUserId());
        workCalendar.set("createtime", (Object)new Date());
        workCalendar.set("modifytime", (Object)new Date());
        workCalendar.set("creator", (Object)this.getCurrentUserId());
        workCalendar.set("enable", (Object)"1");
        workCalendar.set("ssccenter", (Object)this.getCurrentOrgId());
        workCalendar.set("expiringyearfrom", (Object)calendarDate.get(1));
        workCalendar.set("expiringyearto", (Object)calendarDate.get(1));
        workCalendar.set("expiringmonthfrom", (Object)(calendarDate.get(2) + 1));
        workCalendar.set("expiringmonthto", (Object)(calendarDate.get(2) + 1));
        workCalendar.set("expiringdayfrom", (Object)calendarDate.get(5));
        workCalendar.set("expiringdayto", (Object)calendarDate.get(5));
        int weekday = calendarDate.get(7);
        switch (SscDateType.getSscDateType((String)panelData.get("datetype"))) {
            case WORKDATE: {
                String[] morningstarttime = panelData.get("morning_starttime").split(":");
                String[] morningendtime = panelData.get("morning_endtime").split(":");
                String[] afternoonstarttime = panelData.get("afternoon_starttime").split(":");
                String[] afternoonendtime = panelData.get("afternoon_endtime").split(":");
                workCalendar.set("hourofbegintimeam", (Object)morningstarttime[0]);
                workCalendar.set("minofbegintimeam", (Object)morningstarttime[1]);
                workCalendar.set("hourofendtimeam", (Object)morningendtime[0]);
                workCalendar.set("minofendtimeam", (Object)morningendtime[1]);
                workCalendar.set("hourofbegintimepm", (Object)afternoonstarttime[0]);
                workCalendar.set("minofbegintimepm", (Object)afternoonstarttime[1]);
                workCalendar.set("hourofendtimepm", (Object)afternoonendtime[0]);
                workCalendar.set("minofendtimepm", (Object)afternoonendtime[1]);
                break;
            }
            case RESTDATE: {
                this.generalRestDate(weekday, workCalendar);
                break;
            }
            case HALFWORKDATEAM: {
                String[] morningstarttime1 = panelData.get("morning_starttime").split(":");
                String[] morningendtim1 = panelData.get("morning_endtime").split(":");
                workCalendar.set("hourofbegintimeam", (Object)morningstarttime1[0]);
                workCalendar.set("minofbegintimeam", (Object)morningstarttime1[1]);
                workCalendar.set("hourofendtimeam", (Object)morningendtim1[0]);
                workCalendar.set("minofendtimeam", (Object)morningendtim1[1]);
                this.generalHalfWorkDate(weekday, workCalendar, "am");
                break;
            }
            case HALFWORKDATEPM: {
                String[] afternoonstarttime1 = panelData.get("afternoon_starttime").split(":");
                String[] afternoonendtime1 = panelData.get("afternoon_endtime").split(":");
                workCalendar.set("hourofbegintimepm", (Object)afternoonstarttime1[0]);
                workCalendar.set("minofbegintimepm", (Object)afternoonstarttime1[1]);
                workCalendar.set("hourofendtimepm", (Object)afternoonendtime1[0]);
                workCalendar.set("minofendtimepm", (Object)afternoonendtime1[1]);
                this.generalHalfWorkDate(weekday, workCalendar, "pm");
                break;
            }
        }
        return workCalendar;
    }

    protected DynamicObject setDateEntry(Map<String, String> panelData, Date date, DynamicObject dateEntry) {
        dateEntry.set("ssc", (Object)this.getCurrentOrgId());
        switch (this.getCurrentEntityName()) {
            case "ssc_workcalendar_group": {
                dateEntry.set("usergroup", (Object)this.getCurrentGroup());
                dateEntry.set("level", (Object)SscLevelType.GROUP.getValue());
                break;
            }
            case "ssc_workcalendar_center": {
                dateEntry.set("level", (Object)SscLevelType.SSCCENTER.getValue());
                break;
            }
            case "ssc_workcalendar_employee": {
                dateEntry.set("user", (Object)this.getUidFromCache());
                dateEntry.set("usergroup", (Object)this.getCurrentGroup());
                dateEntry.set("level", (Object)SscLevelType.EMPLOYEE.getValue());
                break;
            }
        }
        dateEntry.set("date", (Object)date);
        dateEntry.set("datetype", (Object)panelData.get("datetype"));
        return dateEntry;
    }

    private DynamicObject setTimeEntry(Map<String, String> panelData, DynamicObject timeEntry) {
        timeEntry.set("timeType", (Object)SscTimeType.WORKTIME.getValue());
        timeEntry.set("begintimeam", (Object)panelData.get("morning_starttime"));
        timeEntry.set("begintimepm", (Object)panelData.get("afternoon_starttime"));
        timeEntry.set("endtimeam", (Object)panelData.get("morning_endtime"));
        timeEntry.set("endtimepm", (Object)panelData.get("afternoon_endtime"));
        return timeEntry;
    }

    protected DynamicObject setTimeEntry(String beginTime, String endTime, DynamicObject timeEntry, String timeType) {
        timeEntry.set("timetype", (Object)timeType);
        timeEntry.set("begintimeam", (Object)beginTime);
        timeEntry.set("endtimeam", (Object)endTime);
        return timeEntry;
    }

    Map<String, String> getPanelData() {
        IDataModel model = this.getModel();
        HashMap<String, String> panelData = new HashMap<String, String>(16);
        boolean restdate = (Boolean)model.getValue("restdate");
        boolean holiday = (Boolean)model.getValue("holiday");
        boolean halfworkdate = (Boolean)model.getValue("halfworkdate");
        boolean workdate = (Boolean)model.getValue("workdate");
        boolean timepm = (Boolean)model.getValue("pm_time");
        boolean timeam = (Boolean)model.getValue("am_time");
        String dateType = "";
        if (restdate) {
            dateType = SscDateType.RESTDATE.getValue();
        } else if (holiday) {
            dateType = SscDateType.HOLIDAY.getValue();
        } else if (halfworkdate) {
            if (timeam) {
                dateType = SscDateType.HALFWORKDATEAM.getValue();
                Object morningStartTime = model.getValue("morning_starttime");
                Object morningEndTime = model.getValue("morning_endtime");
                if (morningStartTime == null || morningEndTime == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5de5\u4f5c\u65f6\u95f4\u3002", (String)"SscWorkCalendarBasePlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return null;
                }
                if (morningStartTime.equals(morningEndTime)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u5348\u7684\u5de5\u4f5c\u201c\u5f00\u59cb\u65f6\u95f4\u201d\u4e0e\u201c\u7ed3\u675f\u65f6\u95f4\u201d\u4e0d\u80fd\u76f8\u540c\u6216\u4e3a\u7a7a\u3002", (String)"SscWorkCalendarBasePlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return null;
                }
                panelData.put("morning_starttime", SscWorkCalendarUtil.getTimeShow((Integer)morningStartTime));
                panelData.put("morning_endtime", SscWorkCalendarUtil.getTimeShow((Integer)morningEndTime));
            } else if (timepm) {
                dateType = SscDateType.HALFWORKDATEPM.getValue();
                Object afternoonStartTime = model.getValue("afternoon_starttime");
                Object afternoonEndTime = model.getValue("afternoon_endtime");
                if (afternoonStartTime == null || afternoonEndTime == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5de5\u4f5c\u65f6\u95f4\u3002", (String)"SscWorkCalendarBasePlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return null;
                }
                if (afternoonStartTime.equals(afternoonEndTime)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u5348\u7684\u5de5\u4f5c\u201c\u5f00\u59cb\u65f6\u95f4\u201d\u4e0e\u201c\u7ed3\u675f\u65f6\u95f4\u201d\u4e0d\u80fd\u76f8\u540c\u6216\u4e3a\u7a7a\u3002", (String)"SscWorkCalendarBasePlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return null;
                }
                panelData.put("afternoon_starttime", SscWorkCalendarUtil.getTimeShow((Integer)afternoonStartTime));
                panelData.put("afternoon_endtime", SscWorkCalendarUtil.getTimeShow((Integer)afternoonEndTime));
            }
        } else if (workdate) {
            dateType = SscDateType.WORKDATE.getValue();
            Object morningStartTime = model.getValue("morning_starttime");
            Object morningEndTime = model.getValue("morning_endtime");
            Object afternoonStartTime = model.getValue("afternoon_starttime");
            Object afternoonEndTime = model.getValue("afternoon_endtime");
            if (morningStartTime == null || morningEndTime == null || afternoonStartTime == null || afternoonEndTime == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5de5\u4f5c\u65f6\u95f4\u3002", (String)"SscWorkCalendarBasePlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return null;
            }
            if (morningStartTime.equals(morningEndTime) || afternoonStartTime.equals(afternoonEndTime)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u76f8\u540c\u6216\u4e3a\u7a7a\u3002", (String)"SscWorkCalendarBasePlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return null;
            }
            if ((Integer)morningEndTime > (Integer)afternoonStartTime) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u5348\u5de5\u4f5c\u65f6\u95f4\u5e94\u665a\u4e8e\u4e0a\u5348\u5de5\u4f5c\u65f6\u95f4\u3002", (String)"SscWorkCalendarBasePlugin_12", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return null;
            }
            panelData.put("morning_starttime", SscWorkCalendarUtil.getTimeShow((Integer)morningStartTime));
            panelData.put("morning_endtime", SscWorkCalendarUtil.getTimeShow((Integer)morningEndTime));
            panelData.put("afternoon_starttime", SscWorkCalendarUtil.getTimeShow((Integer)afternoonStartTime));
            panelData.put("afternoon_endtime", SscWorkCalendarUtil.getTimeShow((Integer)afternoonEndTime));
        } else if (!this.getCurrentEntityName().equals("ssc_workcalendar_employee")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u7c7b\u578b\u3002", (String)"SscWorkCalendarBasePlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return null;
        }
        panelData.put("datetype", dateType);
        return panelData;
    }

    void toRestDate() {
        this.resetMarkType();
        this.getModel().setValue("restdate", (Object)Boolean.TRUE);
        this.getView().setVisible(Boolean.FALSE, new String[]{"worktimepanel"});
    }

    void toHoliday() {
        this.resetMarkType();
        this.getModel().setValue("holiday", (Object)Boolean.TRUE);
        this.getView().setVisible(Boolean.FALSE, new String[]{"worktimepanel"});
    }

    void toWorkDate() {
        this.resetMarkType();
        this.getModel().setValue("workdate", (Object)Boolean.TRUE);
        this.getView().setVisible(Boolean.FALSE, new String[]{"halfworkdaypanel"});
    }

    void toHalfWorkDate() {
        this.resetMarkType();
        this.getModel().setValue("halfworkdate", (Object)Boolean.TRUE);
        this.getView().setVisible(Boolean.FALSE, new String[]{"afternoon"});
        this.getModel().setValue("am_time", (Object)Boolean.TRUE);
        this.getModel().setValue("pm_time", (Object)Boolean.FALSE);
    }

    String getCurrentOrgId() {
        return this.getModel().getValue("ssccenter") + "";
    }

    int getCurrentYear() {
        return Integer.parseInt(this.getModel().getValue("year") + "");
    }

    String getCurrentGroup() {
        return this.getModel().getValue("usergroup") + "";
    }

    String getCurrentEntityName() {
        return this.getModel().getDataEntityType().getName();
    }

    void putDateTypeChangeCache() {
        this.getPageCache().put("dateTypeChange", "1");
    }

    void putSelectDateCache(String date) {
        this.getPageCache().put("selectDate", date);
    }

    void resetUser() {
        if ("ssc_workcalendar_employee".equals(this.getCurrentEntityName())) {
            this.setUserList();
        }
    }

    void putUidToCache(Long uid) {
        this.getPageCache().put("uid", String.valueOf(uid));
    }

    String getUidFromCache() {
        return this.getPageCache().get("uid");
    }

    void putWorkCalendarId(String workCalendarId) {
        this.getPageCache().put("workCalendarId", workCalendarId);
    }

    void putDateEntryId(String dateEntryId) {
        this.getPageCache().put("dateEntryId", dateEntryId);
    }

    String getWorkCalendarId() {
        return this.getPageCache().get("workCalendarId");
    }

    String getDateEntryId() {
        return this.getPageCache().get("dateEntryId");
    }

    void removeDateTypeChangeCache() {
        this.getPageCache().remove("dateTypeChange");
    }

    void removeWorkCalendarId() {
        this.getPageCache().remove("workCalendarId");
    }

    void removeWorkDateEntryId() {
        this.getPageCache().remove("dateEntryId");
    }

    void generalRestDate(int weekday, DynamicObject workCalendar) {
        switch (weekday) {
            case 1: {
                workCalendar.set("issunrest", (Object)Boolean.TRUE);
                break;
            }
            case 2: {
                workCalendar.set("ismonrest", (Object)Boolean.TRUE);
                break;
            }
            case 3: {
                workCalendar.set("istuerest", (Object)Boolean.TRUE);
                break;
            }
            case 4: {
                workCalendar.set("iswedrest", (Object)Boolean.TRUE);
                break;
            }
            case 5: {
                workCalendar.set("isthurest", (Object)Boolean.TRUE);
                break;
            }
            case 6: {
                workCalendar.set("isfrirest", (Object)Boolean.TRUE);
                break;
            }
            case 7: {
                workCalendar.set("issatrest", (Object)Boolean.TRUE);
                break;
            }
        }
    }

    void generalHalfWorkDate(int weekday, DynamicObject workCalendar, String type) {
        switch (weekday) {
            case 1: {
                workCalendar.set("ishalfsunrest" + type, (Object)Boolean.TRUE);
                break;
            }
            case 2: {
                workCalendar.set("ishalfmonrest" + type, (Object)Boolean.TRUE);
                break;
            }
            case 3: {
                workCalendar.set("ishalftuerest" + type, (Object)Boolean.TRUE);
                break;
            }
            case 4: {
                workCalendar.set("ishalfwedrest" + type, (Object)Boolean.TRUE);
                break;
            }
            case 5: {
                workCalendar.set("ishalfthurest" + type, (Object)Boolean.TRUE);
                break;
            }
            case 6: {
                workCalendar.set("ishalffrirest" + type, (Object)Boolean.TRUE);
                break;
            }
            case 7: {
                workCalendar.set("ishalfsatrest" + type, (Object)Boolean.TRUE);
                break;
            }
        }
    }

    private void userOffAndOverTimeBtn(Boolean show) {
        this.getView().setVisible(show, new String[]{"offtime_add", "offtime_del", "overtime_add", "overtime_del"});
    }

    private boolean enableUserGroup(String userGroup) {
        DynamicObject group;
        this.getView().setEnable(Boolean.TRUE, new String[]{"btn_save", "bar_batchset", "syncothergroup"});
        if (StringUtils.isNotEmpty((CharSequence)userGroup) && (group = QueryServiceHelper.queryOne((String)"task_usergroup", (String)"id,enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(userGroup))})) != null && !group.getBoolean("enable")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u7ec4\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u7f16\u8f91\u5de5\u4f5c\u65e5\u5386\u3002", (String)"SscWorkCalendarBasePlugin_19", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save", "bar_batchset", "syncothergroup"});
            return false;
        }
        return true;
    }

    protected String getSscToday() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DynamicObject sscInfo = (DynamicObject)this.getModel().getValue("orgfield");
        DynamicObject timezone = sscInfo.getDynamicObject("timezone");
        if (timezone != null) {
            String number = sscInfo.getDynamicObject("timezone").getString("number");
            sdf.setTimeZone(TimeZone.getTimeZone(number));
        }
        String today = sdf.format(new Date());
        log.info(sscInfo.getString("name") + "\u7684\u4eca\u65e5\u65f6\u95f4\u4e3a" + today);
        return today;
    }
}

