/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.workcalendar;

import java.util.Calendar;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.WorkCalendar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.common.workcalendar.WorkCalendarUtils;
import kd.ssc.task.formplugin.workcalendar.SscWorkCalendarBasePlugin;

public class SscWorkCalendarEditPlugin
extends SscWorkCalendarBasePlugin
implements IConfirmCallBack {
    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setInit();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (propName.equals("ssccenter")) {
            this.setInit();
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (evt.getItemKey().equals("bar_refresh")) {
            this.setInit();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("bacthset".equals(closedCallBackEvent.getActionId())) {
            if (WorkCalendarUtils.isExistCalendar(this.getCurrentOrgId(), this.getCurrentYear())) {
                int year = Calendar.getInstance().get(1);
                this.setCurYear(year);
                if (!this.loadBaseWorkCalendar(year)) {
                    this.loadEmptyWorkCalendar(year);
                }
                String selecteddate = this.getModel().getValue("selecteddate") + "";
                this.markWorkCalendar(selecteddate);
                this.setInit();
            }
            this.getView().updateView("country");
            this.getView().updateView("timezone");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        afterDoOperationEventArgs.getOperationResult();
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "donothing_batchset": {
                this.showForm(false);
                break;
            }
            case "donothing_save": {
                this.savePersonalizedData();
                this.loadBaseWorkCalendar(this.getCurrentYear());
                break;
            }
            case "donothing_init": {
                String init = this.getPageCache().get("init");
                if (!StringUtils.isNotBlank((CharSequence)init) || !init.equals("1")) break;
                this.showForm(true);
                break;
            }
        }
    }

    private void showForm(boolean init) {
        String orgId = this.getCurrentOrgId().trim();
        if (StringUtils.isEmpty((CharSequence)orgId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u6743\u9650\u4e0d\u8db3\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SscWorkCalendarEditPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("formId", "ssc_workcalendarsetting");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8bbe\u7f6e\u5de5\u4f5c\u65e5\u5386", (String)"SscWorkCalendarEditPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        showParameter.setShowTitle(true);
        showParameter.setCustomParams(map);
        map.put("creatorid", Long.parseLong(this.getCurrentUserId()));
        map.put("ssccenterid", this.getCurrentOrgId());
        map.put("init", init);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bacthset"));
        this.getView().showForm(showParameter);
    }

    private void loadEmptyWorkCalendar(int year) {
        this.setCurYear(year);
        WorkCalendar workCalendar = (WorkCalendar)this.getControl("workcalendarap");
        workCalendar.setYear(year);
        workCalendar.setToday(this.getSscToday());
        workCalendar.setData();
    }

    private void setCurYear(int year) {
        this.getModel().setValue("year", (Object)year);
        Label label = (Label)this.getControl("yearshow");
        label.setText(String.valueOf(year));
    }

    private void setInit() {
        boolean init;
        String ssc = this.getModel().getValue("ssccenter") + "";
        boolean bl = init = !QueryServiceHelper.exists((String)"ssc_workcalendar_init", (QFilter[])new QFilter[]{new QFilter("initssc", "=", (Object)Long.parseLong(ssc))});
        if (init) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_init"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_batchset"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save"});
            this.getPageCache().put("init", "1");
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_init"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_batchset"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"btn_save"});
            this.getPageCache().put("init", "0");
        }
    }
}

