/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.workcalendar;

import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ssc.enums.workcalendar.SscDateType;
import kd.ssc.enums.workcalendar.SscLevelType;
import kd.ssc.task.common.LogBuildUtil;
import kd.ssc.task.common.workcalendar.WorkCalendarServiceHelper;
import kd.ssc.task.formplugin.pojo.workcalendar.WorkCalendarTaskMessage;
import kd.ssc.task.formplugin.util.DateUtil;
import kd.ssc.task.formplugin.util.SscWorkCalendarLoadService;

public class SscWorkCalendarMultiplexPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String SOURCE_USER_GROUP = "sourceusergroup";
    private static final String CONFIRM_MULTIPLEX_CALLBACK = "confirmMultiplexCallback";
    private static final String CONTINUE_CLOSE_CALLBACK = "continueClose";
    private static final Log log = LogFactory.getLog(SscWorkCalendarMultiplexPlugin.class);

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String userGroup = (String)parameter.getCustomParam("groupId");
        if (StringUtils.isEmpty((CharSequence)userGroup)) {
            return;
        }
        if (this.isEnableSourceUserGroup(userGroup)) {
            this.getModel().setValue(SOURCE_USER_GROUP, (Object)Long.parseLong(userGroup));
            this.getPageCache().put(SOURCE_USER_GROUP, this.getModel().getValue(SOURCE_USER_GROUP) + "");
        }
    }

    private boolean isEnableSourceUserGroup(String sourceUserGroupId) {
        DynamicObject group = QueryServiceHelper.queryOne((String)"task_usergroup", (String)"id,enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(sourceUserGroupId))});
        if (group == null) {
            return Boolean.FALSE;
        }
        return group.getBoolean("enable");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            switch (e.getOperateKey()) {
                case "btnok": {
                    if (!this.dateIsValid().booleanValue()) {
                        return;
                    }
                    this.showConfirmForm();
                    this.addOperationLog();
                    break;
                }
            }
        }
    }

    private void addOperationLog() {
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u590d\u7528\u5230", "SscWorkCalendarMultiplexPlugin_7", "ssc-task-formplugin");
        MultiLangEnumBridge opDes = new MultiLangEnumBridge("\u5de5\u4f5c\u65e5\u5386\u590d\u7528\u64cd\u4f5c\u3002", "SscWorkCalendarMultiplexPlugin_6", "ssc-task-formplugin");
        OpLogAppInfo opLogAppInfo = LogBuildUtil.buildLogInfo(this.getView(), null, "ssc_calendar_multiplex", "multiplex", opName, opDes, new String[0]);
        LogServiceHelper.addLog((AppLogInfo)opLogAppInfo);
    }

    private void showConfirmForm() {
        IDataModel model = this.getModel();
        String sourceUserGroupName = ((DynamicObject)model.getValue(SOURCE_USER_GROUP)).getString("name");
        String targetUserGroupName = this.getTargetUserGroupName();
        String dateTypeName = this.getDateTypeName();
        String dateRange = this.getDateRange();
        String caption = String.format(ResManager.loadKDString((String)"\u5c06\u3010%1$s\u3011\u3010%2$s\u3011\u3010%3$s\u3011\u7684\u7528\u6237\u7ec4\u4e2a\u6027\u5316\u5de5\u4f5c\u65e5\u5386\u6570\u636e\u590d\u7528\u81f3\u3010%4$s\u3011\uff0c\u6b64\u64cd\u4f5c\u4e0d\u53ef\u64a4\u56de\uff0c\u786e\u5b9a\u590d\u7528\u5417\uff1f", (String)"SscWorkCalendarMultiplexPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), sourceUserGroupName, dateRange, dateTypeName, targetUserGroupName);
        this.getView().showConfirm(caption, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_MULTIPLEX_CALLBACK, (IFormPlugin)this));
    }

    private String getDateRange() {
        IDataModel model = this.getModel();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = (Date)model.getValue("startdate");
        Date endDate = (Date)model.getValue("enddate");
        String dateRange = StringUtils.join((Object[])new String[]{dateFormat.format(startDate), "~", dateFormat.format(endDate)});
        return dateRange;
    }

    private String getTargetUserGroupName() {
        IDataModel model = this.getModel();
        DynamicObjectCollection targetUserGroupList = (DynamicObjectCollection)model.getValue("targetusergroup");
        if (CollectionUtils.isEmpty((Collection)targetUserGroupList)) {
            return "";
        }
        StringBuilder targetUserGroupNameStr = new StringBuilder();
        for (DynamicObject targetUserGroup : targetUserGroupList) {
            String targetUserGroupName = targetUserGroup.getDynamicObject("fbasedataid").getString("name");
            targetUserGroupNameStr.append(targetUserGroupName).append(";");
        }
        return targetUserGroupNameStr.substring(0, targetUserGroupNameStr.length() - 1);
    }

    private List<Long> getTargetUserGroupId() {
        IDataModel model = this.getModel();
        DynamicObjectCollection targetUserGroupList = (DynamicObjectCollection)model.getValue("targetusergroup");
        ArrayList<Long> targetUserGroupIds = new ArrayList<Long>();
        for (DynamicObject targetUserGroup : targetUserGroupList) {
            Long targetUserGroupId = targetUserGroup.getDynamicObject("fbasedataid").getLong("id");
            targetUserGroupIds.add(targetUserGroupId);
        }
        return targetUserGroupIds;
    }

    private String getDateTypeName() {
        IDataModel model = this.getModel();
        String dateTypeStr = (String)model.getValue("datetype");
        if (StringUtils.isEmpty((CharSequence)dateTypeStr)) {
            return "";
        }
        String[] dateTypeSplit = dateTypeStr.split(",");
        StringBuilder dateTypeNameStr = new StringBuilder();
        block10: for (int i = 0; i < dateTypeSplit.length; ++i) {
            switch (dateTypeSplit[i]) {
                case "workdate": {
                    dateTypeNameStr.append(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5", (String)"SscWorkCalendarMultiplexPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0])).append(";");
                    continue block10;
                }
                case "restdate": {
                    dateTypeNameStr.append(ResManager.loadKDString((String)"\u4f11\u606f\u65e5", (String)"SscWorkCalendarMultiplexPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0])).append(";");
                    continue block10;
                }
                case "halfworkdate": {
                    dateTypeNameStr.append(ResManager.loadKDString((String)"\u534a\u5de5\u4f5c\u65e5", (String)"SscWorkCalendarMultiplexPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0])).append(";");
                    continue block10;
                }
            }
        }
        return dateTypeNameStr.substring(0, dateTypeNameStr.length() - 1);
    }

    private List<String> getDateTypeList() {
        IDataModel model = this.getModel();
        String dateTypeStr = (String)model.getValue("datetype");
        String[] dateTypeSplit = dateTypeStr.split(",");
        ArrayList<String> dateTypeList = new ArrayList<String>();
        block10: for (int i = 0; i < dateTypeSplit.length; ++i) {
            switch (dateTypeSplit[i]) {
                case "workdate": {
                    dateTypeList.add(SscDateType.WORKDATE.getValue());
                    continue block10;
                }
                case "restdate": {
                    dateTypeList.add(SscDateType.RESTDATE.getValue());
                    continue block10;
                }
                case "halfworkdate": {
                    dateTypeList.add(SscDateType.HALFWORKDATEAM.getValue());
                    dateTypeList.add(SscDateType.HALFWORKDATEPM.getValue());
                    continue block10;
                }
            }
        }
        return dateTypeList;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if ("btncancel".equals(c.getKey())) {
            this.closeView();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (CONFIRM_MULTIPLEX_CALLBACK.equals(event.getCallBackId())) {
            if (event.getResult() == MessageBoxResult.Yes) {
                Date startDate = (Date)this.getModel().getValue("startdate");
                Date endDate = (Date)this.getModel().getValue("enddate");
                FormShowParameter parameter = this.getView().getFormShowParameter();
                String sscId = (String)parameter.getCustomParam("ssccenterid");
                DynamicObject sourceUserGroupDynObj = (DynamicObject)this.getModel().getValue(SOURCE_USER_GROUP);
                List<Long> targetUserGroupIds = this.getTargetUserGroupId();
                List<String> dateTypeList = this.getDateTypeList();
                try {
                    long sourceusergroup = sourceUserGroupDynObj.getLong("id");
                    String targetusergroupJson = JSONObject.toJSONString(targetUserGroupIds);
                    String datetypeJson = JSONObject.toJSONString(dateTypeList);
                    log.info("\u4fdd\u5b58\u5de5\u4f5c\u65e5\u5386\u5c55\u793a\u6570\u636e-\u590d\u7528\u5230start: sscId = {},startDate = {}, endDate = {}, sourceusergroup = {}, targetusergroup = {}, datetype = {}", new Object[]{sscId, startDate, endDate, sourceusergroup, targetusergroupJson, datetypeJson});
                }
                catch (Exception e) {
                    log.error("\u4fdd\u5b58\u5de5\u4f5c\u65e5\u5386\u5c55\u793a\u6570\u636e-\u590d\u7528\u5230\uff0c\u53c2\u6570\u65e5\u5fd7\u6253\u5370\u5f02\u5e38", (Throwable)e);
                }
                QFilter filters = new QFilter("dateentry.ssc", "=", (Object)Long.parseLong(sscId));
                filters.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.SSCCENTER.getValue()));
                filters.and(new QFilter("dateentry.date", ">=", (Object)startDate));
                filters.and(new QFilter("dateentry.date", "<=", (Object)endDate));
                HashSet workCalendarIds = new HashSet(QueryServiceHelper.queryPrimaryKeys((String)"ssc_workcalendarsetting", (QFilter[])new QFilter[]{filters}, null, (int)-1));
                if (CollectionUtils.isEmpty(workCalendarIds)) {
                    this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SscWorkCalendarBasePlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    this.getView().getParentView().setReturnData((Object)"refreshData");
                    this.getView().close();
                    return;
                }
                DynamicObject[] workCalendars = BusinessDataServiceHelper.load((Object[])workCalendarIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ssc_workcalendarsetting"));
                DynamicObjectCollection dateentrys = workCalendars[0].getDynamicObjectCollection("dateentry");
                DynamicObjectType dateEntryType = dateentrys.getDynamicObjectType();
                QFilter filters1 = new QFilter("dateentry.ssc", "=", (Object)Long.parseLong(sscId));
                filters1.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.GROUP.getValue()));
                filters1.and(new QFilter("dateentry.date", ">=", (Object)startDate));
                filters1.and(new QFilter("dateentry.date", "<=", (Object)endDate));
                filters1.and(new QFilter("dateentry.usergroup", "in", targetUserGroupIds));
                List dateentryids = QueryServiceHelper.query((String)"ssc_workcalendarsetting", (String)"dateentry.id", (QFilter[])new QFilter[]{filters1}).stream().map(id -> id.getLong("dateentry.id")).collect(Collectors.toList());
                if (dateentryids.size() > 0) {
                    DeleteServiceHelper.delete((IDataEntityType)dateEntryType, (Object[])dateentryids.toArray());
                }
                QFilter filters2 = new QFilter("dateentry.ssc", "=", (Object)Long.parseLong(sscId));
                filters2.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.GROUP.getValue()));
                filters2.and(new QFilter("dateentry.date", ">=", (Object)startDate));
                filters2.and(new QFilter("dateentry.date", "<=", (Object)endDate));
                filters2.and(new QFilter("dateentry.usergroup", "=", (Object)sourceUserGroupDynObj.getLong("id")));
                filters2.and(new QFilter("dateentry.datetype", "in", dateTypeList));
                List sourceDateEntryIds = QueryServiceHelper.query((String)"ssc_workcalendarsetting", (String)"dateentry.id", (QFilter[])new QFilter[]{filters2}).stream().map(id -> id.getLong("dateentry.id")).collect(Collectors.toList());
                DynamicObject[] sourceDateEntrys = BusinessDataServiceHelper.load((Object[])sourceDateEntryIds.toArray(), (DynamicObjectType)dateEntryType);
                Map<Long, List<Long>> workCalendarIdMap = SscWorkCalendarMultiplexPlugin.buildWorkCalendarIdMap(workCalendars);
                Map<Long, DynamicObject> userGroupInfoMap = WorkCalendarServiceHelper.batchQueryUserGroupInfoByGroupId(targetUserGroupIds);
                for (Long userGroupId : targetUserGroupIds) {
                    for (DynamicObject workCalendar : workCalendars) {
                        DynamicObjectCollection sscDateEntrys = workCalendar.getDynamicObjectCollection("dateentry");
                        List<Long> workCalendarDateEntryIds = workCalendarIdMap.get((Long)workCalendar.getPkValue());
                        for (DynamicObject sourceDateEntry : sourceDateEntrys) {
                            if (!workCalendarDateEntryIds.contains(sourceDateEntry.get("id"))) continue;
                            CloneUtils cloneUtils = new CloneUtils(false, true);
                            DynamicObject targetDateEntry = (DynamicObject)cloneUtils.clone((IDataEntityBase)sourceDateEntry);
                            DynamicObject userGroupInfo = userGroupInfoMap.get(userGroupId);
                            targetDateEntry.set("usergroup", (Object)userGroupInfo);
                            sscDateEntrys.add((Object)targetDateEntry);
                        }
                    }
                }
                SaveServiceHelper.save((DynamicObject[])workCalendars);
                IFormView parentView = this.getView().getParentView();
                parentView.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SscWorkCalendarBasePlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                parentView.setReturnData((Object)"refreshData");
                this.getView().sendFormAction(parentView);
                this.getView().close();
                try (MessagePublisher pub = MQFactory.get().createSimplePublisher("ssc", "kd.ssc.task.ssc_workcalendar_queue");){
                    for (Long userGorupId : targetUserGroupIds) {
                        pub.publish((Object)new WorkCalendarTaskMessage(sscId, userGorupId + "", SscWorkCalendarLoadService.getUserIdList(userGorupId + ""), startDate, endDate, "usergroup"));
                    }
                }
            }
        } else if (CONTINUE_CLOSE_CALLBACK.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            this.getView().close();
        }
    }

    private static Map<Long, List<Long>> buildWorkCalendarIdMap(DynamicObject[] workCalendars) {
        HashMap<Long, List<Long>> workCalendarIdMap = new HashMap<Long, List<Long>>(16);
        for (DynamicObject workCalendar : workCalendars) {
            DynamicObjectCollection sscDateEntrys = workCalendar.getDynamicObjectCollection("dateentry");
            List workCalendarDateEntryIds = sscDateEntrys.stream().map(entry -> entry.getLong("id")).collect(Collectors.toList());
            Long workCalendarId = (Long)workCalendar.getPkValue();
            workCalendarIdMap.put(workCalendarId, workCalendarDateEntryIds);
        }
        return workCalendarIdMap;
    }

    public void closeView() {
        if (this.valueChange()) {
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(CONTINUE_CLOSE_CALLBACK, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SscWorkCalendarUserSettingPlugin_13", (String)"ssc-task-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBack);
        } else {
            this.getView().close();
        }
    }

    private boolean valueChange() {
        String targetUserGroupName = this.getTargetUserGroupName();
        if (StringUtils.isNotEmpty((CharSequence)targetUserGroupName)) {
            return Boolean.TRUE;
        }
        String dateTypeName = this.getDateTypeName();
        if (!StringUtils.equals((CharSequence)dateTypeName, (CharSequence)this.getDefaultDateType())) {
            return Boolean.TRUE;
        }
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (startDate != null || endDate != null) {
            return Boolean.TRUE;
        }
        String sourceUserGroupCache = this.getPageCache().get(SOURCE_USER_GROUP) + "";
        String sourceUserGroupNew = this.getModel().getValue(SOURCE_USER_GROUP) + "";
        if (!StringUtils.equals((CharSequence)sourceUserGroupNew, (CharSequence)sourceUserGroupCache)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private String getDefaultDateType() {
        return ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5;\u534a\u5de5\u4f5c\u65e5;\u4f11\u606f\u65e5", (String)"SscWorkCalendarMultiplexPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit targetUserGroup = (BasedataEdit)this.getView().getControl("targetusergroup");
        BasedataEdit sourceUserGroup = (BasedataEdit)this.getView().getControl(SOURCE_USER_GROUP);
        targetUserGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        sourceUserGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (StringUtils.equals((CharSequence)"targetusergroup", (CharSequence)name)) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String sscId = (String)parameter.getCustomParam("ssccenterid");
            DynamicObject sourceUserGroupDyn = (DynamicObject)this.getModel().getValue(SOURCE_USER_GROUP);
            QFilter qFilter = new QFilter("createorg", "=", (Object)Long.parseLong(sscId));
            if (sourceUserGroupDyn != null) {
                qFilter.and(new QFilter("id", "!=", sourceUserGroupDyn.getPkValue()));
            }
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        } else if (StringUtils.equals((CharSequence)SOURCE_USER_GROUP, (CharSequence)name)) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String sscId = (String)parameter.getCustomParam("ssccenterid");
            List<Long> targetUserGroupId = this.getTargetUserGroupId();
            QFilter qFilter = new QFilter("createorg", "=", (Object)Long.parseLong(sscId));
            if (CollectionUtils.isNotEmpty(targetUserGroupId)) {
                qFilter.and(new QFilter("id", "not in", targetUserGroupId));
            }
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "startdate": 
            case "enddate": {
                this.dateIsValid();
                break;
            }
            case "sourceusergroup": {
                this.getModel().setValue("targetusergroup", null);
                break;
            }
        }
    }

    private Boolean dateIsValid() {
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (startDate == null || endDate == null) {
            return Boolean.FALSE;
        }
        try {
            Date now = DateUtil.parse(DateUtil.format(new Date(), "yyyy-MM-dd"), "yyyy-MM-dd");
            if (startDate.getTime() < now.getTime()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5f00\u59cb\u65e5\u671f\u201d\u5e94\u665a\u4e8e\u6216\u8005\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"SscWorkCalendarGroupSettingPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
        }
        catch (ParseException e) {
            return Boolean.FALSE;
        }
        long diffMillis = endDate.getTime() - startDate.getTime();
        long diffDays = diffMillis / 86400000L;
        if (diffDays > 364L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc71\u5e74\u3002", (String)"SscWorkCalendarMultiplexPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

