/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.workcalendar;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.cache.SscDistributeCache;
import kd.ssc.enums.workcalendar.SscDateType;
import kd.ssc.enums.workcalendar.SscLevelType;
import kd.ssc.enums.workcalendar.SscTimeOp;
import kd.ssc.task.common.workcalendar.WorkCalendarServiceHelper;
import kd.ssc.task.formplugin.pojo.PersonInfo;
import kd.ssc.task.formplugin.util.SscWorkCalendarLoadService;
import kd.ssc.task.formplugin.util.SscWorkCalendarUtil;
import kd.ssc.task.util.DateUtil;

public class SscWorkCalendarUserSettingPlugin
extends AbstractFormPlugin {
    private static final String offFlag = "offFlag";
    private static final String overFlag = "overFlag";
    private boolean isUpdate = true;
    private static final String SYNC_OTHER_GROUP = "syncOtherGroup";
    private static final Log log = LogFactory.getLog(SscWorkCalendarUserSettingPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setUser();
        boolean hasPermission = this.checkSyncOtherGroupPermission();
        if (!hasPermission) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"syncothergroup"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("confirm".equals(operateKey)) {
            String offStarTime = (String)this.getModel().getValue("offstarttime");
            String offEndTime = (String)this.getModel().getValue("offendtime");
            Integer startTimeInt = this.getTimeInt(offStarTime);
            Integer endTimeInt = this.getTimeInt(offEndTime);
            if (startTimeInt == null || endTimeInt == null) {
                return;
            }
            if (startTimeInt > endTimeInt) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5f00\u59cb\u65f6\u95f4\u201d\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u201c\u7ed3\u675f\u65f6\u95f4\u201d\u3002", (String)"SscWorkCalendarUserSettingPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private Integer getTimeInt(String timeStr) {
        if (StringUtils.isEmpty((CharSequence)timeStr)) {
            return null;
        }
        String[] timeArr = timeStr.split(":");
        return Integer.parseInt(timeArr[0]) * 60 + Integer.parseInt(timeArr[1]);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("confirm".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            String primaryKeyStr = SscDistributeCache.get((String)"work_calendar_sync_other_group");
            if (StringUtils.isNotEmpty((CharSequence)primaryKeyStr) && StringUtils.equals((CharSequence)primaryKeyStr, (CharSequence)this.getSscCenter())) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5171\u4eab\u4e2d\u5fc3\u6709\u6b63\u5728\u8fdb\u884c\u540c\u6b65\u5176\u4ed6\u7528\u6237\u7ec4\u7684\u4efb\u52a1\u3002", (String)"SscWorkCalendarUserSettingPlugin_15", (String)"ssc-task-formplugin", (Object[])new Object[0]), new Object[0]));
                return;
            }
            Boolean syncOtherGroup = (Boolean)this.getModel().getValue("syncothergroup");
            Map<String, Object> panelData = this.getPanelData();
            if (panelData == null) {
                return;
            }
            if (syncOtherGroup.booleanValue()) {
                this.showSyncOtherGroupForm();
            } else {
                this.saveUserWorkCalendarSetting(panelData);
            }
        }
    }

    private void saveUserWorkCalendarSetting(Map<String, Object> panelData) {
        List<Long> userIds = this.getSelectUserIds();
        Long userGroupId = Long.parseLong(this.getGroup());
        for (Long userId : userIds) {
            this.syncSingleUserWorkCalendarSetting(userId, userGroupId, panelData);
        }
        IFormView parentView = this.getView().getParentView();
        parentView.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SscWorkCalendarBasePlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        parentView.setReturnData((Object)"refreshData");
        this.getView().sendFormAction(parentView);
        this.isUpdate = false;
        this.getView().close();
    }

    private void showSyncOtherGroupForm() {
        ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(SYNC_OTHER_GROUP, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u540c\u6b65\u8be5\u5458\u5de5\u5f53\u65e5\u7684\u5de5\u4f5c\u65e5\u5386\u81f3\u5176\u4ed6\u7528\u6237\u7ec4\u540e\u5c06\u65e0\u6cd5\u64a4\u9500\uff0c\u786e\u5b9a\u8981\u540c\u6b65\u5417\uff1f", (String)"SscWorkCalendarUserSettingPlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBack);
    }

    private void syncSingleUserWorkCalendarSetting(Long userId, Long userGroupId, Map<String, Object> panelData) {
        List<String> timeIntervals;
        String timeInterval;
        Long sscId = Long.parseLong(this.getSscCenter());
        if (this.getPageCache().get(offFlag) != null) {
            Date offStartDate = (Date)panelData.get("offstartdate");
            Date offEndDate = (Date)panelData.get("offenddate");
            if (offStartDate != null && offEndDate != null) {
                String offStartTime = (String)panelData.get("offstarttime");
                String offEndTime = (String)panelData.get("offendtime");
                timeInterval = StringUtils.join((Object[])new String[]{offStartTime, "-", offEndTime});
                timeIntervals = Collections.singletonList(timeInterval);
                WorkCalendarServiceHelper.updateUserWorkTime(sscId, userGroupId, userId, offStartDate, offEndDate, SscTimeOp.ASKFORLEAVE, timeIntervals);
            }
        }
        if (this.getPageCache().get(overFlag) != null) {
            Date overworkStartDate = (Date)panelData.get("overworkstartdate");
            Date overworkEndDate = (Date)panelData.get("overworkenddate");
            if (overworkStartDate != null && overworkEndDate != null) {
                String overworkTimeStart = (String)panelData.get("overworktimestart");
                String overworkTimeEnd = (String)panelData.get("overworktimeend");
                timeInterval = StringUtils.join((Object[])new String[]{overworkTimeStart, "-", overworkTimeEnd});
                timeIntervals = Collections.singletonList(timeInterval);
                WorkCalendarServiceHelper.updateUserWorkTime(sscId, userGroupId, userId, overworkStartDate, overworkEndDate, SscTimeOp.OVERTIME, timeIntervals);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "offstartdate": 
            case "offenddate": {
                String timePropName;
                String date;
                Object offstartdate = this.getModel().getValue("offstartdate");
                Object offenddate = this.getModel().getValue("offenddate");
                if (offstartdate != null && propName.equals("offstartdate")) {
                    date = DateUtil.format((Object)offstartdate, (String)"yyyy-MM-dd");
                    timePropName = "offstarttime";
                } else if (offenddate != null && propName.equals("offenddate")) {
                    date = DateUtil.format((Object)offenddate, (String)"yyyy-MM-dd");
                    timePropName = "offendtime";
                } else {
                    if (offstartdate == null && propName.equals("offstartdate")) {
                        String timePropName2 = "offstarttime";
                        this.setOffTime(new ArrayList<String>(), timePropName2);
                        return;
                    }
                    if (offenddate == null && propName.equals("offenddate")) {
                        String timePropName3 = "offendtime";
                        this.setOffTime(new ArrayList<String>(), timePropName3);
                        return;
                    }
                    return;
                }
                this.setOffTime(new ArrayList<String>(), timePropName);
                try {
                    Date now = DateUtil.parse((String)DateUtil.format((Object)new Date(), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
                    if (DateUtil.parse((String)date, (String)"yyyy-MM-dd").getTime() < now.getTime()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5f00\u59cb\u65f6\u95f4\u201d\u5e94\u665a\u4e8e\u6216\u8005\u7b49\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"SscWorkCalendarUserSettingPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                catch (ParseException ex) {
                    log.info(ex.getMessage());
                    return;
                }
                if (offstartdate != null && offenddate != null) {
                    if (((Date)offstartdate).getTime() > ((Date)offenddate).getTime()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5f00\u59cb\u65f6\u95f4\u201d\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u201c\u7ed3\u675f\u65f6\u95f4\u201d\u3002", (String)"SscWorkCalendarUserSettingPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    boolean success = this.validateDate((Date)offstartdate, (Date)offenddate, offFlag);
                    if (!success) {
                        return;
                    }
                    boolean syncDateIsValid = this.syncDateIsValid((Date)offstartdate, (Date)offenddate);
                    if (!syncDateIsValid) {
                        return;
                    }
                }
                ArrayList<String> times = new ArrayList<String>(10);
                HashMap<String, String> params = new HashMap<String, String>(2);
                params.put("ssc", this.getSscCenter());
                params.put("date", date);
                DynamicObjectCollection timeDatas = SscWorkCalendarLoadService.getCalendarTimeOfWorkTime(params);
                if (timeDatas == null || timeDatas.size() == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u65e5\u671f\u5728\u5171\u4eab\u4e2d\u5fc3\u5de5\u4f5c\u65e5\u5386\u4e2d\u672a\u8bbe\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"SscWorkCalendarUserSettingPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    this.getPageCache().put(offFlag, null);
                    return;
                }
                DynamicObject groupData = (DynamicObject)timeDatas.get(0);
                for (DynamicObject timeData : timeDatas) {
                    if (!timeData.getString("dateentry.usergroup").equals(this.getGroup())) continue;
                    groupData = timeData;
                    break;
                }
                switch (SscDateType.getSscDateType((String)groupData.getString("dateentry.datetype"))) {
                    case HOLIDAY: 
                    case RESTDATE: {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f11\u606f\u65e5/\u8282\u5047\u65e5\u65e0\u9700\u8bf7\u5047\u3002", (String)"SscWorkCalendarUserSettingPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        this.getModel().setValue(propName, null);
                        this.setOffTime(new ArrayList<String>(), timePropName);
                        return;
                    }
                    case HALFWORKDATEAM: {
                        if (propName.equals("offstartdate")) {
                            times.add(groupData.getString("dateentry.timeentry.begintimeam"));
                        } else {
                            times.add(groupData.getString("dateentry.timeentry.endtimeam"));
                        }
                        this.setOffTime(times, timePropName);
                        break;
                    }
                    case HALFWORKDATEPM: {
                        if (propName.equals("offstartdate")) {
                            times.add(groupData.getString("dateentry.timeentry.begintimepm"));
                        } else {
                            times.add(groupData.getString("dateentry.timeentry.endtimepm"));
                        }
                        this.setOffTime(times, timePropName);
                        break;
                    }
                    case WORKDATE: {
                        if (propName.equals("offstartdate")) {
                            times.add(groupData.getString("dateentry.timeentry.begintimeam"));
                            times.add(groupData.getString("dateentry.timeentry.begintimepm"));
                        } else {
                            times.add(groupData.getString("dateentry.timeentry.endtimeam"));
                            times.add(groupData.getString("dateentry.timeentry.endtimepm"));
                        }
                        this.setOffTime(times, timePropName);
                    }
                }
                break;
            }
            case "overworkstartdate": 
            case "overworkenddate": {
                Object overworkstartdate = this.getModel().getValue("overworkstartdate");
                Object overworkenddate = this.getModel().getValue("overworkenddate");
                if (overworkstartdate == null && propName.equals("overworkstartdate") || overworkenddate == null && propName.equals("overworkenddate")) {
                    return;
                }
                if (overworkstartdate == null || overworkenddate == null) {
                    return;
                }
                try {
                    Date now = DateUtil.parse((String)DateUtil.format((Object)new Date(), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
                    if (((Date)overworkstartdate).getTime() < now.getTime()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5f00\u59cb\u65f6\u95f4\u201d\u5e94\u665a\u4e8e\u6216\u8005\u7b49\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"SscWorkCalendarUserSettingPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                catch (ParseException ex) {
                    log.info(ex.getMessage());
                    return;
                }
                if (((Date)overworkstartdate).getTime() > ((Date)overworkenddate).getTime()) {
                    return;
                }
                boolean syncDateIsValid = this.syncDateIsValid((Date)overworkstartdate, (Date)overworkenddate);
                if (!syncDateIsValid) {
                    return;
                }
                this.validateDate((Date)overworkstartdate, (Date)overworkenddate, overFlag);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getModel().getDataChanged() && this.isUpdate) {
            ConfirmCallBackListener close = new ConfirmCallBackListener("exit");
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SscWorkCalendarUserSettingPlugin_13", (String)"ssc-task-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, close);
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if ("exit".equals(callBackId) && evt.getResult() == MessageBoxResult.Yes) {
            this.isUpdate = false;
            this.getView().close();
        } else if (SYNC_OTHER_GROUP.equals(evt.getCallBackId()) && evt.getResult() == MessageBoxResult.Yes) {
            this.syncOtherGroup();
        }
    }

    private void syncOtherGroup() {
        Map<String, Object> panelData = this.getPanelData();
        if (panelData == null) {
            return;
        }
        this.showProgressForm(panelData, this.getSelectUserIds());
        this.isUpdate = false;
        this.getView().close();
    }

    private Map<String, Object> getPanelData() {
        HashMap<String, Object> panelData = new HashMap<String, Object>(16);
        Object offstartdate = this.getModel().getValue("offstartdate");
        Object offenddate = this.getModel().getValue("offenddate");
        String offstarttime = this.getModel().getValue("offstarttime") + "";
        String offendtime = this.getModel().getValue("offendtime") + "";
        if (offstartdate != null && offenddate == null || offstartdate == null && offenddate != null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5047\u65f6\u95f4\u4e0d\u5b8c\u6574\uff0c\u8bf7\u68c0\u67e5\u201c\u8bf7\u5047\u5f00\u59cb\u65f6\u95f4\u201d\u6216\u201c\u8bf7\u5047\u7ed3\u675f\u65f6\u95f4\u201d\u3002", (String)"SscWorkCalendarUserSettingPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return null;
        }
        if (offstartdate != null && (StringUtils.isEmpty((CharSequence)offstarttime) || StringUtils.isEmpty((CharSequence)offendtime))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5047\u65f6\u95f4\u4e0d\u5b8c\u6574\uff0c\u8bf7\u68c0\u67e5\u201c\u8bf7\u5047\u5f00\u59cb\u65f6\u95f4\u201d\u6216\u201c\u8bf7\u5047\u7ed3\u675f\u65f6\u95f4\u201d\u3002", (String)"SscWorkCalendarUserSettingPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return null;
        }
        Object overworkenddate = this.getModel().getValue("overworkenddate");
        Object overworkstartdate = this.getModel().getValue("overworkstartdate");
        int overworktimestart = (Integer)this.getModel().getValue("overworktimestart");
        int overworktimeend = (Integer)this.getModel().getValue("overworktimeend");
        if (overworkenddate != null && overworktimeend <= 0 || overworkenddate == null && overworktimestart >= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u52a0\u73ed\u65f6\u95f4\u4e0d\u5b8c\u6574\uff0c\u8bf7\u68c0\u67e5\u201c\u52a0\u73ed\u65e5\u671f\u201d\u6216\u201c\u52a0\u73ed\u65f6\u95f4\u201d\u3002", (String)"SscWorkCalendarUserSettingPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return null;
        }
        if (offstartdate == null && overworkstartdate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5047\u65f6\u95f4\u548c\u52a0\u73ed\u65f6\u95f4\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"SscWorkCalendarUserSettingPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return null;
        }
        if (offstartdate != null && offenddate != null && overworkstartdate != null && overworkenddate != null && !this.isOverlap((Date)overworkstartdate, (Date)overworkenddate, (Date)offstartdate, (Date)offenddate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5047\u65e5\u671f\u8303\u56f4\u548c\u52a0\u73ed\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u91cd\u53e0\u3002", (String)"SscWorkCalendarUserSettingPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return null;
        }
        if (offstartdate != null) {
            try {
                Date now = DateUtil.parse((String)DateUtil.format((Object)new Date(), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
                if (((Date)offstartdate).getTime() < now.getTime() || ((Date)offenddate).getTime() < now.getTime()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5f00\u59cb\u65f6\u95f4\u201d\u5e94\u665a\u4e8e\u6216\u8005\u7b49\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"SscWorkCalendarUserSettingPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return null;
                }
            }
            catch (ParseException ex) {
                log.info(ex.getMessage());
                return null;
            }
            if (((Date)offstartdate).getTime() > ((Date)offenddate).getTime()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5f00\u59cb\u65f6\u95f4\u201d\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u201c\u7ed3\u675f\u65f6\u95f4\u201d\u3002", (String)"SscWorkCalendarUserSettingPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return null;
            }
            if (offstartdate.equals(offenddate) && SscWorkCalendarUtil.getTimeShow(offstarttime) > SscWorkCalendarUtil.getTimeShow(offendtime)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u8bf7\u5047\u7ed3\u675f\u65f6\u95f4\u665a\u4e8e\u8bf7\u5047\u5f00\u59cb\u65f6\u95f4\u3002", (String)"SscWorkCalendarUserSettingPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return null;
            }
            boolean syncDateIsValid = this.syncDateIsValid((Date)offstartdate, (Date)offenddate);
            if (!syncDateIsValid) {
                return null;
            }
            panelData.put("offstartdate", offstartdate);
            panelData.put("offenddate", offenddate);
            panelData.put("offstarttime", offstarttime);
            panelData.put("offendtime", offendtime);
        }
        if (overworkstartdate != null) {
            try {
                Date now = DateUtil.parse((String)DateUtil.format((Object)new Date(), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
                if (((Date)overworkstartdate).getTime() < now.getTime()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5f00\u59cb\u65f6\u95f4\u201d\u5e94\u665a\u4e8e\u6216\u8005\u7b49\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"SscWorkCalendarUserSettingPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return null;
                }
            }
            catch (ParseException ex) {
                log.info(ex.getMessage());
                return null;
            }
            boolean syncDateIsValid = this.syncDateIsValid((Date)overworkstartdate, (Date)overworkenddate);
            if (!syncDateIsValid) {
                return null;
            }
            panelData.put("overworkstartdate", overworkstartdate);
            panelData.put("overworkenddate", overworkenddate);
            panelData.put("overworktimestart", SscWorkCalendarUtil.getTimeShow(overworktimestart));
            panelData.put("overworktimeend", SscWorkCalendarUtil.getTimeShow(overworktimeend));
        }
        return panelData;
    }

    private boolean syncDateIsValid(Date startDate, Date endDate) {
        Boolean syncOtherGroup = (Boolean)this.getModel().getValue("syncothergroup");
        if (!syncOtherGroup.booleanValue()) {
            return Boolean.TRUE;
        }
        if (startDate == null || endDate == null) {
            return Boolean.FALSE;
        }
        if ((endDate.getTime() - startDate.getTime()) / 86400000L > 6L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u5f00\u542f\u540c\u6b65\u5176\u4ed6\u7528\u6237\u7ec4\u65f6\uff0c\u8bf7\u5047\u6216\u52a0\u73ed\u65f6\u95f4\u6bb5\u4e0d\u53ef\u8d85\u8fc77\u5929\u3002", (String)"SscWorkCalendarUserSettingPlugin_12", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private boolean validateDate(Date startworkdate, Date endworkdate, String flag) {
        Set<Date> selectDates = SscWorkCalendarLoadService.validateDateCalendar(this.getSscCenter(), startworkdate, endworkdate);
        if (selectDates.size() > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u65e5\u671f\u5728\u5171\u4eab\u4e2d\u5fc3\u5de5\u4f5c\u65e5\u5386\u4e2d\u672a\u8bbe\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"SscWorkCalendarUserSettingPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.getPageCache().put(flag, null);
            return false;
        }
        this.getPageCache().put(flag, "1");
        return true;
    }

    void setUser() {
        String group = this.getGroup();
        if (StringUtils.isEmpty((CharSequence)group)) {
            return;
        }
        List<PersonInfo> personInfos = SscWorkCalendarLoadService.getUserListByGroupId(group);
        List<ComboItem> comboItems = this.getUserComboItems(personInfos);
        ComboEdit combo = (ComboEdit)this.getControl("user");
        if (comboItems.size() > 0) {
            combo.setComboItems(comboItems);
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String selectedUser = (String)parameter.getCustomParam("selecteduser");
            this.getModel().setValue("user", (Object)selectedUser);
            this.getView().updateView("user");
        } else {
            this.getModel().setValue("user", (Object)"");
            combo.setComboItems(null);
        }
    }

    void setOffTime(List<String> items, String fieldname) {
        List<ComboItem> comboItems = this.getOffTimeComboItems(items);
        ComboEdit combo = (ComboEdit)this.getControl(fieldname);
        combo.setComboItems(null);
        if (comboItems.size() > 0) {
            combo.setComboItems(comboItems);
            this.getModel().setValue(fieldname, (Object)comboItems.get(0).getValue());
            this.getView().updateView(fieldname);
        } else {
            this.getModel().setValue(fieldname, (Object)"");
            combo.setComboItems(null);
        }
    }

    public List<ComboItem> getUserComboItems(List<PersonInfo> personInfos) {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(10);
        for (PersonInfo item : personInfos) {
            ComboItem citem = new ComboItem();
            citem.setCaption(new LocaleString(item.getUserName()));
            citem.setValue(item.getUid() + "");
            list.add(citem);
        }
        return list;
    }

    public List<ComboItem> getOffTimeComboItems(List<String> items) {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(10);
        for (String item : items) {
            ComboItem citem = new ComboItem();
            citem.setCaption(new LocaleString(item));
            citem.setValue(item);
            list.add(citem);
        }
        return list;
    }

    private String getSscCenter() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        return (String)parameter.getCustomParam("ssccenterid");
    }

    private String getGroup() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        return (String)parameter.getCustomParam("groupid");
    }

    private boolean isOverlap(Date begin1, Date end1, Date begin2, Date end2) {
        if (end1.compareTo(begin2) > 0 && begin1.compareTo(end2) > 0) {
            return true;
        }
        return end1.compareTo(begin2) < 0 && begin1.compareTo(end2) < 0;
    }

    private void deleteEmpOffOrOverWorkData(Object startDate, Object endDate, DynamicObjectType dynamicObjectType, String timeType, Long userId, Long userGroupId) {
        QFilter filters = new QFilter("dateentry.ssc", "=", (Object)Long.parseLong(this.getSscCenter()));
        filters.and(new QFilter("dateentry.usergroup", "=", (Object)userGroupId));
        filters.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.EMPLOYEE.getValue()));
        filters.and(new QFilter("dateentry.date", ">=", startDate));
        filters.and(new QFilter("dateentry.date", "<=", endDate));
        filters.and(new QFilter("dateentry.user", "=", (Object)userId));
        filters.and(new QFilter("dateentry.timeentry.timetype", "=", (Object)timeType));
        List dateentryids = QueryServiceHelper.query((String)"ssc_workcalendarsetting", (String)"dateentry.id", (QFilter[])new QFilter[]{filters}).stream().map(id -> id.getLong("dateentry.id")).collect(Collectors.toList());
        if (dateentryids.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)dynamicObjectType, (Object[])dateentryids.toArray());
        }
    }

    private List<Long> getSelectUserIds() {
        String userStr = (String)this.getModel().getValue("user");
        if (StringUtils.isEmpty((CharSequence)userStr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u5458\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SscWorkCalendarUserSettingPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        String[] userStrSplit = userStr.split(",");
        List<String> userIdStrList = Arrays.asList(userStrSplit);
        return userIdStrList.stream().filter(StringUtils::isNotEmpty).map(Long::parseLong).collect(Collectors.toList());
    }

    private boolean checkSyncOtherGroupPermission() {
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = "ssc";
        }
        boolean checkPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"ssc_workcalendar_employee", (String)"3GPF/1EZ0C/M");
        return checkPerm;
    }

    private void showProgressForm(Map<String, Object> panelData, List<Long> userIds) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("ssc_workcalendar_syncing");
        param.setCustomParam("sscId", (Object)this.getSscCenter());
        param.setCustomParam(offFlag, (Object)this.getPageCache().get(offFlag));
        param.setCustomParam(overFlag, (Object)this.getPageCache().get(overFlag));
        param.setCustomParam("panelData", panelData);
        param.setCustomParam("userIds", userIds);
        param.setCloseCallBack(new CloseCallBack("kd.ssc.task.formplugin.workcalendar.SscWorkCalendarUserEditPlugin", "bar_batchset"));
        this.getView().getParentView().showForm(param);
    }
}

