/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.workcalendar;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.DBServiceHelper;
import kd.ssc.task.formplugin.workcalendar.SscWorkCalendarUserSyncProcess;

public class SscWorkCalendarUserSyncFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private String sscId;
    private Map<String, Object> panelData;
    private String offFlag;
    private String overFlag;
    private List<Long> userIds;

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        this.iniFormParameter(parameter);
        this.start();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btncancel"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if ("btncancel".equals(c.getKey())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u7ec8\u6b62\u540c\u6b65\u5176\u4ed6\u7528\u6237\u7ec4\u5417\uff1f", (String)"SscWorkCalendarUserSyncFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("CANCEL"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if ("CANCEL".equalsIgnoreCase(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
            bar.stop();
            this.getView().close();
        }
    }

    public void onProgress(ProgressEvent e) {
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        ProgressBar bar = (ProgressBar)view.getControl("progressbarap");
        try {
            String taskId = this.getTaskId();
            if (StringUtils.isBlank((CharSequence)taskId)) {
                taskId = DBServiceHelper.genStringId();
                FormShowParameter parameter = view.getFormShowParameter();
                this.iniFormParameter(parameter);
                SscWorkCalendarUserSyncProcess execute = new SscWorkCalendarUserSyncProcess(taskId, this.sscId, this.panelData, this.offFlag, this.overFlag, this.userIds);
                ThreadService.execute((Runnable)execute, (TaskType)TaskType.SSC_SYNC_OTHER_GROUP);
                this.setTaskId(taskId);
                return;
            }
            int progress = SscWorkCalendarUserSyncProcess.getProgress(taskId);
            boolean interruption = SscWorkCalendarUserSyncProcess.isInterruption(taskId);
            if (interruption) {
                parentView.showTipNotification(ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\u3002", (String)"SscWorkCalendarUserSyncFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                view.sendFormAction(parentView);
                bar.stop();
                view.close();
            } else {
                e.setProgress(progress);
                if (progress == 100) {
                    bar.stop();
                    parentView.setReturnData((Object)"refreshData");
                    parentView.showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u3002", (String)"SscWorkCalendarUserEditPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    view.sendFormAction(parentView);
                    view.close();
                }
            }
        }
        catch (Exception ex) {
            parentView.showErrMessage(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5176\u4ed6\u7528\u6237\u7ec4\u62a5\u9519\u4fe1\u606f:%s", (String)"SscWorkCalendarUserSyncFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), ex.getMessage()), "");
            view.sendFormAction(parentView);
            bar.stop();
            view.close();
        }
    }

    private void iniFormParameter(FormShowParameter parameter) {
        this.sscId = (String)parameter.getCustomParam("sscId");
        this.offFlag = (String)parameter.getCustomParam("offFlag");
        this.overFlag = (String)parameter.getCustomParam("overFlag");
        this.userIds = (List)parameter.getCustomParam("userIds");
        this.panelData = (Map)parameter.getCustomParam("panelData");
    }

    private void start() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.start();
    }

    private String getTaskId() {
        return this.getPageCache().get("taskid");
    }

    private void setTaskId(String taskId) {
        this.getPageCache().put("taskid", taskId);
    }
}

