/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.helper;

import java.util.Arrays;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;

public final class MutexCacheHelper {
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ssc-task");

    public static void putMutexCache(String userId, String taskId) {
        if (StringUtils.isEmpty((CharSequence)userId) || StringUtils.isEmpty((CharSequence)taskId)) {
            return;
        }
        String key = MutexCacheHelper.getTaskKey(taskId);
        cache.put(key, (Object)"1", 7200);
        cache.put(MutexCacheHelper.getUserKey(userId), key, "1", 7200);
    }

    public static void putMutexCache4Dist(long taskId) {
        if (taskId == 0L) {
            return;
        }
        String key = MutexCacheHelper.getDistTaskKey(taskId);
        cache.put(key, (Object)"1", 600);
    }

    public static void removeMutexCache(String taskId) {
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            return;
        }
        cache.remove(MutexCacheHelper.getTaskKey(taskId));
    }

    public static void removeMutexCache4Dist(long taskId) {
        if (taskId == 0L) {
            return;
        }
        cache.remove(MutexCacheHelper.getDistTaskKey(taskId));
    }

    public static void batchRemoveMutexCache(String[] taskIds) {
        if (taskIds == null || taskIds.length == 0) {
            return;
        }
        String[] keys = (String[])Arrays.stream(taskIds).map(MutexCacheHelper::getTaskKey).toArray(String[]::new);
        cache.remove(keys);
    }

    public static boolean containsMutexCache(String taskId) {
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            return false;
        }
        return cache.contains(MutexCacheHelper.getTaskKey(taskId));
    }

    public static boolean containsMutexCache4Dist(long taskId) {
        if (taskId == 0L) {
            return false;
        }
        return cache.contains(MutexCacheHelper.getDistTaskKey(taskId));
    }

    public static void removeMutexCache4User(String userId) {
        if (StringUtils.isEmpty((CharSequence)userId)) {
            return;
        }
        Map all = cache.getAll(MutexCacheHelper.getUserKey(userId));
        if (all.isEmpty()) {
            return;
        }
        String[] keys = all.keySet().toArray(new String[0]);
        cache.remove(keys);
        cache.remove(MutexCacheHelper.getUserKey(userId));
    }

    private static String getTaskKey(String taskId) {
        return RequestContext.get().getAccountId() + ":mutex_t:" + taskId;
    }

    private static String getUserKey(String userId) {
        return RequestContext.get().getAccountId() + ":mutex_u:" + userId;
    }

    private static String getDistTaskKey(long taskId) {
        return RequestContext.get().getAccountId() + ":mutex_t_dist:" + taskId;
    }

    public static boolean containsMutexCache4Approve(long taskId) {
        if (taskId == 0L) {
            return false;
        }
        return cache.contains(MutexCacheHelper.getApproveTaskKey(taskId));
    }

    public static void putMutexCache4Approve(long taskId) {
        if (taskId == 0L) {
            return;
        }
        String key = MutexCacheHelper.getApproveTaskKey(taskId);
        cache.put(key, (Object)"1", 600);
    }

    public static void removeMutexCache4Approve(long taskId) {
        if (taskId == 0L) {
            return;
        }
        cache.remove(MutexCacheHelper.getApproveTaskKey(taskId));
    }

    private static String getApproveTaskKey(long taskId) {
        return RequestContext.get().getAccountId() + ":mutex_t_approve:" + taskId;
    }
}

