/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.monitor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.ssc.monitor.ExceptionStatusEnum;
import kd.ssc.monitor.SolutionHelper;
import kd.ssc.monitor.sort.EntityQuickSort;
import org.apache.commons.lang3.StringUtils;

public class ExceptionFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String HANDLE_ENTRY = "handle_entry";
    private static final String MONITOR_ENTRY = "monitor_entry";
    private static final String LOG_DETAIL = "log_detail";
    private static final String SHOW_LOG_DETAIL = "show_log_detail";
    private static final String CONTAINER_LOG = "fs_logdetail";

    public void initialize() {
        ((AbstractGrid)this.getControl(MONITOR_ENTRY)).addRowClickListener((RowClickEventListener)this);
    }

    public void afterBindData(EventObject e) {
        DynamicObjectCollection entryEntity;
        IDataModel model = this.getModel();
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        if (!OperationStatus.ADDNEW.equals((Object)operationStatus)) {
            this.entitySortByTimeDesc(HANDLE_ENTRY, "handling_time");
            this.entitySortByTimeDesc(MONITOR_ENTRY, "monitor_time");
        }
        if ((entryEntity = model.getEntryEntity(MONITOR_ENTRY)) != null && !entryEntity.isEmpty()) {
            String logDetail = ((DynamicObject)entryEntity.get(0)).getString(LOG_DETAIL);
            this.loadLogDetail(logDetail);
        }
        String status = (String)model.getValue("status");
        if (ExceptionStatusEnum.UN_PROCESSED.getValue().equals(status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_retry"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_retry"});
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{SHOW_LOG_DETAIL});
    }

    private void entitySortByTimeDesc(String entryId, String timeField) {
        DynamicObjectCollection entry = this.getModel().getEntryEntity(entryId);
        EntityQuickSort entitySort = new EntityQuickSort(entry, timeField);
        entitySort.handle();
        this.getView().updateView(entryId);
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        int row = evt.getRow();
        if (row >= 0 && MONITOR_ENTRY.equals(entryGrid.getEntryKey())) {
            String log = ((DynamicObject)this.getModel().getEntryEntity(MONITOR_ENTRY).get(row)).getString(LOG_DETAIL);
            this.loadLogDetail(log);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "show_solution": {
                DynamicObject scenarioDo = (DynamicObject)this.getModel().getValue("scenario");
                Long defId = (Long)scenarioDo.getPkValue();
                SolutionHelper.openSolutionForm((IFormView)this.getView(), (Long)defId);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        block17: {
            String key = afterDoOperationEventArgs.getOperateKey();
            if ("download".equals(key)) {
                String detail = (String)this.getModel().getValue(SHOW_LOG_DETAIL);
                if (StringUtils.isBlank((CharSequence)detail)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u8be6\u60c5\u4e3a\u7a7a\u3002", (String)"ExceptionFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                String format = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
                String fileTitle = String.format(ResManager.loadKDString((String)"\u5f02\u5e38\u4fe1\u606f_%s.txt", (String)"ExceptionFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), format);
                try (ByteArrayInputStream input = new ByteArrayInputStream(("=================log detail=================\r\n" + detail).getBytes(StandardCharsets.UTF_8));){
                    String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileTitle, (InputStream)input, 600);
                    this.getView().openUrl(urls);
                    break block17;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if ("retry".equals(key)) {
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private void loadLogDetail(String logDetail) {
        this.getModel().setValue(SHOW_LOG_DETAIL, (Object)logDetail);
        Container flexPanel = (Container)this.getView().getControl(CONTAINER_LOG);
        flexPanel.setCollapse(StringUtils.isBlank((CharSequence)logDetail));
        this.getModel().setDataChanged(false);
    }
}

