/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.schedule;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.config.client.util.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.exception.ExceptionUtil;
import kd.ssc.task.common.TaskStateEnum;
import kd.ssc.task.schedule.IHandleReductionAccount;
import kd.ssc.task.util.ConverterUtil;
import kd.ssc.task.util.RecordExceptionUtil;
import kd.ssc.task.util.TaskDateUtil;

public class HandleReductionAccountImpl
implements IHandleReductionAccount {
    private static final String FIELD_EXTENDERP = "KDCC";
    private static final String FIELD_TASKHISTORY = "id,sscid,orgid,billtype,creator,personid ,billid,billnumber,completetime";
    private static final int RUNPAGESIZE = 1000;
    private static final String DATEFORMAT_YYYYMMDDHHMM = "yyyy-MM-dd HH:mm";
    private static final Log log = LogFactory.getLog(HandleReductionAccountImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveReductionAccountBatch() {
        Date preRecordTime = null;
        String currentRecordTimeStr = StringUtils.getEmpty();
        Date currentRecordTime = null;
        DataSet preTaskDataSet = null;
        Object[] filters = null;
        String filterStr = StringUtils.getEmpty();
        int start = 0;
        int pageIndex = 0;
        try {
            HashMap<String, String> formMap = new HashMap<String, String>();
            Set<String> formIds = this.getVourcherIds(Arrays.asList("er_dailyloanbill", "er_dailyreimbursebill", "er_tripreimbursebill"), formMap);
            log.info("\u6838\u5b9a\u91d1\u989d\u8ba1\u7b97\u8868\u5355ID\u548c\u8868\u5355\u7f16\u7801\uff1a" + formMap);
            HashMap<Long, String> systemMap = new HashMap<Long, String>(16);
            Set<Long> systemIds = this.getKDSystemIds(Collections.singletonList(FIELD_EXTENDERP), systemMap);
            log.info("\u6838\u5b9a\u91d1\u989d\u8ba1\u7b97\u6240\u5c5e\u7cfb\u7edf\uff1a" + systemMap);
            HashMap<Long, String> billFormMap = new HashMap<Long, String>(16);
            Set<Long> billTypeIds = this.getBillTypeIds(systemIds, formIds, billFormMap);
            log.info("\u6838\u5b9a\u91d1\u989d\u8ba1\u7b97\u8868\u5355ID\u548c\u4e1a\u52a1\u5355\u636eID\uff1abillFormMap = " + billFormMap + ", billTypeIds = " + billTypeIds);
            Map<Long, String> billNumberMap = this.getFormMetaNumber(formMap, billFormMap);
            log.info("\u6838\u5b9a\u91d1\u989d\u8ba1\u7b97\u4e1a\u52a1\u5355\u636eID\u548c\u4e1a\u52a1\u5355\u636e\u8868\u5355\u7f16\u7801\u5173\u7cfb\uff1abillNumberMap = " + billNumberMap);
            preRecordTime = this.getPreMaxDate(billTypeIds);
            Date endTime = new Date(System.currentTimeMillis());
            currentRecordTimeStr = TaskDateUtil.dateConvertFormatString((Date)endTime, (String)DATEFORMAT_YYYYMMDDHHMM);
            currentRecordTime = TaskDateUtil.stringConvertFormatDate((String)currentRecordTimeStr, (String)DATEFORMAT_YYYYMMDDHHMM);
            filters = this.getReductionAccountFilters(preRecordTime, currentRecordTime, billTypeIds);
            filterStr = ConverterUtil.arrayConvetToString((Object[])filters);
            log.info("\u6838\u5b9a\u91d1\u989d\u8ba1\u7b97\u67e5\u8be2\u6761\u4ef6\uff1a" + filterStr);
            log.info("\u6838\u5b9a\u91d1\u989d\u8ba1\u7b97\u4e1a\u52a1\u5355\u636eID\u548c\u8868\u5355\u7f16\u7801\uff1a" + billNumberMap);
            ORM orm = ORM.create();
            preTaskDataSet = orm.queryDataSet("kd.ssc.task.schedule.HandleReductionAccountImpl.saveReductionAccountBatch()", "task_taskhistory", FIELD_TASKHISTORY, (QFilter[])filters, null, start, 1000);
            int count = preTaskDataSet.copy().count("id", true);
            log.info("\u6838\u5b9a\u91d1\u989d\u8ba1\u7b97\u7b26\u5408\u67e5\u8be2\u6761\u4ef6\u6570\u636e\u603b\u6570\uff1a" + count);
            while (preTaskDataSet != null && preTaskDataSet.hasNext()) {
                log.info("\u6838\u5b9a\u91d1\u989d\u8ba1\u7b97\u5355\u636e\u6821\u9a8c\u5f00\u59cb:" + pageIndex);
                List<DynamicObject> reductionAccountList = this.getSingleFullReductionAccountData(currentRecordTime, preTaskDataSet, billNumberMap);
                log.info("\u6838\u5b9a\u91d1\u989d\u8ba1\u7b97\u7b26\u5408\u6761\u4ef6\u6570\u636e\u603b\u6570:" + reductionAccountList.size());
                this.excuteSaveReductionAccountBatch(reductionAccountList);
                start = 1000 * ++pageIndex;
                preTaskDataSet = orm.queryDataSet("kd.ssc.task.schedule.HandleReductionAccountImpl.saveReductionAccountBatch()", "task_taskhistory", FIELD_TASKHISTORY, (QFilter[])filters, null, start, 1000);
            }
            log.info("\u6838\u5b9a\u91d1\u989d\u8ba1\u7b97\u670d\u52a1\u7ed3\u675f,\u5171\u4ea7\u751f\u8bb0\u5f55\u6761\u6570\uff1a" + this.getGenerateReductionAccountCount(currentRecordTime));
        }
        catch (Exception e) {
            String errorMsg = ResManager.loadKDString((String)"\u5b9a\u65f6\u4efb\u52a1\u751f\u6210\u6838\u5b9a\u91d1\u989d\u6570\u636e\u5f02\u5e38", (String)"HandleReductionAccountImpl_0", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            log.error(errorMsg, (Throwable)e);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("preRecordTime", TaskDateUtil.dateConvertFormatString(preRecordTime, (String)DATEFORMAT_YYYYMMDDHHMM));
            param.put("currentRecordTime", currentRecordTimeStr);
            if (filters != null) {
                param.put("filters", filterStr);
            }
            RecordExceptionUtil.saveRecordExcept((String)"ssc", (String)"kd.ssc.task.schedule.HandleReductionAccountImpl.saveReductionAccountBatch()", param, (String)errorMsg, (String)ExceptionUtil.getStackTrace((Throwable)e));
        }
        finally {
            if (preTaskDataSet != null) {
                preTaskDataSet.close();
            }
        }
    }

    private boolean excuteSaveReductionAccountBatch(List<DynamicObject> data) {
        if (data == null || data.size() == 0) {
            return false;
        }
        DynamicObject[] dataArray = new DynamicObject[data.size()];
        data.toArray(dataArray);
        Object[] ret = SaveServiceHelper.save((DynamicObject[])dataArray);
        return ret != null && ret.length > 0;
    }

    private List<DynamicObject> getSingleFullReductionAccountData(Date currentRecordTime, DataSet preTaskDataSet, Map<Long, String> billNumberMap) {
        ArrayList<DynamicObject> ret = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> tempRet = new ArrayList<DynamicObject>();
        Iterator rows = preTaskDataSet.iterator();
        Row data = null;
        DynamicObject dyReductionAccount = null;
        String formNumber = StringUtils.getEmpty();
        Long billid = null;
        Long billtypeid = null;
        HashSet<Long> dailyLoanBillSet = new HashSet<Long>(16);
        HashSet<Long> dailyReimburseBillSet = new HashSet<Long>(16);
        HashSet<Long> tripReimburseBillSet = new HashSet<Long>(16);
        while (rows != null && rows.hasNext()) {
            data = (Row)rows.next();
            dyReductionAccount = BusinessDataServiceHelper.newDynamicObject((String)"task_temporaryamount");
            billtypeid = data.getLong("billtype");
            formNumber = billNumberMap.get(billtypeid);
            log.info("\u6838\u5b9a\u91d1\u989d\u8ba1\u7b97\u5355\u636e\u8868\u5355\u5339\u914d\uff0cbilltypeid=" + billtypeid + ",formNumber=" + formNumber);
            if (StringUtils.isEmpty((String)formNumber)) continue;
            billid = data.getLong("billid");
            dyReductionAccount.set("billid", (Object)billid);
            dyReductionAccount.set("formnumber", (Object)formNumber);
            dyReductionAccount.set("billno", data.get("billnumber"));
            dyReductionAccount.set("org", data.get("orgid"));
            dyReductionAccount.set("ssccenter", data.get("sscid"));
            dyReductionAccount.set("billtype", (Object)billtypeid);
            dyReductionAccount.set("requestperson", data.get("creator"));
            dyReductionAccount.set("auditperson", data.get("personid"));
            dyReductionAccount.set("completetime", data.get("completetime"));
            dyReductionAccount.set("taskid", data.get("id"));
            dyReductionAccount.set("recordtime", (Object)currentRecordTime);
            if ("er_dailyloanbill".equalsIgnoreCase(formNumber)) {
                dailyLoanBillSet.add(billid);
            } else if ("er_dailyreimbursebill".equalsIgnoreCase(formNumber)) {
                dailyReimburseBillSet.add(billid);
            } else if ("er_tripreimbursebill".equalsIgnoreCase(formNumber)) {
                tripReimburseBillSet.add(billid);
            }
            tempRet.add(dyReductionAccount);
        }
        Map<String, DynamicObject> dailyLoadBillCol = this.getVoucherDataCol(dailyLoanBillSet, "er_dailyloanbill");
        Map<String, DynamicObject> dailyReimburseBillCol = this.getVoucherDataCol(dailyReimburseBillSet, "er_dailyreimbursebill");
        Map<String, DynamicObject> tripReimburseBillCol = this.getVoucherDataCol(tripReimburseBillSet, "er_tripreimbursebill");
        boolean validatePass = false;
        for (DynamicObject item : tempRet) {
            log.info("\u6838\u5b9a\u91d1\u989d\u8ba1\u7b97\u5355\u636e\u8fdb\u5165\u6838\u51cf\u6821\u9a8citem.id= " + item.getPkValue());
            formNumber = item.getString("formnumber");
            if ("er_dailyloanbill".equalsIgnoreCase(formNumber)) {
                validatePass = this.checkReductionAccountEntry(item, dailyLoadBillCol);
            } else if ("er_dailyreimbursebill".equalsIgnoreCase(formNumber)) {
                validatePass = this.checkReductionAccountEntry(item, dailyReimburseBillCol);
            } else if ("er_tripreimbursebill".equalsIgnoreCase(formNumber)) {
                validatePass = this.checkReductionAccountEntry(item, tripReimburseBillCol);
            }
            if (!validatePass) continue;
            ret.add(item);
        }
        return ret;
    }

    private Map<String, DynamicObject> getVoucherDataCol(Set<Long> idSet, String formNumber) {
        HashMap<String, DynamicObject> ret = new HashMap<String, DynamicObject>(16);
        MainEntityType dyType = EntityMetadataCache.getDataEntityType((String)formNumber);
        DynamicObject[] vourcherDataArray = BusinessDataServiceHelper.load((Object[])idSet.toArray(), (DynamicObjectType)dyType);
        if (vourcherDataArray == null || vourcherDataArray.length == 0) {
            return ret;
        }
        DynamicObject item = null;
        for (int i = 0; i < vourcherDataArray.length; ++i) {
            item = vourcherDataArray[i];
            ret.put(item.getString("id"), item);
        }
        return ret;
    }

    private boolean checkReductionAccountEntry(DynamicObject dyReductionAccount, Map<String, DynamicObject> vourcherDataMap) {
        DynamicObjectCollection entries;
        if (dyReductionAccount == null) {
            return false;
        }
        String billid = dyReductionAccount.getString("billid");
        String formNumber = dyReductionAccount.getString("formnumber");
        DynamicObject vourcherData = vourcherDataMap.get(billid);
        if (vourcherData == null) {
            return false;
        }
        dyReductionAccount.set("loccur", vourcherData.get("currency"));
        BigDecimal amountTotal = new BigDecimal(0);
        BigDecimal approvedAmountTotal = new BigDecimal(0);
        BigDecimal reductionAmountTotal = new BigDecimal(0);
        BigDecimal currExpenseAmount = null;
        BigDecimal expeApproveCurrAmount = null;
        if ("er_dailyloanbill".equalsIgnoreCase(formNumber) || "er_dailyreimbursebill".equalsIgnoreCase(formNumber)) {
            entries = (DynamicObjectCollection)vourcherData.get("expenseentryentity");
            if (entries == null || entries.size() == 0) {
                return false;
            }
            for (DynamicObject entry : entries) {
                currExpenseAmount = entry.getBigDecimal("currexpenseamount") == null ? new BigDecimal(0) : entry.getBigDecimal("currexpenseamount");
                expeApproveCurrAmount = entry.getBigDecimal("expeapprovecurramount") == null ? new BigDecimal(0) : entry.getBigDecimal("expeapprovecurramount");
                amountTotal = amountTotal.add(currExpenseAmount);
                approvedAmountTotal = approvedAmountTotal.add(expeApproveCurrAmount);
            }
        } else if ("er_tripreimbursebill".equalsIgnoreCase(formNumber)) {
            entries = (DynamicObjectCollection)vourcherData.get("tripentry");
            if (entries == null || entries.size() == 0) {
                return false;
            }
            DynamicObjectCollection expenseEntries = null;
            for (DynamicObject tripEntry : entries) {
                expenseEntries = tripEntry.getDynamicObjectCollection("entryentity");
                if (expenseEntries == null || expenseEntries.size() == 0) {
                    return false;
                }
                for (DynamicObject entry : expenseEntries) {
                    currExpenseAmount = entry.getBigDecimal("entryamount") == null ? new BigDecimal(0) : entry.getBigDecimal("entryamount");
                    expeApproveCurrAmount = entry.getBigDecimal("entryappamount") == null ? new BigDecimal(0) : entry.getBigDecimal("entryappamount");
                    amountTotal = amountTotal.add(currExpenseAmount);
                    approvedAmountTotal = approvedAmountTotal.add(expeApproveCurrAmount);
                }
            }
        }
        log.info("\u6838\u51cf\u6821\u9a8c\uff1abillid = " + billid + ",amountTotal=" + amountTotal + ",approvedAmountTotal=" + approvedAmountTotal);
        reductionAmountTotal = amountTotal.subtract(approvedAmountTotal);
        if (approvedAmountTotal.compareTo(amountTotal) < 0) {
            DynamicObjectCollection objEntrys = dyReductionAccount.getDynamicObjectCollection("entryentity");
            DynamicObject objentry = new DynamicObject(objEntrys.getDynamicObjectType());
            objentry.set("amountcount", (Object)amountTotal);
            objentry.set("approvedcount", (Object)approvedAmountTotal);
            objentry.set("reductionamount", (Object)reductionAmountTotal);
            objEntrys.add((Object)objentry);
            return true;
        }
        return false;
    }

    private QFilter[] getReductionAccountFilters(Date preRecordTime, Date currentRecordTime, Set<Long> billTypeIds) {
        QFilter filterQcLibId = new QFilter("qualitysamplelibrary", "=", (Object)0L);
        QFilter filterPoolType = new QFilter("pooltype", "=", (Object)"2");
        QFilter filterState = new QFilter("state", "=", (Object)TaskStateEnum.AuditPassed.getValue());
        QFilter filterBillType = new QFilter("billtype", "in", billTypeIds);
        QFilter filter = filterQcLibId.and(filterPoolType).and(filterState).and(filterBillType);
        if (preRecordTime != null) {
            QFilter filterPreCompleteTime = new QFilter("completetime", ">=", (Object)preRecordTime);
            filter.and(filterPreCompleteTime);
        }
        QFilter filterCompleteTime = new QFilter("completetime", "<", (Object)currentRecordTime);
        filter.and(filterCompleteTime);
        return filter.toArray();
    }

    private Set<String> getVourcherIds(List<String> numbers, Map<String, String> formMap) {
        HashSet<String> ret = new HashSet<String>();
        QFilter filterNumber = new QFilter("number", "in", numbers);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.ssc.task.schedule.HandleReductionAccountImpl.getVourcherIds", (String)"bos_formmeta", (String)"id,number", (QFilter[])new QFilter[]{filterNumber}, null);){
            Iterator rows = ds.iterator();
            Row data = null;
            String id = null;
            String number = null;
            while (rows != null && rows.hasNext()) {
                data = (Row)rows.next();
                id = data.getString("id");
                number = data.getString("number");
                if (!ret.add(id)) continue;
                formMap.put(id, number);
            }
        }
        return ret;
    }

    private Set<Long> getKDSystemIds(List<String> numbers, Map<Long, String> systemMap) {
        HashSet<Long> ret = new HashSet<Long>();
        QFilter filterNumber = new QFilter("number", "in", numbers);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.ssc.task.schedule.HandleReductionAccountImpl.getKDSystemIds", (String)"bas_extenderp", (String)"id,number", (QFilter[])new QFilter[]{filterNumber}, null);){
            Iterator rows = ds.iterator();
            Row data = null;
            Long id = null;
            String number = null;
            while (rows != null && rows.hasNext()) {
                data = (Row)rows.next();
                id = data.getLong("id");
                number = data.getString("number");
                if (!ret.add(id)) continue;
                systemMap.put(id, number);
            }
        }
        return ret;
    }

    private Set<Long> getBillTypeIds(Set<Long> systemIds, Set<String> formids, Map<Long, String> billFormMap) {
        HashSet<Long> ret = new HashSet<Long>();
        QFilter filterForm = new QFilter("bindbill", "in", formids);
        QFilter filterSystem = new QFilter("externalerp", "in", systemIds);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.ssc.task.schedule.HandleReductionAccountImpl.getBillTypeIds", (String)"task_taskbill", (String)"id,bindbill", (QFilter[])new QFilter[]{filterForm, filterSystem}, null);){
            Iterator rows = ds.iterator();
            Row data = null;
            Long id = null;
            String bindbill = null;
            while (rows != null && rows.hasNext()) {
                data = (Row)rows.next();
                id = data.getLong("id");
                bindbill = data.getString("bindbill");
                if (!ret.add(id)) continue;
                billFormMap.put(id, bindbill);
            }
        }
        return ret;
    }

    private Map<Long, String> getFormMetaNumber(Map<String, String> formMap, Map<Long, String> billFormMap) {
        HashMap<Long, String> billNumberMap = new HashMap<Long, String>(16);
        for (Map.Entry<Long, String> entry : billFormMap.entrySet()) {
            Long id = entry.getKey();
            String bindBill = billFormMap.get(id);
            String billNumber = formMap.get(bindBill);
            billNumberMap.put(id, billNumber);
        }
        return billNumberMap;
    }

    private Date getPreMaxDate(Set<Long> billTypeIds) {
        Date maxRecordTime = null;
        try (DataSet dsReductAccount = QueryServiceHelper.queryDataSet((String)"kd.ssc.task.schedule.HandleReductionAccountImpl.getpPreMaxDate", (String)"task_temporaryamount", (String)"id,recordtime", null, (String)"recordtime desc", (int)1);){
            Iterator rows = dsReductAccount.iterator();
            Row data = null;
            if (rows != null && rows.hasNext()) {
                data = (Row)rows.next();
                maxRecordTime = data.getDate("recordtime");
            }
        }
        if (maxRecordTime == null) {
            QFilter filterQcLibId = new QFilter("qualitysamplelibrary", "=", (Object)0L);
            QFilter filterPoolType = new QFilter("pooltype", "=", (Object)"2");
            QFilter filterState = new QFilter("state", "=", (Object)TaskStateEnum.AuditPassed.getValue());
            QFilter filterBillType = new QFilter("billtype", "in", billTypeIds);
            QFilter filterCompleteTime = new QFilter("completetime", "is not null", (Object)"");
            QFilter filter = filterQcLibId.and(filterPoolType).and(filterState).and(filterBillType).and(filterCompleteTime);
            try (DataSet dsTask = QueryServiceHelper.queryDataSet((String)"HandleReductionAccountImpl.getpPreMaxDate.taskhistory", (String)"task_taskhistory", (String)"completetime", (QFilter[])filter.toArray(), (String)"completetime asc", (int)1);){
                Iterator rows = dsTask.iterator();
                Row data = null;
                if (rows != null && rows.hasNext()) {
                    data = (Row)rows.next();
                    maxRecordTime = data.getDate("completetime");
                } else {
                    maxRecordTime = new Date();
                }
            }
        }
        String maxRecordTimeString = TaskDateUtil.dateConvertFormatString(maxRecordTime, (String)"yyyy-MM-dd HH:mm:ss");
        return TaskDateUtil.stringConvertFormatDate((String)maxRecordTimeString, (String)DATEFORMAT_YYYYMMDDHHMM);
    }

    private Date getRecordEndTime(Date preRecordTime, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(preRecordTime);
        calendar.add(6, days);
        return calendar.getTime();
    }

    private int getGenerateReductionAccountCount(Date recordtime) {
        if (recordtime == null) {
            return 0;
        }
        QFilter filter = new QFilter("recordtime", "=", (Object)recordtime);
        DataSet dsRet = QueryServiceHelper.queryDataSet((String)"kd.ssc.task.schedule.HandleReductionAccountImpl.getGenerateReductionAccountCount(QFilter[])", (String)"task_temporaryamount", (String)"id", (QFilter[])new QFilter[]{filter}, null);
        if (dsRet == null) {
            return 0;
        }
        return dsRet.count("id", false);
    }
}

