/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.schedule.achieve;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.ssc.achieve.AchieveDateUtil;
import kd.ssc.task.formplugin.pojo.achieve.AchieveExpEnum;
import kd.ssc.task.formplugin.pojo.achieve.AchieveExpInfo;
import kd.ssc.task.formplugin.util.AchieveUtil;
import kd.ssc.task.formplugin.util.WorkLoadOnlineRecountUtil;

public class WorkLoadOnlineScheduleTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(WorkLoadOnlineScheduleTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date beforeDay = AchieveDateUtil.getBeforeDay();
        try {
            WorkLoadOnlineRecountUtil.deleteWorkLoadByDay(beforeDay, null);
            WorkLoadOnlineRecountUtil.saveWorkLoadBybeforeDay(beforeDay, null);
        }
        catch (Exception e) {
            this.saveWorkLoadExpInfo(e.getMessage(), beforeDay);
            log.error("\u5171\u4eab\u4eba\u5458\u7ebf\u4e0a\u5de5\u4f5c\u91cf\u751f\u6210\u6570\u636e\u5931\u8d25,\u5931\u8d25\u65e5\u671f\uff1a" + sdf.format(beforeDay), (Throwable)e);
        }
    }

    private void saveWorkLoadExpInfo(String erroMsg, Date createDate) {
        ArrayList<AchieveExpInfo> infos = new ArrayList<AchieveExpInfo>(16);
        List<Long> sscIds = AchieveUtil.getSscCenters();
        List<Long> exitSscIds = AchieveUtil.getExistWorkCalendarSsc(sscIds, createDate);
        for (Long sid : exitSscIds) {
            AchieveExpInfo achieveExpInfo = AchieveUtil.buildAchieveExp(sid, AchieveExpEnum.SSC_WORKLOADONLINE.getValue(), "1", 0, erroMsg, createDate, createDate);
            infos.add(achieveExpInfo);
        }
        AchieveUtil.saveAchieveExp(infos);
    }
}

