/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.service.filter.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.ComboItem;
import kd.bos.util.CollectionUtils;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.task.helper.FormShowParameterHelper;
import kd.ssc.task.image.SscImageServiceUtil;
import kd.ssc.task.service.filter.TaskCommonFilterService;
import kd.ssc.task.service.filter.dto.CommonFilterDTO;
import org.apache.commons.lang3.StringUtils;

public class TaskPoolTypeFilterServiceImpl
implements TaskCommonFilterService {
    @Override
    public void invokeAudit(CommonFilterDTO commonFilterDTO) {
        FormShowParameter formShowParameter;
        Map paramMap;
        commonFilterDTO.getCommonFilterColumn().getComboItems().removeIf(t -> t.getValue().equals(TaskPoolTypeEnum.TO_BE_DIS.getValue()) || t.getValue().equals(TaskPoolTypeEnum.TO_UPLOAD_IMAGE.getValue()));
        commonFilterDTO.getCommonFilterColumn().setDefaultValue(TaskPoolTypeEnum.PROCESSING.getValue());
        String newAdd = commonFilterDTO.getPageCache().get("is_firsttime_from_index");
        if ("TaskSalesIndexPlugin".equals(newAdd) && "3".equals((paramMap = (formShowParameter = commonFilterDTO.getFormView().getFormShowParameter()).getCustomParams()).get("tasksaleindex_item"))) {
            commonFilterDTO.getCommonFilterColumn().setDefaultValue(TaskPoolTypeEnum.COMPLETE.getValue());
        }
        commonFilterDTO.getCommonFilterColumn().setMustInput(true);
        String isScheme = commonFilterDTO.getPageCache().get("isSchemeFilter");
        String pooltype = commonFilterDTO.getPageCache().get("pooltype");
        if ("true".equals(isScheme) && kd.bos.util.StringUtils.isNotEmpty((String)pooltype)) {
            commonFilterDTO.getCommonFilterColumn().setDefaultValue(pooltype);
        }
    }

    @Override
    public void invokeQuality(CommonFilterDTO commonFilterDTO) {
        List comboItemList = commonFilterDTO.getCommonFilterColumn().getComboItems();
        comboItemList.clear();
        List<ComboItem> cbList = this.getPoolTypeList();
        commonFilterDTO.getCommonFilterColumn().setComboItems(cbList);
        String defaultValue = TaskPoolTypeEnum.PROCESSING.getValue();
        if (commonFilterDTO.getPageCache() != null && !StringUtils.isEmpty((CharSequence)commonFilterDTO.getPageCache().get("pooltype"))) {
            defaultValue = commonFilterDTO.getPageCache().get("pooltype");
        }
        commonFilterDTO.getCommonFilterColumn().setDefaultValue(defaultValue);
        commonFilterDTO.getCommonFilterColumn().setMustInput(true);
    }

    private List<ComboItem> getPoolTypeList() {
        ArrayList<ComboItem> cbList = new ArrayList<ComboItem>();
        cbList.add(new ComboItem(new LocaleString(TaskPoolTypeEnum.PROCESSING.getName()), TaskPoolTypeEnum.PROCESSING.getValue()));
        cbList.add(new ComboItem(new LocaleString(TaskPoolTypeEnum.COMPLETE.getName()), TaskPoolTypeEnum.COMPLETE.getValue()));
        return cbList;
    }

    @Override
    public void invokeAuditAdmin(CommonFilterDTO commonFilterDTO) {
        boolean displayImage;
        List listcomitem = commonFilterDTO.getCommonFilterColumn().getComboItems();
        String sscId = commonFilterDTO.getPageCache().get("sscid");
        String billTypeJson = commonFilterDTO.getPageCache().get("billTypeJson");
        List billTypeIdList = new ArrayList();
        if (kd.bos.util.StringUtils.isNotEmpty((String)billTypeJson)) {
            billTypeIdList = (List)SerializationUtils.fromJsonString((String)billTypeJson, List.class);
        }
        if (!(displayImage = SscImageServiceUtil.imageDisplayCtrl((Long)Long.valueOf(sscId), billTypeIdList)) && CollectionUtils.isNotEmpty((Collection)listcomitem)) {
            Iterator iterator = listcomitem.iterator();
            while (iterator.hasNext()) {
                ComboItem poolTypeItem = (ComboItem)iterator.next();
                String poolType = poolTypeItem.getValue();
                if (!TaskPoolTypeEnum.TO_UPLOAD_IMAGE.getValue().equals(poolType)) continue;
                iterator.remove();
            }
            commonFilterDTO.getCommonFilterColumn().setComboItems(listcomitem);
        }
        if ("true".equals(commonFilterDTO.getPageCache().get("is_firsttime_from_index")) || "true".equals(commonFilterDTO.getPageCache().get("isSchemeFilter"))) {
            commonFilterDTO.getCommonFilterColumn().setDefaultValue(commonFilterDTO.getPageCache().get("pooltype"));
        } else {
            commonFilterDTO.getCommonFilterColumn().setDefaultValue(TaskPoolTypeEnum.TO_BE_DIS.getValue());
        }
        commonFilterDTO.getCommonFilterColumn().setMustInput(true);
    }

    private int getSizeInList(List<ComboItem> listcomitem, String string) {
        for (int i = 0; i < listcomitem.size(); ++i) {
            ComboItem c = listcomitem.get(i);
            String value = c.getValue();
            if (!"3".equals(value)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void invokeQualityList(CommonFilterDTO commonFilterDTO) {
        String source = (String)FormShowParameterHelper.getParameterByKey(commonFilterDTO.getFormView(), "sources");
        List poolTypeList = (List)FormShowParameterHelper.getParameterByKey(commonFilterDTO.getFormView(), "pooltype");
        List comboItems = commonFilterDTO.getCommonFilterColumn().getComboItems();
        comboItems.removeIf(p -> p.getValue().equals(TaskPoolTypeEnum.TO_UPLOAD_IMAGE.getValue()));
        if ("qualitysamplelibrary".equalsIgnoreCase(source)) {
            if (poolTypeList == null || poolTypeList.size() == 0) {
                commonFilterDTO.getPageCache().put("pooltype", TaskPoolTypeEnum.TO_BE_DIS.getValue());
                commonFilterDTO.getCommonFilterColumn().setDefaultValue(TaskPoolTypeEnum.TO_BE_DIS.getValue());
            } else {
                commonFilterDTO.getCommonFilterColumn().setDefaultValues(poolTypeList);
            }
        } else {
            commonFilterDTO.getCommonFilterColumn().setDefaultValue(TaskPoolTypeEnum.TO_BE_DIS.getValue());
        }
        commonFilterDTO.getCommonFilterColumn().setMustInput(true);
    }
}

