/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.service.filter.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.field.ComboItem;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.ssc.enums.SSCTypeEnum;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.business.helper.DutyManageDataHelper;
import kd.ssc.task.common.TaskPropertyEnum;
import kd.ssc.task.common.TaskTypeUtil;
import kd.ssc.task.image.SscImageServiceUtil;
import kd.ssc.task.service.filter.TaskCommonFilterService;
import kd.ssc.task.service.filter.dto.CommonFilterDTO;

public class TaskStateFilterServiceImpl
implements TaskCommonFilterService {
    private List<String> needStates = null;

    @Override
    public void invokeAudit(CommonFilterDTO commonFilterDTO) {
        String sscId = commonFilterDTO.getPageCache().get("sscid.id");
        String billTypeJson = commonFilterDTO.getPageCache().get("billTypeJson");
        List billTypeIdList = new ArrayList();
        if (StringUtils.isNotEmpty((String)billTypeJson)) {
            billTypeIdList = (List)SerializationUtils.fromJsonString((String)billTypeJson, List.class);
        }
        String poolType = commonFilterDTO.getPageCache().get("pooltype");
        CommonFilterColumn commonFilterColumn = commonFilterDTO.getCommonFilterColumn();
        List comboItems = commonFilterColumn.getComboItems();
        List noNeedStates = TaskStateEnum.getAllTaskState();
        if (TaskPoolTypeEnum.PROCESSING.getValue().equals(poolType)) {
            boolean displayImage = SscImageServiceUtil.imageDisplayCtrl((Long)Long.valueOf(sscId), billTypeIdList);
            if (displayImage) {
                noNeedStates.removeAll(Arrays.asList(TaskStateEnum.TO_BE_AUDIT.getValue(), TaskStateEnum.PAUSE.getValue(), TaskStateEnum.RESCAN.getValue(), TaskStateEnum.REUPLOAD_IMAGE.getValue()));
            } else {
                noNeedStates.removeAll(Arrays.asList(TaskStateEnum.TO_BE_AUDIT.getValue(), TaskStateEnum.PAUSE.getValue()));
            }
        } else if (TaskPoolTypeEnum.COMPLETE.getValue().equals(poolType)) {
            noNeedStates.removeAll(Arrays.asList(TaskStateEnum.AUDIT_PASSED.getValue(), TaskStateEnum.AUDIT_NOTPASSED.getValue()));
        }
        if (CollectionUtils.isNotEmpty((Collection)noNeedStates)) {
            comboItems.removeIf(p -> noNeedStates.contains(p.getValue()));
        }
        String newAdd = commonFilterDTO.getPageCache().get("is_firsttime_from_index");
        String statisticalItem = commonFilterDTO.getPageCache().get("tasksaleindex_item");
        if ("TaskSalesIndexPlugin".equals(newAdd)) {
            if (commonFilterColumn.getDefaultValues() != null) {
                commonFilterColumn.getDefaultValues().clear();
                commonFilterColumn.setDefaultValue(null);
            }
            ArrayList<String> defaultValues = new ArrayList<String>(2);
            if ("3".equals(statisticalItem)) {
                commonFilterColumn.setDefaultValues(defaultValues);
            } else if (!"4".equals(statisticalItem)) {
                if ("1".equals(statisticalItem)) {
                    defaultValues.add(TaskStateEnum.TO_BE_AUDIT.getValue());
                    defaultValues.add(TaskStateEnum.REUPLOAD_IMAGE.getValue());
                    commonFilterColumn.setDefaultValues(defaultValues);
                } else if ("0".equals(statisticalItem)) {
                    commonFilterColumn.setDefaultValue(TaskStateEnum.PAUSE.getValue());
                } else if ("2".equals(statisticalItem)) {
                    commonFilterColumn.setDefaultValue(TaskStateEnum.RESCAN.getValue());
                }
            }
        }
    }

    @Override
    public void invokeQuality(CommonFilterDTO commonFilterDTO) {
        String poolType = commonFilterDTO.getPageCache().get("pooltype");
        String state = commonFilterDTO.getPageCache().get("state");
        CommonFilterColumn commonFilterColumn = commonFilterDTO.getCommonFilterColumn();
        List comboItems = commonFilterColumn.getComboItems();
        if (StringUtils.isNotEmpty((String)poolType)) {
            List<String> quaStateProcess = Arrays.asList(TaskStateEnum.CHECKING.getValue(), TaskStateEnum.RECTIFYING.getValue(), TaskStateEnum.REVIEW.getValue(), TaskStateEnum.PAUSE_CHECKING.getValue(), TaskStateEnum.PAUSE_RECTIFYING.getValue(), TaskStateEnum.PAUSE_REVIEW.getValue());
            if (TaskPoolTypeEnum.PROCESSING.getValue().equals(poolType) && !TaskStateEnum.TO_BE_TRACKED.getValue().equals(state)) {
                comboItems.removeIf(p -> !quaStateProcess.contains(p.getValue()));
            } else if (TaskPoolTypeEnum.COMPLETE.getValue().equals(poolType)) {
                this.resetComboItems(commonFilterColumn, true, TaskStateEnum.QUA_CHECK_COMPLETED.getValue());
            } else if (TaskStateEnum.TO_BE_TRACKED.getValue().equals(state)) {
                this.resetComboItems(commonFilterColumn, true, TaskStateEnum.TO_BE_TRACKED.getValue());
            }
        }
        String newAdd = commonFilterDTO.getPageCache().get("is_firsttime_from_index");
        String statisticalItem = commonFilterDTO.getPageCache().get("tasksaleindex_item");
        if ("TaskSalesIndexPlugin".equals(newAdd)) {
            if (commonFilterColumn.getDefaultValues() != null) {
                commonFilterColumn.getDefaultValues().clear();
                commonFilterColumn.setDefaultValue(null);
            }
            ArrayList<String> defaultValues = new ArrayList<String>(2);
            switch (statisticalItem) {
                case "5": {
                    defaultValues.add(TaskStateEnum.CHECKING.getValue());
                    break;
                }
                case "10": {
                    defaultValues.add(TaskStateEnum.PAUSE_CHECKING.getValue());
                    defaultValues.add(TaskStateEnum.PAUSE_RECTIFYING.getValue());
                    defaultValues.add(TaskStateEnum.PAUSE_REVIEW.getValue());
                    break;
                }
                case "6": {
                    defaultValues.add(TaskStateEnum.RECTIFYING.getValue());
                    break;
                }
                case "7": {
                    defaultValues.add(TaskStateEnum.REVIEW.getValue());
                    break;
                }
                case "9": {
                    defaultValues.add(TaskStateEnum.QUA_CHECK_COMPLETED.getValue());
                }
            }
            commonFilterColumn.setDefaultValues(defaultValues);
        }
    }

    private void resetComboItems(CommonFilterColumn commonFilterColumn, boolean isMustInput, String defaultVal) {
        List comboItems = commonFilterColumn.getComboItems();
        comboItems.clear();
        comboItems.add(new ComboItem(new LocaleString(TaskStateEnum.TO_BE_TRACKED.getName()), TaskStateEnum.TO_BE_TRACKED.getValue()));
        comboItems.add(new ComboItem(new LocaleString(TaskStateEnum.QUA_CHECK_COMPLETED.getName()), TaskStateEnum.QUA_CHECK_COMPLETED.getValue()));
        commonFilterColumn.setMustInput(isMustInput);
        commonFilterColumn.setDefaultValue(defaultVal);
    }

    @Override
    public void invokeAuditAdmin(CommonFilterDTO commonFilterDTO) {
        String state;
        String poolType = commonFilterDTO.getPageCache().get("pooltype");
        String sscId = commonFilterDTO.getPageCache().get("sscid");
        String billTypeJson = commonFilterDTO.getPageCache().get("billTypeJson");
        List billTypeIdList = new ArrayList();
        if (StringUtils.isNotEmpty((String)billTypeJson)) {
            billTypeIdList = (List)SerializationUtils.fromJsonString((String)billTypeJson, List.class);
        }
        String taskTypeJson = commonFilterDTO.getPageCache().get("taskTypeJson");
        ArrayList<Long> taskTypeIDList = new ArrayList();
        if (StringUtils.isNotEmpty((String)taskTypeJson)) {
            taskTypeIDList = (List)SerializationUtils.fromJsonString((String)taskTypeJson, List.class);
        }
        List comboItems = commonFilterDTO.getCommonFilterColumn().getComboItems();
        List noNeedStates = TaskStateEnum.getAllTaskState();
        if (TaskPoolTypeEnum.TO_UPLOAD_IMAGE.getValue().equals(poolType)) {
            noNeedStates.removeAll(Collections.singletonList(TaskStateEnum.TO_UPLOAD_IMAGE.getValue()));
        } else if (TaskPoolTypeEnum.TO_BE_DIS.getValue().equals(poolType)) {
            noNeedStates.removeAll(Arrays.asList(TaskStateEnum.TO_BE_DIS.getValue(), TaskStateEnum.DIS_EXCEPTION.getValue(), TaskStateEnum.RECYCLE.getValue()));
        } else if (TaskPoolTypeEnum.PROCESSING.getValue().equals(poolType)) {
            boolean displayImage = SscImageServiceUtil.imageDisplayCtrl((Long)Long.valueOf(sscId), billTypeIdList);
            if (displayImage) {
                noNeedStates.removeAll(Arrays.asList(TaskStateEnum.TO_BE_AUDIT.getValue(), TaskStateEnum.PAUSE.getValue(), TaskStateEnum.RESCAN.getValue(), TaskStateEnum.REUPLOAD_IMAGE.getValue()));
            } else {
                noNeedStates.removeAll(Arrays.asList(TaskStateEnum.TO_BE_AUDIT.getValue(), TaskStateEnum.PAUSE.getValue()));
            }
        } else if (TaskPoolTypeEnum.COMPLETE.getValue().equals(poolType)) {
            String sscType = DutyManageDataHelper.getSSCType((long)Long.parseLong(sscId));
            if (SSCTypeEnum.HR.getValue().equals(sscType)) {
                if (CollectionUtils.isNotEmpty(taskTypeIDList)) {
                    HashSet<String> needStateSet = new HashSet<String>();
                    if (TaskTypeUtil.containTaskProperty(taskTypeIDList, TaskPropertyEnum.HANDLE_TASK)) {
                        needStateSet.add(TaskStateEnum.PROCESSED.getValue());
                        needStateSet.add(TaskStateEnum.TERMINATED.getValue());
                    }
                    if (TaskTypeUtil.containTaskProperty(taskTypeIDList, TaskPropertyEnum.APPROVETASK) || TaskTypeUtil.containTaskProperty(taskTypeIDList, TaskPropertyEnum.INQUIRY_TASK)) {
                        needStateSet.add(TaskStateEnum.AUDIT_PASSED.getValue());
                        needStateSet.add(TaskStateEnum.AUDIT_NOTPASSED.getValue());
                        needStateSet.add(TaskStateEnum.TERMINATED.getValue());
                    }
                    noNeedStates.removeAll(needStateSet);
                } else {
                    noNeedStates.removeAll(Arrays.asList(TaskStateEnum.AUDIT_PASSED.getValue(), TaskStateEnum.AUDIT_NOTPASSED.getValue(), TaskStateEnum.PROCESSED.getValue(), TaskStateEnum.TERMINATED.getValue()));
                }
            } else {
                noNeedStates.removeAll(Arrays.asList(TaskStateEnum.AUDIT_PASSED.getValue(), TaskStateEnum.AUDIT_NOTPASSED.getValue()));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)noNeedStates)) {
            comboItems.removeIf(p -> noNeedStates.contains(p.getValue()));
        }
        if ((state = commonFilterDTO.getPageCache().get("state")) != null && !noNeedStates.contains(state)) {
            commonFilterDTO.getCommonFilterColumn().setDefaultValue(state);
            commonFilterDTO.getPageCache().remove("state");
        }
    }

    @Override
    public void invokeQualityList(CommonFilterDTO commonFilterDTO) {
        String poolType = commonFilterDTO.getPageCache().get("pooltype");
        List comboItems = commonFilterDTO.getCommonFilterColumn().getComboItems();
        if (TaskPoolTypeEnum.TO_BE_DIS.getValue().equals(poolType)) {
            this.needStates = Arrays.asList(TaskStateEnum.TO_BE_DIS.getValue(), TaskStateEnum.TO_BE_MANUAL_DIS.getValue(), TaskStateEnum.DIS_EXCEPTION.getValue(), TaskStateEnum.RECYCLE.getValue());
        } else if (TaskPoolTypeEnum.PROCESSING.getValue().equals(poolType)) {
            this.needStates = Arrays.asList(TaskStateEnum.CHECKING.getValue(), TaskStateEnum.RECTIFYING.getValue(), TaskStateEnum.REVIEW.getValue(), TaskStateEnum.PAUSE_CHECKING.getValue(), TaskStateEnum.PAUSE_RECTIFYING.getValue(), TaskStateEnum.PAUSE_REVIEW.getValue());
        } else if (TaskPoolTypeEnum.COMPLETE.getValue().equals(poolType)) {
            this.needStates = Arrays.asList(TaskStateEnum.QUA_CHECK_COMPLETED.getValue(), TaskStateEnum.DISCARD.getValue());
        }
        if (this.needStates != null) {
            comboItems.removeIf(p -> !this.needStates.contains(p.getValue()));
        }
    }
}

