/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.service.filter.impl;

import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.formplugin.util.UserGroupUtil;
import kd.ssc.task.service.filter.TaskCommonFilterService;
import kd.ssc.task.service.filter.dto.CommonFilterDTO;

public class UserGroupFilterServiceImpl
implements TaskCommonFilterService {
    @Override
    public void invokeAuditAdmin(CommonFilterDTO commonFilterDTO) {
        String sscid = commonFilterDTO.getPageCache().get("sscid");
        List listcomitemBilltype = commonFilterDTO.getCommonFilterColumn().getComboItems();
        listcomitemBilltype.clear();
        if (sscid != null) {
            this.setComboItems(commonFilterDTO, sscid, "HXLFBW8ZGNH", "HXLT47Z1L8S");
        }
    }

    private void setComboItems(CommonFilterDTO commonFilterDTO, String sscid, String adminRoleId, String businessAdminRole) {
        QFilter sscFilter = new QFilter("createorg", "=", (Object)Long.valueOf(sscid));
        IPageCache pageCache = commonFilterDTO.getPageCache();
        String groupId = pageCache.get("usergroupid");
        boolean hasRight = UserGroupUtil.verifyIdentity(sscid, RequestContext.get().getUserId(), adminRoleId, businessAdminRole, pageCache);
        if (!hasRight) {
            pageCache.put("isright", "false");
            return;
        }
        pageCache.put("isright", null);
        String identity = pageCache.get("identity");
        if ("sysadmin".equals(identity)) {
            List<ComboItem> userGroups = CommonFilterUtil.getComboItems("task_usergroup", sscFilter);
            userGroups.add(0, new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"TaskTypeFilterServiceImpl_0", (String)"ssc-task-formplugin", (Object[])new Object[0])), ""));
            commonFilterDTO.getCommonFilterColumn().setComboItems(userGroups);
            if (StringUtils.isNotBlank((CharSequence)groupId) && !"-1".equals(groupId)) {
                commonFilterDTO.getCommonFilterColumn().setDefaultValue(groupId);
                this.buildCommonFilterData(pageCache, sscid, groupId);
            } else {
                commonFilterDTO.getCommonFilterColumn().setDefaultValue("");
                this.buildCommonFilterData(pageCache, sscid, null);
            }
        } else {
            HashSet<Long> manageGroup = UserGroupUtil.getManageGroup(sscid, RequestContext.get().getUserId());
            QFilter idFilter = new QFilter("id", "in", manageGroup);
            List<ComboItem> userGroups = CommonFilterUtil.getComboItems("task_usergroup", idFilter);
            userGroups.add(0, new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"TaskTypeFilterServiceImpl_0", (String)"ssc-task-formplugin", (Object[])new Object[0])), ""));
            commonFilterDTO.getCommonFilterColumn().setComboItems(userGroups);
            if (userGroups.size() == 0) {
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)groupId) && !"-1".equals(groupId)) {
                commonFilterDTO.getCommonFilterColumn().setDefaultValue(groupId);
                this.buildCommonFilterData(pageCache, sscid, groupId);
            } else {
                commonFilterDTO.getCommonFilterColumn().setDefaultValue("");
                this.buildCommonFilterData(pageCache, sscid, null);
            }
        }
    }

    @Override
    public void invokeQualityList(CommonFilterDTO commonFilterDTO) {
        String sscid = commonFilterDTO.getPageCache().get("CACHE_QUALITYCHECKMANAGEMENT_SSCID");
        List listcomitemBilltype = commonFilterDTO.getCommonFilterColumn().getComboItems();
        listcomitemBilltype.clear();
        if (sscid != null) {
            this.setComboItems(commonFilterDTO, sscid, "/JFEAD2U2A1R", "HXLT47Z1L8S");
        }
    }

    private void buildCommonFilterData(IPageCache pageCache, String sscid, String usergroup) {
        DynamicObject[] disrules;
        if (usergroup == null) {
            pageCache.put("taskManager_Usergroup_Tasktype", null);
            pageCache.put("taskManager_Usergroup_Taskbill", null);
            pageCache.put("taskManager_Usergroup_Taskorg", null);
            return;
        }
        QFilter sscFilter = new QFilter("ssccenter.id", "=", (Object)Long.parseLong(sscid));
        HashSet<Long> tasktypeSet = new HashSet<Long>(16);
        HashSet<Long> taskbillSet = new HashSet<Long>(16);
        HashSet<Long> taskorgSet = new HashSet<Long>(16);
        for (DynamicObject disrule : disrules = BusinessDataServiceHelper.load((String)"task_disrule", (String)"tasktype,entryentity.billtype,entryentity1.orgrange,entryentity1.usergroup", (QFilter[])new QFilter[]{sscFilter}, (String)"priority")) {
            DynamicObjectCollection entryBillTypeColls = disrule.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection entryGroupOrgcolls = disrule.getDynamicObjectCollection("entryentity1");
            for (DynamicObject entryGroupOrg : entryGroupOrgcolls) {
                String groupId = entryGroupOrg.getString("usergroup.id");
                if (!usergroup.equals(groupId)) continue;
                for (DynamicObject entryBillType : entryBillTypeColls) {
                    Long billType = entryBillType.getLong("billtype.id");
                    taskbillSet.add(billType);
                }
                Long taskType = disrule.getLong("tasktype.id");
                tasktypeSet.add(taskType);
                DynamicObjectCollection orgColls = entryGroupOrg.getDynamicObjectCollection("orgrange");
                for (DynamicObject dyobj : orgColls) {
                    taskorgSet.add(dyobj.getLong("FBasedataId_id"));
                }
            }
        }
        pageCache.put("taskManager_Usergroup_Tasktype", SerializationUtils.toJsonString(tasktypeSet));
        pageCache.put("taskManager_Usergroup_Taskbill", SerializationUtils.toJsonString(taskbillSet));
        pageCache.put("taskManager_Usergroup_Taskorg", SerializationUtils.toJsonString(taskorgSet));
    }
}

