/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.service.rpt.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.task.common.DateRangeEnum;
import kd.ssc.task.common.DateRangeUtil;
import kd.ssc.task.common.TaskFilterEnum;
import kd.ssc.task.formplugin.pojo.DateRange;
import kd.ssc.task.formplugin.rpt.TaskScheduleParamHelper;
import kd.ssc.task.service.rpt.TaskCountService;

public class TaskChartCountServiceImpl
implements TaskCountService {
    private static final String SELECTFIELD = "pooltype,sscid,tasktypeid,createtime,receivetime,completetime";
    private static final String[] GROUPBY = new String[]{"sscid", "pooltype", "tasktypeid"};
    private static final int PAGE_SIZE = 1000;

    @Override
    public void countTask() {
        DateRangeEnum[] dateRangeEnums = DateRangeEnum.values();
        Date[] showDate = TaskScheduleParamHelper.getBarChartDateRange();
        for (DateRangeEnum dateRangeEnum : dateRangeEnums) {
            DataSet tmpDataSet;
            int i;
            DateRange dateRange = DateRangeUtil.getDateRange(dateRangeEnum);
            DataSet[] taskData = this.query(dateRange);
            for (i = 0; i < showDate.length - 1; ++i) {
                tmpDataSet = this.processAndUnion(taskData, showDate[i], showDate[i + 1]);
                this.delete(dateRangeEnum, i);
                this.save(tmpDataSet, dateRangeEnum, i);
            }
            tmpDataSet = this.processAndUnion(taskData, null, showDate[i]);
            this.delete(dateRangeEnum, i);
            this.save(tmpDataSet, dateRangeEnum, i);
        }
    }

    private DataSet[] query(DateRange dateRange) {
        QFilter[] filtersTodist = this.getFilters(dateRange, 0);
        DataSet dataTodist = QueryServiceHelper.queryDataSet((String)"TaskChartCountServiceImpl.query", (String)"task_task", (String)SELECTFIELD, (QFilter[])filtersTodist, null);
        QFilter[] filtersProc = this.getFilters(dateRange, 1);
        DataSet dataProc = QueryServiceHelper.queryDataSet((String)"TaskChartCountServiceImpl.query", (String)"task_task", (String)SELECTFIELD, (QFilter[])filtersProc, null);
        QFilter[] filtersCompl = this.getFilters(dateRange, 2);
        DataSet dataCompl = QueryServiceHelper.queryDataSet((String)"TaskChartCountServiceImpl.query", (String)"task_taskhistory", (String)SELECTFIELD, (QFilter[])filtersCompl, null);
        DataSet[] dataSets = new DataSet[]{dataTodist, dataProc, dataCompl};
        return dataSets;
    }

    private DataSet process(DataSet dataSet, Date beginDate, Date endDate, int pooltype) {
        DataSet dataSetProcess;
        if (pooltype == 0) {
            String caseSql = this.getCaseSql("createtime", pooltype, beginDate, endDate);
            dataSetProcess = dataSet.select(SELECTFIELD).groupBy(GROUPBY).sum(caseSql, "count").finish();
        } else if (pooltype == 1) {
            String caseSql = this.getCaseSql("receivetime", 1, beginDate, endDate);
            dataSetProcess = dataSet.select(SELECTFIELD).groupBy(GROUPBY).sum(caseSql, "count").finish();
        } else {
            String caseSql = this.getCaseSql("completetime", 2, beginDate, endDate);
            dataSetProcess = dataSet.select(SELECTFIELD).groupBy(GROUPBY).sum(caseSql, "count").finish();
        }
        return dataSetProcess;
    }

    private void delete(DateRangeEnum dateRangeEnum, int statdateRange) {
        QFilter filter = new QFilter("datetype", "=", (Object)dateRangeEnum.getValue());
        filter.and(new QFilter("statdaterange", "=", (Object)statdateRange));
        DeleteServiceHelper.delete((String)"task_chart_statistics", (QFilter[])new QFilter[]{filter});
    }

    private void save(DataSet dataSet, DateRangeEnum dateRangeEnum, int statdateRange) {
        int totalCount = dataSet.copy().count("pooltype", false);
        int pageCount = totalCount / 1000;
        int remiCount = totalCount;
        for (int i = 0; i <= pageCount; ++i) {
            int fromIndex = i * 1000;
            int pageSizeAcu = Math.min(remiCount, 1000);
            DataSet subDataSet = dataSet.range(fromIndex, pageSizeAcu);
            this.savePage(subDataSet, dateRangeEnum, statdateRange, pageSizeAcu);
            if ((remiCount -= 1000) <= 0) break;
        }
        dataSet.close();
    }

    private QFilter[] getFilters(DateRange dateRange, int pooltype) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (pooltype == 0) {
            filterList.add(new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.TO_BE_DIS.getValue()));
            filterList.add(new QFilter("createtime", ">=", (Object)dateRange.getStartDate()));
            filterList.add(new QFilter("createtime", "<", (Object)dateRange.getEndDate()));
        } else if (pooltype == 1) {
            filterList.add(new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue()));
            filterList.add(new QFilter("createtime", ">=", (Object)dateRange.getStartDate()));
            filterList.add(new QFilter("createtime", "<", (Object)dateRange.getEndDate()));
        } else {
            filterList.add(new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.COMPLETE.getValue()));
            filterList.add(new QFilter("createtime", ">=", (Object)dateRange.getStartDate()));
            filterList.add(new QFilter("createtime", "<", (Object)dateRange.getEndDate()));
        }
        filterList.add(new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK));
        filterList.add(new QFilter("autoprocess", "=", (Object)"0"));
        return filterList.toArray(new QFilter[0]);
    }

    private String getCaseSql(String timeType, int pooltype, Date beginDate, Date endDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String typeTimeFilter = String.format("cast(year(%s) as integer)*10000+cast(month(%s) as integer)*100+cast(day(%s) as integer)", timeType, timeType, timeType);
        if (beginDate == null && endDate == null) {
            return String.format("cast(case when " + typeTimeFilter + " < %s and " + typeTimeFilter + " >= %s and pooltype = '%d' then 1 else 0 end as integer)", df.format(new Date()), df.format(new Date()), pooltype);
        }
        if (beginDate == null) {
            return String.format("cast(case when " + typeTimeFilter + " < %s and pooltype = '%d' then 1 else 0 end as integer)", df.format(endDate), pooltype);
        }
        if (endDate == null) {
            return String.format("cast(case when " + typeTimeFilter + " >= %s and pooltype = '%d' then 1 else 0 end as integer)", df.format(beginDate), pooltype);
        }
        return String.format("cast(case when " + typeTimeFilter + " < %s and " + typeTimeFilter + " >= %s and pooltype = '%d' then 1 else 0 end as integer)", df.format(beginDate), df.format(endDate), pooltype);
    }

    private void savePage(DataSet subDataSet, DateRangeEnum dateRangeEnum, int statdaterange, int size) {
        DynamicObject[] taskArr = new DynamicObject[size];
        int i = 0;
        for (Row row : subDataSet) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"task_chart_statistics");
            obj.set("sscid", row.get("sscid"));
            obj.set("tasktypeid", row.get("tasktypeid"));
            obj.set("datetype", (Object)dateRangeEnum.getValue());
            obj.set("pooltype", row.get("pooltype"));
            obj.set("statdaterange", (Object)statdaterange);
            obj.set("count", row.get("count"));
            taskArr[i++] = obj;
        }
        SaveServiceHelper.save((DynamicObject[])taskArr);
    }

    private DataSet processAndUnion(DataSet[] taskData, Date begin, Date end) {
        DataSet dataSetTodist = this.process(taskData[0].copy(), begin, end, 0);
        DataSet dataSetProc = this.process(taskData[1].copy(), begin, end, 1);
        DataSet dataSetComl = this.process(taskData[2].copy(), begin, end, 2);
        return dataSetTodist.union(dataSetProc).union(dataSetComl);
    }
}

