/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.service.wf.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.task.formplugin.pojo.DateRange;
import kd.ssc.task.service.wf.TaskWfTimeService;
import kd.ssc.task.util.DateUtil;

public class TaskWfTimeServiceImpl
implements TaskWfTimeService {
    private static final Log log = LogFactory.getLog(TaskWfTimeServiceImpl.class);
    private static final String TASK_HIS = "task_taskhistory";
    private static final String TASK_WF = "task_wftask";
    private static final String TASK_WF_STATICS = "task_wftimestatistics";
    private static final String TASK_FIELDS = "id, tasktypeid, billtype, orgid, sscid, personid, costwaittime";
    private static final String TASK_WF_FIELDS = "id, processdefinitionid, taskdefinitionkey, processinstanceid, taskhistoryid, assignid";
    private static final String TASK_WF_STATICS_FIELDS = "id, processdefinitionid as PROCDEFID, taskdefinitionkey as PROCDEFKEY, tasktypeid.id as NODEID, tasktypeid.name as NODENAME, personid as USERID, count, timesum, timemax";
    private static final String[] TASK_JOIN = new String[]{"id", "tasktypeid", "billtype", "orgid", "sscid", "personid", "costwaittime"};
    private static final String[] TASK_WF_JOIN = new String[]{"processdefinitionid", "taskdefinitionkey", "processinstanceid", "taskhistoryid", "assignid"};
    private static final String[] TASK_WF_GROUPBY = new String[]{"processdefinitionid", "taskdefinitionkey", "tasktypeid", "billtype", "orgid", "sscid", "personid"};
    private static final String[] STATICS_NODE_GROUPBY = new String[]{"PROCDEFID", "PROCDEFKEY", "NODEID", "NODENAME"};
    private static final String[] STATICS_USER_GROUPBY = new String[]{"PROCDEFID", "PROCDEFKEY", "NODEID", "NODENAME", "USERID"};

    @Override
    public void statisticsWfTime(Map<String, Date> params) {
        DateRange dateRange = this.getDate(params);
        QFilter[] filters = new QFilter[]{new QFilter("completetime", ">=", (Object)dateRange.getStartDate()), new QFilter("completetime", "<=", (Object)dateRange.getEndDate())};
        DataSet taskHis = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".query"), (String)TASK_HIS, (String)TASK_FIELDS, (QFilter[])filters, null);
        DataSet taskWf = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".query"), (String)TASK_WF, (String)TASK_WF_FIELDS, (QFilter[])filters, null);
        if (taskHis.isEmpty() || taskWf.isEmpty()) {
            log.info("\u65f6\u957f\u7edf\u8ba1\u4e8b\u52a1\u6267\u884c\u5f02\u5e38\uff0c\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a\uff01");
        } else {
            DataSet taskAndWf = taskHis.join(taskWf, JoinType.INNER).select(TASK_JOIN, TASK_WF_JOIN).on("id", "taskhistoryid").finish();
            DataSet taskStatics = taskAndWf.groupBy(TASK_WF_GROUPBY).sum("costwaittime", "timesum").max("costwaittime", "timemax").count("count").finish();
            if (this.existTaskStatics(dateRange)) {
                log.info("\u65f6\u957f\u7edf\u8ba1\u8868\u4e2d\u5df2\u5b58\u5728\u6570\u636e\uff0c\u5c06\u5220\u9664\u91cd\u65b0\u7edf\u8ba1");
                try (TXHandle h = TX.requiresNew((String)"ssc_task_taskWf");){
                    try {
                        this.clearTaskStatics(dateRange);
                        this.saveTaskStatics(taskStatics, dateRange);
                    }
                    catch (Throwable e) {
                        log.error("\u65f6\u957f\u7edf\u8ba1\u4e8b\u52a1\u6267\u884c\u5f02\u5e38\uff0c\u5c06\u56de\u6eda");
                        h.markRollback();
                    }
                }
            } else {
                this.saveTaskStatics(taskStatics, dateRange);
            }
        }
    }

    @Override
    public List<Map<String, Object>> getStaticsByNode(Date begin, Date end) {
        log.info("\u5171\u4eab\u65f6\u957f\u7edf\u8ba1\u8868\u6309\u8282\u70b9\u67e5\u8be2, begin\uff1a{}, end: {}", (Object)begin, (Object)end);
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        if (begin == null || end == null) {
            log.info("\u5171\u4eab\u65f6\u957f\u7edf\u8ba1\u8868\u6309\u8282\u70b9\u67e5\u8be2, \u4f20\u5165\u53c2\u6570\u6709\u7a7a\u503c\uff01");
            return result;
        }
        QFilter[] filters = new QFilter[]{new QFilter("date", ">=", (Object)begin), new QFilter("date", "<=", (Object)end)};
        DataSet taskStatics = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".query"), (String)TASK_WF_STATICS, (String)TASK_WF_STATICS_FIELDS, (QFilter[])filters, null);
        if (null != taskStatics) {
            DataSet staticsData = taskStatics.groupBy(STATICS_NODE_GROUPBY).sum("timesum", "SUMDURATION").sum("count", "INSTANCECOUNT").max("timemax", "MAXDURATION").finish();
            result = new LinkedList();
            for (Row row : staticsData) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("PROCDEFID", row.getLong("PROCDEFID"));
                data.put("NODEID", row.getString("PROCDEFKEY"));
                data.put("NODENAME", row.getString("NODENAME"));
                data.put("INSTANCECOUNT", row.getInteger("INSTANCECOUNT"));
                BigDecimal sum = row.getBigDecimal("SUMDURATION").multiply(new BigDecimal(3600)).multiply(new BigDecimal(1000));
                BigDecimal max = row.getBigDecimal("MAXDURATION").multiply(new BigDecimal(3600)).multiply(new BigDecimal(1000));
                data.put("SUMDURATION", sum.longValueExact());
                data.put("MAXDURATION", max.longValueExact());
                result.add(data);
            }
            log.info("\u5171\u4eab\u65f6\u957f\u7edf\u8ba1\u8868\u6309\u8282\u70b9\u67e5\u8be2, \u7edf\u8ba1\u7ed3\u679c\uff1a{}", result);
            return result;
        }
        log.info("\u5171\u4eab\u65f6\u957f\u7edf\u8ba1\u8868\u6309\u8282\u70b9\u67e5\u8be2, \u7edf\u8ba1\u6570\u636e\u4e3a\u7a7a\uff01");
        return result;
    }

    @Override
    public List<Map<String, Object>> getStaticsByUser(Date begin, Date end) {
        log.info("\u5171\u4eab\u65f6\u957f\u7edf\u8ba1\u8868\u6309\u4eba\u5458\u67e5\u8be2, begin\uff1a{}, end: {}", (Object)begin, (Object)end);
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        if (begin == null || end == null) {
            log.info("\u5171\u4eab\u65f6\u957f\u7edf\u8ba1\u8868\u6309\u8282\u70b9\u67e5\u8be2, \u4f20\u5165\u53c2\u6570\u6709\u7a7a\u503c\uff01");
            return result;
        }
        QFilter[] filters = new QFilter[]{new QFilter("date", ">=", (Object)begin), new QFilter("date", "<=", (Object)end)};
        DataSet taskStatics = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".query"), (String)TASK_WF_STATICS, (String)TASK_WF_STATICS_FIELDS, (QFilter[])filters, null);
        if (null != taskStatics) {
            DataSet staticsData = taskStatics.groupBy(STATICS_USER_GROUPBY).sum("timesum", "SUMDURATION").sum("count", "INSTANCECOUNT").max("timemax", "MAXDURATION").finish();
            result = new LinkedList();
            for (Row row : staticsData) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("PROCDEFID", row.getLong("PROCDEFID"));
                data.put("NODEID", row.getString("PROCDEFKEY"));
                data.put("NODENAME", row.getString("NODENAME"));
                data.put("USERID", row.getLong("USERID"));
                data.put("INSTANCECOUNT", row.getInteger("INSTANCECOUNT"));
                BigDecimal sum = row.getBigDecimal("SUMDURATION").multiply(new BigDecimal(3600)).multiply(new BigDecimal(1000));
                BigDecimal max = row.getBigDecimal("MAXDURATION").multiply(new BigDecimal(3600)).multiply(new BigDecimal(1000));
                data.put("SUMDURATION", sum.longValueExact());
                data.put("MAXDURATION", max.longValueExact());
                result.add(data);
            }
            log.info("\u5171\u4eab\u65f6\u957f\u7edf\u8ba1\u8868\u6309\u4eba\u5458\u67e5\u8be2, \u7edf\u8ba1\u7ed3\u679c\uff1a{}", result);
            return result;
        }
        log.info("\u5171\u4eab\u65f6\u957f\u7edf\u8ba1\u8868\u6309\u4eba\u5458\u67e5\u8be2, \u7edf\u8ba1\u6570\u636e\u4e3a\u7a7a\uff01");
        return result;
    }

    private void clearTaskStatics(DateRange dateRange) {
        QFilter[] filters = new QFilter[]{new QFilter("date", ">=", (Object)dateRange.getStartDate()), new QFilter("date", "<=", (Object)dateRange.getEndDate())};
        DeleteServiceHelper.delete((String)TASK_WF_STATICS, (QFilter[])filters);
    }

    private void saveTaskStatics(DataSet taskStatics, DateRange dateRange) {
        LinkedList<DynamicObject> staticsList = new LinkedList<DynamicObject>();
        for (Row row : taskStatics) {
            DynamicObject staticsEntity = BusinessDataServiceHelper.newDynamicObject((String)TASK_WF_STATICS);
            staticsEntity.set("processdefinitionid", (Object)row.getLong("processdefinitionid"));
            staticsEntity.set("taskdefinitionkey", (Object)row.getString("taskdefinitionkey"));
            staticsEntity.set("tasktypeid", (Object)row.getLong("tasktypeid"));
            staticsEntity.set("date", (Object)dateRange.getStartDate());
            staticsEntity.set("count", (Object)row.getInteger("count"));
            staticsEntity.set("timesum", (Object)row.getDouble("timesum"));
            staticsEntity.set("timemax", (Object)row.getDouble("timemax"));
            staticsEntity.set("billtype", (Object)row.getLong("billtype"));
            staticsEntity.set("orgid", (Object)row.getLong("orgid"));
            staticsEntity.set("sscid", (Object)row.getLong("sscid"));
            staticsEntity.set("personid", (Object)row.getLong("personid"));
            staticsList.add(staticsEntity);
        }
        SaveServiceHelper.save((DynamicObject[])staticsList.toArray(new DynamicObject[0]));
    }

    private boolean existTaskStatics(DateRange dateRange) {
        QFilter[] filters = new QFilter[]{new QFilter("date", ">=", (Object)dateRange.getStartDate()), new QFilter("date", "<=", (Object)dateRange.getEndDate())};
        DataSet taskStatics = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".query"), (String)TASK_WF_STATICS, (String)"id", (QFilter[])filters, null);
        return !taskStatics.isEmpty();
    }

    private DateRange getDate(Map<String, Date> params) {
        DateRange dateRange = new DateRange();
        try {
            Date date = new Date();
            if (null != params && null != params.get("date")) {
                date = params.get("date");
            }
            dateRange.setStartDate(DateUtil.getCurDateForm((Date)date, (boolean)true));
            dateRange.setEndDate(DateUtil.getCurDateForm((Date)date, (boolean)false));
        }
        catch (Exception e) {
            log.error("\u65f6\u957f\u7edf\u8ba1\u83b7\u53d6\u65f6\u95f4\u8303\u56f4\u5f02\u5e38e: ", (Throwable)e);
        }
        return dateRange;
    }
}

