/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.workcalendar;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.task.common.TaskFilterEnum;
import kd.ssc.task.common.TaskPropertyEnum;
import kd.ssc.task.common.workcalendar.CalRemainingTime;

public class RemainingTimeTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(RemainingTimeTask.class);

    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        String algoKey = RemainingTimeTask.class + ".execute()";
        String entityName = "task_task";
        String selectFields = "id";
        String orderBy = "receivetime desc";
        QFilter processFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
        QFilter notQuaCheckTaskFil = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        QFilter quaCheckTaskFil = new QFilter("tasktypeid.qualityjudge", "=", (Object)TaskPropertyEnum.QUACHECKTASK.getValue());
        DataSet notQuaCheckTaskIDs = QueryServiceHelper.queryDataSet((String)(algoKey + "_1"), (String)entityName, (String)selectFields, (QFilter[])new QFilter[]{processFilter, notQuaCheckTaskFil}, (String)orderBy);
        DataSet quaCheckTaskIDs = QueryServiceHelper.queryDataSet((String)(algoKey + "_2"), (String)entityName, (String)selectFields, (QFilter[])new QFilter[]{processFilter, quaCheckTaskFil}, (String)orderBy);
        CalRemainingTime cal = new CalRemainingTime();
        ArrayList<Long> idList = new ArrayList<Long>();
        log.info("\u5f00\u59cb\u8ba1\u7b97\u975e\u8d28\u68c0\u4efb\u52a1\u5269\u4f59\u65f6\u95f4\uff0ctime: " + new Date());
        long begin = System.currentTimeMillis();
        for (Row row : notQuaCheckTaskIDs) {
            idList.add(row.getLong("id"));
            if (idList.size() % 1000 != 0) continue;
            cal.calRemainingTime(idList, "1");
            idList.clear();
        }
        if (idList.size() > 0) {
            cal.calRemainingTime(idList, "1");
        }
        long end = System.currentTimeMillis();
        log.info("\u8ba1\u7b97\u975e\u8d28\u68c0\u4efb\u52a1\u5269\u4f59\u65f6\u95f4\u7ed3\u675f\uff0c\u8ba1\u7b97\u8fc7\u7a0b\u8017\u65f6\uff1a" + (end - begin));
        idList.clear();
        log.info("\u5f00\u59cb\u8ba1\u7b97\u8d28\u68c0\u4efb\u52a1\u5269\u4f59\u65f6\u95f4\uff0ctime: " + new Date());
        begin = System.currentTimeMillis();
        for (Row row : quaCheckTaskIDs) {
            idList.add(row.getLong("id"));
            if (idList.size() % 1000 != 0) continue;
            cal.calRemainTimeOfQuaCheckTask(idList);
            idList.clear();
        }
        if (idList.size() > 0) {
            cal.calRemainTimeOfQuaCheckTask(idList);
        }
        end = System.currentTimeMillis();
        log.info("\u8ba1\u7b97\u8d28\u68c0\u4efb\u52a1\u5269\u4f59\u65f6\u95f4\u7ed3\u675f\uff0c\u8ba1\u7b97\u8fc7\u7a0b\u8017\u65f6\uff1a" + (end - begin));
    }
}

