/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.servicehelper;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;

public class ServiceFactory {
    private static Map<String, String> SERVICE_MAP = new HashMap<String, String>(){
        {
            this.put("AdjFilePersonUpgradeService", "kd.swc.hcdm.mservice.update.AdjFilePersonUpgradeService");
            this.put("ICandidateSalaryService", "kd.swc.hcdm.mservice.CandidateSalaryServiceImpl");
            this.put("IHCDMCandidateService", "kd.swc.hcdm.mservice.HCDMCandidateService");
            this.put("IAdjFileApplicationService", "kd.swc.hcdm.mservice.AdjFileApplicationServiceImpl");
            this.put("ReportDisplayUpdateService", "kd.swc.hcdm.mservice.update.report.ReportDisplayUpdateService");
            this.put("ReportSchemeUpdateService", "kd.swc.hcdm.mservice.update.report.ReportSchemeUpdateService");
            this.put("IHCDMStopEntryService", "kd.swc.hcdm.mservice.HCDMStopEntryServiceImpl");
            this.put("IHCDMConfirmEntryService", "kd.swc.hcdm.mservice.HCDMConfirmEntryServiceImpl");
            this.put("IAdjConfirmTplQueryService", "kd.swc.hcdm.mservice.AdjConfirmTplQueryServiceImpl");
            this.put("IAdjConfirmBillService", "kd.swc.hcdm.mservice.AdjConfirmBillServiceImpl");
            this.put("IAdjApprovalApplicationService", "kd.swc.hcdm.mservice.AdjApprovalApplicationServiceImpl");
            this.put("IAdjFileInfoService", "kd.swc.hcdm.mservice.AdjFileInfoServiceImpl");
            this.put("HCDMHisSynDataStatusService", "kd.swc.hcdm.mservice.hismodel.HCDMHisSynDataStatusService");
            this.put("AdjSalSynCreateUseRegUpdateService", "kd.swc.hcdm.mservice.update.adjsalsyn.AdjSalSynCreateUseRegUpdateService");
            this.put("IHCDMPersonService", "kd.swc.hcdm.mservice.person.HCDMPersonService");
            this.put("CandidateSalaryOfferIdUpdateService", "kd.swc.hcdm.mservice.update.candidate.CandidateSalaryOfferIdUpdateService");
            this.put("IHCDMCloudCollaService", "kd.swc.hcdm.mservice.cloudcolla.HCDMCloudCollaServiceImpl");
            this.put("IAdjSalSynService", "kd.swc.hcdm.mservice.AdjSalSynServiceImpl");
            this.put("IAdjSalaryService", "kd.swc.hcdm.mservice.AdjSalaryServiceImpl");
        }
    };

    public static <T> T getService(Class<T> clazz) {
        return (T)ServiceFactory.getService(clazz.getSimpleName());
    }

    public static Object getService(String serviceName) {
        String className = SERVICE_MAP.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(Locale.ROOT, "%s service not find", serviceName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }
}

