/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.activity;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.swc.hcdm.business.activity.ActivityBaseDynHelper;
import kd.swc.hcdm.business.candidatesetsalaryappl.CandidateSetSalApplyHelper;
import kd.swc.hcdm.business.candidatesetsalaryappl.syncfile.CandSetSalApplySyncFileTask;
import kd.swc.hcdm.business.salaryadjfile.AdjFileCertCommonHelper;
import kd.swc.hcdm.common.enums.HCDMErrInfoEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CandSetSalActLIstPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(CandSetSalApplySyncFileTask.class);
    private static final String CALLBACK_STOPCANDSETSALACT = "call_stopcandsetsalact";
    private static final String CONFIRM_STOPCANDSETSALACT = "confirm_stopcandsetsalact";

    public void setFilter(SetFilterEvent event) {
        event.addCustomQFilter(new QFilter("activitybase", "in", (Object)ActivityBaseDynHelper.queryIdByCurrUser()));
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new CandSetSalApplyProviderImpl());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "createappl": {
                if (!AdjFileCertCommonHelper.verifyCertCount((IFormView)this.getView())) {
                    args.setCancel(true);
                }
                if (this.validatePerm()) break;
                args.setCancel(true);
                break;
            }
            case "deleteappl": {
                List pkIds = Arrays.stream(formOperate.getListSelectedData().getPrimaryKeyValues()).map(String::valueOf).map(Long::valueOf).collect(Collectors.toList());
                if (formOperate.getOption().tryGetVariableValue(operateKey, new RefObject())) {
                    return;
                }
                if (pkIds.size() > 0) {
                    this.getView().showConfirm(HCDMErrInfoEnum.COMMON_LIST_DELETE_ENTITY_CONFIRM.getMsg(new Object[]{pkIds.size(), HCDMErrInfoEnum.COMMON_CAND_ADJ_APPR_BILL.getMsg()}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(operateKey));
                }
                args.setCancel(true);
                break;
            }
            case "stopcandsetsalact": {
                String confirmResult = formOperate.getOption().getVariableValue(CONFIRM_STOPCANDSETSALACT, "0");
                if (!StringUtils.equals((CharSequence)confirmResult, (CharSequence)"0")) break;
                args.setCancel(true);
                String msg = ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u4f1a\u7ed3\u675f\u5b9a\u85aa\u534f\u4f5c\uff0c\u7ed3\u675f\u540e\u5c06\u4e0d\u53ef\u518d\u521b\u5efa\u7533\u8bf7\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CandSetSalActLIstPlugin_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(MessageFormat.format(msg, 1), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_STOPCANDSETSALACT));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult result = args.getOperationResult();
        boolean existsSuccsss = result != null && result.getSuccessPkIds() != null && result.getSuccessPkIds().size() > 0;
        switch (operateKey) {
            case "stopcandsetsalact": {
                if (existsSuccsss) {
                    this.getView().invokeOperation("refresh");
                }
                if (result == null || !result.isSuccess()) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u6210\u529f\u3002", (String)"CandSetSalActLIstPlugin_5", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "createappl": {
                this.showOpResult(args);
                break;
            }
            case "deleteappl": {
                if (existsSuccsss) {
                    this.getView().invokeOperation("refresh");
                }
                if (result == null || !result.isSuccess()) break;
                this.getView().showSuccessNotification(HCDMErrInfoEnum.COMMON_DELETE_SUCCESSFULLY.getMsg());
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        switch (callBackId) {
            case "deleteappl": {
                if (MessageBoxResult.Yes != result) break;
                if (SWCPermissionServiceHelper.checkCancelDataAndFunctionRight((IFormView)this.getView(), (boolean)true)) {
                    return;
                }
                OperateOption option = OperateOption.create();
                option.setVariableValue(callBackId, Boolean.TRUE.toString());
                this.getView().invokeOperation(callBackId, option);
                break;
            }
            case "call_stopcandsetsalact": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(CONFIRM_STOPCANDSETSALACT, "1");
                this.getView().invokeOperation("stopcandsetsalact", operateOption);
                break;
            }
        }
    }

    private void showOpResult(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        operationResult.setShowMessage(false);
        int total = operationResult.getBillCount();
        int success = operationResult.getSuccessPkIds().size();
        if (total == success) {
            if (total == 1) {
                this.showCandidateSetSalAppl(operationResult);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u521b\u5efa\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u5355\u6210\u529f\u3002", (String)"CandSetSalActLIstPlugin_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
            return;
        }
        List operateInfoList = operationResult.getAllErrorOrValidateInfo();
        ArrayList<String> errorMsgList = new ArrayList<String>(operateInfoList.size());
        for (IOperateInfo iOperateInfo : operateInfoList) {
            String message = iOperateInfo.getMessage();
            message = message.replace(ResManager.loadKDString((String)"\u4fdd\u5b58\u6821\u9a8c\u5931\u8d25", (String)"CandSetSalActLIstPlugin_4", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), "");
            message = message.replace("\uff1a\r\n", "");
            message = message.replace("  \r\n\u3002", "");
            errorMsgList.add(message);
        }
        if (total == 1 && errorMsgList.size() == 1) {
            this.getView().showErrorNotification((String)errorMsgList.get(0));
            return;
        }
        int fail = total - success;
        String message = ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u6761\u8bb0\u5f55\uff0c{1}\u6761\u6210\u529f\uff0c{2}\u6761\u5931\u8d25\u3002", (String)"CandSetSalActLIstPlugin_1", (String)"swc-hcdm-formplugin", (Object[])new Object[]{total, success, fail});
        FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)ResManager.loadKDString((String)"\u521b\u5efa\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u5355", (String)"CandSetSalActLIstPlugin_2", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), (String)message, errorMsgList);
        this.getView().showForm(parameters);
        if (success > 0) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (SWCStringUtils.isEmpty((String)fieldName)) {
            return;
        }
        if (StringUtils.equals((CharSequence)"candsetsalapplnum", (CharSequence)fieldName)) {
            try {
                this.openCandSetSalApply();
            }
            catch (Exception exception) {
                log.error("CandSetSalActLIstPlugin.billListHyperLinkClick error:", (Throwable)exception);
            }
        }
    }

    private void openCandSetSalApply() {
        boolean hasViewPermssion;
        IListView listView = (IListView)this.getView();
        Long pkId = Long.valueOf(String.valueOf(listView.getFocusRowPkId()));
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_candsetsalact");
        DynamicObject candSetSalActDy = helper.loadSingle((Object)pkId);
        long candSetSalApplId = candSetSalActDy.getLong("candsetsalapplid");
        helper.setEntityName("hcdm_singlecandsetsalappl");
        DynamicObject candSetSalApplDy = helper.loadSingle((Object)candSetSalApplId);
        if (HRObjectUtils.isEmpty((Object)candSetSalApplDy)) {
            this.getView().showTipNotification(HCDMErrInfoEnum.CANDIDATE_SET_SALARY_APPL_BILL_NO_NOT_EXISTS.getMsg());
        }
        if (!(hasViewPermssion = SWCPermissionServiceHelper.hasPerm((String)"0VO5EV13=I9W", (String)"hcdm_singlecandsetsalappl", (String)"47150e89000000ac"))) {
            String entityDescName = EntityMetadataCache.getDataEntityType((String)"hcdm_singlecandsetsalappl").getDisplayName().getLocaleValue();
            listView.showErrorNotification(HCDMErrInfoEnum.COMMON_WITHOUT_VIEW_PERMISSION.getMsg(new Object[]{entityDescName}));
            return;
        }
        long orgId = candSetSalApplDy.getLong("org.id");
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"0VO5EV13=I9W", (String)"hcdm_singlecandsetsalappl", (String)"47150e89000000ac");
        if (!permOrgs.hasAllOrgPerm()) {
            HashSet hasPermOrgs = Sets.newHashSet((Iterable)permOrgs.getHasPermOrgs());
            if (CollectionUtils.isEmpty((Collection)hasPermOrgs) || orgId == 0L || !hasPermOrgs.contains(orgId)) {
                String entityDescName = EntityMetadataCache.getDataEntityType((String)"hcdm_singlecandsetsalappl").getDisplayName().getLocaleValue();
                String message = ResManager.loadKDString((String)"\u6ca1\u6709\u201c%s\u201d\u9875\u9762\u201c\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u201d\u6570\u636e\u8303\u56f4\u6743\u9650\u3002", (String)"CandSetSalActLIstPlugin_6", (String)"swc-hcdm-formplugin", (Object[])new Object[]{entityDescName});
                this.getView().showErrorNotification(message);
                return;
            }
            DynamicObjectCollection personEntry = candSetSalApplDy.getDynamicObjectCollection("candsetsalperson");
            Set depIds = personEntry.stream().map(obj -> obj.getLong("department.id")).collect(Collectors.toSet());
            Set departmentPermIds = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((Long)RequestContext.get().getCurrUserId(), (String)"0VO5EV13=I9W", (String)"hcdm_singlecandsetsalappl", (String)"47150e89000000ac", (String)"department");
            if (departmentPermIds != null && (departmentPermIds.size() == 0 || CollectionUtils.isEmpty(depIds) || !departmentPermIds.containsAll(depIds))) {
                String entityDescName = EntityMetadataCache.getDataEntityType((String)"hcdm_singlecandsetsalappl").getDisplayName().getLocaleValue();
                String message = ResManager.loadKDString((String)"\u6ca1\u6709\u201c%s\u201d\u9875\u9762\u201c\u884c\u653f\u7ec4\u7ec7\u201d\u6570\u636e\u8303\u56f4\u6743\u9650\u3002", (String)"CandSetSalActLIstPlugin_7", (String)"swc-hcdm-formplugin", (Object[])new Object[]{entityDescName});
                this.getView().showErrorNotification(message);
                return;
            }
        }
        String candidateName = this.getSelectInfo(candSetSalActDy, "candidate.name");
        String caption = EntityMetadataCache.getDataEntityType((String)"hcdm_singlecandsetsalappl").getDisplayName().getLocaleValue() + "-" + candidateName;
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setPkId((Object)candSetSalApplId);
        baseShowParameter.setCaption(caption);
        String appId = this.getView().getFormShowParameter().getCheckRightAppId();
        baseShowParameter.setPageId(RequestContext.getOrCreate().getGlobalSessionId() + appId + "hcdm_singlecandsetsalappl" + candSetSalApplId);
        baseShowParameter.setFormId("hcdm_singlecandsetsalappl");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(OperationStatus.EDIT);
        baseShowParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void showCandidateSetSalAppl(OperationResult operationResult) {
        DynamicObject candidateSetSalAppl;
        Long actId;
        Map actIdToCandidateSetSalApplMap;
        Object pkId;
        List successPkIds = operationResult.getSuccessPkIds();
        if (!CollectionUtils.isEmpty((Collection)successPkIds) && (pkId = successPkIds.get(0)) instanceof Long && !CollectionUtils.isEmpty((Map)(actIdToCandidateSetSalApplMap = CandidateSetSalApplyHelper.getActIdToCandidateSetSalApplMapByActId((Set)Sets.newHashSet((Object[])new Long[]{actId = Long.valueOf(String.valueOf(pkId))})))) && Objects.nonNull(candidateSetSalAppl = (DynamicObject)actIdToCandidateSetSalApplMap.get(actId))) {
            long id = candidateSetSalAppl.getLong("id");
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId("hcdm_singlecandsetsalappl");
            billShowParameter.setPkId((Object)id);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.ADDNEW);
            billShowParameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    private String getSelectInfo(DynamicObject candSetSalActDy, String selectKey) {
        IListView listView = (IListView)this.getView();
        ListSelectedRow currentSelectedRowInfo = listView.getCurrentSelectedRowInfo();
        DynamicObjectCollection entryEntity = candSetSalActDy.getDynamicObjectCollection("entryentity");
        String value = null;
        for (DynamicObject entry : entryEntity) {
            if (!entry.getPkValue().equals(currentSelectedRowInfo.getEntryPrimaryKeyValue())) continue;
            value = entry.getString(selectKey);
        }
        return value;
    }

    private boolean validatePerm() {
        boolean hasNewPermssion = SWCPermissionServiceHelper.hasPerm((String)"0VO5EV13=I9W", (String)"hcdm_singlecandsetsalappl", (String)"47156aff000000ac");
        if (!hasNewPermssion) {
            String entityDescName = EntityMetadataCache.getDataEntityType((String)"hcdm_singlecandsetsalappl").getDisplayName().getLocaleValue();
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CandSetSalActLIstPlugin_8", (String)"swc-hcdm-formplugin", (Object[])new Object[]{entityDescName}));
            return false;
        }
        return true;
    }

    public static class CandSetSalApplyProviderImpl
    extends ListDataProvider {
        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection actDyns = super.getData(start, limit);
            if (CollectionUtils.isEmpty((Collection)actDyns)) {
                return actDyns;
            }
            this.addProps(actDyns.getDynamicObjectType());
            Set candSedSalApplyNums = actDyns.stream().filter(obj -> !StringUtils.isEmpty((CharSequence)obj.getString("candsetsalapplnum"))).map(obj -> obj.getString("candsetsalapplnum")).collect(Collectors.toSet());
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_singlecandsetsalappl");
            DynamicObject[] applyDyns = serviceHelper.query("id,billno,billstatus", new QFilter[]{new QFilter("billno", "in", candSedSalApplyNums)});
            if (applyDyns == null || applyDyns.length == 0) {
                return actDyns;
            }
            HashMap applyIdMap = Maps.newHashMapWithExpectedSize((int)applyDyns.length);
            for (DynamicObject applyDyn : applyDyns) {
                applyIdMap.put(applyDyn.getString("billno"), applyDyn);
            }
            for (DynamicObject actDyn : actDyns) {
                DynamicObject applyDyn;
                String applyNum = actDyn.getString("candsetsalapplnum");
                if (StringUtils.isEmpty((CharSequence)applyNum)) continue;
                applyDyn = (DynamicObject)applyIdMap.get(applyNum);
                if (applyDyn == null) {
                    log.info("CandSetSalActLIstPlugin CandSetSalApplyProviderImpl applyDyn is null applyNum=" + applyNum);
                    continue;
                }
                actDyn.set("candsetsalapplstatus", applyDyn.get("billstatus"));
            }
            return actDyns;
        }

        private void addProps(DynamicObjectType mainType) {
            BillStatusProp prop = new BillStatusProp();
            prop.setName("candsetsalapplstatus");
            mainType.addProperty((DynamicProperty)prop);
        }
    }
}

