/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjapprbill;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.swc.hcdm.business.adjapplication.service.AdjApprovalApplicationService;
import kd.swc.hcdm.business.salaryadjfile.AdjFileCertCommonHelper;
import kd.swc.hcdm.common.utils.GlobalParam;
import kd.swc.hcdm.formplugin.HCDMBaseFixedFieldListPlugin;
import kd.swc.hcdm.formplugin.adjapprbill.AdjApprovalFormUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AdjApprovalBillList
extends HCDMBaseFixedFieldListPlugin {
    private static Log logger = LogFactory.getLog(AdjApprovalBillList.class);
    private AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);
    private static final String CONFIRMSTATISTIC_CACHE_KEY = "confirmStatisticCache";

    @Override
    protected List<String> getFixFieldList() {
        ArrayList<String> fixFieldList = new ArrayList<String>();
        fixFieldList.add("billno");
        fixFieldList.add("billname");
        return fixFieldList;
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        DynamicObjectCollection rows = event.getPageData();
        List billIds = rows.stream().map(object -> object.getLong("id")).collect(Collectors.toList());
        Map confirmStatisticMap = this.adjApprovalApplicationService.countAdjConfirmStatistic(billIds, null);
        GlobalParam.set((String)CONFIRMSTATISTIC_CACHE_KEY, (Object)confirmStatisticMap);
    }

    public void packageData(PackageDataEvent evt) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
        Long billId = evt.getRowData().getLong("id");
        Map confirmStatisticMap = (Map)GlobalParam.get((String)CONFIRMSTATISTIC_CACHE_KEY);
        if (confirmStatisticMap == null) {
            return;
        }
        Map<String, Integer> confirmStatistic = confirmStatisticMap.getOrDefault(billId, Collections.singletonMap("", 0));
        switch (columnDesc.getKey()) {
            case "hassent": {
                evt.setFormatValue((Object)confirmStatistic.getOrDefault("hassent", 0));
                break;
            }
            case "notsent": {
                evt.setFormatValue((Object)confirmStatistic.getOrDefault("notsent", 0));
                break;
            }
            case "offlineconfirmed": {
                evt.setFormatValue((Object)confirmStatistic.getOrDefault("offlineconfirmed", 0));
                break;
            }
            case "confirmed": {
                evt.setFormatValue((Object)confirmStatistic.getOrDefault("confirmed", 0));
                break;
            }
            case "refused": {
                evt.setFormatValue((Object)confirmStatistic.getOrDefault("refused", 0));
                break;
            }
            case "unconfirmed": {
                evt.setFormatValue((Object)confirmStatistic.getOrDefault("unconfirmed", 0));
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if (fieldName.equals("billno")) {
            args.setCancel(true);
            Object primaryKeyValue = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
            SWCDataServiceHelper billHelper = new SWCDataServiceHelper("hcdm_adjapprbill");
            DynamicObject adjApprBill = billHelper.queryOne(primaryKeyValue);
            if (adjApprBill == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5237\u65b0\u5f53\u524d\u5217\u8868\u6570\u636e\uff01", (String)"AdjApprovalBillList_01", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                return;
            }
            BillShowParameter billShowParameter = AdjApprovalFormUtils.createApprovalForm(this.getView(), primaryKeyValue);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "submit": {
                this.afterSubmitRefreshPage(args, source);
                break;
            }
            case "unsubmit": 
            case "donothing_submiteffect": {
                if (!args.getOperationResult().isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void afterSubmitRefreshPage(AfterDoOperationEventArgs args, FormOperate source) {
        if (args.getOperationResult().isSuccess()) {
            ListSelectedRowCollection listSelectedData = source.getListSelectedData();
            List selectedRowIdList = listSelectedData.stream().map(listSelectedRow -> (Long)listSelectedRow.getPrimaryKeyValue()).collect(Collectors.toList());
            int retryTimes = 1;
            try {
                do {
                    ArrayList allApprovalRecordList = new ArrayList(selectedRowIdList.size());
                    List approvalRecordList = null;
                    for (Long pkId : selectedRowIdList) {
                        approvalRecordList = WorkflowServiceHelper.getAllApprovalRecord((String)pkId.toString());
                        allApprovalRecordList.addAll(approvalRecordList);
                    }
                    if (CollectionUtils.isNotEmpty(allApprovalRecordList)) {
                        this.getView().invokeOperation("refresh");
                        logger.info("retryTimes is {} , page refresh", (Object)retryTimes);
                        break;
                    }
                    Thread.sleep(300 * ++retryTimes);
                    logger.info("retryTimes is {}", (Object)retryTimes);
                } while (retryTimes <= 5);
            }
            catch (Exception e) {
                logger.error("retryTimes is {} error message is {}", (Object)retryTimes, (Object)e.getMessage());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        source.getOption().setVariableValue("listpageflag", "true");
        switch (operateKey) {
            case "new": {
                args.setCancel(true);
                if (!AdjFileCertCommonHelper.verifyCertCount((IFormView)this.getView())) {
                    return;
                }
                String errorMessage = this.checkCodeRule();
                if (StringUtils.isNotEmpty((CharSequence)errorMessage)) {
                    this.getView().showErrorNotification(errorMessage);
                    return;
                }
                BillShowParameter billShowParameter = new BillShowParameter();
                billShowParameter.setStatus(OperationStatus.ADDNEW);
                billShowParameter.setFormId("hcdm_adjapprbill");
                billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                billShowParameter.setParentPageId(this.getView().getPageId());
                billShowParameter.setCustomParam("attributiontype", (Object)AdjAttributionType.DECATTRTYPE.getCode());
                long orgId = RequestContext.get().getOrgId();
                DynamicObject adjFieldCfgWithPerm = this.adjApprovalApplicationService.getFirstAdjFieldCfgWithPerm(Long.valueOf(orgId), AdjAttributionType.DECATTRTYPE.getCode());
                billShowParameter.setCustomParam("adjfieldcfgid", (Object)adjFieldCfgWithPerm.getLong("id"));
                this.getView().showForm((FormShowParameter)billShowParameter);
                break;
            }
            case "submit": 
            case "donothing_submiteffect": {
                if (AdjFileCertCommonHelper.verifyCertCount((IFormView)this.getView())) break;
                args.setCancel(true);
                break;
            }
        }
    }

    private String checkCodeRule() {
        String errorMessage = null;
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjapprbill");
        DynamicObject adjApprBillDyObj = serviceHelper.generateEmptyDynamicObject();
        try {
            CodeRuleServiceHelper.readNumber((String)"hcdm_adjapprbill", (DynamicObject)adjApprBillDyObj, null);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            errorMessage = e.getMessage();
        }
        return errorMessage;
    }
}

