/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjapprbill;

import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class AdjApprovalFormUtils {
    public static final String BILL_ENTRY = "adjapprdetailent";

    private static BillShowParameter newBillShowParameter(String parentPageId, String entityName, Object pk) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId(entityName);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setParentPageId(parentPageId);
        billShowParameter.setPkId(pk);
        return billShowParameter;
    }

    public static FormShowParameter createApprovalFormX(IFormView parentView, DynamicObject billObj) {
        String billTypeName = billObj.getDataEntityType().getName();
        if ("hcdm_adjapprbill".equals(billTypeName)) {
            return AdjApprovalFormUtils.createApprovalForm(parentView, billObj.getLong("id"));
        }
        return AdjApprovalFormUtils.newBillShowParameter(parentView.getPageId(), billTypeName, billObj.getLong("id"));
    }

    public static BillShowParameter createApprovalForm(IFormView parentView, Object primaryKeyValue) {
        String parentPageId = parentView.getPageId();
        BillShowParameter billShowParameter = AdjApprovalFormUtils.newBillShowParameter(parentPageId, "hcdm_adjapprbill", primaryKeyValue);
        SWCDataServiceHelper billHelper = new SWCDataServiceHelper("hcdm_adjapprbill");
        DynamicObject adjApprBill = billHelper.queryOne(primaryKeyValue);
        billShowParameter.setPageId(parentPageId + primaryKeyValue);
        String attributionType = adjApprBill.getString("salaryadjrsn.attributiontype");
        if (StringUtils.isEmpty((CharSequence)attributionType)) {
            attributionType = AdjAttributionType.DECATTRTYPE.getCode();
        }
        billShowParameter.setCustomParam("attributiontype", (Object)attributionType);
        billShowParameter.setCustomParam("adjfieldcfgid", (Object)adjApprBill.getLong("adjfieldcfg.id"));
        String billStatus = adjApprBill.getString("billstatus");
        if (billStatus.equals("A") || billStatus.equals("G")) {
            billShowParameter.setStatus(OperationStatus.ADDNEW);
            billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
        } else if (billStatus.equals("C") || billStatus.equals("E")) {
            billShowParameter.setStatus(OperationStatus.VIEW);
            billShowParameter.setBillStatus(BillOperationStatus.AUDIT);
        } else if (billStatus.equals("B") || billStatus.equals("D")) {
            billShowParameter.setStatus(OperationStatus.EDIT);
            billShowParameter.setBillStatus(BillOperationStatus.SUBMIT);
        }
        return billShowParameter;
    }
}

