/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjapprbill;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hcdm.business.adjapprbill.AdjApprovalLittleKHelper;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprGridHelper;

public class AdjApproveLittleKCardPlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(AdjApproveLittleKCardPlugin.class);
    private static final String KEY_TITLE = "title";
    private static final String KEY_POSITIONTYPE = "positiontype";
    private static final String KEY_CONTENT = "content";

    public void beforeBindData(EventObject eventObject) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String title = (String)formShowParameter.getCustomParam(KEY_TITLE);
        String content = (String)formShowParameter.getCustomParam(KEY_CONTENT);
        String approveBillPageId = (String)this.getView().getFormShowParameter().getCustomParam("approveBillPageId");
        IFormView billView = null;
        billView = StringUtils.isNotEmpty((CharSequence)approveBillPageId) ? this.getView().getParentView().getView(approveBillPageId) : this.getView().getParentView();
        if (billView == null) {
            log.error("approveBillPage is null, can not open little K.");
            return;
        }
        IFormView gridView = null;
        String nineGridChartPageId = (String)formShowParameter.getCustomParam("nineGridChartPageId");
        if (StringUtils.isNotBlank((CharSequence)nineGridChartPageId)) {
            gridView = this.getView().getView(nineGridChartPageId);
        }
        Label label = (Label)this.getView().getControl(KEY_TITLE);
        label.setText(title);
        List paramNames = AdjApprovalLittleKHelper.collectLittleKTplParamNames((String)content);
        Map paramValues = AdjApprovalLittleKHelper.queryLittleKTplParamValue((IFormView)billView, (IFormView)gridView, new HashSet(paramNames));
        Map amountResultMap = DecAdjApprGridHelper.getAmountResultList((IDataModel)billView.getModel());
        List amountResultList = DecAdjApprGridHelper.getFormatAmountResult((Map)amountResultMap, (IDataModel)billView.getModel());
        Collections.sort(amountResultList);
        String totalAmount = StringUtils.join((Object[])amountResultList.toArray(), (String)"+");
        content = AdjApprovalLittleKHelper.generateLittleKCardText((String)totalAmount, (String)content, (Map)paramValues);
        RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl("htmlap");
        richTextEditor.setText(content);
    }
}

