/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjapprbill;

import java.text.MessageFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.hr.hbp.business.bgtask.TaskResult;
import kd.swc.hcdm.common.entity.adjapprbill.AdjBillProgressBean;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import org.apache.commons.lang3.ObjectUtils;

public class DecAdjAddPersonProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log log = LogFactory.getLog(DecAdjAddPersonProgressPlugin.class);
    private static final String KEY_PROGRESSBARAP = "saveprogressbarap";
    private static final String KEY_LABEL_PROGRESS = "saveprocess";
    private static final String KEY_TOTAL_LABEL = "personcount";
    private static final String KEY_DATA_LABEL = "datacount";
    private static final String WAIT = "wait";
    private static final String SUCCESS = "success";
    private static final String FAIL = "fail";
    private static final String MINIMIZE = "minimize";
    private static final String BTN_OK = "btn_ok";
    private static final String KEY_ADDING = "oncalap";
    private static final String KEY_FINISHED = "aftercalap";
    private static final String KEY_TIME_LABEL = "consumetimelabe";

    public void initialize() {
        super.initialize();
        ProgressBar progress = (ProgressBar)this.getControl(KEY_PROGRESSBARAP);
        progress.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_OK, KEY_FINISHED});
    }

    public void onProgress(ProgressEvent evt) {
        Control control = (Control)evt.getSource();
        String progressKey = control.getKey();
        if (StringUtils.equals((CharSequence)progressKey, (CharSequence)KEY_PROGRESSBARAP)) {
            this.setFormInfo(this.readBgTaskBean(), evt);
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        String beanStr = (String)this.getView().getFormShowParameter().getCustomParam("add_adj_person_bean");
        AdjBillProgressBean bean = null;
        if (StringUtils.isNotEmpty((CharSequence)beanStr)) {
            bean = (AdjBillProgressBean)SerializationUtils.fromJsonString((String)beanStr, AdjBillProgressBean.class);
        }
        if (bean == null) {
            bean = this.readBgTaskBean();
        }
        this.setFormInfo(bean, null);
    }

    public void afterBindData(EventObject e) {
        if ("true".equals(this.getView().getFormShowParameter().getCustomParam("isTaskEnd"))) {
            ProgressBar progressBar = (ProgressBar)this.getControl(KEY_PROGRESSBARAP);
            progressBar.setPercent(100);
            Label labelPercentage = (Label)this.getView().getControl(KEY_LABEL_PROGRESS);
            labelPercentage.setText("100%");
            this.stopProgress(null);
            return;
        }
        this.startTask();
    }

    private void setFormInfo(AdjBillProgressBean bean, ProgressEvent progressEvent) {
        int total = 0;
        int success = 0;
        int fail = 0;
        int wait = 0;
        int otherTotal = 0;
        Date startTime = new Date();
        Date endTime = new Date();
        int percentage = 0;
        if (bean != null) {
            total = bean.getTotal();
            fail = bean.getFail();
            success = bean.getSuccess();
            wait = bean.getWait();
            startTime = bean.getStartTime();
            endTime = bean.getEndTime();
            percentage = bean.getProgress();
            otherTotal = bean.getOtherTotal();
            if (ObjectUtils.isNotEmpty((Object)endTime)) {
                percentage = 100;
            }
            this.getView().getPageCache().put("swc_hcdm_biz_bean", SerializationUtils.toJsonString((Object)bean));
        } else {
            AdjBillProgressBean curBean;
            String beanStr = this.getView().getPageCache().get("swc_hcdm_biz_bean");
            if (StringUtils.isNotEmpty((CharSequence)beanStr) && total < (curBean = (AdjBillProgressBean)SerializationUtils.fromJsonString((String)beanStr, AdjBillProgressBean.class)).getTotal()) {
                total = curBean.getTotal();
                fail = curBean.getFail() + curBean.getWait();
                success = curBean.getSuccess();
                wait = 0;
                startTime = curBean.getStartTime();
                endTime = new Date();
                otherTotal = curBean.getOtherTotal();
                percentage = 100;
            }
        }
        log.info("total is{},fail is{},wait is{}", new Object[]{total, fail, wait});
        fail = this.setFailNum(percentage, success, fail, total);
        String msg1 = ResManager.loadKDString((String)"\u672c\u6b21\u6dfb\u52a0\u603b\u4eba\u6570\uff1a{0}\u4eba", (String)"DecAdjAddPersonProgressPlugin_1", (String)"swc-hcdm-formplugin", (Object[])new Object[]{total});
        Label labelWelfarePayer = (Label)this.getControl(KEY_TOTAL_LABEL);
        labelWelfarePayer.setText(msg1);
        String msg2 = ResManager.loadKDString((String)"\u6570\u636e\u603b\u6570\uff1a{0}\u6761", (String)"DecAdjAddPersonProgressPlugin_2", (String)"swc-hcdm-formplugin", (Object[])new Object[]{otherTotal});
        Label labelItem = (Label)this.getView().getControl(KEY_DATA_LABEL);
        labelItem.setText(msg2);
        Label labelWait = (Label)this.getView().getControl(WAIT);
        labelWait.setText(String.valueOf(wait));
        Label labelSuccess = (Label)this.getView().getControl(SUCCESS);
        labelSuccess.setText(String.valueOf(success));
        Label labelFail = (Label)this.getView().getControl(FAIL);
        labelFail.setText(String.valueOf(fail));
        Label labelTime = (Label)this.getView().getControl(KEY_TIME_LABEL);
        startTime = startTime == null ? new Date() : startTime;
        endTime = endTime == null ? new Date() : endTime;
        String consumeTime = SWCDateTimeUtils.getConsumeTime((Date)startTime, (Date)endTime);
        String msg = MessageFormat.format(ResManager.loadKDString((String)"\uff08\u8017\u65f6\uff1a{0}\uff09", (String)"DecAdjAddPersonProgressPlugin_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), consumeTime);
        labelTime.setText(msg);
        Label labelPercentage = (Label)this.getView().getControl(KEY_LABEL_PROGRESS);
        if ("true".equals(this.getView().getFormShowParameter().getCustomParam("isTaskEnd"))) {
            labelPercentage.setText("100%");
            return;
        }
        labelPercentage.setText(percentage + "%");
        if (progressEvent != null) {
            progressEvent.setProgress(percentage);
        } else {
            ProgressBar progressBar = (ProgressBar)this.getControl(KEY_PROGRESSBARAP);
            progressBar.setPercent(percentage);
        }
        if (percentage >= 100 && progressEvent != null) {
            this.stopProgress(progressEvent);
        }
    }

    private int setFailNum(int percentage, int success, int fail, int total) {
        if (percentage >= 100 && success <= 0 && fail <= 0) {
            return total;
        }
        return fail;
    }

    private void startTask() {
        ProgressBar progressBar = (ProgressBar)this.getControl(KEY_PROGRESSBARAP);
        progressBar.start();
    }

    private void stopProgress(ProgressEvent progressEvent) {
        this.getView().setVisible(Boolean.FALSE, new String[]{MINIMIZE, KEY_ADDING});
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_OK, KEY_FINISHED});
        if (progressEvent != null) {
            ProgressBar bar = (ProgressBar)progressEvent.getSource();
            bar.stop();
        }
    }

    private AdjBillProgressBean readBgTaskBean() {
        TaskResult taskResult = HRBackgroundTaskHelper.getInstance().getTaskResult(this.getTaskId());
        Map customData = new HashMap(16);
        if (taskResult != null && taskResult.getCustomData() != null) {
            customData = taskResult.getCustomData();
        }
        return (AdjBillProgressBean)customData.get("add_adj_person_bean");
    }

    private String getTaskId() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        return (String)fsp.getCustomParam("taskId");
    }
}

