/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjapprbill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.ClientActions;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.QRCode;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.sdk.swc.hcdm.common.Pair;
import kd.sdk.swc.hcdm.common.stdtab.SalaryCountAmountMatchParam;
import kd.sdk.swc.hcdm.common.stdtab.SalaryCountAmountMatchResult;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdMatchResultNew;
import kd.sdk.swc.hcdm.common.stdtab.StdAmountAndSalaryCountQueryResult;
import kd.sdk.swc.hcdm.common.stdtab.StdAmountQueryParam;
import kd.sdk.swc.hcdm.common.stdtab.StdTabNotFoundType;
import kd.swc.hcdm.business.adjapplication.service.AdjApprovalApplicationService;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.adjapprbill.BillExRateManager;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprCreateGridHelper;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprGridHelper;
import kd.swc.hcdm.business.adjapprbill.GradeAndRankNameHelper;
import kd.swc.hcdm.business.adjapprbill.entity.AdjApprPerQueryParam;
import kd.swc.hcdm.business.adjapprbill.entity.ExRateKey;
import kd.swc.hcdm.business.adjapprbill.enums.CalcType;
import kd.swc.hcdm.business.adjapprbill.enums.ExcessControlEnum;
import kd.swc.hcdm.business.adjapprbill.enums.OverStandardTypeEnum;
import kd.swc.hcdm.business.adjapprbill.enums.YesOrNoEnum;
import kd.swc.hcdm.business.calculate.SalaryStdCalculateHelper;
import kd.swc.hcdm.business.helper.DynamicObjectValueHelper;
import kd.swc.hcdm.business.matchprop.entity.MatchStdTableWithAdjFileParam;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.stdapplication.domain.stdtab.entityservice.SalaryStdTabService;
import kd.swc.hcdm.business.stdapplication.interfaces.dto.StdOverStandardQueryParam;
import kd.swc.hcdm.business.stdapplication.interfaces.dto.StdOverStandardQueryResult;
import kd.swc.hcdm.business.stdapplication.service.SalaryStdApplicationService;
import kd.swc.hcdm.common.constants.DecAdjApprConstants;
import kd.swc.hcdm.common.entity.adjapprbill.AddFileReturnData;
import kd.swc.hcdm.common.entity.adjapprbill.AmountStdRangeEntity;
import kd.swc.hcdm.common.entity.adjapprbill.GradeAndRankNameEntity;
import kd.swc.hcdm.common.enums.CalcSceneType;
import kd.swc.hcdm.formplugin.adjapprbill.DecAdjApprEntryGrid;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;

public class DecAdjApprFormUtils {
    private static final Log logger = LogFactory.getLog(DecAdjApprFormUtils.class);
    public static final List<String> ratioEnableFields = Lists.newArrayList((Object[])new String[]{DecAdjApprCreateGridHelper.buildKey((String)"suggestminrange"), DecAdjApprCreateGridHelper.buildKey((String)"suggestmaxrange"), DecAdjApprCreateGridHelper.buildKey((String)"actualrange")});
    public static final List<String> amountEnableFields = Lists.newArrayList((Object[])new String[]{DecAdjApprCreateGridHelper.buildKey((String)"suggestminamount"), DecAdjApprCreateGridHelper.buildKey((String)"suggestmaxamount"), DecAdjApprCreateGridHelper.buildKey((String)"actualamount")});
    public static final List<String> enableFields = Lists.newArrayList((Object[])new String[]{DecAdjApprCreateGridHelper.buildKey((String)"grade"), DecAdjApprCreateGridHelper.buildKey((String)"rank")});

    public static void setStdScmEntryInfo(int[] rowIndexes, IDataModel billModel) {
        ArrayList billEntryRows = Lists.newArrayListWithExpectedSize((int)rowIndexes.length);
        for (int rowIndex : rowIndexes) {
            billEntryRows.add(billModel.getEntryRowEntity("adjapprdetailentry", rowIndex));
        }
        Set adjFileIds = billEntryRows.stream().map(item -> item.getLong("dy_adjfile.id")).collect(Collectors.toSet());
        BasedataProp adjFileProp = (BasedataProp)billModel.getProperty("dy_adjfile");
        Map fileObjMap = billModel.loadReferenceDataBatch((DynamicObjectType)adjFileProp.getComplexType(), adjFileIds.toArray());
        List addFileReturnDataList = DecAdjApprGridHelper.getAddAdjFileReturnData((Map)fileObjMap);
        Map<String, AddFileReturnData> dataMap = addFileReturnDataList.stream().collect(Collectors.toMap(item -> item.getAdjFileId() + "_" + item.getSalayStructureId() + "_" + item.getStandardItemId(), item -> item));
        for (int rowIndex : rowIndexes) {
            DynamicObject billEntryRow = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            DynamicObject adjFileDy = billEntryRow.getDynamicObject("dy_adjfile");
            DynamicObject standardItemDyObj = billEntryRow.getDynamicObject("dy_standarditem");
            if (standardItemDyObj == null) continue;
            Long standardItemId = standardItemDyObj.getLong("id");
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_salarystructure", adjFileDy.getLong("salaystructure.id"), rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_stdscm", adjFileDy.getLong("stdscm.sourcevid"), rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_adjfilevid", adjFileDy.getLong("sourcevid"), rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_depemp", adjFileDy.getLong("depemp.id"), rowIndex);
            Long salaryStructureId = billEntryRow.getLong("dy_salarystructure.id");
            Long adjFileId = billEntryRow.getLong("dy_adjfile.id");
            AddFileReturnData addFileReturnData = dataMap.get(adjFileId + "_" + salaryStructureId + "_" + standardItemId);
            if (addFileReturnData == null) continue;
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_excesscontrol", addFileReturnData.getExcessControl(), rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_ismatchgraderank", addFileReturnData.getisMatchGradeRank(), rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_matchstrategy", addFileReturnData.getMatchStrategy(), rowIndex);
        }
    }

    public static Map<Long, Map<Long, SalaryStdMatchResultNew>> getMatchStdResult(int[] rowIndexes, IDataModel billModel) {
        List<MatchStdTableWithAdjFileParam> matchParams = DecAdjApprFormUtils.getMatchParams(rowIndexes, billModel);
        AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);
        Map stdMatchResult = adjApprovalApplicationService.batchMatchStdTable(matchParams);
        return stdMatchResult;
    }

    private static Map<Long, List<Long>> getFileItemMap(int[] rowIndexes, IDataModel billModel) {
        HashMap<Long, List<Long>> fileToItemMap = new HashMap<Long, List<Long>>(16);
        for (int rowIndex : rowIndexes) {
            DynamicObject rowEntity = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            long fileId = rowEntity.getLong("dy_adjfile.id");
            long itemId = rowEntity.getLong("dy_standarditem.id");
            if (fileId <= 0L) continue;
            List itemIdList = fileToItemMap.computeIfAbsent(fileId, v1 -> Lists.newArrayList());
            if (itemId <= 0L) continue;
            itemIdList.add(itemId);
        }
        return fileToItemMap;
    }

    private static List<MatchStdTableWithAdjFileParam> getMatchParams(int[] rowIndexes, IDataModel billModel) {
        ArrayList paramList = Lists.newArrayListWithExpectedSize((int)rowIndexes.length);
        long adjFieldCfgId = billModel.getDataEntity().getLong("adjfieldcfg.id");
        Map visibleContrastAdjFields = DecAdjApprGridHelper.getVisibleContrastAdjFields((Long)adjFieldCfgId);
        for (int rowIndex : rowIndexes) {
            DynamicObject rowEntity = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            Map customContrastPropValue = DecAdjApprGridHelper.getContrastPropValueFromPage((DynamicObject)rowEntity, (Map)visibleContrastAdjFields);
            MatchStdTableWithAdjFileParam param = new MatchStdTableWithAdjFileParam();
            long fileId = rowEntity.getLong("dy_adjfile.id");
            long itemId = rowEntity.getLong("dy_standarditem.id");
            if (fileId <= 0L || itemId <= 0L) continue;
            Date bsed = rowEntity.getDate("dy_salbsed");
            param.setAdjFileId(Long.valueOf(fileId));
            param.setStdItemId(Long.valueOf(itemId));
            param.setBsed(bsed);
            param.setPersonPropValue(customContrastPropValue);
            paramList.add(param);
        }
        return paramList;
    }

    public static void setStdRelationInfo(int[] rowIndexes, IDataModel billModel, Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult, boolean needCheckTableIdChanged, int[] changedRows) {
        HashSet<Long> stdTableVidSet = new HashSet<Long>(16);
        for (int rowIndex : rowIndexes) {
            DynamicObject billEntryRow = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            SalaryStdMatchResultNew salaryStdMatchResult = DecAdjApprFormUtils.getSalaryStdMatchResult(matchStdResult, billEntryRow);
            if (salaryStdMatchResult.getStdTableVid() == null) continue;
            stdTableVidSet.add(salaryStdMatchResult.getStdTableVid());
        }
        long startTime = System.currentTimeMillis();
        Map stdMap = new SalaryStdTabService().queryStdObj(stdTableVidSet);
        logger.info("setStdRelationInfo queryStdObj takes {} ", (Object)(System.currentTimeMillis() - startTime));
        for (int rowIndex : rowIndexes) {
            DynamicObject billEntryRow = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            DynamicObject adjFileDyObj = billEntryRow.getDynamicObject("dy_adjfile");
            SalaryStdMatchResultNew salaryStdMatchResult = DecAdjApprFormUtils.getSalaryStdMatchResult(matchStdResult, billEntryRow);
            boolean needSetStdRelationInfo = true;
            if (needCheckTableIdChanged) {
                boolean stdTableIsChanged;
                boolean bl = stdTableIsChanged = ArrayUtils.indexOf((int[])changedRows, (int)rowIndex) != -1;
                if (!stdTableIsChanged) {
                    needSetStdRelationInfo = false;
                }
            }
            if (!needSetStdRelationInfo) continue;
            Long stdTableVid = salaryStdMatchResult.getStdTableVid();
            DynamicObject salaryStdDynamicObject = (DynamicObject)stdMap.get(stdTableVid);
            if (salaryStdDynamicObject != null) {
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_salarystd", salaryStdDynamicObject, rowIndex);
                if (billEntryRow.getDynamicObject("dy_currency") == null) {
                    if (billModel.getValue("currency") == null) {
                        DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_currency", salaryStdDynamicObject.getDynamicObject("currency"), rowIndex);
                    } else {
                        DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_currency", billModel.getValue("currency"), rowIndex);
                    }
                }
                logger.info("setStdRelationInfo adjFileNumber = {}, stdTableVid = {} , frequency = {}", new Object[]{adjFileDyObj.getString("number"), salaryStdMatchResult.getStdTableVid(), salaryStdDynamicObject.getLong("frequency.id")});
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_frequency", salaryStdDynamicObject.getDynamicObject("frequency"), rowIndex);
            } else if (billEntryRow.getDynamicObject("dy_currency") == null) {
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_currency", billModel.getValue("currency"), rowIndex);
            }
            if (salaryStdMatchResult.getCoefficientVid() == null) continue;
            logger.info("setStdRelationInfo adjFileNumber = {}, stdTableVid = {} , coefficientVid = {}", new Object[]{adjFileDyObj.getString("number"), salaryStdMatchResult.getStdTableVid(), salaryStdMatchResult.getCoefficientVid()});
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_coefficient", salaryStdMatchResult.getCoefficientVid(), rowIndex);
        }
    }

    private static SalaryStdMatchResultNew getSalaryStdMatchResult(Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult, DynamicObject billEntryRow) {
        Long adjFileId = billEntryRow.getLong("dy_adjfile.id");
        Map<Long, SalaryStdMatchResultNew> stdMatchResultMap = matchStdResult.get(adjFileId);
        Long standardItemId = billEntryRow.getLong("dy_standarditem.id");
        return stdMatchResultMap == null || stdMatchResultMap.get(standardItemId) == null ? new SalaryStdMatchResultNew() : stdMatchResultMap.get(standardItemId);
    }

    public static int[] setStdGradeRankInfo(int[] rowIndexes, IDataModel billModel, Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult, boolean needCheckTableIdChanged) {
        ArrayList tableIdChangedRow = Lists.newArrayListWithExpectedSize((int)rowIndexes.length);
        for (int rowIndex : rowIndexes) {
            boolean stdTableIsChanged;
            DynamicObject billEntryRow = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            SalaryStdMatchResultNew salaryStdMatchResult = DecAdjApprFormUtils.getSalaryStdMatchResult(matchStdResult, billEntryRow);
            Map rangeResultMap = salaryStdMatchResult.getRangeData();
            boolean needStdGradeRankInfo = true;
            if (needCheckTableIdChanged && !(stdTableIsChanged = DecAdjApprFormUtils.checkStdTableIsChanged(salaryStdMatchResult, billEntryRow))) {
                needStdGradeRankInfo = false;
            }
            if (!needStdGradeRankInfo || MapUtils.isEmpty((Map)rangeResultMap)) continue;
            tableIdChangedRow.add(rowIndex);
            Long gradeId = salaryStdMatchResult.getGradeId();
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_grade", gradeId, rowIndex);
            Long rankId = salaryStdMatchResult.getRankId();
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_rank", rankId, rowIndex);
            String isMatchGradeRank = salaryStdMatchResult.getIsMatchGradeRank();
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_ismatchgraderank", isMatchGradeRank, rowIndex);
            String matchStrategy = salaryStdMatchResult.getMatchStrategy();
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_matchstrategy", matchStrategy, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_salargrel", JSON.toJSONString((Object)rangeResultMap), rowIndex);
        }
        return tableIdChangedRow.stream().mapToInt(o1 -> o1).toArray();
    }

    public static void setPersonMatchRangeInfo(int[] rowIndexes, IDataModel billModel, Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult) {
        for (int rowIndex : rowIndexes) {
            DynamicObject billEntryRow = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            SalaryStdMatchResultNew salaryStdMatchResult = DecAdjApprFormUtils.getSalaryStdMatchResult(matchStdResult, billEntryRow);
            Map rangeResultMap = salaryStdMatchResult.getRangeData();
            if (MapUtils.isEmpty((Map)rangeResultMap)) continue;
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_salargrel", JSON.toJSONString((Object)rangeResultMap), rowIndex);
        }
    }

    public static void setNoSetRankEntryColumnLock(int[] rowIndexes, IFormView formView, IDataModel billModel) {
        Map<Long, Map<Long, Boolean>> salaryItemUseRankFlag = DecAdjApprFormUtils.getItemUseRankFlag(rowIndexes, billModel);
        Map<Integer, Boolean> itemUseRankMap = DecAdjApprFormUtils.checkItemUseRank(rowIndexes, billModel, salaryItemUseRankFlag);
        for (int rowIndex : rowIndexes) {
            DecAdjApprFormUtils.setGradeAndRankColumnLock(formView, billModel, rowIndex, itemUseRankMap);
        }
    }

    private static void setGradeAndRankColumnLock(IFormView formView, IDataModel billModel, int rowIndex, Map<Integer, Boolean> itemUseRankMap) {
        boolean needAmountLinkGradeRankWhenAdj;
        String adjAttributionType = DecAdjApprGridHelper.getAttributionType((IDataModel)billModel);
        DynamicObject billEntryRow = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
        DynamicObject salaryStdDyObj = billEntryRow.getDynamicObject("dy_salarystd");
        CalcType calcType = CalcType.getByCode((String)((String)DynamicObjectValueHelper.dyObjGetValueIfExist((DynamicObject)billEntryRow, (String)"dy_calctype", null)));
        boolean bl = needAmountLinkGradeRankWhenAdj = AdjAttributionType.ADJATTRTYPE.getCode().equals(adjAttributionType) && (CalcType.AMOUNT == calcType || CalcType.RATIO == calcType);
        if (salaryStdDyObj == null) {
            DecAdjApprFormUtils.setEnable(formView, Boolean.FALSE, rowIndex, "dy_grade");
            DecAdjApprFormUtils.setEnable(formView, Boolean.FALSE, rowIndex, "dy_rank");
        } else if (AdjAttributionType.DECATTRTYPE.getCode().equals(adjAttributionType) || !needAmountLinkGradeRankWhenAdj) {
            String isMatchGradeRank = billEntryRow.getString("dy_ismatchgraderank");
            if (!SWCStringUtils.equals((String)"1", (String)isMatchGradeRank)) {
                DecAdjApprFormUtils.setEnable(formView, Boolean.FALSE, rowIndex, "dy_grade");
                DecAdjApprFormUtils.setEnable(formView, Boolean.FALSE, rowIndex, "dy_rank");
            } else {
                formView.setEnable(Boolean.TRUE, rowIndex, new String[]{"dy_grade"});
                boolean userRank = itemUseRankMap.get(rowIndex);
                if (!userRank) {
                    DecAdjApprFormUtils.setEnable(formView, Boolean.FALSE, rowIndex, "dy_rank");
                } else {
                    DecAdjApprFormUtils.setEnable(formView, Boolean.TRUE, rowIndex, "dy_rank");
                }
            }
        }
    }

    public static Map<Integer, Boolean> checkItemUseRank(int[] rowIndexes, IDataModel billModel, Map<Long, Map<Long, Boolean>> salaryItemUseRankFlag) {
        HashMap<Integer, Boolean> itemUseRankMap = new HashMap<Integer, Boolean>(16);
        for (int rowIndex : rowIndexes) {
            Boolean useRankFlag;
            Map<Long, Boolean> flagMap;
            DynamicObject billEntryRow = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            long stdId = billEntryRow.getLong("dy_salarystd.id");
            long itemId = billEntryRow.getLong("dy_standarditem.id");
            boolean userRank = false;
            if (stdId > 0L && itemId > 0L && salaryItemUseRankFlag != null && (flagMap = salaryItemUseRankFlag.get(stdId)) != null && (useRankFlag = flagMap.get(itemId)) != null) {
                userRank = useRankFlag;
            }
            itemUseRankMap.put(rowIndex, userRank);
        }
        return itemUseRankMap;
    }

    public static Map<Long, Map<Long, Boolean>> getItemUseRankFlag(int[] rowIndexes, IDataModel billModel) {
        SalaryStdApplicationService service = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
        HashMap stdItemMap = Maps.newHashMapWithExpectedSize((int)rowIndexes.length);
        for (int rowIndex : rowIndexes) {
            DynamicObject billEntryRow = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            long stdId = billEntryRow.getLong("dy_salarystd.id");
            long itemId = billEntryRow.getLong("dy_standarditem.id");
            if (stdId <= 0L || itemId <= 0L) continue;
            List itemIds = stdItemMap.computeIfAbsent(stdId, v1 -> Lists.newArrayList());
            itemIds.add(itemId);
        }
        return service.getSalaryItemUseRankFlag((Map)stdItemMap);
    }

    public static void setFrequencyEntryColumnLock(int[] rowIndexes, IFormView formView, IDataModel billModel) {
        for (int rowIndex : rowIndexes) {
            DynamicObject billEntryRow = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            DynamicObject salaryStdDyObj = billEntryRow.getDynamicObject("dy_salarystd");
            if (salaryStdDyObj != null) {
                DecAdjApprFormUtils.setEnable(formView, Boolean.FALSE, rowIndex, "dy_frequency");
                continue;
            }
            DecAdjApprFormUtils.setEnable(formView, Boolean.TRUE, rowIndex, "dy_frequency");
        }
    }

    public static void calcDataWhenGradeChange(int[] rowIndexes, IDataModel billModel) {
        for (int rowIndex : rowIndexes) {
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_intervalmin", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_intervalmax", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_salarypercent", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_salaryseeprate", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_rank", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_amountlogic", null, rowIndex);
        }
    }

    public static void clearItemRelateInfo(int[] rowIndexes, IDataModel billModel) {
        String attributionType = DecAdjApprGridHelper.getAttributionType((IDataModel)billModel);
        for (int rowIndex : rowIndexes) {
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_salarystd", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_intervalmin", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_intervalmax", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_salarypercent", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_salaryseeprate", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_frequency", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_currency", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_exratevalue", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_quotetype", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_salargrel", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_grade", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_rank", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_ismatchgraderank", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_matchstrategy", null, rowIndex);
            if (AdjAttributionType.DECATTRTYPE.getCode().equals(attributionType)) {
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_amount", null, rowIndex);
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_excesscontrol", null, rowIndex);
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_overstandardtype", null, rowIndex);
                continue;
            }
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_suggestminrange", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_suggestminamount", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_suggestmaxrange", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_suggestmaxamount", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_actualrange", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_actualamount", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_amount", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_presalary", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_precurrency", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_presalarypercent", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_presalaryseeprate", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_pregrade", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_prerank", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_amountstdrangedisplay", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_amountstdrange", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_preamountstdrange", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_prefrequency", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_itemmin", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_itemmax", null, rowIndex);
        }
    }

    public static void calcAmountByGradeOrRank(int[] rowIndexes, IDataModel billModel, Map<Integer, Boolean> itemUseRankMap, List<StdAmountAndSalaryCountQueryResult> salaryStdAmountQueryResult) {
        Map salaryCountQueryResultMap = salaryStdAmountQueryResult.stream().collect(Collectors.toMap(StdAmountAndSalaryCountQueryResult::getUnionId, Function.identity(), (key1, key2) -> key1));
        for (int rowIndex : rowIndexes) {
            DynamicObject billEntryRow = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            Long gradeId = billEntryRow.getLong("dy_grade.id");
            Long rankId = billEntryRow.getLong("dy_rank.id");
            Long salaryStdId = billEntryRow.getLong("dy_salarystd.id");
            Long standardItemId = billEntryRow.getLong("dy_standarditem.id");
            String unionId = String.format("%s_%s_%s_%s", salaryStdId, standardItemId, gradeId, rankId);
            if (standardItemId == 0L || salaryStdId == 0L || gradeId == 0L) continue;
            Boolean rankIsUserSetFlag = itemUseRankMap.get(rowIndex);
            if (rankIsUserSetFlag.booleanValue() && rankId == 0L) {
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_intervalmin", null, rowIndex);
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_intervalmax", null, rowIndex);
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_stdmiddlevalue", null, rowIndex);
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_salarypercent", null, rowIndex);
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_salaryseeprate", null, rowIndex);
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_amountlogic", null, rowIndex);
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_amount", null, rowIndex);
                continue;
            }
            StdAmountAndSalaryCountQueryResult stdAmountQueryResult = (StdAmountAndSalaryCountQueryResult)salaryCountQueryResultMap.get(unionId);
            if (stdAmountQueryResult == null) continue;
            BigDecimal standardAmountBD = stdAmountQueryResult.getAmount();
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_stdamount", standardAmountBD, rowIndex);
            BigDecimal coefficientValue = DecAdjApprFormUtils.getCoefficientValue(billEntryRow);
            if (standardAmountBD != null) {
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_amountlogic", coefficientValue.multiply(standardAmountBD), rowIndex);
                continue;
            }
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_amountlogic", null, rowIndex);
        }
    }

    public static List<StdAmountAndSalaryCountQueryResult> getStdAmountQueryResult(int[] rowIndexes, IDataModel billModel) {
        HashSet<StdAmountQueryParam> salaryStdAmountParams = new HashSet<StdAmountQueryParam>(10);
        for (int rowIndex : rowIndexes) {
            DynamicObject billEntryRow = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            Long gradeId = billEntryRow.getLong("dy_grade.id");
            Long rankId = billEntryRow.getLong("dy_rank.id");
            Long salaryStdId = billEntryRow.getLong("dy_salarystd.id");
            Long standardItemId = billEntryRow.getLong("dy_standarditem.id");
            String matchStrategy = billEntryRow.getString("dy_matchstrategy");
            String salaryToGradeAndRankRel = billEntryRow.getString("dy_salargrel");
            if (standardItemId == 0L || salaryStdId == 0L) continue;
            if (gradeId == 0L && !Strings.isNullOrEmpty((String)salaryToGradeAndRankRel)) {
                Map rangeData = (Map)JSON.parseObject((String)salaryToGradeAndRankRel, (TypeReference)new TypeReference<Map<Long, List<Long>>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
                Pair minOrMaxGradeAndRankIdFromRel = ((SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class)).getMinOrMaxGradeAndRankIdFromRel(rangeData, salaryStdId, matchStrategy);
                logger.info("getStdAmountQueryResult invoke getMinOrMaxGradeAndRankIdFromRel rowIndex = [{}], rangeData = [{}], salaryStdId = [{}], matchStrategy = [{}], result = [{}]", new Object[]{rowIndex, rangeData, salaryStdId, matchStrategy, minOrMaxGradeAndRankIdFromRel});
                gradeId = minOrMaxGradeAndRankIdFromRel.getKey() == null ? Long.valueOf(0L) : (Long)minOrMaxGradeAndRankIdFromRel.getKey();
                rankId = minOrMaxGradeAndRankIdFromRel.getValue() == null ? Long.valueOf(0L) : (Long)minOrMaxGradeAndRankIdFromRel.getValue();
            }
            String unionId = String.format("%s_%s_%s_%s", salaryStdId, standardItemId, gradeId, rankId);
            StdAmountQueryParam stdAmountQueryParam = DecAdjApprFormUtils.buildStdAmountQueryParam(gradeId, rankId, salaryStdId, standardItemId, unionId);
            salaryStdAmountParams.add(stdAmountQueryParam);
        }
        if (salaryStdAmountParams.isEmpty()) {
            return Collections.emptyList();
        }
        SalaryStdApplicationService salaryStdApplicationService = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
        List stdAmountAndSalaryCountQueryResults = salaryStdApplicationService.queryAmountAndSalaryCount(new ArrayList(salaryStdAmountParams));
        logger.info("get stdamount Query Result={}", (Object)JSON.toJSONString((Object)stdAmountAndSalaryCountQueryResults));
        return stdAmountAndSalaryCountQueryResults;
    }

    public static void setOverStandardType(int[] rowIndexes, IFormView formView, IDataModel billModel) {
        Long standardItemId;
        Long adjFileId;
        String attributionType = DecAdjApprGridHelper.getAttributionType((IDataModel)billModel);
        BillExRateManager rateManager = new BillExRateManager();
        long exctableId = formView.getModel().getDataEntity().getLong("exctable.id");
        Date rateDate = formView.getModel().getDataEntity().getDate("exchangeratedate");
        ArrayList<StdOverStandardQueryParam> params = new ArrayList<StdOverStandardQueryParam>(10);
        boolean isMatchSetOverStdTypeFlag = true;
        for (int rowIndex : rowIndexes) {
            Long preCurrencyId;
            DynamicObject billEntryRow = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            String excessControl = billEntryRow.getString("dy_excesscontrol");
            if (StringUtils.isEmpty((String)excessControl)) continue;
            DynamicObject salaryStdDyObj = billEntryRow.getDynamicObject("dy_salarystd");
            adjFileId = billEntryRow.getLong("dy_adjfile.id");
            standardItemId = billEntryRow.getLong("dy_standarditem.id");
            long coefficientVid = billEntryRow.getLong("dy_coefficient.id");
            long adjCurrencyId = billEntryRow.getLong("dy_currency.id");
            long stdCurrencyId = 0L;
            stdCurrencyId = AdjAttributionType.ADJATTRTYPE.getCode().equals(attributionType) ? ((preCurrencyId = (Long)DynamicObjectValueHelper.dyObjGetValueIfExist((DynamicObject)billEntryRow, (String)"dy_precurrency_id", (String)"dy_precurrency")) == null || preCurrencyId <= 0L ? billEntryRow.getLong("dy_salarystd.currency.id") : preCurrencyId.longValue()) : billEntryRow.getLong("dy_salarystd.currency.id");
            BigDecimal amount = billEntryRow.getBigDecimal("dy_amount");
            String salaryToGradeAndRankRel = billEntryRow.getString("dy_salargrel");
            if (AdjAttributionType.DECATTRTYPE.getCode().equals(attributionType)) {
                if (Objects.isNull(salaryStdDyObj) || amount == null) {
                    DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_overstandardtype", null, rowIndex);
                    isMatchSetOverStdTypeFlag = false;
                }
            } else if (Objects.isNull(salaryStdDyObj) || amount == null || !Objects.isNull(salaryStdDyObj) && StringUtils.isEmpty((String)salaryToGradeAndRankRel)) {
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_overstandardtype", null, rowIndex);
                isMatchSetOverStdTypeFlag = false;
            }
            if (!isMatchSetOverStdTypeFlag) continue;
            ExchangeRateInfo exchangeRate = DecAdjApprGridHelper.getExchangeRate((BillExRateManager)rateManager, (long)adjCurrencyId, (long)stdCurrencyId, (long)exctableId, (Date)rateDate);
            BigDecimal finalAmountOfStdCurrency = DecAdjApprGridHelper.convertAmountByExrate((ExchangeRateInfo)exchangeRate, (BigDecimal)amount, (long)adjCurrencyId, (long)stdCurrencyId);
            logger.info("set adj cal info rowIndex={}, adjFileId={}, standardItemId={} amount={}, adjCurrencyId={}, stdCurrencyId={}, exchangeRate={}, finalAmountOfStdCurrency={} coefficientVid={}", new Object[]{rowIndex, adjFileId, standardItemId, amount, adjCurrencyId, stdCurrencyId, exchangeRate, finalAmountOfStdCurrency, coefficientVid});
            if (finalAmountOfStdCurrency == null) continue;
            String unionId = String.format("%s_%s", adjFileId, standardItemId);
            StdOverStandardQueryParam stdOverStandardQueryParam = new StdOverStandardQueryParam();
            stdOverStandardQueryParam.setCoefficientId(Long.valueOf(coefficientVid));
            Map personRange = (Map)JSON.parseObject((String)salaryToGradeAndRankRel, (TypeReference)new TypeReference<Map<Long, List<Long>>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
            stdOverStandardQueryParam.setPersonRange(personRange);
            stdOverStandardQueryParam.setTabId(Long.valueOf(salaryStdDyObj.getLong("id")));
            stdOverStandardQueryParam.setItemId(standardItemId);
            stdOverStandardQueryParam.setUnionId(unionId);
            stdOverStandardQueryParam.setAmount(finalAmountOfStdCurrency);
            params.add(stdOverStandardQueryParam);
        }
        List overStandardQueryResults = ((SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class)).getOverStandardType(params);
        Map stdOverStandardQueryResultMap = overStandardQueryResults.stream().collect(Collectors.toMap(StdOverStandardQueryResult::getUnionId, Function.identity()));
        logger.info("stdOverStandardQueryResultMap result is={}", (Object)JSON.toJSONString(stdOverStandardQueryResultMap));
        for (int rowIndex : rowIndexes) {
            DynamicObject billEntryRow = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            adjFileId = billEntryRow.getLong("dy_adjfile.id");
            String unionId = String.format("%s_%s", adjFileId, standardItemId = Long.valueOf(billEntryRow.getLong("dy_standarditem.id")));
            StdOverStandardQueryResult stdOverStandardQueryResult = (StdOverStandardQueryResult)stdOverStandardQueryResultMap.get(unionId);
            if (stdOverStandardQueryResult == null) continue;
            String overStandardType = stdOverStandardQueryResult.getOverStandardTypeEnum().getCode();
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_overstandardtype", overStandardType, rowIndex);
            String excessControl = billEntryRow.getString("dy_excesscontrol");
            DecAdjApprFormUtils.setColor(formView, rowIndex, excessControl, overStandardType);
        }
    }

    public static void setOverStdTypeColumnColor(int[] rowIndexs, IFormView formView, IDataModel billModel) {
        for (int rowIndex : rowIndexs) {
            DynamicObject billEntryRow = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            String excessControl = billEntryRow.getString("dy_excesscontrol");
            DynamicObject salaryStdDyObj = billEntryRow.getDynamicObject("dy_salarystd");
            String overStandardType = billEntryRow.getString("dy_overstandardtype");
            if (Objects.isNull(salaryStdDyObj) || !StringUtils.isNotEmpty((String)excessControl)) continue;
            DecAdjApprFormUtils.setColor(formView, rowIndex, excessControl, overStandardType);
        }
    }

    private static void setColor(IFormView formView, int rowIndex, String excessControl, String overStandardType) {
        List<CellStyle> cellStyleList = null;
        IClientViewProxy proxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        cellStyleList = ExcessControlEnum.CANNOT_EXCCONTROL.getCode().equals(excessControl) ? (OverStandardTypeEnum.WITHIN_LIMIT.getCode().equals(overStandardType) ? DecAdjApprFormUtils.setCellStyles(rowIndex, "#000000") : DecAdjApprFormUtils.setCellStyles(rowIndex, "#FF0000")) : (OverStandardTypeEnum.WITHIN_LIMIT.getCode().equals(overStandardType) ? DecAdjApprFormUtils.setCellStyles(rowIndex, "#000000") : DecAdjApprFormUtils.setCellStyles(rowIndex, "#FC8555"));
        ClientActions.createCellStyle().addAll(cellStyleList).invokeControlMethod(proxy, "adjapprdetailentry");
    }

    private static List<CellStyle> setCellStyles(int rowIndex, String colorCode) {
        ArrayList<CellStyle> cellStyleList = new ArrayList<CellStyle>();
        CellStyle cellStyle = new CellStyle();
        cellStyle.setRow(rowIndex);
        cellStyle.setFieldKey("dy_overstandardtype");
        cellStyle.setForeColor(colorCode);
        cellStyleList.add(cellStyle);
        return cellStyleList;
    }

    public static void showPersonNumber(IFormView billView) {
        IDataModel billModel = billView.getModel();
        Object pkValue = billModel.getDataEntity().getPkValue();
        int adjApprPersonCount = DecAdjApprGridHelper.getAdjApprPersonCount((Long)((Long)pkValue));
        Label personNum = (Label)billView.getControl("personnum");
        personNum.setText(String.valueOf(adjApprPersonCount));
        billView.getModel().getDataEntity(true).set("totalperson", (Object)adjApprPersonCount);
        billView.updateView("statisticpanel");
    }

    public static void formatAmountResult(IFormView billView) {
        IDataModel billModel = billView.getModel();
        Map amountResultMap = DecAdjApprGridHelper.getAmountResultList((IDataModel)billModel);
        List amountResultList = DecAdjApprGridHelper.getFormatAmountResult((Map)amountResultMap, (IDataModel)billModel);
        Collections.sort(amountResultList);
        Label totalAmount = (Label)billView.getControl("adjtotalamount");
        if (CollectionUtils.isEmpty((Collection)amountResultList)) {
            totalAmount.setText("0");
        } else {
            totalAmount.setText(StringUtils.join((Object[])amountResultList.toArray(), (String)"+"));
        }
        billView.updateView("statisticpanel");
        billView.getPageCache().put("amountResultMap", JSON.toJSONString((Object)amountResultMap));
    }

    public static void calcDecAdjFinalAmount(int[] rowIndexes, IDataModel model, String invokeType) {
        DynamicObject billEntity = model.getDataEntity(true);
        BillExRateManager rateManager = new BillExRateManager();
        for (int rowIndex : rowIndexes) {
            DynamicObject billEntryRow = model.getEntryRowEntity("adjapprdetailentry", rowIndex);
            DynamicObject salaryStdDynamicObject = billEntryRow.getDynamicObject("dy_salarystd");
            if (salaryStdDynamicObject == null) continue;
            BigDecimal logicAmount = billEntryRow.getBigDecimal(DecAdjApprCreateGridHelper.buildKey((String)DecAdjApprConstants.KEY_AMOUNTLOGIC));
            BigDecimal finalAmount = null;
            if (logicAmount != null) {
                long stdCurrency = salaryStdDynamicObject.getLong("currency.id");
                long decCurrency = billEntryRow.getLong("dy_currency.id");
                int decCurrencyScale = billEntryRow.getInt("dy_currency.amtprecision");
                if (stdCurrency == decCurrency) {
                    finalAmount = logicAmount;
                    DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_exratevalue", null, rowIndex);
                } else if (stdCurrency > 0L && decCurrency > 0L) {
                    long exctableId = billEntity.getLong("exctable.id");
                    Date rateDate = billEntity.getDate("exchangeratedate");
                    if (decCurrency > 0L && stdCurrency > 0L && exctableId > 0L && rateDate != null) {
                        ExchangeRateInfo exrateInfo = rateManager.getExRate(new ExRateKey(Long.valueOf(decCurrency), Long.valueOf(stdCurrency), Long.valueOf(rateDate.getTime()), Long.valueOf(exctableId)));
                        if (exrateInfo != null) {
                            Boolean quoteType = exrateInfo.getQuoteType();
                            BigDecimal exchangeRate = exrateInfo.getExchangeRate();
                            if (exchangeRate != null && model != null) {
                                DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_exratevalue", exchangeRate, rowIndex);
                                DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_quotetype", quoteType, rowIndex);
                            }
                        } else if (model != null) {
                            DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_exratevalue", null, rowIndex);
                        }
                    }
                    BigDecimal exrateValue = billEntryRow.getBigDecimal("dy_exratevalue");
                    boolean quoteType = billEntryRow.getBoolean("dy_quotetype");
                    if (exrateValue != null && exrateValue.compareTo(BigDecimal.ZERO) != 0) {
                        BigDecimal exrateCurrent;
                        finalAmount = quoteType ? (exrateCurrent = logicAmount.divide(exrateValue, decCurrencyScale, 4)) : (exrateCurrent = logicAmount.multiply(exrateValue).setScale(decCurrencyScale, 4));
                    }
                }
            }
            if (StringUtils.isNotBlank((String)invokeType) && "decEntryImport".equals(invokeType)) {
                return;
            }
            DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_amount", finalAmount, rowIndex);
        }
    }

    public static void setCalcFieldAfter(int[] rowIndexes, IDataModel model) {
        DynamicObject billEntity = model.getDataEntity(true);
        BigDecimal salaryPercent = null;
        BigDecimal salarySeeprate = null;
        BigDecimal stdIntervalMin = null;
        BigDecimal stdIntervalMax = null;
        BigDecimal stdMiddleValue = null;
        BillExRateManager rateManager = new BillExRateManager();
        long exctableId = billEntity.getLong("exctable.id");
        Date rateDate = billEntity.getDate("exchangeratedate");
        List<StdAmountAndSalaryCountQueryResult> stdAmountAndSalaryCountQueryResult = DecAdjApprFormUtils.getStdAmountQueryResult(rowIndexes, model);
        Map salaryCountQueryResultMap = stdAmountAndSalaryCountQueryResult.stream().collect(Collectors.toMap(StdAmountAndSalaryCountQueryResult::getUnionId, Function.identity(), (key1, key2) -> key1));
        for (int rowIndex : rowIndexes) {
            String unionId;
            StdAmountAndSalaryCountQueryResult stdAmountQueryResult;
            DynamicObject billEntryRow = model.getEntryRowEntity("adjapprdetailentry", rowIndex);
            long currencyId = billEntryRow.getLong("dy_currency.id");
            long stdCurrencyId = billEntryRow.getLong("dy_salarystd.currency.id");
            Long gradeId = (Long)DynamicObjectValueHelper.dyObjGetValueIfExist((DynamicObject)billEntryRow, (String)"dy_grade.id", (String)"dy_grade");
            gradeId = gradeId == null ? Long.valueOf(0L) : gradeId;
            Long rankId = (Long)DynamicObjectValueHelper.dyObjGetValueIfExist((DynamicObject)billEntryRow, (String)"dy_rank.id", (String)"dy_rank");
            rankId = rankId == null ? Long.valueOf(0L) : rankId;
            Long salaryStdId = billEntryRow.getLong("dy_salarystd.id");
            Long standardItemId = billEntryRow.getLong("dy_standarditem.id");
            String matchStrategy = billEntryRow.getString("dy_matchstrategy");
            String personRange = billEntryRow.getString("dy_salargrel");
            if (standardItemId == 0L || salaryStdId == 0L) continue;
            if (gradeId == 0L && !Strings.isNullOrEmpty((String)personRange)) {
                Map rangeData = (Map)JSON.parseObject((String)personRange, (TypeReference)new TypeReference<Map<Long, List<Long>>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
                Pair minOrMaxGradeAndRankIdFromRel = ((SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class)).getMinOrMaxGradeAndRankIdFromRel(rangeData, salaryStdId, matchStrategy);
                logger.info("setCalcFieldAfter invoke getMinOrMaxGradeAndRankIdFromRel rowIndex = [{}], rangeData = [{}], salaryStdId = [{}], matchStrategy = [{}], result = [{}]", new Object[]{rowIndex, rangeData, salaryStdId, matchStrategy, minOrMaxGradeAndRankIdFromRel});
                gradeId = minOrMaxGradeAndRankIdFromRel.getKey() == null ? Long.valueOf(0L) : (Long)minOrMaxGradeAndRankIdFromRel.getKey();
                Long l = rankId = minOrMaxGradeAndRankIdFromRel.getValue() == null ? Long.valueOf(0L) : (Long)minOrMaxGradeAndRankIdFromRel.getValue();
            }
            if ((stdAmountQueryResult = (StdAmountAndSalaryCountQueryResult)salaryCountQueryResultMap.get(unionId = String.format("%s_%s_%s_%s", salaryStdId, standardItemId, gradeId, rankId))) == null) continue;
            BigDecimal intervalMin = stdAmountQueryResult.getGradeMinAmount();
            BigDecimal intervalMax = stdAmountQueryResult.getGradeMaxAmount();
            BigDecimal middleValue = stdAmountQueryResult.getGradeMiddleAmount();
            BigDecimal amount = billEntryRow.getBigDecimal("dy_amount");
            BigDecimal coefficientValue = DecAdjApprFormUtils.getCoefficientValue(billEntryRow);
            stdIntervalMin = intervalMin == null ? BigDecimal.ZERO : DecAdjApprGridHelper.convertAmountByExrate((BillExRateManager)rateManager, (BigDecimal)intervalMin, (BigDecimal)amount, (long)stdCurrencyId, (long)currencyId, (long)exctableId, (Date)rateDate, (boolean)true);
            stdIntervalMax = intervalMax == null ? BigDecimal.ZERO : DecAdjApprGridHelper.convertAmountByExrate((BillExRateManager)rateManager, (BigDecimal)intervalMax, (BigDecimal)amount, (long)stdCurrencyId, (long)currencyId, (long)exctableId, (Date)rateDate, (boolean)true);
            stdMiddleValue = middleValue == null ? BigDecimal.ZERO : DecAdjApprGridHelper.convertAmountByExrate((BillExRateManager)rateManager, (BigDecimal)middleValue, (BigDecimal)amount, (long)stdCurrencyId, (long)currencyId, (long)exctableId, (Date)rateDate, (boolean)true);
            salaryPercent = SalaryStdCalculateHelper.calcSalaryRatioNew((BigDecimal)amount, (BigDecimal)stdMiddleValue, (BigDecimal)coefficientValue);
            salarySeeprate = SalaryStdCalculateHelper.calcSalaryPermeability((BigDecimal)amount, (BigDecimal)stdIntervalMin, (BigDecimal)stdIntervalMax, (BigDecimal)coefficientValue);
            logger.info("adjentry cal stdIntervalMin={}, stdIntervalMax={}, salaryPercent={}, salarySeeprate={}, stdMiddleValue={}", new Object[]{stdIntervalMin, stdIntervalMax, salaryPercent, salarySeeprate, stdMiddleValue});
            DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_salarypercent", salaryPercent, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_salaryseeprate", salarySeeprate, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_intervalmin", stdIntervalMin, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_intervalmax", stdIntervalMax, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_stdmiddlevalue", stdMiddleValue, rowIndex);
        }
    }

    private static StdAmountQueryParam buildStdAmountQueryParam(Long gradeId, Long rankId, Long salaryStdId, Long standardItemId, String unionId) {
        StdAmountQueryParam stdAmountQueryParam = new StdAmountQueryParam();
        stdAmountQueryParam.setGradeId(gradeId);
        stdAmountQueryParam.setRankId(rankId);
        stdAmountQueryParam.setStdTabId(salaryStdId);
        stdAmountQueryParam.setItemId(standardItemId);
        stdAmountQueryParam.setUnionId(unionId);
        return stdAmountQueryParam;
    }

    private static BigDecimal getCoefficientValue(DynamicObject row) {
        DynamicObject coefficientDyobj = row.getDynamicObject("dy_coefficient");
        BigDecimal coefficientvalue = BigDecimal.ONE;
        if (!SWCBaseUtils.isEmpty((DynamicObject)coefficientDyobj)) {
            coefficientvalue = coefficientDyobj.getBigDecimal("coefficientvalue");
        }
        return coefficientvalue;
    }

    public static void setFieldEnableWithCalcType(int[] rowIndexes, IDataModel model, IFormView view) {
        for (int index : rowIndexes) {
            DynamicObject billEntryRow = model.getEntryRowEntity("adjapprdetailentry", index);
            CalcType calctype = CalcType.getByCode((String)billEntryRow.getString("dy_calctype"));
            if (CalcType.RATIO == calctype) {
                DecAdjApprFormUtils.setEnable(view, Boolean.TRUE, index, ratioEnableFields.toArray(new String[0]));
                DecAdjApprFormUtils.setEnable(view, Boolean.FALSE, index, amountEnableFields.toArray(new String[0]));
                DecAdjApprFormUtils.setEnable(view, Boolean.FALSE, index, enableFields.toArray(new String[0]));
                continue;
            }
            if (CalcType.AMOUNT == calctype) {
                DecAdjApprFormUtils.setEnable(view, Boolean.TRUE, index, amountEnableFields.toArray(new String[0]));
                DecAdjApprFormUtils.setEnable(view, Boolean.FALSE, index, ratioEnableFields.toArray(new String[0]));
                DecAdjApprFormUtils.setEnable(view, Boolean.FALSE, index, enableFields.toArray(new String[0]));
                continue;
            }
            if (CalcType.GRADE_RANK != calctype) continue;
            DecAdjApprFormUtils.setEnable(view, Boolean.TRUE, index, enableFields.toArray(new String[0]));
            DecAdjApprFormUtils.setEnable(view, Boolean.FALSE, index, ratioEnableFields.toArray(new String[0]));
            DecAdjApprFormUtils.setEnable(view, Boolean.FALSE, index, amountEnableFields.toArray(new String[0]));
        }
    }

    public static void setFieldEnableWithCalcType(int[] rowIndexes, List<String> rangeEnableFields, List<String> amountEnableFields, IDataModel model, IFormView view) {
        for (int index : rowIndexes) {
            DynamicObject billEntryRow = model.getEntryRowEntity("adjapprdetailentry", index);
            CalcType calctype = CalcType.getByCode((String)billEntryRow.getString("dy_calctype"));
            if (CalcType.RATIO == calctype) {
                DecAdjApprFormUtils.setEnable(view, Boolean.TRUE, index, rangeEnableFields.toArray(new String[0]));
                DecAdjApprFormUtils.setEnable(view, Boolean.FALSE, index, amountEnableFields.toArray(new String[0]));
                DecAdjApprFormUtils.setEnable(view, Boolean.FALSE, index, enableFields.toArray(new String[0]));
                continue;
            }
            if (CalcType.AMOUNT != calctype) continue;
            DecAdjApprFormUtils.setEnable(view, Boolean.TRUE, index, amountEnableFields.toArray(new String[0]));
            DecAdjApprFormUtils.setEnable(view, Boolean.FALSE, index, amountEnableFields.toArray(new String[0]));
            DecAdjApprFormUtils.setEnable(view, Boolean.FALSE, index, enableFields.toArray(new String[0]));
        }
    }

    public static void setLastAdjInfo(int[] rowIndexes, IDataModel billModel) {
        Map<Long, List<Long>> fileItemListMap = DecAdjApprFormUtils.getFileItemMap(rowIndexes, billModel);
        HashMap fileItemSetMap = Maps.newHashMapWithExpectedSize((int)fileItemListMap.size());
        for (Map.Entry<Long, List<Long>> entry : fileItemListMap.entrySet()) {
            fileItemSetMap.put(entry.getKey(), Sets.newHashSet((Iterable)entry.getValue()));
        }
        AdjFileApplicationService service = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
        Map latestDecAdjSalary = service.getLatestDecAdjSalary("id,standarditem.id,salaryadjfile.id,datastatus,enable,bsed,salarystd,grade,rank,currency,amount,frequency,salarypercent,salaryseeprate,amountstdrange", (Map)fileItemSetMap);
        logger.info("get last adj info, fileItemSetMap={}, latestDecAdjSalary size={}", (Object)JSON.toJSONString((Object)fileItemSetMap), (Object)latestDecAdjSalary.size());
        for (int rowIndex : rowIndexes) {
            DynamicObject rowEntity = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            long fileId = rowEntity.getLong("dy_adjfile.id");
            long itemId = rowEntity.getLong("dy_standarditem.id");
            Map itemLastSalaryObjs = (Map)latestDecAdjSalary.get(fileId);
            if (fileId <= 0L || itemLastSalaryObjs == null) continue;
            DynamicObject lastSalaryObj = (DynamicObject)itemLastSalaryObjs.get(itemId);
            if (itemId <= 0L || lastSalaryObj == null) continue;
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_presalarystd", lastSalaryObj.getDynamicObject("salarystd"), rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_pregrade", lastSalaryObj.getDynamicObject("grade"), rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_prerank", lastSalaryObj.getDynamicObject("rank"), rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_precurrency", lastSalaryObj.getDynamicObject("currency"), rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_presalary", lastSalaryObj.getBigDecimal("amount"), rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_prefrequency", lastSalaryObj.getDynamicObject("frequency"), rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_presalarypercent", lastSalaryObj.getBigDecimal("salarypercent"), rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_presalaryseeprate", lastSalaryObj.getBigDecimal("salaryseeprate"), rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_preamountstdrange", lastSalaryObj.getString("amountstdrange"), rowIndex);
        }
    }

    public static void modelSetValueIfExist(IDataModel billModel, String key, Object value, int rowIndex) {
        DynamicObjectValueHelper.modelSetValueIfExist((IDataModel)billModel, (String)key, (Object)value, (int)rowIndex);
    }

    public static boolean isAuditView(FormShowParameter parameter) {
        Object processParam = parameter.getCustomParam("processDefinitionId");
        return processParam != null;
    }

    public static void setAdjCalcFieldAfter(int[] rowIndexes, IDataModel model) {
        DynamicObject billEntity = model.getDataEntity(true);
        DynamicObjectCollection billEntryRows = model.getEntryEntity("adjapprdetailentry");
        if (CollectionUtils.isEmpty((Collection)billEntryRows)) {
            return;
        }
        BillExRateManager rateManager = new BillExRateManager();
        long exctableId = billEntity.getLong("exctable.id");
        Date rateDate = billEntity.getDate("exchangeratedate");
        ArrayList<SalaryCountAmountMatchParam> params = new ArrayList<SalaryCountAmountMatchParam>(10);
        SalaryCountAmountMatchParam salaryCountAmountMatchParam = null;
        for (int rowIndex : rowIndexes) {
            salaryCountAmountMatchParam = new SalaryCountAmountMatchParam();
            DynamicObject row = model.getEntryRowEntity("adjapprdetailentry", rowIndex);
            long fileId = row.getLong("dy_adjfile.id");
            long itemId = row.getLong("dy_standarditem.id");
            long coefficientVid = row.getLong("dy_coefficient.id");
            long stdTableId = row.getLong("dy_salarystd.id");
            long adjCurrencyId = row.getLong("dy_currency.id");
            String matchStrategy = row.getString("dy_matchstrategy");
            String isMatchGradeRankVal = row.getString("dy_ismatchgraderank");
            long stdCurrencyId = row.getLong("dy_salarystd.currency.id");
            Map matchRangeMap = null;
            if (row.getDataEntityType().getProperties().containsKey((Object)"dy_salargrel")) {
                String salaryToGradeAndRankRel = row.getString("dy_salargrel");
                if (StringUtils.isBlank((String)salaryToGradeAndRankRel)) continue;
                matchRangeMap = (Map)JSON.parseObject((String)salaryToGradeAndRankRel, (TypeReference)new TypeReference<Map<Long, List<Long>>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
            }
            BigDecimal finalAmount = row.getBigDecimal("dy_amount");
            ExchangeRateInfo exchangeRate = DecAdjApprGridHelper.getExchangeRate((BillExRateManager)rateManager, (long)adjCurrencyId, (long)stdCurrencyId, (long)exctableId, (Date)rateDate);
            BigDecimal finalAmountOfStdCurrency = DecAdjApprGridHelper.convertAmountByExrate((ExchangeRateInfo)exchangeRate, (BigDecimal)finalAmount, (long)adjCurrencyId, (long)stdCurrencyId);
            if (finalAmountOfStdCurrency == null || stdTableId <= 0L || itemId <= 0L) continue;
            salaryCountAmountMatchParam.setStdTableId(Long.valueOf(stdTableId));
            salaryCountAmountMatchParam.setItemId(Long.valueOf(itemId));
            salaryCountAmountMatchParam.setCoeficientVid(Long.valueOf(coefficientVid));
            salaryCountAmountMatchParam.setAmount(finalAmountOfStdCurrency);
            salaryCountAmountMatchParam.setUnionId(String.format("%s_%s", fileId, itemId));
            salaryCountAmountMatchParam.setisMatchGradeRank(isMatchGradeRankVal);
            salaryCountAmountMatchParam.setMatchStrategy(matchStrategy);
            if (matchRangeMap != null) {
                salaryCountAmountMatchParam.setGradeRankInfo(matchRangeMap);
            }
            params.add(salaryCountAmountMatchParam);
        }
        List salaryCountAmountMatchResults = ((SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class)).matchTableRangeBySalaryCountOrAmount(params);
        logger.info("salary count amount match params={}, results={}", (Object)JSON.toJSONString(params), (Object)JSON.toJSONString((Object)salaryCountAmountMatchResults));
        Map salaryCountAmountMatchResultMap = salaryCountAmountMatchResults.stream().collect(Collectors.toMap(SalaryCountAmountMatchResult::getUnionId, Function.identity()));
        HashMap amountStdRangeMatchMap = new HashMap(16);
        ArrayList positionInfoOfNotUseRankList = new ArrayList(16);
        salaryCountAmountMatchResultMap.values().stream().forEach(item -> {
            if (item.isItemUseRank()) {
                Map positionInfo = item.getPositionInfo();
                for (Map.Entry entry : positionInfo.entrySet()) {
                    Long key = (Long)entry.getKey();
                    List rankList = amountStdRangeMatchMap.computeIfAbsent(key, o1 -> Lists.newArrayList());
                    rankList.addAll((Collection)entry.getValue());
                }
            } else {
                positionInfoOfNotUseRankList.addAll(item.getPositionInfoOfNotUseRank());
            }
        });
        GradeAndRankNameEntity gradeAndRankNameEntity = DecAdjApprGridHelper.getMatchGradeAndRankNameEntity(amountStdRangeMatchMap, positionInfoOfNotUseRankList);
        for (int rowIndex : rowIndexes) {
            DynamicObject row = model.getEntryRowEntity("adjapprdetailentry", rowIndex);
            long fileId = row.getLong("dy_adjfile.id");
            long itemId = row.getLong("dy_standarditem.id");
            String calcTypeCode = row.getString("dy_calctype");
            CalcType calcType = CalcType.getByCode((String)calcTypeCode);
            boolean needCalcGradeRankByAmount = calcType != null && (calcType == CalcType.AMOUNT || calcType == CalcType.RATIO);
            String unionKey = String.format("%s_%s", fileId, itemId);
            long adjCurrencyId = row.getLong("dy_currency.id");
            long stdCurrencyId = row.getLong("dy_salarystd.currency.id");
            BigDecimal finalAmount = row.getBigDecimal("dy_amount");
            BigDecimal coefficientValue = DecAdjApprFormUtils.getCoefficientValue(row);
            SalaryCountAmountMatchResult salaryCountAmountMatchResult = (SalaryCountAmountMatchResult)salaryCountAmountMatchResultMap.get(unionKey);
            Long afterGradeId = null;
            Long afterRankId = null;
            BigDecimal afterStdIntervalMin = (BigDecimal)DynamicObjectValueHelper.modelGetValueIfExist((IDataModel)model, (String)"dy_intervalmin", (int)rowIndex, (String)"dy_intervalmin");
            BigDecimal afterStdIntervalMax = (BigDecimal)DynamicObjectValueHelper.modelGetValueIfExist((IDataModel)model, (String)"dy_intervalmax", (int)rowIndex, (String)"dy_intervalmax");
            BigDecimal afterStdMiddleValue = (BigDecimal)DynamicObjectValueHelper.modelGetValueIfExist((IDataModel)model, (String)"dy_stdmiddlevalue", (int)rowIndex, (String)"dy_stdmiddlevalue");
            String amountStdRangeName = null;
            String amountstdrange = null;
            if (needCalcGradeRankByAmount) {
                afterStdIntervalMin = null;
                afterStdIntervalMax = null;
                afterStdMiddleValue = null;
                if (salaryCountAmountMatchResult != null) {
                    Map amountStdRangeMap = null;
                    List<Pair<Long, Long>> amountStdNoUseRangeList = null;
                    Map positionInfo = salaryCountAmountMatchResult.getPositionInfo();
                    List positionInfoOfNotUseRank = salaryCountAmountMatchResult.getPositionInfoOfNotUseRank();
                    afterGradeId = salaryCountAmountMatchResult.getGradeId();
                    afterRankId = salaryCountAmountMatchResult.getRankId();
                    if (salaryCountAmountMatchResult.isItemUseRank() && MapUtils.isNotEmpty((Map)positionInfo)) {
                        amountStdRangeMap = DecAdjApprFormUtils.getAmountStdRange(positionInfo);
                        if (MapUtils.isNotEmpty(amountStdRangeMap)) {
                            amountStdRangeMap = amountStdRangeMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
                            amountStdRangeName = DecAdjApprGridHelper.buildMatchGradeAndRankRangeDisplayName((Map)amountStdRangeMap, (GradeAndRankNameEntity)gradeAndRankNameEntity);
                        }
                    } else if (!CollectionUtils.isEmpty((Collection)positionInfoOfNotUseRank) && !CollectionUtils.isEmpty(amountStdNoUseRangeList = DecAdjApprFormUtils.getAmountStdRange(positionInfoOfNotUseRank))) {
                        amountStdRangeName = DecAdjApprGridHelper.buildAllMatchGradeRangeName(amountStdNoUseRangeList, (GradeAndRankNameEntity)gradeAndRankNameEntity);
                    }
                    AmountStdRangeEntity amountStdRangeEntity = new AmountStdRangeEntity(amountStdRangeMap, amountStdNoUseRangeList);
                    amountstdrange = JSON.toJSONString((Object)amountStdRangeEntity);
                    Map gradeIntervalInfo = salaryCountAmountMatchResult.getGradeIntervalInfo();
                    Map gradeIntervalInfoMap = (Map)gradeIntervalInfo.get(afterGradeId);
                    ExchangeRateInfo rateInfo = DecAdjApprGridHelper.getExchangeRate((BillExRateManager)rateManager, (long)stdCurrencyId, (long)adjCurrencyId, (long)exctableId, (Date)rateDate);
                    if (MapUtils.isNotEmpty((Map)gradeIntervalInfoMap)) {
                        afterStdIntervalMin = DecAdjApprGridHelper.convertAmountByExrate((ExchangeRateInfo)rateInfo, (BigDecimal)((BigDecimal)gradeIntervalInfoMap.get("gradeMin")), (long)stdCurrencyId, (long)adjCurrencyId);
                        afterStdIntervalMax = DecAdjApprGridHelper.convertAmountByExrate((ExchangeRateInfo)rateInfo, (BigDecimal)((BigDecimal)gradeIntervalInfoMap.get("gradeMax")), (long)stdCurrencyId, (long)adjCurrencyId);
                        afterStdMiddleValue = DecAdjApprGridHelper.convertAmountByExrate((ExchangeRateInfo)rateInfo, (BigDecimal)((BigDecimal)gradeIntervalInfoMap.get("gradeMiddle")), (long)stdCurrencyId, (long)adjCurrencyId);
                    }
                }
                DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_grade", afterGradeId, rowIndex);
                DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_rank", afterRankId, rowIndex);
                DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_intervalmin", afterStdIntervalMin, rowIndex);
                DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_intervalmax", afterStdIntervalMax, rowIndex);
                DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_stdmiddlevalue", afterStdMiddleValue, rowIndex);
                DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_amountstdrange", amountstdrange, rowIndex);
                DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_amountstdrangedisplay", amountStdRangeName, rowIndex);
            }
            BigDecimal afterSalaryPercent = SalaryStdCalculateHelper.calcSalaryRatioNew((BigDecimal)finalAmount, (BigDecimal)afterStdMiddleValue, (BigDecimal)coefficientValue);
            BigDecimal afterSalarySeeprate = SalaryStdCalculateHelper.calcSalaryPermeability((BigDecimal)finalAmount, (BigDecimal)afterStdIntervalMin, (BigDecimal)afterStdIntervalMax, (BigDecimal)coefficientValue);
            DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_salarypercent", afterSalaryPercent, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_salaryseeprate", afterSalarySeeprate, rowIndex);
            String isMatchGradeRank = row.getString("dy_ismatchgraderank");
            if (!SWCStringUtils.equals((String)"1", (String)isMatchGradeRank)) {
                DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_grade", null, rowIndex);
                DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_rank", null, rowIndex);
            }
            if (!Objects.isNull(afterGradeId) && 0L != afterGradeId) continue;
            DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_salarypercent", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_salaryseeprate", null, rowIndex);
        }
    }

    private static Map<Long, List<Pair<Long, Long>>> getAmountStdRange(Map<Long, List<Pair<Long, Long>>> positionInfoMap) {
        ArrayList gradeIdList = new ArrayList(10);
        positionInfoMap.forEach((key, value) -> {
            List positionInfo = (List)positionInfoMap.get(key);
            positionInfo.forEach(item -> {
                Long minRankId = (Long)item.getValue();
                Long maxRankId = (Long)item.getKey();
                if (minRankId == 0L || maxRankId == 0L) {
                    gradeIdList.add(key);
                }
            });
        });
        positionInfoMap.keySet().removeIf(item -> gradeIdList.contains(item));
        return positionInfoMap;
    }

    private static List<Pair<Long, Long>> getAmountStdRange(List<Pair<Long, Long>> positionInfoOfNotUseRankList) {
        HashSet<Long> gradeIdSet = new HashSet<Long>(16);
        for (Pair<Long, Long> positionInfoOfNotUseRank : positionInfoOfNotUseRankList) {
            Long minGradeId = (Long)positionInfoOfNotUseRank.getKey();
            Long maxGradeId = (Long)positionInfoOfNotUseRank.getValue();
            if (minGradeId != 0L && maxGradeId != 0L) continue;
            gradeIdSet.add(minGradeId);
            gradeIdSet.add(maxGradeId);
        }
        positionInfoOfNotUseRankList.removeIf(item -> gradeIdSet.contains(item.getKey()) || gradeIdSet.contains(item.getValue()));
        return positionInfoOfNotUseRankList;
    }

    public static void hideControl(String attrButionType, IFormView formView) {
        OperationStatus status;
        if (attrButionType == null || AdjAttributionType.DECATTRTYPE.getCode().equals(attrButionType)) {
            formView.setVisible(Boolean.FALSE, new String[]{"salaryadjscm", "advconbaritemapdecision", "caltype"});
            formView.setVisible(Boolean.FALSE, new String[]{"flextips"});
        } else {
            formView.setVisible(Boolean.TRUE, new String[]{"salaryadjscm", "advconbaritemapdecision", "caltype"});
        }
        DynamicObject billEntity = formView.getModel().getDataEntity();
        String billStatus = billEntity.getString("auditstatus");
        String approveStatus = billEntity.getString("billstatus");
        if (StringUtils.equals((String)billStatus, (String)"B") || StringUtils.equals((String)billStatus, (String)"C") || StringUtils.equals((String)approveStatus, (String)"E")) {
            formView.setVisible(Boolean.FALSE, new String[]{"advconbaritemap", "advconbaritemap1", "advconbaritemap2", "advconbaritemap3", "advconbaritemap4", "advconbaritemap5"});
        } else {
            formView.setVisible(Boolean.TRUE, new String[]{"advconbaritemap", "advconbaritemap1", "advconbaritemap2", "advconbaritemap3", "advconbaritemap4", "advconbaritemap5"});
        }
        DynamicObject salaryAdjScm = billEntity.getDynamicObject("salaryadjscm");
        if (salaryAdjScm == null || !salaryAdjScm.getBoolean("isadjdecision")) {
            formView.setVisible(Boolean.FALSE, new String[]{"advconbaritemapdecision"});
        }
        if (OperationStatus.VIEW.equals((Object)(status = formView.getFormShowParameter().getStatus()))) {
            formView.setVisible(Boolean.FALSE, new String[]{"advconbaritemap", "advconbaritemap1", "advconbaritemap2", "advconbaritemap5"});
        }
    }

    public static void changeAdjEntryPanelName(String attrButionType, IFormView formView) {
        HashMap controlMap = new HashMap(1);
        HashMap<String, String> titleMap = new HashMap<String, String>(1);
        titleMap.put(ResManager.getLanguage(), String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u660e\u7ec6\u4fe1\u606f", (String)"DecAdjApprFormUtils_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), AdjAttributionType.getByCode((String)attrButionType).getDisplayName()));
        controlMap.put("text", titleMap);
        formView.updateControlMetadata("flexadj", controlMap);
    }

    public static void changeAdjEntryPanelLabelName(String attrButionType, IFormView formView) {
        Label totalPersonLab = (Label)formView.getControl("labelap3");
        Label totalAmountLab = (Label)formView.getControl("labelap31");
        String totalPersonText = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u603b\u4eba\u6570", (String)"DecAdjApprFormUtils_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), AdjAttributionType.getByCode((String)attrButionType).getDisplayName());
        String totalAmountText = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u603b\u91d1\u989d", (String)"DecAdjApprFormUtils_2", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), AdjAttributionType.getByCode((String)attrButionType).getDisplayName());
        totalPersonLab.setText(totalPersonText);
        totalAmountLab.setText(totalAmountText);
        String tipMsg = ResManager.loadKDString((String)"\u6839\u636e\u201c\u5b9e\u9645\u8c03\u5e45\uff08\u91d1\u989d\uff09\u201d\u81ea\u52a8\u6c47\u603b\uff1b\u82e5\u660e\u7ec6\u4fe1\u606f\u4e2d\u201c\u672c\u6b21\u8c03\u85aa\u4fe1\u606f\u201d\u51fa\u73b0\u591a\u4e2a\u5e01\u79cd\u6216\u591a\u4e2a\u9891\u5ea6\uff0c\u5219\u76f8\u540c\u5e01\u79cd&\u9891\u5ea6\u7684\u6570\u636e\u4f1a\u8fdb\u884c\u6c47\u603b\u3002", (String)"DecAdjApprFormUtils_13", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        if (AdjAttributionType.DECATTRTYPE.getCode().equals(attrButionType)) {
            tipMsg = ResManager.loadKDString((String)"\u6839\u636e\u201c\u91d1\u989d\u201d\u81ea\u52a8\u6c47\u603b\uff1b\u82e5\u660e\u7ec6\u4fe1\u606f\u4e2d\u51fa\u73b0\u591a\u4e2a\u5e01\u79cd\u6216\u591a\u4e2a\u9891\u5ea6\uff0c\u5219\u76f8\u540c\u5e01\u79cd&\u9891\u5ea6\u7684\u6570\u636e\u4f1a\u8fdb\u884c\u6c47\u603b\u3002", (String)"DecAdjApprFormUtils_14", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        }
        Tips tips = new Tips();
        tips.setType("text");
        tips.setContent(new LocaleString(tipMsg));
        totalAmountLab.addTips(tips);
    }

    public static void changeAdjEntryOperateButtonName(String attrButionType, IFormView formView) {
        HashMap controlMap = new HashMap(1);
        HashMap<String, String> titleMap = new HashMap<String, String>(1);
        String addAdjPersonTitle = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6dfb\u52a0%1$s\u4eba\u5458", (String)"DecAdjApprFormUtils_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), AdjAttributionType.getByCode((String)attrButionType).getDisplayName());
        titleMap.put(ResManager.getLanguage(), addAdjPersonTitle);
        controlMap.put("text", titleMap);
        formView.updateControlMetadata("advconbaritemap", controlMap);
    }

    public static void changeExchangeRateDateTips(String attributionType, IFormView formView) {
        DateEdit exchangeRateDateEdit = (DateEdit)formView.getControl(DecAdjApprConstants.KEY_EXCHANGERATEDATE);
        Tips tips = new Tips();
        tips.setType("text");
        if (AdjAttributionType.DECATTRTYPE.getCode().equals(attributionType)) {
            tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u4e00\u3001\u54ea\u79cd\u60c5\u51b5\u4f1a\u8fdb\u884c\u6c47\u7387\u6362\u7b97\uff1a{0} 1\uff09\u5f53\u5b9a\u85aa\u5e01\u79cd\u4e0e\u85aa\u916c\u6807\u51c6\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u5b9a\u85aa\u91d1\u989d\u4f1a\u4f7f\u7528\u6c47\u7387\u8fdb\u884c\u6362\u7b97\u3002{1} 2\uff09\u5f53\u5b9a\u85aa\u5e01\u79cd\u4e0e\u85aa\u916c\u6807\u51c6\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u85aa\u916c\u6bd4\u7387\u3001\u85aa\u916c\u6e17\u900f\u7387\u4f1a\u4f7f\u7528\u6c47\u7387\u8fdb\u884c\u6362\u7b97\u3002{2} \u4e8c\u3001\u6c47\u7387\u5982\u4f55\u8fdb\u884c\u6362\u7b97\uff1a{3} 1\uff09\u6709\u76f4\u63a5\u6c47\u7387\uff1a\u4f18\u5148\u53d6\u6c47\u7387\u8868\u4e2d\u751f\u6548\u65e5\u671f<=\u5b9a\u8c03\u85aa\u6c47\u7387\u65e5\u671f\u7684\u76f4\u63a5\u6c47\u7387\u8fdb\u884c\u6362\u7b97\u3002{4} 2\uff09\u65e0\u76f4\u63a5\u6c47\u7387\uff1a\u65e0\u76f4\u63a5\u6c47\u7387\uff1a\u53d6\u6c47\u7387\u8868\u4e2d\u751f\u6548\u65e5\u671f<=\u5b9a\u8c03\u85aa\u6c47\u7387\u65e5\u671f\u7684\u95f4\u63a5\u6c47\u7387\u8fdb\u884c\u6362\u7b97\u3002", (String)"DecAdjApprFormUtils_11", (String)"swc-hcdm-formplugin", (Object[])new Object[]{"\r\n", "\r\n", "\r\n", "\r\n", "\r\n"})));
        } else {
            tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u4e00\u3001\u54ea\u79cd\u60c5\u51b5\u4f1a\u8fdb\u884c\u6c47\u7387\u6362\u7b97\uff1a{0} 1\uff09\u5f53\u4e0a\u4e00\u6b21\u4e0e\u672c\u6b21\u8c03\u85aa\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8ba1\u7b97\u8c03\u85aa\u91d1\u989d\u3001\u91d1\u989d\u4f1a\u4f7f\u7528\u6c47\u7387\u8fdb\u884c\u6362\u7b97\u3002{1} 2\uff09\u5f53\u672c\u6b21\u8c03\u85aa\u5e01\u79cd\u4e0e\u85aa\u916c\u6807\u51c6\u8868\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8ba1\u7b97\u85aa\u916c\u6bd4\u7387\u3001\u85aa\u916c\u6e17\u900f\u7387\u4f1a\u4f7f\u7528\u6c47\u7387\u8fdb\u884c\u6362\u7b97\u3002{2} \u4e8c\u3001\u6c47\u7387\u5982\u4f55\u8fdb\u884c\u6362\u7b97\uff1a{3} 1\uff09\u6709\u76f4\u63a5\u6c47\u7387\uff1a\u4f18\u5148\u53d6\u6c47\u7387\u8868\u4e2d\u751f\u6548\u65e5\u671f<=\u8c03\u85aa\u6c47\u7387\u65e5\u671f\u7684\u76f4\u63a5\u6c47\u7387\u8fdb\u884c\u6362\u7b97\u3002{4} 2\uff09\u65e0\u76f4\u63a5\u6c47\u7387\uff1a\u53d6\u6c47\u7387\u8868\u4e2d\u751f\u6548\u65e5\u671f<=\u8c03\u85aa\u6c47\u7387\u65e5\u671f\u7684\u95f4\u63a5\u6c47\u7387\u8fdb\u884c\u6362\u7b97\u3002", (String)"DecAdjApprFormUtils_12", (String)"swc-hcdm-formplugin", (Object[])new Object[]{"\r\n", "\r\n", "\r\n", "\r\n", "\r\n"})));
        }
        exchangeRateDateEdit.addTips(tips);
    }

    public static void setEnable(IFormView view, Boolean value, int rowIndex, String ... ctlKeys) {
        String[] ctlKeysArrays = ctlKeys;
        int ctlKeysLength = ctlKeys.length;
        for (int i = 0; i < ctlKeysLength; ++i) {
            IDataEntityType iDataEntityType;
            IDataEntityProperty iDataEntityProperty;
            String ctlKey = ctlKeysArrays[i];
            Control ctl = view.getControl(ctlKey);
            if (ctl == null || (iDataEntityProperty = ((FieldEdit)ctl).getProperty()) == null || !((iDataEntityType = iDataEntityProperty.getParent()) instanceof EntryType)) continue;
            ((FieldEdit)ctl).setEnable("", value.booleanValue(), rowIndex);
        }
    }

    public static void registerListenerForBaseData(AbstractFormPlugin plugin, Collection<String> baseDataFields) {
        if (CollectionUtils.isEmpty(baseDataFields) || !(plugin instanceof BeforeF7SelectListener) && !(plugin instanceof AfterF7SelectListener)) {
            return;
        }
        for (String baseDataField : baseDataFields) {
            BasedataEdit basedataEdit = (BasedataEdit)plugin.getView().getControl(baseDataField);
            if (basedataEdit == null || !(plugin instanceof BeforeF7SelectListener)) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)plugin);
        }
    }

    public static void setCurrencySign(int[] rowIndexes, IFormView formView, IDataModel billModel, String buildKey) {
        DecAdjApprEntryGrid entryGrid = (DecAdjApprEntryGrid)formView.getControl("adjapprdetailentry");
        EntityType entityType = (EntityType)billModel.getDataEntityType().getAllEntities().get("adjapprdetailentry");
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)entityType.getProperties().get((Object)buildKey);
        for (int rowIndex : rowIndexes) {
            DynamicObject billEntryRow = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            DynamicObject currencyDyObj = (DynamicObject)DynamicObjectValueHelper.dyObjGetValueIfExist((DynamicObject)billEntryRow, (String)buildKey, null);
            entryGrid.setFmtInfo(iDataEntityProperty, currencyDyObj);
        }
    }

    public static void updateCellFmt(int[] rowIndexes, IFormView formView, List<String> buildKey) {
        DecAdjApprEntryGrid entryGrid = (DecAdjApprEntryGrid)formView.getControl("adjapprdetailentry");
        for (int rowIndex : rowIndexes) {
            entryGrid.updateCellFmt(buildKey, rowIndex);
        }
    }

    public static void updateFormatAmountResult(IFormView billView, String attributionType) {
        IDataModel billModel = billView.getModel();
        List<DynamicObject> changedEntryRows = DecAdjApprFormUtils.getChangedEntryRows(billView, billModel);
        Map<String, BigDecimal> changedEntryRowAmountMap = null;
        changedEntryRowAmountMap = AdjAttributionType.DECATTRTYPE.getCode().equals(attributionType) ? DecAdjApprFormUtils.getChangedEntryRowAmountMap(changedEntryRows, "dy_amount") : DecAdjApprFormUtils.getChangedEntryRowAmountMap(changedEntryRows, "dy_actualamount");
        Map<Long, Map<Long, BigDecimal>> amountResultMap = DecAdjApprFormUtils.parseAmountResultMap(billView.getPageCache());
        DecAdjApprFormUtils.removeChangedEntryRowAmount(attributionType, billModel, changedEntryRows, amountResultMap);
        HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>(amountResultMap.size());
        amountResultMap.keySet().forEach(currencyId -> ((Map)amountResultMap.get(currencyId)).keySet().forEach(frequencyId -> {
            BigDecimal cfr_ignored_0 = (BigDecimal)amountMap.putIfAbsent(String.format("%s_%s", currencyId, frequencyId), (BigDecimal)((Map)amountResultMap.get(currencyId)).get(frequencyId));
        }));
        for (Map.Entry amount : amountMap.entrySet()) {
            String amountKey = (String)amount.getKey();
            BigDecimal changedEntryRowAmount = changedEntryRowAmountMap.get(amountKey);
            if (changedEntryRowAmount == null) continue;
            amountMap.put(amountKey, ((BigDecimal)amount.getValue()).add(changedEntryRowAmount));
            changedEntryRowAmountMap.remove(amountKey);
        }
        List amountResultList = DecAdjApprGridHelper.getFormatAmountResult(amountMap, (IDataModel)billModel);
        List propChangeAmountResult = DecAdjApprGridHelper.getFormatAmountResult(changedEntryRowAmountMap, (IDataModel)billModel);
        amountResultList.addAll(propChangeAmountResult);
        Collections.sort(amountResultList);
        Label totalAmountLabel = (Label)billView.getControl("adjtotalamount");
        totalAmountLabel.setText(CollectionUtils.isEmpty((Collection)amountResultList) ? "0" : StringUtils.join((Object[])amountResultList.toArray(), (String)"+"));
        billView.updateView("statisticpanel");
    }

    private static Map<String, BigDecimal> getChangedEntryRowAmountMap(List<DynamicObject> changedEntryRows, String columnKey) {
        return changedEntryRows.stream().filter(changedEntryRow -> changedEntryRow.getBigDecimal(columnKey) != null).collect(Collectors.groupingBy(key -> String.format("%s_%s", key.getLong("dy_currency.id"), key.getLong("dy_frequency.id")), Collectors.mapping(value -> value.getBigDecimal(columnKey), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
    }

    private static Map<Long, Map<Long, BigDecimal>> parseAmountResultMap(IPageCache pageCache) {
        Map amountResultMap = (Map)JSON.parseObject((String)pageCache.get("amountResultMap"), (TypeReference)new TypeReference<Map<String, BigDecimal>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
        HashMap<Long, Map<Long, BigDecimal>> newAmountResultMap = new HashMap<Long, Map<Long, BigDecimal>>(amountResultMap.size());
        for (Map.Entry entry : amountResultMap.entrySet()) {
            String currFreqGroupKey = (String)entry.getKey();
            BigDecimal amount = (BigDecimal)entry.getValue();
            Long[] currFreqGroupKeys = (Long[])ConvertUtils.convert((String[])currFreqGroupKey.split("_"), Long.class);
            newAmountResultMap.computeIfAbsent(currFreqGroupKeys[0], o1 -> Maps.newHashMap());
            if (newAmountResultMap.get(currFreqGroupKeys[0]) != null) {
                ((Map)newAmountResultMap.get(currFreqGroupKeys[0])).putIfAbsent(currFreqGroupKeys[1], amount);
                continue;
            }
            HashMap<Long, BigDecimal> freqToAmountMap = new HashMap<Long, BigDecimal>(1);
            freqToAmountMap.putIfAbsent(currFreqGroupKeys[1], amount);
            newAmountResultMap.put(currFreqGroupKeys[0], freqToAmountMap);
        }
        return newAmountResultMap;
    }

    private static void removeChangedEntryRowAmount(String attributionType, IDataModel billModel, List<DynamicObject> changedEntryRows, Map<Long, Map<Long, BigDecimal>> currFreqToAmountMap) {
        DynamicObject[] adjApprPersonObjs;
        Set changeEntryIdSet = changedEntryRows.stream().map(dyObj -> dyObj.getLong("adjperentryid")).collect(Collectors.toSet());
        List changeAdjPersonIdList = changedEntryRows.stream().map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList());
        AdjApprPerQueryParam adjApprPerQueryParam = new AdjApprPerQueryParam();
        Long pkValue = (Long)billModel.getDataEntity().getPkValue();
        adjApprPerQueryParam.setAdjApprBillIds((List)Lists.newArrayList((Object[])new Long[]{pkValue}));
        adjApprPerQueryParam.setAdjPersonIdList(changeAdjPersonIdList);
        for (DynamicObject adjApprPersonObj : adjApprPersonObjs = DecAdjApprGridHelper.getAdjApprPersonData((String)"id, entryentity, entryentity.currency, entryentity.frequency, entryentity.amount, entryentity.actualamount", (AdjApprPerQueryParam)adjApprPerQueryParam)) {
            DynamicObjectCollection adjApprPersonEntryObjs = adjApprPersonObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprPersonEntryObj : adjApprPersonEntryObjs) {
                BigDecimal amount;
                Map<Long, BigDecimal> freqToAmountMap;
                if (!changeEntryIdSet.contains(adjApprPersonEntryObj.getLong("id"))) continue;
                long currencyId = adjApprPersonEntryObj.getLong("currency.id");
                long frequencyId = adjApprPersonEntryObj.getLong("frequency.id");
                BigDecimal entryAmount = null;
                entryAmount = AdjAttributionType.DECATTRTYPE.getCode().equals(attributionType) ? adjApprPersonEntryObj.getBigDecimal("amount") : adjApprPersonEntryObj.getBigDecimal("actualamount");
                if (Objects.isNull(entryAmount) || !MapUtils.isNotEmpty(freqToAmountMap = currFreqToAmountMap.get(currencyId)) || Objects.isNull(amount = freqToAmountMap.get(frequencyId))) continue;
                if (amount.subtract(entryAmount).compareTo(BigDecimal.ZERO) == 0) {
                    freqToAmountMap.remove(frequencyId);
                    continue;
                }
                freqToAmountMap.put(frequencyId, amount.subtract(entryAmount));
            }
        }
    }

    public static void saveEntryDataBeforeAddFile(IFormView billView, IDataModel billModel) {
        DecAdjApprFormUtils.saveAdjApprChangedEntryRows(billView, billModel);
    }

    public static void saveEntryDataBeforePageInfoChange(IFormView billView, IDataModel billModel) {
        DecAdjApprFormUtils.saveAdjApprChangedEntryRows(billView, billModel);
    }

    public static void deleteAllEntryRows(IDataModel billModel) {
        DynamicObject dataEntity = billModel.getDataEntity(true);
        dataEntity.set("isdraft", (Object)YesOrNoEnum.YES.getCode());
        Object pkValue = dataEntity.getPkValue();
        DecAdjApprGridHelper.deleteAllEntryRows((Long)((Long)pkValue), (DynamicObject)dataEntity);
    }

    public static void doDeleteEntryIfDeleteStdItem(IFormView billView, List<Long> stdItemOldIdList, DynamicObject[] adjPersonDyObjs) {
        DynamicObject dataEntity = billView.getModel().getDataEntity(true);
        dataEntity.set("isdraft", (Object)YesOrNoEnum.YES.getCode());
        DecAdjApprGridHelper.deleteEntryIfDeleteStdItem((DynamicObject)dataEntity, stdItemOldIdList, (DynamicObject[])adjPersonDyObjs);
    }

    public static void updateEntryRowIfCurrencyChange(IFormView billView, String attributionType, DynamicObjectType adjPersonEntityType) {
        IDataModel billModel = billView.getModel();
        Object currency = billModel.getValue("currency");
        DynamicObject dataEntity = billModel.getDataEntity(true);
        EntityType entityType = (EntityType)billModel.getDataEntityType().getAllEntities().get("adjapprdetailentry");
        DecAdjApprFormUtils.saveAdjApprChangedEntryRows(billView, billModel);
        dataEntity.set("isdraft", (Object)YesOrNoEnum.YES.getCode());
        if (AdjAttributionType.DECATTRTYPE.getCode().equals(attributionType)) {
            DecAdjApprGridHelper.updateEntryRowData((DynamicObject)dataEntity, (EntityType)entityType, (Object)currency);
        } else {
            DecAdjApprGridHelper.calcAdjRangeAndAmount((DynamicObject)dataEntity, (EntityType)entityType, (Object)currency);
        }
    }

    public static void updateEntryRowData(IFormView billView) {
        IDataModel billModel = billView.getModel();
        int rowCount = billModel.getEntryRowCount("adjapprdetailentry");
        if (rowCount > 0) {
            DynamicObject dataEntity = billModel.getDataEntity(true);
            EntityType entityType = (EntityType)billModel.getDataEntityType().getAllEntities().get("adjapprdetailentry");
            DecAdjApprFormUtils.saveAdjApprChangedEntryRows(billView, billModel);
            DecAdjApprGridHelper.updateEntryRowData((DynamicObject)dataEntity, (EntityType)entityType, null);
        }
    }

    public static void copyEntryRows(IFormView billView, IDataModel billModel, DynamicObjectType adjPersonEntityType) {
        EntryGrid entryGrid = (EntryGrid)billView.getControl("adjapprdetailentry");
        int[] beCopyRows = entryGrid.getSelectRows();
        ArrayList<DynamicObject> beCopyRowDyObjList = new ArrayList<DynamicObject>(10);
        for (int beCopyRowIndex : beCopyRows) {
            beCopyRowDyObjList.add(billModel.getEntryRowEntity("adjapprdetailentry", beCopyRowIndex));
        }
        EntityType entityType = (EntityType)billModel.getDataEntityType().getAllEntities().get("adjapprdetailentry");
        DecAdjApprFormUtils.saveAdjApprChangedEntryRows(billView, billModel);
        DynamicObject dataEntity = billModel.getDataEntity(true);
        if (CollectionUtils.isNotEmpty(beCopyRowDyObjList)) {
            DecAdjApprGridHelper.copyEntryRows(beCopyRowDyObjList, (DynamicObject)dataEntity, (DynamicObjectType)adjPersonEntityType, (EntityType)entityType);
        }
    }

    public static void deleteEntryRows(IFormView billView, IDataModel billModel, String selectRowIds) {
        DecAdjApprFormUtils.saveAdjApprChangedEntryRows(billView, billModel);
        DynamicObject dataEntity = billModel.getDataEntity(true);
        DecAdjApprGridHelper.deleteEntryRows((DynamicObject)dataEntity, (String)selectRowIds);
    }

    public static void saveAdjApprChangedEntryRows(IFormView billView, IDataModel billModel) {
        boolean isWfApprPage;
        Set changedPropertySet;
        Map changedPropertyMap;
        IPageCache pageCache = billView.getPageCache();
        String attributionType = DecAdjApprGridHelper.getAttributionType((IDataModel)billModel);
        String changedEntryRowIndexes = pageCache.get("changedEntryRow");
        DynamicObject dataEntity = billModel.getDataEntity(true);
        if (StringUtils.isNotEmpty((String)changedEntryRowIndexes)) {
            dataEntity.set("isdraft", (Object)YesOrNoEnum.YES.getCode());
        }
        if (MapUtils.isNotEmpty((Map)(changedPropertyMap = (Map)JSON.parseObject((String)pageCache.get("changedPropertyMap"), (TypeReference)new TypeReference<Map<Integer, Set<String>>>(){}, (Feature[])new Feature[]{Feature.OrderedField}))) && CollectionUtils.isNotEmpty((Collection)(changedPropertySet = (Set)changedPropertyMap.get(-1)))) {
            dataEntity.set("isdraft", (Object)YesOrNoEnum.YES.getCode());
        }
        boolean bl = isWfApprPage = AdjAttributionType.ADJATTRTYPE.getCode().equals(attributionType) && DecAdjApprFormUtils.isAuditView(billView.getFormShowParameter());
        if (isWfApprPage) {
            dataEntity.set("isdraft", (Object)YesOrNoEnum.NO.getCode());
        }
        Long adjFieldCfgId = (Long)billView.getFormShowParameter().getCustomParam("adjfieldcfgid");
        billModel.setValue("adjfieldcfg", (Object)adjFieldCfgId);
        OperateOption option = OperateOption.create();
        option.setVariableValue("changeEntryRowIndex", changedEntryRowIndexes);
        OperationServiceImpl operationServiceImpl = new OperationServiceImpl();
        ArrayList adjApprBillDyObjList = Lists.newArrayList((Object[])new DynamicObject[]{dataEntity});
        operationServiceImpl.localInvokeOperation("savedraft", adjApprBillDyObjList.toArray(new DynamicObject[0]), option);
    }

    public static List<DynamicObject> getChangedEntryRows(IFormView billView, IDataModel billModel) {
        IPageCache pageCache = billView.getPageCache();
        Set changedEntryRowIdSet = (Set)JSON.parseObject((String)pageCache.get("changedEntryRow"), (TypeReference)new TypeReference<Set<Integer>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
        ArrayList<DynamicObject> changedEntryRows = new ArrayList<DynamicObject>();
        if (!CollectionUtils.isEmpty((Collection)changedEntryRowIdSet)) {
            for (Integer rowIndex : changedEntryRowIdSet) {
                DynamicObject entryRowEntity = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex.intValue());
                changedEntryRows.add(entryRowEntity);
            }
        }
        return changedEntryRows;
    }

    public static void batchCopyGradeAndRank(Map<String, List<Tuple<Integer, Object>>> columnMap, IFormView billView) {
        IDataModel billModel = billView.getModel();
        Set<String> beCopyColumnKeys = columnMap.keySet();
        ArrayList rowIndexesList = new ArrayList(columnMap.size());
        columnMap.values().stream().forEach(item -> item.stream().forEach(tuple -> rowIndexesList.add(tuple.item1)));
        int[] rowIndexes = rowIndexesList.stream().distinct().mapToInt(Integer::intValue).toArray();
        DecAdjApprFormUtils.collectChangeRowIndex(rowIndexes, billView);
        Set<Long> salaryStdIdSet = DecAdjApprFormUtils.getBeCopyEntryRowStdIds(rowIndexes, billModel);
        DecAdjApprFormUtils.compareSetNewGradeOrRankId(columnMap, rowIndexes, salaryStdIdSet, billModel);
        Map<Long, Map<Long, Boolean>> itemUseRankFlag = DecAdjApprFormUtils.getItemUseRankFlag(rowIndexes, billModel);
        Map<Integer, Boolean> itemUseRankMap = DecAdjApprFormUtils.checkItemUseRank(rowIndexes, billModel, itemUseRankFlag);
        List<StdAmountAndSalaryCountQueryResult> salaryStdAmountQueryResult = DecAdjApprFormUtils.getStdAmountQueryResult(rowIndexes, billModel);
        DecAdjApprFormUtils.calcAmountByGradeOrRank(rowIndexes, billModel, itemUseRankMap, salaryStdAmountQueryResult);
        DecAdjApprFormUtils.calcDecAdjFinalAmount(rowIndexes, billModel, null);
        if (beCopyColumnKeys.contains("dy_amount")) {
            DecAdjApprFormUtils.setRowAmountByBeCopyedAmount(columnMap, billView);
        }
        DecAdjApprFormUtils.setLogicAmount(rowIndexes, billModel);
        DecAdjApprFormUtils.setCalcFieldAfter(rowIndexes, billModel);
        String attributionType = DecAdjApprGridHelper.getAttributionType((IDataModel)billModel);
        if (AdjAttributionType.ADJATTRTYPE.getCode().equals(attributionType)) {
            DecAdjApprFormUtils.calcAdjAmountWithChangeData("3", "calcWithAmount", rowIndexes, billModel, null, null);
        }
        DecAdjApprFormUtils.setOverStandardType(rowIndexes, billView, billModel);
    }

    public static void setRowAmountByBeCopyedAmount(Map<String, List<Tuple<Integer, Object>>> columnMap, IFormView billView) {
        List<Tuple<Integer, Object>> copyAmountList = columnMap.get("dy_amount");
        ArrayList rowIndexesList = new ArrayList(copyAmountList.size());
        columnMap.values().stream().forEach(item -> item.stream().forEach(tuple -> rowIndexesList.add(tuple.item1)));
        if (CollectionUtils.isNotEmpty(rowIndexesList)) {
            int[] rowIndexes = rowIndexesList.stream().distinct().mapToInt(Integer::intValue).toArray();
            HashMap<Integer, Object> copyAmountMap = new HashMap<Integer, Object>(copyAmountList.size());
            for (Tuple<Integer, Object> copyAmountTuple : copyAmountList) {
                copyAmountMap.put((Integer)copyAmountTuple.item1, copyAmountTuple.item2);
            }
            IDataModel billModel = billView.getModel();
            for (int rowIndex : rowIndexes) {
                String amount = (String)copyAmountMap.get(rowIndex);
                if (StringUtils.isEmpty((String)amount)) {
                    DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_amount", null, rowIndex);
                    continue;
                }
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_amount", amount, rowIndex);
            }
        }
    }

    private static void compareSetNewGradeOrRankId(Map<String, List<Tuple<Integer, Object>>> columnMap, int[] rowIndexes, Set<Long> salaryStdIdSet, IDataModel billModel) {
        List<Tuple<Integer, Object>> gradeTuples = columnMap.get("dy_grade");
        List<Tuple<Integer, Object>> rankTuples = columnMap.get("dy_rank");
        Map gradeMap = GradeRankHelper.queryGradeData(salaryStdIdSet);
        Map rankMap = GradeRankHelper.queryRankData(salaryStdIdSet);
        block0: for (int rowIndex : rowIndexes) {
            Map rankEntityMap;
            Map<String, Long> rankNameToIdMap;
            DynamicObject billEntryRow = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            long salaryStdId = billEntryRow.getLong("dy_salarystd.id");
            String salaryToGradeAndRankRel = billEntryRow.getString("dy_salargrel");
            Map matchRangeMap = (Map)JSON.parseObject((String)salaryToGradeAndRankRel, (TypeReference)new TypeReference<Map<Long, List<Long>>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
            if (salaryStdId == 0L || MapUtils.isEmpty((Map)matchRangeMap)) continue;
            Map gradeEntityMap = (Map)gradeMap.get(salaryStdId);
            Map<String, Long> gradeNameToIdMap = gradeEntityMap.values().stream().collect(Collectors.toMap(SalaryGradeEntity::getGradeName, SalaryGradeEntity::getId));
            if (MapUtils.isNotEmpty(gradeNameToIdMap) && !CollectionUtils.isEmpty(gradeTuples)) {
                for (Tuple<Integer, Object> gradeTuple : gradeTuples) {
                    Long gradeId = gradeNameToIdMap.get(gradeTuple.item2);
                    Set gradeIdSet = matchRangeMap.keySet();
                    if (((Integer)gradeTuple.item1).equals(rowIndex) && !Objects.isNull(gradeId) && gradeIdSet.contains(gradeId)) {
                        DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_grade", gradeId, rowIndex);
                        break;
                    }
                    DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_grade", null, rowIndex);
                    DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_amount", null, rowIndex);
                    DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_stdamount", null, rowIndex);
                    DecAdjApprFormUtils.calcDataWhenGradeChange(new int[]{rowIndex}, billModel);
                }
            }
            if (!MapUtils.isNotEmpty(rankNameToIdMap = (rankEntityMap = (Map)rankMap.get(salaryStdId)).values().stream().collect(Collectors.toMap(SalaryRankEntity::getRankName, SalaryRankEntity::getId))) || CollectionUtils.isEmpty(rankTuples)) continue;
            for (Tuple<Integer, Object> rankTuple : rankTuples) {
                Long rankId = rankNameToIdMap.get(rankTuple.item2);
                if (((Integer)rankTuple.item1).equals(rowIndex) && !Objects.isNull(rankId)) {
                    DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_rank", rankId, rowIndex);
                    continue block0;
                }
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_rank", null, rowIndex);
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_amount", null, rowIndex);
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_stdamount", null, rowIndex);
                DecAdjApprFormUtils.calcDataWhenGradeChange(new int[]{rowIndex}, billModel);
            }
        }
    }

    private static Set<Long> getBeCopyEntryRowStdIds(int[] rowIndexes, IDataModel billModel) {
        HashSet<Long> salaryStdIdSet = new HashSet<Long>(16);
        for (int rowIndex : rowIndexes) {
            DynamicObject billEntryRow = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            Long salaryStdId = billEntryRow.getLong("dy_salarystd.id");
            salaryStdIdSet.add(salaryStdId);
        }
        return salaryStdIdSet;
    }

    public static void collectChangeRowIndex(int[] rowIndexes, IFormView billView) {
        IPageCache pageCache = billView.getPageCache();
        HashSet<Integer> changedEntryRowIdSet = (HashSet<Integer>)JSON.parseObject((String)pageCache.get("changedEntryRow"), (TypeReference)new TypeReference<Set<Integer>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
        if (CollectionUtils.isEmpty((Collection)changedEntryRowIdSet)) {
            changedEntryRowIdSet = new HashSet<Integer>(16);
            for (int rowIndex : rowIndexes) {
                changedEntryRowIdSet.add(rowIndex);
            }
        } else {
            for (int rowIndex : rowIndexes) {
                changedEntryRowIdSet.add(rowIndex);
            }
        }
        pageCache.put("changedEntryRow", JSON.toJSONString(changedEntryRowIdSet));
    }

    public static void calcAdjRangeAndAmount(IFormView billView, IDataModel billModel) {
        DynamicObjectCollection billEntryRows = billModel.getEntryEntity("adjapprdetailentry");
        if (CollectionUtils.isEmpty((Collection)billEntryRows)) {
            return;
        }
        DynamicObject dataEntity = billModel.getDataEntity(true);
        EntityType entityType = (EntityType)billModel.getDataEntityType().getAllEntities().get("adjapprdetailentry");
        DecAdjApprFormUtils.saveAdjApprChangedEntryRows(billView, billModel);
        DecAdjApprGridHelper.calcAdjRangeAndAmount((DynamicObject)dataEntity, (EntityType)entityType, null);
    }

    public static boolean validateAdjApprBillMustInput(IFormView billView, FormOperate source) {
        IDataModel billModel = billView.getModel();
        List<LocaleString> checkRequiredList = DecAdjApprFormUtils.checkRequired(billModel);
        if (CollectionUtils.isNotEmpty(checkRequiredList)) {
            String content = null;
            content = "donothing_addperson".equals(source.getOperateKey()) || "donothing_import".equals(source.getOperateKey()) || "donothing_export".equals(source.getOperateKey()) || "donothing_deleteentryrow".equals(source.getOperateKey()) || "donothing_copyentryrow".equals(source.getOperateKey()) ? ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u57fa\u672c\u4fe1\u606f\u4e2d\u7684\u201c%1$s\u201d\u3002", (String)"DecAdjApprFormUtils_6", (String)"swc-hcdm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u57fa\u672c\u4fe1\u606f\u4e2d\u7684\u201c%1$s\u201d\u3002", (String)"DecAdjApprFormUtils_8", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            if (checkRequiredList.size() == 1) {
                LocaleString localeString = checkRequiredList.get(0);
                String errorMsg = String.format(Locale.ROOT, content, localeString.getLocaleValue());
                billView.showTipNotification(errorMsg);
            } else {
                ArrayList<String> errorMsgList = new ArrayList<String>(checkRequiredList.size());
                for (LocaleString checkRequired : checkRequiredList) {
                    errorMsgList.add(String.format(Locale.ROOT, content, checkRequired.getLocaleValue()));
                }
                LocaleString operateName = source.getOperateName();
                if ("donothing_addperson".equals(source.getOperateKey())) {
                    String attributionType = DecAdjApprGridHelper.getAttributionType((IDataModel)billModel);
                    operateName = new LocaleString(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6dfb\u52a0%1$s\u4eba\u5458", (String)"DecAdjApprFormUtils_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), AdjAttributionType.getByCode((String)attributionType).getDisplayName()));
                }
                String title = null;
                if ("donothing_addperson".equals(source.getOperateKey()) || "donothing_import".equals(source.getOperateKey()) || "donothing_export".equals(source.getOperateKey()) || "donothing_deleteentryrow".equals(source.getOperateKey()) || "donothing_copyentryrow".equals(source.getOperateKey())) {
                    title = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u5931\u8d25", (String)"DecAdjApprFormUtils_7", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), operateName.getLocaleValue());
                } else {
                    String billNo = billView.getModel().getDataEntity().getString("billno");
                    title = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d%2$s\u5931\u8d25", (String)"AdjApproveBillEdit_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), billNo, operateName.getLocaleValue());
                }
                FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)operateName.getLocaleValue(), (String)title, errorMsgList);
                billView.showForm(parameters);
            }
            return true;
        }
        return false;
    }

    private static List<LocaleString> checkRequired(IDataModel billModel) {
        String attributionType = DecAdjApprGridHelper.getAttributionType((IDataModel)billModel);
        Map propertyMap = billModel.getDataEntityType().getFields();
        List mustInputFieldList = DecAdjApprGridHelper.collectMustInputFieldList((Map)propertyMap);
        ArrayList<LocaleString> checkRequiredList = new ArrayList<LocaleString>();
        for (String mustInputField : mustInputFieldList) {
            IDataEntityProperty property = (IDataEntityProperty)propertyMap.get(mustInputField);
            LocaleString displayName = property.getDisplayName();
            String mustInputValue = billModel.getDataEntity().getString(mustInputField);
            if ("billname".equals(mustInputField)) {
                if (!StringUtils.isEmpty((String)mustInputValue)) continue;
                checkRequiredList.add(displayName);
                continue;
            }
            if ("caltype".equals(mustInputField)) {
                if (!AdjAttributionType.ADJATTRTYPE.getCode().equals(attributionType) || !StringUtils.isEmpty((String)mustInputValue)) continue;
                checkRequiredList.add(displayName);
                continue;
            }
            if (!StringUtils.isEmpty((String)mustInputValue)) continue;
            checkRequiredList.add(displayName);
        }
        return checkRequiredList;
    }

    public static void setIsMatchStdGradeRankInfo(int[] rowIndexes, IDataModel billModel, Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult) {
        for (int rowIndex : rowIndexes) {
            DynamicObject billEntryRow = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            SalaryStdMatchResultNew salaryStdMatchResult = DecAdjApprFormUtils.getSalaryStdMatchResult(matchStdResult, billEntryRow);
            String isMatchGradeRank = salaryStdMatchResult.getIsMatchGradeRank();
            if (!SWCStringUtils.equals((String)"1", (String)isMatchGradeRank)) {
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_grade", null, rowIndex);
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_rank", null, rowIndex);
            }
            if (!Objects.isNull(salaryStdMatchResult.getGradeId()) && 0L != salaryStdMatchResult.getGradeId()) continue;
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_salarypercent", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_salaryseeprate", null, rowIndex);
        }
    }

    public static void calcAdjAmountWithChangeData(String sceneType, String changeType, int[] rowIndexes, IDataModel model, Map<Integer, Map<String, Object>> excelChangeData, String operateType) {
        DynamicObject billEntity = model.getDataEntity();
        BillExRateManager rateManager = new BillExRateManager();
        for (int rowIndex : rowIndexes) {
            DynamicObject billEntryRow = model.getEntryRowEntity("adjapprdetailentry", rowIndex);
            if (billEntryRow == null) continue;
            if (!DecAdjApprFormUtils.isNeedCalculate(billEntity, billEntryRow, rateManager)) {
                if (MapUtils.isNotEmpty(excelChangeData)) {
                    DecAdjApprFormUtils.coverModelDataWithExcel(rowIndex, excelChangeData.get(rowIndex), model);
                }
                DecAdjApprFormUtils.clearAmountRelateFields(rowIndex, model);
                continue;
            }
            if (sceneType.equals(CalcSceneType.EXCEL_IMPORT_ADD.getCode())) {
                DecAdjApprFormUtils.excelImportAddCacl(rowIndex, billEntryRow, model, billEntity, rateManager);
                continue;
            }
            if (sceneType.equals(CalcSceneType.EXCEL_IMPORT_UPDATE.getCode())) {
                DecAdjApprFormUtils.excelImportChangeCacl(rowIndex, billEntryRow, model, billEntity, rateManager, excelChangeData);
                continue;
            }
            if (!sceneType.equals(CalcSceneType.PAGE_CALC.getCode())) continue;
            DecAdjApprFormUtils.pageChangeCacl(rowIndex, changeType, model, billEntity, rateManager, billEntryRow, CalcSceneType.PAGE_CALC, operateType);
        }
    }

    private static void clearAmountRelateFields(int rowIndex, IDataModel model) {
        DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_suggestminamount", null, rowIndex);
        DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_suggestmaxamount", null, rowIndex);
        DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_actualamount", null, rowIndex);
        DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_amount", null, rowIndex);
    }

    private static void excelImportAddCacl(int rowIndex, DynamicObject billEntryRow, IDataModel model, DynamicObject billEntity, BillExRateManager rateManager) {
        String calType = null;
        String calcType = billEntryRow.getString("dy_calctype");
        BigDecimal actualrange = billEntryRow.getBigDecimal("dy_actualrange");
        BigDecimal actualamount = billEntryRow.getBigDecimal("dy_actualamount");
        BigDecimal amount = billEntryRow.getBigDecimal("dy_amount");
        if (amount != null) {
            calType = "calcWithAmount";
        } else if (actualrange != null && CalcType.RATIO.getCode().equals(calcType)) {
            calType = "calcWithActualRange";
        } else if (actualamount != null && CalcType.AMOUNT.getCode().equals(calcType)) {
            calType = "calcWithActualAmount";
        }
        DecAdjApprFormUtils.adjEntryCacl(rowIndex, calType, model, billEntity, rateManager, billEntryRow, CalcSceneType.EXCEL_IMPORT_ADD, null);
    }

    private static void excelImportChangeCacl(int rowIndex, DynamicObject billEntryRow, IDataModel model, DynamicObject billEntity, BillExRateManager rateManager, Map<Integer, Map<String, Object>> excelChangeData) {
        if (MapUtils.isNotEmpty(excelChangeData)) {
            String calType = DecAdjApprFormUtils.judgeCalcType(rowIndex, excelChangeData.get(rowIndex), model);
            if (calType == null) {
                return;
            }
            if (!calType.equals("calcWithCurExchange")) {
                DecAdjApprFormUtils.coverModelDataWithExcel(rowIndex, excelChangeData.get(rowIndex), model);
            }
            DecAdjApprFormUtils.adjEntryCacl(rowIndex, calType, model, billEntity, rateManager, billEntryRow, CalcSceneType.EXCEL_IMPORT_UPDATE, null);
        }
    }

    private static void pageChangeCacl(int rowIndex, String calType, IDataModel model, DynamicObject billEntity, BillExRateManager rateManager, DynamicObject billEntryRow, CalcSceneType sceneType, String operateType) {
        DecAdjApprFormUtils.adjEntryCacl(rowIndex, calType, model, billEntity, rateManager, billEntryRow, sceneType, operateType);
        if (calType.equals("calcWithSuggestAmount")) {
            DecAdjApprFormUtils.calcWithSuggestAmount(model, billEntity, rateManager, rowIndex, billEntryRow);
        } else if (calType.equals("calcWithSuggestRange")) {
            DecAdjApprFormUtils.calcWithSuggestRange(model, billEntity, rateManager, rowIndex, billEntryRow);
        }
    }

    private static void adjEntryCacl(int rowIndex, String calType, IDataModel model, DynamicObject billEntity, BillExRateManager rateManager, DynamicObject billEntryRow, CalcSceneType sceneType, String operateType) {
        if (calType == null) {
            return;
        }
        if (calType.equals("calcWithAmount")) {
            DecAdjApprFormUtils.calcWithAmount(model, billEntity, rateManager, rowIndex, billEntryRow, sceneType, operateType);
        } else if (calType.equals("calcWithActualRange")) {
            DecAdjApprFormUtils.calcWithActualRange(model, billEntity, rateManager, rowIndex, billEntryRow, sceneType);
        } else if (calType.equals("calcWithActualAmount")) {
            DecAdjApprFormUtils.calcWithActualAmount(model, billEntity, rateManager, rowIndex, billEntryRow, sceneType);
        } else if (calType.equals("calcWithCurExchange")) {
            DecAdjApprFormUtils.calcWithCurExchange(model, billEntity, rateManager, rowIndex, billEntryRow, operateType);
        }
    }

    private static void coverModelDataWithExcel(int rowIndex, Map<String, Object> excelMap, IDataModel model) {
        if (MapUtils.isNotEmpty(excelMap)) {
            Object excAmount;
            Object excActualamount;
            BigDecimal actualrange = null;
            BigDecimal actualamount = null;
            BigDecimal amount = null;
            Object excActualrange = excelMap.get("dy_actualrange");
            if (ObjectUtils.isNotEmpty((Object)excActualrange)) {
                actualrange = new BigDecimal(excActualrange.toString());
            }
            if (ObjectUtils.isNotEmpty((Object)(excActualamount = excelMap.get("dy_actualamount")))) {
                actualamount = new BigDecimal(excActualamount.toString());
            }
            if (ObjectUtils.isNotEmpty((Object)(excAmount = excelMap.get("dy_amount")))) {
                amount = new BigDecimal(excAmount.toString());
            }
            DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_actualrange", actualrange, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_actualamount", actualamount, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_amount", amount, rowIndex);
        }
    }

    private static String judgeCalcType(int rowIndex, Map<String, Object> excelMap, IDataModel model) {
        if (MapUtils.isNotEmpty(excelMap)) {
            DynamicObject billEntryRow = model.getEntryRowEntity("adjapprdetailentry", rowIndex);
            BigDecimal actualrange = billEntryRow.getBigDecimal("dy_actualrange");
            BigDecimal actualamount = billEntryRow.getBigDecimal("dy_actualamount");
            BigDecimal amount = billEntryRow.getBigDecimal("dy_amount");
            Object excelActualrange = excelMap.get("dy_actualrange");
            Object excelActualamount = excelMap.get("dy_actualamount");
            Object excelAmount = excelMap.get("dy_amount");
            Object isCurrencyChange = excelMap.get("dy_currency");
            if (ObjectUtils.isNotEmpty((Object)excelAmount)) {
                if (DecAdjApprFormUtils.isChange(excelAmount, amount)) {
                    return "calcWithAmount";
                }
                if (ObjectUtils.isNotEmpty((Object)isCurrencyChange) && ((Boolean)isCurrencyChange).booleanValue()) {
                    return "calcWithCurExchange";
                }
            }
            String calcType = billEntryRow.getString("dy_calctype");
            if (CalcType.RATIO.getCode().equals(calcType)) {
                if (DecAdjApprFormUtils.isChange(excelActualrange, actualrange)) {
                    return "calcWithActualRange";
                }
            } else if (CalcType.AMOUNT.getCode().equals(calcType) && DecAdjApprFormUtils.isChange(excelActualamount, actualamount)) {
                return "calcWithActualAmount";
            }
            if (ObjectUtils.isNotEmpty((Object)isCurrencyChange) && ((Boolean)isCurrencyChange).booleanValue()) {
                return "calcWithCurExchange";
            }
        }
        return null;
    }

    private static boolean isChange(Object excelObj, BigDecimal billObj) {
        boolean isChange = false;
        if (ObjectUtils.isEmpty((Object)excelObj)) {
            if (billObj != null) {
                isChange = true;
            }
        } else if (billObj == null) {
            isChange = true;
        } else {
            BigDecimal obj = new BigDecimal(excelObj.toString());
            if (obj.compareTo(billObj) != 0) {
                isChange = true;
            }
        }
        return isChange;
    }

    public static void calcWithActualRange(IDataModel model, DynamicObject billEntity, BillExRateManager rateManager, int rowIndex, DynamicObject billEntryRow, CalcSceneType sceneType) {
        String calcType = billEntryRow.getString("dy_calctype");
        if (CalcType.RATIO.getCode().equals(calcType)) {
            BigDecimal presalary = (BigDecimal)DynamicObjectValueHelper.dyObjGetValueIfExist((DynamicObject)billEntryRow, (String)"dy_presalary", null);
            BigDecimal actualrange = billEntryRow.getBigDecimal("dy_actualrange");
            BigDecimal actualAmount = billEntryRow.getBigDecimal("dy_actualamount");
            BigDecimal amount = billEntryRow.getBigDecimal("dy_amount");
            if (presalary != null && presalary.compareTo(BigDecimal.ZERO) >= 0) {
                if (actualrange != null) {
                    presalary = DecAdjApprFormUtils.getCalPresalary(rowIndex, billEntity, billEntryRow, rateManager, model, presalary);
                    actualAmount = presalary.multiply(actualrange.multiply(BigDecimal.valueOf(0.01)));
                    amount = presalary.add(actualAmount);
                } else {
                    amount = actualAmount = null;
                }
            }
            DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_actualrange", actualrange, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_actualamount", actualAmount, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_amount", amount, rowIndex);
            if (!CalcSceneType.PAGE_CALC.getCode().equals(sceneType.getCode())) {
                DecAdjApprFormUtils.calcAmount(rowIndex, presalary, model, billEntryRow);
            }
        }
    }

    public static void calcWithActualAmount(IDataModel model, DynamicObject billEntity, BillExRateManager rateManager, int rowIndex, DynamicObject billEntryRow, CalcSceneType sceneType) {
        String calcType = billEntryRow.getString("dy_calctype");
        if (CalcType.AMOUNT.getCode().equals(calcType)) {
            BigDecimal presalary = (BigDecimal)DynamicObjectValueHelper.dyObjGetValueIfExist((DynamicObject)billEntryRow, (String)"dy_presalary", null);
            BigDecimal actualamount = billEntryRow.getBigDecimal("dy_actualamount");
            BigDecimal actualrange = null;
            BigDecimal amount = null;
            if (presalary != null && presalary.compareTo(BigDecimal.ZERO) > 0) {
                if (actualamount != null) {
                    presalary = DecAdjApprFormUtils.getCalPresalary(rowIndex, billEntity, billEntryRow, rateManager, model, presalary);
                    actualrange = actualamount.divide(presalary, 10, 4).multiply(BigDecimal.valueOf(100L));
                    amount = presalary.add(actualamount);
                }
            } else {
                actualrange = null;
                amount = actualamount;
            }
            DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_actualrange", actualrange, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_amount", amount, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_actualamount", actualamount, rowIndex);
            if (!CalcSceneType.PAGE_CALC.getCode().equals(sceneType.getCode())) {
                DecAdjApprFormUtils.calcRatio(rowIndex, presalary, model, billEntryRow);
            }
        }
    }

    public static void calcWithCurExchange(IDataModel model, DynamicObject billEntity, BillExRateManager rateManager, int rowIndex, DynamicObject billEntryRow, String operateType) {
        BigDecimal presalary = (BigDecimal)DynamicObjectValueHelper.dyObjGetValueIfExist((DynamicObject)billEntryRow, (String)"dy_presalary", null);
        BigDecimal actualrange = billEntryRow.getBigDecimal("dy_actualrange");
        BigDecimal actualamount = billEntryRow.getBigDecimal("dy_actualamount");
        BigDecimal amount = billEntryRow.getBigDecimal("dy_amount");
        String calcType = billEntryRow.getString("dy_calctype");
        if (presalary != null && presalary.compareTo(BigDecimal.ZERO) > 0) {
            presalary = DecAdjApprFormUtils.getCalPresalary(rowIndex, billEntity, billEntryRow, rateManager, model, presalary);
            if (CalcType.RATIO.getCode().equals(calcType)) {
                if (actualrange != null) {
                    actualamount = presalary.multiply(actualrange.multiply(BigDecimal.valueOf(0.01)));
                    amount = presalary.add(actualamount);
                }
                DecAdjApprFormUtils.calcAmount(rowIndex, presalary, model, billEntryRow);
            } else if (CalcType.AMOUNT.getCode().equals(calcType)) {
                if (actualamount != null) {
                    actualrange = actualamount.divide(presalary, 10, 4).multiply(BigDecimal.valueOf(100L));
                    amount = presalary.add(actualamount);
                }
                DecAdjApprFormUtils.calcRatio(rowIndex, presalary, model, billEntryRow);
            }
        } else if (presalary != null && presalary.compareTo(BigDecimal.ZERO) == 0) {
            if (CalcType.RATIO.getCode().equals(calcType)) {
                if (actualrange != null) {
                    actualamount = presalary;
                    amount = presalary;
                }
                DecAdjApprFormUtils.calcAmount(rowIndex, presalary, model, billEntryRow);
            } else if (CalcType.AMOUNT.getCode().equals(calcType)) {
                if (actualamount != null) {
                    amount = actualamount;
                }
                DecAdjApprFormUtils.calcRatio(rowIndex, presalary, model, billEntryRow);
            }
        } else if ((presalary == null || presalary.compareTo(BigDecimal.ZERO) == 0) && operateType != null && operateType.equals("calctypeChange")) {
            actualrange = null;
        }
        DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_actualrange", actualrange, rowIndex);
        DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_actualamount", actualamount, rowIndex);
        DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_amount", amount, rowIndex);
    }

    public static void calcWithAmount(IDataModel model, DynamicObject billEntity, BillExRateManager rateManager, int rowIndex, DynamicObject billEntryRow, CalcSceneType sceneType, String operateType) {
        BigDecimal actualamount;
        String calcType = billEntryRow.getString("dy_calctype");
        BigDecimal presalary = (BigDecimal)DynamicObjectValueHelper.dyObjGetValueIfExist((DynamicObject)billEntryRow, (String)"dy_presalary", null);
        BigDecimal amount = billEntryRow.getBigDecimal("dy_amount");
        BigDecimal actualrange = billEntryRow.getBigDecimal("dy_actualrange");
        if (presalary != null && presalary.compareTo(BigDecimal.ZERO) > 0) {
            if (amount != null) {
                presalary = DecAdjApprFormUtils.getCalPresalary(rowIndex, billEntity, billEntryRow, rateManager, model, presalary);
                actualamount = amount.subtract(presalary);
                actualrange = actualamount.divide(presalary, 10, 4).multiply(BigDecimal.valueOf(100L));
            } else {
                actualrange = null;
                actualamount = amount;
            }
        } else {
            if (operateType != null && operateType.equals("calctypeChange")) {
                actualrange = null;
            }
            actualamount = amount;
        }
        if (!CalcSceneType.PAGE_CALC.getCode().equals(sceneType.getCode())) {
            if (CalcType.RATIO.getCode().equals(calcType)) {
                DecAdjApprFormUtils.calcAmount(rowIndex, presalary, model, billEntryRow);
            } else if (CalcType.AMOUNT.getCode().equals(calcType)) {
                DecAdjApprFormUtils.calcRatio(rowIndex, presalary, model, billEntryRow);
            }
        }
        DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_actualrange", actualrange, rowIndex);
        DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_actualamount", actualamount, rowIndex);
        DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_amount", amount, rowIndex);
    }

    public static void calcRatio(int rowIndex, BigDecimal presalary, IDataModel model, DynamicObject billEntryRow) {
        BigDecimal minAmount = (BigDecimal)DynamicObjectValueHelper.dyObjGetValueIfExist((DynamicObject)billEntryRow, (String)"dy_suggestminamount", null);
        BigDecimal maxAmount = (BigDecimal)DynamicObjectValueHelper.dyObjGetValueIfExist((DynamicObject)billEntryRow, (String)"dy_suggestmaxamount", null);
        BigDecimal minRange = SalaryStdCalculateHelper.calcRangeWithAmount((BigDecimal)presalary, (BigDecimal)minAmount);
        BigDecimal maxRange = SalaryStdCalculateHelper.calcRangeWithAmount((BigDecimal)presalary, (BigDecimal)maxAmount);
        DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_suggestminrange", minRange, rowIndex);
        DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_suggestmaxrange", maxRange, rowIndex);
    }

    public static void calcAmount(int rowIndex, BigDecimal presalary, IDataModel model, DynamicObject billEntryRow) {
        BigDecimal minrange = (BigDecimal)DynamicObjectValueHelper.dyObjGetValueIfExist((DynamicObject)billEntryRow, (String)"dy_suggestminrange", null);
        BigDecimal maxrange = (BigDecimal)DynamicObjectValueHelper.dyObjGetValueIfExist((DynamicObject)billEntryRow, (String)"dy_suggestmaxrange", null);
        BigDecimal minAmount = SalaryStdCalculateHelper.calcAmountWithRange((BigDecimal)presalary, (BigDecimal)minrange);
        BigDecimal maxAmount = SalaryStdCalculateHelper.calcAmountWithRange((BigDecimal)presalary, (BigDecimal)maxrange);
        DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_suggestminamount", minAmount, rowIndex);
        DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_suggestmaxamount", maxAmount, rowIndex);
    }

    private static BigDecimal getCalPresalary(int rowIndex, DynamicObject billEntity, DynamicObject billEntryRow, BillExRateManager rateManager, IDataModel model, BigDecimal amount) {
        DynamicObject salaryStdDyn;
        Long preCurrency = (Long)DynamicObjectValueHelper.dyObjGetValueIfExist((DynamicObject)billEntryRow, (String)"dy_precurrency_id", (String)"dy_precurrency");
        long adjCurrency = billEntryRow.getLong("dy_currency_id");
        if ((preCurrency == null || preCurrency <= 0L) && (salaryStdDyn = billEntryRow.getDynamicObject(DecAdjApprCreateGridHelper.buildKey((String)"salarystd"))) != null) {
            preCurrency = salaryStdDyn.getLong("currency.id");
        }
        if (adjCurrency > 0L && preCurrency != adjCurrency) {
            ExchangeRateInfo exrateInfo;
            long exctableId = billEntity.getLong("exctable.id");
            Date rateDate = billEntity.getDate("exchangeratedate");
            if (adjCurrency > 0L && preCurrency > 0L && exctableId > 0L && rateDate != null && (exrateInfo = rateManager.getExRate(new ExRateKey(Long.valueOf(adjCurrency), preCurrency, Long.valueOf(rateDate.getTime()), Long.valueOf(exctableId)))) != null) {
                Boolean quoteType = exrateInfo.getQuoteType();
                BigDecimal exchangeRate = exrateInfo.getExchangeRate();
                if (exchangeRate != null) {
                    model.setValue("dy_exratevalue", (Object)exchangeRate, rowIndex);
                    model.setValue("dy_quotetype", (Object)quoteType, rowIndex);
                    amount = quoteType != false ? amount.divide(exchangeRate, 2, 4) : amount.multiply(exchangeRate);
                }
            }
        }
        return amount;
    }

    private static boolean isNeedCalculate(DynamicObject billEntity, DynamicObject billEntryRow, BillExRateManager rateManager) {
        ExchangeRateInfo exrateInfo;
        DynamicObject salaryStdDyn;
        long adjCurrency = billEntryRow.getLong("dy_currency_id");
        if (adjCurrency <= 0L) {
            return false;
        }
        Long preCurrency = (Long)DynamicObjectValueHelper.dyObjGetValueIfExist((DynamicObject)billEntryRow, (String)"dy_precurrency_id", (String)"dy_precurrency");
        if ((preCurrency == null || preCurrency <= 0L) && (salaryStdDyn = billEntryRow.getDynamicObject(DecAdjApprCreateGridHelper.buildKey((String)"salarystd"))) != null) {
            preCurrency = salaryStdDyn.getLong("currency.id");
        }
        long exctableId = billEntity.getLong("exctable.id");
        Date rateDate = billEntity.getDate("exchangeratedate");
        if (preCurrency != null && preCurrency > 0L && adjCurrency != preCurrency && (exctableId <= 0L || ObjectUtils.isEmpty((Object)rateDate))) {
            return false;
        }
        return preCurrency == null || preCurrency <= 0L || adjCurrency == preCurrency || exctableId <= 0L || rateDate == null || (exrateInfo = rateManager.getExRate(new ExRateKey(Long.valueOf(adjCurrency), preCurrency, Long.valueOf(rateDate.getTime()), Long.valueOf(exctableId)))) != null;
    }

    public static void calcWithSuggestRange(IDataModel model, DynamicObject billEntity, BillExRateManager rateManager, int rowIndex, DynamicObject billEntryRow) {
        BigDecimal presalary;
        String calcType = billEntryRow.getString("dy_calctype");
        if (CalcType.RATIO.getCode().equals(calcType) && (presalary = (BigDecimal)DynamicObjectValueHelper.dyObjGetValueIfExist((DynamicObject)billEntryRow, (String)"dy_presalary", null)) != null && presalary.compareTo(BigDecimal.ZERO) >= 0) {
            presalary = DecAdjApprFormUtils.getCalPresalary(rowIndex, billEntity, billEntryRow, rateManager, model, presalary);
            DecAdjApprFormUtils.calcAmount(rowIndex, presalary, model, billEntryRow);
        }
    }

    public static void calcWithSuggestAmount(IDataModel model, DynamicObject billEntity, BillExRateManager rateManager, int rowIndex, DynamicObject billEntryRow) {
        BigDecimal presalary;
        String calcType = billEntryRow.getString("dy_calctype");
        if (CalcType.AMOUNT.getCode().equals(calcType) && (presalary = (BigDecimal)DynamicObjectValueHelper.dyObjGetValueIfExist((DynamicObject)billEntryRow, (String)"dy_presalary", null)) != null && presalary.compareTo(BigDecimal.ZERO) >= 0) {
            presalary = DecAdjApprFormUtils.getCalPresalary(rowIndex, billEntity, billEntryRow, rateManager, model, presalary);
            DecAdjApprFormUtils.calcRatio(rowIndex, presalary, model, billEntryRow);
        }
    }

    public static void setLogicAmount(int[] rowIndexes, IDataModel billModel) {
        String attributionType = DecAdjApprGridHelper.getAttributionType((IDataModel)billModel);
        for (int rowIndex : rowIndexes) {
            BigDecimal logicAmount;
            DynamicObject billEntryRow = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            BigDecimal amount = billEntryRow.getBigDecimal("dy_amount");
            BigDecimal exrateValue = billEntryRow.getBigDecimal("dy_exratevalue");
            Boolean quoteType = billEntryRow.getBoolean("dy_quotetype");
            DynamicObject salaryStdDyObj = billEntryRow.getDynamicObject("dy_salarystd");
            DynamicObject preSalaryStdDyObj = billEntryRow.getDynamicObject("dy_presalarystd");
            if (salaryStdDyObj == null || amount == null) continue;
            long stdCurrency = AdjAttributionType.DECATTRTYPE.getCode().equals(attributionType) ? salaryStdDyObj.getLong("currency.id") : (preSalaryStdDyObj != null ? preSalaryStdDyObj.getLong("currency.id") : salaryStdDyObj.getLong("currency.id"));
            long decCurrency = billEntryRow.getLong("dy_currency.id");
            if (billModel == null) continue;
            if (stdCurrency == decCurrency) {
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_amountlogic", amount, rowIndex);
                continue;
            }
            if (exrateValue == null || exrateValue.compareTo(BigDecimal.ZERO) == 0) continue;
            if (quoteType.booleanValue()) {
                logicAmount = amount.multiply(exrateValue);
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_amountlogic", logicAmount, rowIndex);
                continue;
            }
            logicAmount = amount.divide(exrateValue, 2, 4);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_amountlogic", logicAmount, rowIndex);
        }
    }

    public static void calDataWhenAdjCurrencyChange(int[] rowIndexes, IFormView billView, String operateType) {
        IDataModel billModel = billView.getModel();
        DecAdjApprFormUtils.calcAdjAmountWithChangeData("3", "calcWithCurExchange", rowIndexes, billModel, null, operateType);
        DecAdjApprFormUtils.setAdjCalcFieldAfter(rowIndexes, billModel);
        DecAdjApprFormUtils.setFieldEnableWithCalcType(rowIndexes, billModel, billView);
    }

    public static void calDataWhenDecCurrencyChange(int[] rowIndexes, IFormView billView) {
        IDataModel billModel = billView.getModel();
        DecAdjApprFormUtils.calcDecAdjFinalAmount(rowIndexes, billModel, null);
        DecAdjApprFormUtils.setCurrencySign(rowIndexes, billView, billModel, "dy_currency");
        DecAdjApprFormUtils.formatAmountResult(billView);
    }

    public static void setAmountStdRangeIfCalTypeIsGradeRank(int[] rowIndexes, IFormView billView) {
        IDataModel billModel = billView.getModel();
        Map<Long, Map<Long, Boolean>> itemUseRankFlag = DecAdjApprFormUtils.getItemUseRankFlag(rowIndexes, billModel);
        Map<Integer, Boolean> itemUseRankMap = DecAdjApprFormUtils.checkItemUseRank(rowIndexes, billModel, itemUseRankFlag);
        ArrayList<String> personRangeList = new ArrayList<String>(1);
        for (int rowIndex : rowIndexes) {
            DynamicObject billEntryRow = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            String personRange = (String)DynamicObjectValueHelper.dyObjGetValueIfExist((DynamicObject)billEntryRow, (String)"dy_salargrel", null);
            if (!StringUtils.isNotEmpty((String)personRange)) continue;
            personRangeList.add(personRange);
        }
        if (CollectionUtils.isNotEmpty(personRangeList)) {
            GradeAndRankNameEntity gradeAndRankNameEntity = GradeAndRankNameHelper.getGradeAndRankNameFromMatchGradeRankRel(personRangeList);
            for (int rowIndex : rowIndexes) {
                DynamicObject billEntryRow = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
                String personRange = (String)DynamicObjectValueHelper.dyObjGetValueIfExist((DynamicObject)billEntryRow, (String)"dy_salargrel", null);
                Boolean isUseRank = itemUseRankMap.get(rowIndex);
                AmountStdRangeEntity amountStdRangeEntity = GradeAndRankNameHelper.convertMatchGradeRankRelToAmountStdRange((String)personRange, (Boolean)isUseRank, (GradeAndRankNameEntity)gradeAndRankNameEntity);
                String amountStdRangeName = GradeAndRankNameHelper.formatGradeAndRankRangeName((String)JSON.toJSONString((Object)amountStdRangeEntity), (GradeAndRankNameEntity)gradeAndRankNameEntity);
                DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_amountstdrangedisplay", amountStdRangeName, rowIndex);
            }
        }
    }

    public static void updateEntryRowIfCalTypeChange(IFormView billView, String attributionType, DynamicObjectType adjPersonEntityType) {
        IDataModel billModel = billView.getModel();
        DecAdjApprFormUtils.saveAdjApprChangedEntryRows(billView, billModel);
        if (AdjAttributionType.ADJATTRTYPE.getCode().equals(attributionType)) {
            DynamicObject dataEntity = billModel.getDataEntity(true);
            EntityType entityType = (EntityType)billModel.getDataEntityType().getAllEntities().get("adjapprdetailentry");
            DecAdjApprGridHelper.updateEntryRowIfCalTypeChange((DynamicObject)dataEntity, (EntityType)entityType, (String)attributionType, (IDataModel)billModel);
        }
    }

    public static void changeLabelWhenBillnoChange(IFormView billView) {
        IDataModel billModel = billView.getModel();
        String billNo = (String)billModel.getValue("billno");
        Label billNoLabel = (Label)billView.getControl("billno1");
        QRCode qrCode = (QRCode)billView.getControl("qrcodeap");
        billNoLabel.setText(billNo);
        if (!Strings.isNullOrEmpty((String)billNo)) {
            qrCode.setUrl(billNo);
        } else {
            qrCode.setUrl("            ");
        }
    }

    public static void setCalTypeMustInput(IFormView billView) {
        IDataModel billModel = billView.getModel();
        String attributionType = DecAdjApprGridHelper.getAttributionType((IDataModel)billModel);
        if (AdjAttributionType.ADJATTRTYPE.getCode().equals(attributionType)) {
            ComboEdit calTypeComboEdit = (ComboEdit)billView.getControl("caltype");
            calTypeComboEdit.setMustInput(true);
        }
    }

    public static void setStdScmRelationInfoFromMatchResult(int[] rowIndexes, IFormView view, IDataModel model, Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult) {
        for (int rowIndex : rowIndexes) {
            DynamicObject billEntryRow = model.getEntryRowEntity("adjapprdetailentry", rowIndex);
            SalaryStdMatchResultNew salaryStdMatchResultNew = DecAdjApprFormUtils.getSalaryStdMatchResult(matchStdResult, billEntryRow);
            if (Objects.isNull(salaryStdMatchResultNew)) {
                logger.info("DecAdjApprFormUtils.setStdScmRelationInfoFromMatchResult salaryStdMatchResultNew is empty");
                continue;
            }
            if (salaryStdMatchResultNew.getStdTableNotFoundType() != null) {
                DecAdjApprFormUtils.showTipNotificationByMatchResult(view, salaryStdMatchResultNew, billEntryRow.getString("dy_standarditem.name"));
            }
            DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_excesscontrol", salaryStdMatchResultNew.getExcessControl(), rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_ismatchgraderank", salaryStdMatchResultNew.getIsMatchGradeRank(), rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(model, "dy_matchstrategy", salaryStdMatchResultNew.getMatchStrategy(), rowIndex);
        }
    }

    public static void showTipNotificationByMatchResult(IFormView view, SalaryStdMatchResultNew salaryStdMatchResultNew, String itemName) {
        if (salaryStdMatchResultNew == null) {
            return;
        }
        StdTabNotFoundType stdTableNotFoundType = salaryStdMatchResultNew.getStdTableNotFoundType();
        if (stdTableNotFoundType == StdTabNotFoundType.NOSTDSCM_INBSED) {
            view.showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u751f\u6548\u65e5\u671f\u4e0b\u6ca1\u6709\u53ef\u7528\u7684\u85aa\u916c\u4f53\u7cfb\uff0c\u76f8\u5173\u5b57\u6bb5\u53ef\u80fd\u4f1a\u88ab\u6e05\u7a7a\uff0c\u8bf7\u5173\u6ce8\u3002", (String)"DecAdjRecordRevisionFormPluginHelper_4", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), itemName));
        } else if (stdTableNotFoundType == StdTabNotFoundType.STD_UNUSEABLE) {
            view.showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u751f\u6548\u65e5\u671f\u4e0b\u6ca1\u6709\u53ef\u7528\u7684\u85aa\u916c\u6807\u51c6\u8868\uff0c\u76f8\u5173\u5b57\u6bb5\u53ef\u80fd\u4f1a\u88ab\u6e05\u7a7a\uff0c\u8bf7\u5173\u6ce8\u3002", (String)"DecAdjRecordRevisionFormPluginHelper_5", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), itemName));
        } else if (stdTableNotFoundType == StdTabNotFoundType.ITEM_NOTEXIST_INSCM) {
            view.showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u751f\u6548\u65e5\u671f\u4e0b\u85aa\u916c\u4f53\u7cfb\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u85aa\u916c\u7ed3\u6784\u7684\u5b9a\u8c03\u85aa\u9879\u76ee\uff0c\u76f8\u5173\u5b57\u6bb5\u53ef\u80fd\u4f1a\u88ab\u6e05\u7a7a\uff0c\u8bf7\u5173\u6ce8\u3002", (String)"DecAdjRecordRevisionFormPluginHelper_6", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), itemName));
        } else if (stdTableNotFoundType == StdTabNotFoundType.ITEM_NOTEXIST_INSTD) {
            view.showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u751f\u6548\u65e5\u671f\u4e0b\u85aa\u916c\u6807\u51c6\u8868\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u5b9a\u8c03\u85aa\u9879\u76ee\uff0c\u76f8\u5173\u5b57\u6bb5\u53ef\u80fd\u4f1a\u88ab\u6e05\u7a7a\uff0c\u8bf7\u5173\u6ce8\u3002", (String)"DecAdjRecordRevisionFormPluginHelper_7", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), itemName));
        } else if (stdTableNotFoundType == StdTabNotFoundType.ITEM_NOTSETSTD_INSCM) {
            view.showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u751f\u6548\u65e5\u671f\u4e0b\u85aa\u916c\u4f53\u7cfb\u4e2d\u5b9a\u8c03\u85aa\u9879\u76ee\u672a\u914d\u7f6e\u85aa\u916c\u6807\u51c6\u8868\uff0c\u76f8\u5173\u5b57\u6bb5\u53ef\u80fd\u4f1a\u88ab\u6e05\u7a7a\uff0c\u8bf7\u5173\u6ce8\u3002", (String)"DecAdjRecordRevisionFormPluginHelper_8", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), itemName));
        }
    }

    public static int[] clearStdTabRelateInfoWhenTableIdChanged(int[] rowIndexes, IDataModel billModel, Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult) {
        String attributionType = DecAdjApprGridHelper.getAttributionType((IDataModel)billModel);
        ArrayList changedRows = Lists.newArrayListWithExpectedSize((int)rowIndexes.length);
        for (int rowIndex : rowIndexes) {
            DynamicObject billEntryRow = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            SalaryStdMatchResultNew salaryStdMatchResult = DecAdjApprFormUtils.getSalaryStdMatchResult(matchStdResult, billEntryRow);
            boolean isTabIdChanged = DecAdjApprFormUtils.checkStdTableIsChanged(salaryStdMatchResult, billEntryRow);
            if (!isTabIdChanged) continue;
            changedRows.add(rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_salarystd", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_intervalmin", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_intervalmax", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_salarypercent", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_salaryseeprate", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_frequency", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_salargrel", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_grade", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_rank", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_overstandardtype", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_actualrange", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_actualamount", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_amount", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_amountstdrangedisplay", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_amountstdrange", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_itemmin", null, rowIndex);
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_itemmax", null, rowIndex);
        }
        return changedRows.stream().mapToInt(o1 -> o1).toArray();
    }

    private static boolean checkStdTableIsChanged(SalaryStdMatchResultNew salaryStdMatchResultNew, DynamicObject billEntryRow) {
        long oldStdTableId = billEntryRow.getLong("dy_salarystd.id");
        boolean isTabIdChanged = oldStdTableId > 0L && (salaryStdMatchResultNew == null || salaryStdMatchResultNew.getStdTableVid() == null || salaryStdMatchResultNew.getStdTableVid() == 0L) || oldStdTableId == 0L && salaryStdMatchResultNew != null && salaryStdMatchResultNew.getStdTableVid() != null && salaryStdMatchResultNew.getStdTableVid() > 0L || oldStdTableId > 0L && salaryStdMatchResultNew.getStdTableVid() != null && salaryStdMatchResultNew.getStdTableVid() > 0L && salaryStdMatchResultNew.getStdTableVid() != oldStdTableId;
        return isTabIdChanged;
    }

    public static void clearCoefficientRelateInfoWhenCoefficientChanged(int[] rowIndexes, IDataModel billModel, Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult) {
        String attributionType = DecAdjApprGridHelper.getAttributionType((IDataModel)billModel);
        for (int rowIndex : rowIndexes) {
            DynamicObject billEntryRow = billModel.getEntryRowEntity("adjapprdetailentry", rowIndex);
            SalaryStdMatchResultNew salaryStdMatchResult = DecAdjApprFormUtils.getSalaryStdMatchResult(matchStdResult, billEntryRow);
            boolean isCoefficientIdChanged = DecAdjApprFormUtils.checkCoefficientIsChanged(salaryStdMatchResult, billEntryRow);
            if (!isCoefficientIdChanged) continue;
            logger.info("clearCoefficientRelateInfoWhenCoefficientChanged");
            DecAdjApprFormUtils.modelSetValueIfExist(billModel, "dy_coefficient", null, rowIndex);
        }
    }

    private static boolean checkCoefficientIsChanged(SalaryStdMatchResultNew salaryStdMatchResultNew, DynamicObject billEntryRow) {
        long oldCoefficientId = billEntryRow.getLong("dy_coefficient.id");
        boolean isCoefficientIdChanged = oldCoefficientId > 0L && (salaryStdMatchResultNew == null || salaryStdMatchResultNew.getCoefficientVid() == null || salaryStdMatchResultNew.getCoefficientVid() == 0L) || oldCoefficientId == 0L && salaryStdMatchResultNew != null && salaryStdMatchResultNew.getCoefficientVid() != null && salaryStdMatchResultNew.getCoefficientVid() > 0L || oldCoefficientId > 0L && salaryStdMatchResultNew.getCoefficientVid() != null && salaryStdMatchResultNew.getCoefficientVid() > 0L && salaryStdMatchResultNew.getCoefficientVid() != oldCoefficientId;
        return isCoefficientIdChanged;
    }
}

