/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjapprbill.adjconfirm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.enums.AdjConfirmConfirmType;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.enums.AdjConfirmFeedbackStatus;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.enums.AdjConfirmSendStatus;
import kd.swc.hcdm.business.adjapplication.service.AdjApprovalApplicationService;
import kd.swc.hcdm.business.adjapprbill.adjconfirm.AdjConfirmHelper;
import kd.swc.hcdm.formplugin.adjapprbill.adjconfirm.AdjConfirmBaseEdit;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class AdjConfirmEdit
extends AdjConfirmBaseEdit
implements SearchEnterListener,
HyperLinkClickListener,
ListboxClickListener {
    private static final String ENTRY_KEY = "confirmentry";
    private static final String CALLBACK_OFFLINECONFIRM = "callback_offlineConfirm";
    private static final String CONTROL_KEY_SEARCH = "searchap";
    private static final String CONTROL_KEY_ENTRYLISTBOX = "tabap1";
    private AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_KEY);
        entryGrid.addPackageDataListener(pkEvent -> {
            String confirmStatus = pkEvent.getRowData().getString("adjconfirmperson.confirmstatus");
            String isSend = pkEvent.getRowData().getString("adjconfirmperson.issend");
            if (pkEvent.getSource() instanceof OperationColumn && "operationcolumnap".equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey())) {
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    if (!"donothing_repeatsend".equalsIgnoreCase(operationColItem.getOperationKey())) continue;
                    operationColItem.setLocked(!AdjConfirmFeedbackStatus.NOT_CONFIRM.getCode().equals(confirmStatus) || !AdjConfirmSendStatus.HAS_SENT.getCode().equals(isSend));
                }
            }
        });
        super.initialize();
    }

    public void registerListener(EventObject object) {
        super.registerListener(object);
        Listbox listbox = (Listbox)this.getControl(CONTROL_KEY_ENTRYLISTBOX);
        listbox.addListboxClickListener((ListboxClickListener)this);
        Button baritemap3 = (Button)this.getControl("buttonap");
        baritemap3.addClickListener((ClickListener)this);
        Button baritemap4 = (Button)this.getControl("buttonap2");
        baritemap4.addClickListener((ClickListener)this);
        Search search = (Search)this.getControl(CONTROL_KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        EntryGrid control = (EntryGrid)this.getControl(ENTRY_KEY);
        control.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void listboxClick(ListboxEvent listboxEvent) {
        String tabKey = listboxEvent.getItemId();
        if (tabKey.startsWith("tab_")) {
            this.cacheListBoxActive(tabKey);
            this.changeTab(tabKey, this.getSearchKeyword());
            this.getView().updateView(ENTRY_KEY);
        }
    }

    private void cacheListBoxActive(String tabKey) {
        this.getPageCache().put(CONTROL_KEY_ENTRYLISTBOX, tabKey);
    }

    private String getListBoxActiveFromCache() {
        String str = this.getPageCache().get(CONTROL_KEY_ENTRYLISTBOX);
        return StringUtils.isEmpty((String)str) ? "tab_all" : str;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button source = (Button)evt.getSource();
        if (StringUtils.equals((String)source.getKey(), (String)"buttonap2")) {
            long billId = this.getModel().getDataEntity().getLong("id");
            this.adjApprovalApplicationService.createAdjConfirmPerson(Collections.singletonList(billId));
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String keyword = searchEnterEvent.getText();
        String tabKey = this.getListBoxActiveFromCache();
        this.changeTab(tabKey, keyword);
        this.getView().updateView(ENTRY_KEY);
        long billId = this.getModel().getDataEntity().getLong("id");
        this.refreshSendStatistic(billId, keyword);
        this.refreshFeedbackStatistic(billId, keyword);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        DynamicObject billEntity = this.getModel().getDataEntity();
        long billId = billEntity.getLong("id");
        String selectedTabKey = this.getListBoxActiveFromCache() == null ? "tab_all" : this.getListBoxActiveFromCache();
        String keyword = this.getSearchKeyword();
        this.refreshFeedbackStatistic(billId, keyword);
        this.refreshSendStatistic(billId, keyword);
        this.changeTab(selectedTabKey, keyword);
        this.getModel().setValue("adjconfirmtpl", (Object)billEntity.getLong("salaryadjscm.adjconfirmtpl.id"));
        long msgTplId = billEntity.getLong("adjconfirmtpl.msgtemplate.id");
        String buttonSelect = billEntity.getString("adjconfirmtpl.buttonselect");
        this.getModel().setValue("msgtpl", (Object)msgTplId);
        if (billEntity.getBoolean("salaryadjscm.enableconfirm")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"msgtpl"});
        }
        this.getModel().setValue("buttonselect", (Object)buttonSelect);
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        DynamicObject billEntity;
        String name = args.getProperty().getName();
        if (StringUtils.equals((String)"adjconfirmtpl", (String)name)) {
            billEntity = this.getModel().getDataEntity();
            long msgTplId = billEntity.getLong("adjconfirmtpl.msgtemplate.id");
            String buttonSelect = billEntity.getString("adjconfirmtpl.buttonselect");
            this.getModel().setValue("msgtpl", (Object)msgTplId);
            this.getModel().setValue("buttonselect", (Object)buttonSelect);
        }
        if (StringUtils.equals((String)"salaryadjscm", (String)name)) {
            billEntity = this.getModel().getDataEntity();
            long adjconfirmtpl = billEntity.getLong("salaryadjscm.adjconfirmtpl.id");
            this.getModel().setValue("adjconfirmtpl", (Object)adjconfirmtpl);
            if (billEntity.getBoolean("salaryadjscm.enableconfirm")) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"msgtpl"});
            }
        }
    }

    private void refreshTab(int waitSent, int hasSent, int offlineConfirm) {
        String allName = ResManager.loadKDString((String)"\u5168\u90e8", (String)"AdjConfirmEdit_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String waitSendName = AdjConfirmSendStatus.NOT_SENT.getNameParam().loadKDString();
        String hasSentName = AdjConfirmSendStatus.HAS_SENT.getNameParam().loadKDString();
        String offlineConfirmName = AdjConfirmConfirmType.OFF_LINE.getNameParam().loadKDString();
        ListboxItem tab1 = new ListboxItem("tab_all", allName);
        ListboxItem tab2 = new ListboxItem("tab_waitsend", MessageFormat.format(waitSendName + "({0})", waitSent));
        ListboxItem tab3 = new ListboxItem("tab_hassent", MessageFormat.format(hasSentName + "({0})", hasSent));
        ListboxItem tab4 = new ListboxItem("tab_offlineconfirm", MessageFormat.format(offlineConfirmName + "({0})", offlineConfirm));
        ArrayList<ListboxItem> itemlist = new ArrayList<ListboxItem>();
        itemlist.add(tab1);
        itemlist.add(tab2);
        itemlist.add(tab3);
        itemlist.add(tab4);
        Listbox tabEntry = (Listbox)this.getControl(CONTROL_KEY_ENTRYLISTBOX);
        tabEntry.addItems(itemlist);
    }

    private String getSearchKeyword() {
        Search control = (Search)this.getControl(CONTROL_KEY_SEARCH);
        return control.getSearchKey();
    }

    private void refreshFeedbackStatistic(long billId, String keyword) {
        Map confirmStatisticMap = this.adjApprovalApplicationService.countAdjConfirmStatistic((List)Lists.newArrayList((Object[])new Long[]{billId}), keyword);
        Map<String, Integer> feedbackStatistic = confirmStatisticMap.getOrDefault(billId, Collections.singletonMap("", 0));
        Label feedbackTotal = (Label)this.getView().getControl("feedback_total");
        Label feedbackConfirmAgree = (Label)this.getView().getControl("feedback_confirmed");
        Label feedbackRefuse = (Label)this.getView().getControl("feedback_refused");
        Label feedbackUnconfirmed = (Label)this.getView().getControl("feedback_unconfirmed");
        feedbackTotal.setText(feedbackStatistic.getOrDefault("total", 0).toString());
        feedbackConfirmAgree.setText(feedbackStatistic.getOrDefault("confirmed", 0).toString());
        feedbackRefuse.setText(feedbackStatistic.getOrDefault("refused", 0).toString());
        feedbackUnconfirmed.setText(feedbackStatistic.getOrDefault("unconfirmed", 0).toString());
    }

    private void refreshSendStatistic(long billId, String keyword) {
        Map sentStatistic = (Map)this.adjApprovalApplicationService.countAdjConfirmStatistic((List)Lists.newArrayList((Object[])new Long[]{billId}), keyword).get(billId);
        if (MapUtils.isEmpty((Map)sentStatistic)) {
            return;
        }
        this.refreshTab((Integer)sentStatistic.get("notsent"), (Integer)sentStatistic.get("hassent"), (Integer)sentStatistic.get("offlineconfirmed"));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "callback_offlineConfirm": {
                String selectedTabKey = this.getListBoxActiveFromCache();
                String keyword = this.getSearchKeyword();
                this.changeTab(selectedTabKey, keyword);
                this.getView().updateView(ENTRY_KEY);
                long billId = this.getModel().getDataEntity().getLong("id");
                this.refreshFeedbackStatistic(billId, keyword);
                this.refreshSendStatistic(billId, keyword);
                break;
            }
            case "print_setting_close": {
                Object returnData = closedCallBackEvent.getReturnData();
                if (!(returnData instanceof String) || !StringUtils.equals((String)((String)returnData), (String)"btnok")) break;
                this.batchPrint(true);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (itemKey.startsWith("opkey_")) {
            this.dispatchOperate(itemKey);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_KEY);
        entryGrid.selectRows(hyperLinkClickEvent.getRowIndex());
        if (StringUtils.equals((String)fieldName, (String)"attachmentnum")) {
            String caption = ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20", (String)"AdjConfirmEdit_7", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            this.toOfflineConfirm("upload", caption);
        }
    }

    private void openPreview() {
        Map<Integer, Long> adjConfirmPersonIds = this.getSelectedPerson(true);
        int focusRow = ((EntryGrid)this.getControl(ENTRY_KEY)).getEntryState().getFocusRow();
        Long adjConfirmPersonId = adjConfirmPersonIds.get(focusRow);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hcdm_adjconfirmpreview");
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        parameter.setOpenStyle(openStyle);
        parameter.setCustomParam("adjconfirmpersonid", (Object)(adjConfirmPersonId + ""));
        parameter.setShowFullScreen(true);
        parameter.setCaption(ResManager.loadKDString((String)"\u9884\u89c8", (String)"AdjConfirmEdit_11", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
        this.getView().showForm(parameter);
    }

    private void dispatchOperate(String itemKey) {
        AdjApprovalApplicationService approvalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);
        Map<Integer, Long> adjConfirmPersonIds = this.getSelectedPerson(false);
        if (MapUtils.isEmpty(adjConfirmPersonIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AdjConfirmEdit_5", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
        }
        ArrayList personIds = Lists.newArrayList(adjConfirmPersonIds.values());
        switch (itemKey) {
            case "opkey_sendconfirm": {
                approvalApplicationService.sendAdjConfirm((List)personIds);
                for (Map.Entry<Integer, Long> entry : adjConfirmPersonIds.entrySet()) {
                    this.getModel().setValue("issend", (Object)AdjConfirmSendStatus.HAS_SENT.getCode(), entry.getKey().intValue());
                }
                break;
            }
            case "opkey_offlineconfirm": {
                this.openOfflineConfirmEdit(personIds, "offlineconfirm", null);
                break;
            }
            case "opkey_repeatsendconfirm": {
                break;
            }
            case "opkey_batchdownload": {
                break;
            }
            case "opkey_batchprint": {
                break;
            }
        }
    }

    private void openOfflineConfirmEdit(List<Long> personIds, String operateType, String caption) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setHasRight(true);
        parameter.setFormId("hcdm_offlineconfirm");
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        parameter.setOpenStyle(openStyle);
        parameter.setShowTitle(true);
        if (caption != null) {
            parameter.setCaption(caption);
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_OFFLINECONFIRM));
        parameter.setCustomParam("adjconfirmpersonids", (Object)StringUtils.join(personIds, (String)","));
        parameter.setCustomParam("operatetype", (Object)operateType);
        this.getView().showForm(parameter);
    }

    private Map<Integer, Long> getSelectedPerson(boolean onlyFocus) {
        EntryGrid control = (EntryGrid)this.getView().getControl(ENTRY_KEY);
        int[] selectRows = onlyFocus ? new int[]{control.getEntryState().getFocusRow()} : control.getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_KEY);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)selectRows.length);
        for (int i = 0; i < entryEntity.size(); ++i) {
            if (!ArrayUtils.contains((int[])selectRows, (int)i)) continue;
            resultMap.put(i, ((DynamicObject)entryEntity.get(i)).getLong("adjconfirmperson.id"));
        }
        return resultMap;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        FormOperate source = (FormOperate)afterDoOperationEventArgs.getSource();
        String opName = source.getOperateName().getLocaleValue();
        switch (operateKey) {
            case "donothing_repeatsend": {
                this.repeatSendConfirm(source);
                break;
            }
            case "donothing_downloadattachment": {
                Map<Integer, Long> selectedPerson = this.getSelectedPerson(true);
                List strings = this.adjApprovalApplicationService.downloadAdjConfirmPDF(new ArrayList<Long>(selectedPerson.values()));
                for (String string : strings) {
                    this.getView().download(string);
                }
                break;
            }
            case "donothing_preview": {
                this.openPreview();
                break;
            }
            case "donothing_sendconfirm": {
                this.sendConfirm(operateKey);
                break;
            }
            case "donothing_offlineconfirm": {
                this.toOfflineConfirm("offlineconfirm", opName);
                break;
            }
            case "donothing_batchdownload": {
                this.downloadAttachment(operateKey);
                break;
            }
            case "donothing_batchprint": {
                this.batchPrint(false);
                break;
            }
            case "donothing_submiteffect": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                this.getView().updateView();
                break;
            }
        }
    }

    private void batchPrint(boolean direct) {
        Object[] selectedRows = this.checkAndGetEntrySelected();
        MultiLangEnumBridge opName2 = new MultiLangEnumBridge("\u6279\u91cf\u6253\u5370", "AdjConfirmEdit_12", "swc-hcdm-formplugin");
        if (!SWCPermissionServiceHelper.hasPerm((String)"0VO5EV13=I9W", (String)"hcdm_adjapprbill", (String)"4730fc9e000000ac")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5458\u5de5\u5b9a\u8c03\u85aa\u7533\u8bf7\u5355\u201d\u7684\u201c\u6253\u5370\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AdjConfirmEdit_15", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ArrayUtils.isNotEmpty((Object[])selectedRows)) {
            if (direct) {
                MultiLangEnumBridge opDesc = null;
                Long printerId = AdjConfirmHelper.getDefaultPrinter();
                if (printerId != null) {
                    this.preCacheService(printerId);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6253\u5370\u4e2d...", (String)"AdjConfirmEdit_10", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                    this.adjApprovalApplicationService.doPrintAdjConfirmPDF(this.fetchAdjPersonIdFromEntry((DynamicObject[])selectedRows), String.valueOf(printerId));
                    opDesc = new MultiLangEnumBridge("\u6253\u5370\u6210\u529f\u3002", "AdjConfirmEdit_4", "swc-hcdm-formplugin");
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6253\u5370\u6210\u529f\u3002", (String)"AdjConfirmEdit_4", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                } else {
                    opDesc = new MultiLangEnumBridge("\u8bf7\u5148\u8bbe\u7f6e\u6253\u5370\u673a\u3002", "AdjConfirmEdit_6", "swc-hcdm-formplugin");
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u6253\u5370\u673a\u3002", (String)"AdjConfirmEdit_6", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                }
                SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"batch print", (MultiLangEnumBridge)opName2, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[0]);
            } else {
                this.openPrintSetting(new CloseCallBack((IFormPlugin)this, "print_setting_close"));
            }
        }
    }

    List<Long> fetchAdjPersonIdFromEntry(DynamicObject[] entryRows) {
        return Arrays.stream(entryRows).map(object -> object.getLong("adjconfirmperson.id")).collect(Collectors.toList());
    }

    private void toOfflineConfirm(String operateType, String caption) {
        Object[] selectedRows = this.checkAndGetEntrySelected();
        if (ArrayUtils.isNotEmpty((Object[])selectedRows)) {
            this.openOfflineConfirmEdit(this.fetchAdjPersonIdFromEntry((DynamicObject[])selectedRows), operateType, caption);
        }
    }

    private void sendConfirm(String opKey) {
        Object[] selectedRows = this.checkAndGetEntrySelected();
        if (ArrayUtils.isNotEmpty((Object[])selectedRows)) {
            List successIds = this.adjApprovalApplicationService.sendAdjConfirm(this.fetchAdjPersonIdFromEntry((DynamicObject[])selectedRows));
            this.refreshEntryAfterSend(successIds, (DynamicObject[])selectedRows, opKey);
        }
    }

    private void refreshEntryAfterSend(List<Long> successIds, DynamicObject[] selectedRows, String opKey) {
        boolean changed = true;
        String message = "";
        MultiLangEnumBridge opDesc = null;
        if (successIds.size() == 0) {
            changed = false;
            message = ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u672a\u53d1\u9001\u72b6\u6001\u7684\u4eba\u5458\u8fdb\u884c\u8c03\u85aa\u786e\u8ba4\u64cd\u4f5c\u3002", (String)"AdjConfirmEdit_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            opDesc = new MultiLangEnumBridge("\u53ea\u80fd\u5bf9\u672a\u53d1\u9001\u72b6\u6001\u7684\u4eba\u5458\u8fdb\u884c\u8c03\u85aa\u786e\u8ba4\u64cd\u4f5c\u3002", "AdjConfirmEdit_1", "swc-hcdm-formplugin");
            this.getView().showErrorNotification(message);
        } else if (successIds.size() < selectedRows.length) {
            message = ResManager.loadKDString((String)"\u90e8\u5206\u53d1\u9001\u6210\u529f", (String)"AdjConfirmEdit_2", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            opDesc = new MultiLangEnumBridge("\u90e8\u5206\u53d1\u9001\u6210\u529f", "AdjConfirmEdit_2", "swc-hcdm-formplugin");
            this.getView().showSuccessNotification(message);
        } else {
            message = ResManager.loadKDString((String)"\u53d1\u9001\u6210\u529f", (String)"AdjConfirmEdit_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            opDesc = new MultiLangEnumBridge("\u53d1\u9001\u6210\u529f", "AdjConfirmEdit_3", "swc-hcdm-formplugin");
            this.getView().showSuccessNotification(message);
        }
        SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)opKey, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[0]);
        for (int index : this.getSelectedRow()) {
            DynamicObject row = this.getModel().getEntryRowEntity(ENTRY_KEY, index);
            if (successIds.indexOf(row.getLong("adjconfirmperson.id")) < 0) continue;
            DynamicObject adjconfirmperson = row.getDynamicObject("adjconfirmperson");
            adjconfirmperson.set("issend", (Object)AdjConfirmSendStatus.HAS_SENT.getCode());
            this.getModel().setValue("adjconfirmperson", (Object)adjconfirmperson, index);
        }
        if (changed) {
            String selectedTabKey = this.getListBoxActiveFromCache();
            String keyword = this.getSearchKeyword();
            this.changeTab(selectedTabKey, keyword);
            this.getView().updateView(ENTRY_KEY);
            long billId = this.getModel().getDataEntity().getLong("id");
            this.refreshFeedbackStatistic(billId, keyword);
            this.refreshSendStatistic(billId, keyword);
        }
    }

    private void preview() {
        Object[] selectedRows = this.checkAndGetEntrySelected();
        if (ArrayUtils.isNotEmpty((Object[])selectedRows)) {
            List adjConfirmPDFs = this.adjApprovalApplicationService.previewAdjConfirmPDF(this.fetchAdjPersonIdFromEntry((DynamicObject[])selectedRows));
            for (String str : adjConfirmPDFs) {
                this.getView().openUrl(str);
            }
        }
    }

    private void downloadAttachment(String operateKey) {
        Object[] selectedRows = this.checkAndGetEntrySelected();
        if (ArrayUtils.isNotEmpty((Object[])selectedRows)) {
            MultiLangEnumBridge opDesc;
            Map confirmPersonAttachment = this.adjApprovalApplicationService.getConfirmPersonAttachment(this.fetchAdjPersonIdFromEntry((DynamicObject[])selectedRows), true);
            for (Map.Entry entry : confirmPersonAttachment.entrySet()) {
                for (Map file : (List)entry.getValue()) {
                    this.getView().download((String)file.get("url"));
                }
            }
            if (MapUtils.isEmpty((Map)confirmPersonAttachment)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u4e0b\u8f7d\u6587\u4ef6\u3002", (String)"AdjConfirmEdit_14", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                opDesc = new MultiLangEnumBridge("\u6682\u65e0\u53ef\u4e0b\u8f7d\u6587\u4ef6\u3002", "AdjConfirmEdit_14", "swc-hcdm-formplugin");
                SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)operateKey, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[0]);
            } else {
                opDesc = new MultiLangEnumBridge("\u6210\u529f", "AdjConfirmEdit_17", "swc-hcdm-formplugin");
                SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)operateKey, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[0]);
            }
        }
    }

    private int[] getSelectedRow() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_KEY);
        return entryGrid.getEntryState().getSelectedRows();
    }

    private DynamicObject[] checkAndGetEntrySelected() {
        int[] selectRowIndexes = this.getSelectedRow();
        if (ArrayUtils.isEmpty((int[])selectRowIndexes)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AdjConfirmEdit_5", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            return new DynamicObject[0];
        }
        DynamicObject[] selectedRows = new DynamicObject[selectRowIndexes.length];
        for (int i = 0; i < selectRowIndexes.length; ++i) {
            selectedRows[i] = this.getModel().getEntryRowEntity(ENTRY_KEY, selectRowIndexes[i]);
        }
        return selectedRows;
    }

    private void repeatSendConfirm(FormOperate operate) {
        Object[] selectedRows = this.checkAndGetEntrySelected();
        if (ArrayUtils.isNotEmpty((Object[])selectedRows)) {
            List<Long> longs = this.fetchAdjPersonIdFromEntry((DynamicObject[])selectedRows);
            Map repeatSendResult = this.adjApprovalApplicationService.repeatSendAdjConfirm(this.fetchAdjPersonIdFromEntry((DynamicObject[])selectedRows));
            List successPk = (List)repeatSendResult.get("successPk");
            List errorMsgList = (List)repeatSendResult.get("errorMsgList");
            String titleTpl = ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u6761\u6570\u636e\uff0c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"AdjConfirmEdit_13", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            String title = MessageFormat.format(titleTpl, selectedRows.length, successPk.size(), errorMsgList.size());
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5171\u9009\u62e9{0}\u6761\u6570\u636e\uff0c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", "AdjConfirmEdit_13", "swc-hcdm-formplugin");
            if (!CollectionUtils.isEmpty((Collection)successPk)) {
                this.refreshEntryAfterSend(longs, (DynamicObject[])selectedRows, operate.getOperateName().getLocaleValue());
            }
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)operate.getOperateKey(), (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[]{selectedRows.length + "", successPk.size() + "", errorMsgList.size() + ""});
            if (errorMsgList.size() > 0) {
                if (errorMsgList.size() == 1) {
                    this.getView().showErrorNotification((String)errorMsgList.get(0));
                } else {
                    FormShowParameter operationResultParameter = SWCShowFormServiceHelper.getOperationResultParameter((String)operate.getOperateName().getLocaleValue(), (String)title, (List)errorMsgList);
                    this.getView().showForm(operationResultParameter);
                }
            }
        }
    }

    private void changeTab(String key, String keyword) {
        DynamicObject[] entryData = new DynamicObject[]{};
        long billId = this.getModel().getDataEntity().getLong("id");
        switch (key) {
            case "tab_all": {
                entryData = this.adjApprovalApplicationService.queryAllConfirmPerson(billId, keyword);
                break;
            }
            case "tab_waitsend": {
                entryData = this.adjApprovalApplicationService.queryWaitSendConfirmPerson(billId, keyword);
                break;
            }
            case "tab_hassent": {
                entryData = this.adjApprovalApplicationService.queryHasSentConfirmPerson(billId, keyword);
                break;
            }
            case "tab_offlineconfirm": {
                entryData = this.adjApprovalApplicationService.queryOfflineConfirmPerson(billId, keyword);
                break;
            }
        }
        DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTRY_KEY);
        rows.clear();
        DynamicObjectType entryType = rows.getDynamicObjectType();
        for (DynamicObject data : entryData) {
            DynamicObject entryRow = new DynamicObject(entryType);
            entryRow.set("confirm_adjfile_id", (Object)data.getLong("adjfile.id"));
            entryRow.set("adjconfirmperson_id", (Object)data.getLong("id"));
            entryRow.set("attachmentnum", (Object)data.getInt("attachmentnum"));
            AdjConfirmConfirmType confirmType = AdjConfirmConfirmType.getByCode((String)data.getString("confirmtype"));
            if (confirmType == AdjConfirmConfirmType.OFF_LINE) {
                entryRow.set("issendtext", (Object)AdjConfirmConfirmType.OFF_LINE.getNameParam().loadKDString());
            } else {
                entryRow.set("issendtext", (Object)AdjConfirmSendStatus.getByCode((String)data.getString("issend")).getNameParam().loadKDString());
            }
            rows.add((Object)entryRow);
        }
        BusinessDataReader.loadRefence((Object[])rows.toArray(), (IDataEntityType)entryType);
        this.getModel().updateEntryCache(rows);
    }
}

