/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjapprbill.adjconfirm;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.enums.AdjConfirmPasswordType;
import kd.swc.hcdm.business.adjapplication.service.AdjApprovalApplicationService;
import kd.swc.hcdm.business.adjapprbill.adjconfirm.AdjConfirmHelper;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;

public class AdjConfirmLoginPlugin
extends AbstractBasePlugIn {
    private static final Log logger = LogFactory.getLog(AdjConfirmLoginPlugin.class);
    private AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);
    private static final String LOGIN = "login";
    private static final String FORGOT_PASS = "forgotpass";
    private static final String SECRET_K = "password";
    public static final String LOGIN_SECRET_ERROR_KEY = "LOGIN_PASSWORD_ERROR";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Button btLogin = (Button)this.getControl(LOGIN);
        btLogin.addClickListener((ClickListener)this);
        Label label = (Label)this.getControl(FORGOT_PASS);
        label.addClickListener((ClickListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        FormShowParameter showParameter = (FormShowParameter)args.getSource();
        String client = StringUtils.contains((String)showParameter.getFormConfig().getModelType(), (String)"mobileform") ? "Mobile" : RequestContext.get().getClient();
        logger.info("client is :{}", (Object)client);
        Long adjConfirmPersonId = this.getAdjConfirmPersonIdFromParam(showParameter);
        logger.info("adjConfirmPersonId is :{}", (Object)adjConfirmPersonId);
        if (this.isLongLinkOverDate(adjConfirmPersonId)) {
            logger.info("url is expired");
            showParameter.setFormId(AdjConfirmHelper.formShowFormIdBySource((String)client, (String)"hcdm_uriexpiry", (String)"hbss_safeuriexpiry"));
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)showParameter.getFormId());
            try {
                BeanUtils.copyProperties((Object)showParameter.getFormConfig(), (Object)formConfig);
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
            }
            return;
        }
        showParameter.setCaption(ResManager.loadKDString((String)"\u767b\u5f55", (String)"AdjConfirmInitLoginPlugin_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
        AdjConfirmPasswordType passwordType = this.adjApprovalApplicationService.getPasswordType(adjConfirmPersonId);
        if (passwordType == AdjConfirmPasswordType.ADJCONFIRM) {
            boolean hasAdjConfirmAccount = this.adjApprovalApplicationService.isAdjConfirmAccount(adjConfirmPersonId.longValue());
            if (!hasAdjConfirmAccount) {
                showParameter.setFormId(AdjConfirmHelper.formShowFormIdBySource((String)client, (String)"hcdm_adjpwdinit", (String)"hcdm_h5adjpwdinit"));
            } else {
                showParameter.setFormId(AdjConfirmHelper.formShowFormIdBySource((String)client, (String)"hcdm_pcadjlogin", (String)"hcdm_h5adjlogin"));
            }
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)showParameter.getFormId());
            showParameter.getFormConfig().setPlugins(formConfig.getPlugins());
            showParameter.getFormConfig().setCaption(formConfig.getCaption());
            showParameter.getFormConfig().setEntityTypeId(formConfig.getEntityTypeId());
            try {
                BeanUtils.copyProperties((Object)showParameter.getFormConfig(), (Object)formConfig);
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
            }
        }
        logger.info("final adjform is :{}", (Object)showParameter.getFormId());
    }

    private boolean isLongLinkOverDate(Long adjConfirmPersonId) {
        Map personMap = this.adjApprovalApplicationService.queryConfirmPerson((List)Lists.newArrayList((Object[])new Long[]{adjConfirmPersonId}));
        DynamicObject personDyObj = (DynamicObject)personMap.get(adjConfirmPersonId);
        logger.info("personDyObj is:{}", (Object)personDyObj);
        return personDyObj == null || this.isOverDate(personDyObj.getDate("expirytime"));
    }

    private boolean isOverDate(Date expiryTime) {
        logger.info("expiryTime is:{}", (Object)expiryTime);
        if (null == expiryTime) {
            return false;
        }
        return expiryTime.before(new Date());
    }

    private Long getAdjConfirmPersonIdFromParam(FormShowParameter showParameter) {
        Long adjConfirmPersonId = (Long)showParameter.getCustomParam("adjConfirmPersonId");
        if (adjConfirmPersonId == null) {
            adjConfirmPersonId = Long.valueOf((String)showParameter.getCustomParam("pkId"));
        }
        return adjConfirmPersonId;
    }

    public void createNewData(BizDataEventArgs args) {
        Long adjConfirmPersonId = this.getAdjConfirmPersonIdFromParam(this.getView().getFormShowParameter());
        AdjConfirmPasswordType passwordType = this.adjApprovalApplicationService.getPasswordType(adjConfirmPersonId);
        String lableText = "";
        if (passwordType == AdjConfirmPasswordType.PAYSLIP) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FORGOT_PASS});
            lableText = ResManager.loadKDString((String)"\u5de5\u8d44\u6761\u67e5\u8be2\u5bc6\u7801", (String)"AdjConfirmInitLoginPlugin_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        } else if (passwordType == AdjConfirmPasswordType.ADJCONFIRM) {
            lableText = ResManager.loadKDString((String)"\u8c03\u85aa\u786e\u8ba4\u67e5\u8be2\u5bc6\u7801", (String)"AdjConfirmInitLoginPlugin_9", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        }
        Label label = (Label)this.getControl("salaryquerylab");
        if (null != label) {
            label.setText(lableText);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button source = (Button)evt.getSource();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        showParameter.setAppId(showParameter.getServiceAppId());
        String client = StringUtils.contains((String)showParameter.getFormConfig().getModelType(), (String)"mobileform") ? "Mobile" : RequestContext.get().getClient();
        Long adjConfirmPersonId = this.getAdjConfirmPersonIdFromParam(showParameter);
        IFormView formView = this.getView();
        if (StringUtils.equals((String)source.getKey(), (String)LOGIN)) {
            String cacheKey;
            String opName = ResManager.loadKDString((String)"\u767b\u5f55", (String)"AdjConfirmInitLoginPlugin_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            MultiLangEnumBridge opName2 = new MultiLangEnumBridge("\u767b\u5f55", "AdjConfirmInitLoginPlugin_0", "swc-hcdm-formplugin");
            String opDescription = ResManager.loadKDString((String)"\u767b\u5f55\u5bc6\u7801\u9519\u8bef", (String)"AdjConfirmLoginPlugin_2", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            String password = this.getModel().getDataEntity().getString(SECRET_K);
            logger.info(" \u767b\u5f55\u9875\u9762\u7684==\u300b adjConfirmPersonId : {} ; password : {}", (Object)String.valueOf(adjConfirmPersonId), (Object)password);
            String password1 = (String)this.getModel().getValue(SECRET_K);
            logger.info(" \u901a\u8fc7value,\u767b\u5f55\u9875\u9762\u7684==\u300b adjConfirmPersonId : {} ; password1 : {}", (Object)String.valueOf(adjConfirmPersonId), (Object)password1);
            AdjConfirmPasswordType passwordType = this.adjApprovalApplicationService.getPasswordType(adjConfirmPersonId);
            if (passwordType == null) {
                return;
            }
            ISWCAppCache appCache = SWCAppCache.get((String)LOGIN_SECRET_ERROR_KEY);
            Integer errorNum = (Integer)appCache.get(cacheKey = LOGIN_SECRET_ERROR_KEY + passwordType.getCode() + adjConfirmPersonId, Integer.class);
            if (errorNum != null && errorNum >= 5) {
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5bc6\u7801\u9519\u8bef\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650\uff0c\u8bf71\u5c0f\u65f6\u540e\u518d\u8bd5\u6216\u91cd\u7f6e\u5bc6\u7801\u3002", "AdjConfirmLoginPlugin_1", "swc-hcdm-formplugin");
                SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)LOGIN, (MultiLangEnumBridge)opName2, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[0]);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bc6\u7801\u9519\u8bef\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650\uff0c\u8bf71\u5c0f\u65f6\u540e\u518d\u8bd5\u6216\u91cd\u7f6e\u5bc6\u7801\u3002", (String)"AdjConfirmLoginPlugin_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean isAuth = passwordType == AdjConfirmPasswordType.PAYSLIP ? this.adjApprovalApplicationService.payslipLogin(password, adjConfirmPersonId.longValue()) : this.adjApprovalApplicationService.adjConfirmQueryCountLogin(password, adjConfirmPersonId.longValue());
            if (isAuth) {
                appCache.remove(cacheKey);
                String formId = AdjConfirmHelper.formShowFormIdBySource((String)client, (String)"hcdm_adjconfirmnotice", (String)"hcdm_h5adjnotice");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u767b\u5f55\u6210\u529f", "AdjConfirmInitLoginPlugin_11", "swc-hcdm-formplugin");
                SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)LOGIN, (MultiLangEnumBridge)opName2, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[0]);
                this.openFormShow(client, formId, adjConfirmPersonId);
            } else {
                int cacheValue = 1;
                if (errorNum != null) {
                    cacheValue = errorNum + 1;
                }
                appCache.put(cacheKey, (Object)cacheValue, 36000);
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u767b\u5f55\u5bc6\u7801\u9519\u8bef\uff0c\u8fd8\u53ef\u5c1d\u8bd5%s\u6b21\u3002", "AdjConfirmLoginPlugin_0", "swc-hcdm-formplugin");
                SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)LOGIN, (MultiLangEnumBridge)opName2, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[]{String.valueOf(5 - cacheValue)});
                this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u767b\u5f55\u5bc6\u7801\u9519\u8bef\uff0c\u8fd8\u53ef\u5c1d\u8bd5%s\u6b21\u3002", (String)"AdjConfirmLoginPlugin_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), String.valueOf(5 - cacheValue)));
            }
        } else if (StringUtils.equals((String)source.getKey(), (String)FORGOT_PASS)) {
            MultiLangEnumBridge opName2 = new MultiLangEnumBridge("\u5fd8\u8bb0\u5bc6\u7801", "AdjConfirmLoginPlugin_3", "swc-hcdm-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5fd8\u8bb0\u5bc6\u7801\u6210\u529f", "AdjConfirmLoginPlugin_4", "swc-hcdm-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"forgot password", (MultiLangEnumBridge)opName2, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[0]);
            String formId = AdjConfirmHelper.formShowFormIdBySource((String)client, (String)"hcdm_adjphonecheck", (String)"hcdm_h5phonecheck");
            this.openFormShow(client, formId, adjConfirmPersonId);
        }
    }

    private void openFormShow(String modelType, String formId, Long adjConfirmPersonId) {
        FormShowParameter parameter = new FormShowParameter();
        ShowType showType = ShowType.Modal;
        if (!AdjConfirmHelper.isPcSource((String)modelType)) {
            parameter = new MobileFormShowParameter();
            showType = ShowType.Floating;
        }
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(showType);
        parameter.setCustomParam("adjConfirmPersonId", (Object)adjConfirmPersonId);
        parameter.setParentPageId(this.getView().getFormShowParameter().getPageId());
        if ("hcdm_adjconfirmnotice".equals(formId) || "hcdm_h5adjnotice".equals(formId)) {
            parameter.setCustomParam("authtime", (Object)TimeServiceHelper.getTimeStamp());
        }
        this.getView().showForm(parameter);
    }
}

