/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjapprbill.adjconfirm;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.enums.AdjConfirmFeedbackStatus;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.enums.AdjConfirmTplShow;
import kd.swc.hcdm.business.adjapplication.service.AdjApprovalApplicationService;
import kd.swc.hcdm.business.adjapprbill.adjconfirm.AdjConfirmHelper;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;

public class AdjConfirmNotifyPlugin
extends AbstractBasePlugIn
implements ClickListener {
    private AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);
    private static final String REFUSE = "refuse";
    private static final String CONFIRM = "confirm";
    private static final String REFUSE_ALREADY = "refusealready";
    private static final String CONFIRM_ALREADY = "confirmalready";
    private static final String CONFIRM_TEXT = "confirmtext";
    private static final String ADJCONFIRMPERSONID = "adjConfirmPersonId";
    private static final int SESSION_TIME_LIMIT = 1800000;

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Button refuse = (Button)this.getControl(REFUSE);
        Button confirm = (Button)this.getControl(CONFIRM);
        refuse.addClickListener((ClickListener)this);
        confirm.addClickListener((ClickListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        FormShowParameter showParameter = (FormShowParameter)args.getSource();
        showParameter.setCaption(ResManager.loadKDString((String)"\u8c03\u85aa\u786e\u8ba4\u901a\u77e5\u5355", (String)"AdjConfirmNotifyPlugin_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
    }

    public void beforeBindData(EventObject eventObject) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Long adjConfirmPersonId = (Long)showParameter.getCustomParam(ADJCONFIRMPERSONID);
        if (adjConfirmPersonId == null) {
            Object pkId = showParameter.getCustomParam("pkId");
            if (null == pkId) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u94fe\u63a5\u3002", (String)"AdjConfirmNotifyPlugin_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                return;
            }
            adjConfirmPersonId = Long.parseLong((String)showParameter.getCustomParam("pkId"));
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{REFUSE, CONFIRM, REFUSE_ALREADY, CONFIRM_ALREADY});
        Long authtime = (Long)showParameter.getCustomParam("authtime");
        String client = this.getFormClient(showParameter);
        if (this.checkSessionLimit(authtime)) {
            this.openAdjConfirmLoginForm(adjConfirmPersonId, client);
        } else {
            Map adjConfirmNotify = this.adjApprovalApplicationService.queryAdjConfirmNotify(adjConfirmPersonId.longValue());
            Map contentMap = (Map)adjConfirmNotify.get(adjConfirmPersonId);
            DynamicObject adjConfirmTemplate = (DynamicObject)contentMap.get("adjConfirmTemplate");
            String buttonselect = adjConfirmTemplate.getString("buttonselect");
            boolean pcSource = AdjConfirmHelper.isPcSource((String)client);
            if (pcSource) {
                RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl(CONFIRM_TEXT);
                richTextEditor.setText((String)contentMap.get("htmlText"));
            } else {
                Html html = (Html)this.getControl(CONFIRM_TEXT);
                html.setConent((String)contentMap.get("htmlText"));
            }
            String[] selects = buttonselect.split(",");
            ArrayList<String> selectList = new ArrayList<String>(selects.length);
            for (String select : selects) {
                if (!StringUtils.isNotBlank((CharSequence)select)) continue;
                selectList.add(select);
            }
            String confirmStatus = (String)contentMap.get("confirmstatus");
            List keys = AdjConfirmTplShow.getKeysByCode(selectList);
            this.getView().getPageCache().put("selectList", JSON.toJSONString((Object)keys));
            this.setButtonVisible(keys, confirmStatus);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Long adjConfirmPersonId = (Long)showParameter.getCustomParam(ADJCONFIRMPERSONID);
        if (adjConfirmPersonId == null) {
            adjConfirmPersonId = Long.valueOf((String)showParameter.getCustomParam("pkId"));
        }
        Long authtime = (Long)showParameter.getCustomParam("authtime");
        String client = this.getFormClient(showParameter);
        String selectListJson = this.getView().getPageCache().get("selectList");
        List keys = JSON.parseArray((String)selectListJson, String.class);
        AdjConfirmFeedbackStatus adjConfirmFeedbackStatus = null;
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)REFUSE)) {
            if (this.checkSessionLimit(authtime)) {
                this.openAdjConfirmLoginForm(adjConfirmPersonId, client);
                return;
            }
            this.adjApprovalApplicationService.onLineConfirmRefuse(adjConfirmPersonId.longValue());
            this.getView().setVisible(Boolean.FALSE, new String[]{REFUSE, CONFIRM});
            adjConfirmFeedbackStatus = AdjConfirmFeedbackStatus.REFUSED;
            MultiLangEnumBridge opName2 = new MultiLangEnumBridge("\u653e\u5f03", "AdjConfirmNotifyPlugin_1", "swc-hcdm-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u653e\u5f03\u6210\u529f", "AdjConfirmNotifyPlugin_4", "swc-hcdm-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"give up", (MultiLangEnumBridge)opName2, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[0]);
        } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)CONFIRM)) {
            if (this.checkSessionLimit(authtime)) {
                this.openAdjConfirmLoginForm(adjConfirmPersonId, client);
                return;
            }
            this.adjApprovalApplicationService.onLineConfirmAgree(adjConfirmPersonId.longValue());
            this.getView().setVisible(Boolean.FALSE, new String[]{REFUSE, CONFIRM});
            adjConfirmFeedbackStatus = AdjConfirmFeedbackStatus.CONFIRMED;
            MultiLangEnumBridge opName2 = new MultiLangEnumBridge("\u786e\u8ba4", "AdjConfirmNotifyPlugin_2", "swc-hcdm-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u786e\u8ba4\u6210\u529f", "AdjConfirmNotifyPlugin_5", "swc-hcdm-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)CONFIRM, (MultiLangEnumBridge)opName2, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[0]);
        }
        if (adjConfirmFeedbackStatus != null) {
            this.setButtonVisible(keys, adjConfirmFeedbackStatus.getCode());
        }
    }

    private boolean checkSessionLimit(Long authtime) {
        return null == authtime || System.currentTimeMillis() - authtime > 1800000L;
    }

    private String getFormClient(FormShowParameter showParameter) {
        return StringUtils.contains((CharSequence)showParameter.getFormConfig().getModelType(), (CharSequence)"mobileform") ? "Mobile" : RequestContext.get().getClient();
    }

    private void openAdjConfirmLoginForm(Long adjConfirmPersonId, String client) {
        String formId = AdjConfirmHelper.formShowFormIdBySource((String)client, (String)"hcdm_pcadjlogin", (String)"hcdm_h5adjlogin");
        FormShowParameter parameter = new FormShowParameter();
        ShowType showType = ShowType.Modal;
        if (!AdjConfirmHelper.isPcSource((String)client)) {
            parameter = new MobileFormShowParameter();
            showType = ShowType.Floating;
        }
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(showType);
        parameter.setCustomParam(ADJCONFIRMPERSONID, (Object)adjConfirmPersonId);
        parameter.setParentPageId(this.getView().getFormShowParameter().getPageId());
        parameter.setCustomParam("pkId", (Object)String.valueOf(adjConfirmPersonId));
        this.getView().showForm(parameter);
    }

    private void setButtonVisible(List<String> keys, String confirmStatus) {
        if (StringUtils.isBlank((CharSequence)confirmStatus)) {
            return;
        }
        boolean isEnable = false;
        if (AdjConfirmFeedbackStatus.CONFIRMED.getCode().equals(confirmStatus)) {
            Collections.replaceAll(keys, CONFIRM, CONFIRM_ALREADY);
            isEnable = true;
        } else if (AdjConfirmFeedbackStatus.REFUSED.getCode().equals(confirmStatus)) {
            Collections.replaceAll(keys, REFUSE, REFUSE_ALREADY);
            isEnable = true;
        }
        for (String key : keys) {
            this.getView().setVisible(Boolean.TRUE, new String[]{key});
            if (!isEnable) continue;
            this.getView().setEnable(Boolean.FALSE, new String[]{key});
        }
    }
}

