/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjapprbill.adjconfirm;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcdm.business.adjapplication.domain.adjapproval.enums.AdjConfirmFeedbackStatus;
import kd.swc.hcdm.business.adjapplication.service.AdjApprovalApplicationService;
import kd.swc.hcdm.formplugin.adjapprbill.adjconfirm.AdjConfirmBaseEdit;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;

public class AdjConfirmOfflineEdit
extends AdjConfirmBaseEdit
implements BeforeF7SelectListener,
UploadListener {
    private static final Log logger = LogFactory.getLog(AdjConfirmOfflineEdit.class);
    private static final String BTN_OK = "ok";
    private AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Button ok = (Button)this.getControl(BTN_OK);
        ok.addClickListener((ClickListener)this);
        TextEdit selectpersontext = (TextEdit)this.getControl("selectpersontext");
        selectpersontext.addClickListener((ClickListener)this);
        BasedataEdit selectperson = (BasedataEdit)this.getControl("selectperson");
        selectperson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanel");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        String operateType = (String)this.getView().getFormShowParameter().getCustomParam("operatetype");
        List<Long> selectedPersonIds = this.getSelectedPersonFromParam();
        if (StringUtils.equalsIgnoreCase((CharSequence)operateType, (CharSequence)"upload")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"personpanel"});
        }
        Map adjConfirmFeedbackStatus = this.adjApprovalApplicationService.getAdjConfirmFeedbackStatus(selectedPersonIds);
        if (StringUtils.equalsIgnoreCase((CharSequence)operateType, (CharSequence)"offlineconfirm")) {
            selectedPersonIds.removeIf(aLong -> adjConfirmFeedbackStatus.get(aLong) != AdjConfirmFeedbackStatus.NOT_CONFIRM);
        }
        Map personObjs = this.adjApprovalApplicationService.queryConfirmPerson(selectedPersonIds);
        if (selectedPersonIds.isEmpty()) {
            return;
        }
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        MulBasedataProp selectperson1 = (MulBasedataProp)this.getModel().getProperty("selectperson");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)selectperson1.getBaseEntityId());
        DynamicObjectType propertyType = selectperson1.getDynamicCollectionItemPropertyType();
        for (DynamicObject dbObject : personObjs.values()) {
            DynamicObject baseObj = new DynamicObject((DynamicObjectType)dataEntityType);
            DynamicObject dynamicObject = new DynamicObject(propertyType);
            dynamicObject.set("fbasedataid", (Object)baseObj);
            dynamicObject.set("fbasedataid_id", dbObject.get("id"));
            baseObj.set("id", dbObject.get("id"));
            dynamicObjects.add((Object)dynamicObject);
        }
        this.getModel().setValue("selectperson", (Object)dynamicObjects);
        String names = personObjs.values().stream().map(object -> object.getString("person.name") + "[" + object.getString("employee.empnumber") + "]").collect(Collectors.joining(";"));
        this.getModel().setValue("selectpersontext", (Object)names);
    }

    public void afterRemove(UploadEvent evt) {
        String operateType = (String)this.getView().getFormShowParameter().getCustomParam("operatetype");
        List<Long> selectedPersonIds = this.getSelectedPersonFromParam();
        if (StringUtils.equalsIgnoreCase((CharSequence)operateType, (CharSequence)"upload")) {
            Object[] urls = evt.getUrls();
            Long confirmPersonId = selectedPersonIds.get(0);
            for (Object url : urls) {
                Map attachment = (Map)url;
                String uid = (String)attachment.get("uid");
                AttachmentServiceHelper.remove((String)"hcdm_adjconfirmperson", (Object)confirmPersonId, (Object)uid);
                this.adjApprovalApplicationService.updateAttachment(Collections.singletonList(confirmPersonId), Collections.emptyList());
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        String operateType = (String)this.getView().getFormShowParameter().getCustomParam("operatetype");
        List<Long> selectedPersonIds = this.getSelectedPersonFromParam();
        if (StringUtils.equalsIgnoreCase((CharSequence)operateType, (CharSequence)"upload")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"personpanel"});
            ArrayList attachments = Lists.newArrayList();
            Map personAttachment = this.adjApprovalApplicationService.getConfirmPersonAttachment(selectedPersonIds, false);
            for (Long personId : selectedPersonIds) {
                List maps = (List)personAttachment.get(personId);
                attachments.addAll(maps);
            }
            this.getView().getPageCache().put("attachments", SerializationUtils.toJsonString((Object)attachments));
            if (!SWCPermissionServiceHelper.hasPerm((String)"0VO5EV13=I9W", (String)"hcdm_offlineconfirm", (String)"2NJ6+I0X0CJ8")) {
                return;
            }
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanel");
            attachmentPanel.bindData((List)attachments);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "ok": {
                this.confirm();
                break;
            }
            case "selectpersontext": {
                BasedataEdit selectperson = (BasedataEdit)this.getControl("selectperson");
                selectperson.click();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        IDataEntityProperty property = args.getProperty();
        switch (property.getName()) {
            case "selectperson": {
                DynamicObjectCollection changeData = (DynamicObjectCollection)args.getChangeSet()[0].getNewValue();
                List selectedPersonIds = changeData.stream().map(object -> object.getLong("fbasedataid_id")).collect(Collectors.toList());
                Map personObjs = this.adjApprovalApplicationService.queryConfirmPerson(selectedPersonIds);
                String names = personObjs.values().stream().map(object -> object.getString("person.name") + "[" + object.getString("employee.empnumber") + "]").collect(Collectors.joining(";"));
                this.getModel().setValue("selectpersontext", (Object)names);
                break;
            }
            case "selectpersontext": {
                if (args.getChangeSet()[0].getNewValue() != null && !StringUtils.isEmpty((CharSequence)((CharSequence)args.getChangeSet()[0].getNewValue()))) break;
                this.getModel().beginInit();
                this.getModel().setValue("selectperson", null);
                this.getModel().endInit();
            }
        }
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        DynamicObjectCollection selectPersonColl = (DynamicObjectCollection)this.getModel().getValue("selectperson");
        List pkIdList = this.adjApprovalApplicationService.matchFailAttachmentIds(selectPersonColl, urls);
        Object source = evt.getSource();
        if (source instanceof AttachmentPanel && CollectionUtils.isNotEmpty((Collection)pkIdList)) {
            ((AttachmentPanel)source).getCustomProperties().put("matchFailAttachmentIds", SerializationUtils.toJsonString((Object)pkIdList));
        }
    }

    public void afterUpload(UploadEvent evt) {
        Object source = evt.getSource();
        if (source instanceof AttachmentPanel) {
            String pkIdJSON = ((AttachmentPanel)source).getCustomProperties().getOrDefault("matchFailAttachmentIds", "[]");
            logger.info("matchFailAttachmentIds is {}", (Object)pkIdJSON);
            List failerFilePkIdList = SerializationUtils.fromJsonStringToList((String)pkIdJSON, String.class);
            if (CollectionUtils.isEmpty((Collection)failerFilePkIdList)) {
                return;
            }
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanel");
            if (attachmentPanel.getAttachmentData().size() > 0) {
                List mapList = attachmentPanel.getAttachmentData();
                Iterator iterator = mapList.iterator();
                while (iterator.hasNext()) {
                    Map map = (Map)iterator.next();
                    for (Object id : failerFilePkIdList) {
                        if (!map.get("uid").toString().equals(id.toString())) continue;
                        String formId = map.get("entityNum").toString();
                        Object pkId = map.get("billPkId");
                        Object fileUid = map.get("uid");
                        AttachmentServiceHelper.remove((String)formId, pkId, fileUid);
                        attachmentPanel.remove(map);
                        iterator.remove();
                    }
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u5339\u914d\u4eba\u5458\u5931\u8d25\uff0c\u6587\u4ef6\u9700\u6309\u201c\u59d3\u540d_\u5de5\u53f7\u201d\u8fdb\u884c\u547d\u540d\u3002", (String)"AdjConfirmOfflineEdit_5", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                if (CollectionUtils.isNotEmpty((Collection)mapList)) {
                    this.addAttachmentPanelBindData(mapList);
                } else {
                    IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                    proxy.invokeControlMethod("attachmentpanel", "cancelUploadAttachment", new Object[]{failerFilePkIdList});
                }
            }
        }
    }

    private void addAttachmentPanelBindData(List<Map<String, Object>> addAttachmentMaps) {
        ArrayList attachments;
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanel");
        String attachmentStr = this.getView().getPageCache().get("attachments");
        List list = attachments = StringUtils.isBlank((CharSequence)attachmentStr) ? Lists.newArrayList() : SerializationUtils.fromJsonStringToList((String)attachmentStr, Map.class);
        if (CollectionUtils.isNotEmpty(addAttachmentMaps)) {
            attachments.addAll(addAttachmentMaps);
        }
        attachmentPanel.bindData((List)attachments);
    }

    private void doOfflineConfirm() {
        MultiLangEnumBridge opName2 = new MultiLangEnumBridge("\u786e\u5b9a", "AdjConfirmOfflineEdit_4", "swc-hcdm-formplugin");
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanel");
        List attachmentData = attachmentPanel.getAttachmentData();
        List<Long> personIds = this.getSelectedPersonFromField();
        if (CollectionUtils.isEmpty(personIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u4eba\u5458\u3002", (String)"AdjConfirmOfflineEdit_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            return;
        }
        List successPersonIds = this.adjApprovalApplicationService.submitOfflineConfirm(personIds, attachmentData);
        Collection failPersonIds = CollectionUtils.removeAll(personIds, (Collection)successPersonIds);
        if (CollectionUtils.isEmpty((Collection)successPersonIds)) {
            String message = ResManager.loadKDString((String)"\u9644\u4ef6\u5339\u914d\u4eba\u5458\u5931\u8d25\uff0c\u6587\u4ef6\u9700\u6309\u201c\u59d3\u540d_\u5de5\u53f7\u201d\u8fdb\u884c\u547d\u540d\u3002", (String)"AdjConfirmOfflineEdit_2", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u9644\u4ef6\u5339\u914d\u4eba\u5458\u5931\u8d25\uff0c\u6587\u4ef6\u9700\u6309\u201c\u59d3\u540d_\u5de5\u53f7\u201d\u8fdb\u884c\u547d\u540d\u3002", "AdjConfirmOfflineEdit_2", "swc-hcdm-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"confirm", (MultiLangEnumBridge)opName2, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[0]);
            this.getView().showTipNotification(message);
            return;
        }
        if (!failPersonIds.isEmpty()) {
            Map map = this.adjApprovalApplicationService.queryConfirmPerson((List)Lists.newArrayList((Iterable)failPersonIds));
            String names = map.values().stream().map(object -> object.getString("person.name") + "_" + object.getString("employee.empnumber")).collect(Collectors.joining(";"));
            String message = ResManager.loadKDString((String)"\u90e8\u5206\u786e\u8ba4\u5b8c\u6210\uff0c\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u4eba\u5458\u201c{0}\u201d\u7684\u9644\u4ef6\u3002", (String)"AdjConfirmOfflineEdit_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u90e8\u5206\u786e\u8ba4\u5b8c\u6210\uff0c\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u4eba\u5458\u201c{0}\u201d\u7684\u9644\u4ef6\u3002", "AdjConfirmOfflineEdit_0", "swc-hcdm-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"confirm", (MultiLangEnumBridge)opName2, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[]{names});
            this.getView().showTipNotification(MessageFormat.format(message, names));
        } else {
            String successMsg = ResManager.loadKDString((String)"\u786e\u8ba4\u5b8c\u6210", (String)"AdjConfirmOfflineEdit_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u786e\u8ba4\u5b8c\u6210", "AdjConfirmOfflineEdit_3", "swc-hcdm-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"confirm", (MultiLangEnumBridge)opName2, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[0]);
            this.getView().showSuccessNotification(successMsg);
            this.getView().close();
        }
    }

    private void confirm() {
        if (!SWCPermissionServiceHelper.hasPerm((String)"0VO5EV13=I9W", (String)"hcdm_adjapprbill", (String)"2JZRIIZRLF/I")) {
            String msg = ResManager.loadKDString((String)"\u65e0\u201c\u5458\u5de5\u5b9a\u8c03\u85aa\u7533\u8bf7\u5355\u201d\u7684\u201c\u7ebf\u4e0b\u786e\u8ba4\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AdjConfirmOfflineEdit_6", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            MultiLangEnumBridge opName2 = new MultiLangEnumBridge("\u786e\u5b9a", "AdjConfirmOfflineEdit_4", "swc-hcdm-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u65e0\u201c\u5458\u5de5\u5b9a\u8c03\u85aa\u7533\u8bf7\u5355\u201d\u7684\u201c\u7ebf\u4e0b\u786e\u8ba4\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", "AdjConfirmOfflineEdit_6", "swc-hcdm-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"confirm", (MultiLangEnumBridge)opName2, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[0]);
            return;
        }
        String operateType = (String)this.getView().getFormShowParameter().getCustomParam("operatetype");
        if (StringUtils.equalsIgnoreCase((CharSequence)operateType, (CharSequence)"upload")) {
            this.doUploadAttachment();
        } else {
            this.doOfflineConfirm();
        }
    }

    private void doUploadAttachment() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanel");
        List<Long> personIds = this.getSelectedPersonFromParam();
        List attachmentData = attachmentPanel.getAttachmentData();
        List successPersonIds = this.adjApprovalApplicationService.updateAttachment(personIds, attachmentData);
        List failPersonIds = ListUtils.removeAll(personIds, (Collection)successPersonIds);
        if (CollectionUtils.isNotEmpty((Collection)attachmentData) && !failPersonIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u5339\u914d\u4eba\u5458\u5931\u8d25\uff0c\u6587\u4ef6\u9700\u6309\u201c\u59d3\u540d_\u5de5\u53f7\u201d\u8fdb\u884c\u547d\u540d\u3002", (String)"AdjConfirmOfflineEdit_2", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().close();
        }
    }

    private List<Long> getSelectedPersonFromParam() {
        String adjConfirmPersonIds = (String)this.getView().getFormShowParameter().getCustomParam("adjconfirmpersonids");
        return Arrays.stream(StringUtils.split((String)adjConfirmPersonIds, (String)",")).map(Long::parseLong).collect(Collectors.toList());
    }

    private List<Long> getSelectedPersonFromField() {
        DynamicObjectCollection selectPerson = this.getModel().getDataEntity().getDynamicObjectCollection("selectperson");
        return selectPerson.stream().map(object -> object.getLong("fbasedataid_id")).collect(Collectors.toList());
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        long billId = this.getView().getParentView().getModel().getDataEntity().getLong("id");
        beforeF7SelectEvent.addCustomQFilter(new QFilter("adjapprovalbill", "=", (Object)billId));
        beforeF7SelectEvent.addCustomQFilter(new QFilter("confirmstatus", "=", (Object)AdjConfirmFeedbackStatus.NOT_CONFIRM.getCode()));
    }
}

