/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjapprbill.adjconfirm;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.utils.KDEncodeUtil;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcdm.business.adjapplication.service.AdjApprovalApplicationService;
import kd.swc.hcdm.business.adjapprbill.adjconfirm.AdjConfirmHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.control.SWCLabelAp;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class AdjConfirmTplEdit
extends SWCDataBaseEdit
implements ClickListener,
BeforeF7SelectListener {
    private AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);
    private static final String KEY_MAINBAR = "tbmain";
    private static final String BTN_SAVE = "bar_save";
    private static final String CONTENT = "content";
    private static final String TEMP_CONTENT = "tempcontent";
    private static final String COUNTRY = "country";
    private static final String MSGTEMPLATE = "msgtemplate";
    private static final String RICHTEXTEDITORAP = "richtexteditorap";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{KEY_MAINBAR});
        BasedataEdit countryEdit = (BasedataEdit)this.getView().getControl(COUNTRY);
        countryEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit msgTemplateEdit = (BasedataEdit)this.getView().getControl(MSGTEMPLATE);
        msgTemplateEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit", "bar_unsubmit"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_delete"});
        String content = this.getModel().getDataEntity().getString(CONTENT);
        RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl(RICHTEXTEDITORAP);
        String captionContent = this.transFieldKeyToCaption(content, false);
        richTextEditor.setText(captionContent);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.equals((Object)status)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"varflexpanelap", RICHTEXTEDITORAP});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control sControl = (Control)evt.getSource();
        Map<String, String> varParamMap = this.getVarParam();
        if (varParamMap.containsKey(sControl.getKey())) {
            AdjConfirmHelper.setArgToContent((IFormView)this.getView(), (String)varParamMap.get(sControl.getKey()), (String)RICHTEXTEDITORAP);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey;
        switch (fieldKey = event.getProperty().getName()) {
            case "country": {
                FormShowParameter formShowParameter = event.getFormShowParameter();
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a", (String)"AdjConfirmTplEdit_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "msgtemplate": {
                event.addCustomQFilter(new QFilter("msgentity", "in", (Object)new String[]{"hcdm_adjconfirmtpl", "hcdm_adjconfirmperson"}));
            }
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FlexPanelAp panelAp = this.createAbstractFlexPlanAp();
        HashMap<String, String> mapHead = new HashMap<String, String>(2);
        mapHead.put("id", "varflexpanelap");
        mapHead.put("items", (String)panelAp.createControl().get("items"));
        args.getItems().add(mapHead);
    }

    public void onGetControl(OnGetControlArgs args) {
        String key = args.getKey();
        Map<String, String> varParamMap = this.getVarParam();
        if (varParamMap.containsKey(key)) {
            Label label = new Label();
            label.setKey(key);
            label.setView(this.getView());
            label.addClickListener((ClickListener)this);
            args.setControl((Control)label);
        }
    }

    public void beforeBindData(EventObject object) {
        super.beforeBindData(object);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "bar_save": {
                RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl(RICHTEXTEDITORAP);
                this.copyRichtextedit2Content(richTextEditor.getText());
                break;
            }
        }
    }

    public void customEvent(CustomEventArgs args) {
        super.customEvent(args);
        String eventArgs = KDEncodeUtil.kdDecoding((String)args.getEventArgs());
        this.copyRichtextedit2Content(eventArgs);
    }

    private void copyRichtextedit2Content(String richtext) {
        this.getModel().setValue(CONTENT, (Object)this.transFieldKeyToCaption(richtext, true));
    }

    private String transFieldKeyToCaption(String content, boolean reverse) {
        Map<String, String> varParam = this.getVarParam();
        String fmt = "{%s}";
        String resultContent = content;
        for (Map.Entry<String, String> entry : varParam.entrySet()) {
            String propName = entry.getKey();
            String caption = entry.getValue();
            String captionParamStr = String.format(Locale.ROOT, fmt, caption);
            String propParamStr = String.format(Locale.ROOT, fmt, propName);
            if (!reverse) {
                resultContent = StringUtils.replace((String)resultContent, (String)propParamStr, (String)captionParamStr);
                continue;
            }
            resultContent = StringUtils.replace((String)resultContent, (String)captionParamStr, (String)propParamStr);
        }
        return resultContent;
    }

    private FlexPanelAp createAbstractFlexPlanAp() {
        FlexPanelAp varPanelAp = new FlexPanelAp();
        varPanelAp.setKey("flexvar");
        Map<String, String> varParamMap = this.getVarParam();
        Set<Map.Entry<String, String>> entries = varParamMap.entrySet();
        String labelNameFmt = "\u3010%s\u3011";
        for (Map.Entry<String, String> entry : entries) {
            LabelAp varLabelAp = this.createStatusLabelAp(entry.getKey().toString(), String.format(Locale.ROOT, labelNameFmt, entry.getValue()));
            varPanelAp.getItems().add(varLabelAp);
        }
        return varPanelAp;
    }

    private LabelAp createStatusLabelAp(String key, String value) {
        return new SWCLabelAp.Builder(key).setFontSize(12).setName(value).setClickable(true).setForeColor("#0E5FD8").build();
    }

    private Map<String, String> getVarParam() {
        SWCPageCache pageCache;
        boolean isVarParamMapNull = true;
        Map varParamMap = null;
        if (this.getView() != null && (varParamMap = (Map)(pageCache = new SWCPageCache(this.getView())).get("varParamKey", Map.class)) != null) {
            isVarParamMapNull = false;
        }
        if (isVarParamMapNull) {
            varParamMap = this.adjApprovalApplicationService.getVarParamMap();
            if (this.getView() != null) {
                pageCache = new SWCPageCache(this.getView());
                pageCache.put("varParamKey", JSON.toJSON((Object)varParamMap));
            }
        }
        return varParamMap;
    }
}

