/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjapprbill.analysis;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.adjapprbill.AdjApprovalGridHelper;
import kd.swc.hcdm.business.country.CountryHelper;
import kd.swc.hcdm.business.country.CountryPolicy;
import kd.swc.hcdm.business.country.CountryRefChanged;
import kd.swc.hcdm.business.enums.AdjDecisionGraphType;
import kd.swc.hcdm.common.enums.AdjNineGridSourceEnum;
import kd.swc.hcdm.common.enums.HCDMErrInfoEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class AdjDecisionConfigPlugin
extends AbstractFormPlugin
implements CountryRefChanged {
    private static final String KEY_XAXIS_PAGE = "xaxis_page";
    private static final String KEY_YAXIS_PAGE = "yaxis_page";
    public static final String KEY_XAXIS_PAGE_ID = "xaxisPageId";
    public static final String KEY_YAXIS_PAGE_ID = "yaxisPageId";
    public static final String KEY_AXIS_ID = "axis_id";
    private static final String KEY_PREVIEW = "preview";
    public static final String KEY_CREATEORG_ID = "createOrgId";

    public void registerListener(EventObject eventObject) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "save": 
            case "submit": {
                boolean passed = this.invokeChildCfgOperate("donothing_checkdata");
                args.setCancel(!passed);
                if (!this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) break;
                source.getOption().setVariableValue("AddNeWStatusBeforeOperate", OperationStatus.ADDNEW.name());
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        OperationResult result = args.getOperationResult();
        switch (operateKey = source.getOperateKey()) {
            case "save": 
            case "submit": {
                if (!result.isSuccess()) break;
                SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_axisdataconfig");
                DynamicObject xEntity = this.getAxisPage(KEY_XAXIS_PAGE).getModel().getDataEntity(true);
                DynamicObject yEntity = this.getAxisPage(KEY_YAXIS_PAGE).getModel().getDataEntity(true);
                DynamicObject[] axisObjs = new DynamicObject[]{xEntity, yEntity};
                this.checkAndResetEntryId(axisObjs);
                this.resetCfgId(axisObjs);
                serviceHelper.save(axisObjs);
                if (source.getOption().containsVariable("AddNeWStatusBeforeOperate")) {
                    AdjDecisionGraphType chartType = AdjDecisionGraphType.getByCode((int)this.getModel().getDataEntity().getInt("charttype"));
                    this.openChildCfgPage(chartType);
                    break;
                }
                this.invokeChildCfgOperate("refresh");
                break;
            }
            case "unsubmit": 
            case "unaudit": {
                this.invokeChildCfgOperate("refresh");
                break;
            }
            case "donothing_preview": {
                OpenStyle openStyle2 = new OpenStyle();
                openStyle2.setShowType(ShowType.Modal);
                StyleCss styleCss = new StyleCss();
                styleCss.setWidth("1090px");
                styleCss.setHeight("420px");
                openStyle2.setInlineStyleCss(styleCss);
                HashMap customParams = Maps.newHashMap();
                customParams.put(KEY_XAXIS_PAGE_ID, this.getPageCache().get(KEY_XAXIS_PAGE));
                customParams.put(KEY_YAXIS_PAGE_ID, this.getPageCache().get(KEY_YAXIS_PAGE));
                AdjApprovalGridHelper.showNineGridChart((IFormView)this.getView(), (String)this.getView().getPageId(), (ShowType)ShowType.InContainer, (Object)AdjNineGridSourceEnum.ADJDECISIONCONFIG.getCode(), (Map)customParams, (OpenStyle)openStyle2);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        CountryPolicy countryPolicy = CountryPolicy.createInstance().putErrorInfoEnum("country", HCDMErrInfoEnum.COMMON_CLEAR_COUNTRY_CONFIRM).delAfterConfirm(true).build();
        CountryHelper.propertyChangedForCountry((AbstractFormPlugin)this, (PropertyChangedArgs)args, (CountryPolicy)countryPolicy);
    }

    private void resetCfgId(DynamicObject[] axisObjs) {
        for (DynamicObject entity : axisObjs) {
            if (entity.get("adjsalauxdcsncfg") != null) continue;
            entity.set("adjsalauxdcsncfg", this.getModel().getDataEntity().getPkValue());
        }
    }

    private void checkAndResetEntryId(DynamicObject[] axisObjs) {
        HashSet<Long> pks = new HashSet<Long>();
        int rowNum = 0;
        for (DynamicObject axisObj : axisObjs) {
            DynamicObjectCollection entryRows = axisObj.getDynamicObjectCollection("entryentity");
            rowNum += entryRows.size();
            for (DynamicObject row : entryRows) {
                pks.add((Long)row.getPkValue());
            }
        }
        int repeatCount = rowNum - pks.size();
        if (repeatCount > 0) {
            ORM orm = ORM.create();
            HashSet<Long> unRepeatPks = new HashSet<Long>();
            long[] newEntryIds = orm.genLongIds("hcdm_axisdataconfig", repeatCount);
            int appliedIdIndex = -1;
            for (DynamicObject axisObj : axisObjs) {
                DynamicObjectCollection entryRows = axisObj.getDynamicObjectCollection("entryentity");
                for (DynamicObject row : entryRows) {
                    Object pkValue = row.getPkValue();
                    if (unRepeatPks.add((Long)pkValue)) continue;
                    row.set("id", (Object)newEntryIds[++appliedIdIndex]);
                }
            }
        }
    }

    private boolean invokeChildCfgOperate(String operate) {
        IFormView xaxisPageView = this.getAxisPage(KEY_XAXIS_PAGE);
        IFormView yaxisPageView = this.getAxisPage(KEY_YAXIS_PAGE);
        OperationResult xResult = xaxisPageView.invokeOperation(operate);
        this.getView().sendFormAction(xaxisPageView);
        OperationResult yResult = yaxisPageView.invokeOperation(operate);
        this.getView().sendFormAction(yaxisPageView);
        boolean passed = !(xResult != null && !xResult.isSuccess() || yResult != null && !yResult.isSuccess());
        StringJoiner messageJoin = new StringJoiner("\r\n");
        if (xResult != null && !xResult.isSuccess()) {
            messageJoin.add(xaxisPageView.getFormShowParameter().getCaption() + xResult.getMessage());
        }
        if (yResult != null && !yResult.isSuccess()) {
            messageJoin.add(yaxisPageView.getFormShowParameter().getCaption() + yResult.getMessage());
        }
        if (!passed) {
            this.getView().showErrorNotification(messageJoin.toString());
        }
        return passed;
    }

    private IFormView getAxisPage(String pageKey) {
        String xaxisPage = this.getPageCache().get(pageKey);
        return this.getView().getView(xaxisPage);
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        AdjDecisionGraphType chartType = AdjDecisionGraphType.getByCode((int)this.getModel().getDataEntity().getInt("charttype"));
        this.openChildCfgPage(chartType);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        CountryPolicy countryPolicy = CountryPolicy.createInstance().putErrorInfoEnum("country", HCDMErrInfoEnum.COMMON_CLEAR_COUNTRY_CONFIRM).putClearPolicy("bizitem", true).build();
        CountryHelper.confirmCallBackForCountry((AbstractFormPlugin)this, (MessageBoxClosedEvent)messageBoxClosedEvent, (CountryPolicy)countryPolicy);
    }

    private void openChildCfgPage(AdjDecisionGraphType chartType) {
        if (chartType != AdjDecisionGraphType.NINE_FLEX) {
            return;
        }
        Long xId = null;
        Long yId = null;
        Long configId = (Long)this.getModel().getDataEntity().getPkValue();
        if (configId > 0L) {
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_axisdataconfig");
            DynamicObject[] db = serviceHelper.query("id,axis,adjsalauxdcsncfg", new QFilter[]{new QFilter("adjsalauxdcsncfg", "=", (Object)configId)});
            if (db.length > 0 && db.length != 2) {
                throw new KDBizException("axis data has error");
            }
            for (DynamicObject object : db) {
                int axis = object.getInt("axis");
                if (axis == 1) {
                    xId = (Long)object.getPkValue();
                }
                if (axis != 2) continue;
                yId = (Long)object.getPkValue();
            }
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Long createOrgId = dataEntity.getLong("createorg.id");
        String xCaption = ResManager.loadKDString((String)"X\u8f74\u914d\u7f6e", (String)"AdjDecisionConfigPlugin_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String yCaption = ResManager.loadKDString((String)"Y\u8f74\u914d\u7f6e", (String)"AdjDecisionConfigPlugin_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        BaseShowParameter xFormShowParameter = new BaseShowParameter();
        xFormShowParameter.setPkId(xId);
        xFormShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
        xFormShowParameter.setFormId("hcdm_axisdataconfig");
        xFormShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        xFormShowParameter.getOpenStyle().setTargetKey("xpanel");
        xFormShowParameter.setCustomParam(KEY_AXIS_ID, (Object)1);
        xFormShowParameter.setCustomParam(KEY_CREATEORG_ID, (Object)String.valueOf(createOrgId));
        xFormShowParameter.setCaption(xCaption);
        BaseShowParameter yFormShowParameter = new BaseShowParameter();
        yFormShowParameter.setPkId((Object)yId);
        yFormShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
        yFormShowParameter.setFormId("hcdm_axisdataconfig");
        yFormShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        yFormShowParameter.getOpenStyle().setTargetKey("ypanel");
        yFormShowParameter.setCustomParam(KEY_AXIS_ID, (Object)2);
        yFormShowParameter.setCustomParam(KEY_CREATEORG_ID, (Object)String.valueOf(createOrgId));
        yFormShowParameter.setCaption(yCaption);
        this.getView().showForm((FormShowParameter)xFormShowParameter);
        this.getView().showForm((FormShowParameter)yFormShowParameter);
        this.getPageCache().put(KEY_XAXIS_PAGE, xFormShowParameter.getPageId());
        this.getPageCache().put(KEY_YAXIS_PAGE, yFormShowParameter.getPageId());
    }

    public StringJoiner getChangedInfoOfRefField(boolean isGeneral) {
        LinkedHashMap errMsgMap = new LinkedHashMap(16);
        long countryId = this.getModel().getDataEntity(true).getLong("country.id");
        List<String> xyAxis = Arrays.asList(KEY_XAXIS_PAGE, KEY_YAXIS_PAGE);
        for (String xyAxi : xyAxis) {
            IFormView axisPageView = CountryHelper.getSubPageView((String)this.getPageCache().get(xyAxi));
            if (axisPageView == null) continue;
            HCDMErrInfoEnum hcdmErrInfoEnum = KEY_XAXIS_PAGE.equals(xyAxi) ? HCDMErrInfoEnum.ADJ_DC_CFG_X_AXIS_BIZ_ITEM_CONFIRM : HCDMErrInfoEnum.ADJ_DC_CFG_Y_AXIS_BIZ_ITEM_CONFIRM;
            CountryHelper.setErrMsgMap((long)countryId, errMsgMap, (DynamicObject)axisPageView.getModel().getDataEntity(true).getDynamicObject("bizitem"), (boolean)false, (HCDMErrInfoEnum)hcdmErrInfoEnum);
        }
        StringJoiner lastErrMsgSj = new StringJoiner("");
        StringJoiner errMsgSj = new StringJoiner(HCDMErrInfoEnum.COMMON_STOP_SIGN.getMsg());
        errMsgMap.entrySet().stream().filter(entry -> ((StringJoiner)entry.getValue()).length() > 0).forEach(entry -> errMsgSj.add(((HCDMErrInfoEnum)entry.getKey()).getMsg()));
        if (errMsgSj.length() > 0) {
            lastErrMsgSj.add(HCDMErrInfoEnum.ADJ_DC_CFG_XY_AXIS_COUNTRY_CONFIRM.getMsg(new Object[]{errMsgSj.toString()}));
        }
        return lastErrMsgSj;
    }

    public boolean clearCountryRefData() {
        this.invokeChildCfgOperate("donothing_clear_biz_item");
        return true;
    }
}

