/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjapprbill.analysis;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.adjapprbill.analysis.BizItemEntryHelper;
import kd.swc.hcdm.business.country.CountryHelper;
import kd.swc.hcdm.common.constants.NineGridConstants;
import kd.swc.hcdm.common.enums.AdjDecisionAxisDataTypeEnum;
import kd.swc.hcdm.common.enums.DataTypeEnum;
import kd.swc.hcdm.common.enums.HCDMErrInfoEnum;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;

public class AxisDataConfigPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log log = LogFactory.getLog(AxisDataConfigPlugin.class);
    private String[] names = new String[]{NineGridConstants.GRID_STATIC_HIGH(), NineGridConstants.GRID_STATIC_MIDDLE(), NineGridConstants.GRID_STATIC_LOW()};

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit bd = (BasedataEdit)this.getControl("bizitem");
        MulBasedataEdit valueBd = (MulBasedataEdit)this.getControl("value");
        bd.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        valueBd.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit edit = (TextEdit)this.getControl("displayvalue");
        edit.addButtonClickListener((ClickListener)this);
        BasedataEdit bizItemCategory = (BasedataEdit)this.getControl("bizitemcategory");
        bizItemCategory.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        if ("displayvalue".equals(ctrl.getKey())) {
            MulBasedataEdit edit = (MulBasedataEdit)this.getControl("value");
            edit.click();
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("axis", customParams.get("axis_id"));
        this.setEntryNameField();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        this.resetNameByCategory(rows);
        this.resetDisplayValue(rows);
        this.resetBizItemCategoryEnt(rows);
        this.getModel().updateEntryCache(rows);
        this.getView().updateView("entryentity");
        this.updateDataByCountry();
        String status = this.getView().getParentView().getModel().getDataEntity().getString("status");
        boolean lock = status.equals("C") || status.equals("B");
        this.getView().setEnable(Boolean.valueOf(!lock), new String[]{"bizitemcategory", "bizitem", "entryentity"});
    }

    private void setEntryNameField() {
        String axisId = (String)this.getModel().getValue("axis");
        String name = "";
        if (axisId.equals(AdjDecisionAxisDataTypeEnum.X_AXIS.getValue())) {
            name = ResManager.loadKDString((String)"X\u8f74\u5404\u533a\u95f4\u540d\u79f0", (String)"AxisDataConfigPlugin_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        } else if (axisId.equals(AdjDecisionAxisDataTypeEnum.Y_AXIS.getValue())) {
            name = ResManager.loadKDString((String)"Y\u8f74\u5404\u533a\u95f4\u540d\u79f0", (String)"AxisDataConfigPlugin_2", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        }
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        grid.setColumnProperty("name", "header", (Object)name);
    }

    private void createDefaultEntry(DynamicObjectCollection rows) {
        for (int i = 0; i < 3; ++i) {
            DynamicObject row = new DynamicObject(rows.getDynamicObjectType());
            row.set("index", (Object)i);
            rows.add((Object)row);
        }
    }

    private void resetDisplayValue(DynamicObjectCollection rows) {
        for (DynamicObject row : rows) {
            String displayValue = this.getDisplayValue(row.getDynamicObjectCollection("value"));
            row.set("displayvalue", (Object)displayValue);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "donothing_checkdata": {
                this.checkDataMustInput(args);
                break;
            }
            case "donothing_clear_biz_item": {
                this.updateDataByCountry();
                break;
            }
        }
    }

    private void checkDataMustInput(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        boolean isEmpty = rows.isEmpty();
        for (DynamicObject row : rows) {
            DynamicObjectCollection value = row.getDynamicObjectCollection("value");
            if (value.isEmpty()) {
                isEmpty = true;
                break;
            }
            String name = row.getString("name");
            if (!StringUtils.isBlank((CharSequence)name)) continue;
            isEmpty = true;
            break;
        }
        if (isEmpty) {
            args.setCancel(true);
            args.setCancelMessage(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"AxisDataConfigPlugin_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void resetBizItemCategoryEnt(DynamicObjectCollection rows) {
        DynamicObject bizitemcategory = (DynamicObject)this.getModel().getValue("bizitemcategory");
        if (bizitemcategory != null) {
            String bizItemCategoryName = bizitemcategory.getString("name");
            for (DynamicObject row : rows) {
                row.set("bizitemcategoryent", (Object)bizItemCategoryName);
            }
        }
    }

    private void resetNameByCategory(DynamicObjectCollection rows) {
        if (rows.size() != 3) {
            rows.clear();
            this.createDefaultEntry(rows);
            for (int i = 0; i < rows.size(); ++i) {
                DynamicObject row = (DynamicObject)rows.get(i);
                row.set("name", (Object)this.names[row.getInt("index")]);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        Object newValue = args.getChangeSet()[0].getNewValue();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        switch (name) {
            case "bizitemcategory": {
                this.checkBizItemByCategory((DynamicObject)newValue);
                this.resetBizItemCategoryEnt(rows);
                this.getModel().updateEntryCache(rows);
                this.getView().updateView("entryentity");
                break;
            }
            case "bizitem": {
                this.setCategoryByBizItem((DynamicObject)newValue);
                this.clearEntryValue();
                this.getView().updateView("entryentity");
                break;
            }
            case "value": {
                String displayValue = this.getDisplayValue((DynamicObjectCollection)newValue);
                this.getModel().setValue("displayvalue", (Object)displayValue, args.getChangeSet()[0].getRowIndex());
                break;
            }
            case "displayvalue": {
                if (newValue != null && !newValue.equals("")) break;
                this.getModel().setValue("value", null, args.getChangeSet()[0].getRowIndex());
                break;
            }
        }
    }

    private String getDisplayValue(DynamicObjectCollection newValue) {
        ArrayList displayValueList = Lists.newArrayListWithCapacity((int)newValue.size());
        int dataType = this.getModel().getDataEntity().getInt("bizitem.datatype");
        boolean isInterval = this.getModel().getDataEntity().getBoolean("bizitem.isinterval");
        DataTypeEnum dataTypeEnum = DataTypeEnum.getByCode((int)dataType);
        for (DynamicObject object : newValue) {
            DynamicObject valueObj = object.getDynamicObject("fbasedataid");
            String singleValueStr = valueObj.getString("name");
            String displayValue = BizItemEntryHelper.dbValueToDisplayValue((DataTypeEnum)dataTypeEnum, (boolean)isInterval, (String)singleValueStr);
            displayValueList.add(displayValue);
        }
        return StringUtils.join((Object[])displayValueList.toArray(new String[0]), (String)"\uff1b");
    }

    private void clearEntryValue() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject row : rows) {
            row.set("value", null);
            row.set("displayvalue", null);
        }
        this.getModel().updateEntryCache(rows);
    }

    private void setCategoryByBizItem(DynamicObject bizItem) {
        long categoryId = this.getModel().getDataEntity().getLong("bizitemcategory.id");
        if (categoryId == 0L && bizItem != null) {
            this.getModel().setValue("bizitemcategory", (Object)bizItem.getDynamicObject("bizitemcategory"));
        }
    }

    private void checkBizItemByCategory(DynamicObject category) {
        DynamicObject bizItem = this.getModel().getDataEntity().getDynamicObject("bizitem");
        if (category == null || bizItem != null && !category.getPkValue().equals(bizItem.getLong("bizitemcategory.id"))) {
            this.getModel().setValue("bizitem", null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String property;
        Long createOrgId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("createOrgId"));
        switch (property = beforeF7SelectEvent.getProperty().getName()) {
            case "bizitem": {
                if (CountryHelper.checkInvalidAndSetFilter((DynamicObject)this.getView().getParentView().getModel().getDataEntity(true), null, (String)"hcdm_bizitem", (List)beforeF7SelectEvent.getCustomQFilters())) {
                    this.getView().showTipNotification(HCDMErrInfoEnum.COMMON_COUNTRY_NOT_EXISTS.getMsg());
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                long categoryId = this.getModel().getDataEntity().getLong("bizitemcategory.id");
                if (categoryId > 0L) {
                    beforeF7SelectEvent.addCustomQFilter(new QFilter("bizitemcategory.id", "=", (Object)categoryId));
                }
                QFilter useOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hcdm_bizitem", (Long)createOrgId);
                beforeF7SelectEvent.addCustomQFilter(useOrgFilter);
                break;
            }
            case "value": {
                long bizItemId = this.getModel().getDataEntity().getLong("bizitem.id");
                List<Long> selectedEntryIds = this.fetchBizItemEntryIds();
                beforeF7SelectEvent.addCustomQFilter(new QFilter("bizitemid", "=", (Object)bizItemId));
                beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "not in", selectedEntryIds));
                break;
            }
            case "bizitemcategory": {
                QFilter orgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hcdm_bizitemcategory", (Long)createOrgId);
                if (orgFilter == null) break;
                beforeF7SelectEvent.addCustomQFilter(orgFilter);
                break;
            }
        }
    }

    private List<Long> fetchBizItemEntryIds() {
        ArrayList ids = Lists.newArrayList();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject row : rows) {
            DynamicObjectCollection objects = row.getDynamicObjectCollection("value");
            for (DynamicObject object : objects) {
                ids.add(object.getLong("fbasedataid_id"));
            }
        }
        return ids;
    }

    private void updateDataByCountry() {
        long countryId;
        DynamicObject bizItemDy = this.getModel().getDataEntity(true).getDynamicObject("bizitem");
        if (CountryHelper.isCountryChanged((DynamicObject)bizItemDy, (long)(countryId = this.getView().getParentView().getModel().getDataEntity(true).getLong("country.id")), (boolean)false)) {
            this.getModel().setValue("bizitem", null);
            this.getView().updateView("bizitem");
        }
    }
}

