/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjapprbill.analysis;

import com.alibaba.fastjson.JSONObject;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.impl.util.DynamicObjectJsonSerializer;
import kd.swc.hcdm.business.adjapprbill.analysis.BizDataEntryHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import org.apache.commons.lang3.StringUtils;

public class BizDataBatchImportPlugin
extends BatchImportPlugin {
    private Log log = LogFactory.getLog(BizDataBatchImportPlugin.class);
    private static String DATA_SOURCE_CACHE_KEY = "IMPORT_DATA_SOURCE";
    private static String BIZDATA_IMPORT_APP_CACHE_KEY = "BIZDATA_IMPORT_APP_CACHE_KEY";
    private String importBizDataSource = this.getBizDataSource().getString("number");

    public List<ComboItem> getOverrideFieldsConfig() {
        List comboItems = super.getOverrideFieldsConfig();
        comboItems.removeIf(comboItem -> StringUtils.equals((CharSequence)comboItem.getValue(), (CharSequence)"bizitement") || StringUtils.equals((CharSequence)comboItem.getValue(), (CharSequence)"value"));
        return comboItems;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        Iterator<ImportBillData> it = billdatas.iterator();
        long start = System.currentTimeMillis();
        while (it.hasNext()) {
            ImportBillData bill = it.next();
            if (bill.isEmpty()) continue;
            JSONObject bizDataSource = new JSONObject();
            bizDataSource.put("number", (Object)this.importBizDataSource);
            bill.getData().put("bizdatasource", (Object)bizDataSource);
        }
        long cost = System.currentTimeMillis() - start;
        this.log.info("beforeSave cost: {}", (Object)cost);
    }

    private DynamicObject getBizDataSource() {
        ISWCAppCache appCache = SWCAppCache.get((String)BIZDATA_IMPORT_APP_CACHE_KEY);
        String bizDataSourceJSONString = (String)appCache.get(DATA_SOURCE_CACHE_KEY, String.class);
        if (bizDataSourceJSONString == null) {
            DynamicObject bizDataSourceDyObj = BizDataEntryHelper.queryBizDataSource((String)"1020_S");
            bizDataSourceJSONString = DynamicObjectJsonSerializer.convertDynamicObjectToJson((DynamicObject)bizDataSourceDyObj);
            appCache.put(DATA_SOURCE_CACHE_KEY, (Object)bizDataSourceJSONString);
        }
        return DynamicObjectJsonSerializer.parseDynamicObjectJson((String)bizDataSourceJSONString, (String)"hcdm_bizdatasource");
    }
}

