/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjapprbill.analysis;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.swc.hcdm.business.adjapprbill.analysis.BizDataEntryHelper;
import kd.swc.hcdm.business.adjapprbill.analysis.BizItemEntryHelper;
import kd.swc.hcdm.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.dynamic.control.SWCDecimalEdit;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainerBaseHelper;

public class BizDataEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener,
BasedataFuzzySearchListener {
    private static String BIZDATA_PERSON_CALLBACK = "bizdatapersoncallback";
    private static String BIZITEM = "bizitem";
    private static String BIZITEMENT = "bizitement";
    private static String VALUE = "value";
    private static String BIZITEMCATEGORY = "bizitemcategory";
    private String[] valueFileds = new String[]{BIZITEMENT, VALUE, "bizitementdecimal", "bizitementtext", "bizitementdate"};

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addBeforeF7SelectListener("person", BIZITEM, BIZITEMENT);
        this.addClickListeners(new String[]{"bizitementdecimal", "bizitementtext", "bizitementdate"});
        BasedataEdit bizItemEntControl = (BasedataEdit)this.getView().getControl(BIZITEMENT);
        bizItemEntControl.addBasedataFuzzySearchListener((BasedataFuzzySearchListener)this);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        args.getItems().add(this.createDynamicFieldMeta());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (formOperate.getOperateKey()) {
            case "save": 
            case "saveandnew": {
                this.setBizDataSource();
                this.setValueField();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ((StringUtils.equals((CharSequence)"save", (CharSequence)formOperate.getOperateKey()) || StringUtils.equals((CharSequence)"saveandnew", (CharSequence)formOperate.getOperateKey())) && Boolean.parseBoolean(formOperate.getOption().getVariableValue("isValueNull", "false"))) {
            this.checkField();
        }
    }

    private void checkField() {
        IDataModel model = this.getModel();
        DynamicObject bizItemDyObj = (DynamicObject)model.getValue(BIZITEM);
        DataTypeEnum datatype = DataTypeEnum.getByCode((int)bizItemDyObj.getInt("datatype"));
        boolean isInterval = bizItemDyObj.getBoolean("isinterval");
        String exitMeg = ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"DecideSalaryCommonEdit_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        ArrayList<FieldTip> fieldTips = new ArrayList<FieldTip>(5);
        FieldTip fieldTip = new FieldTip();
        fieldTip.setSuccess(false);
        fieldTip.setTip(exitMeg);
        if (isInterval) {
            switch (datatype) {
                case NUMBER: 
                case PERCENT: {
                    fieldTip.setFieldKey("bizitementdecimal");
                    break;
                }
                case TEXT: {
                    fieldTip.setFieldKey("bizitementtext");
                    break;
                }
                case DATE: {
                    fieldTip.setFieldKey("bizitementdate");
                    break;
                }
            }
        } else {
            fieldTip.setFieldKey(BIZITEMENT);
        }
        fieldTips.add(fieldTip);
        this.getView().showFieldTips(fieldTips);
    }

    private void setBizDataSource() {
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        if (pkValue == 0L) {
            DynamicObject bizDataSourceDyObj = BizDataEntryHelper.queryBizDataSource((String)"1010_S");
            this.getModel().setValue("bizdatasource", (Object)bizDataSourceDyObj.getLong("id"));
        }
    }

    public void initImportData(InitImportDataEventArgs args) {
        SystemParamServiceHelper.loadPublicParametersFromCache().put("import_basedata_checkperm", Boolean.TRUE);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData changeData = args.getChangeSet()[0];
        DynamicObject bizItemDyObj = (DynamicObject)model.getValue(BIZITEM);
        DataTypeEnum datatype = null;
        if (bizItemDyObj != null) {
            datatype = DataTypeEnum.getByCode((int)bizItemDyObj.getInt("datatype"));
        }
        switch (name) {
            case "bizitemcategory": {
                this.clearBizitemOrBizItemEnt(name);
                break;
            }
            case "bizitem": {
                this.clearBizitemOrBizItemEnt(name);
                this.updateFieldPrecisionProp(this.getModel().getDataEntity().getString("bizitem.scale"), datatype);
                if (datatype != null && bizItemDyObj != null) {
                    boolean isInterval = bizItemDyObj.getBoolean("isinterval");
                    if (isInterval) {
                        this.setFieldVisibleByDataType(datatype);
                    } else {
                        this.initFieldVisible();
                    }
                }
                String scaleStr = this.getModel().getDataEntity().getString("bizitem.scale");
                this.getPageCache().put("scale", scaleStr);
                int scale = StringUtils.isEmpty((CharSequence)scaleStr) ? 10 : Integer.parseInt(scaleStr);
                this.createControlPanelAp(scale);
                break;
            }
            case "bizitement": {
                boolean isInterval;
                if (datatype != DataTypeEnum.DATE || bizItemDyObj == null || (isInterval = bizItemDyObj.getBoolean("isinterval"))) break;
                DynamicObject dateDyObj = (DynamicObject)changeData.getNewValue();
                this.dbDateValueToDisplayDateValue(dateDyObj);
                break;
            }
            case "bizitementtext": {
                this.getModel().setDataChanged(false);
                String text = (String)changeData.getNewValue();
                this.getModel().setValue(VALUE, (Object)text);
                break;
            }
            case "bizitementdecimal": {
                this.getModel().setDataChanged(false);
                BigDecimal decimal = (BigDecimal)changeData.getNewValue();
                this.getModel().setValue(VALUE, (Object)(decimal == null ? null : decimal.toString()));
                break;
            }
            case "bizitementdate": {
                this.getModel().setDataChanged(false);
                Date date = (Date)changeData.getNewValue();
                Long dateTime = date == null ? null : Long.valueOf(date.getTime());
                this.getModel().setValue(VALUE, (Object)dateTime);
                break;
            }
        }
    }

    private void setValueField() {
        DynamicObject bizItemDyObj = (DynamicObject)this.getModel().getValue(BIZITEM);
        if (bizItemDyObj == null) {
            return;
        }
        DataTypeEnum datatype = DataTypeEnum.getByCode((int)bizItemDyObj.getInt("datatype"));
        switch (datatype) {
            case NUMBER: 
            case PERCENT: {
                if (this.getModel().getValue("bizitementdecimal") == null) break;
                this.getModel().setValue(VALUE, (Object)this.getModel().getValue("bizitementdecimal").toString());
                break;
            }
            case TEXT: {
                if (this.getModel().getValue("bizitementtext") == null) break;
                this.getModel().setValue(VALUE, this.getModel().getValue("bizitementtext"));
                break;
            }
            case DATE: {
                if (this.getModel().getValue("bizitementdate") == null) break;
                Date date = (Date)this.getModel().getValue("bizitementdate");
                Long dateTime = date.getTime();
                this.getModel().setValue(VALUE, (Object)dateTime);
                break;
            }
        }
    }

    private void updateFieldPrecisionProp(String scaleStr, DataTypeEnum datatype) {
        boolean isNumberType;
        boolean bl = isNumberType = DataTypeEnum.NUMBER == datatype || DataTypeEnum.PERCENT == datatype;
        if (!isNumberType) {
            return;
        }
        int scale = StringUtils.isEmpty((CharSequence)scaleStr) ? 2 : Integer.parseInt(scaleStr);
        SWCDecimalEdit decimalMin = (SWCDecimalEdit)this.getView().getControl("bizitementdecimal");
        decimalMin.updateScale(scale);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        IDataEntityProperty property = event.getProperty();
        switch (property.getName()) {
            case "person": {
                this.openAdjFilePerson(event);
                break;
            }
            case "bizitem": {
                this.openBizItem(event);
                break;
            }
            case "bizitement": {
                this.openBizItemEnt(event);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (BIZDATA_PERSON_CALLBACK.equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            this.setParentData((ListSelectedRowCollection)returnData);
        }
    }

    private void addBeforeF7SelectListener(String ... fields) {
        for (String filed : fields) {
            BasedataEdit control = (BasedataEdit)this.getView().getControl(filed);
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private void openAdjFilePerson(BeforeF7SelectEvent event) {
        event.setCancel(true);
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hcdm_adjfileperson", (boolean)false);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BIZDATA_PERSON_CALLBACK));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void setParentData(ListSelectedRowCollection selectedRows) {
        if (selectedRows == null) {
            return;
        }
        Object[] pkIds = selectedRows.getPrimaryKeyValues();
        Object pkId = pkIds[0];
        QFilter filter = new QFilter("id", "=", pkId);
        DynamicObject adjFileInfoDynamicObject = BizDataEntryHelper.queryAdjFilePerson((QFilter)filter);
        this.getModel().setValue("person", (Object)adjFileInfoDynamicObject.getLong("person_id"));
    }

    private void openBizItem(BeforeF7SelectEvent event) {
        DynamicObject bizItemCategoryDyObj = (DynamicObject)this.getModel().getValue(BIZITEMCATEGORY);
        QFilter qFilter = new QFilter("bizitemcategory", "in", (Object)bizItemCategoryDyObj.getLong("id"));
        qFilter.and("status", "in", (Object)"C");
        event.addCustomQFilter(qFilter);
    }

    private void openBizItemEnt(BeforeF7SelectEvent event) {
        DynamicObject bizItemDyObj = (DynamicObject)this.getModel().getValue(BIZITEM);
        QFilter qFilter = new QFilter("bizitemid", "=", (Object)bizItemDyObj.getLong("id"));
        event.addCustomQFilter(qFilter);
    }

    private void clearBizitemOrBizItemEnt(String key) {
        if (key.equals(BIZITEMCATEGORY)) {
            this.getModel().setValue(BIZITEM, null);
        }
        for (String valueFiled : this.valueFileds) {
            this.getModel().setValue(valueFiled, null);
        }
    }

    private Map<String, Object> createDynamicFieldMeta() {
        FlexPanelAp headAp = this.createFlexPanelAp(2);
        HashMap<String, Object> mapHead = new HashMap<String, Object>();
        mapHead.put("id", "valuepanelap");
        mapHead.put("items", headAp.createControl().get("items"));
        return mapHead;
    }

    private FlexPanelAp createFlexPanelAp(int scale) {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"hcdm_bizdata", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        return BizDataEntryHelper.createFlexPanelAp((EntityMetadata)entityMetadata, (int)scale);
    }

    private void createControlPanelAp(int scale) {
        FlexPanelAp headAp = this.createFlexPanelAp(scale);
        Container fldPanel = (Container)this.getView().getControl("valuepanelap");
        fldPanel.getItems().addAll(((Container)headAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(fldPanel.getItems());
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        MainEntityType oldMainType = args.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        String cachedScale = this.getPageCache().get("scale");
        int scale = StringUtils.isEmpty((CharSequence)cachedScale) ? 10 : Integer.parseInt(cachedScale);
        List param = BizDataEntryHelper.createFlexBuildParam(null, (int)scale);
        EntryParamContainerBaseHelper.registProp((List)param, (EntityType)((BasedataEntityType)newMainType.getAllEntities().get("hcdm_bizdata")));
        args.setNewEntityType(newMainType);
    }

    public void beforeBindData(EventObject eventObject) {
        this.getPageCache().put("scale", this.getModel().getDataEntity().getString("bizitem.scale"));
        BasedataEdit bizItemEntEdit = (BasedataEdit)this.getView().getControl(BIZITEMENT);
        bizItemEntEdit.setMustInput(true);
        this.createControlPanelAp(10);
        this.initFieldVisible();
        DynamicObject bizItemDyObj = (DynamicObject)this.getModel().getValue(BIZITEM);
        if (bizItemDyObj != null) {
            DataTypeEnum datatype = DataTypeEnum.getByCode((int)bizItemDyObj.getInt("datatype"));
            if (bizItemDyObj.getBoolean("isinterval")) {
                this.setFieldVisibleByDataType(datatype);
                this.syncFieldValue(datatype);
            }
        }
    }

    public void afterCopyData(EventObject eventObject) {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        for (String filed : this.valueFileds) {
            dynamicObject.set(filed, null);
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject eventObject) {
        if (this.isIntervalDateField()) {
            DynamicObject dateDyObj = (DynamicObject)this.getModel().getValue(BIZITEMENT);
            this.dbDateValueToDisplayDateValue(dateDyObj);
        }
    }

    private void dbDateValueToDisplayDateValue(DynamicObject dateDyObj) {
        String dateStr = dateDyObj.getString("name");
        String displayValue = BizItemEntryHelper.dbValueToDisplayValue((DataTypeEnum)DataTypeEnum.DATE, (boolean)false, (String)dateStr);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty(BIZITEMENT, "v", (Object)displayValue);
    }

    private void initFieldVisible() {
        this.getView().setVisible(Boolean.TRUE, new String[]{BIZITEMENT});
        this.getView().setVisible(Boolean.FALSE, new String[]{"bizitementdecimal", "bizitementtext", "bizitementdate"});
    }

    private void setFieldVisibleByDataType(DataTypeEnum datatype) {
        if (datatype == null) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{BIZITEMENT});
        switch (datatype) {
            case NUMBER: 
            case PERCENT: {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bizitementdecimal"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bizitementtext", "bizitementdate"});
                break;
            }
            case TEXT: {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bizitementtext"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bizitementdecimal", "bizitementdate"});
                break;
            }
            case DATE: {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bizitementdate"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bizitementdecimal", "bizitementtext"});
                break;
            }
        }
    }

    private void syncFieldValue(DataTypeEnum datatype) {
        String value = (String)this.getModel().getValue(VALUE);
        if (datatype == null || StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        switch (datatype) {
            case NUMBER: 
            case PERCENT: {
                this.getModel().setValue("bizitementdecimal", (Object)BizItemEntryHelper.stringToDecimal((String)value));
                break;
            }
            case TEXT: {
                this.getModel().setValue("bizitementtext", (Object)value);
                break;
            }
            case DATE: {
                this.getModel().setValue("bizitementdate", (Object)BizItemEntryHelper.stringToDate((String)value));
                break;
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void onGetControl(OnGetControlArgs args) {
        String key;
        super.onGetControl(args);
        switch (key = args.getKey()) {
            case "bizitementtext": {
                TextEdit textEdit = new TextEdit();
                textEdit.setKey("bizitementtext");
                textEdit.setView(this.getView());
                textEdit.setMustInput(true);
                args.setControl((Control)textEdit);
                break;
            }
            case "bizitementdate": {
                DateEdit dateEdit = new DateEdit();
                dateEdit.setKey("bizitementdate");
                dateEdit.setView(this.getView());
                dateEdit.setMustInput(true);
                args.setControl((Control)dateEdit);
                break;
            }
            case "bizitementdecimal": {
                SWCDecimalEdit decimalEdit = new SWCDecimalEdit();
                decimalEdit.setKey("bizitementdecimal");
                decimalEdit.setView(this.getView());
                decimalEdit.setMustInput(true);
                args.setControl((Control)decimalEdit);
                break;
            }
        }
    }

    public void handleData(BasedataFuzzySearchEvent basedataFuzzySearchEvent) {
        if (this.isIntervalDateField()) {
            List queryData = basedataFuzzySearchEvent.getQueryData();
            for (Object data : queryData) {
                List list = (List)data;
                String dbValue = (String)list.get(2);
                String displayValue = BizItemEntryHelper.dbValueToDisplayValue((DataTypeEnum)DataTypeEnum.DATE, (boolean)false, (String)dbValue);
                list.set(2, displayValue);
            }
        }
    }

    private boolean isIntervalDateField() {
        boolean isInterval;
        DynamicObject bizItemDyObj = (DynamicObject)this.getModel().getValue(BIZITEM);
        DataTypeEnum datatype = null;
        return bizItemDyObj != null && (datatype = DataTypeEnum.getByCode((int)bizItemDyObj.getInt("datatype"))) == DataTypeEnum.DATE && !(isInterval = bizItemDyObj.getBoolean("isinterval"));
    }
}

