/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjapprbill.analysis;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hcdm.business.adjapprbill.analysis.BizDataEntryHelper;
import kd.swc.hcdm.business.adjapprbill.analysis.BizItemCategoryHelper;
import kd.swc.hcdm.formplugin.adjapprbill.analysis.BizDataBatchImportPlugin;
import kd.swc.hcdm.formplugin.downloadtemplate.BizDataDownloadTemplatePlugin;
import kd.swc.hcdm.formplugin.imports.ImportStartCommonPlugin;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;
import org.apache.commons.lang3.StringUtils;

public class BizDataList
extends SWCDataBaseList {
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"importdata"});
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                for (DynamicObject row : rows) {
                    String displayValue;
                    DynamicObjectType dyType = row.getDynamicObjectType();
                    DynamicProperty bizItemProperty = dyType.getProperty("bizitem");
                    DynamicProperty valueProperty = dyType.getProperty("value");
                    if (bizItemProperty == null || valueProperty == null || (displayValue = BizDataEntryHelper.getDisplayValueOfBizDataList((DynamicObject)row)) == null) continue;
                    row.set("value", (Object)displayValue);
                }
                return rows;
            }
        });
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        IFormView view = this.getView();
        if (StringUtils.equals((CharSequence)"importdata", (CharSequence)itemKey)) {
            Long userId = RequestContext.get().getCurrUserId();
            boolean superUser = SWCPermissionServiceHelper.isSuperUser();
            boolean hasPermByPermItemNum = SWCPermissionServiceHelper.hasPermByPermItemNum((long)userId, (String)"0VO5EV13=I9W", (String)"hcdm_bizdata", (String)"QXX0020");
            if (superUser || hasPermByPermItemNum) {
                String name = ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e", (String)"BizDataList_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
                String downloadPluginPath = BizDataDownloadTemplatePlugin.class.getName();
                String importStartPluginPath = ImportStartCommonPlugin.class.getName();
                String batchImportPluginPath = BizDataBatchImportPlugin.class.getName();
                FormShowParameter showParameter = BizItemCategoryHelper.showParamImportStart((IFormView)view, (String)name, (String)downloadPluginPath, (String)importStartPluginPath, (String)batchImportPluginPath);
                this.getView().showForm(showParameter);
            }
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent event) {
        DynamicObject[] queryValues;
        for (DynamicObject queryValue : queryValues = event.getQueryValues()) {
            String displayValue = BizDataEntryHelper.getDisplayValueOfBizDataList((DynamicObject)queryValue);
            if (displayValue == null) continue;
            queryValue.set("value", (Object)displayValue);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName;
        super.filterContainerBeforeF7Select(args);
        switch (fieldName = args.getFieldName()) {
            case "bizitemcategory.name": {
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                this.setBizItemCategoryFilter(qFilters);
                args.getCustomQFilters().addAll(qFilters);
                break;
            }
            case "bizitem.name": {
                ArrayList<QFilter> itemQFilters = new ArrayList<QFilter>();
                this.setBizItemFilter(itemQFilters);
                args.getCustomQFilters().addAll(itemQFilters);
                break;
            }
        }
    }

    private void setBizItemCategoryFilter(List<QFilter> qFilters) {
        List hasPermOrgs;
        QFilter baseDataFilter;
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"28", (String)"hcdm", (String)((ListView)this.getView()).getBillFormId(), (String)"47150e89000000ac");
        if (permOrgs != null && !permOrgs.hasAllOrgPerm() && (baseDataFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hcdm_bizitemcategory", (List)(hasPermOrgs = permOrgs.getHasPermOrgs()), (boolean)true)) != null) {
            qFilters.add(baseDataFilter);
        }
    }

    private void setBizItemFilter(List<QFilter> qFilters) {
        List hasPermOrgs;
        QFilter baseDataFilter;
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"28", (String)"hcdm", (String)((ListView)this.getView()).getBillFormId(), (String)"47150e89000000ac");
        if (permOrgs != null && !permOrgs.hasAllOrgPerm() && (baseDataFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hcdm_bizitem", (List)(hasPermOrgs = permOrgs.getHasPermOrgs()), (boolean)true)) != null) {
            qFilters.add(baseDataFilter);
        }
    }
}

