/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjapprbill.analysis;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.DecimalProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.adjapprbill.analysis.BizItemEntryHelper;
import kd.swc.hcdm.business.country.CountryHelper;
import kd.swc.hcdm.business.country.CountryPolicy;
import kd.swc.hcdm.common.enums.DataTypeEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.dynamic.control.SWCDecimalEdit;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainerBaseHelper;
import org.apache.commons.lang.StringUtils;

public class BizItemEntryPlugin
extends AbstractFormPlugin
implements EntryGridBindDataListener {
    private static final String CALLBACK_CLEAR_ENTRY_DATATYPE = "callback_clear_entry_datatype";
    private static final String CALLBACK_CLEAR_ENTRY_ISINTERVAL = "callback_clear_entry_isinterval";
    private static final String PAGECACHE_KEY_FIELD_TEMP = "pagecache_key_field_temp";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        EntryGrid control = this.getEntryControl();
        control.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        args.getItems().add(this.createEntryMeta());
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        if (StringUtils.contains((String)key, (String)"decimal") || StringUtils.contains((String)key, (String)"percent")) {
            SWCDecimalEdit decimalEdit = new SWCDecimalEdit();
            decimalEdit.setKey(key);
            decimalEdit.setFieldKey(key);
            decimalEdit.setView(this.getView());
            decimalEdit.setEntryKey("entryentity");
            decimalEdit.setEntryControlKey("entryentity");
            args.setControl((Control)decimalEdit);
            return;
        }
        switch (key) {
            case "date": {
                DateEdit dateEdit = new DateEdit();
                dateEdit.setKey(key);
                dateEdit.setFieldKey(key);
                dateEdit.setView(this.getView());
                dateEdit.setEntryKey("entryentity");
                dateEdit.setEntryControlKey("entryentity");
                args.setControl((Control)dateEdit);
                break;
            }
        }
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        MainEntityType oldMainType = args.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException ignore) {
            return;
        }
        String cachedScale = this.getPageCache().get("scale");
        int scale = StringUtils.isEmpty((String)cachedScale) ? 2 : Integer.parseInt(cachedScale);
        List entryBuildParam = BizItemEntryHelper.createEntryBuildParam(null, (DataTypeEnum)DataTypeEnum.NUMBER, (boolean)false, (int)scale);
        EntryParamContainerBaseHelper.registProp((List)entryBuildParam, (EntityType)((EntityType)newMainType.getAllEntities().get("entryentity")));
        args.setNewEntityType(newMainType);
    }

    public void beforeBindData(EventObject eventObject) {
        this.getEntryControl();
        DataTypeEnum datatype = DataTypeEnum.getByCode((int)this.getModel().getDataEntity().getInt("datatype"));
        boolean isInterval = this.getModel().getDataEntity().getBoolean("isinterval");
        this.setEntryFieldVisibleByDataType(datatype, isInterval);
        this.syncToValueField(datatype, isInterval);
        this.updateFieldCaption(datatype, isInterval);
        this.setFieldMustInput(datatype);
        String scale = this.getModel().getDataEntity().getString("scale");
        this.getPageCache().put("scale", scale);
        this.updateFieldPrecisionProp(scale, datatype);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Boolean isCopy = (Boolean)formShowParameter.getCustomParam("iscopy");
        if (isCopy != null && isCopy.booleanValue()) {
            String pkId = ((BaseShowParameter)this.getView().getFormShowParameter()).getPkId().toString();
            this.copyData(Long.valueOf(pkId));
        }
        CountryHelper.afterBindDataForCountry((AbstractFormPlugin)this);
    }

    private void copyData(Long pkId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_bizitem");
        QFilter filter = new QFilter("id", "=", (Object)pkId);
        DynamicObject dyn = helper.queryOne("ctrlstrategy", new QFilter[]{filter});
        this.getModel().setValue("ctrlstrategy", (Object)dyn.getString("ctrlstrategy"));
    }

    private EntryGrid getEntryControl() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        if (entryGrid.getItems().size() > 3) {
            return entryGrid;
        }
        entryGrid.getItems().clear();
        for (String entryField : BizItemEntryHelper.ALL_ENTRY_FIELDS) {
            Control control = this.getControl(entryField);
            if (control == null) continue;
            entryGrid.getItems().add(control);
        }
        return entryGrid;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "callback_clear_entry_datatype": {
                this.getEntryControl();
                if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                    boolean isInterval = this.getModel().getDataEntity().getBoolean("isinterval");
                    DataTypeEnum datatype = DataTypeEnum.getByCode((int)this.getModel().getDataEntity().getInt("datatype"));
                    this.setFieldMustInput(datatype);
                    this.setEntryFieldVisibleByDataType(datatype, isInterval);
                    this.clearDataWhenDataTypeChanged();
                    this.updateFieldCaption(datatype, isInterval);
                    break;
                }
                String str = this.getPageCache().get(PAGECACHE_KEY_FIELD_TEMP);
                this.getModel().beginInit();
                this.getModel().setValue("datatype", (Object)str);
                this.getView().updateView("datatype");
                this.getModel().endInit();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (formOperate.getOperateKey()) {
            case "newentry": {
                this.getEntryControl();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "save": 
            case "submit": 
            case "audit": {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"hcdm_bizitementtobd");
                DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)mainEntityType);
                for (DynamicObject dynamicObject : entryEntity) {
                    cacheManager.removeByPrimaryKey(new Object[]{dynamicObject.getLong("id")});
                }
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        boolean isInterval = this.getModel().getDataEntity().getBoolean("isinterval");
        DataTypeEnum datatype = DataTypeEnum.getByCode((int)this.getModel().getDataEntity().getInt("datatype"));
        this.getEntryControl();
        switch (propName) {
            case "datatype": {
                if (this.getModel().getEntryRowCount("entryentity") > 0) {
                    String message = ResManager.loadKDString((String)"\u5207\u6362\u6570\u636e\u7c7b\u578b\uff0c\u5c06\u540c\u6b65\u5220\u9664\u503c\u5217\u8868\u4fe1\u606f\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"BizItemEntryHelper_07", (String)"swc-hcdm-business", (Object[])new Object[0]);
                    this.getPageCache().put(PAGECACHE_KEY_FIELD_TEMP, changeData.getOldValue() == null ? "" : changeData.getOldValue().toString());
                    ConfirmCallBackListener listener = new ConfirmCallBackListener(CALLBACK_CLEAR_ENTRY_DATATYPE, (IFormPlugin)this);
                    this.getView().showConfirm(message, MessageBoxOptions.OKCancel, listener);
                    break;
                }
                this.setFieldMustInput(datatype);
                this.setEntryFieldVisibleByDataType(datatype, isInterval);
                this.clearDataWhenDataTypeChanged();
                this.updateFieldCaption(datatype, isInterval);
                break;
            }
            case "isinterval": {
                this.setFieldMustInput(datatype);
                this.setEntryFieldVisibleByDataType(datatype, isInterval);
                this.updateFieldCaption(datatype, isInterval);
                this.updateFieldPrecisionProp(this.getModel().getDataEntity().getString("scale"), datatype);
                break;
            }
            case "scale": {
                String scaleStr = (String)changeData.getNewValue();
                this.getPageCache().put("scale", scaleStr);
                this.formatDecimal(scaleStr, datatype, isInterval);
                this.updateFieldPrecisionProp(this.getModel().getDataEntity().getString("scale"), datatype);
                break;
            }
            case "daterange_startdate": 
            case "daterange_enddate": {
                Date startDate = changeData.getDataEntity().getDate("daterange_startdate");
                Date endDate = changeData.getDataEntity().getDate("daterange_enddate");
                this.getModel().setValue("value", (Object)BizItemEntryHelper.dateRangeToString((Date)startDate, (Date)endDate), changeData.getRowIndex());
                break;
            }
            case "decimal_min": 
            case "percent_min": {
                if (isInterval) {
                    BigDecimal minValue = (BigDecimal)changeData.getNewValue();
                    BigDecimal maxValue = changeData.getDataEntity().getBigDecimal(BizItemEntryHelper.getPartOfIntervalName((String)propName, (boolean)false));
                    this.getModel().setValue("value", (Object)BizItemEntryHelper.decimalRangeToString((BigDecimal)minValue, (BigDecimal)maxValue), changeData.getRowIndex());
                    break;
                }
                BigDecimal value = (BigDecimal)changeData.getNewValue();
                this.getModel().setValue("value", (Object)BizItemEntryHelper.decimalToString((BigDecimal)value), changeData.getRowIndex());
                break;
            }
            case "decimal_max": 
            case "percent_max": {
                BigDecimal maxV = (BigDecimal)changeData.getNewValue();
                BigDecimal minV = changeData.getDataEntity().getBigDecimal(BizItemEntryHelper.getPartOfIntervalName((String)propName, (boolean)true));
                this.getModel().setValue("value", (Object)BizItemEntryHelper.decimalRangeToString((BigDecimal)minV, (BigDecimal)maxV), changeData.getRowIndex());
                break;
            }
            case "date": {
                Date date = (Date)changeData.getNewValue();
                this.getModel().setValue("value", (Object)BizItemEntryHelper.dateToString((Date)date), changeData.getRowIndex());
                break;
            }
        }
        CountryPolicy countryPolicy = CountryPolicy.createInstance().putErrorInfoEnum("areatype", null).putErrorInfoEnum("country", null).build();
        CountryHelper.propertyChangedForCountry((AbstractFormPlugin)this, (PropertyChangedArgs)args, (CountryPolicy)countryPolicy);
    }

    private void formatDecimal(String scaleStr, DataTypeEnum datatype, boolean isInterval) {
        boolean isNumberType;
        boolean bl = isNumberType = DataTypeEnum.NUMBER == datatype || DataTypeEnum.PERCENT == datatype;
        if (!isNumberType) {
            return;
        }
        int scale = StringUtils.isEmpty((String)scaleStr) ? 2 : Integer.parseInt(scaleStr);
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        ArrayList fields = Lists.newArrayList();
        if (datatype == DataTypeEnum.NUMBER) {
            fields.add("decimal_min");
            if (isInterval) {
                fields.add("decimal_max");
            }
        }
        if (datatype == DataTypeEnum.PERCENT) {
            fields.add("percent_min");
            if (isInterval) {
                fields.add("percent_max");
            }
        }
        for (String field : fields) {
            DecimalProp property = (DecimalProp)this.getModel().getEntryEntity("entryentity").getDynamicObjectType().getProperty(field);
            property.setScale(scale);
        }
        for (int i = 0; i < rows.size(); ++i) {
            DynamicObject row = (DynamicObject)rows.get(i);
            for (String field : fields) {
                BigDecimal oldValue = row.getBigDecimal(field);
                if (oldValue == null) continue;
                this.getModel().setValue(field, (Object)oldValue.setScale(scale, 1).stripTrailingZeros(), i);
            }
        }
    }

    private void updateFieldPrecisionProp(String scaleStr, DataTypeEnum datatype) {
        int scale;
        boolean isNumberType;
        boolean bl = isNumberType = DataTypeEnum.NUMBER == datatype || DataTypeEnum.PERCENT == datatype;
        if (!isNumberType) {
            return;
        }
        int n = scale = StringUtils.isEmpty((String)scaleStr) ? 2 : Integer.parseInt(scaleStr);
        if (DataTypeEnum.NUMBER == datatype) {
            SWCDecimalEdit decimalMin = (SWCDecimalEdit)this.getView().getControl("decimal_min");
            SWCDecimalEdit decimalMax = (SWCDecimalEdit)this.getView().getControl("decimal_max");
            decimalMin.updateScale(scale);
            decimalMax.updateScale(scale);
        } else {
            SWCDecimalEdit percentMin = (SWCDecimalEdit)this.getView().getControl("percent_min");
            SWCDecimalEdit percentMax = (SWCDecimalEdit)this.getView().getControl("percent_max");
            percentMin.updateScale(scale);
            percentMax.updateScale(scale);
        }
    }

    private void setFieldMustInput(DataTypeEnum datatype) {
        FieldEdit precision = (FieldEdit)this.getControl("scale");
        FieldEdit edit = (FieldEdit)this.getControl("datalength");
        boolean isNumberType = DataTypeEnum.NUMBER == datatype || DataTypeEnum.PERCENT == datatype;
        precision.setMustInput(isNumberType);
        edit.setMustInput(DataTypeEnum.TEXT == datatype);
    }

    private void updateFieldCaption(DataTypeEnum datatype, boolean isInterval) {
        HashMap<String, LocaleString> captionMap = new HashMap<String, LocaleString>();
        switch (datatype) {
            case NUMBER: {
                if (isInterval) {
                    captionMap.put("decimal_min", new LocaleString(BizItemEntryHelper.MIN_CAPTION()));
                    break;
                }
                captionMap.put("decimal_min", new LocaleString(BizItemEntryHelper.VALUE_CAPTION()));
                break;
            }
            case PERCENT: {
                if (isInterval) {
                    captionMap.put("percent_min", new LocaleString(BizItemEntryHelper.MIN_CAPTION() + "(%)"));
                    break;
                }
                captionMap.put("percent_min", new LocaleString(BizItemEntryHelper.VALUE_CAPTION() + "(%)"));
                break;
            }
        }
        for (Map.Entry entry : captionMap.entrySet()) {
            FieldEdit edit = (FieldEdit)this.getControl((String)entry.getKey());
            edit.setCaption((LocaleString)entry.getValue());
        }
    }

    private Map<String, Object> createEntryMeta() {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"hcdm_bizitem", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        String scaleStr = this.getModel() == null ? "" : this.getModel().getDataEntity().getString("scale");
        int scale = StringUtils.isEmpty((String)scaleStr) ? 2 : Integer.parseInt(scaleStr);
        EntryAp entryAP = BizItemEntryHelper.createEntryAp((EntityMetadata)entityMetadata, (DataTypeEnum)DataTypeEnum.NUMBER, (boolean)false, (int)scale);
        HashMap<String, Object> mapEntry = new HashMap<String, Object>();
        mapEntry.put("id", "entryentity");
        mapEntry.put("columns", entryAP.createControl().get("columns"));
        return mapEntry;
    }

    private void clearDataWhenDataTypeChanged() {
        this.getModel().setValue("datalength", null);
        this.getModel().deleteEntryData("entryentity");
    }

    private void syncToValueField(DataTypeEnum datatype, boolean isInterval) {
        if (datatype == null) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity.isEmpty()) {
            return;
        }
        switch (datatype) {
            case NUMBER: {
                for (DynamicObject row : entryEntity) {
                    row.set("decimal_min", (Object)BizItemEntryHelper.stringToDecimalRange((String)row.getString("value"), (boolean)true));
                    if (!isInterval) continue;
                    row.set("decimal_max", (Object)BizItemEntryHelper.stringToDecimalRange((String)row.getString("value"), (boolean)false));
                }
                break;
            }
            case PERCENT: {
                for (DynamicObject row : entryEntity) {
                    row.set("percent_min", (Object)BizItemEntryHelper.stringToDecimalRange((String)row.getString("value"), (boolean)true));
                    if (!isInterval) continue;
                    row.set("percent_max", (Object)BizItemEntryHelper.stringToDecimalRange((String)row.getString("value"), (boolean)false));
                }
                break;
            }
            case DATE: {
                for (DynamicObject row : entryEntity) {
                    if (isInterval) {
                        row.set("daterange_startdate", (Object)BizItemEntryHelper.stringToDateRange((String)row.getString("value"), (boolean)true));
                        row.set("daterange_enddate", (Object)BizItemEntryHelper.stringToDateRange((String)row.getString("value"), (boolean)false));
                        continue;
                    }
                    row.set("date", (Object)BizItemEntryHelper.stringToDate((String)row.getString("value")));
                }
                break;
            }
        }
        this.getModel().updateEntryCache(entryEntity);
    }

    private void setEntryFieldVisibleByDataType(DataTypeEnum datatype, boolean isInterval) {
        if (datatype == null) {
            return;
        }
        String[] needUseFields = this.getNeedUseFields(datatype, isInterval);
        this.getView().setVisible(Boolean.TRUE, needUseFields);
        this.getView().setVisible(Boolean.FALSE, BizItemEntryHelper.getEntryFieldNotIn((String[])needUseFields));
    }

    private String[] getNeedUseFields(DataTypeEnum datatype, boolean isInterval) {
        String[] needUseFields = null;
        switch (datatype) {
            case TEXT: {
                needUseFields = new String[]{"value", "valuedescription"};
                break;
            }
            case NUMBER: {
                String[] stringArray;
                if (isInterval) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "decimal_min";
                    stringArray2[1] = "decimal_max";
                    stringArray = stringArray2;
                    stringArray2[2] = "valuedescription";
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = "decimal_min";
                    stringArray = stringArray3;
                    stringArray3[1] = "valuedescription";
                }
                needUseFields = stringArray;
                break;
            }
            case PERCENT: {
                String[] stringArray;
                if (isInterval) {
                    String[] stringArray4 = new String[3];
                    stringArray4[0] = "percent_min";
                    stringArray4[1] = "percent_max";
                    stringArray = stringArray4;
                    stringArray4[2] = "valuedescription";
                } else {
                    String[] stringArray5 = new String[2];
                    stringArray5[0] = "percent_min";
                    stringArray = stringArray5;
                    stringArray5[1] = "valuedescription";
                }
                needUseFields = stringArray;
                break;
            }
            case DATE: {
                String[] stringArray;
                if (isInterval) {
                    String[] stringArray6 = new String[2];
                    stringArray6[0] = "daterange";
                    stringArray = stringArray6;
                    stringArray6[1] = "valuedescription";
                } else {
                    String[] stringArray7 = new String[2];
                    stringArray7[0] = "date";
                    stringArray = stringArray7;
                    stringArray7[1] = "valuedescription";
                }
                needUseFields = stringArray;
                break;
            }
        }
        return needUseFields;
    }
}

