/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjapprbill.analysis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcdm.business.SalaryStandardSerializationUtils;
import kd.swc.hcdm.business.adjapplication.domain.adjfile.service.AdjFileDomainService;
import kd.swc.hcdm.business.adjapprbill.AdjApprovalGridHelper;
import kd.swc.hcdm.business.adjapprbill.AdjBillEntryImpHelper;
import kd.swc.hcdm.business.adjapprbill.BillExRateManager;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprCreateGridHelper;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprGridHelper;
import kd.swc.hcdm.business.adjapprbill.analysis.AxisDataConfigHelper;
import kd.swc.hcdm.business.adjapprbill.analysis.BizDataEntryHelper;
import kd.swc.hcdm.business.adjapprbill.analysis.BizItemEntryHelper;
import kd.swc.hcdm.business.adjapprbill.analysis.NineGridCacheHelper;
import kd.swc.hcdm.business.adjapprbill.analysis.NineGridHelper;
import kd.swc.hcdm.business.adjapprbill.entity.RankingListEntity;
import kd.swc.hcdm.business.adjapprbill.enums.AxisTypeEnum;
import kd.swc.hcdm.business.adjapprbill.enums.CalcType;
import kd.swc.hcdm.business.calculate.SalaryStdCalculateHelper;
import kd.swc.hcdm.business.converter.DecimalConverter;
import kd.swc.hcdm.business.helper.DynamicObjectValueHelper;
import kd.swc.hcdm.common.constants.DecAdjApprConstants;
import kd.swc.hcdm.common.constants.NineGridConstants;
import kd.swc.hcdm.common.enums.AdjDecisionAxisDataTypeEnum;
import kd.swc.hcdm.common.enums.AdjNineGridSourceEnum;
import kd.swc.hcdm.common.enums.DataTypeEnum;
import kd.swc.hcdm.common.utils.FieldDataUtils;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.business.imports.ValidateResults;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCGridUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class NineGridPlugin
extends AbstractBasePlugIn
implements AfterF7SelectListener,
BeforeF7SelectListener {
    private Log log = LogFactory.getLog(NineGridPlugin.class);
    private static final String KEY_YAXIS = "yaxis_name";
    private static final String KEY_XAXIS = "xaxis_name";
    private static final String KEY_STANDARDITEM = "standarditem";
    private static final String KEY_DECISION_CONFIG = "decisionconfig";
    private static final String KEY_SEL_ALL = "selall";
    private static final String KEY_NINE_YAXIS = "yaxisname";
    private static final String KEY_NINE_XAXIS = "xaixsname";
    private static final String LBL_PERSONNUM = "personnum";
    private static final String LBL_PERCENTVALUE = "percentvalue";
    private static final String LBL_ADJTOTALPROPORTION = "adjtotalproportion";
    private static final int KEY_NINE = 9;
    private static final String KEY_COLORMAP = "entryentityColorMap";
    private static final String AXIS_SIGN = "axis_sign";
    private String[] xAxisSeriesNames = new String[]{"labelap62", "labelap61", "labelap6"};
    private String[] yAxisSeriesNames = new String[]{"labelap1", "labelap2", "labelap3"};
    private List<String> suffixList = Lists.newArrayList((Object[])new String[]{"02", "01", "00", "12", "11", "10", "22", "21", "20"});
    private static final String HIGH_COLOR = "#26B175";
    private static final String LOW_COLOR = "#FD6C6A";
    private static final int INDEX_ITEMID = 1;
    private static final int INDEX_CFGID = 0;
    private static final int INDEX_NINEGRID = 1;
    private static final int INDEX_AXIS = 0;
    private static final int INDEX_BIZITEMID = 1;
    private AdjFileDomainService adjFileDomainService = (AdjFileDomainService)DomainFactory.getInstance(AdjFileDomainService.class);

    public void initialize() {
        if (this.checkParentView()) {
            return;
        }
        this.refreshEntryEntityColor();
    }

    private void refreshEntryEntityColor() {
        String colorMapjson = this.getView().getPageCache().get(KEY_COLORMAP);
        if (colorMapjson == null) {
            return;
        }
        Map colorMap = (Map)SerializationUtils.fromJsonString((String)colorMapjson, Map.class);
        IClientViewProxy clientService = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        DynamicObjectCollection entryEntity = new DynamicObjectCollection();
        DynamicObject[] entryEntities = AdjBillEntryImpHelper.getDynamicEntryData((IFormView)this.getView().getParentView());
        entryEntities = Arrays.stream(entryEntities).filter(dyObj -> dyObj.getBigDecimal("dy_amount") != null).collect(Collectors.toList()).toArray(new DynamicObject[0]);
        entryEntity.addAll(Arrays.asList(entryEntities));
        for (int i = 0; i < entryEntity.size(); ++i) {
            SWCGridUtils.setGridStyle((IClientViewProxy)clientService, (String)"entryentity", (int)i, (String)"compare", (String)((String)colorMap.get(String.valueOf(i))));
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addAfterF7SelectListener(KEY_DECISION_CONFIG);
        List<String> checkboxKeyList = this.generateKey("checkbox");
        for (String checkbox : checkboxKeyList) {
            this.addClickListeners(new String[]{checkbox});
        }
        BasedataEdit decisionCfg = (BasedataEdit)this.getControl(KEY_DECISION_CONFIG);
        decisionCfg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object source = formShowParameter.getCustomParam("source");
        if (source.equals(AdjNineGridSourceEnum.ADJDECISIONCONFIG.getCode())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1", "flexpanelap4", KEY_SEL_ALL, "checkbox02", "flexpanelap58", "checkbox01", "checkbox00", "checkbox12", "checkbox11", "checkbox10", "checkbox22", "checkbox21", "checkbox20"});
            this.updateViewByAdjDecisionConfig();
            this.getView().setFormTitle(new LocaleString(ResManager.loadKDString((String)"\u9884\u89c8", (String)"NineGridPlugin_8", (String)"swc-hcdm-formplugin", (Object[])new Object[0])));
        } else if (source.equals(AdjNineGridSourceEnum.ADJAPPROVEBILL.getCode())) {
            if (this.checkParentView()) {
                return;
            }
            this.initStandardItemCombo(NineGridHelper.collectStandardItemData((DynamicObjectCollection)this.getAdjDetailEntDynamicObjectCollection()));
            String cfgIdAndStdItemId = NineGridCacheHelper.getCfgIdAndStdItemId((String)this.getAdjApprovalBillNo());
            DynamicObject salaryadjscm = (DynamicObject)this.getParentView().getModel().getValue("salaryadjscm");
            if (Objects.nonNull(salaryadjscm)) {
                this.initAxisNameCombo(NineGridHelper.collectAxisTypeData((DynamicObject)salaryadjscm));
            }
            if (null == cfgIdAndStdItemId || null == salaryadjscm || !salaryadjscm.getBoolean("isadjdecision")) {
                this.initNineGridChart(null, null);
            } else {
                String[] parseKey = NineGridCacheHelper.parseKey((String)cfgIdAndStdItemId);
                String itemId = parseKey[1];
                String cfgId = parseKey[0];
                Long itemIdentity = SWCStringUtils.equals((String)"null", (String)itemId) ? null : Long.valueOf(itemId);
                Long cfgIdentity = SWCStringUtils.equals((String)"null", (String)cfgId) ? null : Long.valueOf(cfgId);
                this.initNineGridChart(itemIdentity, cfgIdentity);
            }
        }
    }

    private void updateViewByAdjDecisionConfig() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String xaxisPageId = (String)customParams.get("xaxisPageId");
        String yaxisPageId = (String)customParams.get("yaxisPageId");
        IFormView xaxisView = this.getView().getView(xaxisPageId);
        IFormView yaxisView = this.getView().getView(yaxisPageId);
        DynamicObject xaxisDataEntity = xaxisView.getModel().getDataEntity(true);
        DynamicObject yaxisDataEntity = yaxisView.getModel().getDataEntity(true);
        this.setAxisCategoryName(xaxisDataEntity, yaxisDataEntity);
    }

    private void setAxisCategoryName(DynamicObject ... dyObjs) {
        for (DynamicObject dyObj : dyObjs) {
            Label label;
            if (dyObj == null) continue;
            String axisId = dyObj.getString("axis");
            IFormView gridView = this.getView();
            String aixsname = dyObj.getString("bizitemcategory.name");
            DynamicObjectCollection rows = dyObj.getDynamicObjectCollection("entryentity");
            this.setNineGridAxisNameByCategory(rows, aixsname, axisId);
            if (axisId.equals(AdjDecisionAxisDataTypeEnum.X_AXIS.getValue())) {
                label = (Label)gridView.getControl(KEY_NINE_XAXIS);
                label.setText(aixsname);
                this.setNameByAxisName(rows, this.xAxisSeriesNames);
                continue;
            }
            if (!axisId.equals(AdjDecisionAxisDataTypeEnum.Y_AXIS.getValue())) continue;
            label = (Label)gridView.getControl(KEY_NINE_YAXIS);
            label.setText(aixsname);
            this.setNameByAxisName(rows, this.yAxisSeriesNames);
        }
    }

    private void setNameByAxisName(DynamicObjectCollection rows, String[] axisSeriesNames) {
        for (int i = 0; i < rows.size(); ++i) {
            DynamicObject row = (DynamicObject)rows.get(i);
            String axisName = axisSeriesNames[i];
            Label label = (Label)this.getView().getControl(axisName);
            label.setText(row.getString("name"));
        }
    }

    private void setNineGridAxisNameByCategory(DynamicObjectCollection rows, String categoryName, String axisId) {
        String xbizitemcategoryName = "";
        String ybizitemcategoryName = "";
        if (axisId.equals(AdjDecisionAxisDataTypeEnum.X_AXIS.getValue())) {
            xbizitemcategoryName = categoryName;
        } else if (axisId.equals(AdjDecisionAxisDataTypeEnum.Y_AXIS.getValue())) {
            ybizitemcategoryName = categoryName;
        }
        ArrayList yaxisCategoryName = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList xaxisCategoryName = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList yaxisNames = Lists.newArrayListWithExpectedSize((int)3);
        ArrayList xaxisNames = Lists.newArrayListWithExpectedSize((int)3);
        for (DynamicObject row : rows) {
            if (axisId.equals(AdjDecisionAxisDataTypeEnum.X_AXIS.getValue())) {
                xaxisNames.add(row.getString("name"));
                continue;
            }
            if (!axisId.equals(AdjDecisionAxisDataTypeEnum.Y_AXIS.getValue())) continue;
            yaxisNames.add(row.getString("name"));
        }
        IPageCache pageCache = this.getView().getPageCache();
        String finalYbizitemcategoryName = ybizitemcategoryName == null ? "" : ybizitemcategoryName;
        yaxisNames.forEach(o1 -> yaxisCategoryName.add(o1 + finalYbizitemcategoryName));
        String finalXbizitemcategoryName = xbizitemcategoryName == null ? "" : xbizitemcategoryName;
        xaxisNames.forEach(o1 -> xaxisCategoryName.add(o1 + finalXbizitemcategoryName));
        if (CollectionUtil.isNotEmpty((Collection)yaxisCategoryName)) {
            pageCache.put("ybizitemcategoryName", JSONObject.toJSONString((Object)yaxisCategoryName));
        }
        if (CollectionUtil.isNotEmpty((Collection)xaxisCategoryName)) {
            pageCache.put("xbizitemcategoryName", JSONObject.toJSONString((Object)xaxisCategoryName));
        }
        List xbizitemcategoryNameCache = JSON.parseArray((String)pageCache.get("xbizitemcategoryName"), String.class);
        List ybizitemcategoryNameCache = JSON.parseArray((String)pageCache.get("ybizitemcategoryName"), String.class);
        if (CollectionUtil.isNotEmpty((Collection)xbizitemcategoryNameCache) && CollectionUtil.isNotEmpty((Collection)ybizitemcategoryNameCache)) {
            Map nineGridNameMap = NineGridHelper.createAxisNames((List)ybizitemcategoryNameCache, (List)xbizitemcategoryNameCache);
            this.log.info("\u4e5d\u5bab\u683c[nineGridNameMap] = {}", (Object)JSON.toJSONString((Object)nineGridNameMap));
            for (Map.Entry entry : nineGridNameMap.entrySet()) {
                Label label = (Label)this.getView().getControl("bizname" + (String)entry.getKey());
                label.setText((String)entry.getValue());
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        FormShowParameter showParameter = (FormShowParameter)args.getSource();
        showParameter.setCaption(ResManager.loadKDString((String)"\u8c03\u85aa\u8f85\u52a9\u51b3\u7b56\u4fe1\u606f", (String)"NineGridPlugin_7", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String axisSign;
        Map itemMap;
        if (this.checkParentView()) {
            return;
        }
        String key = args.getProperty().getName();
        if (SWCStringUtils.equals((String)KEY_STANDARDITEM, (String)key)) {
            this.updateNineGridByItem(args.getChangeSet()[0].getNewValue());
        }
        DynamicObject salaryadjscm = (DynamicObject)this.getParentView().getModel().getValue("salaryadjscm");
        Map axisTypeMapping = null;
        Map axisTypeData = null;
        if (salaryadjscm != null) {
            axisTypeMapping = NineGridHelper.getAxisTypeMapping((DynamicObject)salaryadjscm);
            axisTypeData = NineGridHelper.collectAxisTypeData((DynamicObject)salaryadjscm);
        }
        List<String> checkboxKeyList = this.generateKey("checkbox");
        if (SWCStringUtils.equals((String)KEY_SEL_ALL, (String)key)) {
            this.getModel().beginInit();
            checkboxKeyList.forEach(checkbox -> this.getModel().setValue(checkbox, this.getModel().getValue(KEY_SEL_ALL)));
            this.updateNineGridRankingList();
            this.getModel().endInit();
        } else if (SWCStringUtils.equals((String)"rankinglistsort", (String)key)) {
            this.getModel().beginInit();
            this.updateNineGridRankingList();
            this.getModel().endInit();
        } else if (SWCStringUtils.equals((String)KEY_YAXIS, (String)key) && salaryadjscm != null) {
            String yAxisTypeValue = (String)this.getModel().getValue(KEY_YAXIS);
            if (StringUtils.isBlank((CharSequence)yAxisTypeValue)) {
                return;
            }
            Multimap XTypeMultimap = (Multimap)axisTypeMapping.get("xtype");
            Collection xTypeIds = XTypeMultimap.get((Object)yAxisTypeValue);
            Map xAxisTypeData = (Map)axisTypeData.get("xtype");
            itemMap = Maps.filterKeys((Map)xAxisTypeData, xTypeIds::contains);
            axisSign = this.getView().getPageCache().get(AXIS_SIGN);
            if (KEY_YAXIS.equals(axisSign) || StringUtils.isBlank((CharSequence)axisSign)) {
                this.setComboItems(FieldDataUtils.buildComboItem((Map)itemMap), KEY_XAXIS);
                this.getView().getPageCache().put(AXIS_SIGN, KEY_YAXIS);
                if (!CollectionUtils.isEmpty((Map)itemMap)) {
                    this.getView().getPageCache().put("isPropertyChanged", "true");
                    this.getModel().setValue(KEY_XAXIS, itemMap.keySet().stream().findFirst().get());
                }
            }
            this.updateNineGridByDecisionCfgId(salaryadjscm);
        } else if (SWCStringUtils.equals((String)KEY_XAXIS, (String)key) && axisTypeMapping != null && axisTypeData != null) {
            String xAxisTypeValue = (String)this.getModel().getValue(KEY_XAXIS);
            if (StringUtils.isBlank((CharSequence)xAxisTypeValue)) {
                return;
            }
            Multimap yTypeMultimap = (Multimap)axisTypeMapping.get("ytype");
            Collection yTypeIds = yTypeMultimap.get((Object)xAxisTypeValue);
            Map yAxisTypeData = (Map)axisTypeData.get("ytype");
            itemMap = Maps.filterKeys((Map)yAxisTypeData, yTypeIds::contains);
            axisSign = this.getView().getPageCache().get(AXIS_SIGN);
            if (KEY_XAXIS.equals(axisSign) || StringUtils.isBlank((CharSequence)axisSign)) {
                this.setComboItems(FieldDataUtils.buildComboItem((Map)itemMap), KEY_YAXIS);
                this.getView().getPageCache().put(AXIS_SIGN, KEY_XAXIS);
                if (!CollectionUtils.isEmpty((Map)itemMap)) {
                    this.getView().getPageCache().put("isPropertyChanged", "true");
                    this.getModel().setValue(KEY_YAXIS, itemMap.keySet().stream().findFirst().get());
                }
            }
            this.updateNineGridByDecisionCfgId(salaryadjscm);
        }
        if (checkboxKeyList.contains(key)) {
            this.getModel().beginInit();
            int num = 0;
            for (String checkboxKey : checkboxKeyList) {
                Boolean checkboxValue = (Boolean)this.getModel().getValue(checkboxKey);
                if (!checkboxValue.booleanValue()) continue;
                ++num;
            }
            if (num == 0) {
                this.getModel().setValue(KEY_SEL_ALL, (Object)Boolean.FALSE);
            } else if (num == checkboxKeyList.size()) {
                this.getModel().setValue(KEY_SEL_ALL, (Object)Boolean.TRUE);
            } else {
                this.getModel().setValue(KEY_SEL_ALL, (Object)Boolean.FALSE);
            }
            this.updateNineGridRankingList();
            this.getModel().endInit();
        }
        for (String checkboxKey : checkboxKeyList) {
            this.getView().updateView(checkboxKey);
        }
        this.getView().updateView(KEY_SEL_ALL);
    }

    private void updateNineGridRankingList() {
        DynamicObject decisionConfig = (DynamicObject)this.getModel().getValue(KEY_DECISION_CONFIG);
        String itemIdentity = (String)this.getModel().getValue(KEY_STANDARDITEM);
        Long itemId = itemIdentity == null ? null : Long.valueOf(itemIdentity);
        Long decisionCfgId = decisionConfig == null ? null : Long.valueOf(decisionConfig.getLong("id"));
        this.initNineGridChart(itemId, decisionCfgId);
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "decisionconfig": {
                if (this.checkParentView()) break;
                String pkId = (String)evt.getInputValue();
                this.setAxisName(Long.valueOf(pkId));
                String itemIdentity = (String)this.getModel().getValue(KEY_STANDARDITEM);
                Long itemId = itemIdentity == null ? null : Long.valueOf(itemIdentity);
                this.initNineGridChart(itemId, Long.valueOf(pkId));
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        this.getModel().setValue(KEY_SEL_ALL, (Object)Boolean.TRUE);
        List<String> checkboxKeyList = this.generateKey("checkbox");
        for (String checkbox : checkboxKeyList) {
            this.getModel().setValue(checkbox, (Object)Boolean.TRUE);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "donothing_refreshninegrid": {
                if (this.checkParentView()) {
                    args.setCancel(true);
                    break;
                }
                this.initStandardItemCombo(NineGridHelper.collectStandardItemData((DynamicObjectCollection)this.getAdjDetailEntDynamicObjectCollection()));
                String cfgIdAndStdItemId = NineGridCacheHelper.getCfgIdAndStdItemId((String)this.getAdjApprovalBillNo());
                DynamicObject salaryadjscm = (DynamicObject)this.getParentView().getModel().getValue("salaryadjscm");
                if (null == cfgIdAndStdItemId || null == salaryadjscm || !salaryadjscm.getBoolean("isadjdecision")) {
                    this.initNineGridChart(null, null);
                    break;
                }
                String[] parseKey = NineGridCacheHelper.parseKey((String)cfgIdAndStdItemId);
                String itemId = parseKey[1];
                String cfgId = parseKey[0];
                Long itemIdentity = SWCStringUtils.equals((String)"null", (String)itemId) ? null : Long.valueOf(itemId);
                Long cfgIdentity = SWCStringUtils.equals((String)"null", (String)cfgId) ? null : Long.valueOf(cfgId);
                this.initNineGridChart(itemIdentity, cfgIdentity);
                break;
            }
            case "donothing_refreshlittlek": {
                if (this.checkParentView()) {
                    args.setCancel(true);
                    break;
                }
                AdjApprovalGridHelper.openLittleKAnalyze((IFormView)this.getView().getParentView(), (IFormView)this.getView(), (AdjNineGridSourceEnum)AdjNineGridSourceEnum.ADJDECISIONCONFIG);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name;
        switch (name = beforeF7SelectEvent.getProperty().getName()) {
            case "decisionconfig": {
                if (this.checkParentView()) {
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                DynamicObjectCollection nineGridEnts = this.getParentView().getModel().getDataEntity().getDynamicObjectCollection("salaryadjscm.ninegrid");
                List<Object> cfgIds = new ArrayList(10);
                if (null != nineGridEnts) {
                    cfgIds = nineGridEnts.stream().map(dy -> dy.getLong("adjdecisioncfg.id")).collect(Collectors.toList());
                }
                beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", cfgIds));
            }
        }
    }

    private void updateNineGridByItem(Object newValue) {
        if (null == newValue) {
            return;
        }
        String newStr = newValue.toString();
        Long itemIdentity = SWCStringUtils.isEmpty((String)newStr) ? Long.valueOf(0L) : Long.valueOf(newStr);
        DynamicObject decisionConfig = (DynamicObject)this.getModel().getValue(KEY_DECISION_CONFIG);
        Long decisionCfgId = decisionConfig == null ? null : Long.valueOf(decisionConfig.getLong("id"));
        this.initNineGridChart(itemIdentity, decisionCfgId);
    }

    private void updateNineGridByDecisionCfgId(DynamicObject salaryadjscm) {
        String key;
        if (null == salaryadjscm) {
            return;
        }
        String itemIdentity = (String)this.getModel().getValue(KEY_STANDARDITEM);
        String xaxisName = (String)this.getModel().getValue(KEY_XAXIS);
        String yaxisName = (String)this.getModel().getValue(KEY_YAXIS);
        Multimap mapping = NineGridHelper.getDecisionCfgIdAxisTypeMapping((DynamicObject)salaryadjscm);
        Collection decisionCfgIds = mapping.get((Object)(key = xaxisName + "_" + yaxisName));
        if (decisionCfgIds.isEmpty()) {
            return;
        }
        Long decisionCfgId = null;
        Iterator iterator = decisionCfgIds.iterator();
        if (iterator.hasNext()) {
            decisionCfgId = (Long)iterator.next();
        }
        this.initNineGridChart(StringUtils.isEmpty((CharSequence)itemIdentity) ? Long.valueOf(0L) : Long.valueOf(itemIdentity), decisionCfgId);
    }

    private void initNineGridChart(Long itemIdentity, Long cfgId) {
        String[] split;
        DynamicObject yaxisDyObj;
        DynamicObjectCollection detailEnt = this.getAdjDetailEntDynamicObjectCollection();
        DynamicObject dataEntity = this.getParentView().getModel().getDataEntity();
        long totalamount = dataEntity.getLong("totalamount");
        BigDecimal adjTotalAmount = new BigDecimal(totalamount);
        DynamicObject currencyDyObj = dataEntity.getDynamicObject("currency");
        if (null == itemIdentity) {
            Map itemNameMap = NineGridHelper.collectStandardItemData((DynamicObjectCollection)detailEnt);
            itemIdentity = itemNameMap.keySet().stream().findFirst().orElse(null);
            this.getModel().setValue(KEY_STANDARDITEM, (Object)itemIdentity);
        }
        Date beginDate = null;
        Date endDate = null;
        DynamicObject adjscm = (DynamicObject)this.getParentView().getModel().getValue("salaryadjscm");
        if (null != adjscm && adjscm.getBoolean("isadjdecision")) {
            beginDate = adjscm.getDate("bizdatadatebegin");
            endDate = adjscm.getDate("bizdatadateend");
            DynamicObjectCollection nineGridEnts = adjscm.getDynamicObjectCollection("ninegrid");
            List collect = nineGridEnts.stream().map(object -> object.getLong("adjdecisioncfg.id")).collect(Collectors.toList());
            if (!(CollectionUtils.isEmpty(collect) || null != cfgId && collect.contains(cfgId))) {
                cfgId = (Long)collect.get(0);
            }
        }
        Long itemId = itemIdentity;
        Long decisionCfgId = cfgId;
        this.getModel().setValue(KEY_DECISION_CONFIG, (Object)cfgId);
        DynamicObject[] axisData = AxisDataConfigHelper.queryAxisDataByCfgId((Long)decisionCfgId);
        HashSet<Long> bizitemIds = new HashSet<Long>(axisData.length);
        HashMap bizItemValueMap = Maps.newHashMapWithExpectedSize((int)axisData.length);
        HashMap bizitemAxis = Maps.newHashMapWithExpectedSize((int)2);
        HashMap axisBizitemCategoryNameMap = Maps.newHashMapWithExpectedSize((int)2);
        HashMap axisSeriesNameMap = Maps.newHashMapWithExpectedSize((int)2);
        this.handleAxisData(axisData, bizItemValueMap, bizitemAxis, bizitemIds, axisBizitemCategoryNameMap, axisSeriesNameMap);
        Map employeeIdEntMap = NineGridHelper.groupByEmployeeId((DynamicObjectCollection)detailEnt, (Long)itemId);
        DynamicObject[] bizdatas = BizDataEntryHelper.queryBizdatasByEmployee(employeeIdEntMap.keySet(), bizitemIds, (Date)beginDate, (Date)endDate);
        List bizdataList = NineGridHelper.removeRepeatDynamicObject((DynamicObject[])bizdatas);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(2);
        DynamicObject xaxisDyObj = (DynamicObject)bizitemAxis.get(AxisTypeEnum.XAXIS.getCode());
        if (xaxisDyObj != null) {
            LocaleString xaxisName = LocaleString.fromMap((Map)xaxisDyObj.getLocaleString("bizitem.name"));
            items.add(new ComboItem(xaxisName, "xaxis_bizitem"));
        }
        if ((yaxisDyObj = (DynamicObject)bizitemAxis.get(AxisTypeEnum.YAXIS.getCode())) != null) {
            LocaleString yaxisName = LocaleString.fromMap((Map)yaxisDyObj.getLocaleString("bizitem.name"));
            items.add(new ComboItem(yaxisName, "yaxis_bizitem"));
        }
        Map<Long, List<DynamicObject>> employeeBizdatas = bizdataList.stream().collect(Collectors.groupingBy(object -> object.getLong("employee.id")));
        Map<String, List<Long>> nineGridMap = this.getNineGridDataMap(bizItemValueMap, employeeBizdatas);
        String xbizitemcategoryName = "";
        String ybizitemcategoryName = "";
        Long xbizitemcategoryId = null;
        Long ybizitemcategoryId = null;
        String xAxisBizitemCategory = (String)axisBizitemCategoryNameMap.get(AxisTypeEnum.XAXIS.getCode());
        String yAxisBizitemCategory = (String)axisBizitemCategoryNameMap.get(AxisTypeEnum.YAXIS.getCode());
        List xAxisNameList = (List)axisSeriesNameMap.get(AxisTypeEnum.XAXIS.getCode());
        List yAxisNameList = (List)axisSeriesNameMap.get(AxisTypeEnum.YAXIS.getCode());
        if (xAxisBizitemCategory != null) {
            split = xAxisBizitemCategory.split("&_#");
            xbizitemcategoryId = Long.valueOf(split[0]);
            xbizitemcategoryName = split[1];
        }
        if (yAxisBizitemCategory != null) {
            split = yAxisBizitemCategory.split("&_#");
            ybizitemcategoryId = Long.valueOf(split[0]);
            ybizitemcategoryName = split[1];
        }
        ArrayList yaxisCategoryName = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList xaxisCategoryName = Lists.newArrayListWithExpectedSize((int)10);
        String finalYbizitemcategoryName = ybizitemcategoryName;
        String finalXbizitemcategoryName = xbizitemcategoryName;
        if (xAxisNameList != null) {
            xAxisNameList.forEach(o1 -> xaxisCategoryName.add(o1 + finalXbizitemcategoryName));
        }
        if (yAxisNameList != null) {
            yAxisNameList.forEach(o1 -> yaxisCategoryName.add(o1 + finalYbizitemcategoryName));
        }
        Map nineGridNameMap = NineGridHelper.createAxisNames((List)yaxisCategoryName, (List)xaxisCategoryName);
        this.setAxisSeriesName(axisSeriesNameMap);
        this.setAxisCategoryName(axisData);
        this.setLabelValue(KEY_NINE_YAXIS, ybizitemcategoryName);
        this.setLabelValue(KEY_NINE_XAXIS, xbizitemcategoryName);
        String calcCode = this.getCalcCodeFromAdjDetailEnt(itemId);
        this.initRankingListSort(items, calcCode);
        Map<Long, String[]> avgValGridMap = this.setNineGridValue(nineGridMap, employeeIdEntMap, nineGridNameMap, calcCode, adjTotalAmount, currencyDyObj);
        List<String> selectedCheckboxs = this.getSelectedCheckbox();
        List<String> rangeData = this.getRankingRangeDataByCheckbox(selectedCheckboxs, nineGridNameMap);
        this.refreshRankingRange(rangeData);
        List<Long> selectedEmployees = this.getSelectedEmployeeIds(selectedCheckboxs, nineGridMap);
        Collection<List<Long>> nineGridEmployeeIdList = nineGridMap.values();
        ArrayList nineGridEmployeeIds = Lists.newArrayListWithExpectedSize((int)detailEnt.size());
        for (List<Long> nineGridEmployeeId : nineGridEmployeeIdList) {
            nineGridEmployeeIds.addAll(nineGridEmployeeId);
        }
        List<Long> firstThree = this.calcFirstThree(employeeIdEntMap, bizdataList, bizitemAxis, axisData, nineGridEmployeeIds);
        this.setRankingEntryEntityValue(selectedEmployees, employeeIdEntMap, calcCode, bizdataList, bizitemAxis, avgValGridMap, firstThree, axisData, nineGridEmployeeIds);
        this.cacheCfgIdAndStdItemId(decisionCfgId, itemId);
        this.cacheCompareEntity(detailEnt, bizitemIds, bizdatas);
        this.getModel().beginInit();
        String isPropertyChanged = this.getView().getPageCache().get("isPropertyChanged");
        if (StringUtils.isBlank((CharSequence)isPropertyChanged)) {
            isPropertyChanged = "false";
        }
        String xTypeCache = this.getView().getPageCache().get("xTypeCache");
        Map xTypeMap = (Map)JSON.parseObject((String)xTypeCache, Map.class);
        String yTypeCache = this.getView().getPageCache().get("yTypeCache");
        Map yTypeMap = (Map)JSON.parseObject((String)yTypeCache, Map.class);
        if (itemIdentity != null && !itemIdentity.equals(0L) && !Boolean.parseBoolean(isPropertyChanged)) {
            for (String xTypeKey : xTypeMap.keySet()) {
                if (!xTypeKey.contains(String.valueOf(xbizitemcategoryId))) continue;
                this.getModel().setValue(KEY_XAXIS, (Object)xTypeKey);
                break;
            }
            for (String yTypeKey : yTypeMap.keySet()) {
                if (!yTypeKey.contains(String.valueOf(ybizitemcategoryId))) continue;
                this.getModel().setValue(KEY_YAXIS, (Object)yTypeKey);
                break;
            }
        }
        this.getModel().endInit();
        this.getModel().setValue(KEY_STANDARDITEM, (Object)itemIdentity);
        this.getModel().setValue(KEY_DECISION_CONFIG, (Object)cfgId);
        this.getView().updateView(KEY_STANDARDITEM);
        this.getView().updateView(KEY_XAXIS);
        this.getView().updateView(KEY_YAXIS);
        this.getView().updateView(KEY_DECISION_CONFIG);
        IFormView parentView = this.getView().getParentView().getParentView();
        if (parentView != null) {
            String littleKPageFinish = parentView.getPageCache().get("littleKPageFinish");
            if ("true".equals(littleKPageFinish)) {
                AdjApprovalGridHelper.openLittleKFromApprovePage((IFormView)this.getView().getParentView().getParentView(), (IFormView)this.getView().getParentView(), (IFormView)this.getView(), (AdjNineGridSourceEnum)AdjNineGridSourceEnum.ADJDECISIONCONFIG);
            } else {
                AdjApprovalGridHelper.openLittleKAnalyze((IFormView)this.getView().getParentView(), (IFormView)this.getView(), (AdjNineGridSourceEnum)AdjNineGridSourceEnum.ADJDECISIONCONFIG);
            }
        }
    }

    private void setAxisSeriesName(Map<String, List<String>> axisSeriesNameMap) {
        ArrayList xAxisSeriesNameList = Lists.newArrayList((Object[])this.xAxisSeriesNames);
        ArrayList yAxisSeriesNameList = Lists.newArrayList((Object[])this.yAxisSeriesNames);
        for (Map.Entry<String, List<String>> axisSeriesName : axisSeriesNameMap.entrySet()) {
            String axis = axisSeriesName.getKey();
            List<String> valueList = axisSeriesName.getValue();
            for (int i = 0; i < valueList.size(); ++i) {
                String xAxisSeriesValue = valueList.get(i);
                if (axis.equals(AxisTypeEnum.XAXIS.getCode())) {
                    this.setLabelValue((String)xAxisSeriesNameList.get(i), xAxisSeriesValue);
                    continue;
                }
                if (!axis.equals(AxisTypeEnum.YAXIS.getCode())) continue;
                this.setLabelValue((String)yAxisSeriesNameList.get(i), xAxisSeriesValue);
            }
        }
    }

    private List<Long> calcFirstThree(Map<Long, List<DynamicObject>> employeeIdEntMap, List<DynamicObject> bizdatas, Map<String, DynamicObject> bizitemAxis, DynamicObject[] axisData, List<Long> nineGridEmployeeIds) {
        List<RankingListEntity> rankingList = this.getRankingListEntityData(employeeIdEntMap, bizdatas, bizitemAxis, axisData, nineGridEmployeeIds);
        Collections.sort(rankingList, (a1, b1) -> b1.getFileId().compareTo(a1.getFileId()));
        this.sortRankingList(rankingList, bizitemAxis);
        ArrayList rankKeys = Lists.newArrayListWithCapacity((int)3);
        for (int i = 0; i < rankingList.size(); ++i) {
            RankingListEntity entity = rankingList.get(i);
            if (i > 2) continue;
            rankKeys.add(entity.getEmployeeId());
        }
        return rankKeys;
    }

    private int getAxisDataValueIndex(DynamicObject[] axisDatas, String aixsBizDataVal, AxisTypeEnum axisTypeEnum) {
        for (DynamicObject axisData : axisDatas) {
            String axis = axisData.getString("axis");
            if (!axis.equals(axisTypeEnum.getCode())) continue;
            DynamicObjectCollection entryentity = axisData.getDynamicObjectCollection("entryentity");
            String scale = axisData.getString("bizitem.scale");
            DataTypeEnum datatype = DataTypeEnum.getByCode((int)axisData.getInt("bizitem.datatype"));
            boolean isInterval = axisData.getBoolean("bizitem.isinterval");
            int maxEntCol = this.getMaxEntCol(entryentity) * entryentity.size();
            int seq = 0;
            for (DynamicObject ent : entryentity) {
                seq = ent.getInt("seq") * maxEntCol;
                DynamicObjectCollection valueCol = ent.getDynamicObjectCollection("value");
                List<DynamicObject> displayValues = this.getDisplayValue(valueCol);
                for (DynamicObject displayVal : displayValues) {
                    BigDecimal maxValue;
                    String maxValueStr;
                    Map<String, BigDecimal> entryValue;
                    BigDecimal minValue;
                    String minValueStr;
                    String fmt;
                    String dataScope;
                    DecimalConverter decimalConverter;
                    ValidateResults validateResults;
                    String dbValue = displayVal.getString("name");
                    ++seq;
                    if (!(isInterval ? (validateResults = (decimalConverter = new DecimalConverter(dataScope = String.format(fmt = "[%s,%s]", minValueStr = (minValue = (entryValue = this.convertBizItemEntryValueMinMax(datatype, dbValue)).get(BizDataEntryHelper.MIN_VALUE_KEY)) == null ? "" : minValue.toString(), maxValueStr = (maxValue = entryValue.get(BizDataEntryHelper.MAX_VALUE_KEY)) == null ? "" : maxValue.toString()), 23, StringUtils.isBlank((CharSequence)scale) ? 0 : Integer.parseInt(scale))).checkVal((Object)aixsBizDataVal)).isSuccess() : dbValue.equals(aixsBizDataVal))) continue;
                    return seq;
                }
            }
        }
        return 0;
    }

    private int getMaxEntCol(DynamicObjectCollection entryentity) {
        int max = 0;
        for (DynamicObject ent : entryentity) {
            DynamicObjectCollection valueCol = ent.getDynamicObjectCollection("value");
            int valueMax = valueCol.size();
            if (max >= valueMax) continue;
            max = valueMax;
        }
        return max;
    }

    private Map<String, BigDecimal> convertBizItemEntryValueMinMax(DataTypeEnum datatype, String dbValue) {
        HashMap<String, BigDecimal> minMax = new HashMap<String, BigDecimal>(2);
        switch (datatype) {
            case NUMBER: 
            case PERCENT: {
                BigDecimal startBD = BizItemEntryHelper.stringToDecimalRange((String)dbValue, (boolean)true);
                BigDecimal endBD = BizItemEntryHelper.stringToDecimalRange((String)dbValue, (boolean)false);
                minMax.put(BizDataEntryHelper.MIN_VALUE_KEY, startBD);
                minMax.put(BizDataEntryHelper.MAX_VALUE_KEY, endBD);
                break;
            }
            case DATE: {
                Date startDate = BizItemEntryHelper.stringToDateRange((String)dbValue, (boolean)true);
                Date endDate = BizItemEntryHelper.stringToDateRange((String)dbValue, (boolean)false);
                minMax.put(BizDataEntryHelper.MIN_VALUE_KEY, startDate == null ? null : BigDecimal.valueOf(startDate.getTime()));
                minMax.put(BizDataEntryHelper.MAX_VALUE_KEY, endDate == null ? null : BigDecimal.valueOf(endDate.getTime()));
                break;
            }
        }
        return minMax;
    }

    private void refreshRankingRange(List<String> rangeData) {
        FlexPanelAp listRangePanel = NineGridHelper.createDynamicRankingListRangePanel(rangeData);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", "rankinglistrangepanel");
        map.put("items", (String)listRangePanel.createControl().get("items"));
        this.getView().updateControlMetadata("rankinglistrangepanel", map);
    }

    private void cacheCompareEntity(DynamicObjectCollection detailEnt, Set<Long> bizitemIds, DynamicObject[] bizdatas) {
        Map<Long, List<DynamicObject>> employeeBizdatas = Arrays.stream(bizdatas).collect(Collectors.groupingBy(object -> object.getLong("employee.id")));
        Set<Long> bizDataEmployeeIds = employeeBizdatas.keySet();
        Map beComparedMap = NineGridHelper.getNineGridCompareEntityMap((DynamicObjectCollection)detailEnt, bizDataEmployeeIds);
        String beComparedData = SerializationUtils.serializeToBase64((Object)beComparedMap);
        String bizitemIdsString = SalaryStandardSerializationUtils.toJsonString(bizitemIds);
        IFormView currentView = this.getView();
        String parentPageId = currentView.getFormShowParameter().getParentPageId();
        IFormView pView = currentView.getView(parentPageId);
        pView.getPageCache().put("cachekey_hcdm_ninegrid_compare", beComparedData);
        pView.getPageCache().put("cachekey_hcdm_ninegrid_bieitemids", bizitemIdsString);
    }

    private void cacheCfgIdAndStdItemId(Long decisionCfgId, Long itemId) {
        String combinationId = NineGridCacheHelper.generateKey((String[])new String[]{String.valueOf(decisionCfgId), String.valueOf(itemId)});
        NineGridCacheHelper.putCfgIdAndStdItemId((String)this.getAdjApprovalBillNo(), (Object)combinationId);
    }

    private List<Long> getSelectedEmployeeIds(List<String> selectedCheckboxs, Map<String, List<Long>> nineGridMap) {
        if (nineGridMap.size() == 0 || selectedCheckboxs.size() == 0) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)selectedCheckboxs.size());
        for (String checkbox : selectedCheckboxs) {
            List<Long> longs = nineGridMap.get(checkbox);
            if (null == longs) continue;
            result.addAll(longs);
        }
        return result;
    }

    private List<String> getSelectedCheckbox() {
        List<String> checkboxKeyList = this.generateKey("checkbox");
        ArrayList trueList = Lists.newArrayListWithExpectedSize((int)checkboxKeyList.size());
        for (String checkboxKey : checkboxKeyList) {
            Boolean checkboxValue = (Boolean)this.getModel().getValue(checkboxKey);
            if (!checkboxValue.booleanValue()) continue;
            trueList.add(checkboxKey.substring(8));
        }
        return trueList;
    }

    private List<String> getRankingRangeDataByCheckbox(List<String> selectedCheckboxs, Map<String, String> nineGridNameMap) {
        if (selectedCheckboxs.size() == 0) {
            return Lists.newArrayList();
        }
        ArrayList<String> dynamicRangList = new ArrayList<String>();
        if (selectedCheckboxs.size() == nineGridNameMap.size()) {
            dynamicRangList.add(NineGridConstants.GRID_STATIC_SELL_ALL());
        } else {
            for (String suffix : selectedCheckboxs) {
                dynamicRangList.add(nineGridNameMap.get(suffix));
            }
        }
        return dynamicRangList;
    }

    private void setRankingEntryEntityValue(List<Long> totalEmployeeIds, Map<Long, List<DynamicObject>> employeeIdEntMap, String calcCode, List<DynamicObject> bizdatas, Map<String, DynamicObject> bizitemAxis, Map<Long, String[]> avgValGridMap, List<Long> firstThree, DynamicObject[] axisData, List<Long> nineGridEmployeeIds) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter setter = this.getRankEntryTableValueSetter(calcCode);
        this.setVisibleByCalcCode(calcCode);
        this.changeFieldName(bizitemAxis);
        IClientViewProxy clientService = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        List<RankingListEntity> row = this.sortDetailEntByCalcCode(totalEmployeeIds, employeeIdEntMap, calcCode, bizdatas, bizitemAxis, axisData, nineGridEmployeeIds);
        List adjCurrencyIds = row.stream().map(RankingListEntity::getAdjCurrencyId).collect(Collectors.toList());
        Map adjCurrencyDyMap = NineGridHelper.queryAdjCurrency(adjCurrencyIds);
        Collections.sort(row, (entity, entity1) -> entity1.getFileId().compareTo(entity.getFileId()));
        this.sortRankingList(row, bizitemAxis);
        HashMap<String, String> colorMap = new HashMap<String, String>(16);
        for (int i = 0; i < row.size(); ++i) {
            RankingListEntity rankRow = row.get(i);
            String personNumber = rankRow.getPersonNumber();
            String personName = rankRow.getPersonName();
            Long employeeId = rankRow.getEmployeeId();
            String xaixsBizDataVal = rankRow.getXaixsBizDataVal();
            String yaixsBizDataVal = rankRow.getYaixsBizDataVal();
            String standardItem = rankRow.getStandardItemName();
            String departmentName = rankRow.getDepartmentName();
            String jobName = rankRow.getJobName();
            String joblevelName = rankRow.getJoblevelName();
            String jobgradeName = rankRow.getJobgradeName();
            BigDecimal finalamount = rankRow.getFinalamount();
            Long adjcurrencyId = rankRow.getAdjCurrencyId();
            Long stdItemId = rankRow.getStandardItemId();
            BigDecimal aftersalaryseeprate = rankRow.getAftersalaryseeprate();
            String seeprate = AdjApprovalGridHelper.formatPercent((boolean)true, (BigDecimal)aftersalaryseeprate);
            BigDecimal aftersalarypercent = rankRow.getAftersalarypercent();
            String percent = AdjApprovalGridHelper.formatPercent((boolean)true, (BigDecimal)aftersalarypercent);
            String[] strings = avgValGridMap.get(employeeId);
            String avgVal = strings[0];
            String formatValue = this.foramtValueByCalcCode(calcCode, new BigDecimal(avgVal));
            BigDecimal adjRatio = rankRow.getActualRange();
            String formatPercentRatio = AdjApprovalGridHelper.formatPercent((boolean)true, (BigDecimal)adjRatio);
            BigDecimal actualAmount = rankRow.getActualAmount();
            String formatActualAmount = AdjApprovalGridHelper.formatAmountValue((BigDecimal)actualAmount, (DynamicObject)((DynamicObject)adjCurrencyDyMap.get(rankRow.getAdjCurrencyId())));
            int calResultFlag = this.getCalResultFlag(calcCode, avgVal, adjRatio, actualAmount);
            String compareVal = this.getDispalyValueByFlag(calResultFlag);
            String color = this.getCompareColValueColor(calResultFlag);
            String position = strings[1];
            int rankIndex = firstThree.indexOf(employeeId);
            if (rankIndex == 0) {
                setter.addRow(new Object[]{"A", personNumber, personName, xaixsBizDataVal, yaixsBizDataVal, standardItem, formatValue, formatPercentRatio, formatActualAmount, compareVal, position, departmentName, jobName, joblevelName, jobgradeName, finalamount, adjcurrencyId, seeprate, percent, employeeId, stdItemId});
            } else if (rankIndex == 1) {
                setter.addRow(new Object[]{"B", personNumber, personName, xaixsBizDataVal, yaixsBizDataVal, standardItem, formatValue, formatPercentRatio, formatActualAmount, compareVal, position, departmentName, jobName, joblevelName, jobgradeName, finalamount, adjcurrencyId, seeprate, percent, employeeId, stdItemId});
            } else if (rankIndex == 2) {
                setter.addRow(new Object[]{"C", personNumber, personName, xaixsBizDataVal, yaixsBizDataVal, standardItem, formatValue, formatPercentRatio, formatActualAmount, compareVal, position, departmentName, jobName, joblevelName, jobgradeName, finalamount, adjcurrencyId, seeprate, percent, employeeId, stdItemId});
            } else {
                setter.addRow(new Object[]{"", personNumber, personName, xaixsBizDataVal, yaixsBizDataVal, standardItem, formatValue, formatPercentRatio, formatActualAmount, compareVal, position, departmentName, jobName, joblevelName, jobgradeName, finalamount, adjcurrencyId, seeprate, percent, employeeId, stdItemId});
            }
            SWCGridUtils.setGridStyle((IClientViewProxy)clientService, (String)"entryentity", (int)i, (String)"compare", (String)color);
            colorMap.put(String.valueOf(i), color);
        }
        model.beginInit();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
        this.getView().getPageCache().put(KEY_COLORMAP, SerializationUtils.toJsonString(colorMap));
    }

    private void sortRankingList(List<RankingListEntity> rows, Map<String, DynamicObject> bizitemAxis) {
        this.log.info("\u6392\u884c\u699c\u6570\u636e \u6392\u5e8f :{}", (Object)JSONObject.toJSONString(rows));
        String value = (String)this.getModel().getValue("rankinglistsort");
        DynamicObject xaxisDyObj = bizitemAxis.get(AxisTypeEnum.XAXIS.getCode());
        DynamicObject yaxisDyObj = bizitemAxis.get(AxisTypeEnum.YAXIS.getCode());
        switch (value) {
            case "adjratio": {
                Collections.sort(rows, new Comparator<RankingListEntity>(){

                    @Override
                    public int compare(RankingListEntity o1, RankingListEntity o2) {
                        if (o2.getActualRange() != null && o1.getActualRange() != null) {
                            return o2.getActualRange().compareTo(o1.getActualRange());
                        }
                        return o1.getActualRange() == null ? 1 : -1;
                    }
                });
                break;
            }
            case "adjamount": {
                Collections.sort(rows, new Comparator<RankingListEntity>(){

                    @Override
                    public int compare(RankingListEntity o1, RankingListEntity o2) {
                        if (o2.getActualAmount() != null && o1.getActualAmount() != null) {
                            return o2.getActualAmount().compareTo(o1.getActualAmount());
                        }
                        return o1.getActualAmount() == null ? 1 : -1;
                    }
                });
                break;
            }
            case "joblevel": {
                Collections.sort(rows, new Comparator<RankingListEntity>(){

                    @Override
                    public int compare(RankingListEntity o1, RankingListEntity o2) {
                        if (o2.getJoblevelSeq() != null && o1.getJoblevelSeq() != null) {
                            return o2.getJoblevelSeq().compareTo(o1.getJoblevelSeq());
                        }
                        return o1.getJoblevelSeq() == null ? 1 : -1;
                    }
                });
                break;
            }
            case "jobgrade": {
                Collections.sort(rows, new Comparator<RankingListEntity>(){

                    @Override
                    public int compare(RankingListEntity o1, RankingListEntity o2) {
                        if (o2.getJobgradeSeq() != null && o1.getJobgradeSeq() != null) {
                            return o2.getJobgradeSeq().compareTo(o1.getJobgradeSeq());
                        }
                        return o1.getJobgradeSeq() == null ? 1 : -1;
                    }
                });
                break;
            }
            case "finalamount": {
                Collections.sort(rows, new Comparator<RankingListEntity>(){

                    @Override
                    public int compare(RankingListEntity o1, RankingListEntity o2) {
                        if (o2.getFinalamount() != null && o1.getFinalamount() != null) {
                            return o2.getFinalamount().compareTo(o1.getFinalamount());
                        }
                        return o1.getFinalamount() == null ? 1 : -1;
                    }
                });
                break;
            }
            case "aftersalaryseeprate": {
                rows.sort(Comparator.comparing(RankingListEntity::getAftersalaryseeprate, Comparator.nullsFirst(BigDecimal::compareTo)).reversed());
                break;
            }
            case "aftersalarypercent": {
                rows.sort(Comparator.comparing(RankingListEntity::getAftersalarypercent, Comparator.nullsFirst(BigDecimal::compareTo)).reversed());
                break;
            }
            case "xaxis_bizitem": {
                this.sortRankingListByBizItem(rows, xaxisDyObj, AxisTypeEnum.XAXIS);
                break;
            }
            case "yaxis_bizitem": {
                this.sortRankingListByBizItem(rows, yaxisDyObj, AxisTypeEnum.YAXIS);
                break;
            }
        }
        for (RankingListEntity row : rows) {
            int xDataType = xaxisDyObj.getInt("bizitem.datatype");
            DataTypeEnum xDataTypeEnum = DataTypeEnum.getByCode((int)xDataType);
            String xBizDataVal = row.getXaixsBizDataVal();
            row.setXaixsBizDataVal(BizItemEntryHelper.dbValueToDisplayValue((DataTypeEnum)xDataTypeEnum, (boolean)false, (String)xBizDataVal));
            int yDataType = yaxisDyObj.getInt("bizitem.datatype");
            DataTypeEnum yDataTypeEnum = DataTypeEnum.getByCode((int)yDataType);
            String yBizDataVal = row.getYaixsBizDataVal();
            row.setYaixsBizDataVal(BizItemEntryHelper.dbValueToDisplayValue((DataTypeEnum)yDataTypeEnum, (boolean)false, (String)yBizDataVal));
        }
    }

    private void sortRankingListByBizItem(List<RankingListEntity> rows, DynamicObject axisData, AxisTypeEnum axisTypeEnum) {
        int dataType = axisData.getInt("bizitem.datatype");
        DataTypeEnum dataTypeEnum = DataTypeEnum.getByCode((int)dataType);
        switch (dataTypeEnum) {
            case TEXT: {
                if (axisTypeEnum == AxisTypeEnum.XAXIS) {
                    rows.sort(Comparator.comparing(RankingListEntity::getXaixsBizDataValSeq).thenComparing(RankingListEntity::getPersonNumber));
                    break;
                }
                if (axisTypeEnum != AxisTypeEnum.YAXIS) break;
                rows.sort(Comparator.comparing(RankingListEntity::getYaixsBizDataValSeq).thenComparing(RankingListEntity::getPersonNumber));
                break;
            }
            case DATE: {
                if (axisTypeEnum == AxisTypeEnum.XAXIS) {
                    rows.sort(Comparator.comparingInt(RankingListEntity::getXaixsBizDataValSeq).thenComparing(RankingListEntity::getXaixsBizDataVal, Comparator.reverseOrder()));
                    break;
                }
                if (axisTypeEnum != AxisTypeEnum.YAXIS) break;
                rows.sort(Comparator.comparingInt(RankingListEntity::getYaixsBizDataValSeq).thenComparing(RankingListEntity::getYaixsBizDataVal, Comparator.reverseOrder()));
                break;
            }
            case NUMBER: 
            case PERCENT: {
                if (axisTypeEnum == AxisTypeEnum.XAXIS) {
                    rows.sort(Comparator.comparingInt(RankingListEntity::getXaixsBizDataValSeq).thenComparing(entity -> StringUtils.isBlank((Object)entity) ? BigDecimal.ZERO : new BigDecimal(entity.getXaixsBizDataVal()), Comparator.reverseOrder()));
                    break;
                }
                if (axisTypeEnum != AxisTypeEnum.YAXIS) break;
                rows.sort(Comparator.comparingInt(RankingListEntity::getYaixsBizDataValSeq).thenComparing(entity -> StringUtils.isBlank((Object)entity) ? BigDecimal.ZERO : new BigDecimal(entity.getYaixsBizDataVal()), Comparator.reverseOrder()));
                break;
            }
        }
        this.log.info("\u8f74\u7c7b\u578b\uff1a{} \uff1b \u8f74\u6570\u636e\u6392\u5e8f\u540e \uff1a {}", (Object)axisTypeEnum.name(), (Object)JSON.toJSONString(rows));
    }

    private String getCompareColValueColor(int calResultFlag) {
        if (calResultFlag == 1) {
            return HIGH_COLOR;
        }
        if (calResultFlag == -1) {
            return LOW_COLOR;
        }
        return null;
    }

    private String getDispalyValueByFlag(int calResultFlag) {
        return null;
    }

    private int getCalResultFlag(String calcCode, String avgVal, BigDecimal adjRatioVal, BigDecimal actualBigDecimal) {
        BigDecimal avg = new BigDecimal(avgVal);
        return CalcType.RATIO.getCode().equals(calcCode) ? adjRatioVal.setScale(2, 5).compareTo(avg) : actualBigDecimal.setScale(this.getAdjCurrencyScale(), 5).compareTo(avg);
    }

    private void changeFieldName(Map<String, DynamicObject> bizitemAxis) {
        if (CollectionUtils.isEmpty(bizitemAxis)) {
            return;
        }
        TextEdit xaxisField = (TextEdit)this.getControl("xaxis_bizitem");
        TextEdit yaxisField = (TextEdit)this.getControl("yaxis_bizitem");
        xaxisField.setCaption(LocaleString.fromMap((Map)bizitemAxis.get(AxisTypeEnum.XAXIS.getCode()).getLocaleString("bizitem.name")));
        yaxisField.setCaption(LocaleString.fromMap((Map)bizitemAxis.get(AxisTypeEnum.YAXIS.getCode()).getLocaleString("bizitem.name")));
    }

    private String getBizDataValue(List<DynamicObject> bizdatas, Long employeeId, DynamicObject aixsBizData) {
        Long bizitemId = aixsBizData == null ? null : Long.valueOf(aixsBizData.getLong("bizitem.id"));
        for (DynamicObject object : bizdatas) {
            if (!employeeId.equals(object.getLong("employee.id")) || bizitemId == null || !bizitemId.equals(object.getLong("bizitem.id"))) continue;
            String datatype = aixsBizData.getDynamicObject("bizitem").getString("datatype");
            DataTypeEnum dataTypeEnum = DataTypeEnum.getByCode((int)Integer.parseInt(datatype));
            String value = object.getBoolean("bizitem.isinterval") ? object.getString("value") : object.getString("bizitement.name");
            return value;
        }
        return "";
    }

    private TableValueSetter getRankEntryTableValueSetter(String calcCode) {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("rankpicture", new Object[0]);
        setter.addField("person_number", new Object[0]);
        setter.addField("person_name", new Object[0]);
        setter.addField("xaxis_bizitem", new Object[0]);
        setter.addField("yaxis_bizitem", new Object[0]);
        setter.addField("standard_item", new Object[0]);
        if (CalcType.RATIO.getCode().equals(calcCode)) {
            setter.addField("avg_ratio", new Object[0]);
        } else {
            setter.addField("avg_amount", new Object[0]);
        }
        setter.addField("adjratio", new Object[0]);
        setter.addField("adjamount", new Object[0]);
        setter.addField("compare", new Object[0]);
        setter.addField("position", new Object[0]);
        setter.addField("department", new Object[0]);
        setter.addField("job", new Object[0]);
        setter.addField("joblevel", new Object[0]);
        setter.addField("jobgrade", new Object[0]);
        setter.addField("finalamount", new Object[0]);
        setter.addField("adjcurrency", new Object[0]);
        setter.addField("aftersalaryseeprate", new Object[0]);
        setter.addField("aftersalarypercent", new Object[0]);
        setter.addField("employee", new Object[0]);
        setter.addField("stditem", new Object[0]);
        return setter;
    }

    private void setVisibleByCalcCode(String calcCode) {
        if (CalcType.RATIO.getCode().equals(calcCode)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"avg_amount"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"avg_ratio"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"avg_ratio"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"avg_amount"});
        }
    }

    private List<RankingListEntity> sortDetailEntByCalcCode(List<Long> totalEmployeeIds, Map<Long, List<DynamicObject>> employIdEntMaps, String calcCode, List<DynamicObject> bizdatas, Map<String, DynamicObject> bizitemAxis, DynamicObject[] axisData, List<Long> nineGridEmployeeIds) {
        List<RankingListEntity> rankingListEntities = this.getRankingListEntityData(employIdEntMaps, bizdatas, bizitemAxis, axisData, nineGridEmployeeIds);
        if (CalcType.RATIO.getCode().equals(calcCode)) {
            return rankingListEntities.stream().filter(entity -> totalEmployeeIds.contains(entity.getEmployeeId())).sorted(Comparator.comparing(RankingListEntity::getActualRange).reversed()).collect(Collectors.toList());
        }
        return rankingListEntities.stream().filter(entity -> totalEmployeeIds.contains(entity.getEmployeeId())).sorted(Comparator.comparing(RankingListEntity::getActualAmount).reversed()).collect(Collectors.toList());
    }

    private List<RankingListEntity> getRankingListEntityData(Map<Long, List<DynamicObject>> employeeIdEntMap, List<DynamicObject> bizdatas, Map<String, DynamicObject> bizitemAxis, DynamicObject[] axisData, List<Long> nineGridEmployeeIds) {
        ArrayList rankingListEntities = Lists.newArrayListWithExpectedSize((int)employeeIdEntMap.size());
        HashSet<Long> depempIds = new HashSet<Long>(employeeIdEntMap.size());
        HashSet<Long> jobIds = new HashSet<Long>(employeeIdEntMap.size());
        for (Map.Entry<Long, List<DynamicObject>> entry2 : employeeIdEntMap.entrySet()) {
            Long employeeId = entry2.getKey();
            List<DynamicObject> value = entry2.getValue();
            BigDecimal sumFinalAmount = this.sum(DecAdjApprCreateGridHelper.buildKey((String)"amount"), value);
            BigDecimal sumActualAmount = this.sum(DecAdjApprCreateGridHelper.buildKey((String)"actualamount"), value);
            BigDecimal sumAfterStdIntervalMin = this.sumByExrate(DecAdjApprCreateGridHelper.buildKey((String)DecAdjApprConstants.KEY_INTERVALMIN), value);
            BigDecimal sumAfterStdIntervalMax = this.sumByExrate(DecAdjApprCreateGridHelper.buildKey((String)DecAdjApprConstants.KEY_INTERVALMAX), value);
            BigDecimal sumAfterStdIntervalMiddle = this.sumByExrate(DecAdjApprCreateGridHelper.buildKey((String)DecAdjApprConstants.KEY_INTERVALMIDDLE), value);
            DynamicObject valueObj = value.get(0);
            Long fileId = valueObj.getLong(DecAdjApprCreateGridHelper.buildKey((String)"adjfile") + "." + "id");
            Map adjFileData = this.adjFileDomainService.getAdjFileInfoData((Set)Sets.newHashSet((Object[])new Long[]{fileId}));
            DynamicObject adjFileObject = (DynamicObject)adjFileData.get(fileId);
            String personNumber = valueObj.getString(DecAdjApprCreateGridHelper.buildKey((String)"number"));
            String personName = valueObj.getString(DecAdjApprCreateGridHelper.buildKey((String)"name"));
            Long standardItemId = valueObj.getLong(DecAdjApprCreateGridHelper.buildKey((String)KEY_STANDARDITEM) + "." + "id");
            String standardItemName = valueObj.getString(DecAdjApprCreateGridHelper.buildKey((String)KEY_STANDARDITEM) + "." + "name");
            Long depempId = adjFileObject.getLong("empposorgrel.depemp.id");
            Long jobId = (Long)DynamicObjectValueHelper.dyObjGetValueIfExist((DynamicObject)valueObj, (String)"dy_job.id", (String)"dy_job");
            BigDecimal actualrange = SalaryStdCalculateHelper.calcSalaryActualRange((BigDecimal)sumActualAmount, (BigDecimal)sumFinalAmount);
            Long adjcurrencyId = valueObj.getLong(DecAdjApprCreateGridHelper.buildKey((String)"currency") + "." + "id");
            BigDecimal aftersalaryseeprate = SalaryStdCalculateHelper.calcSalaryPermeability((BigDecimal)sumFinalAmount, (BigDecimal)sumAfterStdIntervalMin, (BigDecimal)sumAfterStdIntervalMax);
            BigDecimal aftersalarypercent = SalaryStdCalculateHelper.calcSalaryRatioNew((BigDecimal)sumFinalAmount, (BigDecimal)sumAfterStdIntervalMiddle, (BigDecimal)BigDecimal.ONE);
            aftersalarypercent = aftersalarypercent.multiply(BigDecimal.valueOf(100L));
            DynamicObject xaixsBizData = bizitemAxis.get(AxisTypeEnum.XAXIS.getCode());
            String xaixsBizDataVal = this.getBizDataValue(bizdatas, employeeId, xaixsBizData);
            DynamicObject yaixsBizData = bizitemAxis.get(AxisTypeEnum.YAXIS.getCode());
            String yaixsBizDataVal = this.getBizDataValue(bizdatas, employeeId, yaixsBizData);
            Integer xaixsBizDataValSeq = this.getAxisDataValueIndex(axisData, xaixsBizDataVal, AxisTypeEnum.XAXIS);
            Integer yaixsBizDataValSeq = this.getAxisDataValueIndex(axisData, yaixsBizDataVal, AxisTypeEnum.YAXIS);
            RankingListEntity entity2 = new RankingListEntity(Long.valueOf(0L), employeeId, fileId, personNumber, personName, standardItemId, standardItemName, actualrange, sumActualAmount, depempId, jobId, sumFinalAmount, adjcurrencyId, aftersalaryseeprate, aftersalarypercent, xaixsBizDataVal, yaixsBizDataVal, xaixsBizDataValSeq, yaixsBizDataValSeq);
            depempIds.add(depempId);
            jobIds.add(jobId);
            rankingListEntities.add(entity2);
        }
        Map jobData = AdjApprovalGridHelper.getJobData(jobIds);
        Map depempData = AdjApprovalGridHelper.getDepempData(depempIds);
        HashMap employeeIdMap = Maps.newHashMapWithExpectedSize((int)depempData.size());
        depempData.entrySet().forEach(entry -> employeeIdMap.put(entry.getKey(), ((DynamicObject)entry.getValue()).getLong("employee.id")));
        Map empjobrelData = AdjApprovalGridHelper.getEmpJobRel((Map)employeeIdMap);
        for (RankingListEntity entity3 : rankingListEntities) {
            Long depempId = entity3.getDepempId();
            Long jobId = entity3.getJobId();
            DynamicObject jobObject = (DynamicObject)jobData.get(jobId);
            DynamicObject empjobrelObject = (DynamicObject)empjobrelData.get(depempId);
            DynamicObject depempObject = (DynamicObject)depempData.get(depempId);
            String jobName = Optional.ofNullable(jobObject).map(object -> object.getString("name")).orElse("");
            String departmentName = Optional.ofNullable(depempObject).map(object -> object.getString("adminorg.name")).orElse("");
            String joblevelName = Optional.ofNullable(empjobrelObject).map(object -> object.getString("joblevel.name")).orElse("");
            String jobgradeName = Optional.ofNullable(empjobrelObject).map(object -> object.getString("jobgrade.name")).orElse("");
            Integer joblevelseq = Optional.ofNullable(empjobrelObject).map(object -> object.getInt("joblevel.joblevelseq")).orElse(0);
            Integer jobgradeseq = Optional.ofNullable(empjobrelObject).map(object -> object.getInt("jobgrade.jobgradeseq")).orElse(0);
            entity3.setJobName(jobName);
            entity3.setDepartmentName(departmentName);
            entity3.setJoblevelName(joblevelName);
            entity3.setJobgradeName(jobgradeName);
            entity3.setJoblevelSeq(joblevelseq);
            entity3.setJobgradeSeq(jobgradeseq);
        }
        return rankingListEntities.stream().filter(entity -> nineGridEmployeeIds.contains(entity.getEmployeeId())).collect(Collectors.toList());
    }

    private void handleAxisData(DynamicObject[] axisData, Map<String, List<List<DynamicObject>>> bizItemValueMap, Map<String, DynamicObject> bizitemAxis, Set<Long> bizitemIds, Map<String, String> axisBizitemCategoryNameMap, Map<String, List<String>> axisSeriesNameMap) {
        for (DynamicObject axisObj : axisData) {
            String axis = axisObj.getString("axis");
            Long bizitemId = axisObj.getLong("bizitem.id");
            bizitemIds.add(bizitemId);
            bizitemAxis.put(axis, axisObj);
            axisBizitemCategoryNameMap.put(axis, axisObj.getLong("bizitemcategory.id") + "&_#" + axisObj.getString("bizitemcategory.name"));
            DynamicObjectCollection entryentity = axisObj.getDynamicObjectCollection("entryentity");
            ArrayList valueList = Lists.newArrayListWithExpectedSize((int)3);
            ArrayList axisNameList = Lists.newArrayListWithExpectedSize((int)3);
            for (DynamicObject ent : entryentity) {
                DynamicObjectCollection value = ent.getDynamicObjectCollection("value");
                List<DynamicObject> displayValue = this.getDisplayValue(value);
                valueList.add(displayValue);
                axisNameList.add(ent.getString("name"));
            }
            axisSeriesNameMap.put(axis, axisNameList);
            bizItemValueMap.put(NineGridCacheHelper.generateKey((String[])new String[]{axis, String.valueOf(bizitemId)}), valueList);
        }
    }

    private Map<String, List<Long>> getNineGridDataMap(Map<String, List<List<DynamicObject>>> bizItemValueMap, Map<Long, List<DynamicObject>> employeeBizdatas) {
        HashMap nineGridMap = Maps.newHashMapWithExpectedSize((int)9);
        Iterator<Map.Entry<Long, List<DynamicObject>>> iterator = employeeBizdatas.entrySet().iterator();
        HashMap<String, String> temp = new HashMap<String, String>(16);
        while (iterator.hasNext()) {
            temp.clear();
            Map.Entry<Long, List<DynamicObject>> next = iterator.next();
            Long employeeId = next.getKey();
            List<DynamicObject> bizDyObj = next.getValue();
            for (DynamicObject bizdata : bizDyObj) {
                String intervalValue = bizdata.getString("value");
                Long bizitemId = bizdata.getLong("bizitem.id");
                DynamicObject bizitemEnt = bizdata.getDynamicObject("bizitement");
                boolean isinterval = bizdata.getBoolean("bizitem.isinterval");
                int dataType = bizdata.getInt("bizitem.datatype");
                DataTypeEnum dataTypeEnum = DataTypeEnum.getByCode((int)dataType);
                for (Map.Entry<String, List<List<DynamicObject>>> map : bizItemValueMap.entrySet()) {
                    List<List<DynamicObject>> axisDataLists;
                    int index;
                    String axisAndItemId = map.getKey();
                    String[] parseKey = NineGridCacheHelper.parseKey((String)axisAndItemId);
                    if (!bizitemId.equals(Long.valueOf(parseKey[1])) || (index = this.getAxisPosition(intervalValue, bizitemEnt, axisDataLists = map.getValue(), isinterval, dataTypeEnum)) < 0) continue;
                    temp.put(parseKey[0], String.valueOf(index));
                }
            }
            String xaxis = (String)temp.get(AxisTypeEnum.XAXIS.getCode());
            String yaxis = (String)temp.get(AxisTypeEnum.YAXIS.getCode());
            if (temp.size() != 2 || !SWCStringUtils.isNotEmpty((String)xaxis) || !SWCStringUtils.isNotEmpty((String)yaxis)) continue;
            String uniqueKey = this.generateKey(yaxis, xaxis);
            ArrayList<Long> list = (ArrayList<Long>)nineGridMap.get(uniqueKey);
            if (null != list && !list.isEmpty()) {
                list.add(employeeId);
                nineGridMap.put(uniqueKey, list);
                continue;
            }
            list = new ArrayList<Long>();
            list.add(employeeId);
            nineGridMap.put(uniqueKey, list);
        }
        return nineGridMap;
    }

    private String getAxisByBizItemId(Map<String, DynamicObject> bizitemAxis, Long bizitemId) {
        for (Map.Entry<String, DynamicObject> map : bizitemAxis.entrySet()) {
            DynamicObject value = map.getValue();
            if (!bizitemId.equals(value.getLong("bizitem.id"))) continue;
            return map.getKey();
        }
        return null;
    }

    private Map<Long, String[]> setNineGridValue(Map<String, List<Long>> nineGridMap, Map<Long, List<DynamicObject>> employeeIdEntMap, Map<String, String> nineGridNameMap, String calcCode, BigDecimal adjTotalAmount, DynamicObject currencyDyObj) {
        this.resetData(LBL_PERSONNUM, calcCode);
        this.resetData(LBL_PERCENTVALUE, calcCode);
        this.resetData(LBL_ADJTOTALPROPORTION, calcCode);
        HashMap employeeGridMap = Maps.newHashMap();
        for (Map.Entry<String, List<Long>> entry : nineGridMap.entrySet()) {
            String uniqueKey = entry.getKey();
            List<Long> employeeIds = entry.getValue();
            this.setLabelValue(LBL_PERSONNUM + uniqueKey, String.valueOf(employeeIds.size()));
            BigDecimal avgValue = this.calAvgValue(employeeIds, calcCode, employeeIdEntMap);
            String formatValue = this.foramtValueByCalcCode(calcCode, avgValue);
            this.setLabelValue(LBL_PERCENTVALUE + uniqueKey, formatValue);
            this.setAdjTotalProportion(LBL_ADJTOTALPROPORTION + uniqueKey, adjTotalAmount, employeeIds, employeeIdEntMap, currencyDyObj);
            for (Long employeeId : employeeIds) {
                String[] array = new String[]{avgValue.toPlainString(), nineGridNameMap.get(uniqueKey)};
                employeeGridMap.put(employeeId, array);
            }
        }
        return employeeGridMap;
    }

    private void setAdjTotalProportion(String labelKey, BigDecimal adjTotalAmount, List<Long> employeeIds, Map<Long, List<DynamicObject>> employeeIdEntMap, DynamicObject currencyDyObj) {
        BigDecimal employeeActualAmount = BigDecimal.ZERO;
        for (Long employeeId : employeeIds) {
            List<DynamicObject> entList = employeeIdEntMap.get(employeeId);
            for (DynamicObject dyobj : entList) {
                BigDecimal actualamount = dyobj.getBigDecimal(DecAdjApprCreateGridHelper.buildKey((String)"actualamount"));
                if (actualamount == null) {
                    actualamount = BigDecimal.ZERO;
                }
                employeeActualAmount = employeeActualAmount.add(actualamount);
            }
        }
        BigDecimal adjTotalProportion = adjTotalAmount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : employeeActualAmount.divide(adjTotalAmount, 4, 4).multiply(BigDecimal.valueOf(100L));
        String adjTotalProportionStr = AdjApprovalGridHelper.getFormatNumberStr((BigDecimal)adjTotalProportion, (int)2, (String)"%");
        this.setLabelValue(labelKey, adjTotalProportionStr);
    }

    private String foramtValueByCalcCode(String calcCode, BigDecimal avgValue) {
        if (CalcType.RATIO.getCode().equals(calcCode)) {
            return avgValue.toPlainString() + "%";
        }
        return AdjApprovalGridHelper.formatAmountValue((BigDecimal)avgValue, (DynamicObject)this.getAdjCurrencyDyObj());
    }

    private void resetData(String labeKeyPrefix, String calcCode) {
        List<String> list = this.generateKey(labeKeyPrefix);
        String value = "0";
        if (LBL_PERCENTVALUE.equals(labeKeyPrefix)) {
            if (CalcType.RATIO.getCode().equals(calcCode)) {
                value = "0.00%";
            } else {
                DynamicObject currencyObj = this.getAdjCurrencyDyObj();
                String sign = currencyObj.getString("sign");
                int adjCurrencyScale = this.getAdjCurrencyScale();
                value = sign + new BigDecimal("0").setScale(adjCurrencyScale).toPlainString();
            }
        } else if (LBL_ADJTOTALPROPORTION.equals(labeKeyPrefix)) {
            value = "0.00%";
        }
        for (String labelKey : list) {
            this.setLabelValue(labelKey, value);
        }
    }

    private BigDecimal calAvgValue(List<Long> employeeIds, String calcCode, Map<Long, List<DynamicObject>> employeeIdEntMap) {
        BigDecimal result = new BigDecimal("0");
        CalcType calctype = CalcType.getByCode((String)calcCode);
        if (CalcType.RATIO == calctype) {
            result = this.sum(DecAdjApprCreateGridHelper.buildKey((String)"actualrange"), employeeIds, employeeIdEntMap, result);
            return result.divide(new BigDecimal(String.valueOf(employeeIds.size())), 2, 5);
        }
        result = this.sum(DecAdjApprCreateGridHelper.buildKey((String)"actualamount"), employeeIds, employeeIdEntMap, result);
        return result.divide(new BigDecimal(String.valueOf(employeeIds.size())), this.getAdjCurrencyScale(), 5);
    }

    private BigDecimal sum(String param, List<Long> employeeIds, Map<Long, List<DynamicObject>> employeeIdEntMap, BigDecimal result) {
        for (Long employeeId : employeeIds) {
            List<DynamicObject> entDyObjs = employeeIdEntMap.get(employeeId);
            BigDecimal reduce = entDyObjs.stream().filter(dy -> dy.getBigDecimal(param) != null).map(object -> object.getBigDecimal(param)).reduce(BigDecimal.ZERO, BigDecimal::add);
            result = result.add(reduce);
        }
        return result;
    }

    private BigDecimal sum(String param, List<DynamicObject> entDyObj) {
        return entDyObj.stream().filter(dy -> dy.getBigDecimal(param) != null).map(object -> object.getBigDecimal(param)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private BigDecimal sumByExrate(String param, List<DynamicObject> entDyObj) {
        BigDecimal sumBigDecimal = BigDecimal.ZERO;
        BillExRateManager rateManager = new BillExRateManager();
        for (DynamicObject dy : entDyObj) {
            ExchangeRateInfo exrate;
            BigDecimal convertBigDecimal;
            BigDecimal bigDecimal = dy.getBigDecimal(param);
            if (bigDecimal == null) continue;
            long adjCurrency = dy.getLong(DecAdjApprCreateGridHelper.buildKey((String)"currency") + "." + "id");
            long stdcurrency = dy.getLong(DecAdjApprCreateGridHelper.buildKey((String)"salarystd") + "." + "currency" + "." + "id");
            DynamicObject billEntity = this.getView().getParentView().getModel().getDataEntity();
            long exctableId = billEntity.getLong("exctable.id");
            Date rateDate = billEntity.getDate("exchangeratedate");
            DynamicObject coefficientDyobj = dy.getDynamicObject("dy_coefficient");
            BigDecimal coefficientvalue = BigDecimal.ONE;
            if (!SWCBaseUtils.isEmpty((DynamicObject)coefficientDyobj)) {
                coefficientvalue = coefficientDyobj.getBigDecimal("coefficientvalue");
            }
            if ((convertBigDecimal = DecAdjApprGridHelper.convertAmountByExrate((ExchangeRateInfo)(exrate = DecAdjApprGridHelper.getExchangeRate((BillExRateManager)rateManager, (long)stdcurrency, (long)adjCurrency, (long)exctableId, (Date)rateDate)), (BigDecimal)bigDecimal, (long)stdcurrency, (long)adjCurrency)) == null) continue;
            convertBigDecimal = convertBigDecimal.multiply(coefficientvalue);
            sumBigDecimal = sumBigDecimal.add(convertBigDecimal);
        }
        return sumBigDecimal;
    }

    private int getAdjCurrencyScale() {
        DynamicObject currencyObj = this.getAdjCurrencyDyObj();
        return null == currencyObj ? 0 : currencyObj.getInt("amtprecision");
    }

    private int getAxisPosition(String intervalValue, DynamicObject bizitemEnt, List<List<DynamicObject>> axisValues, Boolean isinterval, DataTypeEnum dataTypeEnum) {
        if (!isinterval.booleanValue()) {
            Long id = bizitemEnt.getLong("id");
            for (int i = 0; i < axisValues.size(); ++i) {
                List<DynamicObject> list = axisValues.get(i);
                for (DynamicObject dynamicObject : list) {
                    if (!id.equals(dynamicObject.getLong("id"))) continue;
                    return i;
                }
            }
        } else {
            return NineGridHelper.findIndex((String)intervalValue, axisValues, (DataTypeEnum)dataTypeEnum);
        }
        return -1;
    }

    private List<DynamicObject> getDisplayValue(DynamicObjectCollection newValue) {
        List sortNewValue = newValue.stream().sorted(Comparator.comparing(object -> object.getLong("pkid"))).collect(Collectors.toList());
        return sortNewValue.stream().map(object -> object.getDynamicObject("fbasedataid")).collect(Collectors.toList());
    }

    private String getCalcCodeFromAdjDetailEnt(Long standardItemId) {
        String ratioCode = CalcType.RATIO.getCode();
        if (standardItemId == null) {
            return ratioCode;
        }
        DynamicObjectCollection adjDetailEnts = this.getAdjDetailEntDynamicObjectCollection();
        HashMap<String, ArrayList<DynamicObject>> calctypeMap = new HashMap<String, ArrayList<DynamicObject>>(16);
        for (DynamicObject adjDetailEnt : adjDetailEnts) {
            if (!standardItemId.equals(adjDetailEnt.getLong(DecAdjApprCreateGridHelper.buildKey((String)KEY_STANDARDITEM) + "." + "id"))) continue;
            String calctype = adjDetailEnt.getString(DecAdjApprCreateGridHelper.buildKey((String)"calctype"));
            calctype = calctype == null ? CalcType.RATIO.getCode() : calctype;
            ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)calctypeMap.get(calctype);
            if (null != list && !list.isEmpty()) {
                list.add(adjDetailEnt);
                calctypeMap.put(calctype, list);
                continue;
            }
            list = new ArrayList<DynamicObject>();
            list.add(adjDetailEnt);
            calctypeMap.put(calctype, list);
        }
        String calcCode = ratioCode;
        boolean isCalcTypeAllGradeRank = calctypeMap.keySet().stream().allMatch(item -> CalcType.GRADE_RANK.getCode().equals(item));
        if (isCalcTypeAllGradeRank) {
            calcCode = CalcType.RATIO.getCode();
        } else {
            calctypeMap.remove(CalcType.GRADE_RANK.getCode());
            if (calctypeMap.size() == 1) {
                calcCode = calctypeMap.keySet().stream().findFirst().orElse(null);
            } else if (calctypeMap.size() == 2) {
                String amountCode = CalcType.AMOUNT.getCode();
                calcCode = ((List)calctypeMap.get(ratioCode)).size() >= ((List)calctypeMap.get(amountCode)).size() ? ratioCode : amountCode;
            }
        }
        return calcCode;
    }

    private DynamicObjectCollection getAdjDetailEntDynamicObjectCollection() {
        IFormView parentView = this.getParentView();
        DynamicObject[] entryEntities = AdjBillEntryImpHelper.getDynamicEntryData((IFormView)parentView);
        entryEntities = Arrays.stream(entryEntities).filter(dyObj -> dyObj.getBigDecimal("dy_amount") != null).collect(Collectors.toList()).toArray(new DynamicObject[0]);
        DynamicObjectCollection result = new DynamicObjectCollection();
        result.addAll(Arrays.asList(entryEntities));
        return result;
    }

    private String getAdjApprovalBillNo() {
        IFormView parentView = this.getParentView();
        return (String)parentView.getModel().getValue("billno");
    }

    private DynamicObject getAdjCurrencyDyObj() {
        IFormView parentView = this.getParentView();
        return parentView.getModel().getDataEntity().getDynamicObject("currency");
    }

    private IFormView getParentView() {
        IFormView currentView = this.getView();
        String parentPageId = currentView.getFormShowParameter().getParentPageId();
        return currentView.getView(parentPageId);
    }

    private void initStandardItemCombo(Map<Long, String> itemMap) {
        this.setComboItems(FieldDataUtils.buildComboItem(itemMap), KEY_STANDARDITEM);
    }

    private void initAxisNameCombo(Map<String, Map<String, String>> itemMap) {
        this.log.info("\u8f74\u4e0b\u62c9\u9009\u5185\u5bb9\uff1a{}", (Object)JSONObject.toJSONString(itemMap));
        if (itemMap.isEmpty()) {
            return;
        }
        Map<String, String> xtypeItemMap = itemMap.get("xtype");
        Map<String, String> ytypeItemMap = itemMap.get("ytype");
        this.getView().getPageCache().put("xTypeCache", JSONObject.toJSONString(xtypeItemMap));
        this.getView().getPageCache().put("yTypeCache", JSONObject.toJSONString(ytypeItemMap));
        this.setComboItems(FieldDataUtils.buildComboItem(xtypeItemMap), KEY_XAXIS);
        this.setComboItems(FieldDataUtils.buildComboItem(ytypeItemMap), KEY_YAXIS);
    }

    private void initRankingListSort(List<ComboItem> items, String calcCode) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("rankinglistsort");
        ArrayList comboItems = Lists.newArrayListWithExpectedSize((int)10);
        comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8c03\u85aa\u6bd4\u4f8b", (String)"NineGridPlugin_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0])), "adjratio"));
        comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8c03\u85aa\u91d1\u989d", (String)"NineGridPlugin_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0])), "adjamount"));
        comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u85aa\u916c\u6bd4\u7387", (String)"NineGridPlugin_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0])), "aftersalarypercent"));
        comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u85aa\u916c\u6e17\u900f\u7387", (String)"NineGridPlugin_4", (String)"swc-hcdm-formplugin", (Object[])new Object[0])), "aftersalaryseeprate"));
        comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6700\u7ec8\u85aa\u916c", (String)"NineGridPlugin_2", (String)"swc-hcdm-formplugin", (Object[])new Object[0])), "finalamount"));
        if (!items.isEmpty()) {
            comboItems.addAll(items);
        }
        comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u804c\u7ea7", (String)"NineGridPlugin_5", (String)"swc-hcdm-formplugin", (Object[])new Object[0])), "joblevel"));
        comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u804c\u7b49", (String)"NineGridPlugin_6", (String)"swc-hcdm-formplugin", (Object[])new Object[0])), "jobgrade"));
        comboEdit.setComboItems((List)comboItems);
        ComboProp comboProp = (ComboProp)this.getModel().getProperty("rankinglistsort");
        if (CalcType.RATIO.getCode().equals(calcCode)) {
            comboProp.setDefaultValue((Object)"adjratio");
        } else {
            comboProp.setDefaultValue((Object)"adjamount");
        }
        this.getView().updateView("rankinglistsort");
    }

    private void setComboItems(List<ComboItem> gradeComboItems, String ... keys) {
        for (String key : keys) {
            ComboEdit comboEdit = (ComboEdit)this.getControl(key);
            if (comboEdit == null) continue;
            comboEdit.setComboItems(gradeComboItems);
        }
    }

    private void setAxisName(Long pkId) {
        DynamicObject[] axisData = AxisDataConfigHelper.queryAxisDataByCfgId((Long)pkId);
        Map<String, String> categoryMap = this.getAxisBizitemCategoryMap(axisData);
        this.getModel().setValue(KEY_XAXIS, (Object)categoryMap.get("1"));
        this.getModel().setValue(KEY_YAXIS, (Object)categoryMap.get("2"));
    }

    private void setLabelValue(String labelKey, String labelValue) {
        Label label = (Label)this.getView().getControl(labelKey);
        if (label != null) {
            label.setText(labelValue);
        }
    }

    private Map<String, String> getAxisBizitemCategoryMap(DynamicObject[] axisData) {
        return Arrays.stream(axisData).collect(Collectors.toMap(object -> object.getString("axis"), object -> object.getString("bizitemcategory.name")));
    }

    private void addAfterF7SelectListener(String ... fields) {
        for (String filed : fields) {
            BasedataEdit control = (BasedataEdit)this.getView().getControl(filed);
            control.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
    }

    private List<String> generateKey(String prefix) {
        ArrayList<String> result = new ArrayList<String>(10);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.suffixList.size(); ++i) {
            stringBuilder.append(prefix).append(this.suffixList.get(i));
            result.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        return result;
    }

    private String generateKey(String axis, String index) {
        return String.format("%s%s", axis, index);
    }

    private boolean checkParentView() {
        if (this.getParentView() == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u7533\u8bf7\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u64cd\u4f5c\u8c03\u85aa\u8f85\u52a9\u51b3\u7b56\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u5b9a\u8c03\u85aa\u7533\u8bf7\u5355\u518d\u64cd\u4f5c\u8f85\u52a9\u51b3\u7b56\u4fe1\u606f\u3002", (String)"NineGridPlugin_9", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }
}

