/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjapprbill.entryimport;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.rpc.holders.StringHolder;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.id.ID;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.sdk.swc.hcdm.common.adjfile.AdjFileMatchParam;
import kd.sdk.swc.hcdm.common.adjfile.AdjfileMatchResult;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropConfigEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdMatchResultNew;
import kd.sdk.swc.hcdm.common.stdtab.StdTabNotFoundType;
import kd.swc.hcdm.business.adjapplication.service.AdjApprovalApplicationService;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.adjapprbill.AdjBillEntryImpHelper;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprCreateGridHelper;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprGridHelper;
import kd.swc.hcdm.business.adjapprbill.adjfieldcfg.AdjDetailFieldMappingHelper;
import kd.swc.hcdm.business.adjapprbill.entity.AdjApprPerQueryParam;
import kd.swc.hcdm.business.adjapprbill.enums.CalcType;
import kd.swc.hcdm.business.converter.DecimalConverter;
import kd.swc.hcdm.business.imports.perm.AdjFilePermissionHandler;
import kd.swc.hcdm.business.imports.perm.IPermissionHandler;
import kd.swc.hcdm.business.matchprop.entity.MatchStdTableWithAdjFileParam;
import kd.swc.hcdm.business.salaryadjfile.AdjFileCertCommonHelper;
import kd.swc.hcdm.business.salarystandard.ContrastConfigHelper;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.common.enums.AdjFileStatusEnum;
import kd.swc.hcdm.formplugin.adjapprbill.entryimport.AdjBillEntryImpConfig;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.imports.ProgressHandler;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class AdjBillEntryBizHelper {
    private static Log logger = LogFactory.getLog(AdjBillEntryBizHelper.class);
    private static String fixSalMustCol = "dy_number,dy_standarditem";
    private static String adjSalMustCol = "dy_number,dy_standarditem,dy_calctype";
    private static String gradeAndRank = "dy_grade,dy_rank";
    private static String baseDataNameProp = "dy_standarditem,dy_frequency,dy_grade,dy_rank,dy_currency";
    private static SWCDataServiceHelper adjPersonService = new SWCDataServiceHelper("hcdm_adjapprperson");
    private static MainEntityType adjPersonEntity = MetadataServiceHelper.getDataEntityType((String)"hcdm_adjapprperson");
    private static Map<String, Long> comparaConCfg = AdjDetailFieldMappingHelper.getAdjDetailFieldToContrastCfg();
    private static String personProperty = "job,position,stdposition,joblevel,jobgrade,laborreltype,laborrelstatus,jobscm,jobseq,jobfamily,jobclass,projectteam,postype,departmenttype,admindivision,workplace,industrytype,operationequal,eocpquallevel,protitle,protitlelevel,protitletype,pocpquallevel,ocpqual,schooltype,diploma,religion,nationality";

    public static void asyncResolveExcel(final AdjBillEntryImpConfig conf) {
        String url = String.valueOf(conf.getParam().get("url"));
        final int fixRemarkHeight = (Integer)conf.getParam().get("fixRemarkHeight");
        final int fixHeadHeight = (Integer)conf.getParam().get("fixHeadHeight");
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream in = service.getInputStream(url);){
            conf.setResolveBegin(true);
            new ExcelReader().read(in, new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow row) {
                    int rowNum = row.getRowNum();
                    if (rowNum < fixRemarkHeight) {
                        return;
                    }
                    if (fixRemarkHeight <= rowNum && rowNum < fixHeadHeight) {
                        conf.getDataHead().add(row.getData());
                    } else if (!row.isEmpty()) {
                        Map rowData = row.getData();
                        rowData.put(2199, String.valueOf(row.getRowNum()));
                        conf.getDataQueues().add(rowData);
                    }
                    if (conf.getDataQueues().size() >= 9000) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            logger.error((Throwable)e);
                        }
                    }
                }
            });
            conf.setResolveEnd(true);
        }
        catch (Exception ex) {
            logger.error("AdjBillEntryImpTask.resolveExcel error:", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u8bfb\u53d6Excel\u6570\u636e\u9519\u8bef,\u8be6\u7ec6\u8bf7\u770b\u65e5\u5fd7\u3002", (String)"AdjBillEntryImpTask_4", (String)"swc-hcdm-formplugin", (Object[])new Object[0])), new Object[0]);
        }
    }

    public static void validateBizData(String salaryadjrsnType, AdjBillEntryImpConfig conf, List<Map<Integer, String>> dataRows, Map<String, Integer> colKeyIndexMap, DataEntityPropertyCollection propertyCollection) {
        ProgressHandler handler = conf.getHandler();
        long beginTime = System.currentTimeMillis();
        long startTime = System.currentTimeMillis();
        Map<Integer, String> colIdToFileMap = conf.getDataHead().get(0);
        Map<Integer, String> colIdToNameMap = conf.getDataHead().get(2);
        Map<String, Object> params = conf.getParam();
        QFilter[] adjFilePermFilter = conf.getAdjFilePermissionFilter();
        Long orgId = Long.valueOf(params.get("orgId").toString());
        String orgName = params.get("orgName").toString();
        HashMap map = Maps.newHashMap();
        map.put(DecAdjApprCreateGridHelper.buildKey((String)"adjfile"), new AdjFilePermissionHandler());
        Map<String, Map<String, List<DynamicObject>>> baseDataMap = AdjBillEntryBizHelper.loadBaseDataWithPermission(colIdToFileMap, dataRows, propertyCollection, map);
        conf.setBaseDataMap(baseDataMap);
        logger.info(" loadBaseDataWithPermission use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        boolean isGradeRankValidate = false;
        if (AdjAttributionType.DECATTRTYPE.getCode().equals(salaryadjrsnType)) {
            AdjBillEntryBizHelper.mustInputFieldValidate(fixSalMustCol, colIdToFileMap, colKeyIndexMap, dataRows, baseDataMap, handler, propertyCollection, colIdToNameMap);
            isGradeRankValidate = true;
        } else if (AdjAttributionType.ADJATTRTYPE.getCode().equals(salaryadjrsnType)) {
            AdjBillEntryBizHelper.mustInputFieldValidate(adjSalMustCol, colIdToFileMap, colKeyIndexMap, dataRows, baseDataMap, handler, propertyCollection, colIdToNameMap);
        }
        logger.info(" mustInputFieldValidate use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        AdjBillEntryBizHelper.importAdjfileValidate(salaryadjrsnType, colKeyIndexMap, dataRows, baseDataMap, handler, orgId, orgName, adjFilePermFilter);
        logger.info(" importAdjfileValidate use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        Map<Integer, String> indexToStructNameMap = AdjBillEntryBizHelper.itemValidate(colKeyIndexMap, dataRows, baseDataMap, handler);
        logger.info(" itemValidate use time:{}", (Object)(System.currentTimeMillis() - startTime));
        Set<Long> fileIds = AdjBillEntryBizHelper.getAdjFileId(colKeyIndexMap, dataRows, baseDataMap, handler);
        Map<Long, Map<Long, DynamicObject>> itemEntryDataOfPage = AdjBillEntryBizHelper.queryItemEntryByFileId(fileIds, Long.parseLong((String)params.get("billid")));
        startTime = System.currentTimeMillis();
        AdjBillEntryBizHelper.stdTableValidate(salaryadjrsnType, isGradeRankValidate, colKeyIndexMap, dataRows, baseDataMap, indexToStructNameMap, conf, propertyCollection, itemEntryDataOfPage);
        logger.info(" stdTableValidate use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        String countryId = (String)params.get("countryId");
        AdjBillEntryBizHelper.countryValidate(countryId, colKeyIndexMap, dataRows, baseDataMap, conf);
        logger.info(" countryValidate use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        AdjBillEntryBizHelper.bsedDateValidate(salaryadjrsnType, colKeyIndexMap, dataRows, baseDataMap, handler, conf, itemEntryDataOfPage);
        logger.info(" bsedDateValidate use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        AdjBillEntryBizHelper.repeatDataValidate(salaryadjrsnType, colKeyIndexMap, dataRows, handler);
        logger.info("repeatDataValidate use time:{}", (Object)(System.currentTimeMillis() - startTime));
        logger.info("AdjBillEntryBizHelper.validateBizData use total time:{}", (Object)(System.currentTimeMillis() - beginTime));
    }

    private static Set<Long> getAdjFileId(Map<String, Integer> colKeyIndexMap, List<Map<Integer, String>> dataRows, Map<String, Map<String, List<DynamicObject>>> baseDataMap, ProgressHandler handler) {
        String adjFileKey = DecAdjApprCreateGridHelper.buildKey((String)"adjfile");
        Map<String, List<DynamicObject>> adjFileDataMap = baseDataMap.get(adjFileKey);
        if (MapUtils.isEmpty(adjFileDataMap)) {
            return Collections.emptySet();
        }
        HashSet resultSet = Sets.newHashSetWithExpectedSize((int)dataRows.size());
        Integer fileIdx = colKeyIndexMap.get(adjFileKey);
        for (int index = 0; index < dataRows.size(); ++index) {
            Map<Integer, String> row = dataRows.get(index);
            String adjFileNumber = row.get(fileIdx);
            List<DynamicObject> objectList = adjFileDataMap.get(adjFileNumber);
            if (!CollectionUtils.isNotEmpty(objectList)) continue;
            resultSet.add(objectList.get(0).getLong("id"));
        }
        return resultSet;
    }

    private static Map<Long, Map<Long, DynamicObject>> queryItemEntryByFileId(Set<Long> fileIds, Long adjBillId) {
        if (CollectionUtils.isEmpty(fileIds)) {
            return Collections.emptyMap();
        }
        AdjApprPerQueryParam adjApprPerQueryParam = new AdjApprPerQueryParam();
        adjApprPerQueryParam.setAdjApprBillId(adjBillId);
        adjApprPerQueryParam.setAdjFileIds(fileIds);
        DynamicObject[] adjApprPersonData = DecAdjApprGridHelper.getAdjApprPersonData((String)"id,adjapprbill,adjfile,standarditem,salbsed,salbsled", (AdjApprPerQueryParam)adjApprPerQueryParam);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)adjApprPersonData.length);
        for (DynamicObject adjApprPerson : adjApprPersonData) {
            long fileId = adjApprPerson.getLong("adjfile.id");
            if (fileId <= 0L) continue;
            Map valueMap = resultMap.computeIfAbsent(fileId, val -> Maps.newHashMap());
            DynamicObjectCollection itemEntry = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject itemRow : itemEntry) {
                long itemId = itemRow.getLong("standarditem.id");
                if (itemId <= 0L) continue;
                valueMap.put(itemId, itemRow);
            }
        }
        return resultMap;
    }

    private static void bsedDateValidate(String salaryadjrsnType, Map<String, Integer> colKeyIndexMap, List<Map<Integer, String>> dataRow, Map<String, Map<String, List<DynamicObject>>> baseDataMap, ProgressHandler handler, AdjBillEntryImpConfig conf, Map<Long, Map<Long, DynamicObject>> itemEntryDataOfPage) {
        block14: {
            Date entBsled;
            DynamicObject entryRowObject;
            DynamicObject itemObj;
            DynamicObject fileObj;
            Integer rowNumIndex;
            Map<Integer, String> row;
            Map adjfileMatchResultMap;
            AdjFileApplicationService adjFileApplicationService;
            Date billEffectiveDate;
            Date maxBsled;
            HashMap<Long, Set> fileBoidToItemIdMap;
            Map<String, List<DynamicObject>> adjFileDataMap;
            Map<String, List<DynamicObject>> itemDataMap;
            Integer salBsledIndex;
            Integer salBsedIndex;
            Integer itemIndex;
            Integer empNumIndex;
            Integer adjFileIndex;
            String adjAfterNearestDate;
            String dateFormatMsg;
            block13: {
                String decAfterNearestDate = ResManager.loadKDString((String)"\u5de5\u53f7\uff08%1$s\uff09\uff1a\u5b9a\u8c03\u85aa\u751f\u6548\u65e5\u671f\uff08%2$s\uff09\u5fc5\u987b\u5927\u4e8e\u4e0a\u4e00\u6b21\u5b9a\u8c03\u85aa\u751f\u6548\u65e5\u671f\uff08%3$s\uff09\u3002", (String)"AdjBillEntryBizHelper_47", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
                dateFormatMsg = ResManager.loadKDString((String)"\u5de5\u53f7%s\uff1a\u751f\u6548\u65e5\u671f\u683c\u5f0f\u586b\u5199\u6709\u8bef,\u8bf7\u586b\u5199\u6b63\u786e\u7684\u683c\u5f0f\u3002", (String)"AdjBillEntryBizHelper_32", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
                adjAfterNearestDate = ResManager.loadKDString((String)"\u5de5\u53f7\uff08%1$s\uff09\uff1a\u5b9a\u8c03\u85aa\u751f\u6548\u65e5\u671f\uff08%2$s\uff09\u5fc5\u987b\u5927\u4e8e\u4e0a\u4e00\u6b21\u5b9a\u8c03\u85aa\u751f\u6548\u65e5\u671f\uff08%3$s\uff09\u3002", (String)"AdjBillEntryBizHelper_47", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
                String keyAdjFile = DecAdjApprCreateGridHelper.buildKey((String)"adjfile");
                String keyNumber = DecAdjApprCreateGridHelper.buildKey((String)"number");
                adjFileIndex = colKeyIndexMap.get(keyAdjFile);
                empNumIndex = colKeyIndexMap.get(keyNumber);
                String keyItem = DecAdjApprCreateGridHelper.buildKey((String)"standarditem");
                String keySalbsed = DecAdjApprCreateGridHelper.buildKey((String)"salbsed");
                String keySalbsled = DecAdjApprCreateGridHelper.buildKey((String)"salbsled");
                itemIndex = colKeyIndexMap.get(keyItem);
                salBsedIndex = colKeyIndexMap.get(keySalbsed);
                salBsledIndex = colKeyIndexMap.get(keySalbsled);
                itemDataMap = baseDataMap.get(keyItem);
                adjFileDataMap = baseDataMap.get(keyAdjFile);
                fileBoidToItemIdMap = new HashMap<Long, Set>(16);
                ArrayList<AdjFileMatchParam> params = new ArrayList<AdjFileMatchParam>(10);
                String effectiveDateStr = (String)conf.getParam().get("effectivedate");
                maxBsled = SWCDateTimeUtils.getMaxBsled();
                billEffectiveDate = null;
                if (StringUtils.isNotBlank((CharSequence)effectiveDateStr)) {
                    try {
                        billEffectiveDate = SWCDateTimeUtils.parseDate((String)effectiveDateStr, (String)"yyyy-MM-dd");
                    }
                    catch (ParseException e) {
                        logger.error("parseDate error", (Throwable)e);
                    }
                }
                for (int i = 0; i < dataRow.size(); ++i) {
                    Map<Integer, String> row2 = dataRow.get(i);
                    if (handler.getLogCache().containsKey(AdjBillEntryBizHelper.getOriExelRowNumber(row2))) continue;
                    String fileNum = row2.get(adjFileIndex);
                    String itemNum = row2.get(itemIndex);
                    DynamicObject fileObj2 = adjFileDataMap.get(fileNum).get(0);
                    DynamicObject itemObj2 = itemDataMap.get(itemNum).get(0);
                    DynamicObject entryRowObject2 = AdjBillEntryBizHelper.getEntryRowObject(fileObj2, itemObj2, itemEntryDataOfPage);
                    Date entBsed = AdjBillEntryBizHelper.getDateFromExcelOrPage(row2, salBsedIndex, entryRowObject2, "salbsed", billEffectiveDate);
                    Date entBsled2 = AdjBillEntryBizHelper.getDateFromExcelOrPage(row2, salBsledIndex, entryRowObject2, "salbsled", maxBsled);
                    if (entBsed == null || entBsled2 == null || fileObj2 == null || itemObj2 == null) continue;
                    Set itemSet = fileBoidToItemIdMap.computeIfAbsent(fileObj2.getLong("boid"), val -> new HashSet(16));
                    itemSet.add(itemObj2.getLong("id"));
                    AdjFileMatchParam matchParam = new AdjFileMatchParam();
                    matchParam.setAdjFileBoId(Long.valueOf(fileObj2.getLong("boid")));
                    matchParam.setBsed(entBsed);
                    matchParam.setBsled(entBsled2);
                    matchParam.setUnionId(DecAdjApprCreateGridHelper.combineStrings((String[])new String[]{fileObj2.getString("boid"), itemObj2.getString("id"), SWCDateTimeUtils.format((Date)entBsed, (String)"yyyy-MM-dd"), SWCDateTimeUtils.format((Date)entBsled2, (String)"yyyy-MM-dd")}));
                    matchParam.setBeforeAdjFileMinBsed(false);
                    params.add(matchParam);
                }
                if (MapUtils.isEmpty(fileBoidToItemIdMap)) {
                    return;
                }
                adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
                adjfileMatchResultMap = adjFileApplicationService.batchMatchEffectiveAdjfileVersion(params);
                if (!AdjAttributionType.DECATTRTYPE.getCode().equals(salaryadjrsnType)) break block13;
                Map maxDisableDate = adjFileApplicationService.getMaxBsedOfRecordForDecType(fileBoidToItemIdMap.keySet());
                logger.info("maxDisableDate is{}", (Object)JSON.toJSONString((Object)maxDisableDate));
                for (int i = 0; i < dataRow.size(); ++i) {
                    String unionId;
                    AdjfileMatchResult adjfileMatchResult;
                    row = dataRow.get(i);
                    rowNumIndex = AdjBillEntryBizHelper.getOriExelRowNumber(row);
                    if (handler.getLogCache().containsKey(rowNumIndex)) continue;
                    fileObj = adjFileDataMap.get(row.get(adjFileIndex)).get(0);
                    itemObj = itemDataMap.get(row.get(itemIndex)).get(0);
                    entryRowObject = AdjBillEntryBizHelper.getEntryRowObject(fileObj, itemObj, itemEntryDataOfPage);
                    Date entBsed = AdjBillEntryBizHelper.getDateFromExcelOrPage(row, salBsedIndex, entryRowObject, "salbsed", billEffectiveDate);
                    entBsled = AdjBillEntryBizHelper.getDateFromExcelOrPage(row, salBsledIndex, entryRowObject, "salbsled", maxBsled);
                    String empNum = row.get(empNumIndex);
                    if (entBsed == null) {
                        handler.putRowError(rowNumIndex, String.format(Locale.ROOT, dateFormatMsg, empNum));
                        continue;
                    }
                    String formatEntBsed = SWCDateTimeUtils.format((Date)entBsed, (String)"yyyy-MM-dd");
                    String formatEntBsled = SWCDateTimeUtils.format((Date)entBsled, (String)"yyyy-MM-dd");
                    if (entBsled.compareTo(entBsed) < 0) {
                        handler.putRowError(rowNumIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5de5\u53f7\uff08%1$s\uff09\uff1a\u5b9a\u8c03\u85aa\u751f\u6548\u65e5\u671f\uff08%2$s\uff09\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65e5\u671f\uff08%3$s\uff09\u3002", (String)"DecAdjApprBaseValidator_15", (String)"swc-hcdm-opplugin", (Object[])new Object[0]), empNum, formatEntBsed, formatEntBsled));
                    }
                    if (fileObj == null || itemObj == null) continue;
                    if (!adjfileMatchResultMap.isEmpty() && null != (adjfileMatchResult = (AdjfileMatchResult)adjfileMatchResultMap.get(unionId = DecAdjApprCreateGridHelper.combineStrings((String[])new String[]{fileObj.getString("boid"), itemObj.getString("id"), SWCDateTimeUtils.format((Date)entBsed, (String)"yyyy-MM-dd"), SWCDateTimeUtils.format((Date)entBsled, (String)"yyyy-MM-dd")}))) && null == adjfileMatchResult.getAdjfileVersion()) {
                        handler.putRowError(rowNumIndex, adjfileMatchResult.getAdjfileNotFoundErrorEnum().getLocaleName().loadKDString());
                        continue;
                    }
                    if (maxDisableDate.isEmpty() || null == maxDisableDate.get(fileObj.getLong("boid"))) continue;
                    Date disableDate = (Date)maxDisableDate.get(fileObj.getLong("boid"));
                    logger.info("empNumber is:{},excelEffectDate is:{}, adjfile disableDate is:{}", new Object[]{empNum, SWCDateTimeUtils.format((Date)entBsed, (String)"yyyy-MM-dd"), SWCDateTimeUtils.format((Date)disableDate, (String)"yyyy-MM-dd")});
                    if (entBsed.after(disableDate)) continue;
                    String bsedStr = HRInteDateTimeUtil.formatDate((String)"hcdm_salaryadjrecord", (String)"bsed", (Date)entBsed);
                    String disableDateStr = HRInteDateTimeUtil.formatDate((String)"hcdm_salaryadjrecord", (String)"bsed", (Date)disableDate);
                    handler.putRowError(rowNumIndex, String.format(Locale.ROOT, decAfterNearestDate, empNum, bsedStr, disableDateStr));
                }
                break block14;
            }
            if (!AdjAttributionType.ADJATTRTYPE.getCode().equals(salaryadjrsnType)) break block14;
            Map maxBsedOfFileForAdjBill = adjFileApplicationService.getMaxBsedOfRecordForAdjType(fileBoidToItemIdMap);
            logger.info("maxBsedOfFileForAdjBill is{}", (Object)JSON.toJSONString((Object)maxBsedOfFileForAdjBill));
            for (int i = 0; i < dataRow.size(); ++i) {
                Date disableDate;
                Map itemToDateMap;
                String unionId;
                AdjfileMatchResult adjfileMatchResult;
                row = dataRow.get(i);
                rowNumIndex = AdjBillEntryBizHelper.getOriExelRowNumber(row);
                if (handler.getLogCache().containsKey(rowNumIndex)) continue;
                fileObj = adjFileDataMap.get(row.get(adjFileIndex)).get(0);
                itemObj = itemDataMap.get(row.get(itemIndex)).get(0);
                entryRowObject = AdjBillEntryBizHelper.getEntryRowObject(fileObj, itemObj, itemEntryDataOfPage);
                Date excelEffectDate = AdjBillEntryBizHelper.getDateFromExcelOrPage(row, salBsedIndex, entryRowObject, "salbsed", billEffectiveDate);
                entBsled = AdjBillEntryBizHelper.getDateFromExcelOrPage(row, salBsledIndex, entryRowObject, "salbsled", maxBsled);
                String empNum = row.get(empNumIndex);
                if (excelEffectDate == null) {
                    handler.putRowError(rowNumIndex, String.format(Locale.ROOT, dateFormatMsg, empNum));
                    continue;
                }
                Long itemId = itemObj.getLong("id");
                String formatEntBsed = SWCDateTimeUtils.format((Date)excelEffectDate, (String)"yyyy-MM-dd");
                String formatEntBsled = SWCDateTimeUtils.format((Date)entBsled, (String)"yyyy-MM-dd");
                if (entBsled.compareTo(excelEffectDate) < 0) {
                    handler.putRowError(rowNumIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5de5\u53f7\uff08%1$s\uff09\uff1a\u5b9a\u8c03\u85aa\u751f\u6548\u65e5\u671f\uff08%2$s\uff09\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65e5\u671f\uff08%3$s\uff09\u3002", (String)"DecAdjApprBaseValidator_15", (String)"swc-hcdm-opplugin", (Object[])new Object[0]), empNum, formatEntBsed, formatEntBsled));
                    continue;
                }
                if (!adjfileMatchResultMap.isEmpty() && null != (adjfileMatchResult = (AdjfileMatchResult)adjfileMatchResultMap.get(unionId = DecAdjApprCreateGridHelper.combineStrings((String[])new String[]{fileObj.getString("boid"), itemObj.getString("id"), SWCDateTimeUtils.format((Date)excelEffectDate, (String)"yyyy-MM-dd"), SWCDateTimeUtils.format((Date)entBsled, (String)"yyyy-MM-dd")}))) && null == adjfileMatchResult.getAdjfileVersion()) {
                    handler.putRowError(rowNumIndex, adjfileMatchResult.getAdjfileNotFoundErrorEnum().getLocaleName().loadKDString());
                    continue;
                }
                if (MapUtils.isEmpty((Map)maxBsedOfFileForAdjBill) || MapUtils.isEmpty((Map)(itemToDateMap = (Map)maxBsedOfFileForAdjBill.get(fileObj.getLong("boid")))) || ObjectUtils.isEmpty(itemToDateMap.get(itemId)) || excelEffectDate.after(disableDate = (Date)itemToDateMap.get(itemId))) continue;
                handler.putRowError(rowNumIndex, String.format(Locale.ROOT, adjAfterNearestDate, empNum, formatEntBsed, HRInteDateTimeUtil.formatDate((String)"hcdm_salaryadjrecord", (String)"bsed", (Date)disableDate)));
            }
        }
    }

    private static DynamicObject getEntryRowObject(DynamicObject fileObj, DynamicObject itemObj, Map<Long, Map<Long, DynamicObject>> itemEntryDataOfPage) {
        if (fileObj != null && itemObj != null) {
            DynamicObject itemEntryObj;
            long fileId = fileObj.getLong("id");
            long itemId = itemObj.getLong("id");
            Map<Long, DynamicObject> itemEntryData = itemEntryDataOfPage.get(fileId);
            if (itemEntryData != null && (itemEntryObj = itemEntryData.get(itemId)) != null) {
                return itemEntryObj;
            }
        }
        return null;
    }

    private static Date getDateFromExcelOrPage(Map<Integer, String> row, Integer entDateIndex, DynamicObject entryRowObject, String entDatePropName, Date defaultDate) {
        if (entDateIndex == null) {
            if (entryRowObject != null && entryRowObject.getDate(entDatePropName) != null) {
                return entryRowObject.getDate(entDatePropName);
            }
        } else {
            String dateExcel = row.get(entDateIndex);
            if (StringUtils.isNotBlank((CharSequence)dateExcel)) {
                try {
                    return SWCDateTimeUtils.parseDate((String)dateExcel, (String)"yyyy-MM-dd");
                }
                catch (ParseException parseException) {
                }
            } else if (entryRowObject != null && entryRowObject.getDate(entDatePropName) != null) {
                return entryRowObject.getDate(entDatePropName);
            }
        }
        return defaultDate;
    }

    private static Map<Integer, String> itemValidate(Map<String, Integer> colKeyIndexMap, List<Map<Integer, String>> dataRow, Map<String, Map<String, List<DynamicObject>>> baseDataMap, ProgressHandler handler) {
        HashMap indexToStructNameMap = Maps.newHashMapWithExpectedSize((int)dataRow.size());
        Map<String, List<DynamicObject>> adjFileDataMap = baseDataMap.get(DecAdjApprCreateGridHelper.buildKey((String)"adjfile"));
        Map<String, List<DynamicObject>> itemDataMap = baseDataMap.get(DecAdjApprCreateGridHelper.buildKey((String)"standarditem"));
        String itemNotBelongToStructMsg = ResManager.loadKDString((String)"\u5de5\u53f7%1$s\uff1a\u5b9a\u8c03\u85aa\u9879\u76ee\u4e0d\u5c5e\u4e8e\u8be5\u4eba\u5458\u6863\u6848(%2$s)\u3010%3$s\u85aa\u916c\u7ed3\u6784\u3011\u4e2d\u7684\u5b9a\u8c03\u85aa\u9879\u76ee\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjBillEntryBizHelper_33", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        HashMap structToItemMap = Maps.newHashMapWithExpectedSize((int)dataRow.size());
        HashSet<Long> structIds = new HashSet<Long>(dataRow.size());
        Integer adjFileIndex = colKeyIndexMap.get(DecAdjApprCreateGridHelper.buildKey((String)"adjfile"));
        Integer standardItemIndex = colKeyIndexMap.get(DecAdjApprCreateGridHelper.buildKey((String)"standarditem"));
        Integer empNumberIndex = colKeyIndexMap.get(DecAdjApprCreateGridHelper.buildKey((String)"number"));
        for (int i = 0; i < dataRow.size(); ++i) {
            Map<Integer, String> row = dataRow.get(i);
            Integer rowNumber = AdjBillEntryBizHelper.getOriExelRowNumber(row);
            if (handler.getLogCache().containsKey(rowNumber)) continue;
            String adjFileNumber = row.get(adjFileIndex);
            String standardItem = row.get(standardItemIndex);
            DynamicObject fileObj = adjFileDataMap.get(adjFileNumber).get(0);
            Long salaystructureId = fileObj.getLong("salaystructure.id");
            structIds.add(salaystructureId);
            HashMap subMap = (HashMap)structToItemMap.computeIfAbsent(salaystructureId, key -> Maps.newHashMapWithExpectedSize((int)8));
            subMap.put(i, itemDataMap.get(standardItem));
        }
        if (CollectionUtils.isNotEmpty(structIds)) {
            DynamicObject[] structObjs = AdjBillEntryImpHelper.getSalayStructure(structIds);
            Map<Long, Set> structIdToItemIdMap = Arrays.stream(structObjs).collect(Collectors.toMap(key -> key.getLong("id"), dy -> dy.getDynamicObjectCollection("entryentity").stream().map(obj -> obj.getLong("standarditem.id")).collect(Collectors.toSet())));
            Map<Long, String> strIdToNameMap = Arrays.stream(structObjs).collect(Collectors.toMap(key -> key.getLong("id"), dy -> dy.getString("name")));
            for (Map.Entry entry : structToItemMap.entrySet()) {
                Long structId = (Long)entry.getKey();
                Map subStMap = (Map)entry.getValue();
                Set itemSet = structIdToItemIdMap.get(structId);
                subStMap.forEach((key, val) -> {
                    DynamicObject matchItem = val.stream().filter(obj -> itemSet.contains(obj.getLong("id"))).findFirst().orElse(null);
                    Map row = (Map)dataRow.get((int)key);
                    if (matchItem != null) {
                        itemDataMap.put((String)row.get(standardItemIndex), Collections.singletonList(matchItem));
                        indexToStructNameMap.put(key, strIdToNameMap.get(structId));
                    } else {
                        String structName = (String)strIdToNameMap.get(structId);
                        String empNumber = (String)row.get(empNumberIndex);
                        String adjfileNumber = (String)row.get(adjFileIndex);
                        handler.putRowError(AdjBillEntryBizHelper.getOriExelRowNumber(row), String.format(Locale.ROOT, itemNotBelongToStructMsg, empNumber, adjfileNumber, structName));
                    }
                });
            }
        }
        return indexToStructNameMap;
    }

    public static List<DynamicObject> convertData(AdjBillEntryImpConfig conf, List<Map<Integer, String>> dataRows, DataEntityPropertyCollection propertyCollection) {
        List<DynamicObject> newAdjPersonList = null;
        if (CollectionUtils.isEmpty(dataRows)) {
            return null;
        }
        Map<Integer, String> colIdMap = conf.getDataHead().get(0);
        LinkedHashMap<String, Integer> colKeyIndexMap = new LinkedHashMap<String, Integer>();
        colIdMap.forEach((key, value) -> colKeyIndexMap.put((String)value, (Integer)key));
        Object billid = conf.getParam().get("billid");
        long beginTime = System.currentTimeMillis();
        Map<String, List<Map<Integer, String>>> personGroups = AdjBillEntryBizHelper.groupByAdjFileNumber(dataRows, colKeyIndexMap, conf.getHandler());
        if (ObjectUtils.isNotEmpty((Object)billid) && MapUtils.isNotEmpty(personGroups)) {
            Long billId = Long.parseLong((String)billid);
            logger.info("convertData adjapprbill id is:{}", (Object)billId);
            Map<String, List<DynamicObject>> adjPersonDB = new HashMap<String, List<DynamicObject>>(16);
            Object[] adjPersons = AdjBillEntryImpHelper.queryAdjPersonByBillId((Long)billId);
            if (ArrayUtils.isNotEmpty((Object[])adjPersons)) {
                adjPersonDB = Arrays.stream(adjPersons).collect(Collectors.groupingBy(obj -> obj.getString("adjfile.number")));
            }
            newAdjPersonList = AdjBillEntryBizHelper.geneAdjPersonAndEntryObj(billId, conf, personGroups, adjPersonDB, propertyCollection);
        }
        logger.info("AdjBillEntryBizHelper.convertData geneAdjPersonAndEntryObj use time:{}", (Object)(System.currentTimeMillis() - beginTime));
        return newAdjPersonList;
    }

    private static List<DynamicObject> geneAdjPersonAndEntryObj(Long billId, AdjBillEntryImpConfig conf, Map<String, List<Map<Integer, String>>> personGroups, Map<String, List<DynamicObject>> adjPersonDB, DataEntityPropertyCollection propertyCollection) {
        Map<String, Map<String, List<DynamicObject>>> baseDataMap = conf.getBaseDataMap();
        Map<Integer, String> colIdMap = conf.getDataHead().get(0);
        LinkedHashMap<String, Integer> colKeyIndexMap = new LinkedHashMap<String, Integer>();
        colIdMap.forEach((key, value) -> colKeyIndexMap.put((String)value, (Integer)key));
        String keyAdjFile = DecAdjApprCreateGridHelper.buildKey((String)"adjfile");
        Map<String, List<DynamicObject>> baseAdjFileMap = baseDataMap.get(keyAdjFile);
        ArrayList allFileList = new ArrayList(baseAdjFileMap.size());
        baseAdjFileMap.values().stream().forEach(obj -> allFileList.addAll(obj));
        long startTime = System.currentTimeMillis();
        Map<Long, Map<Long, Object>> contrastPropValueMap = AdjBillEntryBizHelper.getContrastPropValueMap(allFileList.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList()));
        logger.info("contrastPropValueMap:{}", (Object)JSON.toJSONString(contrastPropValueMap));
        logger.info("getContrastPropValueMap use time:{}", (Object)(System.currentTimeMillis() - startTime));
        HashSet employeeIds = new HashSet(baseAdjFileMap.size());
        HashSet personSetIds = new HashSet(baseAdjFileMap.size());
        allFileList.forEach(obj -> {
            employeeIds.add(obj.getLong("employee.id"));
            personSetIds.add(obj.getLong("person.id"));
        });
        startTime = System.currentTimeMillis();
        Map contrWorkLocMap = DecAdjApprGridHelper.getContractWorkPlace(new ArrayList(employeeIds));
        Map baseLocationcMap = DecAdjApprGridHelper.getPermanentWorkPlace(new ArrayList(employeeIds));
        startTime = System.currentTimeMillis();
        Map entryDateMap = DecAdjApprGridHelper.getEntryDate(personSetIds);
        logger.info("entryDateMap size is:{}", (Object)entryDateMap.size());
        logger.info("DecAdjApprGridHelper.getEntryDate use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        Map realregulardateMap = DecAdjApprGridHelper.getRealRegularDate(personSetIds);
        logger.info("realregulardateMap size is:{}", (Object)realregulardateMap.size());
        logger.info("DecAdjApprGridHelper.getRealRegularDate use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        Map stdSourceVids = AdjBillEntryImpHelper.getStdSourceVids(conf.getStdTableMatchResult());
        logger.info("AdjBillEntryImpHelper.getStdSourceVids use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        Map<Long, DynamicObject> stdTableDynMap = conf.getStdTableDynMap();
        logger.info("AdjBillEntryImpHelper.getStdTableInfo use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        Map coefficientMap = AdjBillEntryImpHelper.getCoefficientInfo((Set)((Set)stdSourceVids.get("coefficientVid")));
        logger.info("AdjBillEntryImpHelper.getCoefficientInfo use time:{}", (Object)(System.currentTimeMillis() - startTime));
        ArrayList<DynamicObject> savePersonList = new ArrayList<DynamicObject>(personGroups.size());
        int newAdjPersonIds = 0;
        startTime = System.currentTimeMillis();
        long[] personIds = ORM.create().genLongIds("hcdm_adjapprperson", personGroups.size());
        logger.info("ORM.create().genLongIds() use time is:{}", (Object)(System.currentTimeMillis() - startTime));
        long beginTime = System.currentTimeMillis();
        logger.info("geneAdjPersonAndEntryObj personGroups size is:{}", (Object)personGroups.size());
        for (Map.Entry<String, List<Map<Integer, String>>> personGroup : personGroups.entrySet()) {
            List<DynamicObject> dbPersons;
            String key2 = personGroup.getKey();
            logger.info("geneAdjPersonAndEntryObj for key is:{}", (Object)JSON.toJSONString((Object)key2));
            List<Map<Integer, String>> dataRows = personGroup.getValue();
            DynamicObject baseAdjFile = baseAdjFileMap.get(key2).get(0);
            if (ObjectUtils.isEmpty((Object)baseAdjFile)) {
                AdjBillEntryBizHelper.writeErrorLog(conf.getHandler(), dataRows);
                continue;
            }
            DynamicObject adjPersonObj = null;
            if (MapUtils.isNotEmpty(adjPersonDB) && CollectionUtils.isNotEmpty(dbPersons = adjPersonDB.get(key2))) {
                adjPersonObj = dbPersons.get(0);
            }
            if (adjPersonObj == null) {
                adjPersonObj = adjPersonService.generateEmptyDynamicObject();
                adjPersonObj.set("id", (Object)personIds[newAdjPersonIds++]);
                adjPersonObj.set("adjapprbill", (Object)billId);
                Map<Long, Object> conPropValMap = contrastPropValueMap.get(baseAdjFile.getLong("id"));
                startTime = System.currentTimeMillis();
                AdjBillEntryBizHelper.initAdjPerson(adjPersonObj, baseAdjFile, conPropValMap, contrWorkLocMap, baseLocationcMap, entryDateMap, realregulardateMap);
                logger.info("initAdjPerson use time:{}", (Object)(System.currentTimeMillis() - startTime));
            }
            startTime = System.currentTimeMillis();
            AdjBillEntryBizHelper.assembleAdjPersonEntry(adjPersonObj, conf, dataRows, baseDataMap, colKeyIndexMap, stdTableDynMap, coefficientMap, propertyCollection);
            logger.info("assembleAdjPersonEntry use time:{}", (Object)(System.currentTimeMillis() - startTime));
            savePersonList.add(adjPersonObj);
        }
        logger.info("geneAdjPersonAndEntryObj for use time:{}", (Object)(System.currentTimeMillis() - beginTime));
        return savePersonList;
    }

    private static void initAdjPerson(DynamicObject personObj, DynamicObject adjFile, Map<Long, Object> conPropValMap, Map<Long, DynamicObject> contrWorkLocMap, Map<Long, DynamicObject> baseLocationcMap, Map<Long, DynamicObject> entryDateMap, Map<Long, DynamicObject> realregulardateMap) {
        DynamicObject dyObj;
        DynamicObject baseLocationc;
        personObj.set("confirmstatus", (Object)"0");
        personObj.set("synstatus", (Object)"0");
        personObj.set("adjfile", (Object)adjFile);
        personObj.set("adjfilevid", (Object)adjFile.getLong("sourcevid"));
        personObj.set("employee", adjFile.get("employee"));
        personObj.set("number", adjFile.get("employee.empnumber"));
        personObj.set("person", adjFile.get("person"));
        personObj.set("name", adjFile.get("person.name"));
        personObj.set("depemp", adjFile.get("depemp"));
        personObj.set("empgroup", adjFile.get("empgroup"));
        personObj.set("depcytype", adjFile.get("depcytype"));
        personObj.set("company", adjFile.get("empposorgrel.company"));
        personObj.set("adminorg", adjFile.get("empposorgrel.adminorg"));
        personObj.set("assoadminorg", adjFile.get("assoadminorg"));
        personObj.set("salarystructure", adjFile.get("salaystructure"));
        personObj.set("stdscm", adjFile.get("stdscm.sourcevid"));
        Long personId = adjFile.getLong("person.id");
        Long employeeId = adjFile.getLong("employee.id");
        DynamicObject contWorkPlace = contrWorkLocMap.get(employeeId);
        if (ObjectUtils.isNotEmpty((Object)contWorkPlace)) {
            personObj.set("agreedlocation", contWorkPlace.get("agreedlocation"));
        }
        if (ObjectUtils.isNotEmpty((Object)(baseLocationc = baseLocationcMap.get(employeeId)))) {
            personObj.set("baselocation", baseLocationc.get("location"));
        }
        if (MapUtils.isNotEmpty(entryDateMap) && ObjectUtils.isNotEmpty((Object)entryDateMap.get(personId))) {
            dyObj = entryDateMap.get(personId);
            personObj.set("entrydate", dyObj.getDate("startdate") == null ? " " : dyObj.getDate("startdate"));
        }
        if (MapUtils.isNotEmpty(realregulardateMap) && ObjectUtils.isNotEmpty((Object)realregulardateMap.get(personId))) {
            dyObj = realregulardateMap.get(personId);
            personObj.set("realregulardate", dyObj.getDate("realregulardate") == null ? " " : dyObj.getDate("realregulardate"));
        }
        AdjBillEntryBizHelper.assembleFourPersonInfo(personObj, conPropValMap);
    }

    private static void assembleFourPersonInfo(DynamicObject personObj, Map<Long, Object> conPropValMap) {
        String[] allPersonField;
        for (String colName : allPersonField = personProperty.split("[,]")) {
            List mulBaseBataIdList;
            Comparable<Long> obj;
            DynamicProperty property = adjPersonEntity.getProperty(colName);
            Long contrastCfgSetId = comparaConCfg.get(colName);
            if (property instanceof BasedataProp) {
                obj = (Long)conPropValMap.get(contrastCfgSetId);
                if (obj == null) continue;
                personObj.set(colName, (Object)obj);
                continue;
            }
            if (property instanceof DateProp) {
                obj = (Date)conPropValMap.get(contrastCfgSetId);
                if (obj == null) continue;
                personObj.set(colName, (Object)obj);
                continue;
            }
            if (!(property instanceof MulBasedataProp) || CollectionUtils.isEmpty((Collection)(mulBaseBataIdList = (List)conPropValMap.get(contrastCfgSetId))) || !colName.equals("schooltype")) continue;
            DynamicObjectCollection multiBaseDataDyColl = personObj.getDynamicObjectCollection("schooltype");
            for (Long multiBaseData : mulBaseBataIdList) {
                DynamicObject newMultiBaseData = new DynamicObject(multiBaseDataDyColl.getDynamicObjectType());
                newMultiBaseData.set("fbasedataid", (Object)multiBaseData);
                multiBaseDataDyColl.add((Object)newMultiBaseData);
                logger.info("schooltype id:{}", (Object)multiBaseData);
            }
            personObj.set("schooltype", (Object)multiBaseDataDyColl);
        }
    }

    private static void assembleAdjPersonEntry(DynamicObject personObj, AdjBillEntryImpConfig conf, List<Map<Integer, String>> dataRows, Map<String, Map<String, List<DynamicObject>>> baseDataMap, Map<String, Integer> colKeyIndexMap, Map<Long, DynamicObject> stdTableDynMap, Map<Long, DynamicObject> coefficientMap, DataEntityPropertyCollection propertyCollection) {
        String salaryadjrsnType = (String)conf.getParam().get("salaryadjrsnType");
        DynamicObjectCollection personEntryCollect = personObj.getDynamicObjectCollection("entryentity");
        Integer standardItemIndex = colKeyIndexMap.get(DecAdjApprCreateGridHelper.buildKey((String)"standarditem"));
        Map<String, List<DynamicObject>> itemDataMap = baseDataMap.get(DecAdjApprCreateGridHelper.buildKey((String)"standarditem"));
        Map<Long, SalaryStdMatchResultNew> matchMap = conf.getStdTableMatchResult().get(personObj.getLong("adjfile.id"));
        int entryNewIds = 0;
        long startTime = System.currentTimeMillis();
        long[] entryIds = ID.genLongIds((int)dataRows.size());
        logger.info(" ID.genLongIds(dataRows.size()) entry use time:{}", (Object)(System.currentTimeMillis() - startTime));
        long beginTime = System.currentTimeMillis();
        Date maxBsled = SWCDateTimeUtils.getMaxBsled();
        for (Map<Integer, String> row : dataRows) {
            Map rangeData;
            String standardItem = row.get(standardItemIndex);
            DynamicObject excelItem = itemDataMap.get(standardItem).get(0);
            DynamicObject entryObj = AdjBillEntryBizHelper.getMatchItem(excelItem, personEntryCollect);
            if (entryObj == null) {
                entryObj = adjPersonService.generateEmptyEntryDynamicObject("entryentity");
                entryObj.set("standarditem", (Object)excelItem);
                entryObj.set("id", (Object)entryIds[entryNewIds++]);
                personEntryCollect.add((Object)entryObj);
            }
            conf.getEntryPkValueToExcelRowIndex().put(entryObj.getLong("id"), AdjBillEntryBizHelper.getOriExelRowNumber(row));
            SalaryStdMatchResultNew ssmr = matchMap.get(excelItem.getLong("id"));
            Long stdTableVid = ssmr.getStdTableVid();
            Long coefficientVid = ssmr.getCoefficientVid();
            if (stdTableVid != null && stdTableVid != 0L) {
                entryObj.set("salarystd", (Object)stdTableVid);
                if (MapUtils.isNotEmpty(stdTableDynMap) && ObjectUtils.isNotEmpty((Object)stdTableDynMap.get(stdTableVid))) {
                    entryObj.set("salarystd", (Object)stdTableDynMap.get(stdTableVid));
                }
            }
            if (coefficientVid != null && coefficientVid != 0L) {
                entryObj.set("coefficient", (Object)coefficientVid);
                if (MapUtils.isNotEmpty(coefficientMap) && ObjectUtils.isNotEmpty((Object)coefficientMap.get(coefficientVid))) {
                    entryObj.set("coefficient", (Object)coefficientMap.get(coefficientVid));
                }
            }
            if (MapUtils.isNotEmpty((Map)(rangeData = ssmr.getRangeData()))) {
                String jsonRangeData = JSON.toJSONString((Object)rangeData);
                entryObj.set("salargrel", (Object)jsonRangeData);
                logger.info("salargrel rangeResultData is:{}", (Object)jsonRangeData);
            }
            startTime = System.currentTimeMillis();
            AdjBillEntryBizHelper.setEntryData(entryObj, conf, row, colKeyIndexMap, baseDataMap, propertyCollection);
            if (entryObj.getDate("salbsled") == null) {
                entryObj.set("salbsled", (Object)maxBsled);
            }
            logger.info("setEntryData for use time:{}", (Object)(System.currentTimeMillis() - startTime));
            if (AdjAttributionType.DECATTRTYPE.getCode().equals(salaryadjrsnType)) {
                if (!MapUtils.isNotEmpty(stdTableDynMap) || !ObjectUtils.isNotEmpty((Object)stdTableDynMap.get(stdTableVid))) continue;
                entryObj.set("frequency", stdTableDynMap.get(stdTableVid).get("frequency"));
                continue;
            }
            if (!AdjAttributionType.ADJATTRTYPE.getCode().equals(salaryadjrsnType) || !ObjectUtils.isEmpty((Object)entryObj.get("frequency")) || !MapUtils.isNotEmpty(stdTableDynMap) || !ObjectUtils.isNotEmpty((Object)stdTableDynMap.get(stdTableVid))) continue;
            entryObj.set("frequency", stdTableDynMap.get(stdTableVid).get("frequency"));
        }
        logger.info("assembleAdjPersonEntry for use time:{}", (Object)(System.currentTimeMillis() - beginTime));
        personObj.set("entryentity", (Object)personEntryCollect);
    }

    private static void setEntryData(DynamicObject entryObj, AdjBillEntryImpConfig conf, Map<Integer, String> row, Map<String, Integer> colKeyIndexMap, Map<String, Map<String, List<DynamicObject>>> baseDataMap, DataEntityPropertyCollection propertyCollection) {
        DataEntityPropertyCollection properties = entryObj.getDataEntityType().getProperties();
        Map<String, Object> gradeRankMap = conf.getGradeRankMap().get(AdjBillEntryBizHelper.getOriExelRowNumber(row));
        for (Map.Entry<String, Integer> entry : colKeyIndexMap.entrySet()) {
            String temKey = entry.getKey();
            Integer integer = entry.getValue();
            String col = temKey.split("_")[1];
            if (ObjectUtils.isEmpty((Object)integer) || !properties.containsKey((Object)col)) continue;
            Object value = row.get(integer);
            logger.info("addOrUpdateEntryData value:{}", value);
            DynamicProperty property = (DynamicProperty)propertyCollection.get((Object)temKey);
            if (property != null && ObjectUtils.isNotEmpty((Object)value)) {
                Map<String, String> comboMap;
                Map<String, List<DynamicObject>> dataMap;
                if ((property instanceof BasedataProp || property instanceof MulBasedataProp) && MapUtils.isNotEmpty(dataMap = baseDataMap.get(temKey)) && ObjectUtils.isNotEmpty(dataMap.get(value))) {
                    value = dataMap.get(value).get(0);
                }
                if (property instanceof DecimalProp) {
                    BigDecimal tempValue = new BigDecimal((String)value);
                    DecimalProp tempDecimalProp = (DecimalProp)property;
                    int scale = tempDecimalProp.getScale();
                    value = tempValue.setScale(scale, tempDecimalProp.getRoundingMode()).toPlainString();
                }
                if (property instanceof DateProp) {
                    SimpleDateFormat sdf = (SimpleDateFormat)((DateProp)property).getDateFormat();
                    sdf.setTimeZone(KDDateUtils.getTimeZone());
                    try {
                        value = sdf.parse((String)value);
                    }
                    catch (ParseException ex) {
                        logger.error("AdjBillEntryBizHelper.setEntryData cellVal is{},Exception:{}", value, (Object)ex.getMessage());
                    }
                }
                if (property instanceof ComboProp && !SWCObjectUtils.isEmpty(comboMap = AdjBillEntryBizHelper.getComboMap((ComboProp)property))) {
                    value = comboMap.get(value);
                }
            }
            if (gradeAndRank.contains(temKey)) {
                value = MapUtils.isNotEmpty(gradeRankMap) ? (ObjectUtils.isNotEmpty((Object)gradeRankMap.get(value)) ? gradeRankMap.get(value) : null) : null;
            }
            if (ObjectUtils.isNotEmpty((Object)value)) {
                entryObj.set(col, value);
            }
            if (!col.equals("amount")) continue;
            entryObj.set(col, value);
        }
    }

    private static Map<String, String> getComboMap(ComboProp property) {
        List comboItems = property.getComboItems();
        Map<String, String> nameToValue = new HashMap<String, String>(16);
        if (CollectionUtils.isNotEmpty((Collection)comboItems)) {
            nameToValue = comboItems.stream().collect(Collectors.toMap(key -> key.getName().getLocaleValue(), ValueMapItem::getValue, (o1, o2) -> o2));
        }
        return nameToValue;
    }

    private static DynamicObject getMatchItem(DynamicObject excelItem, DynamicObjectCollection personEntryCollect) {
        if (ObjectUtils.isEmpty((Object)personEntryCollect)) {
            return null;
        }
        return personEntryCollect.stream().filter(obj -> obj.getLong("standarditem.id") == excelItem.getLong("id")).findFirst().orElse(null);
    }

    public static Map<String, List<Map<Integer, String>>> groupByAdjFileNumber(List<Map<Integer, String>> dataRow, Map<String, Integer> colKeyIndexMap, ProgressHandler handler) {
        Integer adjFileIndex = colKeyIndexMap.get(DecAdjApprCreateGridHelper.buildKey((String)"adjfile"));
        HashMap<String, List<Map<Integer, String>>> personGroups = new HashMap<String, List<Map<Integer, String>>>(dataRow.size());
        for (int i = 0; i < dataRow.size(); ++i) {
            Map<Integer, String> row = dataRow.get(i);
            Integer rowNumber = AdjBillEntryBizHelper.getOriExelRowNumber(row);
            if (handler.getLogCache().containsKey(rowNumber)) continue;
            String key = row.get(adjFileIndex);
            List temList = personGroups.computeIfAbsent(key, val -> Lists.newArrayListWithExpectedSize((int)10));
            temList.add(row);
        }
        return personGroups;
    }

    private static Map<String, Map<String, List<DynamicObject>>> loadBaseDataWithPermission(Map<Integer, String> colKeyIndexMap, List<Map<Integer, String>> dataRow, DataEntityPropertyCollection propertyCollection, Map<String, IPermissionHandler> permissionHandlerMap) {
        HashMap<String, Map<String, List<DynamicObject>>> map = new HashMap<String, Map<String, List<DynamicObject>>>();
        for (Map.Entry<Integer, String> entry : colKeyIndexMap.entrySet()) {
            BasedataProp basedataProp;
            int colIndex = entry.getKey();
            String propName = entry.getValue();
            DynamicProperty property = (DynamicProperty)propertyCollection.get((Object)propName);
            if (gradeAndRank.contains(propName) || !(property instanceof BasedataProp) && !(property instanceof MulBasedataProp)) continue;
            String baseEntityId = "";
            StringHolder displayProp = new StringHolder();
            HashSet values = new HashSet();
            HashSet<String> refProperties = new HashSet<String>();
            if (property instanceof BasedataProp) {
                basedataProp = (BasedataProp)property;
                baseEntityId = basedataProp.getBaseEntityId();
                displayProp.value = basedataProp.getDispProp().getName();
                DataEntityPropertyCollection properties = basedataProp.getDynamicComplexPropertyType().getProperties();
                for (IDataEntityProperty dataEntityProperty : properties) {
                    refProperties.add(dataEntityProperty.getName());
                }
                dataRow.stream().filter(stringMap -> StringUtils.isNotEmpty((CharSequence)((CharSequence)stringMap.get(colIndex)))).forEach(map1 -> values.add(map1.get(colIndex)));
            }
            if (property instanceof MulBasedataProp) {
                basedataProp = (MulBasedataProp)property;
                dataRow.stream().filter(map1 -> StringUtils.isNotEmpty((CharSequence)((CharSequence)map1.get(colIndex)))).forEach(stringMap -> values.addAll(Arrays.asList(((String)stringMap.get(colIndex)).split(";"))));
                baseEntityId = basedataProp.getBaseEntityId();
                displayProp.value = basedataProp.getDisplayProp();
            }
            if (StringUtils.isEmpty((CharSequence)baseEntityId) || StringUtils.isEmpty((CharSequence)displayProp.value) || values.isEmpty()) {
                map.put(propName, Maps.newHashMap());
                continue;
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
            QFilter valueFilter = new QFilter(displayProp.value, "in", values);
            Object[] allFilter = new QFilter[]{valueFilter};
            IPermissionHandler permissionHandler = permissionHandlerMap.get(propName);
            if (permissionHandler != null) {
                Object[] permissionFilter = permissionHandler.getPermissionFilter();
                allFilter = (QFilter[])ArrayUtils.addAll((Object[])permissionFilter, (Object[])allFilter);
            }
            if (dataEntityType.getProperty("iscurrentversion") != null) {
                allFilter = (QFilter[])ArrayUtils.addAll((Object[])allFilter, (Object[])new QFilter[]{new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE)});
            }
            if (baseEntityId.equals("hsbs_standarditem")) {
                allFilter = (QFilter[])ArrayUtils.addAll((Object[])allFilter, (Object[])new QFilter[]{new QFilter("biztype", "!=", (Object)"3")});
            }
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(baseEntityId);
            String refProperty = SWCListUtils.join(refProperties, (String)",");
            Object[] objects = serviceHelper.query("id," + refProperty + displayProp, (QFilter[])allFilter);
            if (!ArrayUtils.isNotEmpty((Object[])objects)) continue;
            Map<String, List<DynamicObject>> groupObjs = Arrays.stream(objects).collect(Collectors.groupingBy(obj -> obj.getString(displayProp.value)));
            map.putIfAbsent(propName, groupObjs);
        }
        return map;
    }

    private static String getBaseDataProp(String propName) {
        if (baseDataNameProp.contains(propName)) {
            return propName + "_name";
        }
        return propName;
    }

    private static void mustInputFieldValidate(String mustCol, Map<Integer, String> colIdMap, Map<String, Integer> colKeyIndexMap, List<Map<Integer, String>> dataRow, Map<String, Map<String, List<DynamicObject>>> baseDataMap, ProgressHandler handler, DataEntityPropertyCollection propertyCollection, Map<Integer, String> colIdToNameMap) {
        String mustInputMsg = ResManager.loadKDString((String)"\u5fc5\u586b\u9879\uff1a", (String)"AdjBillEntryBizHelper_10", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String empNumber = ResManager.loadKDString((String)"\u5de5\u53f7%s\uff1a", (String)"AdjBillEntryBizHelper_300", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String emptyMsg = ResManager.loadKDString((String)"\u672a\u586b\u5199", (String)"AdjBillEntryBizHelper_11", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String notExistOrErrorMsg = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6,\u8bf7\u8c03\u6574\u3002", (String)"AdjBillEntryBizHelper_13", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String dateFormatMsg = ResManager.loadKDString((String)"%s\u683c\u5f0f\u586b\u5199\u6709\u8bef,\u8bf7\u586b\u5199\u6b63\u786e\u7684\u683c\u5f0f\u3002", (String)"AdjBillEntryBizHelper_59", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String notNumberMsg = ResManager.loadKDString((String)"\u51fa\u73b0\u975e\u6570\u503c\u578b\u6570\u636e,\u8bf7\u8c03\u6574\u3002", (String)"AdjBillEntryBizHelper_14", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String maxLenthMsg = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,%2$s]\u3002", (String)"AdjBillEntryBizHelper_15", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String dateRangeMsg = ResManager.loadKDString((String)"{%1$s}\u5bfc\u5165\u5931\u8d25\uff0c\u89e3\u6790\u540e\u7684\u65e5\u671f{%2$s}\u4e0d\u5728\u53ef\u9009\u65e5\u671f{%3$s}~{%4$s}\u5e74\u8303\u56f4\u4e4b\u5185\u3002", (String)"AdjBillEntryBizHelper_73", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        ArrayList mustInputFieldSet = Lists.newArrayList();
        ArrayList valueExistFieldSet = Lists.newArrayList();
        ArrayList illegalFieldSet = Lists.newArrayList();
        ArrayList valueLength = Lists.newArrayList();
        int employeeIndex = colKeyIndexMap.get(DecAdjApprCreateGridHelper.buildKey((String)"number"));
        for (int i = 0; i < dataRow.size(); ++i) {
            Map<Integer, String> row = dataRow.get(i);
            Integer rowNumber = AdjBillEntryBizHelper.getOriExelRowNumber(row);
            String empnum = row.get(employeeIndex);
            mustInputFieldSet.clear();
            valueExistFieldSet.clear();
            illegalFieldSet.clear();
            valueLength.clear();
            for (Map.Entry<Integer, String> col : colIdMap.entrySet()) {
                String celKey = col.getValue();
                String cellVal = row.get(col.getKey());
                String fileName = AdjBillEntryImpHelper.removeAster((String)colIdToNameMap.get(col.getKey()));
                if (gradeAndRank.contains(celKey)) continue;
                if (mustCol.contains(celKey) && StringUtils.isBlank((CharSequence)cellVal)) {
                    mustInputFieldSet.add(fileName);
                    continue;
                }
                DynamicProperty property = (DynamicProperty)propertyCollection.get((Object)celKey);
                if (StringUtils.isBlank((CharSequence)cellVal) || property == null) continue;
                if ((property instanceof BasedataProp || property instanceof MulBasedataProp) && (baseDataMap.get(celKey) == null || baseDataMap.get(celKey).get(cellVal) == null)) {
                    valueExistFieldSet.add(fileName);
                    continue;
                }
                if (property instanceof DecimalProp) {
                    DecimalProp decimalProp = (DecimalProp)property;
                    String dataScope = decimalProp.getDataScope();
                    int precision = decimalProp.getPrecision();
                    int scale = decimalProp.getScale();
                    DecimalConverter converter = new DecimalConverter(dataScope, precision, scale);
                    if (StringUtils.isNotEmpty((CharSequence)cellVal) && !converter.checkType((Object)cellVal).isSuccess()) {
                        illegalFieldSet.add(fileName);
                    } else if (StringUtils.isNotEmpty((CharSequence)cellVal) && !converter.checkVal((Object)cellVal).isSuccess()) {
                        valueLength.add(fileName + converter.checkVal((Object)cellVal).getErrorList());
                    }
                }
                if (property instanceof DateProp) {
                    try {
                        DateProp dateProp = (DateProp)property;
                        DateFormat dateFormat = dateProp.getDateFormat();
                        Date curDate = dateFormat.parse(cellVal);
                        if (!SWCDateTimeUtils.isCover((Date)curDate, (Date)dateFormat.parse("1900-01-01"), (Date)dateFormat.parse("2999-12-31"))) {
                            handler.putRowError(rowNumber, String.format(Locale.ROOT, dateRangeMsg, fileName, SWCDateTimeUtils.format((Date)curDate, (String)"yyyy-MM-dd"), "1900", "2999"));
                        }
                    }
                    catch (Exception ex) {
                        logger.error("AdjBillEntryBizHelper.mustInputFieldValidate cellVal is{},Exception:{}", (Object)cellVal, (Object)ex.getMessage());
                        handler.putRowError(rowNumber, String.format(Locale.ROOT, empNumber, empnum) + String.format(Locale.ROOT, dateFormatMsg, fileName));
                    }
                }
                if (property instanceof ComboProp) {
                    List comboItems = ((ComboProp)property).getComboItems();
                    AdjBillEntryBizHelper.comboIsExist(celKey, cellVal, fileName, row, colKeyIndexMap, comboItems, mustInputFieldSet, valueExistFieldSet, colIdToNameMap);
                }
                if (!(property instanceof TextProp) || !StringUtils.isNotBlank((CharSequence)cellVal)) continue;
                int maxLenth = ((TextProp)property).getMaxLenth();
                if (cellVal.length() <= maxLenth) continue;
                handler.putRowError(rowNumber, String.format(Locale.ROOT, maxLenthMsg, fileName, maxLenth));
            }
            if (!mustInputFieldSet.isEmpty()) {
                handler.putRowError(rowNumber, mustInputMsg + mustInputFieldSet.stream().collect(Collectors.joining("\u3001")) + emptyMsg);
            }
            if (!valueExistFieldSet.isEmpty()) {
                handler.putRowError(rowNumber, valueExistFieldSet.stream().collect(Collectors.joining("\u3001")) + notExistOrErrorMsg);
            }
            if (!illegalFieldSet.isEmpty()) {
                handler.putRowError(rowNumber, illegalFieldSet.stream().collect(Collectors.joining("\u3001")) + notNumberMsg);
            }
            if (valueLength.isEmpty()) continue;
            handler.putRowError(rowNumber, valueLength.stream().collect(Collectors.joining("\u3001")) + notNumberMsg);
        }
    }

    private static void comboIsExist(String celKey, String cellVal, String fileName, Map<Integer, String> row, Map<String, Integer> colKeyIndexMap, List<ValueMapItem> comboItems, ArrayList<String> mustInputFieldSet, ArrayList<String> valueExistFieldSet, Map<Integer, String> colIdToNameMap) {
        Map<String, String> nameToValue = comboItems.stream().collect(Collectors.toMap(key -> key.getName().getLocaleValue(), ValueMapItem::getValue, (o1, o2) -> o2));
        if (StringUtils.isBlank((CharSequence)nameToValue.get(cellVal))) {
            valueExistFieldSet.add(fileName);
        } else if (celKey.equals("dy_calctype")) {
            String value = nameToValue.get(cellVal);
            if (StringUtils.isNotBlank((CharSequence)value) && value.equals("1")) {
                String excActualrange = row.get(colKeyIndexMap.get("dy_actualrange"));
                if (StringUtils.isBlank((CharSequence)excActualrange)) {
                    int actualrangeIndex = colKeyIndexMap.get(DecAdjApprCreateGridHelper.buildKey((String)"actualrange"));
                    mustInputFieldSet.add(AdjBillEntryImpHelper.removeAster((String)colIdToNameMap.get(actualrangeIndex)));
                }
                row.put(colKeyIndexMap.get("dy_suggestminamount"), null);
                row.put(colKeyIndexMap.get("dy_suggestmaxamount"), null);
                row.put(colKeyIndexMap.get("dy_actualamount"), null);
            }
            if (StringUtils.isNotBlank((CharSequence)value) && value.equals("2")) {
                String excActualamount = row.get(colKeyIndexMap.get("dy_actualamount"));
                if (StringUtils.isBlank((CharSequence)excActualamount)) {
                    int actualamountIndex = colKeyIndexMap.get(DecAdjApprCreateGridHelper.buildKey((String)"actualamount"));
                    mustInputFieldSet.add(AdjBillEntryImpHelper.removeAster((String)colIdToNameMap.get(actualamountIndex)));
                }
                row.put(colKeyIndexMap.get("dy_suggestminrange"), null);
                row.put(colKeyIndexMap.get("dy_suggestmaxrange"), null);
                row.put(colKeyIndexMap.get("dy_actualrange"), null);
            }
        }
    }

    public static void importAdjfileValidate(String salaryadjrsnType, Map<String, Integer> colKeyIndexMap, List<Map<Integer, String>> dataRow, Map<String, Map<String, List<DynamicObject>>> baseDataMap, ProgressHandler handler, Long orgId, String orgName, QFilter[] adjFilePermFilter) {
        String keyNumber = DecAdjApprCreateGridHelper.buildKey((String)"number");
        int employeeIndex = colKeyIndexMap.get(keyNumber);
        String keyAdjFile = DecAdjApprCreateGridHelper.buildKey((String)"adjfile");
        Map<String, List<DynamicObject>> baseAdjFileMap = baseDataMap.get(keyAdjFile);
        Integer adjFileIndex = colKeyIndexMap.get(keyAdjFile);
        HashSet employeeNumbers = new HashSet();
        dataRow.stream().filter(data -> StringUtils.isNotEmpty((CharSequence)((CharSequence)data.get(employeeIndex)))).forEach(obj -> employeeNumbers.add(obj.get(employeeIndex)));
        long startTime = System.currentTimeMillis();
        DynamicObject[] employeeDyns = AdjBillEntryImpHelper.getEmployeeByEmpnumber(employeeNumbers);
        logger.info("AdjBillEntryImpHelper.getEmployeeByEmpnumber use time:{}", (Object)(System.currentTimeMillis() - startTime));
        Map<String, List<DynamicObject>> employeeMap = Arrays.stream(employeeDyns).collect(Collectors.groupingBy(obj -> obj.getString("empnumber")));
        Set employeeIds = Arrays.stream(employeeDyns).map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        startTime = System.currentTimeMillis();
        DynamicObject[] adjFileLists = AdjBillEntryImpHelper.getAdjFileList((Long)orgId, employeeIds, null);
        Map<String, List<DynamicObject>> selectAdjFileMap = Arrays.stream(adjFileLists).collect(Collectors.groupingBy(adjFile -> adjFile.getString("employee.empnumber")));
        logger.info("AdjBillEntryImpHelper.getAdjFileList use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        DynamicObject[] adjFileAuthorList = ArrayUtils.isNotEmpty((Object[])adjFilePermFilter) ? AdjBillEntryImpHelper.getAdjFileList((Long)orgId, employeeIds, (QFilter[])adjFilePermFilter) : adjFileLists;
        Map<String, List<DynamicObject>> selectAdjFileAuthorMap = Arrays.stream(adjFileAuthorList).collect(Collectors.groupingBy(adjFile -> adjFile.getString("employee.empnumber")));
        logger.info("AdjBillEntryImpHelper.getAdjFileList by Author use time:{}", (Object)(System.currentTimeMillis() - startTime));
        String noFilePermMsg = ResManager.loadKDString((String)"\u65e0\u59d3\u540d%1$s\uff1a\u5de5\u53f7\u3010%2$s\u3011\u7684\u64cd\u4f5c\u6743\u9650\u3002", (String)"AdjBillEntryBizHelper_20", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String employeeNotExistMsg = ResManager.loadKDString((String)"\u5de5\u53f7%s\uff1a\u8be5\u4eba\u5458\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjBillEntryBizHelper_21", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String empNumNotIdentMsg = ResManager.loadKDString((String)"\u5de5\u53f7%1$s\uff1a%2$s\u7684\u5b9a\u8c03\u85aa\u6863\u6848\u7f16\u53f7\u586b\u5199\u4e0d\u6b63\u786e\uff0c\u8bf7\u786e\u8ba4\u5e76\u8c03\u6574\u3002", (String)"AdjBillEntryBizHelper_22", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String fileStatusErrorMsg = ResManager.loadKDString((String)"\u5de5\u53f7%1$s\uff1a\u5b9a\u8c03\u85aa\u6863\u6848\u72b6\u6001\u4e3a%2$s\uff0c\u53ea\u6709\u5b9a\u8c03\u85aa\u6863\u6848\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AdjBillEntryBizHelper_23", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String fixMultiFileErrorMsg = ResManager.loadKDString((String)"\u5de5\u53f7%1$s\uff1a%2$s\u5728\u7cfb\u7edf\u4e2d\u5b58\u5728\u591a\u4efd\u5b9a\u8c03\u85aa\u6863\u6848\uff0c\u82e5\u9700\u5b9a\u85aa\uff0c\u8bf7\u586b\u5199\u6863\u6848\u7f16\u53f7\u3002", (String)"AdjBillEntryBizHelper_24", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String adjMultiFileErrorMsg = ResManager.loadKDString((String)"\u5de5\u53f7%1$s\uff1a%2$s\u5728\u7cfb\u7edf\u4e2d\u5b58\u5728\u591a\u4efd\u5b9a\u8c03\u85aa\u6863\u6848\uff0c\u82e5\u9700\u8c03\u85aa\uff0c\u8bf7\u586b\u5199\u6863\u6848\u7f16\u53f7\u3002", (String)"AdjBillEntryBizHelper_49", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String orgNoEqualErrorMsg = ResManager.loadKDString((String)"\u5de5\u53f7%1$s\uff1a\u8be5\u4eba\u5458\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u5c5e\u4e8e%2$s\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7,\u8bf7\u786e\u8ba4\u5e76\u8c03\u6574\u3002", (String)"AdjBillEntryBizHelper_61", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        startTime = System.currentTimeMillis();
        for (int i = 0; i < dataRow.size(); ++i) {
            Long comOrgId;
            String personName;
            Map<Integer, String> row = dataRow.get(i);
            Integer rowNumber = AdjBillEntryBizHelper.getOriExelRowNumber(row);
            if (handler.getLogCache().containsKey(rowNumber)) continue;
            String employeeNumber = row.get(employeeIndex);
            String adjFileNumber = row.get(adjFileIndex);
            logger.info("import adjFileNumber is: {},employeeNumber is: {}", (Object)adjFileNumber, (Object)employeeNumber);
            List<DynamicObject> employeeInfo = employeeMap.get(employeeNumber);
            List<DynamicObject> adjFileAuthorInfo = selectAdjFileAuthorMap.get(employeeNumber);
            List<DynamicObject> adjFileInfo = selectAdjFileMap.get(employeeNumber);
            if (CollectionUtils.isEmpty(employeeInfo) || CollectionUtils.isEmpty(adjFileInfo)) {
                handler.putRowError(rowNumber, String.format(Locale.ROOT, employeeNotExistMsg, employeeNumber));
                continue;
            }
            if (CollectionUtils.isNotEmpty(adjFileInfo) && CollectionUtils.isEmpty(adjFileAuthorInfo)) {
                personName = adjFileInfo.get(0).getString("person.name");
                handler.putRowError(rowNumber, String.format(Locale.ROOT, noFilePermMsg, personName, employeeNumber));
                continue;
            }
            personName = employeeInfo.get(0).getString("person.name");
            Set adjFileNumberList = adjFileAuthorInfo.stream().filter(obj -> obj.getBoolean("iscurrentversion") && obj.getString("status").equals("C")).map(obj -> obj.getString("number")).collect(Collectors.toSet());
            logger.info("import employee has adjFileAuthorInfo is: {}", (Object)JSON.toJSONString(adjFileNumberList));
            DynamicObject curObj = adjFileAuthorInfo.stream().filter(obj -> obj.getBoolean("iscurrentversion") && obj.getString("status").equals("C")).findFirst().orElse(null);
            if (curObj == null) {
                handler.putRowError(rowNumber, String.format(Locale.ROOT, fileStatusErrorMsg, employeeNumber, AdjFileStatusEnum.getDisplayNameByCode((String)adjFileAuthorInfo.get(0).getString("status"))));
                continue;
            }
            if (StringUtils.isNotEmpty((CharSequence)adjFileNumber)) {
                if (CollectionUtils.isEmpty((Collection)baseAdjFileMap.get(adjFileNumber))) {
                    handler.putRowError(rowNumber, ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7\uff1a\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6,\u8bf7\u8c03\u6574\u3002", (String)"AdjBillEntryImpTask_5", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                    continue;
                }
                String status = baseAdjFileMap.get(adjFileNumber).get(0).getString("status");
                if (!status.equals("C")) {
                    handler.putRowError(rowNumber, String.format(Locale.ROOT, fileStatusErrorMsg, employeeNumber, AdjFileStatusEnum.getDisplayNameByCode((String)status)));
                    continue;
                }
            }
            if (adjFileNumberList.size() == 1) {
                if (StringUtils.isNotEmpty((CharSequence)adjFileNumber) && !adjFileNumberList.contains(adjFileNumber)) {
                    handler.putRowError(rowNumber, String.format(Locale.ROOT, empNumNotIdentMsg, employeeNumber, personName));
                    continue;
                }
                String number = curObj.getString("number");
                row.put(adjFileIndex, number);
                baseAdjFileMap.put(number, Collections.singletonList(curObj));
            } else {
                if (StringUtils.isEmpty((CharSequence)adjFileNumber)) {
                    String msg = String.format(Locale.ROOT, fixMultiFileErrorMsg, employeeNumber, personName);
                    if (AdjAttributionType.ADJATTRTYPE.getCode().equals(salaryadjrsnType)) {
                        msg = String.format(Locale.ROOT, adjMultiFileErrorMsg, employeeNumber, personName);
                    }
                    handler.putRowError(rowNumber, msg);
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)adjFileNumber) && !adjFileNumberList.contains(adjFileNumber)) {
                    handler.putRowError(rowNumber, String.format(Locale.ROOT, empNumNotIdentMsg, employeeNumber, personName));
                    continue;
                }
            }
            String confirmFileNum = row.get(adjFileIndex);
            if (!CollectionUtils.isNotEmpty((Collection)baseAdjFileMap.get(confirmFileNum)) || (comOrgId = Long.valueOf(baseAdjFileMap.get(confirmFileNum).get(0).getLong("org.id"))) == null || comOrgId.equals(orgId)) continue;
            handler.putRowError(rowNumber, String.format(Locale.ROOT, orgNoEqualErrorMsg, employeeNumber, orgName));
        }
        logger.info("importAdjfileValidate for use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        AdjBillEntryBizHelper.certValidate(dataRow, handler, baseAdjFileMap, adjFileIndex);
        logger.info("certValidate use time:{}", (Object)(System.currentTimeMillis() - startTime));
    }

    private static void certValidate(List<Map<Integer, String>> dataRow, ProgressHandler handler, Map<String, List<DynamicObject>> baseAdjFileMap, Integer adjFileIndex) {
        ArrayList<Long> fileIds = new ArrayList<Long>(baseAdjFileMap.size());
        for (int index = 0; index < dataRow.size(); ++index) {
            Integer rowNumber = AdjBillEntryBizHelper.getOriExelRowNumber(dataRow.get(index));
            if (handler.getLogCache().containsKey(rowNumber)) continue;
            String fileNumber = dataRow.get(index).get(adjFileIndex);
            List<DynamicObject> files = baseAdjFileMap.get(fileNumber);
            for (DynamicObject file : files) {
                fileIds.add(file.getLong("id"));
            }
        }
        String certErr = AdjFileCertCommonHelper.verifyExistFile(fileIds);
        if (certErr != null) {
            for (int index = 0; index < dataRow.size(); ++index) {
                Integer rowNumber = AdjBillEntryBizHelper.getOriExelRowNumber(dataRow.get(index));
                if (handler.getLogCache().containsKey(rowNumber) || certErr == null) continue;
                handler.putRowError(rowNumber, certErr);
            }
        }
    }

    private static void repeatDataValidate(String salaryadjrsnType, Map<String, Integer> colKeyIndexMap, List<Map<Integer, String>> dataRow, ProgressHandler handler) {
        HashMap allRowKey = Maps.newHashMapWithExpectedSize((int)dataRow.size());
        HashMap firstRowKey = Maps.newHashMapWithExpectedSize((int)dataRow.size());
        String repeatMsg = AdjAttributionType.DECATTRTYPE.getCode().equals(salaryadjrsnType) ? ResManager.loadKDString((String)"\u5de5\u53f7%1$s\uff1a\u5b9a\u85aa\u4fe1\u606f\u4e0e\u7b2c%2$s\u884c\u91cd\u590d\uff0c\u540c\u4e00\u4e2a\u5b9a\u8c03\u85aa\u6863\u6848\u4e2d\uff0c\u4e0d\u5141\u8bb8\u51fa\u73b0\u91cd\u590d\u7684\u5b9a\u8c03\u85aa\u9879\u76ee\u3002", (String)"AdjBillEntryBizHelper_25", (String)"swc-hcdm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5de5\u53f7%1$s\uff1a\u8c03\u85aa\u4fe1\u606f\u4e0e\u7b2c%2$s\u884c\u91cd\u590d\uff0c\u540c\u4e00\u4e2a\u5b9a\u8c03\u85aa\u6863\u6848\u4e2d\uff0c\u4e0d\u5141\u8bb8\u51fa\u73b0\u91cd\u590d\u7684\u5b9a\u8c03\u85aa\u9879\u76ee\u3002", (String)"AdjBillEntryBizHelper_51", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String allColRepeatMsg = AdjAttributionType.DECATTRTYPE.getCode().equals(salaryadjrsnType) ? ResManager.loadKDString((String)"\u5de5\u53f7%1$s\uff1a\u5b9a\u85aa\u4fe1\u606f\u4e0e\u7b2c%2$s\u884c\u91cd\u590d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjBillEntryBizHelper_26", (String)"swc-hcdm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5de5\u53f7%1$s\uff1a\u8c03\u85aa\u4fe1\u606f\u4e0e\u7b2c%2$s\u884c\u91cd\u590d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjBillEntryBizHelper_52", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        Integer adjFileIndex = colKeyIndexMap.get(DecAdjApprCreateGridHelper.buildKey((String)"adjfile"));
        Integer employeeIndex = colKeyIndexMap.get(DecAdjApprCreateGridHelper.buildKey((String)"number"));
        Integer standardItemIndex = colKeyIndexMap.get(DecAdjApprCreateGridHelper.buildKey((String)"standarditem"));
        for (int i = 0; i < dataRow.size(); ++i) {
            Map<Integer, String> row = dataRow.get(i);
            Integer rowNumber = AdjBillEntryBizHelper.getOriExelRowNumber(row);
            if (handler.getLogCache().containsKey(rowNumber)) continue;
            String employeeNumber = row.get(employeeIndex);
            String adjFileNumber = row.get(adjFileIndex);
            String standardItem = row.get(standardItemIndex);
            String colKey = row.values().stream().filter(obj -> StringUtils.isNotBlank((CharSequence)obj)).collect(Collectors.joining("_"));
            if (allRowKey.get(colKey) != null) {
                handler.putRowError(rowNumber, String.format(Locale.ROOT, allColRepeatMsg, employeeNumber, allRowKey.get(colKey)));
                continue;
            }
            allRowKey.put(colKey, rowNumber + 1);
            if (StringUtils.isBlank((CharSequence)adjFileNumber)) continue;
            String key = adjFileNumber + "_" + standardItem;
            if (firstRowKey.get(key) != null) {
                handler.putRowError(rowNumber, String.format(Locale.ROOT, repeatMsg, employeeNumber, firstRowKey.get(key)));
                continue;
            }
            firstRowKey.put(key, rowNumber + 1);
        }
    }

    private static void stdTableValidate(String salaryadjrsnType, boolean isGradeRankValidate, Map<String, Integer> colKeyIndexMap, List<Map<Integer, String>> dataRow, Map<String, Map<String, List<DynamicObject>>> baseDataMap, Map<Integer, String> indexToStructNameMap, AdjBillEntryImpConfig conf, DataEntityPropertyCollection propertyCollection, Map<Long, Map<Long, DynamicObject>> itemEntryDataOfPage) {
        String twoMatchOneMsg = ResManager.loadKDString((String)"\u5de5\u53f7%1$s\uff1a\u85aa\u7b49\u85aa\u6863\u4e0d\u5728\u3010%2$s\u85aa\u916c\u7ed3\u6784\u3011\u5339\u914d\u7684\u3010%3$s\u85aa\u916c\u6807\u51c6\u8868\u3011\u85aa\u7b49\u85aa\u6863\uff1a%4$s\u8303\u56f4\u5185\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjBillEntryBizHelper_27", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String itemNoBelogToTable = ResManager.loadKDString((String)"\u5de5\u53f7%s\uff1a\u5b9a\u8c03\u85aa\u9879\u76ee\u4e0d\u5b58\u5728\u6240\u5c5e\u7684\u6807\u51c6\u8868\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjBillEntryBizHelper_34", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String gradeMustInputMsg = ResManager.loadKDString((String)"\u5fc5\u586b\u9879\uff1a\u85aa\u7b49\u672a\u586b\u5199\u3002", (String)"AdjBillEntryBizHelper_35", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String rankMustInputMsg = ResManager.loadKDString((String)"\u5fc5\u586b\u9879\uff1a\u85aa\u6863\u672a\u586b\u5199\u3002", (String)"AdjBillEntryBizHelper_36", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String noMatchTable = ResManager.loadKDString((String)"\u5de5\u53f7%s\uff1a\u672a\u5339\u914d\u5230\u7b26\u5408\u6761\u4ef6\u7684\u85aa\u916c\u6807\u51c6\u8868,\u8bf7\u6838\u5b9e\u540e\u518d\u6dfb\u52a0\u3002", (String)"AdjBillEntryBizHelper_48", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String itemNoBelogToStruct = ResManager.loadKDString((String)"\u5de5\u53f7%1$s\uff1a\u5b9a\u8c03\u85aa\u9879\u76ee\u4e0d\u5c5e\u4e8e\u8be5\u4eba\u5458\u6863\u6848\u3010%2$s\u85aa\u916c\u7ed3\u6784\u3011\u4e2d\u7684\u5b9a\u8c03\u85aa\u9879\u76ee\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjBillEntryBizHelper_42", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String noStdscmInbsed = ResManager.loadKDString((String)"\u5de5\u53f7%s\uff1a\u751f\u6548\u65e5\u671f\u4e0b\u6ca1\u6709\u53ef\u7528\u7684\u85aa\u916c\u4f53\u7cfb\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AdjBillEntryBizHelper_69", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String stdTableUnused = ResManager.loadKDString((String)"\u5de5\u53f7%s\uff1a\u751f\u6548\u65e5\u671f\u4e0b\u6ca1\u6709\u53ef\u7528\u7684\u85aa\u916c\u6807\u51c6\u8868\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AdjBillEntryBizHelper_70", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String requencyMustInputMsg = ResManager.loadKDString((String)"\u5fc5\u586b\u9879\uff1a\u9891\u5ea6\u672a\u586b\u5199\u3002", (String)"AdjBillEntryBizHelper_41", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String noFindRank = ResManager.loadKDString((String)"\u5de5\u53f7%1$s\uff1a\u6240\u4f7f\u7528\u7684%2$s\u6807\u51c6\u8868\u672a\u542f\u7528\u85aa\u6863\uff0c\u5bfc\u5165\u6a21\u677f\u4e2d\u65e0\u9700\u586b\u5199\u85aa\u6863\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjBillEntryBizHelper_72", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String noStandardItemMsg = ResManager.loadKDString((String)"\u5458\u5de5\u5f53\u524d\u5b9a\u8c03\u85aa\u9879\u76ee\uff08%s\uff09\u6ca1\u6709\u53ef\u7528\u85aa\u7b49\u3001\u85aa\u6863\uff0c\u8bf7\u586b\u5199\u91d1\u989d\u3002", (String)"AdjBillEntryBizHelper_62", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String gradeAndRankMustInputMsg = ResManager.loadKDString((String)"\u5fc5\u586b\u9879\uff1a\u85aa\u7b49\u3001\u85aa\u6863\u672a\u586b\u5199\u3002", (String)"AdjBillEntryBizHelper_63", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String isShowGrankAndRank = ResManager.loadKDString((String)"\u5de5\u53f7%1$s\uff1a\u8be5\u4eba\u5458\u6240\u5c5e\u3010%2$s\u85aa\u916c\u4f53\u7cfb\u3011\u662f\u5426\u663e\u793a\u85aa\u7b49\u85aa\u6863\u4e3a\u5426\uff0c\u65e0\u9700\u586b\u5199\u85aa\u7b49\u3001\u85aa\u6863\u3002", (String)"AdjBillEntryBizHelper_64", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String actualRangeMsg = ResManager.loadKDString((String)"\u5fc5\u586b\u9879\uff1a\u5b9e\u9645\u8c03\u5e45\uff08%\uff09\u672a\u586b\u5199\u3002", (String)"AdjBillEntryBizHelper_65", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String actualAmountMsg = ResManager.loadKDString((String)"\u5fc5\u586b\u9879\uff1a\u5b9e\u9645\u8c03\u5e45\uff08\u91d1\u989d\uff09\u672a\u586b\u5199\u3002", (String)"AdjBillEntryBizHelper_66", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String noMatchFrequency = ResManager.loadKDString((String)"\u5de5\u53f7%1$s\uff1a\u9891\u5ea6\u4e0e\u85aa\u916c\u6807\u51c6\u8868\u4e2d\u9891\u5ea6\u4e0d\u4e00\u81f4\uff08\u85aa\u916c\u6807\u51c6\u8868\u9891\u5ea6\uff1a%2$s\uff09\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjBillEntryBizHelper_68", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        HashMap gradeRankMap = Maps.newHashMapWithExpectedSize((int)dataRow.size());
        conf.setGradeRankMap(gradeRankMap);
        String adjFileKey = DecAdjApprCreateGridHelper.buildKey((String)"adjfile");
        String stdItemKey = DecAdjApprCreateGridHelper.buildKey((String)"standarditem");
        String bsedKey = DecAdjApprCreateGridHelper.buildKey((String)"salbsed");
        Map<String, List<DynamicObject>> adjFileDataMap = baseDataMap.get(adjFileKey);
        Map<String, List<DynamicObject>> itemDataMap = baseDataMap.get(stdItemKey);
        HashMap fileToItemMap = Maps.newHashMapWithExpectedSize((int)dataRow.size());
        HashSet matchParams = Sets.newHashSetWithExpectedSize((int)dataRow.size());
        String effectiveDateStr = (String)conf.getParam().get("effectivedate");
        Date billEffectiveDate = null;
        if (StringUtils.isNotBlank((CharSequence)effectiveDateStr)) {
            try {
                billEffectiveDate = SWCDateTimeUtils.parseDate((String)effectiveDateStr, (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                logger.error("parseDate error", (Throwable)e);
            }
        }
        ProgressHandler handler = conf.getHandler();
        Integer salBsedIndex = colKeyIndexMap.get(bsedKey);
        for (int index = 0; index < dataRow.size(); ++index) {
            Map<Integer, String> row = dataRow.get(index);
            Integer rowNumber = AdjBillEntryBizHelper.getOriExelRowNumber(row);
            if (handler.getLogCache().containsKey(rowNumber)) continue;
            String adjFileNumber = row.get(colKeyIndexMap.get(adjFileKey));
            String standardItem = row.get(colKeyIndexMap.get(stdItemKey));
            DynamicObject fileObj = adjFileDataMap.get(adjFileNumber).get(0);
            DynamicObject itemObj = itemDataMap.get(standardItem).get(0);
            DynamicObject entryRowObject = AdjBillEntryBizHelper.getEntryRowObject(fileObj, itemObj, itemEntryDataOfPage);
            Date bsed = AdjBillEntryBizHelper.getDateFromExcelOrPage(row, salBsedIndex, entryRowObject, "salbsed", billEffectiveDate);
            if (fileObj == null || itemObj == null) continue;
            MatchStdTableWithAdjFileParam param = new MatchStdTableWithAdjFileParam();
            matchParams.add(param);
            param.setAdjFileId(Long.valueOf(fileObj.getLong("id")));
            param.setStdItemId(Long.valueOf(itemObj.getLong("id")));
            param.setBsed(bsed);
            Map itemMap = fileToItemMap.computeIfAbsent(fileObj.getLong("id"), val -> Maps.newHashMapWithExpectedSize((int)16));
            itemMap.put(index, itemObj.getLong("id"));
        }
        DynamicProperty property = (DynamicProperty)propertyCollection.get((Object)DecAdjApprCreateGridHelper.buildKey((String)"calctype"));
        Map<Object, Object> comboMap = new HashMap(16);
        if (property instanceof ComboProp) {
            comboMap = AdjBillEntryBizHelper.getComboMap((ComboProp)property);
        }
        if (MapUtils.isNotEmpty((Map)fileToItemMap)) {
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)fileToItemMap.size());
            fileToItemMap.forEach((key, val) -> paramMap.put(key, val.values().stream().collect(Collectors.toList())));
            long startTime = System.currentTimeMillis();
            Map resultMap = AdjBillEntryImpHelper.getMatchStdResult((List)Lists.newArrayList((Iterable)matchParams));
            Map<String, Map<Long, String>> rankAndGradeNameMaps = AdjBillEntryBizHelper.getGradeAndRankById(resultMap);
            logger.info("StdMatchHelper.queryStdMatchResult use time :{}", (Object)(System.currentTimeMillis() - startTime));
            logger.info("StdMatchHelper.queryStdMatchResult() resultMap:{}", (Object)JSON.toJSONString((Object)resultMap));
            if (MapUtils.isNotEmpty((Map)resultMap)) {
                conf.setStdTableMatchResult(resultMap);
                Set stdTableVids = (Set)AdjBillEntryImpHelper.getStdSourceVids((Map)resultMap).get("stdTableVid");
                Map openRankMap = AdjBillEntryImpHelper.getUseRankFlag((Map)resultMap);
                Map stdTableIdToNameMap = AdjBillEntryImpHelper.getStdTableIdToNameMap((Set)stdTableVids);
                Map gradeEntities = GradeRankHelper.queryGradeEntities((Set)stdTableVids);
                Map salaryRankEntities = GradeRankHelper.querySalaryRankEntities((Set)stdTableVids, (boolean)true);
                Map stdTableDynMap = AdjBillEntryImpHelper.getStdTableInfo((Set)stdTableVids);
                conf.setStdTableDynMap(stdTableDynMap);
                for (Map.Entry entry : fileToItemMap.entrySet()) {
                    Long fileId = (Long)entry.getKey();
                    Map values = (Map)entry.getValue();
                    Map matchValues = (Map)resultMap.get(fileId);
                    for (Map.Entry subEntry : values.entrySet()) {
                        Integer rowIndex = (Integer)subEntry.getKey();
                        Long itemId = (Long)subEntry.getValue();
                        SalaryStdMatchResultNew sMatchResult = (SalaryStdMatchResultNew)matchValues.get(itemId);
                        Map<Integer, String> row = dataRow.get(rowIndex);
                        Integer excelRowIndex = AdjBillEntryBizHelper.getOriExelRowNumber(row);
                        String frequency = row.get(colKeyIndexMap.get(DecAdjApprCreateGridHelper.buildKey((String)"frequency")));
                        Long stdTableVid = sMatchResult.getStdTableVid();
                        StdTabNotFoundType stdTabNotFoundType = sMatchResult.getStdTableNotFoundType();
                        String empNumber = row.get(colKeyIndexMap.get(DecAdjApprCreateGridHelper.buildKey((String)"number")));
                        String structName = indexToStructNameMap.get(rowIndex);
                        String isMatchGradeRank = sMatchResult.getIsMatchGradeRank();
                        String excelGrade = row.get(colKeyIndexMap.get(DecAdjApprCreateGridHelper.buildKey((String)"grade")));
                        String excelRank = row.get(colKeyIndexMap.get(DecAdjApprCreateGridHelper.buildKey((String)"rank")));
                        String excelAmount = row.get(colKeyIndexMap.get(DecAdjApprCreateGridHelper.buildKey((String)"amount")));
                        boolean isOpenRank = false;
                        Map itemIsOpMap = (Map)openRankMap.get(stdTableVid);
                        if (MapUtils.isNotEmpty((Map)itemIsOpMap) && itemIsOpMap.get(itemId) != null && ((Boolean)itemIsOpMap.get(itemId)).booleanValue()) {
                            isOpenRank = true;
                        }
                        if (AdjAttributionType.ADJATTRTYPE.getCode().equals(salaryadjrsnType)) {
                            String calType = row.get(colKeyIndexMap.get(DecAdjApprCreateGridHelper.buildKey((String)"calctype")));
                            if (!comboMap.isEmpty() && CalcType.GRADE_RANK.getCode().equals(comboMap.get(calType))) {
                                if (SWCStringUtils.equals((String)"1", (String)isMatchGradeRank)) {
                                    if (StringUtils.isBlank((CharSequence)excelGrade) && StringUtils.isBlank((CharSequence)excelRank)) {
                                        handler.putRowError(excelRowIndex, gradeAndRankMustInputMsg);
                                        continue;
                                    }
                                    if (StringUtils.isBlank((CharSequence)excelGrade)) {
                                        handler.putRowError(excelRowIndex, gradeMustInputMsg);
                                        continue;
                                    }
                                    if (StringUtils.isBlank((CharSequence)excelRank) && isOpenRank) {
                                        handler.putRowError(excelRowIndex, rankMustInputMsg);
                                        continue;
                                    }
                                    isGradeRankValidate = true;
                                } else {
                                    if (StringUtils.isBlank((CharSequence)excelAmount)) {
                                        String excelStandardItem = row.get(colKeyIndexMap.get(DecAdjApprCreateGridHelper.buildKey((String)"standarditem")));
                                        handler.putRowError(excelRowIndex, String.format(Locale.ROOT, noStandardItemMsg, excelStandardItem));
                                        continue;
                                    }
                                    isGradeRankValidate = false;
                                }
                            } else {
                                String excelActualAmount = row.get(colKeyIndexMap.get(DecAdjApprCreateGridHelper.buildKey((String)"actualamount")));
                                String excelActualRang = row.get(colKeyIndexMap.get(DecAdjApprCreateGridHelper.buildKey((String)"actualrange")));
                                if (CalcType.RATIO.getCode().equals(comboMap.get(calType)) && StringUtils.isBlank((CharSequence)excelActualRang)) {
                                    handler.putRowError(excelRowIndex, actualRangeMsg);
                                    continue;
                                }
                                if (CalcType.AMOUNT.getCode().equals(comboMap.get(calType)) && StringUtils.isBlank((CharSequence)excelActualAmount)) {
                                    handler.putRowError(excelRowIndex, actualAmountMsg);
                                    continue;
                                }
                            }
                        }
                        if (isMatchGradeRank != null && (StringUtils.isBlank((CharSequence)isMatchGradeRank) || SWCStringUtils.equals((String)"0", (String)isMatchGradeRank)) && (StringUtils.isNotBlank((CharSequence)excelGrade) || StringUtils.isNotBlank((CharSequence)excelRank))) {
                            String adjFileNumber = row.get(colKeyIndexMap.get(adjFileKey));
                            DynamicObject fileObj = adjFileDataMap.get(adjFileNumber).get(0);
                            String stdscmName = fileObj.getString("stdscm.name");
                            handler.putRowError(excelRowIndex, String.format(Locale.ROOT, isShowGrankAndRank, empNumber, StringUtils.isBlank((CharSequence)stdscmName) ? " " : stdscmName));
                            continue;
                        }
                        if (ObjectUtils.isEmpty((Object)stdTabNotFoundType)) {
                            String frequencyName;
                            DynamicObject stdTable;
                            if ((ObjectUtils.isEmpty((Object)stdTableVid) || stdTableVid <= 0L) && StringUtils.isBlank((CharSequence)frequency)) {
                                handler.putRowError(excelRowIndex, requencyMustInputMsg);
                                continue;
                            }
                            if (StringUtils.isNotEmpty((CharSequence)frequency) && ObjectUtils.isNotEmpty((Object)stdTableDynMap) && !ObjectUtils.isEmpty((Object)(stdTable = (DynamicObject)stdTableDynMap.get(stdTableVid))) && StringUtils.isNotEmpty((CharSequence)(frequencyName = stdTable.getString("frequency.name"))) && !StringUtils.equals((CharSequence)frequencyName, (CharSequence)frequency)) {
                                handler.putRowError(excelRowIndex, String.format(Locale.ROOT, noMatchFrequency, empNumber, frequencyName));
                                continue;
                            }
                            Map gradeRankKeys = sMatchResult.getRangeData();
                            if (MapUtils.isEmpty((Map)gradeRankKeys)) {
                                handler.putRowError(excelRowIndex, String.format(Locale.ROOT, noMatchTable, empNumber));
                                continue;
                            }
                            if (!isGradeRankValidate) continue;
                            if (AdjAttributionType.DECATTRTYPE.getCode().equals(salaryadjrsnType) && SWCStringUtils.equals((String)"1", (String)isMatchGradeRank) && StringUtils.isBlank((CharSequence)excelGrade)) {
                                handler.putRowError(excelRowIndex, gradeMustInputMsg);
                                continue;
                            }
                            if (StringUtils.isBlank((CharSequence)excelGrade)) continue;
                            logger.info("gradeId is:{},rankIds is:{}", (Object)JSON.toJSONString(gradeRankKeys.keySet()), (Object)JSON.toJSONString(gradeRankKeys.values()));
                            String stdTableName = (String)stdTableIdToNameMap.get(stdTableVid);
                            Long gradeMatchObj = AdjBillEntryBizHelper.gradeRankMatch("grade", excelGrade, rankAndGradeNameMaps, gradeRankKeys, null);
                            Map subGRmap = gradeRankMap.computeIfAbsent(excelRowIndex, val -> Maps.newHashMap());
                            subGRmap.put(excelGrade, gradeMatchObj == null ? null : gradeMatchObj);
                            if (gradeMatchObj != null && CollectionUtils.isNotEmpty((Collection)((Collection)gradeRankKeys.get(gradeMatchObj)))) {
                                if (SWCStringUtils.equals((String)"1", (String)isMatchGradeRank) && StringUtils.isBlank((CharSequence)excelRank) && isOpenRank) {
                                    handler.putRowError(excelRowIndex, rankMustInputMsg);
                                    continue;
                                }
                                if (StringUtils.isBlank((CharSequence)excelRank)) continue;
                                Long rankMatchObj = AdjBillEntryBizHelper.gradeRankMatch("rank", excelRank, rankAndGradeNameMaps, gradeRankKeys, gradeMatchObj);
                                String range = AdjBillEntryBizHelper.getGradeRankRange(isOpenRank, gradeRankKeys, (List)gradeEntities.get(stdTableVid), (List)salaryRankEntities.get(stdTableVid));
                                logger.info("open rank range is{}:", (Object)range);
                                if (ObjectUtils.isEmpty((Object)gradeMatchObj) || ObjectUtils.isEmpty((Object)rankMatchObj)) {
                                    handler.putRowError(excelRowIndex, String.format(Locale.ROOT, twoMatchOneMsg, empNumber, structName, stdTableName, range));
                                    continue;
                                }
                                subGRmap.put(excelRank, rankMatchObj == null ? null : rankMatchObj);
                                continue;
                            }
                            if (ObjectUtils.isEmpty((Object)gradeMatchObj)) {
                                String range = AdjBillEntryBizHelper.getGradeRankRange(isOpenRank, gradeRankKeys, (List)gradeEntities.get(stdTableVid), (List)salaryRankEntities.get(stdTableVid));
                                logger.info("not open rank range is{}:", (Object)range);
                                handler.putRowError(excelRowIndex, String.format(Locale.ROOT, twoMatchOneMsg, empNumber, structName, stdTableName, range));
                                continue;
                            }
                            if (!StringUtils.isNotBlank((CharSequence)excelRank)) continue;
                            handler.putRowError(excelRowIndex, String.format(Locale.ROOT, noFindRank, empNumber, stdTableName));
                            continue;
                        }
                        String errorMsg = StdTabNotFoundType.getNameByCode((String)stdTabNotFoundType.getCode());
                        if (StdTabNotFoundType.NOSTDSCM_INBSED.getCode().equals(stdTabNotFoundType.getCode())) {
                            handler.putRowError(excelRowIndex, String.format(Locale.ROOT, noStdscmInbsed, empNumber));
                        }
                        if (StdTabNotFoundType.ITEM_NOTEXIST_INSCM.getCode().equals(stdTabNotFoundType.getCode())) {
                            handler.putRowError(excelRowIndex, String.format(Locale.ROOT, itemNoBelogToStruct, empNumber, structName));
                        }
                        if (StdTabNotFoundType.STD_UNUSEABLE.getCode().equals(stdTabNotFoundType.getCode())) {
                            handler.putRowError(excelRowIndex, String.format(Locale.ROOT, stdTableUnused, empNumber));
                        }
                        if (!StdTabNotFoundType.ITEM_NOTEXIST_INSTD.getCode().equals(stdTabNotFoundType.getCode())) continue;
                        handler.putRowError(excelRowIndex, String.format(Locale.ROOT, itemNoBelogToTable, empNumber));
                    }
                }
            } else {
                logger.info("StdMatchHelper.queryStdMatchResult() match result is empty ");
            }
        }
    }

    private static String getGradeRankRange(boolean isUseRank, Map<Long, List<Long>> gradeRankKeys, List<SalaryGradeEntity> gradeEntities, List<SalaryRankEntity> salaryRankEntities) {
        ArrayList<SalaryGradeEntity> gradeList = new ArrayList<SalaryGradeEntity>(10);
        if (gradeEntities != null && gradeEntities.size() > 0) {
            gradeList.addAll(gradeEntities);
        }
        ArrayList<SalaryRankEntity> rankList = new ArrayList<SalaryRankEntity>(10);
        if (salaryRankEntities != null && salaryRankEntities.size() > 0) {
            rankList.addAll(salaryRankEntities);
        }
        List gradeRankValueList = GradeRankHelper.getRangeCodeByMap(gradeList, rankList, gradeRankKeys);
        Map gradeIndexNameMap = GradeRankHelper.getGradeIndexNameMap(gradeList);
        Map rankIndexNameMap = GradeRankHelper.getRankIndexNameMap(rankList);
        return GradeRankHelper.getRangeNamesByRangeCode((List)gradeRankValueList, (int)rankList.size(), (Map)gradeIndexNameMap, (Map)rankIndexNameMap, (boolean)isUseRank);
    }

    private static Map<String, Map<Long, String>> getGradeAndRankById(Map<Long, Map<Long, SalaryStdMatchResultNew>> resultMap) {
        HashMap<String, Map<Long, String>> gradeAndRankMap = new HashMap<String, Map<Long, String>>(16);
        if (MapUtils.isEmpty(resultMap)) {
            return gradeAndRankMap;
        }
        HashSet gradeIdset = new HashSet(16);
        HashSet rankIdset = new HashSet(16);
        for (Map.Entry<Long, Map<Long, SalaryStdMatchResultNew>> subMap : resultMap.entrySet()) {
            Map<Long, SalaryStdMatchResultNew> entry = subMap.getValue();
            for (Map.Entry<Long, SalaryStdMatchResultNew> ssubMap : entry.entrySet()) {
                Map rangeData = ssubMap.getValue().getRangeData();
                if (!MapUtils.isNotEmpty((Map)rangeData)) continue;
                gradeIdset.addAll(rangeData.keySet());
                if (!CollectionUtils.isNotEmpty(rangeData.values())) continue;
                rangeData.values().forEach(subList -> {
                    if (CollectionUtils.isNotEmpty((Collection)subList)) {
                        rankIdset.addAll(subList.stream().collect(Collectors.toSet()));
                    }
                });
            }
        }
        if (CollectionUtils.isNotEmpty(gradeIdset)) {
            HRBaseServiceHelper gradeHelper = new HRBaseServiceHelper("hcdm_salarygradeentrytodb");
            DynamicObject[] gradDys = gradeHelper.query("id,name,number", new QFilter[]{new QFilter("id", "in", gradeIdset)});
            Map<Long, String> gradIdToNameMap = Arrays.stream(gradDys).filter(obj -> ObjectUtils.isNotEmpty((Object)obj)).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("name"), (dy1, dy2) -> dy1));
            if (MapUtils.isNotEmpty(gradIdToNameMap)) {
                gradeAndRankMap.put("grade", gradIdToNameMap);
            }
        }
        if (CollectionUtils.isNotEmpty(rankIdset)) {
            HRBaseServiceHelper rankHelper = new HRBaseServiceHelper("hcdm_rankgradeentrytodb");
            DynamicObject[] rankDys = rankHelper.query("id,name,number", new QFilter[]{new QFilter("id", "in", rankIdset)});
            Map<Long, String> rankIdToNameMap = Arrays.stream(rankDys).filter(obj -> ObjectUtils.isNotEmpty((Object)obj)).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("name"), (dy1, dy2) -> dy1));
            if (MapUtils.isNotEmpty(rankIdToNameMap)) {
                gradeAndRankMap.put("rank", rankIdToNameMap);
            }
        }
        return gradeAndRankMap;
    }

    private static Long gradeRankMatch(String type, String excelValue, Map<String, Map<Long, String>> rankAndGradeMaps, Map<Long, List<Long>> gradeRankKeys, Long gradeId) {
        Long matchId = null;
        if (MapUtils.isEmpty(rankAndGradeMaps) || MapUtils.isEmpty(rankAndGradeMaps.get(type)) || StringUtils.isBlank((CharSequence)excelValue)) {
            return matchId;
        }
        if ("grade".equals(type)) {
            if (MapUtils.isEmpty(gradeRankKeys) || CollectionUtils.isEmpty(gradeRankKeys.keySet())) {
                return matchId;
            }
            Map<Long, String> gradeMap = rankAndGradeMaps.get(type);
            Set<Long> gradIds = gradeRankKeys.keySet();
            for (Map.Entry<Long, String> subMpa : gradeMap.entrySet()) {
                if (!excelValue.equals(subMpa.getValue()) || !gradIds.contains(subMpa.getKey())) continue;
                matchId = subMpa.getKey();
            }
        }
        if ("rank".equals(type) && MapUtils.isNotEmpty(gradeRankKeys) && CollectionUtils.isNotEmpty(gradeRankKeys.values())) {
            Map<Long, String> rankMap = rankAndGradeMaps.get(type);
            List<Long> rankIds = gradeRankKeys.get(gradeId);
            for (Map.Entry<Long, String> subMpa : rankMap.entrySet()) {
                if (!excelValue.equals(subMpa.getValue()) || !rankIds.contains(subMpa.getKey())) continue;
                matchId = subMpa.getKey();
            }
        }
        return matchId;
    }

    public static Integer getOriExelRowNumber(Map<Integer, String> row) {
        Integer rowIndex = Integer.parseInt(row.get(2199));
        return rowIndex;
    }

    private static Map<Long, Map<Long, Object>> getContrastPropValueMap(List<Long> adjFileIds) {
        Map allContrastConfigMap = ContrastConfigHelper.getAllContrastConfigMap();
        List propConfigEntities = Arrays.stream(personProperty.split("[,]")).map(item -> (ContrastPropConfigEntity)allContrastConfigMap.get(comparaConCfg.get(item))).collect(Collectors.toList());
        AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);
        Map contrastPropValueMap = adjApprovalApplicationService.getContrastPropValue(propConfigEntities, new ArrayList<Long>(adjFileIds), true);
        return contrastPropValueMap;
    }

    private static void countryValidate(String countryId, Map<String, Integer> colKeyIndexMap, List<Map<Integer, String>> dataRow, Map<String, Map<String, List<DynamicObject>>> baseDataMap, AdjBillEntryImpConfig conf) {
        String frequencyMsg = ResManager.loadKDString((String)"\u5de5\u53f7%s\uff1a\u5f53\u524d\u9891\u5ea6\u6240\u5c5e\u56fd\u5bb6/\u5730\u533a\u4e0e\u5458\u5de5\u5b9a\u8c03\u85aa\u7533\u8bf7\u5355\u57fa\u672c\u4fe1\u606f\u4e2d\u56fd\u5bb6/\u5730\u533a\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjBillEntryBizHelper_53", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String adjFileMsg = ResManager.loadKDString((String)"\u5de5\u53f7%s\uff1a\u5f53\u524d\u5458\u5de5\u5b9a\u8c03\u85aa\u6863\u6848\u7ba1\u7406\u5c5e\u5730\u4e0e\u5458\u5de5\u5b9a\u8c03\u85aa\u7533\u8bf7\u5355\u57fa\u672c\u4fe1\u606f\u4e2d\u56fd\u5bb6/\u5730\u533a\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjBillEntryBizHelper_54", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String notExistOrErrorMsg = ResManager.loadKDString((String)"\u9891\u5ea6\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6,\u8bf7\u8c03\u6574\u3002", (String)"AdjBillEntryBizHelper_55", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String keyAdjFile = DecAdjApprCreateGridHelper.buildKey((String)"adjfile");
        Integer adjFileIndex = colKeyIndexMap.get(keyAdjFile);
        String keyFrequency = DecAdjApprCreateGridHelper.buildKey((String)"frequency");
        Integer frequencyIndex = colKeyIndexMap.get(keyFrequency);
        boolean frequencyNeedValidate = frequencyIndex != null;
        String keyNumber = DecAdjApprCreateGridHelper.buildKey((String)"number");
        Integer empNumIndex = colKeyIndexMap.get(keyNumber);
        Map<String, List<DynamicObject>> adjFileDataMap = baseDataMap.get(keyAdjFile);
        Map<Object, Object> nameToFrequencyMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet names = Sets.newHashSetWithExpectedSize((int)16);
        if (frequencyNeedValidate) {
            Object[] frerDyns;
            dataRow.stream().filter(obj -> StringUtils.isNotEmpty((CharSequence)((CharSequence)obj.get(frequencyIndex)))).forEach(obj -> names.add(((String)obj.get(frequencyIndex)).trim()));
            if (CollectionUtils.isNotEmpty((Collection)names) && ArrayUtils.isNotEmpty((Object[])(frerDyns = AdjBillEntryImpHelper.getFrequencyByName((Set)names)))) {
                nameToFrequencyMap = Arrays.stream(frerDyns).collect(Collectors.groupingBy(obj -> obj.getString("name")));
            }
        }
        ProgressHandler handler = conf.getHandler();
        Map<Integer, Map<String, Object>> frequencyDataMap = conf.getFrequencyDataMap();
        for (int i = 0; i < dataRow.size(); ++i) {
            String frequency;
            Map<Integer, String> row = dataRow.get(i);
            Integer errorRowIndex = AdjBillEntryBizHelper.getOriExelRowNumber(row);
            if (handler.getLogCache().containsKey(errorRowIndex)) continue;
            String empNum = row.get(empNumIndex);
            String fileNum = row.get(adjFileIndex);
            DynamicObject fileObj = adjFileDataMap.get(fileNum).get(0);
            if (ObjectUtils.isNotEmpty((Object)fileObj) && ObjectUtils.isNotEmpty((Object)fileObj.get("country")) && !countryId.equals(String.valueOf(fileObj.getLong("country.id")))) {
                handler.putRowError(errorRowIndex, String.format(Locale.ROOT, adjFileMsg, empNum));
                continue;
            }
            if (!frequencyNeedValidate || !StringUtils.isNotBlank((CharSequence)(frequency = row.get(frequencyIndex)))) continue;
            if (nameToFrequencyMap == null) {
                handler.putRowError(errorRowIndex, notExistOrErrorMsg);
                continue;
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)nameToFrequencyMap.get(frequency)))) {
                List dyObjs = (List)nameToFrequencyMap.get(frequency);
                if (AdjBillEntryBizHelper.isMatchFrequency(frequency, countryId, dyObjs, frequencyDataMap.computeIfAbsent(i, val -> Maps.newHashMapWithExpectedSize((int)16)))) continue;
                handler.putRowError(errorRowIndex, String.format(Locale.ROOT, frequencyMsg, empNum));
                continue;
            }
            handler.putRowError(errorRowIndex, notExistOrErrorMsg);
        }
    }

    private static boolean isMatchFrequency(String frequency, String countryId, List<DynamicObject> dyObjs, Map<String, Object> frequencyDataMap) {
        boolean isMatch = false;
        List matchList = dyObjs.stream().filter(obj -> ObjectUtils.isEmpty((Object)obj.get("country")) || ObjectUtils.isNotEmpty((Object)obj.get("country")) && countryId.equals(String.valueOf(obj.getLong("country.id")))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(matchList)) {
            DynamicObject matchObj = matchList.stream().filter(obj -> ObjectUtils.isNotEmpty((Object)obj.get("country")) && countryId.equals(String.valueOf(obj.getLong("country.id")))).findFirst().orElse(null);
            frequencyDataMap.put(frequency, matchObj == null ? matchList.get(0) : matchObj.get("id"));
            isMatch = true;
        }
        return isMatch;
    }

    private static void writeErrorLog(ProgressHandler handler, List<Map<Integer, String>> dataRows) {
        String errorMsg = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7\uff1a\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6,\u8bf7\u8c03\u6574\u3002", (String)"AdjBillEntryImpTask_5", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        for (Map<Integer, String> row : dataRows) {
            Integer rowNumber = AdjBillEntryBizHelper.getOriExelRowNumber(row);
            handler.putRowError(rowNumber, errorMsg);
        }
    }

    public static MainEntityType getAdjPersonEntity() {
        return adjPersonEntity;
    }
}

