/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjapprbill.entryimport;

import java.text.MessageFormat;
import java.util.Date;
import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.swc.hcdm.formplugin.adjapprbill.entryimport.AdjBillEntryImpConfig;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class AdjBillEntryImpProgressPlugin
extends AbstractBasePlugIn
implements ProgresssListener {
    private static Log log = LogFactory.getLog(AdjBillEntryImpProgressPlugin.class);
    private static final String KEY_TOTAL_LABEL = "totallabel";
    private static final String WAIT = "wait";
    private static final String SUCCESS = "success";
    private static final String FAIL = "fail";
    private static final String FAIL_DETAIL_HYPER = "faildetailhyper";
    private static final String KEY_PANEL_FINISH = "panelfinish";
    private static final String PROGRESS_NUM_LABEL = "progressnumlabel";
    private static final String KEY_PROGRESSBARAP = "progressbarap";
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    private static final String KEY_PANEL_HANDLING = "panelhandling";
    private static final String KEY_TIMELABEL = "timelabel";
    private static final String KEY_TASKID = "taskId";
    private static final String KEY_TASK_PROGRESS = "TaskProgress_{0}";
    private static final String KEY_EXCEPTION_MSG = "exceptionmsg";
    private static final String CACHE_KEY_IMPORT_FINISH_MARK = "cache_key_import_finish_mark";

    public void initialize() {
        super.initialize();
        ProgressBar progress = (ProgressBar)this.getControl(KEY_PROGRESSBARAP);
        progress.addProgressListener((ProgresssListener)this);
        Label label = (Label)this.getControl(FAIL_DETAIL_HYPER);
        label.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{FAIL_DETAIL_HYPER, KEY_PANEL_FINISH, BTN_CANCEL, KEY_EXCEPTION_MSG});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        AdjBillEntryImpConfig adjBillEntryImpConfig = this.getTaskProgressInfo("beforeBindData", null);
        this.setFormInfo(adjBillEntryImpConfig, null);
    }

    public void afterBindData(EventObject e) {
        if ("true".equals(this.getView().getFormShowParameter().getCustomParam("isTaskEnd"))) {
            ProgressBar progressBar = (ProgressBar)this.getControl(KEY_PROGRESSBARAP);
            progressBar.setPercent(100);
            AdjBillEntryImpConfig adjBillEntryImpConfig = this.getTaskProgressInfo("afterBindData", null);
            int fail = 0;
            if (adjBillEntryImpConfig != null) {
                fail = adjBillEntryImpConfig.getFailRows();
            }
            this.setStopProgressFormInfo(fail);
            return;
        }
        this.startTask();
    }

    public void onProgress(ProgressEvent progressEvent) {
        Control control = (Control)progressEvent.getSource();
        String progressKey = control.getKey();
        if (SWCStringUtils.equals((String)progressKey, (String)KEY_PROGRESSBARAP)) {
            AdjBillEntryImpConfig adjBillEntryImpConfig = this.getTaskProgressInfo("onProgress", progressEvent);
            this.setFormInfo(adjBillEntryImpConfig, progressEvent);
        }
    }

    public void click(EventObject evt) {
        String itemKey;
        super.click(evt);
        Control itemControl = (Control)evt.getSource();
        switch (itemKey = itemControl.getKey()) {
            case "faildetailhyper": {
                this.downloadErrorLogFile();
                break;
            }
        }
    }

    private void downloadErrorLogFile() {
        AdjBillEntryImpConfig cfg = this.getTaskProgressInfo("downloadErrorLogFile", null);
        if (cfg == null || StringUtils.isBlank((String)cfg.getErrorLogFileUrl())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"AdjImportProcessPlugin_4", (String)"swc-hcdm-business", (Object[])new Object[0]));
            return;
        }
        this.getView().download(UrlService.getAttachmentFullUrl((String)cfg.getErrorLogFileUrl()));
        this.getView().sendFormAction(this.getView());
    }

    public void beforeClosed(BeforeClosedEvent event) {
        this.getView().setReturnData((Object)CACHE_KEY_IMPORT_FINISH_MARK);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        String parentFormId = parentView.getEntityId();
        if ("hcdm_entryimportstart".equals(parentFormId)) {
            parentView.getFormShowParameter().setCustomParam(CACHE_KEY_IMPORT_FINISH_MARK, (Object)"import_progress_page_close");
            parentView.close();
            this.getView().sendFormAction(parentView);
        }
    }

    private void startTask() {
        ProgressBar progressBar = (ProgressBar)this.getControl(KEY_PROGRESSBARAP);
        progressBar.start();
    }

    private AdjBillEntryImpConfig getTaskProgressInfo(String event, ProgressEvent progressEvent) {
        String taskId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_TASKID);
        ISWCAppCache appCache = SWCAppCache.get((String)"hcdm");
        String cfgJson = (String)appCache.get(MessageFormat.format(KEY_TASK_PROGRESS, taskId), String.class);
        AdjBillEntryImpConfig cfg = null;
        if (cfgJson != null) {
            cfg = (AdjBillEntryImpConfig)SerializationUtils.deSerializeFromBase64((String)cfgJson);
        }
        return cfg;
    }

    private void stopProgress(int fail, ProgressEvent progressEvent) {
        this.setStopProgressFormInfo(fail);
        ProgressBar bar = (ProgressBar)progressEvent.getSource();
        bar.stop();
    }

    private void setStopProgressFormInfo(int fail) {
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_OK, KEY_PANEL_HANDLING});
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CANCEL, KEY_PANEL_FINISH});
        if (fail > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FAIL_DETAIL_HYPER});
        }
    }

    private void setFormInfo(AdjBillEntryImpConfig cfg, ProgressEvent progressEvent) {
        int total = 0;
        int success = 0;
        int fail = 0;
        int deal = 0;
        int wait = 0;
        Date startTime = new Date();
        Date endTime = new Date();
        int percentage = 0;
        if (cfg != null) {
            total = cfg.getTotalRows();
            fail = cfg.getFailRows();
            deal = cfg.getDealRows();
            success = cfg.getSuccessRows();
            wait = cfg.getWaitRows();
            startTime = cfg.getStartTime();
            endTime = cfg.getEndTime();
            percentage = cfg.getProgress();
            if (ObjectUtils.isNotEmpty((Object)endTime)) {
                percentage = 100;
            }
        }
        log.info("total is{0},fail is{1},deal is{2},wait is{3}", new Object[]{total, fail, deal, wait});
        fail = this.setFailNum(percentage, success, fail, total);
        Label labelWelfarePayer = (Label)this.getControl(KEY_TOTAL_LABEL);
        labelWelfarePayer.setText(String.valueOf(total));
        Label labelWait = (Label)this.getView().getControl(WAIT);
        labelWait.setText(String.valueOf(wait));
        Label labelSuccess = (Label)this.getView().getControl(SUCCESS);
        labelSuccess.setText(String.valueOf(success));
        Label labelFail = (Label)this.getView().getControl(FAIL);
        labelFail.setText(String.valueOf(fail));
        Label labelTime = (Label)this.getView().getControl(KEY_TIMELABEL);
        startTime = startTime == null ? new Date() : startTime;
        endTime = endTime == null ? new Date() : endTime;
        String consumeTime = SWCDateTimeUtils.getConsumeTime((Date)startTime, (Date)endTime);
        String msg = MessageFormat.format(ResManager.loadKDString((String)"\u5df2\u8017\u65f6{0}", (String)"AdjBillEntryImpProgressPlugin_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), consumeTime);
        labelTime.setText(msg);
        Label labelPercentage = (Label)this.getView().getControl(PROGRESS_NUM_LABEL);
        if ("true".equals(this.getView().getFormShowParameter().getCustomParam("isTaskEnd"))) {
            labelPercentage.setText("100");
            if (cfg != null) {
                this.setExceptionMsg(cfg);
                this.updateEntryView(cfg);
            }
            return;
        }
        labelPercentage.setText(String.valueOf(percentage));
        if (percentage >= 100 && progressEvent != null) {
            this.stopProgress(fail, progressEvent);
            if (cfg != null) {
                this.setExceptionMsg(cfg);
                this.updateEntryView(cfg);
            }
        }
        if (progressEvent != null) {
            progressEvent.setProgress(percentage);
        }
    }

    private int setFailNum(int percentage, int success, int fail, int total) {
        if (percentage >= 100 && success <= 0 && fail <= 0) {
            return total;
        }
        return fail;
    }

    private void setExceptionMsg(AdjBillEntryImpConfig cfg) {
        String excMsg = cfg.getKdBizExceptionMsg();
        if (StringUtils.isNotBlank((String)excMsg)) {
            Label exceptionLabel = (Label)this.getView().getControl(KEY_EXCEPTION_MSG);
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_EXCEPTION_MSG});
            exceptionLabel.setText(excMsg);
        }
    }

    private void updateEntryView(AdjBillEntryImpConfig conf) {
        this.getView().getPageCache().put(CACHE_KEY_IMPORT_FINISH_MARK, "true");
    }
}

