/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjapprbill.entryimport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.FileNameUtils;
import kd.hr.hbp.business.bgtask.CommonBizTask;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hcdm.business.extpoint.adjapprbill.DefaultDecAdjApprSupportPlugin;
import kd.sdk.swc.hcdm.business.extpoint.adjapprbill.IDecAdjApprExtPlugin;
import kd.sdk.swc.hcdm.business.extpoint.adjapprbill.event.ImportValidateEvent;
import kd.sdk.swc.hcdm.business.extpoint.adjapprbill.event.ImportWriteEntryEvent;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprGridHelper;
import kd.swc.hcdm.business.imports.perm.AdjFilePermissionHandler;
import kd.swc.hcdm.formplugin.adjapprbill.entryimport.AdjBillEntryBizHelper;
import kd.swc.hcdm.formplugin.adjapprbill.entryimport.AdjBillEntryImpConfig;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.formplugin.imports.ProgressHandler;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class AdjBillEntryImpTask
extends CommonBizTask {
    private static Log log = LogFactory.getLog(AdjBillEntryImpTask.class);
    protected static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"SWC_HCDM_AdjBillEntryImpTask", (int)1);
    private static final String KEY_TASK_PROGRESS = "TaskProgress_{0}";
    private static String SAVE_DRAFT = "savedraft";
    private HRPluginProxy<IDecAdjApprExtPlugin> importValidateProxy = HRPlugInProxyFactory.create((Object)new DefaultDecAdjApprSupportPlugin(), IDecAdjApprExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.adjapprbill.IDecAdjApprExtPlugin#onImportValidate", null);
    private HRPluginProxy<IDecAdjApprExtPlugin> importWriteEntryProxy = HRPlugInProxyFactory.create((Object)new DefaultDecAdjApprSupportPlugin(), IDecAdjApprExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.adjapprbill.IDecAdjApprExtPlugin#onImportWriteEntry", null);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        AdjBillEntryImpConfig conf = new AdjBillEntryImpConfig(map);
        conf.setStartTime(new Date());
        int uploadTotalNum = 1;
        if (ObjectUtils.isNotEmpty((Object)map.get("uploadTotalNum"))) {
            uploadTotalNum = Integer.parseInt((String)map.get("uploadTotalNum"));
        }
        log.info("uploadTotalNum is:{}", (Object)uploadTotalNum);
        conf.setTotalRows(uploadTotalNum);
        Object[] filePermFilter = this.getAdjFilePermissionFilter();
        if (ArrayUtils.isNotEmpty((Object[])filePermFilter)) {
            conf.setAdjFilePermissionFilter((QFilter[])filePermFilter);
        }
        this.setProgress(conf, false);
        this.asyncHandleData(conf);
        Object billid = conf.getParam().get("billid");
        if (ObjectUtils.isNotEmpty((Object)billid)) {
            log.info("AdjBillEntryBizHelper.beforeSetAdjBillTotalPersonNum...");
            DecAdjApprGridHelper.setAdjBillTotalPersonNum((Long)Long.parseLong((String)billid));
            log.info("AdjBillEntryBizHelper.afterSetAdjBillTotalPersonNum...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncHandleData(AdjBillEntryImpConfig conf) {
        RequestContext ctx = RequestContext.getOrCreate();
        threadPool.execute(() -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            AdjBillEntryBizHelper.asyncResolveExcel(conf);
        });
        try {
            int timeout = 0;
            LinkedBlockingQueue<Map<Integer, String>> dataQueue = conf.getDataQueues();
            while (!(conf.isResolveEnd() && dataQueue.isEmpty() || timeout > 5)) {
                ArrayList<Map<Integer, String>> rowdatas = new ArrayList<Map<Integer, String>>(1000);
                if (dataQueue.size() <= 0) {
                    log.info("...read...null");
                    ++timeout;
                    this.sleep(2);
                    continue;
                }
                timeout = 0;
                dataQueue.drainTo(rowdatas, 1000);
                log.info("AdjBillEntryBizHelper.beforeHandleData...");
                this.handleData(conf, rowdatas);
                log.info("AdjBillEntryBizHelper.afterHandleData...");
                conf.setDealRows(conf.getDealRows() + rowdatas.size());
                conf.setFailRows(conf.getHandler().getLogCache().size());
                conf.setSuccessRows(conf.getDealRows() - conf.getFailRows());
                conf.setWaitRows(conf.getTotalRows() - conf.getDealRows());
                conf.getFrequencyDataMap().clear();
                conf.getEntryPkValueToExcelRowIndex().clear();
                conf.getStdTableDynMap().clear();
                log.info("AdjBillEntryBizHelper.beforeSetProgress...");
                this.setProgress(conf, false);
                log.info("AdjBillEntryBizHelper.afterSetProgress...");
            }
            log.info("AdjBillEntryBizHelper.beforeSetWriteLog...");
            this.writeLog(conf);
            log.info("AdjBillEntryBizHelper.afterSetWriteLog...");
            conf.setFailRows(conf.getHandler().getLogCache().size());
            conf.setDealRows(conf.getTotalRows() - conf.getFailRows());
        }
        catch (Exception ex) {
            log.error("AdjBillEntryImpTask.asyncHandleData error:", (Throwable)ex);
            conf.setKdBizExceptionMsg(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25,\u8be6\u60c5\u770b\u65e5\u5fd7\u4fe1\u606f,\u8bf7\u91cd\u8bd5\u6216\u8005\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"AdjBillEntryImpTask_8", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
        }
        finally {
            log.info("AdjBillEntryBizHelper.finallyBeforeSetProgress...");
            this.setProgress(conf, true);
            log.info("AdjBillEntryBizHelper.finallyAfterSetProgress...");
        }
    }

    private void handleData(AdjBillEntryImpConfig conf, List<Map<Integer, String>> handlerDataRows) {
        long startTime = System.currentTimeMillis();
        Map<Integer, String> colIdToFileMap = conf.getDataHead().get(0);
        LinkedHashMap<String, Integer> colKeyIndexMap = new LinkedHashMap<String, Integer>();
        colIdToFileMap.forEach((key, value) -> colKeyIndexMap.put((String)value, (Integer)key));
        String salaryadjrsnType = (String)conf.getParam().get("salaryadjrsnType");
        String property = String.valueOf(conf.getParam().get("property"));
        DataEntityPropertyCollection propertyCollection = (DataEntityPropertyCollection)SerializationUtils.deSerializeFromBase64((String)property);
        AdjBillEntryBizHelper.validateBizData(salaryadjrsnType, conf, handlerDataRows, colKeyIndexMap, propertyCollection);
        log.info("AdjBillEntryBizHelper.validateBizData use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        this.invalidateSectionPoint(salaryadjrsnType, conf, handlerDataRows, colKeyIndexMap);
        log.info("AdjBillEntryBizHelper.invalidateSectionPoint use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        List<DynamicObject> newAdjPersonList = AdjBillEntryBizHelper.convertData(conf, handlerDataRows, propertyCollection);
        log.info("AdjBillEntryBizHelper.convertData use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        this.modifySectionPoint(salaryadjrsnType, conf, newAdjPersonList);
        log.info("AdjBillEntryBizHelper.modifySectionPoint use time:{}", (Object)(System.currentTimeMillis() - startTime));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(newAdjPersonList)) {
            startTime = System.currentTimeMillis();
            this.invokeOperate(SAVE_DRAFT, conf, newAdjPersonList);
            log.info("invokeOperate use time:{}", (Object)(System.currentTimeMillis() - startTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeOperate(String operationKey, AdjBillEntryImpConfig conf, List<DynamicObject> list) {
        try (TXHandle tx = TX.requiresNew();){
            OperationServiceImpl opImpl = new OperationServiceImpl();
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("invokeType", "excelImport");
            option.setVariableValue("dyncolname", SerializationUtils.serializeToBase64(this.getDynObjColPropName(conf)));
            long startTime = System.currentTimeMillis();
            OperationResult empResult = opImpl.localInvokeOperation(operationKey, list.toArray(new DynamicObject[0]), option);
            log.info("invoke AdjBillEntryImpTask.invokeOperate use time:{}", (Object)(System.currentTimeMillis() - startTime));
            if (!empResult.isSuccess()) {
                List allErrorOrValidateInfo = empResult.getAllErrorOrValidateInfo();
                if (!empResult.isSuccess()) {
                    StringBuilder msgSb = new StringBuilder();
                    msgSb.append(empResult.getMessage());
                    if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
                        allErrorOrValidateInfo.forEach(obj -> {
                            log.info("AdjBillEntryImpTask.invokeOperate error message:{},pkvalue:{} ", (Object)obj.getMessage(), obj.getPkValue());
                            msgSb.append(obj.getMessage());
                        });
                    }
                    log.info("AdjBillEntryImpTask.invokeOperate validator error: {}", (Object)msgSb.toString());
                }
                this.writeLogToHandler(conf, allErrorOrValidateInfo, null);
            }
        }
    }

    private void setProgress(AdjBillEntryImpConfig conf, boolean isEnd) {
        int progress = conf.getProgress();
        if (progress >= 100 && !isEnd) {
            progress = 99;
        }
        this.feedbackProgress(progress);
        HRBackgroundTaskHelper.getInstance().feedbackProgress(this.taskId, progress, "", conf.getParam());
        if (progress >= 100 || isEnd) {
            conf.setEndTime(new Date());
            HRBackgroundTaskHelper.getInstance().feedbackStatus(this.taskId, "COMPLETED", "", conf.getParam());
        }
        AdjBillEntryImpConfig confCache = new AdjBillEntryImpConfig();
        confCache.setTotalRows(conf.getTotalRows());
        confCache.setFailRows(conf.getFailRows());
        confCache.setDealRows(conf.getDealRows());
        confCache.setSuccessRows(conf.getSuccessRows());
        confCache.setWaitRows(conf.getWaitRows());
        confCache.setStartTime(conf.getStartTime());
        confCache.setEndTime(conf.getEndTime());
        confCache.setErrorLogFileUrl(conf.getErrorLogFileUrl());
        confCache.setKdBizExceptionMsg(conf.getKdBizExceptionMsg());
        log.info("taskId is:{},conf.getTotalRows is:{},conf.getFailRows is:{},conf.getDealRows is:{}", new Object[]{this.taskId, conf.getTotalRows(), conf.getFailRows(), conf.getDealRows()});
        ISWCAppCache appCache = SWCAppCache.get((String)"hcdm");
        appCache.put(MessageFormat.format(KEY_TASK_PROGRESS, this.taskId), (Object)SerializationUtils.serializeToBase64((Object)confCache));
    }

    private void writeLogToHandler(AdjBillEntryImpConfig conf, List<IOperateInfo> errorMsg, List<DynamicObject> adjPersonList) {
        Map<Long, Integer> entryPkValueToExcelRowIndexMap = conf.getEntryPkValueToExcelRowIndex();
        ProgressHandler handler = conf.getHandler();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(errorMsg)) {
            for (IOperateInfo obj2 : errorMsg) {
                String msg = obj2.getMessage();
                Object pkValue = obj2.getPkValue();
                log.info("AdjBillEntryImpTask.writeLogToHandler error message:{},pkvalue:{} ", (Object)obj2.getMessage(), obj2.getPkValue());
                Integer rowIndex = entryPkValueToExcelRowIndexMap.get(pkValue);
                if (rowIndex == null) continue;
                handler.putRowError(rowIndex, msg);
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(adjPersonList)) {
            ArrayList entryData = new ArrayList(adjPersonList.size());
            adjPersonList.stream().forEach(obj -> {
                DynamicObjectCollection personEntryCollect = obj.getDynamicObjectCollection("entryentity");
                entryData.addAll(personEntryCollect);
            });
            for (DynamicObject entryObj : entryData) {
                Integer rowIndex = entryPkValueToExcelRowIndexMap.get(entryObj.getLong("id"));
                if (rowIndex == null) continue;
                handler.putRowError(rowIndex, ResManager.loadKDString((String)"\u4fdd\u5b58\u6570\u636e\u9519\u8bef,\u8bf7\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AdjBillEntryImpTask_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private Set<String> getDynObjColPropName(AdjBillEntryImpConfig conf) {
        String property = String.valueOf(conf.getParam().get("property"));
        DataEntityPropertyCollection propertyCollection = (DataEntityPropertyCollection)SerializationUtils.deSerializeFromBase64((String)property);
        HashSet<String> colName = new HashSet<String>(propertyCollection.size());
        propertyCollection.stream().filter(obj -> ObjectUtils.isNotEmpty((Object)obj)).forEach(obj -> {
            if (obj.getName().startsWith("dy_")) {
                colName.add(obj.getName().substring(3, obj.getName().length()));
            }
        });
        return colName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLog(AdjBillEntryImpConfig conf) {
        Map logCache = conf.getHandler().getLogCache();
        if (logCache.isEmpty()) {
            return;
        }
        Map<String, Object> paramMap = conf.getParam();
        OutputStream out = null;
        FileItem fileItem = null;
        FileInputStream fileInputStream = null;
        try {
            FileService service = FileServiceFactory.getAttachmentFileService();
            String url = String.valueOf(paramMap.get("url"));
            XSSFWorkbook workbook = new XSSFWorkbook(service.getInputStream(url));
            XSSFSheet sheet = workbook.getSheetAt(0);
            int fieldEndRowNum = (Integer)paramMap.get("fixHeadHeight") - 1;
            XSSFRow fieldRow = sheet.getRow(fieldEndRowNum);
            short lastCellNum = fieldRow.getLastCellNum();
            Iterator rowIt = sheet.rowIterator();
            CellStyle cellStyle = this.getWarnTextStyle(workbook);
            String error = ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"AdjBillEntryImpTask_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            while (rowIt.hasNext()) {
                List logs;
                Row row = (Row)rowIt.next();
                Cell cell = row.createCell((int)lastCellNum);
                int rowNum = row.getRowNum();
                if (rowNum == fieldEndRowNum - 1 || rowNum == fieldEndRowNum) {
                    cell.setCellStyle((CellStyle)this.setBorderStyle(workbook));
                    cell.setCellValue(error);
                }
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(logs = (List)logCache.get(rowNum)))) continue;
                cell.setCellStyle(cellStyle);
                cell.setCellValue(StringUtils.join((Object[])logs.toArray(), (String)";"));
            }
            sheet.addMergedRegion(new CellRangeAddress(fieldEndRowNum - 1, fieldEndRowNum, (int)lastCellNum, (int)lastCellNum));
            File temp = File.createTempFile(UUID.randomUUID().toString(), ".xlsx");
            out = new FileOutputStream(temp);
            out.flush();
            workbook.write(out);
            String tplStr = ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f_", (String)"AdjBillEntryImpTask_2", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            String failStr = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25_", (String)"AdjBillEntryImpTask_7", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            String fileBaseName = FilenameUtils.getBaseName((String)url);
            fileBaseName = fileBaseName.replace(tplStr, "");
            fileBaseName = fileBaseName.replace(failStr, "");
            String fileName = failStr + fileBaseName + ".xlsx";
            RequestContext ctx = RequestContext.getOrCreate();
            String path = FileNameUtils.getExportFileName((String)ctx.getTenantId(), (String)ctx.getAccountId(), (String)"hcdm", (String)("import" + UUID.randomUUID().toString()), (String)fileName);
            fileInputStream = new FileInputStream(temp);
            fileItem = new FileItem(FilenameUtils.getName((String)fileName), path, (InputStream)fileInputStream);
            String uploadFileUrl = service.upload(fileItem);
            conf.setErrorLogFileUrl(uploadFileUrl);
            conf.getParam().put("errorLogFileUrl", uploadFileUrl);
        }
        catch (Exception ex) {
            log.error("AdjBillEntryImpTask.writeLog error:", (Throwable)ex);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException ex) {
                log.error(ex.getMessage());
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                log.error(ex.getMessage());
            }
            try {
                if (fileItem != null) {
                    fileItem.close();
                }
            }
            catch (Exception ex) {
                log.error(ex.getMessage());
            }
        }
    }

    private XSSFCellStyle setBorderStyle(XSSFWorkbook workbook) {
        XSSFCellStyle style = workbook.createCellStyle();
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return style;
    }

    private CellStyle getWarnTextStyle(XSSFWorkbook workbook) {
        XSSFFont font = workbook.createFont();
        font.setColor((short)10);
        XSSFCellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setFont((Font)font);
        return cellStyle;
    }

    private void sleep(int seconds) {
        try {
            Thread.sleep((long)seconds * 1000L);
        }
        catch (InterruptedException e) {
            log.error((Throwable)e);
        }
    }

    private void invalidateSectionPoint(String salaryadjrsnType, AdjBillEntryImpConfig conf, List<Map<Integer, String>> handlerDataRows, Map<String, Integer> colKeyIndexMap) {
        ImportValidateEvent event = new ImportValidateEvent((Object)this);
        event.setAdjAttributionType(salaryadjrsnType);
        event.setColIdMap(colKeyIndexMap);
        event.setDataRows(handlerDataRows);
        event.setBaseDataMap(conf.getBaseDataMap());
        event.setGradeRankMap(conf.getGradeRankMap());
        event.setMatchResult(null);
        this.importValidateProxy.callAfter(plugin -> {
            plugin.onImportValidate(event);
            return null;
        });
        ProgressHandler handler = conf.getHandler();
        if (MapUtils.isNotEmpty((Map)event.getErrorMsg())) {
            for (Map.Entry entry : event.getErrorMsg().entrySet()) {
                for (String msg : (List)entry.getValue()) {
                    handler.putRowError((Integer)entry.getKey(), msg);
                }
            }
        }
    }

    private void modifySectionPoint(String salaryadjrsnType, AdjBillEntryImpConfig conf, List<DynamicObject> newAdjPersonList) {
        ImportWriteEntryEvent event = new ImportWriteEntryEvent((Object)this);
        event.setAdjAttributionType(salaryadjrsnType);
        event.setApprPersonEntityType((DynamicObjectType)AdjBillEntryBizHelper.getAdjPersonEntity());
        event.setDataList(newAdjPersonList);
        event.setMatchResult(conf.getStdTableMatchResult());
        event.setRowUpdate(true);
        this.importWriteEntryProxy.callAfter(plugin -> {
            plugin.onImportWriteEntry(event);
            return null;
        });
    }

    private QFilter[] getAdjFilePermissionFilter() {
        return new AdjFilePermissionHandler().getPermissionFilter();
    }
}

